/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.task;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.execution.SUnreleasableTaskException;
import org.bonitasoft.engine.execution.StateBehaviors;

public final class AssignOrUnassignUserTask
implements TransactionContent {
    private final long userId;
    private final long userTaskId;
    private final ActivityInstanceService activityInstanceService;
    private final StateBehaviors stateBehaviors;

    public AssignOrUnassignUserTask(long userId, long userTaskId, ActivityInstanceService activityInstanceService, StateBehaviors stateBehaviors) {
        this.userId = userId;
        this.userTaskId = userTaskId;
        this.activityInstanceService = activityInstanceService;
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    public void execute() throws SBonitaException {
        SActivityInstance activityInstance = this.activityInstanceService.getActivityInstance(this.userTaskId);
        if (this.userId == 0L && SFlowNodeType.MANUAL_TASK.equals((Object)activityInstance.getType())) {
            throw new SUnreleasableTaskException("The activity with id " + activityInstance.getId() + " can't be assigned because it is a manual sub task");
        }
        this.activityInstanceService.assignHumanTask(this.userTaskId, this.userId);
        if (this.userId > 0L) {
            this.stateBehaviors.addAssignmentSystemComment(activityInstance, this.userId);
        }
    }
}

