/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.model.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.api.impl.transaction.activity.CreateActivityInstance;
import org.bonitasoft.engine.api.impl.transaction.actor.GetActor;
import org.bonitasoft.engine.api.impl.transaction.connector.CreateConnectorInstances;
import org.bonitasoft.engine.api.impl.transaction.event.CreateEventInstance;
import org.bonitasoft.engine.api.impl.transaction.flownode.CreateGatewayInstance;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.data.instance.TransientDataService;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.SOperatorType;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SHumanTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SMultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SStandardLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateThrowEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SStartEventDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.GatewayInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SManualTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.STaskPriority;
import org.bonitasoft.engine.core.process.instance.model.builder.SActivityInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SAutomaticTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SAutomaticTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SCallActivityInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SCallActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SConnectorInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SGatewayInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SGatewayInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SHumanTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SLoopActivityInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SLoopActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SManualTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SManualTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SMultiInstanceActivityInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SMultiInstanceActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SReceiveTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SReceiveTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SSendTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SSendTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SSubProcessActivityInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SSubProcessActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SBoundaryEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SBoundaryEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SEndEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SEndEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateCatchEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateCatchEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateThrowEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SIntermediateThrowEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SStartEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SStartEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.api.ParentContainerResolver;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceReadException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.model.exceptions.SDataInstanceNotWellFormedException;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.LogMessageBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.PersistentObject;

public class BPMInstancesCreator {
    private final ActivityInstanceService activityInstanceService;
    private final ActorMappingService actorMappingService;
    private final GatewayInstanceService gatewayInstanceService;
    private final EventInstanceService eventInstanceService;
    private final ConnectorInstanceService connectorInstanceService;
    private Map<SFlowNodeType, Integer> firstStateIds;
    private Map<SFlowNodeType, String> firstStateNames;
    private final ExpressionResolverService expressionResolverService;
    private final DataInstanceService dataInstanceService;
    private final TransientDataService transientDataService;
    private final TechnicalLoggerService logger;
    private final ParentContainerResolver parentContainerResolver;

    public BPMInstancesCreator(ActivityInstanceService activityInstanceService, ActorMappingService actorMappingService, GatewayInstanceService gatewayInstanceService, EventInstanceService eventInstanceService, ConnectorInstanceService connectorInstanceService, ExpressionResolverService expressionResolverService, DataInstanceService dataInstanceService, TechnicalLoggerService logger, TransientDataService transientDataService, ParentContainerResolver parentContainerResolver) {
        this.activityInstanceService = activityInstanceService;
        this.actorMappingService = actorMappingService;
        this.gatewayInstanceService = gatewayInstanceService;
        this.eventInstanceService = eventInstanceService;
        this.connectorInstanceService = connectorInstanceService;
        this.expressionResolverService = expressionResolverService;
        this.dataInstanceService = dataInstanceService;
        this.logger = logger;
        this.transientDataService = transientDataService;
        this.parentContainerResolver = parentContainerResolver;
    }

    public List<SFlowNodeInstance> createFlowNodeInstances(Long processDefinitionId, long rootContainerId, long parentContainerId, List<SFlowNodeDefinition> flowNodeDefinitions, long rootProcessInstanceId, long parentProcessInstanceId, SStateCategory stateCategory) throws SBonitaException {
        ArrayList<SFlowNodeInstance> flownNodeInstances = new ArrayList<SFlowNodeInstance>(flowNodeDefinitions.size());
        for (SFlowNodeDefinition sFlowNodeDefinition : flowNodeDefinitions) {
            flownNodeInstances.add(this.createFlowNodeInstance(processDefinitionId, rootContainerId, parentContainerId, SFlowElementsContainerType.PROCESS, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, false, -1, stateCategory, -1L));
        }
        return flownNodeInstances;
    }

    public SFlowNodeInstance createFlowNodeInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId, boolean createInnerActivity, int loopCounter, SStateCategory stateCategory, long relatedActivityInstanceId) throws SBonitaException {
        SFlowNodeInstance flownNodeInstance = this.toFlowNodeInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, createInnerActivity, loopCounter, stateCategory, relatedActivityInstanceId);
        if (SFlowNodeType.GATEWAY.equals((Object)flownNodeInstance.getType())) {
            new CreateGatewayInstance((SGatewayInstance)flownNodeInstance, this.gatewayInstanceService).call();
        } else if (flownNodeInstance instanceof SActivityInstance) {
            new CreateActivityInstance((SActivityInstance)flownNodeInstance, this.activityInstanceService).call();
        } else {
            new CreateEventInstance((SEventInstance)flownNodeInstance, this.eventInstanceService).call();
        }
        this.createConnectorInstances(flownNodeInstance, sFlowNodeDefinition.getConnectors(), "flowNode");
        return flownNodeInstance;
    }

    public SFlowNodeInstance toFlowNodeInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId, boolean createInnerActivity, int loopCounter, SStateCategory stateCategory, long relatedActivityInstanceId) throws SActorNotFoundException, SActivityReadException {
        SFlowNodeInstanceBuilder builder;
        SActivityDefinition activityDefinition;
        SLoopCharacteristics loopCharacteristics;
        if (!createInnerActivity && sFlowNodeDefinition instanceof SActivityDefinition && (loopCharacteristics = (activityDefinition = (SActivityDefinition)sFlowNodeDefinition).getLoopCharacteristics()) != null) {
            SActivityInstanceBuilder builder2 = loopCharacteristics instanceof SStandardLoopCharacteristics ? this.createLoopActivityInstance(processDefinitionId, rootContainerId, parentContainerId, rootProcessInstanceId, parentProcessInstanceId, activityDefinition) : this.createMultiInstanceActivityInstance(processDefinitionId, rootContainerId, parentContainerId, rootProcessInstanceId, parentProcessInstanceId, activityDefinition, (SMultiInstanceLoopCharacteristics)loopCharacteristics);
            builder2.setState(this.firstStateIds.get((Object)builder2.getFlowNodeType()), false, false, this.firstStateNames.get((Object)builder2.getFlowNodeType()));
            builder2.setStateCategory(stateCategory);
            return builder2.done();
        }
        switch (sFlowNodeDefinition.getType()) {
            case AUTOMATIC_TASK: {
                builder = this.createAutomaticTaskInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, parentProcessInstanceId);
                break;
            }
            case END_EVENT: {
                builder = this.createEndEventInstance(processDefinitionId, rootContainerId, parentContainerId, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case GATEWAY: {
                builder = this.createGatewayInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case INTERMEDIATE_CATCH_EVENT: {
                builder = this.createIntermediateCatchEventInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case INTERMEDIATE_THROW_EVENT: {
                builder = this.createIntermediateThrowEventInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case MANUAL_TASK: {
                builder = this.createManualTaskInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case START_EVENT: {
                builder = this.createStartEventInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case USER_TASK: {
                builder = this.createUserTaskInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case RECEIVE_TASK: {
                builder = this.createReceiveTaskInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, parentProcessInstanceId);
                break;
            }
            case SEND_TASK: {
                builder = this.createSendTaskInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, parentProcessInstanceId);
                break;
            }
            case CALL_ACTIVITY: {
                builder = this.createCallActivityInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case SUB_PROCESS: {
                builder = this.createSubProcessActivityInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
                break;
            }
            case BOUNDARY_EVENT: {
                builder = this.createBoundaryEventInstance(processDefinitionId, rootContainerId, parentContainerId, parentContainerType, (SBoundaryEventDefinition)sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId, relatedActivityInstanceId);
                break;
            }
            default: {
                throw new SActivityReadException("Activity type not found : " + (Object)((Object)sFlowNodeDefinition.getType()));
            }
        }
        builder.setLoopCounter(loopCounter);
        builder.setState(this.firstStateIds.get((Object)builder.getFlowNodeType()), false, false, this.firstStateNames.get((Object)builder.getFlowNodeType()));
        builder.setStateCategory(stateCategory);
        return builder.done();
    }

    private SCallActivityInstanceBuilder createCallActivityInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) {
        SCallActivityDefinition callActivityDef = (SCallActivityDefinition)sFlowNodeDefinition;
        SCallActivityInstanceBuilderFactory builderFact = BuilderFactory.get(SCallActivityInstanceBuilderFactory.class);
        SCallActivityInstanceBuilder builder = builderFact.createNewCallActivityInstance(callActivityDef.getName(), callActivityDef.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        this.updateActivityInstance(parentContainerId, parentContainerType, sFlowNodeDefinition, builder);
        return builder;
    }

    private SSubProcessActivityInstanceBuilder createSubProcessActivityInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) {
        SSubProcessDefinition subProcessActivityDef = (SSubProcessDefinition)sFlowNodeDefinition;
        SSubProcessActivityInstanceBuilderFactory builderFact = BuilderFactory.get(SSubProcessActivityInstanceBuilderFactory.class);
        SSubProcessActivityInstanceBuilder builder = builderFact.createNewSubProcessActivityInstance(subProcessActivityDef.getName(), subProcessActivityDef.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId, subProcessActivityDef.isTriggeredByEvent());
        this.updateActivityInstance(parentContainerId, parentContainerType, sFlowNodeDefinition, builder);
        return builder;
    }

    private SHumanTaskInstanceBuilder createUserTaskInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) throws SActorNotFoundException {
        SHumanTaskInstanceBuilder builder = this.createHumanTaskInstance(processDefinitionId, rootContainerId, parentContainerId, sFlowNodeDefinition, rootProcessInstanceId, parentProcessInstanceId);
        this.updateActivityInstance(parentContainerId, parentContainerType, sFlowNodeDefinition, builder);
        return builder;
    }

    private SStartEventInstanceBuilder createStartEventInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) {
        SStartEventDefinition startEventDef = (SStartEventDefinition)sFlowNodeDefinition;
        SStartEventInstanceBuilder builder = BuilderFactory.get(SStartEventInstanceBuilderFactory.class).createNewStartEventInstance(startEventDef.getName(), startEventDef.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        this.updateFlowNodeInstance(parentContainerId, parentContainerType, builder);
        return builder;
    }

    private SHumanTaskInstanceBuilder createManualTaskInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) throws SActorNotFoundException {
        SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)sFlowNodeDefinition;
        String actorName = humanTaskDefinition.getActorName();
        SActor actor = this.getActor(processDefinitionId, actorName);
        SManualTaskInstanceBuilder builder = BuilderFactory.get(SManualTaskInstanceBuilderFactory.class).createNewManualTaskInstance(humanTaskDefinition.getName(), humanTaskDefinition.getId(), rootContainerId, parentContainerId, actor.getId(), processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        this.fillHumanTask(humanTaskDefinition, builder);
        this.updateActivityInstance(parentContainerId, parentContainerType, sFlowNodeDefinition, builder);
        return builder;
    }

    public SManualTaskInstance createManualTaskInstance(long parentUserTaskId, String name, long flowNodeDefinitionId, String displayName, long userId, String description, long dueDate, STaskPriority priority) throws SFlowNodeNotFoundException, SFlowNodeReadException {
        SHumanTaskInstance parentUserTask = (SHumanTaskInstance)this.activityInstanceService.getFlowNodeInstance(parentUserTaskId);
        SManualTaskInstanceBuilderFactory manualTaskInstanceBuilderFact = BuilderFactory.get(SManualTaskInstanceBuilderFactory.class);
        long processDefinitionId = parentUserTask.getLogicalGroup(manualTaskInstanceBuilderFact.getProcessDefinitionIndex());
        long rootProcessInstanceId = parentUserTask.getLogicalGroup(manualTaskInstanceBuilderFact.getRootProcessInstanceIndex());
        long parentProcessInstanceId = parentUserTask.getLogicalGroup(manualTaskInstanceBuilderFact.getParentProcessInstanceIndex());
        SManualTaskInstanceBuilder builder = manualTaskInstanceBuilderFact.createNewManualTaskInstance(name, flowNodeDefinitionId, parentUserTask.getRootContainerId(), parentUserTaskId, parentUserTask.getActorId(), processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        builder.setParentContainerId(parentUserTaskId);
        builder.setParentActivityInstanceId(parentUserTaskId);
        builder.setAssigneeId(userId);
        builder.setExpectedEndDate(dueDate);
        builder.setDescription(description);
        builder.setDisplayDescription(description);
        builder.setDisplayName(displayName);
        builder.setPriority(priority);
        builder.setState(this.firstStateIds.get((Object)builder.getFlowNodeType()), false, false, this.firstStateNames.get((Object)builder.getFlowNodeType()));
        return builder.done();
    }

    private SActor getActor(long processDefinitionId, String actorName) throws SActorNotFoundException {
        GetActor getSActor = new GetActor(this.actorMappingService, actorName, processDefinitionId);
        try {
            getSActor.execute();
        }
        catch (SBonitaException sbe) {
            throw new SActorNotFoundException(sbe);
        }
        return getSActor.getResult();
    }

    private SIntermediateThrowEventInstanceBuilder createIntermediateThrowEventInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) {
        SIntermediateThrowEventDefinition intermediateThrowEvent = (SIntermediateThrowEventDefinition)sFlowNodeDefinition;
        SIntermediateThrowEventInstanceBuilder builder = BuilderFactory.get(SIntermediateThrowEventInstanceBuilderFactory.class).createNewIntermediateThrowEventInstance(intermediateThrowEvent.getName(), intermediateThrowEvent.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        this.updateFlowNodeInstance(parentContainerId, parentContainerType, builder);
        return builder;
    }

    private SIntermediateCatchEventInstanceBuilder createIntermediateCatchEventInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) {
        SIntermediateCatchEventDefinition intermediateCatchEvent = (SIntermediateCatchEventDefinition)sFlowNodeDefinition;
        SIntermediateCatchEventInstanceBuilder builder = BuilderFactory.get(SIntermediateCatchEventInstanceBuilderFactory.class).createNewIntermediateCatchEventInstance(intermediateCatchEvent.getName(), intermediateCatchEvent.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        this.updateFlowNodeInstance(parentContainerId, parentContainerType, builder);
        return builder;
    }

    private SBoundaryEventInstanceBuilder createBoundaryEventInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SBoundaryEventDefinition boundaryEvent, long rootProcessInstanceId, long parentProcessInstanceId, long activityInstanceId) {
        SBoundaryEventInstanceBuilder builder = BuilderFactory.get(SBoundaryEventInstanceBuilderFactory.class).createNewBoundaryEventInstance(boundaryEvent.getName(), boundaryEvent.isInterrupting(), boundaryEvent.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId, activityInstanceId);
        this.updateFlowNodeInstance(parentContainerId, parentContainerType, builder);
        return builder;
    }

    private SGatewayInstanceBuilder createGatewayInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) {
        SGatewayInstanceBuilder builder = BuilderFactory.get(SGatewayInstanceBuilderFactory.class).createNewInstance(sFlowNodeDefinition.getName(), sFlowNodeDefinition.getId(), rootContainerId, parentContainerId, ((SGatewayDefinition)sFlowNodeDefinition).getGatewayType(), processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        this.updateFlowNodeInstance(parentContainerId, parentContainerType, builder);
        return builder;
    }

    protected SEndEventInstanceBuilder createEndEventInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) {
        SEndEventDefinition endEventDef = (SEndEventDefinition)sFlowNodeDefinition;
        return BuilderFactory.get(SEndEventInstanceBuilderFactory.class).createNewEndEventInstance(endEventDef.getName(), endEventDef.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
    }

    private SAutomaticTaskInstanceBuilder createAutomaticTaskInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long parentProcessInstanceId) {
        SAutomaticTaskInstanceBuilder builder = BuilderFactory.get(SAutomaticTaskInstanceBuilderFactory.class).createNewAutomaticTaskInstance(sFlowNodeDefinition.getName(), sFlowNodeDefinition.getId(), rootContainerId, parentContainerId, processDefinitionId, rootContainerId, parentProcessInstanceId);
        this.updateActivityInstance(parentContainerId, parentContainerType, sFlowNodeDefinition, builder);
        return builder;
    }

    private SFlowNodeInstanceBuilder createReceiveTaskInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long parentProcessInstanceId) {
        SReceiveTaskInstanceBuilder builder = BuilderFactory.get(SReceiveTaskInstanceBuilderFactory.class).createNewReceiveTaskInstance(sFlowNodeDefinition.getName(), sFlowNodeDefinition.getId(), rootContainerId, parentContainerId, processDefinitionId, rootContainerId, parentProcessInstanceId);
        this.updateActivityInstance(parentContainerId, parentContainerType, sFlowNodeDefinition, builder);
        return builder;
    }

    private SFlowNodeInstanceBuilder createSendTaskInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, long parentProcessInstanceId) {
        SSendTaskInstanceBuilder builder = BuilderFactory.get(SSendTaskInstanceBuilderFactory.class).createNewSendTaskInstance(sFlowNodeDefinition.getName(), sFlowNodeDefinition.getId(), rootContainerId, parentContainerId, processDefinitionId, rootContainerId, parentProcessInstanceId);
        this.updateActivityInstance(parentContainerId, parentContainerType, sFlowNodeDefinition, builder);
        return builder;
    }

    private void updateActivityInstance(long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeDefinition sFlowNodeDefinition, SActivityInstanceBuilder builder) {
        this.updateFlowNodeInstance(parentContainerId, parentContainerType, builder);
        builder.setDescription(sFlowNodeDefinition.getDescription());
    }

    private void updateFlowNodeInstance(long parentContainerId, SFlowElementsContainerType parentContainerType, SFlowNodeInstanceBuilder builder) {
        long logicalGroup3 = SFlowElementsContainerType.FLOWNODE.equals((Object)parentContainerType) ? parentContainerId : 0L;
        builder.setParentActivityInstanceId(logicalGroup3);
    }

    private SMultiInstanceActivityInstanceBuilder createMultiInstanceActivityInstance(long processDefinitionId, long rootContainerId, long parentContainerId, long rootProcessInstanceId, long parentProcessInstanceId, SActivityDefinition activityDefinition, SMultiInstanceLoopCharacteristics loopCharacteristics) {
        SMultiInstanceActivityInstanceBuilder builder = BuilderFactory.get(SMultiInstanceActivityInstanceBuilderFactory.class).createNewOuterTaskInstance(activityDefinition.getName(), activityDefinition.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId, loopCharacteristics.isSequential());
        builder.setLoopDataInputRef(loopCharacteristics.getLoopDataInputRef());
        builder.setLoopDataOutputRef(loopCharacteristics.getLoopDataOutputRef());
        builder.setDataInputItemRef(loopCharacteristics.getDataInputItemRef());
        builder.setDataOutputItemRef(loopCharacteristics.getDataOutputItemRef());
        return builder;
    }

    public SLoopActivityInstanceBuilder createLoopActivityInstance(long processDefinitionId, long rootContainerId, long parentContainerId, long rootProcessInstanceId, long parentProcessInstanceId, SActivityDefinition activityDefinition) {
        SLoopActivityInstanceBuilder builder = BuilderFactory.get(SLoopActivityInstanceBuilderFactory.class).createNewOuterTaskInstance(activityDefinition.getName(), activityDefinition.getId(), rootContainerId, parentContainerId, processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        return builder;
    }

    private SHumanTaskInstanceBuilder createHumanTaskInstance(long processDefinitionId, long rootContainerId, long parentContainerId, SFlowNodeDefinition sFlowNodeDefinition, long rootProcessInstanceId, long parentProcessInstanceId) throws SActorNotFoundException {
        SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)sFlowNodeDefinition;
        String actorName = humanTaskDefinition.getActorName();
        SActor actor = this.getActor(processDefinitionId, actorName);
        SUserTaskInstanceBuilder builder = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class).createNewUserTaskInstance(humanTaskDefinition.getName(), humanTaskDefinition.getId(), rootContainerId, parentContainerId, actor.getId(), processDefinitionId, rootProcessInstanceId, parentProcessInstanceId);
        this.fillHumanTask(humanTaskDefinition, builder);
        return builder;
    }

    private void fillHumanTask(SHumanTaskDefinition humanTaskDefinition, SHumanTaskInstanceBuilder builder) {
        String priority;
        builder.setReachedStateDate(System.currentTimeMillis());
        Long expectedDuration = humanTaskDefinition.getExpectedDuration();
        if (expectedDuration != null) {
            builder.setExpectedEndDate(System.currentTimeMillis() + expectedDuration);
        }
        if ((priority = humanTaskDefinition.getPriority()) != null) {
            STaskPriority sPriority = STaskPriority.valueOf(priority);
            builder.setPriority(sPriority);
        }
    }

    public void createConnectorInstances(PersistentObject container, List<SConnectorDefinition> connectors, String containerType) throws SBonitaException {
        ArrayList<SConnectorInstance> connectorInstances = new ArrayList<SConnectorInstance>(connectors.size());
        int executionOrder = 0;
        for (SConnectorDefinition sConnectorDefinition : connectors) {
            connectorInstances.add(BuilderFactory.get(SConnectorInstanceBuilderFactory.class).createNewInstance(sConnectorDefinition.getName(), container.getId(), containerType, sConnectorDefinition.getConnectorId(), sConnectorDefinition.getVersion(), sConnectorDefinition.getActivationEvent(), executionOrder++).done());
        }
        CreateConnectorInstances transaction = new CreateConnectorInstances(connectorInstances, this.connectorInstanceService);
        transaction.execute();
    }

    public void setFirstStateIds(Map<SFlowNodeType, Integer> firstStateIds) {
        this.firstStateIds = firstStateIds;
    }

    public void setFirstStateNames(Map<SFlowNodeType, String> firstStateNames) {
        this.firstStateNames = firstStateNames;
    }

    public void createDataInstances(SProcessInstance processInstance, SFlowElementContainerDefinition processContainer, SProcessDefinition processDefinition, SExpressionContext expressionContext, List<SOperation> operations, Map<String, Object> context) throws SDataInstanceNotWellFormedException, SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException, SDataInstanceException, SFlowNodeNotFoundException, SFlowNodeReadException {
        List<SDataDefinition> sDataDefinitions = processContainer.getDataDefinitions();
        ArrayList<SDataInstance> sDataInstances = new ArrayList<SDataInstance>(sDataDefinitions.size());
        for (SDataDefinition sDataDefinition : sDataDefinitions) {
            SOperation operation;
            Serializable defaultValue = null;
            boolean hasOperation = false;
            SExpression expression = null;
            SExpressionContext currentExpressionContext = null;
            if (operations != null && (operation = this.getOperationToSetData(sDataDefinition.getName(), operations)) != null) {
                hasOperation = true;
                expression = operation.getRightOperand();
                if (expressionContext != null) {
                    expressionContext.setInputValues(context);
                    currentExpressionContext = expressionContext;
                } else {
                    currentExpressionContext = new SExpressionContext((Long)processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name(), processInstance.getProcessDefinitionId());
                    currentExpressionContext.setInputValues(context);
                }
                operations.remove(operation);
            }
            if (!hasOperation) {
                expression = sDataDefinition.getDefaultValueExpression();
                currentExpressionContext = new SExpressionContext((Long)processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.name(), processInstance.getProcessDefinitionId());
            }
            if (expression != null) {
                defaultValue = (Serializable)this.expressionResolverService.evaluate(expression, currentExpressionContext);
            } else if (sDataDefinition.isTransientData().booleanValue() && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "Creating a transient data instance with a null expression is not a good practice.");
            }
            try {
                SDataInstance dataInstance = BuilderFactory.get(SDataInstanceBuilderFactory.class).createNewInstance(sDataDefinition).setContainerId(processInstance.getId()).setContainerType(DataInstanceContainer.PROCESS_INSTANCE.name()).setValue(defaultValue).done();
                sDataInstances.add(dataInstance);
            }
            catch (ClassCastException e) {
                throw new SDataInstanceNotWellFormedException("Trying to set variable \"" + sDataDefinition.getName() + "\" with incompatible type: " + e.getMessage());
            }
        }
        if (this.hasLocalOrInheritedData(processDefinition, processContainer)) {
            this.createDataForProcess(processInstance, processDefinition, sDataInstances);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Initialized variables for process instance [name: <");
            stb.append(processInstance.getName());
            stb.append(">, version: <");
            stb.append(processDefinition.getVersion());
            stb.append(">, id: <");
            stb.append(processInstance.getId());
            stb.append(">, root process instance: <");
            stb.append(processInstance.getRootProcessInstanceId());
            stb.append(">, process definition: <");
            stb.append(processInstance.getProcessDefinitionId());
            if (processInstance.getCallerId() > 0L) {
                stb.append(">, caller id: <");
                stb.append(processInstance.getCallerId());
                stb.append(">, caller type: <");
                stb.append((Object)processInstance.getCallerType());
            }
            stb.append(">]");
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, stb.toString());
        }
    }

    private void createDataForProcess(SProcessInstance processInstance, SProcessDefinition processDefinition, List<SDataInstance> sDataInstances) throws SDataInstanceException, SFlowNodeNotFoundException, SFlowNodeReadException {
        if (!sDataInstances.isEmpty()) {
            for (SDataInstance sDataInstance : sDataInstances) {
                this.dataInstanceService.createDataInstance(sDataInstance);
            }
        }
    }

    private boolean hasLocalOrInheritedData(SProcessDefinition processDefinition, SFlowElementContainerDefinition processContainer) {
        return !processContainer.getDataDefinitions().isEmpty() || !processDefinition.getProcessContainer().getDataDefinitions().isEmpty();
    }

    SOperation getOperationToSetData(String dataName, List<SOperation> operations) {
        SOperation dataOperation = null;
        Iterator<SOperation> iterator = operations.iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            SOperation operation = iterator.next();
            if (!SOperatorType.ASSIGNMENT.equals((Object)operation.getType()) || !"DATA".equals(operation.getLeftOperand().getType()) || !dataName.equals(operation.getLeftOperand().getName())) continue;
            found = true;
            dataOperation = operation;
        }
        return dataOperation;
    }

    /*
     * Unable to fully structure code
     */
    private void createDataInstances(List<SDataDefinition> dataDefinitions, long containerId, DataInstanceContainer containerType, SExpressionContext expressionContext, String loopDataInputRef, int index, String dataInputRef, long parentContainerId) throws SDataInstanceException, SExpressionException {
        for (SDataDefinition dataDefinition : dataDefinitions) {
            dataValue = null;
            if (!dataDefinition.getName().equals(dataInputRef)) ** GOTO lbl14
            dataInstance = this.dataInstanceService.getDataInstance(loopDataInputRef, parentContainerId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), this.parentContainerResolver);
            if (dataInstance != null) {
                try {
                    list = (List)dataInstance.getValue();
                    if (list.isEmpty()) ** GOTO lbl20
                    dataValue = (Serializable)list.get(index);
                }
                catch (ClassCastException e) {
                    throw new SDataInstanceReadException("LoopDataInput ref named " + loopDataInputRef + " in " + containerId + " " + (Object)containerType + " is not a list or the value is not serializable.");
                }
            } else {
                throw new SDataInstanceReadException("LoopDataInput ref named " + loopDataInputRef + " is not visible for " + containerId + " " + (Object)containerType);
lbl14:
                // 1 sources

                defaultValueExpression = dataDefinition.getDefaultValueExpression();
                if (defaultValueExpression != null) {
                    dataValue = (Serializable)this.expressionResolverService.evaluate(dataDefinition.getDefaultValueExpression(), expressionContext);
                } else if (dataDefinition.isTransientData().booleanValue() && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "Creating a transient data instance with a null expression is not a good practice.");
                }
            }
lbl20:
            // 6 sources

            try {
                dataInstance = this.buildDataInstance(dataDefinition, containerId, containerType, dataValue);
            }
            catch (SDataInstanceNotWellFormedException e) {
                throw new SDataInstanceReadException(e);
            }
            if (dataInstance.isTransientData().booleanValue()) {
                this.transientDataService.createDataInstance(dataInstance);
                continue;
            }
            this.dataInstanceService.createDataInstance(dataInstance);
        }
    }

    public void createDataInstances(List<SDataDefinition> dataDefinitions, long containerId, DataInstanceContainer containerType, SExpressionContext expressionContext) throws SDataInstanceException, SExpressionException {
        this.createDataInstances(dataDefinitions, containerId, containerType, expressionContext, null, -1, null, -1L);
    }

    private SDataInstance buildDataInstance(SDataDefinition dataDefinition, long dataContainerId, DataInstanceContainer dataContainerType, Serializable dataValue) throws SDataInstanceNotWellFormedException {
        return BuilderFactory.get(SDataInstanceBuilderFactory.class).createNewInstance(dataDefinition).setContainerId(dataContainerId).setContainerType(dataContainerType.name()).setValue(dataValue).done();
    }

    public boolean createDataInstances(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, SExpressionContext sExpressionContext) throws SActivityStateExecutionException {
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        SActivityDefinition activityDefinition = (SActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        if (activityDefinition != null) {
            SExpressionContext expressionContext = sExpressionContext == null ? new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId()) : sExpressionContext;
            return this.createDataInstances(processContainer, activityDefinition, flowNodeInstance, expressionContext);
        }
        return false;
    }

    private boolean createDataInstances(SFlowElementContainerDefinition processContainer, SActivityDefinition activityDefinition, SFlowNodeInstance flowNodeInstance, SExpressionContext expressionContext) throws SActivityStateExecutionException {
        List<SDataDefinition> sDataDefinitions = activityDefinition.getSDataDefinitions();
        SLoopCharacteristics loopCharacteristics = activityDefinition.getLoopCharacteristics();
        try {
            if (loopCharacteristics instanceof SMultiInstanceLoopCharacteristics && (((SMultiInstanceLoopCharacteristics)loopCharacteristics).getDataInputItemRef() != null || ((SMultiInstanceLoopCharacteristics)loopCharacteristics).getDataOutputItemRef() != null)) {
                this.createDataInstancesForMultiInstance(activityDefinition, flowNodeInstance, expressionContext);
            } else {
                this.createDataInstances(sDataDefinitions, flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE, expressionContext);
            }
            if (!sDataDefinitions.isEmpty() && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                String message = "Initialized variables for flow node" + LogMessageBuilder.buildFlowNodeContextMessage(flowNodeInstance);
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, message);
            }
            return sDataDefinitions.size() > 0;
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    protected void createDataInstancesForMultiInstance(SActivityDefinition activityDefinition, SFlowNodeInstance flowNodeInstance, SExpressionContext expressionContext) throws SDataInstanceException, SExpressionException {
        SLoopCharacteristics loopCharacteristics = activityDefinition.getLoopCharacteristics();
        SMultiInstanceLoopCharacteristics miLoop = (SMultiInstanceLoopCharacteristics)loopCharacteristics;
        this.createDataInstances(activityDefinition.getSDataDefinitions(), flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE, expressionContext, miLoop.getLoopDataInputRef(), flowNodeInstance.getLoopCounter(), miLoop.getDataInputItemRef(), flowNodeInstance.getParentContainerId());
    }

    public TechnicalLoggerService getLogger() {
        return this.logger;
    }
}

