/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.cache.ehcache;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.bonitasoft.engine.cache.CacheConfiguration;
import org.bonitasoft.engine.cache.CacheConfigurations;
import org.bonitasoft.engine.cache.CommonCacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;

public abstract class CommonEhCacheCacheService
implements CommonCacheService {
    protected CacheManager cacheManager;
    protected final TechnicalLoggerService logger;
    protected final ReadSessionAccessor sessionAccessor;
    protected final Map<String, net.sf.ehcache.config.CacheConfiguration> cacheConfigurations;
    private final net.sf.ehcache.config.CacheConfiguration defaultCacheConfiguration;
    private final String diskStorePath;

    public CommonEhCacheCacheService(TechnicalLoggerService logger, ReadSessionAccessor sessionAccessor, CacheConfigurations cacheConfigurations, CacheConfiguration defaultCacheConfiguration, String diskStorePath) {
        this.logger = logger;
        this.sessionAccessor = sessionAccessor;
        this.diskStorePath = diskStorePath;
        this.defaultCacheConfiguration = this.getEhCacheConfiguration(defaultCacheConfiguration);
        List<CacheConfiguration> configurations = cacheConfigurations.getConfigurations();
        this.cacheConfigurations = new HashMap<String, net.sf.ehcache.config.CacheConfiguration>(configurations.size());
        for (CacheConfiguration cacheConfig : configurations) {
            this.cacheConfigurations.put(cacheConfig.getName(), this.getEhCacheConfiguration(cacheConfig));
        }
    }

    protected net.sf.ehcache.config.CacheConfiguration getEhCacheConfiguration(CacheConfiguration cacheConfig) {
        net.sf.ehcache.config.CacheConfiguration ehCacheConfig = new net.sf.ehcache.config.CacheConfiguration();
        ehCacheConfig.setMaxElementsInMemory(cacheConfig.getMaxElementsInMemory());
        ehCacheConfig.setMaxElementsOnDisk(cacheConfig.getMaxElementsOnDisk());
        ehCacheConfig.setOverflowToDisk(!cacheConfig.isInMemoryOnly());
        ehCacheConfig.setEternal(cacheConfig.isEternal());
        ehCacheConfig.setCopyOnRead(cacheConfig.isCopyOnRead());
        ehCacheConfig.setCopyOnWrite(cacheConfig.isCopyOnWrite());
        if (!cacheConfig.isEternal()) {
            ehCacheConfig.setTimeToLiveSeconds(cacheConfig.getTimeToLiveSeconds());
        }
        return ehCacheConfig;
    }

    protected void buildCacheManagerWithDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setDefaultCacheConfiguration(this.defaultCacheConfiguration);
        configuration.diskStore(new DiskStoreConfiguration().path(this.diskStorePath));
        this.cacheManager = new CacheManager(configuration);
    }

    protected synchronized Cache createCache(String cacheName, String internalCacheName) throws SCacheException {
        if (this.cacheManager == null) {
            throw new SCacheException("The cache is not stated, call start() on the cache service");
        }
        Cache cache = this.cacheManager.getCache(internalCacheName);
        if (cache == null) {
            net.sf.ehcache.config.CacheConfiguration cacheConfiguration = this.cacheConfigurations.get(cacheName);
            if (cacheConfiguration != null) {
                net.sf.ehcache.config.CacheConfiguration newCacheConfig = cacheConfiguration.clone();
                newCacheConfig.setName(internalCacheName);
                cache = new Cache(newCacheConfig);
                this.cacheManager.addCache(cache);
            } else {
                throw new SCacheException("No configuration found for the cache " + cacheName);
            }
        }
        return cache;
    }

    @Override
    public void store(String cacheName, Serializable key, Object value) throws SCacheException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "store"));
        }
        if (this.cacheManager == null) {
            throw new SCacheException("The cache is not started, call start() on the cache service");
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache = this.cacheManager.getCache(cacheNameKey);
            if (cache == null) {
                cache = this.createCache(cacheName, cacheNameKey);
            }
            if (value instanceof Serializable) {
                cache.put(new Element(key, (Serializable)value));
            } else {
                cache.put(new Element((Object)key, value));
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "store"));
            }
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "store", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new SCacheException(msg, e);
        }
        catch (CacheException ce) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "store", (Exception)((Object)ce)));
            }
            throw new SCacheException(ce);
        }
    }

    protected abstract String getKeyFromCacheName(String var1) throws SCacheException;

    @Override
    public Object get(String cacheName, Object key) throws SCacheException {
        if (this.cacheManager == null) {
            return null;
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "get"));
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache = this.cacheManager.getCache(cacheNameKey);
            if (cache == null) {
                return null;
            }
            Element element = cache.get(key);
            if (element != null) {
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "get"));
                }
                return element.getObjectValue();
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "get"));
            }
            return null;
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "get", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new SCacheException(msg, e);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "get", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' does not exist");
            String msg = stringBuilder.toString();
            throw new SCacheException(msg, e);
        }
    }

    @Override
    public boolean clear(String cacheName) throws SCacheException {
        if (this.cacheManager == null) {
            return true;
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "clear"));
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache = this.cacheManager.getCache(cacheNameKey);
            if (cache != null) {
                cache.removeAll();
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "clear"));
            }
            return cache == null;
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "clear", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new SCacheException(msg, e);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "clear", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' does not exist");
            String msg = stringBuilder.toString();
            throw new SCacheException(msg, e);
        }
    }

    @Override
    public int getCacheSize(String cacheName) throws SCacheException {
        if (this.cacheManager == null) {
            return 0;
        }
        Cache cache = this.cacheManager.getCache(this.getKeyFromCacheName(cacheName));
        if (cache == null) {
            return 0;
        }
        return cache.getSize();
    }

    @Override
    public void clearAll() throws SCacheException {
        if (this.cacheManager == null) {
            return;
        }
        try {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "clearAll"));
            }
            List<String> cacheNames = this.getCachesNames();
            for (String cacheName : cacheNames) {
                this.clear(cacheName);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "clearAll"));
            }
        }
        catch (CacheException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "clearAll", (Exception)((Object)e)));
            }
            throw new SCacheException(e);
        }
    }

    @Override
    public boolean remove(String cacheName, Object key) throws SCacheException {
        if (this.cacheManager == null) {
            return false;
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "remove"));
        }
        Cache cache = this.cacheManager.getCache(cacheNameKey);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "remove"));
        }
        return cache != null && cache.remove(key);
    }

    @Override
    public List<Object> getKeys(String cacheName) throws SCacheException {
        if (this.cacheManager == null) {
            return Collections.emptyList();
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache;
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getKeys"));
            }
            if ((cache = this.cacheManager.getCache(cacheNameKey)) == null) {
                return Collections.emptyList();
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getKeys"));
            }
            return cache.getKeys();
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getKeys", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new SCacheException(msg, e);
        }
        catch (CacheException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getKeys", (Exception)((Object)e)));
            }
            throw new SCacheException(e);
        }
    }

    protected void shutdownCacheManager() {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
            this.cacheManager = null;
        }
    }
}

