/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.cache.ehcache;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.cache.CacheConfiguration;
import org.bonitasoft.engine.cache.CacheConfigurations;
import org.bonitasoft.engine.cache.PlatformCacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.cache.ehcache.CommonEhCacheCacheService;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;

public class PlatformEhCacheCacheService
extends CommonEhCacheCacheService
implements PlatformCacheService {
    public PlatformEhCacheCacheService(TechnicalLoggerService logger, ReadSessionAccessor sessionAccessor, CacheConfigurations cacheConfigurations, CacheConfiguration defaultCacheConfiguration, String diskStorePath) {
        super(logger, sessionAccessor, cacheConfigurations, defaultCacheConfiguration, diskStorePath);
    }

    @Override
    protected String getKeyFromCacheName(String cacheName) {
        return "P_" + cacheName;
    }

    @Override
    public List<String> getCachesNames() {
        String[] cacheNames = this.cacheManager.getCacheNames();
        ArrayList<String> cacheNamesList = new ArrayList<String>(cacheNames.length);
        String prefix = "P_";
        for (String cacheName : cacheNames) {
            if (!cacheName.startsWith("P_")) continue;
            cacheNamesList.add(this.getCacheNameFromKey(cacheName));
        }
        return cacheNamesList;
    }

    private String getCacheNameFromKey(String cacheNameKey) {
        return cacheNameKey.substring(cacheNameKey.indexOf(95) + 1);
    }

    @Override
    public synchronized void start() {
        this.buildCacheManagerWithDefaultConfiguration();
    }

    @Override
    public synchronized void stop() {
        this.shutdownCacheManager();
    }

    @Override
    public void pause() {
        try {
            this.clearAll();
        }
        catch (SCacheException sce) {
            throw new SBonitaRuntimeException(sce);
        }
    }

    @Override
    public void resume() {
        if (this.cacheManager == null) {
            this.start();
        }
    }
}

