/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.commons;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SReflectException;

public class ClassReflector {
    private static final String EMPTY = "";
    private static final String SET = "set";
    private static final String IS = "is";
    private static final String GET = "get";
    private static final Map<String, Method> methods = new HashMap<String, Method>();
    private static final Object MUTEX = new Object();

    public static Collection<Method> getAccessibleGetters(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Method method : clazz.getMethods()) {
            if (!ClassReflector.isAGetterMethod(method)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static <T> Class<T> getClass(Class<T> clazz, String className) throws SReflectException {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static <T> T getObject(Class<T> clazz, String className) throws SReflectException {
        try {
            return ClassReflector.getClass(clazz, className).newInstance();
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws SReflectException {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, String className, Class<?> ... parameterTypes) throws SReflectException {
        try {
            return ClassReflector.getClass(clazz, className).getConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static <T> T getInstance(Constructor<T> constructor, Object ... parameters) throws SReflectException {
        try {
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static <T> T invokeGetter(Object entity, String getterName) throws SReflectException {
        try {
            Method getter = ClassReflector.getMethod(entity.getClass(), getterName, new Class[0]);
            return (T)getter.invoke(entity, (Object[])null);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static void invokeSetter(Object entity, String setterName, Class<?> parameterType, Object parameterValue) throws SReflectException {
        try {
            Method setter = ClassReflector.getMethod(entity.getClass(), setterName, parameterType);
            setter.invoke(entity, parameterValue);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.hashCode());
        stringBuilder.append(':');
        stringBuilder.append(clazz.getName());
        stringBuilder.append('.');
        stringBuilder.append(methodName);
        stringBuilder.append('(');
        if (parameterTypes != null) {
            for (Class<?> class1 : parameterTypes) {
                stringBuilder.append(class1.getName());
                stringBuilder.append(',');
            }
        }
        stringBuilder.append(')');
        String key = stringBuilder.toString();
        ClassReflector.putIfAbsent(clazz, methodName, key, parameterTypes);
        return methods.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putIfAbsent(Class<?> clazz, String methodName, String key, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (!methods.containsKey(key)) {
            Object object = MUTEX;
            synchronized (object) {
                if (!methods.containsKey(key)) {
                    methods.put(key, clazz.getMethod(methodName, parameterTypes));
                }
            }
        }
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clazz.getName());
        stringBuilder.append('.');
        stringBuilder.append(methodName);
        String key = stringBuilder.toString();
        ClassReflector.putIfAbsent(clazz, methodName, key);
        return methods.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putIfAbsent(Class<?> clazz, String methodName, String key) {
        if (!methods.containsKey(key)) {
            Object object = MUTEX;
            synchronized (object) {
                if (!methods.containsKey(key)) {
                    Method method = ClassReflector.getFirstMethodWithName(clazz, methodName);
                    methods.put(key, method);
                }
            }
        }
    }

    public static Method getFirstMethodWithName(Class<?> clazz, String methodName) {
        Method selectedMethod = null;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            selectedMethod = method;
            break;
        }
        return selectedMethod;
    }

    public static void invokeMethodByName(Object entity, String methodName, Object ... parameterValues) throws SReflectException {
        Class<?> clazz = entity.getClass();
        Method methodToInvoke = ClassReflector.getMethodByName(clazz, methodName);
        if (methodToInvoke == null) {
            throw new SReflectException("unable to find a method with name '" + methodName + "' within class " + clazz.getName());
        }
        try {
            methodToInvoke.invoke(entity, parameterValues);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
    }

    public static Object invokeMethod(Object entity, String methodName, Class<?> parameterType, Object parameterValue) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = ClassReflector.getMethod(entity.getClass(), methodName, parameterType);
        return method.invoke(entity, parameterValue);
    }

    public static Object invokeMethod(Object entity, String methodName, Class<?>[] parameterType, Object[] parameterValue) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = ClassReflector.getMethod(entity.getClass(), methodName, parameterType);
        return method.invoke(entity, parameterValue);
    }

    private static boolean isWrapped(Class<?> a, Class<?> b) {
        return a.equals(Integer.TYPE) && b.equals(Integer.class) || a.equals(Double.TYPE) && b.equals(Double.class) || a.equals(Boolean.TYPE) && b.equals(Boolean.class) || a.equals(Character.TYPE) && b.equals(Character.class) || a.equals(Long.TYPE) && b.equals(Long.class) || a.equals(Short.TYPE) && b.equals(Short.class) || a.equals(Float.TYPE) && b.equals(Float.class) || a.equals(Byte.TYPE) && b.equals(Byte.class);
    }

    public static Method getCompatibleMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SReflectException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            if (paramTypes != null) {
                Method[] methods;
                for (Method method : methods = clazz.getMethods()) {
                    if (!methodName.equals(method.getName())) continue;
                    Class<?>[] types = method.getParameterTypes();
                    boolean check = true;
                    if (types.length != paramTypes.length) {
                        throw new SReflectException("wrong parameters");
                    }
                    for (int i = 0; i < types.length; ++i) {
                        if (types[i].isAssignableFrom(paramTypes[i]) || paramTypes[i].isAssignableFrom(types[i]) || ClassReflector.isWrapped(types[i], paramTypes[i])) continue;
                        check = false;
                        break;
                    }
                    if (!check) continue;
                    return method;
                }
            }
            throw new SReflectException(e);
        }
    }

    public static Type getGetterReturnType(Class<?> classConnector, String getterName) throws SReflectException {
        Method m;
        try {
            m = ClassReflector.getMethod(classConnector, getterName, new Class[0]);
        }
        catch (Exception e) {
            throw new SReflectException(e);
        }
        return m.getGenericReturnType();
    }

    public static Method[] getDeclaredSetters(Class<?> clazz) {
        ArrayList<Method> setters = new ArrayList<Method>();
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!ClassReflector.isASetterMethod(method)) continue;
            setters.add(method);
        }
        return setters.toArray(new Method[setters.size()]);
    }

    public static Method[] getDeclaredGetters(Class<?> clazz) {
        ArrayList<Method> getters = new ArrayList<Method>();
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!ClassReflector.isAGetterMethod(method)) continue;
            getters.add(method);
        }
        return getters.toArray(new Method[getters.size()]);
    }

    public static boolean isAGetterMethod(Method method) {
        String methodName = method.getName();
        return (methodName.startsWith(GET) || methodName.startsWith(IS)) && method.getParameterTypes().length == 0 && !Void.class.equals(method.getReturnType());
    }

    public static boolean isASetterMethod(Method method) {
        String methodName = method.getName();
        return methodName.startsWith(SET) && "void".equals(method.getReturnType().toString()) && method.getParameterTypes().length == 1;
    }

    public static String getGetterName(String fieldName) {
        StringBuilder builder = new StringBuilder(GET);
        builder.append(String.valueOf(fieldName.charAt(0)).toUpperCase());
        builder.append(fieldName.substring(1));
        return builder.toString();
    }

    public static String getGetterName(String fieldName, Class<?> fieldType) {
        StringBuilder builder = new StringBuilder();
        builder.append(ClassReflector.getGetterPrefix(fieldType));
        builder.append(String.valueOf(fieldName.charAt(0)).toUpperCase());
        builder.append(fieldName.substring(1));
        return builder.toString();
    }

    private static String getGetterPrefix(Class<?> fieldType) {
        if (fieldType.isAssignableFrom(Boolean.class)) {
            return IS;
        }
        return GET;
    }

    public static String getFieldName(String methodName) {
        int cut = 4;
        if (methodName.startsWith(IS)) {
            cut = 3;
        }
        if (methodName.length() < cut) {
            return EMPTY;
        }
        String end = methodName.substring(cut);
        char c = methodName.charAt(cut - 1);
        String begin = String.valueOf(c).toLowerCase();
        return begin.concat(end);
    }
}

