/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.connector.impl;

import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.connector.AbstractConnector;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorException;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.bonitasoft.engine.connector.EngineExecutionContext;
import org.bonitasoft.engine.connector.SConnector;
import org.bonitasoft.engine.connector.exception.SConnectorException;
import org.bonitasoft.engine.connector.exception.SConnectorValidationException;

public class SConnectorAdapter
implements SConnector {
    private final Connector connector;

    public SConnectorAdapter(Connector connector) {
        NullCheckingUtil.checkArgsNotNull(connector);
        this.connector = connector;
    }

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        APIAccessor apiAccessor = (APIAccessor)parameters.remove("connectorApiAccessor");
        EngineExecutionContext executionContext = (EngineExecutionContext)parameters.remove("engineExecutionContext");
        if (this.connector instanceof AbstractConnector) {
            ((AbstractConnector)this.connector).setAPIAccessor(apiAccessor);
            if (executionContext != null) {
                ((AbstractConnector)this.connector).setExecutionContext(executionContext);
            }
        }
        this.connector.setInputParameters(parameters);
    }

    @Override
    public void validate() throws SConnectorValidationException {
        try {
            this.connector.validateInputParameters();
        }
        catch (ConnectorValidationException e) {
            throw new SConnectorValidationException(e);
        }
    }

    @Override
    public Map<String, Object> execute() throws SConnectorException {
        try {
            return this.connector.execute();
        }
        catch (ConnectorException e) {
            throw new SConnectorException(e);
        }
    }

    @Override
    public void connect() throws SConnectorException {
        try {
            this.connector.connect();
        }
        catch (ConnectorException e) {
            throw new SConnectorException(e);
        }
    }

    @Override
    public void disconnect() throws SConnectorException {
        try {
            this.connector.disconnect();
        }
        catch (ConnectorException e) {
            throw new SConnectorException(e);
        }
    }
}

