/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.login;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.bonitasoft.engine.authentication.AuthenticationException;
import org.bonitasoft.engine.authentication.AuthenticationService;
import org.bonitasoft.engine.authentication.GenericAuthenticationService;
import org.bonitasoft.engine.core.login.LoginService;
import org.bonitasoft.engine.core.login.SLoginException;
import org.bonitasoft.engine.core.login.TechnicalUser;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.io.PropertiesManager;
import org.bonitasoft.engine.session.SSessionException;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class SecuredLoginServiceImpl
implements LoginService {
    private AuthenticationService authenticationService = null;
    private GenericAuthenticationService genericAuthenticationService = null;
    private final SessionService sessionService;
    private final SessionAccessor sessionAccessor;
    private final IdentityService identityService;

    @Deprecated
    public SecuredLoginServiceImpl(AuthenticationService authenticationService, SessionService sessionService, SessionAccessor sessionAccessor, IdentityService identityService) {
        this.authenticationService = authenticationService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.identityService = identityService;
    }

    public SecuredLoginServiceImpl(GenericAuthenticationService genericAuthenticationService, SessionService sessionService, SessionAccessor sessionAccessor, IdentityService identityService) {
        this.genericAuthenticationService = genericAuthenticationService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.identityService = identityService;
    }

    @Override
    @Deprecated
    public SSession login(long tenantId, String userName, String password) throws SLoginException {
        HashMap<String, Serializable> credentials = new HashMap<String, Serializable>();
        credentials.put("authentication.tenant.id", (Serializable)((Object)String.valueOf(tenantId)));
        credentials.put("authentication.password", (Serializable)((Object)password));
        credentials.put("authentication.username", (Serializable)((Object)userName));
        return this.login(credentials);
    }

    @Override
    public SSession login(Map<String, Serializable> credentials) throws SLoginException {
        if (credentials == null) {
            throw new SLoginException("invalid credentials, map is null");
        }
        Long tenantId = NumberUtils.toLong((String)String.valueOf(credentials.get("authentication.tenant.id")), (long)-1L);
        this.sessionAccessor.setSessionInfo(-1L, tenantId);
        long userId = 0L;
        boolean isTechnicalUser = false;
        String userName = null;
        try {
            TechnicalUser technicalUser = this.getTechnicalUser(tenantId);
            if (credentials.containsKey("authentication.username") && credentials.get("authentication.username") != null) {
                userName = String.valueOf(credentials.get("authentication.username"));
            }
            if (technicalUser.getUserName().equals(userName) && technicalUser.getPassword().equals(String.valueOf(credentials.get("authentication.password")))) {
                isTechnicalUser = true;
                userId = -1L;
            } else {
                userName = this.loginChoosingAppropriateAuthenticationService(credentials);
                if (StringUtils.isNotBlank((CharSequence)userName)) {
                    SUser user = this.identityService.getUserByUserName(userName);
                    userId = user.getId();
                } else {
                    this.authenticationFailed();
                }
            }
        }
        catch (AuthenticationException ae) {
            throw new SLoginException(ae);
        }
        catch (SUserNotFoundException e) {
            throw new SLoginException("Unable to found user " + userName);
        }
        finally {
            this.sessionAccessor.deleteSessionId();
        }
        try {
            return this.sessionService.createSession(tenantId, userId, userName, isTechnicalUser);
        }
        catch (SSessionException e) {
            throw new SLoginException(e);
        }
    }

    protected void authenticationFailed() throws SLoginException {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            throw new SLoginException("User name or password is not valid!");
        }
        throw new SLoginException("User name or password is not valid!");
    }

    protected String loginChoosingAppropriateAuthenticationService(Map<String, Serializable> credentials) throws AuthenticationException, SLoginException {
        if (this.authenticationService != null) {
            String password;
            String userName = this.retrieveUsernameFromCredentials(credentials);
            if (this.authenticationService.checkUserCredentials(userName, password = this.retrievePasswordFromCredentials(credentials))) {
                return userName;
            }
            return null;
        }
        if (this.genericAuthenticationService != null) {
            return this.genericAuthenticationService.checkUserCredentials(credentials);
        }
        throw new AuthenticationException("no implementation of authentication supplied");
    }

    protected String retrievePasswordFromCredentials(Map<String, Serializable> credentials) throws SLoginException {
        if (credentials == null || !credentials.containsKey("authentication.password") || credentials.get("authentication.password") == null) {
            throw new SLoginException("invalid credentials, password is absent");
        }
        return String.valueOf(credentials.get("authentication.password"));
    }

    protected String retrieveUsernameFromCredentials(Map<String, Serializable> credentials) throws SLoginException {
        String userName;
        if (credentials == null || !credentials.containsKey("authentication.username") || credentials.get("authentication.username") == null || StringUtils.isBlank((CharSequence)(userName = String.valueOf(credentials.get("authentication.username"))))) {
            throw new SLoginException("invalid credentials, username is blank");
        }
        return userName;
    }

    @Override
    public void logout(long sessionId) throws SSessionNotFoundException {
        this.sessionService.deleteSession(sessionId);
    }

    @Override
    public boolean isValid(long sessionId) {
        try {
            return this.sessionService.isValid(sessionId);
        }
        catch (SSessionNotFoundException e) {
            return false;
        }
    }

    protected TechnicalUser getTechnicalUser(long tenantId) throws SLoginException {
        try {
            String technicalUserPropertiesPath = BonitaHomeServer.getInstance().getTenantConfFolder(tenantId) + File.separator + "bonita-server.properties";
            Properties properties = PropertiesManager.getProperties((File)new File(technicalUserPropertiesPath));
            String userName = (String)properties.get("userName");
            String password = (String)properties.get("userPassword");
            return new TechnicalUser(userName, password);
        }
        catch (BonitaHomeNotSetException e) {
            throw new SLoginException(e);
        }
        catch (IOException e) {
            throw new SLoginException(e);
        }
    }
}

