/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.instance.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.Pair;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.commons.exceptions.SObjectReadException;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.api.ParentContainerResolver;
import org.bonitasoft.engine.data.instance.exception.SCreateDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceNotFoundException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceReadException;
import org.bonitasoft.engine.data.instance.exception.SDeleteDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SUpdateDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstance;
import org.bonitasoft.engine.data.instance.model.archive.builder.SADataInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class DataInstanceServiceImpl
implements DataInstanceService {
    private static final String DATA_INSTANCE = "DATA_INSTANCE";
    protected final Recorder recorder;
    protected final ReadPersistenceService persistenceService;
    protected final ArchiveService archiveService;
    protected final TechnicalLoggerService logger;

    public DataInstanceServiceImpl(Recorder recorder, ReadPersistenceService persistenceService, ArchiveService archiveService, TechnicalLoggerService logger) {
        this.recorder = recorder;
        this.persistenceService = persistenceService;
        this.archiveService = archiveService;
        this.logger = logger;
    }

    private void archiveDataInstance(SDataInstance sDataInstance) throws SDataInstanceException {
        this.archiveDataInstance(sDataInstance, System.currentTimeMillis());
    }

    @Override
    public void archiveDataInstance(SDataInstance sDataInstance, long archiveDate) throws SDataInstanceException {
        if (!sDataInstance.isTransientData().booleanValue()) {
            try {
                SADataInstance saDataInstance = BuilderFactory.get(SADataInstanceBuilderFactory.class).createNewInstance(sDataInstance).done();
                ArchiveInsertRecord archiveInsertRecord = new ArchiveInsertRecord(saDataInstance);
                this.archiveService.recordInsert(archiveDate, archiveInsertRecord);
            }
            catch (SRecorderException e) {
                this.logOnExceptionMethod("updateDataInstance", e);
                throw new SDataInstanceException("Unable to create SADataInstance", e);
            }
        }
    }

    @Override
    public SDataInstance getDataInstance(String dataName, long containerId, String containerType, ParentContainerResolver parentContainerResolver) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataName, containerType);
        String queryName = "getDataInstancesWithNames";
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put("dataNames", Collections.singletonList(dataName));
        List<SDataInstance> dataInstances = this.getSDatainstanceOfContainers(containerId, containerType, parentContainerResolver, "getDataInstancesWithNames", inputParameters);
        if (dataInstances.size() == 0) {
            throw new SDataInstanceNotFoundException("DataInstance with name not found: [name: " + dataName + ", container type: " + containerType + ", container id: " + containerId + ']');
        }
        if (dataInstances.size() > 1) {
            throw new SDataInstanceReadException("Several data have been retrieved for: [name: " + dataName + ", container type: " + containerType + ", container id: " + containerId + ']');
        }
        return dataInstances.get(0);
    }

    @Override
    public List<SDataInstance> getDataInstances(long containerId, String containerType, ParentContainerResolver parentContainerResolver, int fromIndex, int numberOfResults) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(containerType);
        String queryName = "getDataInstances";
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        List<SDataInstance> dataInstances = this.getSDatainstanceOfContainers(containerId, containerType, parentContainerResolver, "getDataInstances", inputParameters);
        int startIndex = Math.max(0, fromIndex);
        int toIndex = Math.min(dataInstances.size(), fromIndex + numberOfResults);
        return dataInstances.subList(startIndex, toIndex);
    }

    private Map<String, List<Long>> buildContainersMap(List<Pair<Long, String>> containerHierarchy, Map<String, Object> inputParameters) {
        HashMap<String, List<Long>> containers = new HashMap<String, List<Long>>();
        for (Pair<Long, String> container : containerHierarchy) {
            String containerTypeKey = container.getRight();
            if (!containers.containsKey(containerTypeKey)) {
                containers.put(containerTypeKey, new ArrayList());
                inputParameters.put("containerType" + containers.size(), containerTypeKey);
                inputParameters.put("containerType" + containers.size() + "Ids", containers.get(containerTypeKey));
            }
            ((List)containers.get(containerTypeKey)).add(container.getLeft());
        }
        return containers;
    }

    private List<SDataInstance> getSDatainstanceOfContainers(long containerId, String containerType, ParentContainerResolver parentContainerResolver, String queryName, Map<String, Object> inputParameters) throws SDataInstanceNotFoundException, SDataInstanceReadException {
        List<SDataInstance> dataInstances;
        List<Pair<Long, String>> containerHierarchy;
        try {
            containerHierarchy = parentContainerResolver.getContainerHierarchy(new Pair<Long, String>(containerId, containerType));
        }
        catch (SObjectNotFoundException e) {
            throw new SDataInstanceNotFoundException(e);
        }
        catch (SObjectReadException e) {
            throw new SDataInstanceNotFoundException(e);
        }
        Map<String, List<Long>> containers = this.buildContainersMap(containerHierarchy, inputParameters);
        try {
            dataInstances = this.persistenceService.selectList(new SelectListDescriptor(this.getDynamicContainersQueryName(queryName, containers.size()), inputParameters, SDataInstance.class, new QueryOptions(0, Integer.MAX_VALUE)));
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Unable to check if a data instance already exists: " + e.getMessage(), e);
        }
        Collections.sort(dataInstances, new Comparator<SDataInstance>(){

            @Override
            public int compare(SDataInstance o1, SDataInstance o2) {
                Pair<Long, String> o1Container = new Pair<Long, String>(o1.getContainerId(), o1.getContainerType());
                Pair<Long, String> o2Container = new Pair<Long, String>(o2.getContainerId(), o2.getContainerType());
                return containerHierarchy.indexOf(o1Container) - containerHierarchy.indexOf(o2Container);
            }
        });
        HashSet<String> alreadyUsedNames = new HashSet<String>();
        Iterator it = dataInstances.iterator();
        while (it.hasNext()) {
            SDataInstance current = (SDataInstance)it.next();
            if (alreadyUsedNames.contains(current.getName())) {
                it.remove();
                continue;
            }
            alreadyUsedNames.add(current.getName());
        }
        return dataInstances;
    }

    @Override
    public SDataInstance getLocalDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceReadException {
        SDataInstance dataInstance = this.internalGetLocalDataInstance(dataName, containerId, containerType);
        if (dataInstance == null) {
            throw new SDataInstanceReadException("No data instance found");
        }
        return dataInstance;
    }

    private SDataInstance internalGetLocalDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceReadException {
        NullCheckingUtil.checkArgsNotNull(dataName, containerType);
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        Map<String, Object> paraMap = CollectionUtil.buildSimpleMap(fact.getNameKey(), dataName);
        paraMap.put(fact.getContainerIdKey(), containerId);
        paraMap.put(fact.getContainerTypeKey(), containerType);
        try {
            return this.persistenceService.selectOne(new SelectOneDescriptor<SDataInstance>("getDataInstancesByNameAndContainer", paraMap, SDataInstance.class, SDataInstance.class));
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Unable to check if a data instance already exists: " + e.getMessage(), e);
        }
    }

    @Override
    public List<SDataInstance> getLocalDataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceReadException {
        NullCheckingUtil.checkArgsNotNull(containerType);
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        Map<String, Object> paraMap = CollectionUtil.buildSimpleMap(fact.getContainerIdKey(), containerId);
        OrderByOption orderByOption = new OrderByOption(SDataInstance.class, fact.getIdKey(), OrderByType.ASC);
        paraMap.put(fact.getContainerTypeKey(), containerType);
        try {
            return this.persistenceService.selectList(new SelectListDescriptor<SDataInstance>("getDataInstancesByContainer", paraMap, SDataInstance.class, SDataInstance.class, new QueryOptions(fromIndex, numberOfResults, Arrays.asList(orderByOption))));
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Unable to check if a data instance already exists for the data container of type " + containerType + " with id " + containerId + " for reason: " + e.getMessage(), e);
        }
    }

    private List<SADataInstance> getSADatainstanceOfContainers(long containerId, String containerType, ParentContainerResolver parentContainerResolver, String queryName, Map<String, Object> inputParameters) throws SDataInstanceReadException {
        List<SADataInstance> dataInstances;
        List<Pair<Long, String>> containerHierarchy;
        try {
            containerHierarchy = parentContainerResolver.getArchivedContainerHierarchy(new Pair<Long, String>(containerId, containerType));
        }
        catch (SObjectNotFoundException e) {
            throw new SDataInstanceReadException(e);
        }
        catch (SObjectReadException e) {
            throw new SDataInstanceReadException(e);
        }
        Map<String, List<Long>> containers = this.buildContainersMap(containerHierarchy, inputParameters);
        try {
            dataInstances = this.persistenceService.selectList(new SelectListDescriptor(this.getDynamicContainersQueryName(queryName, containers.size()), inputParameters, SADataInstance.class, new QueryOptions(0, Integer.MAX_VALUE)));
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Unable to check if a data instance already exists: " + e.getMessage(), e);
        }
        Collections.sort(dataInstances, new Comparator<SADataInstance>(){

            @Override
            public int compare(SADataInstance o1, SADataInstance o2) {
                Pair<Long, String> o1Container = new Pair<Long, String>(o1.getContainerId(), o1.getContainerType());
                Pair<Long, String> o2Container = new Pair<Long, String>(o2.getContainerId(), o2.getContainerType());
                if (containerHierarchy.indexOf(o1Container) - containerHierarchy.indexOf(o2Container) == 0) {
                    return (int)(o2.getArchiveDate() - o1.getArchiveDate());
                }
                return containerHierarchy.indexOf(o1Container) - containerHierarchy.indexOf(o2Container);
            }
        });
        HashSet<String> alreadyUsedNames = new HashSet<String>();
        Iterator it = dataInstances.iterator();
        while (it.hasNext()) {
            SADataInstance current = (SADataInstance)it.next();
            if (alreadyUsedNames.contains(current.getName())) {
                it.remove();
                continue;
            }
            alreadyUsedNames.add(current.getName());
        }
        return dataInstances;
    }

    private String getDynamicContainersQueryName(String queryName, long nbOfContainers) {
        return queryName + "Of" + nbOfContainers + "Containers";
    }

    @Override
    public SADataInstance getSADataInstance(long containerId, String containerType, ParentContainerResolver parentContainerResolver, String dataName, long time) throws SDataInstanceReadException {
        this.logBeforeMethod("getSADataInstance");
        String queryName = "getArchivedDataInstancesWithNames";
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put("dataNames", Collections.singletonList(dataName));
        inputParameters.put("time", time);
        List<SADataInstance> dataInstances = this.getSADatainstanceOfContainers(containerId, containerType, parentContainerResolver, "getArchivedDataInstancesWithNames", inputParameters);
        if (dataInstances.size() == 0) {
            throw new SDataInstanceReadException("DataInstance with name not found: [name: " + dataName + ", container type: " + containerType + ", container id: " + containerId + ']');
        }
        if (dataInstances.size() > 1) {
            throw new SDataInstanceReadException("Several data have been retrieved for: [name: " + dataName + ", container type: " + containerType + ", container id: " + containerId + ']');
        }
        return dataInstances.get(0);
    }

    @Override
    public SADataInstance getSADataInstance(long sourceObjectId, long time) throws SDataInstanceReadException {
        this.logBeforeMethod("getSADataInstance");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("dataInstanceId", sourceObjectId);
            parameters.put("time", time);
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getSADataInstanceByDataInstanceIdAndArchiveDate", parameters, SADataInstance.class));
            this.logAfterMethod("getSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getSADataInstance", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public SADataInstance getLastSADataInstance(String dataName, long containerId, String containerType, ParentContainerResolver parentContainerResolver) throws SDataInstanceException {
        this.logBeforeMethod("getLastSADataInstance");
        SADataInstance saDataInstance = this.getSADataInstance(containerId, containerType, parentContainerResolver, dataName, System.currentTimeMillis());
        if (saDataInstance == null) {
            throw new SDataInstanceNotFoundException("No archived data instance found for data:" + dataName + " in container: " + containerType + " " + containerId);
        }
        return saDataInstance;
    }

    @Override
    public List<SADataInstance> getSADataInstances(long containerId, String containerType, ParentContainerResolver parentContainerResolver, List<String> dataNames, long time) throws SDataInstanceReadException {
        this.logBeforeMethod("getSADataInstances");
        if (dataNames.isEmpty()) {
            return Collections.emptyList();
        }
        String queryName = "getArchivedDataInstancesWithNames";
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put("time", time);
        inputParameters.put("dataNames", dataNames);
        return this.getSADatainstanceOfContainers(containerId, containerType, parentContainerResolver, "getArchivedDataInstancesWithNames", inputParameters);
    }

    @Override
    public List<SADataInstance> getLastLocalSADataInstances(long containerId, String containerType, int startIndex, int maxResults) throws SDataInstanceReadException {
        this.logBeforeMethod("getLastLocalSADataInstances");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("containerId", containerId);
            parameters.put("containerType", containerType);
            List<SADataInstance> saDataInstances = readPersistenceService.selectList(new SelectListDescriptor("getLastLocalSADataInstances", parameters, SADataInstance.class, new QueryOptions(startIndex, maxResults)));
            this.logAfterMethod("getLastLocalSADataInstances");
            return saDataInstances;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getLastLocalSADataInstances", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public long getNumberOfDataInstances(long containerId, String containerType, ParentContainerResolver parentContainerResolver) throws SDataInstanceReadException {
        List<SDataInstance> dataInstances;
        this.logBeforeMethod("getNumberOfDataInstances");
        try {
            dataInstances = this.getDataInstances(containerId, containerType, parentContainerResolver, 0, Integer.MAX_VALUE);
        }
        catch (SDataInstanceException e) {
            throw new SDataInstanceReadException(e);
        }
        this.logAfterMethod("getNumberOfDataInstances");
        return dataInstances.size();
    }

    @Override
    public List<SDataInstance> getDataInstances(List<String> dataNames, long containerId, String containerType, ParentContainerResolver parentContainerResolver) throws SDataInstanceException {
        this.logBeforeMethod("getDataInstances");
        NullCheckingUtil.checkArgsNotNull(dataNames, containerType);
        if (dataNames.isEmpty()) {
            return Collections.emptyList();
        }
        String queryName = "getDataInstancesWithNames";
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put("dataNames", dataNames);
        return this.getSDatainstanceOfContainers(containerId, containerType, parentContainerResolver, "getDataInstancesWithNames", inputParameters);
    }

    @Override
    public List<SADataInstance> getLocalSADataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceReadException {
        this.logBeforeMethod("getLocalSADataInstances");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("containerId", containerId);
            parameters.put("containerType", containerType);
            List<SADataInstance> saDataInstances = readPersistenceService.selectList(new SelectListDescriptor("getLocalSADataInstances", parameters, SADataInstance.class, new QueryOptions(fromIndex, numberOfResults)));
            this.logAfterMethod("getLocalSADataInstances");
            return saDataInstances;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getLocalSADataInstances", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    private void deleteSADataInstance(SADataInstance dataInstance) throws SDeleteDataInstanceException {
        DeleteRecord deleteRecord = new DeleteRecord(dataInstance);
        SEvent event = BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent(DATA_INSTANCE).setObject(dataInstance).done();
        SDeleteEvent deleteEvent = (SDeleteEvent)event;
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SDeleteDataInstanceException("Impossible to delete data instance", e);
        }
    }

    @Override
    public void deleteLocalArchivedDataInstances(long containerId, String containerType) throws SDataInstanceException {
        List<SADataInstance> sDataInstances;
        do {
            sDataInstances = this.getLocalSADataInstances(containerId, containerType, 0, 100);
            for (SADataInstance sDataInstance : sDataInstances) {
                this.deleteSADataInstance(sDataInstance);
            }
        } while (!sDataInstances.isEmpty());
    }

    @Override
    public void deleteLocalDataInstances(long containerId, String dataInstanceContainerType, boolean dataPresent) throws SDataInstanceException {
        if (dataPresent) {
            int deleteBatchSize = 80;
            List<SDataInstance> sDataInstances = this.getLocalDataInstances(containerId, dataInstanceContainerType, 0, 80);
            while (sDataInstances.size() > 0) {
                for (SDataInstance sDataInstance : sDataInstances) {
                    this.deleteDataInstance(sDataInstance);
                }
                sDataInstances = this.getLocalDataInstances(containerId, dataInstanceContainerType, 0, 80);
            }
        }
    }

    private void logBeforeMethod(String methodName) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logAfterMethod(String methodName) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void logOnExceptionMethod(String methodName, Exception e) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, e));
        }
    }

    private SInsertEvent getInsertEvent(Object obj) {
        return (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent(DATA_INSTANCE).setObject(obj).done();
    }

    private SUpdateEvent getUpdateEvent(Object obj) {
        return (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(DATA_INSTANCE).setObject(obj).done();
    }

    private SDeleteEvent getDeleteEvent(Object obj) {
        return (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent(DATA_INSTANCE).setObject(obj).done();
    }

    @Override
    public void createDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        try {
            InsertRecord insertRecord = new InsertRecord(dataInstance);
            SInsertEvent insertEvent = this.getInsertEvent(dataInstance);
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SCreateDataInstanceException("Impossible to create data instance.", e);
        }
        this.archiveDataInstance(dataInstance);
    }

    @Override
    public void updateDataInstance(SDataInstance dataInstance, EntityUpdateDescriptor descriptor) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)dataInstance, descriptor);
        SUpdateEvent updateEvent = this.getUpdateEvent(dataInstance);
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SUpdateDataInstanceException("Impossible to update data instance '" + dataInstance.getName() + "': " + e.getMessage(), e);
        }
        this.archiveDataInstance(dataInstance);
    }

    @Override
    public void deleteDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        DeleteRecord deleteRecord = new DeleteRecord(dataInstance);
        SDeleteEvent deleteEvent = this.getDeleteEvent(dataInstance);
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SDeleteDataInstanceException("Impossible to delete data instance", e);
        }
    }

    @Override
    public SDataInstance getDataInstance(long dataInstanceId) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstanceId);
        try {
            SelectByIdDescriptor<SDataInstance> selectDescriptor = new SelectByIdDescriptor<SDataInstance>("getDataInstanceById", SDataInstance.class, dataInstanceId);
            SDataInstance dataInstance = this.persistenceService.selectById(selectDescriptor);
            if (dataInstance == null) {
                throw new SDataInstanceNotFoundException("Cannot get the data instance with id " + dataInstanceId);
            }
            return dataInstance;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Cannot get the data instance with id " + dataInstanceId, e);
        }
    }
}

