/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.List;
import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.comment.api.SCommentAddException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.api.SystemCommentType;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAAutomaticTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.FlowNodeExecutor;
import org.bonitasoft.engine.execution.archive.ProcessArchiver;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class FlowNodeExecutorImpl
implements FlowNodeExecutor {
    private final FlowNodeStateManager flowNodeStateManager;
    private final ActivityInstanceService activityInstanceService;
    private final OperationService operationService;
    private final ArchiveService archiveService;
    private final DataInstanceService dataInstanceService;
    private final ContainerRegistry containerRegistry;
    private final ProcessDefinitionService processDefinitionService;
    private final SCommentService commentService;
    private final ProcessInstanceService processInstanceService;
    private final ConnectorInstanceService connectorInstanceService;
    private final ClassLoaderService classLoaderService;
    private final WorkService workService;

    public FlowNodeExecutorImpl(FlowNodeStateManager flowNodeStateManager, ActivityInstanceService activityInstanceManager, OperationService operationService, ArchiveService archiveService, DataInstanceService dataInstanceService, ContainerRegistry containerRegistry, ProcessDefinitionService processDefinitionService, SCommentService commentService, ProcessInstanceService processInstanceService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, WorkService workService) {
        this.flowNodeStateManager = flowNodeStateManager;
        this.activityInstanceService = activityInstanceManager;
        this.operationService = operationService;
        this.archiveService = archiveService;
        this.dataInstanceService = dataInstanceService;
        this.containerRegistry = containerRegistry;
        this.processInstanceService = processInstanceService;
        this.connectorInstanceService = connectorInstanceService;
        this.classLoaderService = classLoaderService;
        this.workService = workService;
        containerRegistry.addContainerExecutor(this);
        this.processDefinitionService = processDefinitionService;
        this.commentService = commentService;
    }

    @Override
    public StateCode executeState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, FlowNodeState state) throws SActivityStateExecutionException, SActivityExecutionException {
        try {
            StateCode stateCode = StateCode.DONE;
            if (state.getStateCategory().equals((Object)flowNodeInstance.getStateCategory())) {
                stateCode = state.execute(processDefinition, flowNodeInstance);
                this.addSystemComment(flowNodeInstance, state);
            }
            return stateCode;
        }
        catch (SCommentAddException e) {
            throw new SActivityExecutionException(e);
        }
    }

    private void addSystemComment(SFlowNodeInstance flowNodeInstance, FlowNodeState state) throws SCommentAddException {
        if (this.commentService.isCommentEnabled(SystemCommentType.STATE_CHANGE) && state.mustAddSystemComment(flowNodeInstance)) {
            this.commentService.addSystemComment(flowNodeInstance.getRootContainerId(), state.getSystemComment(flowNodeInstance));
        }
    }

    @Override
    public FlowNodeState stepForward(long flowNodeInstanceId, SExpressionContext expressionContext, List<SOperation> operations, long processInstanceId, Long executerId, Long executerSubstituteId) throws SFlowNodeExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SFlowNodeInstance sFlowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
            long processDefinitionId = sFlowNodeInstance.getLogicalGroup(BuilderFactory.get(SUserTaskInstanceBuilderFactory.class).getProcessDefinitionIndex());
            ClassLoader localClassLoader = this.classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
            Thread.currentThread().setContextClassLoader(localClassLoader);
            if (!sFlowNodeInstance.isStateExecuting()) {
                this.archiveFlowNodeInstance(sFlowNodeInstance, false, processDefinitionId);
                this.setExecutedBy(executerId, sFlowNodeInstance);
                this.setExecutedBySubstitute(executerSubstituteId, sFlowNodeInstance);
                this.executeOperations(expressionContext, operations, sFlowNodeInstance);
            }
            SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
            FlowNodeState state = this.updateState(sFlowNodeInstance, processDefinition);
            if (!sFlowNodeInstance.isStateExecuting() && state != null) {
                this.registerWork(state, processDefinitionId, processInstanceId, sFlowNodeInstance);
            }
            FlowNodeState flowNodeState = state;
            return flowNodeState;
        }
        catch (SActivityStateExecutionException e) {
            throw e;
        }
        catch (SFlowNodeExecutionException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new SFlowNodeExecutionException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private FlowNodeState updateState(SFlowNodeInstance sFlowNodeInstance, SProcessDefinition processDefinition) throws SActivityStateExecutionException, SActivityExecutionException, SFlowNodeModificationException {
        StateCode stateCode = this.executeState(processDefinition, sFlowNodeInstance, this.flowNodeStateManager.getState(sFlowNodeInstance.getStateId()));
        if (StateCode.DONE.equals((Object)stateCode)) {
            return this.getNextNormalState(sFlowNodeInstance, processDefinition);
        }
        if (StateCode.EXECUTING.equals((Object)stateCode)) {
            this.activityInstanceService.setExecuting(sFlowNodeInstance);
        }
        return null;
    }

    private FlowNodeState getNextNormalState(SFlowNodeInstance sFlowNodeInstance, SProcessDefinition processDefinition) throws SActivityExecutionException, SFlowNodeModificationException {
        FlowNodeState state = this.flowNodeStateManager.getNextNormalState(processDefinition, sFlowNodeInstance, sFlowNodeInstance.getStateId());
        if (sFlowNodeInstance.getStateId() != state.getId()) {
            this.activityInstanceService.setState(sFlowNodeInstance, state);
        }
        return state;
    }

    private void registerWork(FlowNodeState state, long processDefinitionId, long processInstanceId, SFlowNodeInstance sFlowNodeInstance) throws SWorkRegisterException {
        if (!state.isStable() && !state.isInterrupting()) {
            this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(processDefinitionId, processInstanceId, sFlowNodeInstance.getId(), null, null));
        } else {
            this.registerCreateNotifyChildFinishedWorkIfStateIsTerminal(processDefinitionId, state, sFlowNodeInstance);
        }
    }

    private void registerCreateNotifyChildFinishedWorkIfStateIsTerminal(long processDefinitionId, FlowNodeState state, SFlowNodeInstance sFlowNodeInstance) throws SWorkRegisterException {
        if (state.isTerminal()) {
            this.workService.registerWork(WorkFactory.createNotifyChildFinishedWork(processDefinitionId, sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), sFlowNodeInstance.getParentContainerId(), sFlowNodeInstance.getParentContainerType().name()));
        }
    }

    private void executeOperations(SExpressionContext expressionContext, List<SOperation> operations, SFlowNodeInstance sFlowNodeInstance) throws SOperationExecutionException {
        if (operations != null) {
            this.operationService.execute(operations, sFlowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), expressionContext);
        }
    }

    private void setExecutedBySubstitute(Long executerSubstituteId, SFlowNodeInstance sFlowNodeInstance) throws SFlowNodeModificationException {
        if (this.isNotNullOrEmptyAndDifferentOf(sFlowNodeInstance.getExecutedBySubstitute(), executerSubstituteId)) {
            this.activityInstanceService.setExecutedBySubstitute(sFlowNodeInstance, executerSubstituteId);
        }
    }

    private void setExecutedBy(Long executerId, SFlowNodeInstance sFlowNodeInstance) throws SFlowNodeModificationException {
        if (this.isNotNullOrEmptyAndDifferentOf(sFlowNodeInstance.getExecutedBy(), executerId)) {
            this.activityInstanceService.setExecutedBy(sFlowNodeInstance, executerId);
        }
    }

    private boolean isNotNullOrEmptyAndDifferentOf(long executerId, Long newExecuterId) {
        return newExecuterId != null && newExecuterId > 0L && executerId != newExecuterId;
    }

    @Override
    public void setStateByStateId(long sProcessDefinitionId, long flowNodeInstanceId, int stateId) throws SActivityStateExecutionException {
        FlowNodeState state = this.flowNodeStateManager.getState(stateId);
        try {
            SFlowNodeInstance sFlowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
            this.archiveFlowNodeInstance(sFlowNodeInstance, false, sProcessDefinitionId);
            this.activityInstanceService.setState(sFlowNodeInstance, state);
            this.registerCreateNotifyChildFinishedWorkIfStateIsTerminal(sProcessDefinitionId, state, sFlowNodeInstance);
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    @Override
    public void childFinished(long processDefinitionId, long flowNodeInstanceId, long parentId) throws SFlowNodeNotFoundException, SFlowNodeReadException, SProcessDefinitionNotFoundException, SProcessDefinitionReadException, SArchivingException, SFlowNodeModificationException, SFlowNodeExecutionException {
        SFlowNodeInstance sFlowNodeInstanceChild = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
        this.archiveFlowNodeInstance(sFlowNodeInstanceChild, true, processDefinitionId);
        SActivityInstance activityInstanceParent = (SActivityInstance)this.activityInstanceService.getFlowNodeInstance(parentId);
        this.decrementToken(activityInstanceParent);
        SProcessDefinition sProcessDefinition = this.processDefinitionService.getProcessDefinition(processDefinitionId);
        boolean hit = this.flowNodeStateManager.getState(activityInstanceParent.getStateId()).hit(sProcessDefinition, activityInstanceParent, sFlowNodeInstanceChild);
        if (hit) {
            this.stepForward(parentId, null, null, sFlowNodeInstanceChild.getParentProcessInstanceId(), null, null);
        }
    }

    private void decrementToken(SActivityInstance sActivityInstance) throws SFlowNodeModificationException {
        int tokenCount = sActivityInstance.getTokenCount() - 1;
        this.activityInstanceService.setTokenCount(sActivityInstance, tokenCount);
    }

    @Override
    public void childReachedState(SProcessInstance childProcInst, ProcessInstanceState childState, boolean hasActionsToExecute) throws SBonitaException {
        long callerId = childProcInst.getCallerId();
        if (this.isTerminalState(childState) && callerId > 0L) {
            SActivityInstance callActivityInstance = this.activityInstanceService.getActivityInstance(childProcInst.getCallerId());
            this.decrementToken(callActivityInstance);
            this.executeFlowNodeIfHasActionsToExecute(hasActionsToExecute, callActivityInstance);
        }
    }

    private void executeFlowNodeIfHasActionsToExecute(boolean hasActionsToExecute, SActivityInstance callActivityInstance) throws SWorkRegisterException {
        if (!hasActionsToExecute) {
            this.containerRegistry.executeFlowNode(callActivityInstance.getProcessDefinitionId(), callActivityInstance.getLogicalGroup(BuilderFactory.get(SAAutomaticTaskInstanceBuilderFactory.class).getParentProcessInstanceIndex()), callActivityInstance.getId(), null, null);
        }
    }

    private boolean isTerminalState(ProcessInstanceState childState) {
        return ProcessInstanceState.COMPLETED.equals((Object)childState) || ProcessInstanceState.CANCELLED.equals((Object)childState) || ProcessInstanceState.ABORTED.equals((Object)childState);
    }

    @Override
    public String getHandledType() {
        return SFlowElementsContainerType.FLOWNODE.name();
    }

    @Override
    public FlowNodeState executeFlowNode(long flowNodeInstanceId, SExpressionContext contextDependency, List<SOperation> operations, long processInstanceId, Long executerId, Long executerSubstituteId) throws SFlowNodeExecutionException {
        return this.stepForward(flowNodeInstanceId, contextDependency, operations, processInstanceId, executerId, executerSubstituteId);
    }

    @Override
    public void archiveFlowNodeInstance(SFlowNodeInstance flowNodeInstance, boolean deleteAfterArchive, long processDefinitionId) throws SArchivingException {
        ProcessArchiver.archiveFlowNodeInstance(flowNodeInstance, deleteAfterArchive, processDefinitionId, this.processInstanceService, this.processDefinitionService, this.archiveService, this.dataInstanceService, this.activityInstanceService, this.connectorInstanceService);
    }
}

