/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.transition.ImplicitGatewayTransitionEvaluator;
import org.bonitasoft.engine.execution.transition.InclusiveExclusiveTransitionEvaluator;
import org.bonitasoft.engine.execution.transition.ParallelGatewayTransitionEvaluator;

public class TransitionEvaluator {
    private final ImplicitGatewayTransitionEvaluator implicitGatewayTransitionEvaluator;
    private final ParallelGatewayTransitionEvaluator parallelGatewayTransitionEvaluator;
    private final InclusiveExclusiveTransitionEvaluator inclusiveTransitionEvaluator;
    private final InclusiveExclusiveTransitionEvaluator exclusiveTransitionEvaluator;

    public TransitionEvaluator(ImplicitGatewayTransitionEvaluator implicitGatewayTransitionEvaluator, ParallelGatewayTransitionEvaluator parallelGatewayTransitionEvaluator, InclusiveExclusiveTransitionEvaluator inclusiveTransitionEvaluator, InclusiveExclusiveTransitionEvaluator exclusiveTransitionEvaluator) {
        this.implicitGatewayTransitionEvaluator = implicitGatewayTransitionEvaluator;
        this.parallelGatewayTransitionEvaluator = parallelGatewayTransitionEvaluator;
        this.inclusiveTransitionEvaluator = inclusiveTransitionEvaluator;
        this.exclusiveTransitionEvaluator = exclusiveTransitionEvaluator;
    }

    protected List<STransitionDefinition> evaluateOutgoingTransitions(FlowNodeTransitionsWrapper transitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        if (!SStateCategory.NORMAL.equals((Object)flowNodeInstance.getStateCategory())) {
            return Collections.emptyList();
        }
        SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), sDefinition.getId());
        if (SFlowNodeType.GATEWAY.equals((Object)flowNodeInstance.getType())) {
            return this.evaluateOutgoingTransitionsForGateways(transitions, sDefinition, flowNodeInstance, sExpressionContext);
        }
        if (SFlowNodeType.BOUNDARY_EVENT.equals((Object)flowNodeInstance.getType())) {
            return new ArrayList<STransitionDefinition>(transitions.getAllOutgoingTransitionDefinitions());
        }
        return this.evaluateOutgoingTransitionsForActivity(transitions, sDefinition, flowNodeInstance, sExpressionContext);
    }

    List<STransitionDefinition> evaluateOutgoingTransitionsForActivity(FlowNodeTransitionsWrapper transitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, SExpressionContext sExpressionContext) throws SBonitaException {
        if (transitions.getAllOutgoingTransitionDefinitions().isEmpty()) {
            STransitionDefinition defaultTransition = this.getDefaultTransition(sDefinition, flowNodeInstance);
            if (defaultTransition == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(defaultTransition);
        }
        return this.implicitGatewayTransitionEvaluator.evaluateTransitions(sDefinition, flowNodeInstance, transitions, sExpressionContext);
    }

    List<STransitionDefinition> evaluateOutgoingTransitionsForGateways(FlowNodeTransitionsWrapper transitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, SExpressionContext sExpressionContext) throws SBonitaException {
        List<STransitionDefinition> chosenTransitionDefinitions;
        SGatewayInstance gatewayInstance = (SGatewayInstance)flowNodeInstance;
        switch (gatewayInstance.getGatewayType()) {
            case EXCLUSIVE: {
                chosenTransitionDefinitions = this.exclusiveTransitionEvaluator.evaluateTransitions(sDefinition, flowNodeInstance, transitions, sExpressionContext);
                break;
            }
            case INCLUSIVE: {
                chosenTransitionDefinitions = this.inclusiveTransitionEvaluator.evaluateTransitions(sDefinition, flowNodeInstance, transitions, sExpressionContext);
                break;
            }
            case PARALLEL: {
                chosenTransitionDefinitions = this.parallelGatewayTransitionEvaluator.evaluateTransitions(transitions);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported gateway type: " + (Object)((Object)gatewayInstance.getGatewayType()));
            }
        }
        return chosenTransitionDefinitions;
    }

    protected STransitionDefinition getDefaultTransition(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) {
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
        return flowNode.getDefaultTransition();
    }

    FlowNodeTransitionsWrapper buildTransitionsWrapper(SFlowNodeDefinition flowNode, SProcessDefinition sProcessDefinition, SFlowNodeInstance child) throws SBonitaException {
        FlowNodeTransitionsWrapper transitionsDescriptor = new FlowNodeTransitionsWrapper();
        if (flowNode == null) {
            transitionsDescriptor.setInputTransitionsSize(0);
            transitionsDescriptor.setAllOutgoingTransitionDefinitions(Collections.<STransitionDefinition>emptyList());
        } else {
            transitionsDescriptor.setInputTransitionsSize(flowNode.getIncomingTransitions().size());
            transitionsDescriptor.setAllOutgoingTransitionDefinitions(new ArrayList<STransitionDefinition>(flowNode.getOutgoingTransitions()));
            transitionsDescriptor.setDefaultTransition(flowNode.getDefaultTransition());
        }
        transitionsDescriptor.setValidOutgoingTransitionDefinitions(this.evaluateOutgoingTransitions(transitionsDescriptor, sProcessDefinition, child));
        return transitionsDescriptor;
    }
}

