/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.handler;

import java.util.UUID;
import org.bonitasoft.engine.SArchivingException;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.events.model.SHandlerExecutionException;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.execution.archive.ProcessArchiver;
import org.bonitasoft.engine.execution.handler.SProcessInstanceHandler;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;

public class ArchiveProcessInstancesHandler
implements SProcessInstanceHandler<SUpdateEvent> {
    private static final long serialVersionUID = 1L;
    private final long tenantId;
    private final String identifier;

    public ArchiveProcessInstancesHandler(long tenantId) {
        this(tenantId, UUID.randomUUID().toString());
    }

    public ArchiveProcessInstancesHandler(long tenantId, String identifier) {
        this.tenantId = tenantId;
        this.identifier = identifier;
    }

    @Override
    public void execute(SUpdateEvent event) throws SHandlerExecutionException {
        SProcessInstance processInstance = (SProcessInstance)event.getObject();
        try {
            TenantServiceAccessor tenantServiceAccessor = this.getTenantServiceAccessor();
            ArchiveService archiveService = tenantServiceAccessor.getArchiveService();
            ProcessInstanceService processInstanceService = tenantServiceAccessor.getProcessInstanceService();
            TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
            DataInstanceService dataInstanceService = tenantServiceAccessor.getDataInstanceService();
            DocumentService documentService = tenantServiceAccessor.getDocumentService();
            SCommentService commentService = tenantServiceAccessor.getCommentService();
            ProcessDefinitionService processDefinitionService = tenantServiceAccessor.getProcessDefinitionService();
            ConnectorInstanceService connectorInstanceService = tenantServiceAccessor.getConnectorInstanceService();
            ClassLoaderService classLoaderService = tenantServiceAccessor.getClassLoaderService();
            ProcessArchiver.archiveProcessInstance(processInstance, archiveService, processInstanceService, dataInstanceService, documentService, logger, commentService, processDefinitionService, connectorInstanceService, classLoaderService);
        }
        catch (SArchivingException e) {
            throw new SHandlerExecutionException(e);
        }
        catch (SBonitaException e) {
            throw new SHandlerExecutionException(e);
        }
    }

    private TenantServiceAccessor getTenantServiceAccessor() throws SHandlerExecutionException {
        try {
            ServiceAccessorFactory serviceAccessorFactory = ServiceAccessorFactory.getInstance();
            return serviceAccessorFactory.createTenantServiceAccessor(this.tenantId);
        }
        catch (Exception e) {
            throw new SHandlerExecutionException(e.getMessage(), null);
        }
    }

    @Override
    public boolean isInterested(SUpdateEvent event) {
        boolean isInterested;
        boolean bl = isInterested = "PROCESSINSTANCE_STATE_UPDATED".equals(event.getType()) && event.getObject() instanceof SProcessInstance;
        if (isInterested) {
            SProcessInstance processInstance = (SProcessInstance)event.getObject();
            boolean isTerminal = ProcessInstanceState.COMPLETED.getId() == processInstance.getStateId() || ProcessInstanceState.ABORTED.getId() == processInstance.getStateId() || ProcessInstanceState.CANCELLED.getId() == processInstance.getStateId();
            isInterested = isTerminal && (processInstance.getCallerId() <= 0L || SFlowNodeType.SUB_PROCESS.equals((Object)processInstance.getCallerType()));
        }
        return isInterested;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

