/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.transition;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.transition.DefaultTransitionGetter;
import org.bonitasoft.engine.execution.transition.EvaluatedTransitions;
import org.bonitasoft.engine.execution.transition.TransitionConditionEvaluator;

public class ImplicitGatewayTransitionEvaluator {
    private final TransitionConditionEvaluator conditionEvaluator;
    private final DefaultTransitionGetter defaultTransitionGetter;

    public ImplicitGatewayTransitionEvaluator(TransitionConditionEvaluator conditionEvaluator, DefaultTransitionGetter defaultTransitionGetter) {
        this.conditionEvaluator = conditionEvaluator;
        this.defaultTransitionGetter = defaultTransitionGetter;
    }

    public List<STransitionDefinition> evaluateTransitions(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, FlowNodeTransitionsWrapper transitions, SExpressionContext sExpressionContext) throws SBonitaException {
        EvaluatedTransitions evaluatedTransitions = this.evaluatedTransitions(sExpressionContext, transitions.getAllOutgoingTransitionDefinitions());
        return this.buildChosenTransitions(evaluatedTransitions, transitions, sDefinition, flowNodeInstance);
    }

    private List<STransitionDefinition> buildChosenTransitions(EvaluatedTransitions evaluatedTransitions, FlowNodeTransitionsWrapper transitions, SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(evaluatedTransitions.getUnconditionalTransitions().size() + evaluatedTransitions.getTrueTransitions().size());
        if (evaluatedTransitions.hasUnconditionalTransitions()) {
            chosenTransitions.addAll(evaluatedTransitions.getUnconditionalTransitions());
        }
        if (evaluatedTransitions.hasTrueTransitions()) {
            chosenTransitions.addAll(evaluatedTransitions.getTrueTransitions());
        } else if (evaluatedTransitions.hasFalseTransitons()) {
            STransitionDefinition defaultTransition = this.defaultTransitionGetter.getDefaultTransition(transitions, sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    private EvaluatedTransitions evaluatedTransitions(SExpressionContext sExpressionContext, List<STransitionDefinition> outgoingTransitionDefinitions) throws SBonitaException {
        EvaluatedTransitions evaluatedTransitions = new EvaluatedTransitions();
        for (STransitionDefinition sTransitionDefinition : outgoingTransitionDefinitions) {
            this.evaluateTransition(evaluatedTransitions, sTransitionDefinition, sExpressionContext);
        }
        return evaluatedTransitions;
    }

    private void evaluateTransition(EvaluatedTransitions evaluatedTransitions, STransitionDefinition sTransitionDefinition, SExpressionContext sExpressionContext) throws SBonitaException {
        Boolean condition = this.conditionEvaluator.evaluateCondition(sTransitionDefinition, sExpressionContext);
        if (!sTransitionDefinition.hasCondition()) {
            evaluatedTransitions.addUnconditionalTransition(sTransitionDefinition);
        } else if (condition != null && condition.booleanValue()) {
            evaluatedTransitions.addTrueTransition(sTransitionDefinition);
        } else {
            evaluatedTransitions.addFalseTransition(sTransitionDefinition);
        }
    }
}

