/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.transition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.flowmerger.FlowNodeTransitionsWrapper;
import org.bonitasoft.engine.execution.transition.DefaultTransitionGetter;
import org.bonitasoft.engine.execution.transition.TransitionConditionEvaluator;
import org.bonitasoft.engine.execution.transition.TransitionEvaluationStrategy;

public class InclusiveExclusiveTransitionEvaluator {
    private final TransitionEvaluationStrategy strategy;
    private final TransitionConditionEvaluator evaluator;
    private final DefaultTransitionGetter defaultTransitionGetter;

    public InclusiveExclusiveTransitionEvaluator(TransitionEvaluationStrategy strategy, TransitionConditionEvaluator evaluator, DefaultTransitionGetter defaultTransitionGetter) {
        this.strategy = strategy;
        this.evaluator = evaluator;
        this.defaultTransitionGetter = defaultTransitionGetter;
    }

    public List<STransitionDefinition> evaluateTransitions(SProcessDefinition sDefinition, SFlowNodeInstance flowNodeInstance, FlowNodeTransitionsWrapper transitions, SExpressionContext sExpressionContext) throws SBonitaException {
        List<STransitionDefinition> outgoingTransitionDefinitions = transitions.getAllOutgoingTransitionDefinitions();
        List<STransitionDefinition> chosenTransitions = this.evaluateNonDefaultTransitions(sExpressionContext, outgoingTransitionDefinitions);
        if (chosenTransitions.isEmpty()) {
            STransitionDefinition defaultTransition = this.defaultTransitionGetter.getDefaultTransition(transitions, sDefinition, flowNodeInstance);
            chosenTransitions.add(defaultTransition);
            outgoingTransitionDefinitions.add(defaultTransition);
        }
        return chosenTransitions;
    }

    private List<STransitionDefinition> evaluateNonDefaultTransitions(SExpressionContext sExpressionContext, List<STransitionDefinition> outgoingTransitionDefinitions) throws SBonitaException {
        ArrayList<STransitionDefinition> chosenTransitions = new ArrayList<STransitionDefinition>(outgoingTransitionDefinitions.size());
        boolean found = false;
        Iterator<STransitionDefinition> iterator = outgoingTransitionDefinitions.iterator();
        while (iterator.hasNext() && this.strategy.shouldContinue(found)) {
            STransitionDefinition transitionDefinition = iterator.next();
            Boolean shouldTakeTransition = this.evaluator.evaluateCondition(transitionDefinition, sExpressionContext);
            if (transitionDefinition.hasCondition() && (shouldTakeTransition == null || !shouldTakeTransition.booleanValue())) continue;
            chosenTransitions.add(transitionDefinition);
            found = true;
        }
        return chosenTransitions;
    }
}

