/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.transition;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.SExpression;

public class TransitionConditionEvaluator {
    private final ExpressionResolverService resolverService;

    public TransitionConditionEvaluator(ExpressionResolverService resolverService) {
        this.resolverService = resolverService;
    }

    public Boolean evaluateCondition(STransitionDefinition sTransitionDefinition, SExpressionContext contextDependency) throws SBonitaException {
        SExpression condition = sTransitionDefinition.getCondition();
        if (condition == null) {
            return null;
        }
        if (!Boolean.class.getName().equals(condition.getReturnType())) {
            throw new SExpressionEvaluationException("Condition expression must return a boolean, on transition: " + sTransitionDefinition.getName(), condition.getName());
        }
        return (Boolean)this.resolverService.evaluate(condition, contextDependency);
    }
}

