/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.WaitingEventsInterrupter;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class FailedStateSetter {
    private final WaitingEventsInterrupter waitingEventsInterrupter;
    private final ActivityInstanceService activityInstanceService;
    private final FlowNodeStateManager flowNodeStateManager;
    private final TechnicalLoggerService loggerService;

    public FailedStateSetter(WaitingEventsInterrupter waitingEventsInterrupter, ActivityInstanceService activityInstanceService, FlowNodeStateManager flowNodeStateManager, TechnicalLoggerService loggerService) {
        this.waitingEventsInterrupter = waitingEventsInterrupter;
        this.activityInstanceService = activityInstanceService;
        this.flowNodeStateManager = flowNodeStateManager;
        this.loggerService = loggerService;
    }

    public void setAsFailed(long flowNodeInstanceId) throws SBonitaException {
        block3: {
            try {
                SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(flowNodeInstanceId);
                if (flowNodeInstance.getStateId() != this.flowNodeStateManager.getFailedState().getId()) {
                    this.activityInstanceService.setState(flowNodeInstance, this.flowNodeStateManager.getFailedState());
                    this.waitingEventsInterrupter.interruptWaitingEvents(flowNodeInstance);
                }
            }
            catch (SFlowNodeNotFoundException e) {
                if (!this.loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) break block3;
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Impossible to put flow node instance in failed state: flow node instance with id '" + flowNodeInstanceId + "' not found.");
            }
        }
    }
}

