/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.WaitingEventsInterrupter;
import org.bonitasoft.engine.execution.work.FailedStateSetter;
import org.bonitasoft.engine.execution.work.SetInFailCallable;
import org.bonitasoft.engine.execution.work.TenantAwareBonitaWork;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.transaction.UserTransactionService;

public class NotifyChildFinishedWork
extends TenantAwareBonitaWork {
    private static final long serialVersionUID = -8987586943379865375L;
    private final long processDefinitionId;
    private final long flowNodeInstanceId;
    private final String parentType;
    private final long parentId;

    NotifyChildFinishedWork(long processDefinitionId, long flowNodeInstanceId, long parentId, String parentType) {
        this.processDefinitionId = processDefinitionId;
        this.flowNodeInstanceId = flowNodeInstanceId;
        this.parentId = parentId;
        this.parentType = parentType;
    }

    protected ClassLoader getClassLoader(Map<String, Object> context) throws SBonitaException {
        return this.getTenantAccessor(context).getClassLoaderService().getLocalClassLoader(ScopeType.PROCESS.name(), this.processDefinitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work(Map<String, Object> context) throws Exception {
        ClassLoader processClassloader = this.getClassLoader(context);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(processClassloader);
            ContainerRegistry containerRegistry = this.getTenantAccessor(context).getContainerRegistry();
            containerRegistry.nodeReachedState(this.processDefinitionId, this.flowNodeInstanceId, this.parentId, this.parentType);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + ": processInstanceId:" + this.parentId + ", flowNodeInstanceId: " + this.flowNodeInstanceId;
    }

    @Override
    public void handleFailure(Exception e, Map<String, Object> context) throws Exception {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        UserTransactionService userTransactionService = tenantAccessor.getUserTransactionService();
        TechnicalLoggerService loggerService = tenantAccessor.getTechnicalLoggerService();
        WaitingEventsInterrupter waitingEventsInterrupter = new WaitingEventsInterrupter(tenantAccessor.getEventInstanceService(), tenantAccessor.getSchedulerService(), loggerService);
        FailedStateSetter failedStateSetter = new FailedStateSetter(waitingEventsInterrupter, tenantAccessor.getActivityInstanceService(), tenantAccessor.getFlowNodeStateManager(), loggerService);
        userTransactionService.executeInTransaction(new SetInFailCallable(failedStateSetter, this.flowNodeInstanceId));
    }

    @Override
    public String getRecoveryProcedure() {
        return "call processApi.executeFlowNode(" + this.flowNodeInstanceId + ")";
    }

    public String toString() {
        return "Work[" + this.getDescription() + "]";
    }
}

