/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.work.WorkService;

public class RestartProcessHandler
implements TenantRestartHandler {
    private final Map<Long, List<Long>> processInstancesByTenant = new HashMap<Long, List<Long>>();

    @Override
    public void beforeServicesStart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        ProcessInstanceService processInstanceService = tenantServiceAccessor.getProcessInstanceService();
        TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
        long tenantId = tenantServiceAccessor.getTenantId();
        ArrayList<Long> ids = new ArrayList<Long>();
        this.processInstancesByTenant.put(tenantId, ids);
        QueryOptions queryOptions = new QueryOptions(0, 1000, SProcessInstance.class, "id", OrderByType.ASC);
        try {
            List<SProcessInstance> processInstances;
            do {
                processInstances = processInstanceService.getProcessInstancesInStates(queryOptions, ProcessInstanceState.INITIALIZING, ProcessInstanceState.COMPLETING, ProcessInstanceState.COMPLETED, ProcessInstanceState.ABORTED, ProcessInstanceState.CANCELLED);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SProcessInstance sProcessInstance : processInstances) {
                    ids.add(sProcessInstance.getId());
                }
            } while (processInstances.size() == queryOptions.getNumberOfResults());
            this.logInfo(logger, "Found " + ids.size() + " process to restart on tenant " + tenantId);
        }
        catch (SProcessInstanceReadException e) {
            this.handleException(e, "Unable to restart process: can't read process instances");
        }
    }

    protected void logInfo(TechnicalLoggerService logger, String msg) {
        if (logger.isLoggable(RestartProcessHandler.class, TechnicalLogSeverity.INFO)) {
            logger.log(RestartProcessHandler.class, TechnicalLogSeverity.INFO, msg);
        }
    }

    private void handleException(Exception e, String message) throws RestartException {
        throw new RestartException(message, e);
    }

    private ProcessInstanceState getState(int stateId) {
        return ProcessInstanceState.getFromId((int)stateId);
    }

    @Override
    public void afterServicesStart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        TransactionService transactionService = platformServiceAccessor.getTransactionService();
        long tenantId = tenantServiceAccessor.getTenantId();
        ProcessDefinitionService processDefinitionService = tenantServiceAccessor.getProcessDefinitionService();
        ProcessInstanceService processInstanceService = tenantServiceAccessor.getProcessInstanceService();
        ProcessExecutor processExecutor = tenantServiceAccessor.getProcessExecutor();
        TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
        ActivityInstanceService activityInstanceService = tenantServiceAccessor.getActivityInstanceService();
        WorkService workService = tenantServiceAccessor.getWorkService();
        List<Long> list = this.processInstancesByTenant.get(tenantId);
        Iterator<Long> iterator = list.iterator();
        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting " + list.size() + " processes for tenant " + tenantId);
        ExecuteProcesses exec = null;
        try {
            do {
                exec = new ExecuteProcesses(workService, logger, activityInstanceService, processDefinitionService, processInstanceService, processExecutor, tenantServiceAccessor.getFlowNodeStateManager(), iterator);
                transactionService.executeInTransaction(exec);
            } while (iterator.hasNext());
        }
        catch (Exception e) {
            throw new RestartException("Unable to restart process instance", e);
        }
    }

    protected void handleCompletion(SProcessInstance processInstance, TechnicalLoggerService logger, ActivityInstanceService activityInstanceService, WorkService workService, FlowNodeStateManager flowNodeStateManager) throws SBonitaException {
        SActivityInstance callActivityInstance;
        long callerId;
        if (!processInstance.hasBeenInterruptedByEvent() && (callerId = processInstance.getCallerId()) > 0L && (callActivityInstance = activityInstanceService.getActivityInstance(processInstance.getCallerId())).getStateId() != flowNodeStateManager.getFailedState().getId()) {
            workService.registerWork(WorkFactory.createExecuteFlowNodeWork(callActivityInstance.getProcessDefinitionId(), callActivityInstance.getParentProcessInstanceId(), callActivityInstance.getId(), null, null));
            this.logInfo(logger, "Restarting notification of finished process '" + processInstance.getName() + "' with id " + processInstance.getId() + " in state " + this.getState(processInstance.getStateId()));
        }
    }

    private void restartConnector(SProcessDefinition processDefinition, SProcessInstance processInstance, ConnectorEvent event, ProcessExecutor processExecutor) throws SBonitaException {
        processExecutor.executeConnectors(processDefinition, processInstance, event, null);
    }

    public class ExecuteProcesses
    implements Callable<Object> {
        private final WorkService workService;
        private final TechnicalLoggerService logger;
        private final ActivityInstanceService activityInstanceService;
        private final ProcessDefinitionService processDefinitionService;
        private final ProcessInstanceService processInstanceService;
        private final ProcessExecutor processExecutor;
        private final FlowNodeStateManager flowNodeStateManager;
        private final Iterator<Long> iterator;

        public ExecuteProcesses(WorkService workService, TechnicalLoggerService logger, ActivityInstanceService activityInstanceService, ProcessDefinitionService processDefinitionService, ProcessInstanceService processInstanceService, ProcessExecutor processExecutor, FlowNodeStateManager flowNodeStateManager, Iterator<Long> iterator) {
            this.workService = workService;
            this.logger = logger;
            this.activityInstanceService = activityInstanceService;
            this.processDefinitionService = processDefinitionService;
            this.processInstanceService = processInstanceService;
            this.processExecutor = processExecutor;
            this.flowNodeStateManager = flowNodeStateManager;
            this.iterator = iterator;
        }

        @Override
        public Object call() throws Exception {
            for (int i = 0; i < 20 && this.iterator.hasNext(); ++i) {
                Long processId = this.iterator.next();
                try {
                    SProcessInstance processInstance = this.processInstanceService.getProcessInstance(processId);
                    SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
                    ProcessInstanceState state = RestartProcessHandler.this.getState(processInstance.getStateId());
                    switch (state) {
                        case ABORTED: {
                            RestartProcessHandler.this.handleCompletion(processInstance, this.logger, this.activityInstanceService, this.workService, this.flowNodeStateManager);
                            break;
                        }
                        case CANCELLED: {
                            RestartProcessHandler.this.handleCompletion(processInstance, this.logger, this.activityInstanceService, this.workService, this.flowNodeStateManager);
                            break;
                        }
                        case COMPLETED: {
                            RestartProcessHandler.this.handleCompletion(processInstance, this.logger, this.activityInstanceService, this.workService, this.flowNodeStateManager);
                            break;
                        }
                        case COMPLETING: {
                            RestartProcessHandler.this.restartConnector(processDefinition, processInstance, ConnectorEvent.ON_FINISH, this.processExecutor);
                            break;
                        }
                        case INITIALIZING: {
                            RestartProcessHandler.this.restartConnector(processDefinition, processInstance, ConnectorEvent.ON_ENTER, this.processExecutor);
                            break;
                        }
                    }
                    continue;
                }
                catch (SBonitaException e) {
                    throw new RestartException("Unable to restart the process " + processId, e);
                }
            }
            return null;
        }
    }
}

