/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.api.ParentContainerResolver;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.persistence.PersistentObject;

public class DataExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    public static final String TIME = "time";
    private final DataInstanceService dataService;
    private final ParentContainerResolver parentContainerResolver;

    public DataExpressionExecutorStrategy(DataInstanceService dataService, ParentContainerResolver parentContainerResolver) {
        this.dataService = dataService;
        this.parentContainerResolver = parentContainerResolver;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionDependencyMissingException, SExpressionEvaluationException {
        return this.evaluate(Collections.singletonList(expression), context, resolvedExpressions, containerState).get(0);
    }

    @Override
    public void validate(SExpression expression) throws SInvalidExpressionException {
        super.validate(expression);
        if (!SourceVersion.isIdentifier(expression.getContent())) {
            throw new SInvalidExpressionException(expression.getContent() + " is not a valid data name in expression : " + expression, expression.getName());
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_VARIABLE;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionDependencyMissingException, SExpressionEvaluationException {
        int maxExpressionSize = expressions.size();
        ArrayList<String> dataNames = new ArrayList<String>(maxExpressionSize);
        HashMap<String, Serializable> results = new HashMap<String, Serializable>(maxExpressionSize);
        for (SExpression sExpression : expressions) {
            String dataName = sExpression.getContent();
            if (context.containsKey(dataName)) {
                Serializable value = (Serializable)context.get(dataName);
                results.put(dataName, value);
                continue;
            }
            dataNames.add(dataName);
        }
        if (dataNames.isEmpty()) {
            return this.buildExpressionResultSameOrderAsInputList(expressions, results);
        }
        if (context == null || !context.containsKey("containerId") || !context.containsKey("containerType")) {
            throw new SExpressionDependencyMissingException("The context to evaluate the data '" + dataNames + "' was not set");
        }
        try {
            List<PersistentObject> dataInstances;
            long containerId = (Long)context.get("containerId");
            String containerType = (String)context.get("containerType");
            Long time = (Long)context.get(TIME);
            if (time != null) {
                dataInstances = this.dataService.getSADataInstances(containerId, containerType, this.parentContainerResolver, dataNames, time);
                for (PersistentObject dataInstance : dataInstances) {
                    dataNames.remove(dataInstance.getName());
                    results.put(dataInstance.getName(), dataInstance.getValue());
                }
            }
            dataInstances = this.dataService.getDataInstances(dataNames, containerId, containerType, this.parentContainerResolver);
            for (PersistentObject dataInstance : dataInstances) {
                dataNames.remove(dataInstance.getName());
                results.put(dataInstance.getName(), dataInstance.getValue());
            }
            if (!dataNames.isEmpty()) {
                throw new SExpressionEvaluationException("Some data were not found " + dataNames, (String)dataNames.get(0));
            }
            return this.buildExpressionResultSameOrderAsInputList(expressions, results);
        }
        catch (SDataInstanceException e) {
            throw new SExpressionEvaluationException((Throwable)e, null);
        }
    }

    private List<Object> buildExpressionResultSameOrderAsInputList(List<SExpression> expressions, Map<String, Serializable> results) {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(results.get(expression.getContent()));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return true;
    }
}

