/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.impl.AbstractGroovyScriptExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyScriptExpressionExecutorCacheStrategy
extends AbstractGroovyScriptExpressionExecutorStrategy {
    public static final String GROOVY_SCRIPT_CACHE_NAME = "GROOVY_SCRIPT_CACHE_NAME";
    public static final String SCRIPT_KEY = "SCRIPT_";
    public static final String SHELL_KEY = "SHELL_";
    private final CacheService cacheService;
    private final ClassLoaderService classLoaderService;
    private final TechnicalLoggerService logger;
    private final boolean debugEnabled;
    private static int counter;

    public GroovyScriptExpressionExecutorCacheStrategy(CacheService cacheService, ClassLoaderService classLoaderService, TechnicalLoggerService logger) {
        this.cacheService = cacheService;
        this.classLoaderService = classLoaderService;
        this.logger = logger;
        this.debugEnabled = logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG);
    }

    protected synchronized String generateScriptName() {
        return "BScript" + ++counter + ".groovy";
    }

    Class getScriptFromCache(final String expressionContent, Long definitionId) throws SCacheException, SClassLoaderException {
        if (definitionId == null) {
            throw new SBonitaRuntimeException("Unable to evaluate expression without a definitionId");
        }
        GroovyShell shell = this.getShell(definitionId);
        String key = this.getScriptKey(expressionContent);
        GroovyCodeSource gcs = (GroovyCodeSource)this.cacheService.get(GROOVY_SCRIPT_CACHE_NAME, key);
        if (gcs == null) {
            gcs = AccessController.doPrivileged(new PrivilegedAction<GroovyCodeSource>(){

                @Override
                public GroovyCodeSource run() {
                    return new GroovyCodeSource(expressionContent, GroovyScriptExpressionExecutorCacheStrategy.this.generateScriptName(), "/groovy/shell");
                }
            });
            this.cacheService.store(GROOVY_SCRIPT_CACHE_NAME, (Serializable)((Object)key), gcs);
        }
        return shell.getClassLoader().parseClass(gcs, true);
    }

    private String getScriptKey(String expressionContent) {
        return SCRIPT_KEY + expressionContent.hashCode();
    }

    GroovyShell getShell(Long definitionId) throws SClassLoaderException, SCacheException {
        String key = SHELL_KEY + definitionId;
        GroovyShell shell = (GroovyShell)this.cacheService.get(GROOVY_SCRIPT_CACHE_NAME, key);
        if (shell == null) {
            ClassLoader classLoader = this.getClassLoaderForShell(definitionId);
            if (this.debugEnabled) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Create a new groovy classloader for " + definitionId + " " + classLoader);
            }
            shell = new GroovyShell(classLoader);
            this.cacheService.store(GROOVY_SCRIPT_CACHE_NAME, (Serializable)((Object)key), shell);
        }
        return shell;
    }

    private ClassLoader getClassLoaderForShell(Long definitionId) throws SClassLoaderException {
        ClassLoader classLoader = definitionId == null ? Thread.currentThread().getContextClassLoader() : this.classLoaderService.getLocalClassLoader("PROCESS", definitionId);
        return classLoader;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        String expressionContent = expression.getContent();
        String expressionName = expression.getName();
        try {
            Binding binding = new Binding(context);
            Script script = InvokerHelper.createScript((Class)this.getScriptFromCache(expressionContent, (Long)context.get("processDefinitionId")), (Binding)binding);
            script.setBinding(binding);
            return script.run();
        }
        catch (MissingPropertyException e) {
            String property = e.getProperty();
            StringBuilder builder = new StringBuilder("Expression ");
            builder.append(expressionName).append(" with content = <").append(expressionContent).append("> depends on ").append(property).append(" is neither defined in the script nor in dependencies.");
            throw new SExpressionEvaluationException(builder.toString(), e, expressionName);
        }
        catch (GroovyRuntimeException e) {
            throw new SExpressionEvaluationException((Throwable)e, expressionName);
        }
        catch (SCacheException e) {
            throw new SExpressionEvaluationException("Problem accessing the Script Cache from GroovyScriptExpressionExecutorCacheStrategy.", e, expressionName);
        }
        catch (SClassLoaderException e) {
            throw new SExpressionEvaluationException("Unable to retrieve the correct classloader to execute the groovy script : " + expression, e, expressionName);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = "No message";
            }
            throw new SExpressionEvaluationException("Groovy script throws an exception of type " + e.getClass() + " with message = " + message + System.getProperty("line.separator") + "Expression : " + expression, e, expressionName);
        }
    }
}

