/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.home;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHome;
import org.bonitasoft.engine.io.IOUtil;
import org.bonitasoft.engine.io.PropertiesManager;

public class BonitaHomeServer
extends BonitaHome {
    private static final String VERSION_FILE_NAME = "VERSION";
    private static final String TENANT_CONFIGURATION_FILE = "bonita-server.properties";
    private static final String CONF = "conf";
    private static final String REPORTS = "reports";
    private static final String BONITA_HOME_SERVER = "server";
    private static final String BONITA_HOME_PLATFORM = "platform";
    private static final String BONITA_HOME_TENANTS = "tenants";
    private static final String BONITA_HOME_PROCESSES = "processes";
    private static final String BONITA_HOME_WORK = "work";
    private static final String BONITA_HOME_TENANT_TEMPLATE = "tenant-template";
    private static final String SERVER_API_IMPLEMENTATION = "serverApi";
    private String tenantsPath;
    private String platformPath;
    private String serverPath;
    private Properties platformProperties = null;
    private String version;
    public static final BonitaHomeServer INSTANCE = new BonitaHomeServer();

    private BonitaHomeServer() {
    }

    public static BonitaHomeServer getInstance() {
        return INSTANCE;
    }

    public String getBonitaHomeProperty(String propertyName) throws IllegalStateException {
        try {
            return this.getPlatformProperties().getProperty(propertyName);
        }
        catch (BonitaHomeNotSetException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getServerAPIImplementation() throws IllegalStateException {
        return this.getBonitaHomeProperty(SERVER_API_IMPLEMENTATION);
    }

    public String getBonitaHomeServerFolder() throws BonitaHomeNotSetException {
        if (this.serverPath == null) {
            StringBuilder path = new StringBuilder(this.getBonitaHomeFolder());
            path.append(File.separatorChar);
            path.append(BONITA_HOME_SERVER);
            this.serverPath = path.toString();
        }
        return this.serverPath;
    }

    public String getPlatformFolder() throws BonitaHomeNotSetException {
        if (this.platformPath == null) {
            StringBuilder path = new StringBuilder(this.getBonitaHomeServerFolder());
            path.append(File.separatorChar);
            path.append(BONITA_HOME_PLATFORM);
            this.platformPath = path.toString();
        }
        return this.platformPath;
    }

    public String getPlatformConfFolder() throws BonitaHomeNotSetException {
        StringBuilder path = new StringBuilder(this.getPlatformFolder());
        path.append(File.separatorChar);
        path.append(CONF);
        return path.toString();
    }

    public File getPlatformFile() throws BonitaHomeNotSetException {
        String platformFolder = this.getPlatformConfFolder();
        return new File(platformFolder + File.separatorChar + "bonita-platform.properties");
    }

    public String getTenantsFolder() throws BonitaHomeNotSetException {
        if (this.tenantsPath == null) {
            this.tenantsPath = this.getBonitaHomeServerFolder() + File.separatorChar + BONITA_HOME_TENANTS;
        }
        return this.tenantsPath;
    }

    public String getProcessesFolder(long tenantId) throws BonitaHomeNotSetException {
        return this.getTenantFolder(tenantId) + File.separatorChar + BONITA_HOME_WORK + File.separatorChar + BONITA_HOME_PROCESSES;
    }

    public String getProcessFolder(long tenantId, long processDefinitionId) throws BonitaHomeNotSetException {
        return this.getTenantFolder(tenantId) + File.separatorChar + BONITA_HOME_WORK + File.separatorChar + BONITA_HOME_PROCESSES + File.separatorChar + processDefinitionId;
    }

    public String getTenantFolder(long tenantId) throws BonitaHomeNotSetException {
        return this.getTenantsFolder() + File.separatorChar + tenantId;
    }

    public String getTenantWorkFolder(long tenantId) throws BonitaHomeNotSetException {
        return this.getTenantFolder(tenantId) + File.separatorChar + BONITA_HOME_WORK;
    }

    public String getTenantConfFolder(long tenantId) throws BonitaHomeNotSetException {
        return this.getTenantsFolder() + File.separatorChar + tenantId + File.separatorChar + CONF;
    }

    public String getTenantReportFolder(long tenantId) throws BonitaHomeNotSetException {
        return this.getTenantsFolder() + File.separatorChar + tenantId + File.separatorChar + REPORTS;
    }

    public String getTenantTemplateFolder() throws BonitaHomeNotSetException {
        return this.getPlatformFolder() + File.separatorChar + BONITA_HOME_TENANT_TEMPLATE;
    }

    protected void refresh() {
        this.platformPath = null;
        this.serverPath = null;
        this.tenantsPath = null;
        this.platformProperties = null;
    }

    public Properties getPlatformProperties() throws BonitaHomeNotSetException, IOException {
        if (this.platformProperties == null) {
            this.platformProperties = PropertiesManager.getProperties((File)this.getPlatformFile());
        }
        return this.platformProperties;
    }

    public String getVersion() {
        if (this.version == null) {
            String platformConfFolder = null;
            try {
                platformConfFolder = this.getPlatformConfFolder();
                File file = new File(new File(platformConfFolder), VERSION_FILE_NAME);
                this.version = IOUtil.read((File)file);
            }
            catch (Exception e) {
                this.buildUnreadableVersionException(platformConfFolder);
            }
            if (this.version == null) {
                this.buildUnreadableVersionException(platformConfFolder);
            }
        }
        return this.version;
    }

    private void buildUnreadableVersionException(String platformConfFolder) {
        throw new IllegalStateException("VERSION file not present or invalid in folder: " + platformConfFolder);
    }

    public Properties getTenantProperties(long tenantId) throws BonitaHomeNotSetException, IOException {
        return PropertiesManager.getProperties((File)new File(this.getTenantConfFolder(tenantId) + File.separatorChar + TENANT_CONFIGURATION_FILE));
    }
}

