/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.log.technical;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechnicalLoggerSLF4JImpl
implements TechnicalLoggerService {
    private final Map<Class<?>, Boolean> classIsTraceLoggable = new HashMap();
    private final Map<Class<?>, Boolean> classIsDebugLoggable = new HashMap();
    private final Map<Class<?>, Boolean> classIsInfoLoggable = new HashMap();
    private final Map<Class<?>, Boolean> classIsWarnLoggable = new HashMap();
    private final Map<Class<?>, Boolean> classIsErrorLoggable = new HashMap();
    private final Map<Class<?>, Logger> classLoggers = new HashMap();
    private String hostname = null;
    private final long tenantId;

    public TechnicalLoggerSLF4JImpl() {
        this(-1L);
    }

    public TechnicalLoggerSLF4JImpl(long tenantId) {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.tenantId = tenantId;
    }

    @Override
    public void log(Class<?> callerClass, TechnicalLogSeverity severity, Throwable t) {
        this.log(callerClass, severity, t.getMessage(), t);
    }

    @Override
    public void log(Class<?> callerClass, TechnicalLogSeverity severity, String message) {
        Logger logger = this.getLogger(callerClass);
        String loggedMessage = this.getContextMessage() + message;
        switch (severity) {
            case TRACE: {
                logger.trace(loggedMessage);
                break;
            }
            case DEBUG: {
                logger.debug(loggedMessage);
                break;
            }
            case INFO: {
                logger.info(loggedMessage);
                break;
            }
            case WARNING: {
                logger.warn(loggedMessage);
                break;
            }
            case ERROR: {
                logger.error(loggedMessage);
                break;
            }
            default: {
                logger.error("Trying to log using an unknow severity, using ERROR instead:" + severity.name());
                logger.error(loggedMessage);
            }
        }
    }

    @Override
    public void log(Class<?> callerClass, TechnicalLogSeverity severity, String message, Throwable t) {
        String loggedMessage = this.getContextMessage() + message;
        switch (severity) {
            case TRACE: {
                this.getLogger(callerClass).trace(loggedMessage, t);
                break;
            }
            case DEBUG: {
                this.getLogger(callerClass).debug(loggedMessage, t);
                break;
            }
            case INFO: {
                this.getLogger(callerClass).info(loggedMessage, t);
                break;
            }
            case WARNING: {
                this.getLogger(callerClass).warn(loggedMessage, t);
                break;
            }
            case ERROR: {
                this.getLogger(callerClass).error(loggedMessage, t);
                break;
            }
            default: {
                this.getLogger(callerClass).error("Trying to log using an unknow severity, using ERROR instead:" + severity.name());
                this.getLogger(callerClass).error(loggedMessage);
            }
        }
    }

    @Override
    public boolean isLoggable(Class<?> callerClass, TechnicalLogSeverity severity) {
        switch (severity) {
            case TRACE: {
                return this.isEnabledForLevel(callerClass, this.classIsTraceLoggable, severity);
            }
            case DEBUG: {
                return this.isEnabledForLevel(callerClass, this.classIsDebugLoggable, severity);
            }
            case INFO: {
                return this.isEnabledForLevel(callerClass, this.classIsInfoLoggable, severity);
            }
            case WARNING: {
                return this.isEnabledForLevel(callerClass, this.classIsWarnLoggable, severity);
            }
            case ERROR: {
                return this.isEnabledForLevel(callerClass, this.classIsErrorLoggable, severity);
            }
        }
        this.getLogger(callerClass).error("Trying to log using an unknow severity, using ERROR instead:" + severity.name());
        return this.isEnabledForLevel(callerClass, this.classIsErrorLoggable, TechnicalLogSeverity.ERROR);
    }

    private boolean isEnabledForLevel(Class<?> callerClass, Map<Class<?>, Boolean> loggableMap, TechnicalLogSeverity severity) {
        Boolean isLevelEnabled = loggableMap.get(callerClass);
        if (isLevelEnabled == null) {
            switch (severity) {
                case DEBUG: {
                    isLevelEnabled = this.getLogger(callerClass).isDebugEnabled();
                    break;
                }
                case ERROR: {
                    isLevelEnabled = this.getLogger(callerClass).isErrorEnabled();
                    break;
                }
                case INFO: {
                    isLevelEnabled = this.getLogger(callerClass).isInfoEnabled();
                    break;
                }
                case TRACE: {
                    isLevelEnabled = this.getLogger(callerClass).isTraceEnabled();
                    break;
                }
                case WARNING: {
                    isLevelEnabled = this.getLogger(callerClass).isWarnEnabled();
                    break;
                }
                default: {
                    isLevelEnabled = false;
                }
            }
            loggableMap.put(callerClass, isLevelEnabled);
        }
        return isLevelEnabled;
    }

    private Logger getLogger(Class<?> clazz) {
        Logger logger = this.classLoggers.get(clazz);
        if (logger == null) {
            logger = LoggerFactory.getLogger(clazz);
            this.classLoggers.put(clazz, logger);
        }
        return logger;
    }

    private String getContextMessage() {
        return this.getThreadIdMessage() + this.getHostNameMessage() + this.getTenantIdMessage();
    }

    private String getThreadIdMessage() {
        long threadId = Thread.currentThread().getId();
        return "THREAD_ID=" + threadId + " | ";
    }

    private String getHostNameMessage() {
        return this.hostname != null && !this.hostname.isEmpty() ? "HOSTNAME=" + this.hostname + " | " : "";
    }

    private String getTenantIdMessage() {
        return this.tenantId != -1L ? "TENANT_ID=" + this.tenantId + " | " : "";
    }
}

