/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.api.impl.DocumentHelper;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.operation.AbstractDocumentLeftOperandHandler;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class DocumentListLeftOperandHandler
extends AbstractDocumentLeftOperandHandler {
    public final DocumentHelper documentHelper;
    final DocumentService documentService;

    public DocumentListLeftOperandHandler(DocumentService documentService, ActivityInstanceService activityInstanceService, SessionAccessor sessionAccessor, SessionService sessionService, ProcessDefinitionService processDefinitionService, ProcessInstanceService processInstanceService) {
        super(activityInstanceService, sessionAccessor, sessionService);
        this.documentService = documentService;
        this.documentHelper = new DocumentHelper(documentService, processDefinitionService, processInstanceService);
    }

    public DocumentListLeftOperandHandler(ActivityInstanceService activityInstanceService, SessionAccessor sessionAccessor, SessionService sessionService, DocumentService documentService, DocumentHelper documentHelper) {
        super(activityInstanceService, sessionAccessor, sessionService);
        this.documentHelper = documentHelper;
        this.documentService = documentService;
    }

    @Override
    public Object update(SLeftOperand sLeftOperand, Map<String, Object> inputValues, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        List<DocumentValue> documentList = this.toCheckedList(newValue);
        String documentName = sLeftOperand.getName();
        try {
            long processInstanceId = this.getProcessInstanceId(containerId, containerType);
            this.documentHelper.setDocumentList(documentList, documentName, processInstanceId, this.getAuthorId());
            return documentList;
        }
        catch (SBonitaException e) {
            throw new SOperationExecutionException(e.getMessage(), e);
        }
    }

    public List<DocumentValue> toCheckedList(Object newValue) throws SOperationExecutionException {
        if (!(newValue instanceof List)) {
            throw new SOperationExecutionException("Document operation only accepts an expression returning a list of DocumentValue");
        }
        for (Object item : (List)newValue) {
            if (item instanceof DocumentValue) continue;
            throw new SOperationExecutionException("Document operation only accepts an expression returning a list of DocumentValue");
        }
        return (List)newValue;
    }

    @Override
    public String getType() {
        return "DOCUMENT_LIST";
    }

    @Override
    public void delete(SLeftOperand leftOperand, long containerId, String containerType) throws SOperationExecutionException {
        throw new SOperationExecutionException("Deleting a document is not supported");
    }

    @Override
    public void loadLeftOperandInContext(SLeftOperand sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) {
    }

    @Override
    public void loadLeftOperandInContext(List<SLeftOperand> sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) throws SBonitaReadException {
    }
}

