/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.core.data.instance.TransientDataService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.LeftOperandHandler;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceNotFoundException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.expression.exception.SExpressionException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class TransientDataLeftOperandHandler
implements LeftOperandHandler {
    private static final String TRANSIENT_DATA = "%TRANSIENT_DATA%_";
    private final TransientDataService transientDataService;
    private final FlowNodeInstanceService flownodeInstanceService;
    private final ProcessDefinitionService processDefinitionService;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final TechnicalLoggerService logger;

    public TransientDataLeftOperandHandler(TransientDataService transientDataService, FlowNodeInstanceService flownodeInstanceService, ProcessDefinitionService processDefinitionService, BPMInstancesCreator bpmInstancesCreator, TechnicalLoggerService logger) {
        this.transientDataService = transientDataService;
        this.flownodeInstanceService = flownodeInstanceService;
        this.processDefinitionService = processDefinitionService;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.logger = logger;
    }

    @Override
    public String getType() {
        return "TRANSIENT_DATA";
    }

    @Override
    public Object update(SLeftOperand sLeftOperand, Map<String, Object> inputValues, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        try {
            SDataInstance dataInstance = (SDataInstance)inputValues.get(TRANSIENT_DATA + sLeftOperand.getName());
            if (dataInstance == null) {
                dataInstance = this.retrieve(sLeftOperand, containerId, containerType);
            }
            EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
            descriptor.addField("value", newValue);
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "The value of the transient data " + sLeftOperand.getName() + " of " + containerId + " " + containerType + " is being updated, be carefull if the application server is restarted this new value will be lost and the data will be reset to its initial value. " + "We advise you to change the design of your process. If you understand the risks and want to hide this warning, change the logging level of this class to error.");
            this.transientDataService.updateDataInstance(dataInstance, descriptor);
            return newValue;
        }
        catch (SDataInstanceException e) {
            throw new SOperationExecutionException("Unable to update the transient data", e);
        }
        catch (SBonitaReadException e) {
            throw new SOperationExecutionException("Unable to update the transient data", e);
        }
    }

    @Override
    public void delete(SLeftOperand leftOperand, long containerId, String containerType) throws SOperationExecutionException {
        throw new SOperationExecutionException("Deleting a transient data is not supported");
    }

    @Override
    public void loadLeftOperandInContext(SLeftOperand sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) throws SBonitaReadException {
        Long containerId = expressionContext.getContainerId();
        String containerType = expressionContext.getContainerType();
        String name = sLeftOperand.getName();
        SDataInstance dataInstance = this.retrieve(sLeftOperand, containerId, containerType);
        contextToSet.put(TRANSIENT_DATA + name, dataInstance);
        if (!contextToSet.containsKey(name)) {
            contextToSet.put(name, dataInstance.getValue());
        }
    }

    private SDataInstance retrieve(SLeftOperand sLeftOperand, Long containerId, String containerType) throws SBonitaReadException {
        try {
            return this.transientDataService.getDataInstance(sLeftOperand.getName(), containerId, containerType);
        }
        catch (SDataInstanceNotFoundException e) {
            try {
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "The value of the transient data " + sLeftOperand.getName() + "  " + containerId + " " + containerType);
                TransientDataLeftOperandHandler.reevaluateTransientData(sLeftOperand.getName(), containerId, containerType, this.flownodeInstanceService, this.processDefinitionService, this.bpmInstancesCreator);
                return this.transientDataService.getDataInstance(sLeftOperand.getName(), containerId, containerType);
            }
            catch (SDataInstanceException e1) {
                throw new SBonitaReadException("Unable to read the transient data", e);
            }
        }
        catch (SDataInstanceException e) {
            throw new SBonitaReadException("Unable to read the transient data", e);
        }
    }

    public static void reevaluateTransientData(String name, long containerId, String containerType, FlowNodeInstanceService flowNodeInstanceService, ProcessDefinitionService processDefinitionService, BPMInstancesCreator bpmInstancesCreator) throws SBonitaReadException {
        try {
            SFlowNodeInstance flowNodeInstance = flowNodeInstanceService.getFlowNodeInstance(containerId);
            long flowNodeDefinitionId = flowNodeInstance.getFlowNodeDefinitionId();
            long processDefinitionId = flowNodeInstance.getProcessDefinitionId();
            SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(processDefinitionId);
            SActivityDefinition flowNode = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(flowNodeDefinitionId);
            List<SDataDefinition> sDataDefinitions = flowNode.getSDataDefinitions();
            SDataDefinition theTransientData = null;
            for (SDataDefinition sDataDefinition : sDataDefinitions) {
                if (!sDataDefinition.getName().equals(name)) continue;
                theTransientData = sDataDefinition;
                break;
            }
            if (theTransientData == null) {
                throw new SBonitaReadException("Transient data was not found and we were unable to reevaluate it because it was not found in the definition, name=<" + name + "> process definition=<" + processDefinition.getName() + "," + processDefinition.getVersion() + "> flow node=<" + flowNode.getName() + ">");
            }
            bpmInstancesCreator.createDataInstances(Arrays.asList(theTransientData), containerId, DataInstanceContainer.ACTIVITY_INSTANCE, new SExpressionContext((Long)containerId, containerType, processDefinitionId));
        }
        catch (SDataInstanceException e) {
            TransientDataLeftOperandHandler.throwBonitaReadException(name, e);
        }
        catch (SExpressionException e) {
            TransientDataLeftOperandHandler.throwBonitaReadException(name, e);
        }
        catch (SFlowNodeNotFoundException e) {
            TransientDataLeftOperandHandler.throwBonitaReadException(name, e);
        }
        catch (SFlowNodeReadException e) {
            TransientDataLeftOperandHandler.throwBonitaReadException(name, e);
        }
        catch (SProcessDefinitionReadException e) {
            TransientDataLeftOperandHandler.throwBonitaReadException(name, e);
        }
        catch (SProcessDefinitionNotFoundException e) {
            TransientDataLeftOperandHandler.throwBonitaReadException(name, e);
        }
    }

    private static void throwBonitaReadException(String name, Exception e) throws SBonitaReadException {
        throw new SBonitaReadException("Transient data was not found and we were unable to reevaluate it, name=<" + name + ">", e);
    }

    @Override
    public void loadLeftOperandInContext(List<SLeftOperand> sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) throws SBonitaReadException {
        for (SLeftOperand leftOperand : sLeftOperand) {
            this.loadLeftOperandInContext(leftOperand, expressionContext, contextToSet);
        }
    }
}

