/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.platform.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.cache.PlatformCacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.platform.exception.SDeletingActivatedTenantException;
import org.bonitasoft.engine.platform.exception.SPlatformCreationException;
import org.bonitasoft.engine.platform.exception.SPlatformDeletionException;
import org.bonitasoft.engine.platform.exception.SPlatformNotFoundException;
import org.bonitasoft.engine.platform.exception.SPlatformUpdateException;
import org.bonitasoft.engine.platform.exception.STenantActivationException;
import org.bonitasoft.engine.platform.exception.STenantAlreadyExistException;
import org.bonitasoft.engine.platform.exception.STenantCreationException;
import org.bonitasoft.engine.platform.exception.STenantDeactivationException;
import org.bonitasoft.engine.platform.exception.STenantDeletionException;
import org.bonitasoft.engine.platform.exception.STenantException;
import org.bonitasoft.engine.platform.exception.STenantNotFoundException;
import org.bonitasoft.engine.platform.exception.STenantUpdateException;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.platform.model.SPlatformProperties;
import org.bonitasoft.engine.platform.model.STenant;
import org.bonitasoft.engine.platform.model.builder.STenantBuilderFactory;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.TenantPersistenceService;
import org.bonitasoft.engine.services.UpdateDescriptor;

public class PlatformServiceImpl
implements PlatformService {
    private static final String TENANT = "TENANT";
    private static final String QUERY_GET_TENANT_BY_NAME = "getTenantByName";
    private static final String QUERY_GET_TENANT_BY_ID = "getTenantById";
    private static final String LOG_UPDATE_TENANT = "updateTenant";
    private static final String LOG_ACTIVATE_TENANT = "activateTenant";
    private static final String LOG_DELETE_TENANT_OBJECTS = "deleteTenantObjects";
    private static final String LOG_DEACTIVE_TENANT = "deactiveTenant";
    private static final String LOG_UPDATE_PLATFORM = "updatePlatform";
    private static final String LOG_GET_TENANTS = "getTenants";
    private static final String LOG_GET_PLATFORM = "getPlatform";
    private static final String LOG_DELETE_TENANT = "deleteTenant";
    private static final String LOG_DELETE_PLATFORM = "deletePlatform";
    private static final String LOG_CREATE_TENANT = "createTenant";
    private static final String LOG_CREATE_PLATFORM = "createPlatform";
    private static final String LOG_IS_PLATFORM_CREATED = "isPlatformCreated";
    private static final String QUERY_GET_DEFAULT_TENANT = "getDefaultTenant";
    private static final String QUERY_GET_NUMBER_OF_TENANTS = "getNumberOfTenants";
    private static final String QUERY_GET_TENANTS_BY_IDS = "getTenantsByIds";
    private static final String QUERY_GET_PLATFORM = "getPlatform";
    private static String CACHE_KEY = "PLATFORM";
    private final PersistenceService platformPersistenceService;
    private final List<TenantPersistenceService> tenantPersistenceServices;
    private final TechnicalLoggerService logger;
    private final boolean isTraced;
    private final PlatformCacheService platformCacheService;
    private final SPlatformProperties sPlatformProperties;
    private final Recorder recorder;
    private final DataSource datasource;
    private final String statementDelimiter;
    private final List<String> sqlFolders;

    public PlatformServiceImpl(PersistenceService platformPersistenceService, Recorder recorder, List<TenantPersistenceService> tenantPersistenceServices, TechnicalLoggerService logger, PlatformCacheService platformCacheService, SPlatformProperties sPlatformProperties, DataSource datasource, String sqlFolder, String statementDelimiter) {
        this(platformPersistenceService, recorder, tenantPersistenceServices, logger, platformCacheService, sPlatformProperties, datasource, Arrays.asList(sqlFolder), statementDelimiter);
    }

    public PlatformServiceImpl(PersistenceService platformPersistenceService, Recorder recorder, List<TenantPersistenceService> tenantPersistenceServices, TechnicalLoggerService logger, PlatformCacheService platformCacheService, SPlatformProperties sPlatformProperties, DataSource datasource, List<String> sqlFolders, String statementDelimiter) {
        this.platformPersistenceService = platformPersistenceService;
        this.tenantPersistenceServices = tenantPersistenceServices;
        this.logger = logger;
        this.platformCacheService = platformCacheService;
        this.sPlatformProperties = sPlatformProperties;
        this.recorder = recorder;
        this.datasource = datasource;
        this.sqlFolders = sqlFolders;
        this.statementDelimiter = statementDelimiter;
        this.isTraced = logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
    }

    @Override
    public void createTables() throws SPlatformCreationException {
        try {
            this.executeSQLResources(Arrays.asList("createTables.sql", "createQuartzTables.sql", "postCreateStructure.sql"));
        }
        catch (IOException e) {
            throw new SPlatformCreationException(e);
        }
        catch (SQLException e) {
            throw new SPlatformCreationException(e);
        }
    }

    protected void executeSQLResources(List<String> sqlFiles) throws IOException, SQLException {
        this.executeSQLResources(sqlFiles, Collections.<String, String>emptyMap());
    }

    protected void executeSQLResources(List<String> sqlFiles, Map<String, String> replacements) throws IOException, SQLException {
        for (String sqlFile : sqlFiles) {
            this.executeSQLResource(sqlFile, replacements);
        }
    }

    private String getSQLFileContent(String sqlFolder, String sqlFile) {
        String resourcePath = sqlFolder + "/" + sqlFile;
        try {
            URL url = this.getClass().getResource(resourcePath);
            if (url != null) {
                byte[] content = IOUtil.getAllContentFrom(url);
                if (content != null) {
                    return new String(content);
                }
            } else {
                File sqlResource = new File(sqlFolder, sqlFile);
                if (sqlResource.exists()) {
                    return new String(IOUtil.getAllContentFrom(sqlResource));
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    protected void executeSQLResource(String sqlFile, Map<String, String> replacements) throws IOException, SQLException {
        for (String sqlFolder : this.sqlFolders) {
            String fileContent = this.getSQLFileContent(sqlFolder, sqlFile);
            String path = sqlFolder + File.separator + sqlFile;
            if (fileContent != null) {
                int lastIndex;
                String regex;
                ArrayList<String> commands;
                String lastCommand;
                int index;
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Processing SQL resource : " + path);
                }
                if ((index = (lastCommand = (String)(commands = new ArrayList<String>(Arrays.asList(fileContent.split(regex = this.statementDelimiter.concat("\r?\n"))))).get(lastIndex = commands.size() - 1)).lastIndexOf(this.statementDelimiter)) > 0) {
                    lastCommand = lastCommand.substring(0, index);
                    commands.remove(lastIndex);
                    commands.add(lastCommand);
                }
                this.doExecuteSQLThroughJDBC(commands, replacements);
                continue;
            }
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "SQL resource file not found: " + path);
        }
    }

    private void doExecuteSQLThroughJDBC(List<String> commands, Map<String, String> replacements) throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        try {
            for (String command : commands) {
                if (command.trim().length() <= 0) continue;
                Statement stmt = connection.createStatement();
                String filledCommand = null;
                try {
                    if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                        this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, command);
                    }
                    filledCommand = this.fillTemplate(command, replacements);
                    if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                        this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Executing the following command : " + filledCommand);
                    }
                    stmt.execute(filledCommand);
                }
                catch (SQLException e) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Following SQL command failed: " + filledCommand);
                    throw e;
                }
                finally {
                    stmt.close();
                }
            }
            connection.commit();
        }
        catch (SQLException sqe) {
            connection.rollback();
            throw sqe;
        }
        finally {
            connection.close();
        }
    }

    private String fillTemplate(String command, Map<String, String> replacements) {
        String trimmedCommand = command.trim();
        if (trimmedCommand.isEmpty() || replacements == null) {
            return trimmedCommand;
        }
        for (Map.Entry<String, String> tableMapping : replacements.entrySet()) {
            String stringToReplace = tableMapping.getKey();
            String value = tableMapping.getValue();
            trimmedCommand = trimmedCommand.replaceAll(stringToReplace, value);
        }
        return trimmedCommand;
    }

    private Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    @Override
    public void createPlatform(SPlatform platform) throws SPlatformCreationException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_CREATE_PLATFORM));
        }
        try {
            this.platformPersistenceService.insert(platform);
            this.cachePlatform(platform);
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_CREATE_PLATFORM));
            }
        }
        catch (SPersistenceException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_PLATFORM, e));
            }
            throw new SPlatformCreationException("Unable to insert the platform row : " + e.getMessage(), e);
        }
    }

    @Override
    public long createTenant(STenant tenant) throws STenantCreationException, STenantAlreadyExistException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_CREATE_TENANT));
        }
        this.checkIfTenantAlreadyExists(tenant);
        InsertRecord insertRecord = new InsertRecord(tenant);
        SInsertEvent insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent(TENANT).setObject(tenant).done();
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT, e));
            }
            throw new STenantCreationException("Unable to insert the tenant row : " + e.getMessage(), e);
        }
        this.initializeTenant(tenant);
        return tenant.getId();
    }

    private void checkIfTenantAlreadyExists(STenant tenant) throws STenantAlreadyExistException {
        block3: {
            try {
                String tenantName = tenant.getName();
                STenant existingTenant = this.getTenantByName(tenantName);
                if (existingTenant != null) {
                    throw new STenantAlreadyExistException("Unable to create the tenant " + tenantName + " : it already exists.");
                }
            }
            catch (STenantNotFoundException e) {
                if (!this.isTraced) break block3;
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_CREATE_TENANT, e));
            }
        }
    }

    private void initializeTenant(STenant tenant) throws STenantCreationException {
        try {
            this.executeSQLResources(Arrays.asList("initTenantTables.sql"), this.buildReplacements(tenant));
        }
        catch (IOException e) {
            throw new STenantCreationException(e);
        }
        catch (SQLException e) {
            throw new STenantCreationException(e);
        }
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_CREATE_TENANT));
        }
    }

    private Map<String, String> buildReplacements(STenant tenant) {
        return Collections.singletonMap("\\$\\{tenantid\\}", Long.toString(tenant.getId()));
    }

    @Override
    public void initializePlatformStructure() throws SPlatformCreationException {
        try {
            this.executeSQLResources(Arrays.asList("initTables.sql"));
        }
        catch (IOException e) {
            throw new SPlatformCreationException(e);
        }
        catch (SQLException e) {
            throw new SPlatformCreationException(e);
        }
    }

    @Override
    public void deletePlatform() throws SPlatformDeletionException, SPlatformNotFoundException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DELETE_PLATFORM));
        }
        SPlatform platform = this.readPlatform();
        this.checkNotExistingTenant();
        try {
            this.platformPersistenceService.delete(platform);
            this.platformCacheService.clear(CACHE_KEY);
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_DELETE_PLATFORM));
            }
        }
        catch (SPersistenceException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_PLATFORM, e));
            }
            throw new SPlatformDeletionException("Unable to delete the platform row : " + e.getMessage(), e);
        }
        catch (SCacheException e) {
            throw new SPlatformDeletionException("Unable to delete the platform from cache : " + e.getMessage(), e);
        }
    }

    private void checkNotExistingTenant() throws SPlatformDeletionException {
        List<STenant> existingTenants;
        try {
            existingTenants = this.getTenants(new QueryOptions(0, 1, STenant.class, "id", OrderByType.ASC));
        }
        catch (STenantException e) {
            throw new SPlatformDeletionException(e);
        }
        if (existingTenants.size() > 0) {
            throw new SPlatformDeletionException("Some tenants still are in the system. Can not delete platform.");
        }
    }

    @Override
    public void deleteTables() throws SPlatformDeletionException {
        try {
            this.executeSQLResources(Arrays.asList("preDropStructure.sql", "dropQuartzTables.sql", "dropTables.sql"));
        }
        catch (IOException e) {
            throw new SPlatformDeletionException(e);
        }
        catch (SQLException e) {
            throw new SPlatformDeletionException(e);
        }
    }

    @Override
    public void deleteTenant(long tenantId) throws STenantDeletionException, STenantNotFoundException, SDeletingActivatedTenantException {
        STenant tenant;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DELETE_TENANT));
        }
        if ((tenant = this.getTenant(tenantId)).getStatus().equals("ACTIVATED")) {
            throw new SDeletingActivatedTenantException();
        }
        try {
            this.platformPersistenceService.delete(tenant);
        }
        catch (SPersistenceException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DELETE_TENANT, e));
            }
            throw new STenantDeletionException("Unable to delete the tenant : " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteTenantObjects(long tenantId) throws STenantDeletionException, STenantNotFoundException, SDeletingActivatedTenantException {
        STenant tenant;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DELETE_TENANT_OBJECTS));
        }
        if ((tenant = this.getTenant(tenantId)).getStatus().equals("ACTIVATED")) {
            throw new SDeletingActivatedTenantException();
        }
        Map<String, String> replacements = this.buildReplacements(tenant);
        try {
            this.executeSQLResources(Arrays.asList("deleteTenantObjects.sql"), replacements);
        }
        catch (IOException e) {
            throw new STenantDeletionException(e);
        }
        catch (SQLException e) {
            throw new STenantDeletionException(e);
        }
    }

    @Override
    public SPlatform getPlatform() throws SPlatformNotFoundException {
        try {
            SPlatform sPlatform = (SPlatform)this.platformCacheService.get(CACHE_KEY, CACHE_KEY);
            if (sPlatform == null) {
                sPlatform = this.readPlatform();
                this.cachePlatform(sPlatform);
            }
            return sPlatform;
        }
        catch (SCacheException e) {
            throw new SPlatformNotFoundException("Platform not present in cache.", e);
        }
    }

    private void cachePlatform(SPlatform platform) {
        try {
            this.platformCacheService.store(CACHE_KEY, (Serializable)((Object)CACHE_KEY), platform);
        }
        catch (SCacheException e) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Can't cache the platform, maybe the platform cache service is not started yet");
        }
    }

    private SPlatform readPlatform() throws SPlatformNotFoundException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getPlatform"));
        }
        SPlatform platform = null;
        try {
            platform = (SPlatform)this.platformPersistenceService.selectOne(new SelectOneDescriptor("getPlatform", null, (Class<? extends PersistentObject>)((Class<PersistentObject>)SPlatform.class)));
            if (platform == null) {
                throw new SPlatformNotFoundException("No platform found");
            }
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getPlatform"));
            }
            return platform;
        }
        catch (Exception e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getPlatform", "Unable to check if a platform already exists : " + e.getMessage()));
            }
            throw new SPlatformNotFoundException("Unable to check if a platform already exists : " + e.getMessage(), e);
        }
    }

    @Override
    public STenant getTenant(long id) throws STenantNotFoundException {
        STenant tenant;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_TENANT_BY_ID));
        }
        try {
            tenant = this.platformPersistenceService.selectById(new SelectByIdDescriptor<STenant>(QUERY_GET_TENANT_BY_ID, STenant.class, id));
            if (tenant == null) {
                throw new STenantNotFoundException("No tenant found with id: " + id);
            }
        }
        catch (Exception e) {
            throw new STenantNotFoundException("Unable to get the tenant : " + e.getMessage(), e);
        }
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_TENANT_BY_ID));
        }
        return tenant;
    }

    @Override
    public boolean isPlatformCreated() {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_IS_PLATFORM_CREATED));
        }
        boolean flag = false;
        try {
            this.getPlatform();
            flag = true;
        }
        catch (SPlatformNotFoundException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_IS_PLATFORM_CREATED, e));
            }
            return false;
        }
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_IS_PLATFORM_CREATED));
        }
        return flag;
    }

    @Override
    public STenant getTenantByName(String name) throws STenantNotFoundException {
        STenant tenant;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_TENANT_BY_NAME));
        }
        try {
            Map<String, Object> parameters = CollectionUtil.buildSimpleMap(BuilderFactory.get(STenantBuilderFactory.class).getNameKey(), name);
            tenant = (STenant)this.platformPersistenceService.selectOne(new SelectOneDescriptor(QUERY_GET_TENANT_BY_NAME, parameters, STenant.class));
            if (tenant == null) {
                throw new STenantNotFoundException("No tenant found with name: " + name);
            }
        }
        catch (SBonitaReadException e) {
            throw new STenantNotFoundException("Unable to check if a tenant already exists: " + e.getMessage(), e);
        }
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_TENANT_BY_NAME));
        }
        return tenant;
    }

    @Override
    public STenant getDefaultTenant() throws STenantNotFoundException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_DEFAULT_TENANT));
        }
        STenant tenant = null;
        try {
            tenant = (STenant)this.platformPersistenceService.selectOne(new SelectOneDescriptor(QUERY_GET_DEFAULT_TENANT, null, (Class<? extends PersistentObject>)((Class<PersistentObject>)STenant.class)));
            if (tenant == null) {
                throw new STenantNotFoundException("No default tenant found");
            }
        }
        catch (SBonitaReadException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), QUERY_GET_DEFAULT_TENANT, e));
            }
            throw new STenantNotFoundException("Unable to check if a default tenant already exists: " + e.getMessage(), e);
        }
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_DEFAULT_TENANT));
        }
        return tenant;
    }

    @Override
    public List<STenant> getTenants(Collection<Long> ids, QueryOptions queryOptions) throws STenantNotFoundException, STenantException {
        List<STenant> tenants;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_GET_TENANTS));
        }
        try {
            Map<String, Object> parameters = CollectionUtil.buildSimpleMap("ids", ids);
            tenants = this.platformPersistenceService.selectList(new SelectListDescriptor(QUERY_GET_TENANTS_BY_IDS, parameters, STenant.class, queryOptions));
            if (tenants.size() != ids.size()) {
                throw new STenantNotFoundException("Unable to retrieve all tenants by ids. Expected: " + ids + ", retrieved: " + tenants);
            }
        }
        catch (SBonitaReadException e) {
            throw new STenantException("Problem getting list of tenants: " + e.getMessage(), e);
        }
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_GET_TENANTS));
        }
        return tenants;
    }

    @Override
    public void updatePlatform(SPlatform platform, EntityUpdateDescriptor descriptor) throws SPlatformUpdateException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_UPDATE_PLATFORM));
        }
        UpdateDescriptor desc = new UpdateDescriptor(platform);
        desc.addFields(descriptor.getFields());
        try {
            this.platformPersistenceService.update(desc);
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_UPDATE_PLATFORM));
            }
        }
        catch (SPersistenceException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_UPDATE_PLATFORM, e));
            }
            throw new SPlatformUpdateException("Problem while updating platform: " + platform, e);
        }
    }

    @Override
    public void updateTenant(STenant tenant, EntityUpdateDescriptor descriptor) throws STenantUpdateException {
        String tenantName;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_UPDATE_TENANT));
        }
        if ((tenantName = (String)descriptor.getFields().get("name")) != null) {
            try {
                if (this.getTenantByName(tenantName).getId() != tenant.getId()) {
                    throw new STenantUpdateException("Unable to update the tenant with new name " + tenantName + " : it already exists.");
                }
            }
            catch (STenantNotFoundException e) {
                // empty catch block
            }
        }
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)tenant, descriptor);
        SUpdateEvent updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(TENANT).setObject(tenant).done();
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_UPDATE_TENANT));
            }
        }
        catch (SRecorderException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_UPDATE_TENANT, e));
            }
            throw new STenantUpdateException("Problem while updating tenant: " + tenant, e);
        }
    }

    @Override
    public boolean activateTenant(long tenantId) throws STenantNotFoundException, STenantActivationException {
        STenant tenant;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_ACTIVATE_TENANT));
        }
        if ((tenant = this.getTenant(tenantId)).isActivated()) {
            return false;
        }
        UpdateDescriptor desc = new UpdateDescriptor(tenant);
        desc.addField(BuilderFactory.get(STenantBuilderFactory.class).getStatusKey(), "ACTIVATED");
        try {
            this.platformPersistenceService.update(desc);
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_ACTIVATE_TENANT));
            }
        }
        catch (SPersistenceException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_ACTIVATE_TENANT, e));
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
            throw new STenantActivationException("Problem while activating tenant: " + tenant, e);
        }
        return true;
    }

    @Override
    public void deactiveTenant(long tenantId) throws STenantNotFoundException, STenantDeactivationException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_DEACTIVE_TENANT));
        }
        STenant tenant = this.getTenant(tenantId);
        UpdateDescriptor desc = new UpdateDescriptor(tenant);
        desc.addField(BuilderFactory.get(STenantBuilderFactory.class).getStatusKey(), "DEACTIVATED");
        try {
            this.platformPersistenceService.update(desc);
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_DEACTIVE_TENANT));
            }
        }
        catch (SPersistenceException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), LOG_DEACTIVE_TENANT, e));
            }
            throw new STenantDeactivationException("Problem while deactivating tenant: " + tenant, e);
        }
    }

    @Override
    public List<STenant> getTenants(QueryOptions queryOptions) throws STenantException {
        List<STenant> tenants;
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), LOG_GET_TENANTS));
        }
        try {
            tenants = this.platformPersistenceService.selectList(new SelectListDescriptor(LOG_GET_TENANTS, null, STenant.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new STenantException("Problem getting list of tenants : " + e.getMessage(), e);
        }
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), LOG_GET_TENANTS));
        }
        return tenants;
    }

    @Override
    public int getNumberOfTenants() throws STenantException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), QUERY_GET_NUMBER_OF_TENANTS));
        }
        Map<String, Object> emptyMap = Collections.emptyMap();
        try {
            Long read = this.platformPersistenceService.selectOne(new SelectOneDescriptor<Long>(QUERY_GET_NUMBER_OF_TENANTS, emptyMap, STenant.class, Long.class));
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), QUERY_GET_NUMBER_OF_TENANTS));
            }
            return read.intValue();
        }
        catch (SBonitaReadException e) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), QUERY_GET_NUMBER_OF_TENANTS, e));
            }
            throw new STenantException(e);
        }
    }

    @Override
    public List<STenant> searchTenants(QueryOptions options) throws SBonitaReadException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchSTenants"));
        }
        List<STenant> listsSTenants = this.platformPersistenceService.searchEntity(STenant.class, options, null);
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchSTenants"));
        }
        return listsSTenants;
    }

    @Override
    public long getNumberOfTenants(QueryOptions options) throws SBonitaReadException {
        if (this.isTraced) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfSTenant"));
        }
        try {
            long number = this.platformPersistenceService.getNumberOfEntities(STenant.class, options, null);
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfSTenant"));
            }
            return number;
        }
        catch (SBonitaReadException bre) {
            if (this.isTraced) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfSTenant", bre));
            }
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public void cleanTenantTables() throws STenantUpdateException {
        try {
            this.executeSQLResources(Arrays.asList("cleanTables.sql"));
        }
        catch (IOException e) {
            throw new STenantUpdateException(e);
        }
        catch (SQLException e) {
            throw new STenantUpdateException(e);
        }
    }

    @Override
    public SPlatformProperties getSPlatformProperties() {
        return this.sPlatformProperties;
    }
}

