/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile;

import java.util.List;
import org.bonitasoft.engine.commons.TenantLifecycleService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.exception.profile.SProfileCreationException;
import org.bonitasoft.engine.profile.exception.profile.SProfileDeletionException;
import org.bonitasoft.engine.profile.exception.profile.SProfileNotFoundException;
import org.bonitasoft.engine.profile.exception.profile.SProfileUpdateException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryCreationException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryDeletionException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryNotFoundException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryUpdateException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberCreationException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberDeletionException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberNotFoundException;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.profile.model.SProfileEntry;
import org.bonitasoft.engine.profile.model.SProfileMember;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public interface ProfileService
extends TenantLifecycleService {
    public static final String PROFILE = "PROFILE";
    public static final String ENTRY_PROFILE = "ENTRY_PROFILE";
    public static final String PROFILE_MEMBER = "PROFILE_MEMBER";

    public SProfile getProfile(long var1) throws SProfileNotFoundException;

    public List<SProfile> getProfiles(List<Long> var1) throws SProfileNotFoundException;

    public SProfile createProfile(SProfile var1) throws SProfileCreationException;

    public SProfile updateProfile(SProfile var1, EntityUpdateDescriptor var2) throws SProfileUpdateException;

    public void deleteProfile(SProfile var1) throws SProfileNotFoundException, SProfileDeletionException, SProfileEntryDeletionException, SProfileMemberDeletionException;

    public void deleteProfile(long var1) throws SProfileNotFoundException, SProfileDeletionException, SProfileEntryDeletionException, SProfileMemberDeletionException;

    public List<SProfile> searchProfilesOfUser(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public SProfileEntry getProfileEntry(long var1) throws SProfileEntryNotFoundException;

    public List<SProfileEntry> getEntriesOfProfile(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public SProfileEntry createProfileEntry(SProfileEntry var1) throws SProfileEntryCreationException;

    public SProfileEntry updateProfileEntry(SProfileEntry var1, EntityUpdateDescriptor var2) throws SProfileEntryUpdateException;

    public void deleteProfileEntry(SProfileEntry var1) throws SProfileEntryDeletionException;

    public void deleteProfileEntry(long var1) throws SProfileEntryNotFoundException, SProfileEntryDeletionException;

    public SProfileMember addUserToProfile(long var1, long var3, String var5, String var6, String var7) throws SProfileMemberCreationException;

    public SProfileMember addGroupToProfile(long var1, long var3, String var5, String var6) throws SProfileMemberCreationException;

    public SProfileMember addRoleToProfile(long var1, long var3, String var5) throws SProfileMemberCreationException;

    public SProfileMember addRoleAndGroupToProfile(long var1, long var3, long var5, String var7, String var8, String var9) throws SProfileMemberCreationException;

    public List<SProfileMember> getProfileMembersOfUser(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public List<SProfileMember> getProfileMembersOfGroup(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public List<SProfileMember> getProfileMembersOfRole(long var1, int var3, int var4, String var5, OrderByType var6) throws SBonitaReadException;

    public void deleteProfileMember(long var1) throws SProfileMemberDeletionException, SProfileMemberNotFoundException;

    public void deleteProfileMember(SProfileMember var1) throws SProfileMemberDeletionException;

    public long getNumberOfProfileMembers(String var1, QueryOptions var2) throws SBonitaReadException;

    public List<SProfileMember> searchProfileMembers(String var1, QueryOptions var2) throws SBonitaReadException;

    public List<SProfileMember> getProfileMembers(List<Long> var1) throws SBonitaReadException;

    public SProfile getProfileByName(String var1) throws SProfileNotFoundException;

    public List<SProfileMember> getProfileMembers(long var1, QueryOptions var3) throws SProfileMemberNotFoundException;

    public List<SProfileEntry> getEntriesOfProfileByParentId(long var1, long var3, int var5, int var6, String var7, OrderByType var8) throws SBonitaReadException;

    public void deleteAllProfileMembers() throws SProfileMemberDeletionException;

    public long getNumberOfProfiles(QueryOptions var1) throws SBonitaReadException;

    public List<SProfile> searchProfiles(QueryOptions var1) throws SBonitaReadException;

    public long getNumberOfProfileEntries(QueryOptions var1) throws SBonitaReadException;

    public List<SProfileEntry> searchProfileEntries(QueryOptions var1) throws SBonitaReadException;

    public void deleteAllProfileMembersOfProfile(SProfile var1) throws SProfileMemberDeletionException;

    public void deleteAllProfileEntriesOfProfile(SProfile var1) throws SProfileEntryDeletionException;

    public SProfileMember getProfileMemberWithoutDisplayName(long var1) throws SProfileMemberNotFoundException;

    public void updateProfileMetaData(long var1) throws SProfileUpdateException;
}

