/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.api.ImportStatus;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.profile.ImportPolicy;
import org.bonitasoft.engine.profile.ProfilesImporter;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.transaction.TransactionService;

public class ProfilesUpdaterRestartHandler
implements TenantRestartHandler {
    @Override
    public void beforeServicesStart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
    }

    @Override
    public void afterServicesStart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) {
        try {
            String profilesFile = this.getProfilesFileName();
            File file = this.getMD5File(tenantServiceAccessor);
            String xmlContent = this.getXMLContent(profilesFile);
            if (IOUtil.checkMD5(file, xmlContent.getBytes())) {
                tenantServiceAccessor.getTechnicalLoggerService().log(ProfilesUpdaterRestartHandler.class, TechnicalLogSeverity.INFO, "Default profiles are up to date");
                return;
            }
            tenantServiceAccessor.getTechnicalLoggerService().log(ProfilesUpdaterRestartHandler.class, TechnicalLogSeverity.INFO, "Default profiles not up to date, updating them...");
            this.updateProfiles(platformServiceAccessor, tenantServiceAccessor, file, xmlContent);
        }
        catch (IOException e) {
            tenantServiceAccessor.getTechnicalLoggerService().log(ProfilesUpdaterRestartHandler.class, TechnicalLogSeverity.ERROR, "Unable to read the read the default profile file to update them", e);
        }
        catch (Exception e) {
            tenantServiceAccessor.getTechnicalLoggerService().log(ProfilesUpdaterRestartHandler.class, TechnicalLogSeverity.ERROR, "Unable to update default profiles", e);
        }
    }

    String getXMLContent(String profilesFile) throws IOException {
        return IOUtil.readResource(profilesFile);
    }

    private void updateProfiles(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor, File file, String xmlContent) throws Exception {
        List<ExportedProfile> profilesFromXML = ProfilesImporter.getProfilesFromXML(xmlContent, tenantServiceAccessor.getProfileParser());
        TransactionService transactionService = platformServiceAccessor.getTransactionService();
        transactionService.executeInTransaction(this.getCallable(tenantServiceAccessor, file, xmlContent, profilesFromXML));
    }

    Callable<Object> getCallable(final TenantServiceAccessor tenantServiceAccessor, final File file, final String xmlContent, final List<ExportedProfile> profilesFromXML) {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ProfilesUpdaterRestartHandler.this.doUpdateProfiles(tenantServiceAccessor, profilesFromXML, file, xmlContent);
            }
        };
    }

    Object doUpdateProfiles(TenantServiceAccessor tenantServiceAccessor, List<ExportedProfile> profilesFromXML, File file, String xmlContent) throws NoSuchAlgorithmException, IOException {
        List<ImportStatus> importStatuses;
        try {
            ProfilesImporter profilesImporter = this.createProfilesImporter(tenantServiceAccessor, profilesFromXML);
            importStatuses = profilesImporter.importProfiles(-1L);
        }
        catch (ExecutionException e) {
            tenantServiceAccessor.getTechnicalLoggerService().log(ProfilesUpdaterRestartHandler.class, TechnicalLogSeverity.ERROR, "Unable to update default profiles", e);
            return null;
        }
        tenantServiceAccessor.getTechnicalLoggerService().log(ProfilesUpdaterRestartHandler.class, TechnicalLogSeverity.INFO, "Updated default profiles " + importStatuses);
        IOUtil.writeMD5(file, xmlContent.getBytes());
        return null;
    }

    protected String getProfilesFileName() {
        return "profiles.xml";
    }

    protected ProfilesImporter createProfilesImporter(TenantServiceAccessor tenantServiceAccessor, List<ExportedProfile> profilesFromXML) {
        return new ProfilesImporter(tenantServiceAccessor.getProfileService(), tenantServiceAccessor.getIdentityService(), profilesFromXML, ImportPolicy.UPDATE_DEFAULTS);
    }

    File getMD5File(TenantServiceAccessor tenantServiceAccessor) throws BonitaHomeNotSetException {
        return ProfilesImporter.getFileContainingMD5(tenantServiceAccessor);
    }
}

