/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.incident.Incident;
import org.bonitasoft.engine.incident.IncidentService;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.scheduler.AbstractBonitaPlatformJobListener;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.SchedulerExecutor;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.StatelessJob;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.exception.jobDescriptor.SJobDescriptorReadException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogCreationException;
import org.bonitasoft.engine.scheduler.exception.jobLog.SJobLogUpdatingException;
import org.bonitasoft.engine.scheduler.impl.BonitaTransactionSynchronizationImpl;
import org.bonitasoft.engine.scheduler.impl.JobLogCreator;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobLog;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;

public class JDBCJobListener
extends AbstractBonitaPlatformJobListener {
    private static final long serialVersionUID = -5060516371371295271L;
    private final JobService jobService;
    private final IncidentService incidentService;
    private final TechnicalLoggerService logger;
    private final JobLogCreator jobLogCreator;
    private final SchedulerService schedulerService;
    private final SchedulerExecutor schedulerExecutor;
    private final SessionAccessor sessionAccessor;
    private final TransactionService transactionService;

    public JDBCJobListener(SchedulerService schedulerService, JobService jobService, SchedulerExecutor schedulerExecutor, SessionAccessor sessionAccessor, TransactionService transactionService, IncidentService incidentService, TechnicalLoggerService logger, JobLogCreator jobLogCreator) {
        this.schedulerService = schedulerService;
        this.jobService = jobService;
        this.schedulerExecutor = schedulerExecutor;
        this.sessionAccessor = sessionAccessor;
        this.transactionService = transactionService;
        this.incidentService = incidentService;
        this.logger = logger;
        this.jobLogCreator = jobLogCreator;
    }

    @Override
    public String getName() {
        return "JDBCJobListener";
    }

    @Override
    public void jobToBeExecuted(Map<String, Serializable> context) {
        Long tenantId;
        Long jobDescriptorId = (Long)context.get("jobDescriptorId");
        if (this.isSessionRelated(jobDescriptorId, tenantId = (Long)context.get("tenantId"))) {
            this.deleteRelatedJob(context, jobDescriptorId, tenantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRelatedJob(Map<String, Serializable> context, Long jobDescriptorId, Long tenantId) {
        try {
            this.sessionAccessor.setTenantId(tenantId);
            SJobDescriptor sJobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
            if (sJobDescriptor == null) {
                this.deleteJob(context, jobDescriptorId, tenantId);
            }
        }
        catch (SBonitaException e) {
            this.logWarningWhenExceptionOccurs("check of the existence of the job descriptor '" + jobDescriptorId + "'.", e);
        }
        finally {
            this.cleanSession();
        }
    }

    private void logWarningWhenExceptionOccurs(String message, Exception e) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "An exception occurs during the " + message, e);
        }
    }

    private void deleteJob(Map<String, Serializable> context, Long jobDescriptorId, Long tenantId) throws SSchedulerException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "No job descriptor found with id '" + jobDescriptorId + "'. It was probably deleted during the scheduler executed it.");
        }
        String jobName = (String)((Object)context.get("jobName"));
        this.schedulerExecutor.delete(jobName, String.valueOf(tenantId));
    }

    @Override
    public void jobExecutionVetoed(Map<String, Serializable> context) {
    }

    @Override
    public void jobWasExecuted(Map<String, Serializable> context, Exception jobException) {
        Long tenantId;
        StatelessJob bosJob = (StatelessJob)context.get("bosJob");
        if (bosJob == null) {
            return;
        }
        Long jobDescriptorId = (Long)context.get("jobDescriptorId");
        if (this.isSessionRelated(jobDescriptorId, tenantId = (Long)context.get("tenantId"))) {
            this.performPostExecutionActions(jobException, jobDescriptorId, tenantId);
        } else {
            this.logWarningWhenExceptionOccurs("job execution.", jobException);
        }
    }

    private boolean isSessionRelated(Long jobDescriptorId, Long tenantId) {
        return this.isNotNullOrEmpty(jobDescriptorId) && this.isNotNullOrEmpty(tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPostExecutionActions(Exception jobException, Long jobDescriptorId, Long tenantId) {
        this.sessionAccessor.setTenantId(tenantId);
        try {
            if (jobException != null) {
                this.setJobLog(jobException, jobDescriptorId);
            } else {
                this.jobService.deleteJobLogs(jobDescriptorId);
                this.deleteJobIfNotScheduledAnyMore(jobDescriptorId);
            }
        }
        catch (SBonitaException sbe) {
            Incident incident = new Incident("An exception occurs during the job execution of the job descriptor " + jobDescriptorId, "", jobException, sbe);
            this.incidentService.report(tenantId, incident);
        }
        finally {
            this.cleanSession();
        }
    }

    private void setJobLog(Exception jobException, Long jobDescriptorId) throws SBonitaReadException, SJobLogUpdatingException, SJobLogCreationException, SJobDescriptorReadException {
        List<SJobLog> jobLogs = this.jobService.getJobLogs(jobDescriptorId, 0, 1);
        if (!jobLogs.isEmpty()) {
            this.updateJobLog(jobException, jobLogs);
        } else {
            this.jobLogCreator.createJobLog(jobException, jobDescriptorId);
        }
    }

    private boolean isNotNullOrEmpty(Long id) {
        return id != null && id != 0L;
    }

    private void cleanSession() {
        block2: {
            try {
                this.transactionService.registerBonitaSynchronization(new BonitaTransactionSynchronizationImpl(this.sessionAccessor));
            }
            catch (STransactionNotFoundException e) {
                if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) break block2;
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, e);
            }
        }
    }

    private void updateJobLog(Exception jobException, List<SJobLog> jobLogs) throws SJobLogUpdatingException {
        SJobLog jobLog = jobLogs.get(0);
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField("lastMessage", this.getStackTrace(jobException));
        descriptor.addField("lastUpdateDate", System.currentTimeMillis());
        descriptor.addField("retryNumber", jobLog.getRetryNumber() + 1L);
        this.jobService.updateJobLog(jobLog, descriptor);
    }

    private void deleteJobIfNotScheduledAnyMore(Long jobDescriptorId) throws SSchedulerException {
        SJobDescriptor jobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
        if (jobDescriptor != null && !this.schedulerService.isStillScheduled(jobDescriptor)) {
            this.schedulerService.delete(jobDescriptor.getJobName());
        } else if (jobDescriptor == null && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("jobDescriptor with id");
            stringBuilder.append(jobDescriptorId);
            stringBuilder.append(" already deleted, ignore it");
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, stringBuilder.toString());
        }
    }

    private String getStackTrace(Exception jobException) {
        StringWriter exceptionWriter = new StringWriter();
        jobException.printStackTrace(new PrintWriter(exceptionWriter));
        return exceptionWriter.toString();
    }
}

