/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SFireEventException;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.scheduler.AbstractBonitaPlatformJobListener;
import org.bonitasoft.engine.scheduler.AbstractBonitaTenantJobListener;
import org.bonitasoft.engine.scheduler.InjectedService;
import org.bonitasoft.engine.scheduler.JobIdentifier;
import org.bonitasoft.engine.scheduler.JobParameter;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.SchedulerExecutor;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.ServicesResolver;
import org.bonitasoft.engine.scheduler.StatelessJob;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;
import org.bonitasoft.engine.scheduler.impl.JobWrapper;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.scheduler.model.SJobParameter;
import org.bonitasoft.engine.scheduler.trigger.Trigger;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.transaction.TransactionService;

public class SchedulerServiceImpl
implements SchedulerService {
    private final TechnicalLoggerService logger;
    private final SchedulerExecutor schedulerExecutor;
    private final JobService jobService;
    private final EventService eventService;
    private final SEvent schedulStarted;
    private final SEvent schedulStopped;
    private final SEvent jobFailed;
    private final SessionAccessor sessionAccessor;
    private final TransactionService transactionService;
    private final ServicesResolver servicesResolver;
    private final int batchSize;

    public SchedulerServiceImpl(SchedulerExecutor schedulerExecutor, JobService jobService, TechnicalLoggerService logger, EventService eventService, TransactionService transactionService, SessionAccessor sessionAccessor, ServicesResolver servicesResolver) {
        this(schedulerExecutor, jobService, logger, eventService, transactionService, sessionAccessor, servicesResolver, 1000);
    }

    public SchedulerServiceImpl(SchedulerExecutor schedulerExecutor, JobService jobService, TechnicalLoggerService logger, EventService eventService, TransactionService transactionService, SessionAccessor sessionAccessor, ServicesResolver servicesResolver, int batchSize) {
        this.schedulerExecutor = schedulerExecutor;
        this.jobService = jobService;
        this.logger = logger;
        this.servicesResolver = servicesResolver;
        this.schedulStarted = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("SCHEDULER_STARTED").done();
        this.schedulStopped = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("SCHEDULER_STOPPED").done();
        this.jobFailed = BuilderFactory.get(SEventBuilderFactory.class).createNewInstance("JOB_FAILED").done();
        this.eventService = eventService;
        this.transactionService = transactionService;
        this.sessionAccessor = sessionAccessor;
        this.batchSize = batchSize;
        schedulerExecutor.setBOSSchedulerService(this);
    }

    private void logBeforeMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logAfterMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void logOnExceptionMethod(TechnicalLogSeverity technicalLogSeverity, String methodName, Exception e) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, e));
        }
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public void schedule(SJobDescriptor jobDescriptor, Trigger trigger) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "schedule");
        SJobDescriptor createdJobDescriptor = this.createJobDescriptor(jobDescriptor, Collections.<SJobParameter>emptyList());
        this.internalSchedule(createdJobDescriptor, trigger);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "schedule");
    }

    @Override
    public void schedule(SJobDescriptor jobDescriptor, List<SJobParameter> parameters, Trigger trigger) throws SSchedulerException {
        if (trigger == null) {
            throw new SSchedulerException("The trigger is null");
        }
        SJobDescriptor createdJobDescriptor = this.createJobDescriptor(jobDescriptor, parameters);
        this.internalSchedule(createdJobDescriptor, trigger);
    }

    @Override
    public void executeAgain(long jobDescriptorId) throws SSchedulerException {
        SJobDescriptor jobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
        this.schedulerExecutor.executeAgain(jobDescriptorId, this.getTenantIdAsString(), jobDescriptor.getJobName(), jobDescriptor.disallowConcurrentExecution());
    }

    @Override
    public void executeAgain(long jobDescriptorId, List<SJobParameter> parameters) throws SSchedulerException {
        SJobDescriptor jobDescriptor = this.jobService.getJobDescriptor(jobDescriptorId);
        this.jobService.setJobParameters(this.getTenantId(), jobDescriptor.getId(), parameters);
        this.schedulerExecutor.executeAgain(jobDescriptorId, this.getTenantIdAsString(), jobDescriptor.getJobName(), jobDescriptor.disallowConcurrentExecution());
    }

    private SJobDescriptor createJobDescriptor(SJobDescriptor sJobDescriptor, List<SJobParameter> parameters) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "createJobDescriptor");
        long tenantId = this.getTenantId();
        try {
            SJobDescriptor createdJobDescriptor = this.jobService.createJobDescriptor(sJobDescriptor, tenantId);
            this.jobService.createJobParameters(parameters, tenantId, createdJobDescriptor.getId());
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "createJobDescriptor");
            return createdJobDescriptor;
        }
        catch (SBonitaException sbe) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "createJobDescriptor", sbe);
            throw new SSchedulerException(sbe);
        }
    }

    private void internalSchedule(SJobDescriptor jobDescriptor, Trigger trigger) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "internalSchedule");
        String tenantId = this.getTenantIdAsString();
        try {
            if (trigger == null) {
                this.schedulerExecutor.executeNow(jobDescriptor.getId(), tenantId, jobDescriptor.getJobName(), jobDescriptor.disallowConcurrentExecution());
            } else {
                this.schedulerExecutor.schedule(jobDescriptor.getId(), tenantId, jobDescriptor.getJobName(), trigger, jobDescriptor.disallowConcurrentExecution());
            }
        }
        catch (Throwable e) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e);
            try {
                this.eventService.fireEvent(this.jobFailed);
            }
            catch (SFireEventException e1) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, e1);
            }
            throw new SSchedulerException(e);
        }
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "internalSchedule");
    }

    private long getTenantId() throws SSchedulerException {
        long tenantId;
        try {
            tenantId = this.sessionAccessor.getTenantId();
        }
        catch (STenantIdNotSetException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getTenantId", e);
            throw new SSchedulerException(e);
        }
        return tenantId;
    }

    private String getTenantIdAsString() throws SSchedulerException {
        return String.valueOf(this.getTenantId());
    }

    @Override
    public void executeNow(SJobDescriptor jobDescriptor, List<SJobParameter> parameters) throws SSchedulerException {
        SJobDescriptor createdJobDescriptor = this.createJobDescriptor(jobDescriptor, parameters);
        this.internalSchedule(createdJobDescriptor, null);
    }

    @Override
    public boolean isStarted() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "isStarted");
        boolean isStarted = this.schedulerExecutor.isStarted();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "isStarted");
        return isStarted;
    }

    @Override
    public boolean isStopped() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "isShutdown");
        boolean isShutdown = this.schedulerExecutor.isShutdown();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "isShutdown");
        return isShutdown;
    }

    @Override
    public void start() throws SSchedulerException, SFireEventException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "start");
        this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Start scheduler");
        this.schedulerExecutor.start();
        this.eventService.fireEvent(this.schedulStarted);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "start");
    }

    @Override
    public void stop() throws SSchedulerException, SFireEventException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "shutdown");
        this.schedulerExecutor.shutdown();
        this.eventService.fireEvent(this.schedulStopped);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "shutdown");
    }

    @Override
    public void pauseJobs(long tenantId) throws SSchedulerException {
        this.schedulerExecutor.pauseJobs(String.valueOf(tenantId));
    }

    @Override
    public void resumeJobs(long tenantId) throws SSchedulerException {
        this.schedulerExecutor.resumeJobs(String.valueOf(tenantId));
    }

    @Override
    public boolean delete(String jobName) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "delete");
        boolean delete = this.schedulerExecutor.delete(jobName, String.valueOf(this.getTenantId()));
        this.jobService.deleteJobDescriptorByJobName(jobName);
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "delete");
        return delete;
    }

    @Override
    public void deleteJobs() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "deleteJobs");
        this.schedulerExecutor.deleteJobs(String.valueOf(this.getTenantId()));
        this.jobService.deleteAllJobDescriptors();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "deleteJobs");
    }

    @Override
    public List<String> getJobs() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getJobs");
        List<String> list = this.schedulerExecutor.getJobs(String.valueOf(this.getTenantId()));
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "getJobs");
        return list;
    }

    @Override
    public List<String> getAllJobs() throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getAllJobs");
        List<String> list = this.schedulerExecutor.getAllJobs();
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "getAllJobs");
        return list;
    }

    public StatelessJob getPersistedJob(JobIdentifier jobIdentifier) throws SSchedulerException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getPersistedJob");
        try {
            this.sessionAccessor.setTenantId(jobIdentifier.getTenantId());
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getPersistedJob");
            StatelessJob statelessJob = this.transactionService.executeInTransaction(new PersistedJobCallable(jobIdentifier));
            return statelessJob;
        }
        catch (Exception e) {
            throw new SSchedulerException("The job class couldn't be instantiated", e);
        }
        finally {
            this.sessionAccessor.deleteTenantId();
        }
    }

    protected void injectServices(StatelessJob statelessJob) throws Exception {
        Method[] methods;
        for (Method method : methods = statelessJob.getClass().getMethods()) {
            if (method.getAnnotation(InjectedService.class) == null) continue;
            String serviceName = method.getName().substring(3);
            serviceName = serviceName.substring(0, 1).toLowerCase() + serviceName.substring(1);
            Object lookup = this.servicesResolver.lookup(serviceName);
            method.invoke((Object)statelessJob, lookup);
        }
    }

    @Override
    public boolean isStillScheduled(SJobDescriptor jobDescriptor) throws SSchedulerException {
        return this.schedulerExecutor.isStillScheduled(this.getTenantIdAsString(), jobDescriptor.getJobName());
    }

    @Override
    public void pause() throws SBonitaException {
        this.pauseJobs(this.getTenantId());
    }

    @Override
    public void resume() throws SBonitaException {
        this.resumeJobs(this.getTenantId());
    }

    @Override
    public void rescheduleErroneousTriggers() throws SSchedulerException {
        this.schedulerExecutor.rescheduleErroneousTriggers();
    }

    @Override
    public Date rescheduleJob(String triggerName, String groupName, Date triggerStartTime) throws SSchedulerException {
        return this.schedulerExecutor.rescheduleJob(triggerName, groupName, triggerStartTime);
    }

    @Override
    public void addJobListener(List<AbstractBonitaTenantJobListener> jobListeners, String groupName) throws SSchedulerException {
        this.schedulerExecutor.addJobListener(jobListeners, groupName);
    }

    @Override
    public void addJobListener(List<AbstractBonitaPlatformJobListener> jobListeners) throws SSchedulerException {
        this.schedulerExecutor.addJobListener(jobListeners);
    }

    @Override
    public void initializeScheduler() throws SSchedulerException {
        this.schedulerExecutor.initializeScheduler();
    }

    @Override
    public boolean isExistingJob(String jobName) throws SSchedulerException {
        return this.schedulerExecutor.isExistingJob(jobName, String.valueOf(this.getTenantId()));
    }

    private class PersistedJobCallable
    implements Callable<JobWrapper> {
        private final JobIdentifier jobIdentifier;

        public PersistedJobCallable(JobIdentifier jobIdentifier) {
            this.jobIdentifier = jobIdentifier;
        }

        @Override
        public JobWrapper call() throws Exception {
            SJobDescriptor sJobDescriptor = SchedulerServiceImpl.this.jobService.getJobDescriptor(this.jobIdentifier.getId());
            if (sJobDescriptor == null) {
                return null;
            }
            String jobClassName = sJobDescriptor.getJobClassName();
            Class<?> jobClass = Class.forName(jobClassName);
            StatelessJob statelessJob = (StatelessJob)jobClass.newInstance();
            FilterOption filterOption = new FilterOption(SJobParameter.class, "jobDescriptorId", this.jobIdentifier.getId());
            List<OrderByOption> orderByoptions = Arrays.asList(new OrderByOption(SJobParameter.class, "id", OrderByType.ASC));
            QueryOptions queryOptions = new QueryOptions(0, Integer.MAX_VALUE, orderByoptions, Collections.singletonList(filterOption), null);
            List<SJobParameter> parameters = SchedulerServiceImpl.this.jobService.searchJobParameters(queryOptions);
            HashMap<String, Serializable> parameterMap = new HashMap<String, Serializable>();
            for (SJobParameter sJobParameterImpl : parameters) {
                parameterMap.put(sJobParameterImpl.getKey(), sJobParameterImpl.getValue());
            }
            parameterMap.put("JOB_DESCRIPTOR_ID", Long.valueOf(this.jobIdentifier.getId()));
            parameterMap.put(JobParameter.BATCH_SIZE.name(), Integer.valueOf(SchedulerServiceImpl.this.batchSize));
            statelessJob.setAttributes(parameterMap);
            if (SchedulerServiceImpl.this.servicesResolver != null) {
                SchedulerServiceImpl.this.injectServices(statelessJob);
            }
            return new JobWrapper(this.jobIdentifier.getJobName(), statelessJob, SchedulerServiceImpl.this.logger, this.jobIdentifier.getTenantId(), SchedulerServiceImpl.this.eventService, SchedulerServiceImpl.this.sessionAccessor, SchedulerServiceImpl.this.transactionService);
        }
    }
}

