/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.util.Arrays;
import java.util.List;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.JobIdentifier;
import org.bonitasoft.engine.scheduler.impl.AbstractQuartzJob;
import org.bonitasoft.engine.scheduler.impl.SchedulerServiceImpl;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.TriggerFiredBundle;

public final class TransactionalSimpleJobFactory
extends SimpleJobFactory {
    private final SchedulerServiceImpl schedulerService;
    private final TechnicalLoggerService logger;

    public TransactionalSimpleJobFactory(SchedulerServiceImpl schedulerService, TechnicalLoggerService logger) {
        this.schedulerService = schedulerService;
        this.logger = logger;
    }

    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Job newJob = super.newJob(bundle, scheduler);
        if (newJob instanceof AbstractQuartzJob) {
            AbstractQuartzJob quartzJob = (AbstractQuartzJob)newJob;
            JobDataMap jobDataMap = bundle.getJobDetail().getJobDataMap();
            Long tenantId = Long.valueOf((String)jobDataMap.get((Object)"tenantId"));
            Long jobId = Long.valueOf((String)jobDataMap.get((Object)"jobId"));
            String jobName = (String)jobDataMap.get((Object)"jobName");
            JobIdentifier jobIdentifier = new JobIdentifier(jobId, tenantId, jobName);
            try {
                quartzJob.setBosJob(this.schedulerService.getPersistedJob(jobIdentifier));
            }
            catch (Throwable t) {
                if (this.isInternalCronJob(jobName)) {
                    this.logExecutionIgnored(bundle, jobName, t);
                    quartzJob.setBosJob(null);
                }
                throw new SchedulerException("unable to create the BOS job", t);
            }
            return quartzJob;
        }
        return newJob;
    }

    private void logExecutionIgnored(TriggerFiredBundle bundle, String jobName, Throwable t) {
        if (this.logger.isLoggable(((Object)((Object)this)).getClass(), TechnicalLogSeverity.WARNING)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Unable to create the BOS job '");
            stb.append(jobName);
            stb.append("'. Ignoring this execution. Next fire time is: ");
            stb.append(bundle.getNextFireTime());
            this.logger.log(((Object)((Object)this)).getClass(), TechnicalLogSeverity.WARNING, stb.toString());
        }
        if (this.logger.isLoggable(((Object)((Object)this)).getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(((Object)((Object)this)).getClass(), TechnicalLogSeverity.DEBUG, "Unable to crete the BOS job due to: ", t);
        }
    }

    private boolean isInternalCronJob(String jobName) {
        List<String> internalCronJobs = Arrays.asList("BPMEventHandling", "CleanInvalidSessions", "InsertBatchLogsJob");
        return internalCronJobs.contains(jobName);
    }
}

