/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.process;

import java.util.List;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.search.AbstractArchivedProcessInstanceSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchArchivedProcessInstancesDescriptor;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;

public class SearchArchivedProcessInstances
extends AbstractArchivedProcessInstanceSearchEntity {
    private final ProcessInstanceService processInstanceService;

    public SearchArchivedProcessInstances(ProcessInstanceService processInstanceService, ProcessDefinitionService processDefinitionService, SearchArchivedProcessInstancesDescriptor archivedProcessInstancesDescriptor, SearchOptions options) {
        super((SearchEntityDescriptor)archivedProcessInstancesDescriptor, options, processDefinitionService);
        this.processInstanceService = processInstanceService;
    }

    @Override
    public long executeCount(QueryOptions searchOptions) throws SBonitaReadException {
        return this.processInstanceService.getNumberOfArchivedProcessInstances(searchOptions);
    }

    @Override
    public List<SAProcessInstance> executeSearch(QueryOptions searchOptions) throws SBonitaReadException {
        return this.processInstanceService.searchArchivedProcessInstances(searchOptions);
    }
}

