/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.sequence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.bonitasoft.engine.commons.exceptions.SObjectNotFoundException;
import org.bonitasoft.engine.lock.LockService;

public class TenantSequenceManagerImpl {
    static final String SEQUENCE = "SEQUENCE";
    static final String NEXTID = "nextid";
    static final String SELECT_BY_ID = "SELECT * FROM sequence WHERE tenantid = ? AND id = ?";
    static final String UPDATE_SEQUENCE = "UPDATE sequence SET nextId = ? WHERE tenantid = ? AND id = ?";
    private final Long tenantId;
    private final Map<Long, Integer> rangeSizes;
    private final Map<Long, Long> nextAvailableIds = new HashMap<Long, Long>();
    private final Map<Long, Long> lastIdInRanges = new HashMap<Long, Long>();
    private static final Map<Long, Object> SEQUENCE_MUTEXS = new HashMap<Long, Object>();
    private final int defaultRangeSize;
    private final Map<String, Long> sequencesMappings;
    private final int retries;
    private final int delay;
    private final int delayFactor;
    private final DataSource datasource;
    private final LockService lockService;

    public TenantSequenceManagerImpl(long tenantId, LockService lockService, Map<Long, Integer> rangeSizes, int defaultRangeSize, Map<String, Long> sequencesMappings, DataSource datasource, int retries, int delay, int delayFactor) {
        this.tenantId = tenantId;
        this.lockService = lockService;
        this.defaultRangeSize = defaultRangeSize;
        this.rangeSizes = rangeSizes;
        this.sequencesMappings = sequencesMappings;
        this.retries = retries;
        this.delay = delay;
        this.delayFactor = delayFactor;
        this.datasource = datasource;
        for (Long sequenceId : sequencesMappings.values()) {
            SEQUENCE_MUTEXS.put(sequenceId, new TenantSequenceManagerImplMutex());
            this.nextAvailableIds.put(sequenceId, 0L);
            this.lastIdInRanges.put(sequenceId, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextId(String entityName) throws SObjectNotFoundException {
        Object sequenceMutex;
        Long sequenceId = this.sequencesMappings.get(entityName);
        if (sequenceId == null) {
            throw new SObjectNotFoundException("No sequence id found for " + entityName);
        }
        Object object = sequenceMutex = SEQUENCE_MUTEXS.get(sequenceId);
        synchronized (object) {
            Long nextAvailableId = this.nextAvailableIds.get(sequenceId);
            Long lastIdInRange = this.lastIdInRanges.get(sequenceId);
            if (nextAvailableId > lastIdInRange) {
                this.setNewRange(sequenceId);
                nextAvailableId = this.nextAvailableIds.get(sequenceId);
            }
            this.nextAvailableIds.put(sequenceId, nextAvailableId + 1L);
            return nextAvailableId;
        }
    }

    /*
     * Exception decompiling
     */
    private void setNewRange(long sequenceId) throws SObjectNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    int getRangeSize(long sequenceId) {
        Integer rangeSize = this.rangeSizes.get(sequenceId);
        return rangeSize != null ? rangeSize : this.defaultRangeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSequence(Connection connection, long nextSequenceId, long tenantId, long id) throws SQLException {
        PreparedStatement updateSequencePreparedStatement = connection.prepareStatement(UPDATE_SEQUENCE);
        try {
            updateSequencePreparedStatement.setObject(1, nextSequenceId);
            updateSequencePreparedStatement.setObject(2, tenantId);
            updateSequencePreparedStatement.setObject(3, id);
            updateSequencePreparedStatement.executeUpdate();
        }
        finally {
            if (updateSequencePreparedStatement != null) {
                updateSequencePreparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long selectById(Connection connection, long id, long tenantId) throws SQLException, SObjectNotFoundException {
        PreparedStatement selectByIdPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            selectByIdPreparedStatement = connection.prepareStatement(SELECT_BY_ID);
            selectByIdPreparedStatement.setLong(1, tenantId);
            selectByIdPreparedStatement.setLong(2, id);
            resultSet = selectByIdPreparedStatement.executeQuery();
            long l = this.getNextId(id, tenantId, resultSet);
            return l;
        }
        finally {
            if (selectByIdPreparedStatement != null) {
                selectByIdPreparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextId(long id, long tenantId, ResultSet resultSet) throws SQLException, SObjectNotFoundException {
        try {
            if (resultSet.next()) {
                long nextId = resultSet.getLong(NEXTID);
                if (resultSet.wasNull()) {
                    throw new SQLException("Did not expect a null value for the column nextid");
                }
                if (resultSet.next()) {
                    throw new SQLException("Did not expect more than one value for tenantId:" + tenantId + " id: " + id);
                }
                long l = nextId;
                return l;
            }
        }
        finally {
            this.closeResultSet(resultSet);
        }
        throw new SObjectNotFoundException("Found no row for tenantId:" + tenantId + " id: " + id);
    }

    private void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void manageException(long sleepTime, Exception t) {
        t.printStackTrace();
        System.err.println("Optimistic locking failed: " + t);
        System.err.println("Waiting " + sleepTime + " millis");
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            System.err.println("Retry sleeping got interrupted");
        }
    }

    private static final class TenantSequenceManagerImplMutex {
        private TenantSequenceManagerImplMutex() {
        }
    }
}

