/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.synchro.FlowNodeReachStateHandler;
import org.bonitasoft.engine.synchro.JMSProducer;
import org.bonitasoft.engine.synchro.ProcessInstanceFinishedHandler;
import org.bonitasoft.engine.synchro.TaskReadyHandler;

public class RemovePerfHandlerCommand
extends TenantCommand {
    private static final String PROCESSINSTANCE_STATE_UPDATED = "PROCESSINSTANCE_STATE_UPDATED";
    private static final String ACTIVITYINSTANCE_STATE_UPDATED = "ACTIVITYINSTANCE_STATE_UPDATED";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandExecutionException {
        JMSProducer.resetInstance();
        EventService eventService = serviceAccessor.getEventService();
        this.removeAllHandlers(eventService, PROCESSINSTANCE_STATE_UPDATED, ProcessInstanceFinishedHandler.class);
        this.removeAllHandlers(eventService, ACTIVITYINSTANCE_STATE_UPDATED, TaskReadyHandler.class);
        this.removeAllHandlers(eventService, ACTIVITYINSTANCE_STATE_UPDATED, FlowNodeReachStateHandler.class);
        return null;
    }

    private void removeAllHandlers(EventService eventService, String eventType, Class<?> clazz) {
        Set<SHandler<SEvent>> handlers = eventService.getHandlers(eventType);
        LinkedList<SHandler<SEvent>> removeCandidates = new LinkedList<SHandler<SEvent>>();
        if (handlers != null) {
            for (SHandler<SEvent> handler : handlers) {
                if (!clazz.isInstance(handler)) continue;
                removeCandidates.add(handler);
            }
            handlers.removeAll(removeCandidates);
        }
    }
}

