/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.util.Map;
import javax.jms.JMSException;
import org.bonitasoft.engine.synchro.JMSProducer;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionState;

public class SendJMSMessageSynchronization
implements BonitaTransactionSynchronization {
    private final Map<String, Serializable> event;
    private final Long id;
    private final JMSProducer jmsProducer;

    public SendJMSMessageSynchronization(Map<String, Serializable> event, Long id, JMSProducer jmsProducer) {
        this.event = event;
        this.id = id;
        this.jmsProducer = jmsProducer;
    }

    @Override
    public void beforeCommit() {
    }

    @Override
    public void afterCompletion(TransactionState status) {
        if (status == TransactionState.COMMITTED) {
            try {
                this.jmsProducer.sendMessage(this.event, Long.toString(this.id));
            }
            catch (JMSException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

