/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Iterable;

public abstract class ASN1Sequence
extends ASN1Primitive
implements Iterable {
    ASN1Encodable[] elements;

    public static ASN1Sequence getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1Sequence) {
            return (ASN1Sequence)obj;
        }
        if (obj instanceof ASN1SequenceParser) {
            return ASN1Sequence.getInstance(((ASN1SequenceParser)obj).toASN1Primitive());
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1Sequence.getInstance(ASN1Sequence.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Sequence) {
            return (ASN1Sequence)primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        if (explicit) {
            if (!taggedObject.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return ASN1Sequence.getInstance(taggedObject.getObject());
        }
        ASN1Primitive o = taggedObject.getObject();
        if (taggedObject.isExplicit()) {
            if (taggedObject instanceof BERTaggedObject) {
                return new BERSequence(o);
            }
            return new DLSequence(o);
        }
        if (o instanceof ASN1Sequence) {
            ASN1Sequence s = (ASN1Sequence)o;
            if (taggedObject instanceof BERTaggedObject) {
                return s;
            }
            return (ASN1Sequence)s.toDLObject();
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + taggedObject.getClass().getName());
    }

    protected ASN1Sequence() {
        this.elements = ASN1EncodableVector.EMPTY_ELEMENTS;
    }

    protected ASN1Sequence(ASN1Encodable element) {
        if (null == element) {
            throw new NullPointerException("'element' cannot be null");
        }
        this.elements = new ASN1Encodable[]{element};
    }

    protected ASN1Sequence(ASN1EncodableVector elementVector) {
        if (null == elementVector) {
            throw new NullPointerException("'elementVector' cannot be null");
        }
        this.elements = elementVector.takeElements();
    }

    protected ASN1Sequence(ASN1Encodable[] elements) {
        if (Arrays.isNullOrContainsNull(elements)) {
            throw new NullPointerException("'elements' cannot be null, or contain null");
        }
        this.elements = ASN1EncodableVector.cloneElements(elements);
    }

    ASN1Sequence(ASN1Encodable[] elements, boolean clone) {
        this.elements = clone ? ASN1EncodableVector.cloneElements(elements) : elements;
    }

    public ASN1Encodable[] toArray() {
        return ASN1EncodableVector.cloneElements(this.elements);
    }

    ASN1Encodable[] toArrayInternal() {
        return this.elements;
    }

    public Enumeration getObjects() {
        return new Enumeration(){
            private int pos = 0;

            public boolean hasMoreElements() {
                return this.pos < ASN1Sequence.this.elements.length;
            }

            public Object nextElement() {
                if (this.pos >= ASN1Sequence.this.elements.length) {
                    throw new NoSuchElementException("ASN1Sequence Enumeration");
                }
                return ASN1Sequence.this.elements[this.pos++];
            }
        };
    }

    public ASN1SequenceParser parser() {
        final int count = this.size();
        return new ASN1SequenceParser(){
            private int pos = 0;

            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable obj;
                if (count == this.pos) {
                    return null;
                }
                if ((obj = ASN1Sequence.this.elements[this.pos++]) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)obj).parser();
                }
                if (obj instanceof ASN1Set) {
                    return ((ASN1Set)obj).parser();
                }
                return obj;
            }

            public ASN1Primitive getLoadedObject() {
                return ASN1Sequence.this;
            }

            public ASN1Primitive toASN1Primitive() {
                return ASN1Sequence.this;
            }
        };
    }

    public ASN1Encodable getObjectAt(int index) {
        return this.elements[index];
    }

    public int size() {
        return this.elements.length;
    }

    public int hashCode() {
        int i = this.elements.length;
        int hc = i + 1;
        while (--i >= 0) {
            hc *= 257;
            hc ^= this.elements[i].toASN1Primitive().hashCode();
        }
        return hc;
    }

    boolean asn1Equals(ASN1Primitive other) {
        if (!(other instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence that = (ASN1Sequence)other;
        int count = this.size();
        if (that.size() != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            ASN1Primitive p2;
            ASN1Primitive p1 = this.elements[i].toASN1Primitive();
            if (p1 == (p2 = that.elements[i].toASN1Primitive()) || p1.asn1Equals(p2)) continue;
            return false;
        }
        return true;
    }

    ASN1Primitive toDERObject() {
        return new DERSequence(this.elements, false);
    }

    ASN1Primitive toDLObject() {
        return new DLSequence(this.elements, false);
    }

    boolean isConstructed() {
        return true;
    }

    abstract void encode(ASN1OutputStream var1, boolean var2) throws IOException;

    public String toString() {
        int count = this.size();
        if (0 == count) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int i = 0;
        while (true) {
            sb.append(this.elements[i]);
            if (++i >= count) break;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public Iterator iterator() {
        return new Arrays.Iterator(this.elements);
    }
}

