/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.drbg;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

public class DRBG {
    private static final String PREFIX = DRBG.class.getName();

    private static byte[] generateDefaultPersonalizationString(SecureRandom random) {
        return Arrays.concatenate(Strings.toByteArray("Default"), random.generateSeed(16), Strings.toByteArray(Thread.currentThread().toString()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(SecureRandom random) {
        return Arrays.concatenate(Strings.toByteArray("Nonce"), random.generateSeed(16), Strings.toByteArray(Thread.currentThread().toString()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    static /* synthetic */ byte[] access$000(SecureRandom x0) {
        return DRBG.generateDefaultPersonalizationString(x0);
    }

    static /* synthetic */ byte[] access$100(SecureRandom x0) {
        return DRBG.generateNonceIVPersonalizationString(x0);
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            provider.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private SecureRandom randomSource = new SecureRandom();
        private SecureRandom random = new SP800SecureRandomBuilder(this.randomSource, true).setPersonalizationString(DRBG.access$100(this.randomSource)).buildHash(new SHA512Digest(), this.randomSource.generateSeed(32), false);

        protected void engineSetSeed(byte[] bytes) {
            this.random.setSeed(bytes);
        }

        protected void engineNextBytes(byte[] bytes) {
            this.random.nextBytes(bytes);
        }

        protected byte[] engineGenerateSeed(int numBytes) {
            return this.randomSource.generateSeed(numBytes);
        }
    }

    public static class Default
    extends SecureRandomSpi {
        private SecureRandom randomSource = new SecureRandom();
        private SecureRandom random = new SP800SecureRandomBuilder(this.randomSource, true).setPersonalizationString(DRBG.access$000(this.randomSource)).buildHash(new SHA512Digest(), this.randomSource.generateSeed(32), true);

        protected void engineSetSeed(byte[] bytes) {
            this.random.setSeed(bytes);
        }

        protected void engineNextBytes(byte[] bytes) {
            this.random.nextBytes(bytes);
        }

        protected byte[] engineGenerateSeed(int numBytes) {
            return this.randomSource.generateSeed(numBytes);
        }
    }
}

