/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import org.bouncycastle.pqc.crypto.bike.BIKEKeyParameters;
import org.bouncycastle.pqc.crypto.bike.BIKEParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BIKEPrivateKeyParameters
extends BIKEKeyParameters {
    private byte[] h0;
    private byte[] h1;
    private byte[] sigma;

    public BIKEPrivateKeyParameters(BIKEParameters bikeParameters, byte[] h0, byte[] h1, byte[] sigma) {
        super(true, bikeParameters);
        this.h0 = Arrays.clone(h0);
        this.h1 = Arrays.clone(h1);
        this.sigma = Arrays.clone(sigma);
    }

    byte[] getH0() {
        return this.h0;
    }

    byte[] getH1() {
        return this.h1;
    }

    byte[] getSigma() {
        return this.sigma;
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(Arrays.concatenate(this.h0, this.h1), this.sigma);
    }
}

