/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.kyber;

import org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KyberPublicKeyParameters
extends KyberKeyParameters {
    final byte[] t;
    final byte[] rho;

    public byte[] getPublicKey() {
        return Arrays.concatenate(this.t, this.rho);
    }

    public byte[] getEncoded() {
        return this.getPublicKey();
    }

    public KyberPublicKeyParameters(KyberParameters params, byte[] t, byte[] rho) {
        super(false, params);
        this.t = Arrays.clone(t);
        this.rho = Arrays.clone(rho);
    }

    public KyberPublicKeyParameters(KyberParameters params, byte[] encoding) {
        super(false, params);
        this.t = Arrays.copyOfRange(encoding, 0, encoding.length - 32);
        this.rho = Arrays.copyOfRange(encoding, encoding.length - 32, encoding.length);
    }

    public byte[] getT() {
        return Arrays.clone(this.t);
    }

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }
}

