/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.ecgost;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.ECGOST3410NamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPointEncoder;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class BCECGOST3410PublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "ECGOST3410";
    private boolean withCompression;
    private transient ECPublicKeyParameters ecPublicKey;
    private transient ECParameterSpec ecSpec;
    private transient GOST3410PublicKeyAlgParameters gostParams;

    public BCECGOST3410PublicKey(String string, BCECGOST3410PublicKey bCECGOST3410PublicKey) {
        this.algorithm = string;
        this.ecPublicKey = bCECGOST3410PublicKey.ecPublicKey;
        this.ecSpec = bCECGOST3410PublicKey.ecSpec;
        this.withCompression = bCECGOST3410PublicKey.withCompression;
        this.gostParams = bCECGOST3410PublicKey.gostParams;
    }

    public BCECGOST3410PublicKey(ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        if (eCPublicKeySpec.getParams() != null) {
            this.ecSpec = eCPublicKeySpec.getParams();
            this.ecPublicKey = new ECPublicKeyParameters(eCPublicKeySpec.getQ(), ECUtil.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
        } else {
            this.ecSpec = null;
            ECParameterSpec eCParameterSpec = providerConfiguration.getEcImplicitlyCa();
            this.ecPublicKey = new ECPublicKeyParameters(eCParameterSpec.getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger()), ECUtil.getDomainParameters(providerConfiguration, (ECParameterSpec)null));
        }
    }

    public BCECGOST3410PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string;
        this.ecPublicKey = eCPublicKeyParameters;
        this.ecSpec = eCParameterSpec == null ? new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed()) : eCParameterSpec;
    }

    public BCECGOST3410PublicKey(String string, ECPublicKeyParameters eCPublicKeyParameters) {
        this.algorithm = string;
        this.ecPublicKey = eCPublicKeyParameters;
        this.ecSpec = null;
    }

    BCECGOST3410PublicKey(ECPublicKey eCPublicKey) {
        this.ecPublicKey = new ECPublicKeyParameters(eCPublicKey.getQ(), ECUtil.getDomainParameters(BouncyCastleProvider.CONFIGURATION, eCPublicKey.getParameters()));
        this.algorithm = eCPublicKey.getAlgorithm();
        this.ecSpec = eCPublicKey.getParameters();
    }

    BCECGOST3410PublicKey(String string, ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        this.algorithm = string;
        this.ecPublicKey = new ECPublicKeyParameters(eCPoint, ECUtil.getDomainParameters(BouncyCastleProvider.CONFIGURATION, eCParameterSpec));
        this.ecSpec = eCParameterSpec;
    }

    BCECGOST3410PublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo.getAlgorithmId().getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            int n;
            ASN1OctetString aSN1OctetString;
            DERBitString dERBitString = subjectPublicKeyInfo.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray(dERBitString.getBytes());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] byArray = aSN1OctetString.getOctets();
            byte[] byArray2 = new byte[32];
            byte[] byArray3 = new byte[32];
            for (n = 0; n != byArray2.length; ++n) {
                byArray2[n] = byArray[31 - n];
            }
            for (n = 0; n != byArray3.length; ++n) {
                byArray3[n] = byArray[63 - n];
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)subjectPublicKeyInfo.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = eCNamedCurveParameterSpec;
            ECPoint eCPoint = eCNamedCurveParameterSpec.getCurve().createPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3), false);
            this.ecPublicKey = new ECPublicKeyParameters(eCPoint, ECUtil.getDomainParameters(BouncyCastleProvider.CONFIGURATION, this.ecSpec));
        } else {
            int n;
            ECCurve eCCurve;
            Object object;
            ASN1Object aSN1Object;
            X962Parameters x962Parameters = X962Parameters.getInstance(subjectPublicKeyInfo.getAlgorithmId().getParameters());
            if (x962Parameters.isNamedCurve()) {
                aSN1Object = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
                object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1Object);
                this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1Object), ((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getG(), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH(), ((X9ECParameters)object).getSeed());
                eCCurve = this.ecSpec.getCurve();
            } else if (x962Parameters.isImplicitlyCA()) {
                this.ecSpec = null;
                eCCurve = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa().getCurve();
            } else {
                aSN1Object = X9ECParameters.getInstance(x962Parameters.getParameters());
                this.ecSpec = new ECParameterSpec(((X9ECParameters)aSN1Object).getCurve(), ((X9ECParameters)aSN1Object).getG(), ((X9ECParameters)aSN1Object).getN(), ((X9ECParameters)aSN1Object).getH(), ((X9ECParameters)aSN1Object).getSeed());
                eCCurve = this.ecSpec.getCurve();
            }
            aSN1Object = subjectPublicKeyInfo.getPublicKeyData();
            object = ((ASN1BitString)aSN1Object).getBytes();
            ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object);
            if (object[0] == 4 && object[1] == ((Object)object).length - 2 && (object[2] == 2 || object[2] == 3) && (n = new X9IntegerConverter().getByteLength(eCCurve)) >= ((Object)object).length - 3) {
                try {
                    aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, aSN1OctetString);
            ECPoint eCPoint = x9ECPoint.getPoint();
            this.ecPublicKey = new ECPublicKeyParameters(eCPoint, ECUtil.getDomainParameters(BouncyCastleProvider.CONFIGURATION, this.ecSpec));
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (this.algorithm.equals("ECGOST3410")) {
            int n;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            ASN1Object aSN1Object = null;
            if (this.gostParams != null) {
                aSN1Object = this.gostParams;
            } else if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                aSN1Object = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                object4 = this.ecSpec;
                object3 = ((ECParameterSpec)object4).getG().getCurve();
                object2 = ((ECCurve)object3).createPoint(((ECParameterSpec)object4).getG().getX().toBigInteger(), ((ECParameterSpec)object4).getG().getY().toBigInteger(), this.withCompression);
                object = new X9ECParameters(((ECParameterSpec)object4).getCurve(), (ECPoint)object2, ((ECParameterSpec)object4).getN(), ((ECParameterSpec)object4).getH(), ((ECParameterSpec)object4).getSeed());
                aSN1Object = new X962Parameters((X9ECParameters)object);
            }
            object4 = this.getQ();
            object3 = ((ECPoint)object4).getCurve().createPoint(((ECPoint)object4).getX().toBigInteger(), ((ECPoint)object4).getY().toBigInteger(), false);
            object2 = ASN1OctetString.getInstance(new X9ECPoint((ECPoint)object3));
            object = this.getQ().getX().toBigInteger();
            BigInteger bigInteger = this.getQ().getY().toBigInteger();
            byte[] byArray = new byte[64];
            byte[] byArray2 = ((BigInteger)object).toByteArray();
            for (n = 0; n != 32; ++n) {
                byArray[n] = byArray2[byArray2.length - 1 - n];
            }
            byArray2 = bigInteger.toByteArray();
            for (n = 0; n != 32; ++n) {
                byArray[32 + n] = byArray2[byArray2.length - 1 - n];
            }
            try {
                subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, aSN1Object), new DEROctetString(byArray));
            }
            catch (IOException iOException) {
                return null;
            }
        } else {
            Object object;
            Object object5;
            Object object6;
            X962Parameters x962Parameters = null;
            if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                object6 = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                if (object6 == null) {
                    object6 = new ASN1ObjectIdentifier(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                }
                x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object6);
            } else if (this.ecSpec == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                object6 = this.ecSpec;
                object5 = ((ECParameterSpec)object6).getG().getCurve();
                object = ((ECCurve)object5).createPoint(((ECParameterSpec)object6).getG().getX().toBigInteger(), ((ECParameterSpec)object6).getG().getY().toBigInteger(), this.withCompression);
                X9ECParameters x9ECParameters = new X9ECParameters(((ECParameterSpec)object6).getCurve(), (ECPoint)object, ((ECParameterSpec)object6).getN(), ((ECParameterSpec)object6).getH(), ((ECParameterSpec)object6).getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            object6 = this.ecPublicKey.getParameters().getCurve();
            object5 = ((ECCurve)object6).createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), this.withCompression);
            object = ASN1OctetString.getInstance(new X9ECPoint((ECPoint)object5));
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), ((ASN1OctetString)object).getOctets());
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(subjectPublicKeyInfo);
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    public ECPoint getQ() {
        ECPoint eCPoint = this.ecPublicKey.getQ();
        if (this.ecSpec == null) {
            if (eCPoint instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, eCPoint.getX(), eCPoint.getY());
            }
            return new ECPoint.F2m(null, eCPoint.getX(), eCPoint.getY());
        }
        return eCPoint;
    }

    ECPublicKeyParameters engineGetKeyParameters() {
        return this.ecPublicKey;
    }

    public String toString() {
        return ECUtil.publicKeyToString(this.algorithm, this.ecPublicKey.getQ(), this.engineGetSpec());
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECGOST3410PublicKey)) {
            return false;
        }
        BCECGOST3410PublicKey bCECGOST3410PublicKey = (BCECGOST3410PublicKey)object;
        return this.getQ().equals(bCECGOST3410PublicKey.getQ()) && this.engineGetSpec().equals(bCECGOST3410PublicKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

