/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeAlgorithmSpec
implements AlgorithmParameterSpec {
    private final List algorithmNames;
    private final List parameterSpecs;

    public CompositeAlgorithmSpec(Builder builder) {
        this.algorithmNames = Collections.unmodifiableList(new ArrayList(builder.algorithmNames));
        this.parameterSpecs = Collections.unmodifiableList(new ArrayList(builder.parameterSpecs));
    }

    public List getAlgorithmNames() {
        return this.algorithmNames;
    }

    public List getParameterSpecs() {
        return this.parameterSpecs;
    }

    public static class Builder {
        private List algorithmNames = new ArrayList();
        private List parameterSpecs = new ArrayList();

        public Builder add(String string) {
            this.algorithmNames.add(string);
            this.parameterSpecs.add(null);
            return this;
        }

        public Builder add(String string, AlgorithmParameterSpec algorithmParameterSpec) {
            this.algorithmNames.add(string);
            this.parameterSpecs.add(algorithmParameterSpec);
            return this;
        }

        public CompositeAlgorithmSpec build() {
            if (this.algorithmNames.isEmpty()) {
                throw new IllegalStateException("cannot call build with no algorithm names added");
            }
            return new CompositeAlgorithmSpec(this);
        }
    }
}

