/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;

public class Integers {
    public static final int BYTES = 4;
    public static final int SIZE = 32;
    private static final byte[] DEBRUIJN_TZ = new byte[]{31, 0, 27, 1, 28, 13, 23, 2, 29, 21, 19, 14, 24, 16, 3, 7, 30, 26, 12, 22, 20, 18, 15, 6, 25, 11, 17, 5, 10, 4, 9, 8};

    public static int highestOneBit(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n - (n >>> 1);
    }

    public static int lowestOneBit(int n) {
        return n & -n;
    }

    public static int numberOfLeadingZeros(int n) {
        if (n <= 0) {
            return ~n >>> 26 & 0x20;
        }
        int n2 = 1;
        if (0 == n >>> 16) {
            n2 += 16;
            n <<= 16;
        }
        if (0 == n >>> 24) {
            n2 += 8;
            n <<= 8;
        }
        if (0 == n >>> 28) {
            n2 += 4;
            n <<= 4;
        }
        if (0 == n >>> 30) {
            n2 += 2;
            n <<= 2;
        }
        return n2 -= n >>> 31;
    }

    public static int numberOfTrailingZeros(int n) {
        byte by = DEBRUIJN_TZ[(n & -n) * 251226722 >>> 27];
        int n2 = (n & 0xFFFF | n >>> 16) - 1 >> 31;
        return by - n2;
    }

    public static int reverse(int n) {
        n = Bits.bitPermuteStepSimple(n, 0x55555555, 1);
        n = Bits.bitPermuteStepSimple(n, 0x33333333, 2);
        n = Bits.bitPermuteStepSimple(n, 0xF0F0F0F, 4);
        return Integers.reverseBytes(n);
    }

    public static int reverseBytes(int n) {
        return Integers.rotateLeft(n & 0xFF00FF00, 8) | Integers.rotateLeft(n & 0xFF00FF, 24);
    }

    public static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    public static Integer valueOf(int n) {
        return new Integer(n);
    }
}

