/*
 * Decompiled with CFR 0.152.
 */
package org.buni.meldware.mail.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.buni.meldware.mail.StreamReadException;
import org.buni.meldware.mail.StreamWriteException;
import org.buni.meldware.mail.util.io.Copier;

public class PartialCopier
implements Copier {
    private final int off;
    private int bytesleft;
    private final int len;

    public PartialCopier(int off, int len) {
        this.off = off;
        this.bytesleft = len;
        this.len = len;
    }

    public int copy(InputStream in, OutputStream out, int blockSize) {
        try {
            in.skip(this.off);
        }
        catch (IOException e) {
            throw new StreamReadException(e.getMessage(), e);
        }
        byte[] buffer = new byte[Math.max(blockSize, 1024)];
        int bytesread = 0;
        do {
            int toRead = Math.min(buffer.length, this.bytesleft);
            try {
                bytesread = in.read(buffer, 0, toRead);
            }
            catch (IOException e) {
                throw new StreamWriteException(e.getMessage(), e);
            }
            if (bytesread > 0) {
                try {
                    out.write(buffer, 0, bytesread);
                }
                catch (IOException e) {
                    throw new StreamWriteException(e.getMessage(), e);
                }
            }
            this.bytesleft -= bytesread;
        } while (this.bytesleft > 0 && bytesread > -1);
        return this.len - this.bytesleft;
    }
}

