// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avcodec;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;

import static org.bytedeco.ffmpeg.global.avcodec.*;


/**
 * main external API structure.
 * New fields can be added to the end with minor version bumps.
 * Removal, reordering and changes to existing fields require a major
 * version bump.
 * You can use AVOptions (av_opt* / av_set/get*()) to access these fields from user
 * applications.
 * The name string for AVOptions options matches the associated command line
 * parameter name and can be found in libavcodec/options_table.h
 * The AVOption/command line parameter names differ in some cases from the C
 * structure field names for historic reasons or brevity.
 * sizeof(AVCodecContext) must not be used outside libav*.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avcodec.class)
public class AVCodecContext extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVCodecContext() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVCodecContext(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVCodecContext(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVCodecContext position(long position) {
        return (AVCodecContext)super.position(position);
    }
    @Override public AVCodecContext getPointer(long i) {
        return new AVCodecContext((Pointer)this).offsetAddress(i);
    }

    /**
     * information on struct for av_log
     * - set by avcodec_alloc_context3
     */
    public native @Const AVClass av_class(); public native AVCodecContext av_class(AVClass setter);
    public native int log_level_offset(); public native AVCodecContext log_level_offset(int setter);

    public native @Cast("AVMediaType") int codec_type(); public native AVCodecContext codec_type(int setter); /* see AVMEDIA_TYPE_xxx */
    public native @Const AVCodec codec(); public native AVCodecContext codec(AVCodec setter);
    public native @Cast("AVCodecID") int codec_id(); public native AVCodecContext codec_id(int setter); /* see AV_CODEC_ID_xxx */

    /**
     * fourcc (LSB first, so "ABCD" -> ('D'<<24) + ('C'<<16) + ('B'<<8) + 'A').
     * This is used to work around some encoder bugs.
     * A demuxer should set this to what is stored in the field used to identify the codec.
     * If there are multiple such fields in a container then the demuxer should choose the one
     * which maximizes the information about the used codec.
     * If the codec tag field in a container is larger than 32 bits then the demuxer should
     * remap the longer ID to 32 bits with a table or other structure. Alternatively a new
     * extra_codec_tag + size could be added but for this a clear advantage must be demonstrated
     * first.
     * - encoding: Set by user, if not then the default based on codec_id will be used.
     * - decoding: Set by user, will be converted to uppercase by libavcodec during init.
     */
    public native @Cast("unsigned int") int codec_tag(); public native AVCodecContext codec_tag(int setter);

    public native Pointer priv_data(); public native AVCodecContext priv_data(Pointer setter);

    /**
     * Private context used for internal data.
     *
     * Unlike priv_data, this is not codec-specific. It is used in general
     * libavcodec functions.
     */
    public native @Cast("AVCodecInternal*") Pointer internal(); public native AVCodecContext internal(Pointer setter);

    /**
     * Private data of the user, can be used to carry app specific stuff.
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native Pointer opaque(); public native AVCodecContext opaque(Pointer setter);

    /**
     * the average bitrate
     * - encoding: Set by user; unused for constant quantizer encoding.
     * - decoding: Set by user, may be overwritten by libavcodec
     *             if this info is available in the stream
     */
    public native @Cast("int64_t") long bit_rate(); public native AVCodecContext bit_rate(long setter);

    /**
     * number of bits the bitstream is allowed to diverge from the reference.
     *           the reference can be CBR (for CBR pass1) or VBR (for pass2)
     * - encoding: Set by user; unused for constant quantizer encoding.
     * - decoding: unused
     */
    public native int bit_rate_tolerance(); public native AVCodecContext bit_rate_tolerance(int setter);

    /**
     * Global quality for codecs which cannot change it per frame.
     * This should be proportional to MPEG-1/2/4 qscale.
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int global_quality(); public native AVCodecContext global_quality(int setter);

    /**
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int compression_level(); public native AVCodecContext compression_level(int setter);
public static final int FF_COMPRESSION_DEFAULT = -1;

    /**
     * AV_CODEC_FLAG_*.
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native int flags(); public native AVCodecContext flags(int setter);

    /**
     * AV_CODEC_FLAG2_*
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native int flags2(); public native AVCodecContext flags2(int setter);

    /**
     * some codecs need / can use extradata like Huffman tables.
     * MJPEG: Huffman tables
     * rv10: additional flags
     * MPEG-4: global headers (they can be in the bitstream or here)
     * The allocated memory should be AV_INPUT_BUFFER_PADDING_SIZE bytes larger
     * than extradata_size to avoid problems if it is read with the bitstream reader.
     * The bytewise contents of extradata must not depend on the architecture or CPU endianness.
     * Must be allocated with the av_malloc() family of functions.
     * - encoding: Set/allocated/freed by libavcodec.
     * - decoding: Set/allocated/freed by user.
     */
    public native @Cast("uint8_t*") BytePointer extradata(); public native AVCodecContext extradata(BytePointer setter);
    public native int extradata_size(); public native AVCodecContext extradata_size(int setter);

    /**
     * This is the fundamental unit of time (in seconds) in terms
     * of which frame timestamps are represented. For fixed-fps content,
     * timebase should be 1/framerate and timestamp increments should be
     * identically 1.
     * This often, but not always is the inverse of the frame rate or field rate
     * for video. 1/time_base is not the average frame rate if the frame rate is not
     * constant.
     *
     * Like containers, elementary streams also can store timestamps, 1/time_base
     * is the unit in which these timestamps are specified.
     * As example of such codec time base see ISO/IEC 14496-2:2001(E)
     * vop_time_increment_resolution and fixed_vop_rate
     * (fixed_vop_rate == 0 implies that it is different from the framerate)
     *
     * - encoding: MUST be set by user.
     * - decoding: unused.
     */
    public native @ByRef AVRational time_base(); public native AVCodecContext time_base(AVRational setter);

// #if FF_API_TICKS_PER_FRAME
    /**
     * For some codecs, the time base is closer to the field rate than the frame rate.
     * Most notably, H.264 and MPEG-2 specify time_base as half of frame duration
     * if no telecine is used ...
     *
     * Set to time_base ticks per frame. Default 1, e.g., H.264/MPEG-2 set it to 2.
     *
     * @deprecated
     * - decoding: Use AVCodecDescriptor.props & AV_CODEC_PROP_FIELDS
     * - encoding: Set AVCodecContext.framerate instead
     *
     */
    public native @Deprecated int ticks_per_frame(); public native AVCodecContext ticks_per_frame(int setter);
// #endif

    /**
     * Codec delay.
     *
     * Encoding: Number of frames delay there will be from the encoder input to
     *           the decoder output. (we assume the decoder matches the spec)
     * Decoding: Number of frames delay in addition to what a standard decoder
     *           as specified in the spec would produce.
     *
     * Video:
     *   Number of frames the decoded output will be delayed relative to the
     *   encoded input.
     *
     * Audio:
     *   For encoding, this field is unused (see initial_padding).
     *
     *   For decoding, this is the number of samples the decoder needs to
     *   output before the decoder's output is valid. When seeking, you should
     *   start decoding this many samples prior to your desired seek point.
     *
     * - encoding: Set by libavcodec.
     * - decoding: Set by libavcodec.
     */
    public native int delay(); public native AVCodecContext delay(int setter);


    /* video only */
    /**
     * picture width / height.
     *
     * \note Those fields may not match the values of the last
     * AVFrame output by avcodec_receive_frame() due frame
     * reordering.
     *
     * - encoding: MUST be set by user.
     * - decoding: May be set by the user before opening the decoder if known e.g.
     *             from the container. Some decoders will require the dimensions
     *             to be set by the caller. During decoding, the decoder may
     *             overwrite those values as required while parsing the data.
     */
    public native int width(); public native AVCodecContext width(int setter);
    public native int height(); public native AVCodecContext height(int setter);

    /**
     * Bitstream width / height, may be different from width/height e.g. when
     * the decoded frame is cropped before being output or lowres is enabled.
     *
     * \note Those field may not match the value of the last
     * AVFrame output by avcodec_receive_frame() due frame
     * reordering.
     *
     * - encoding: unused
     * - decoding: May be set by the user before opening the decoder if known
     *             e.g. from the container. During decoding, the decoder may
     *             overwrite those values as required while parsing the data.
     */
    public native int coded_width(); public native AVCodecContext coded_width(int setter);
    public native int coded_height(); public native AVCodecContext coded_height(int setter);

    /**
     * the number of pictures in a group of pictures, or 0 for intra_only
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int gop_size(); public native AVCodecContext gop_size(int setter);

    /**
     * Pixel format, see AV_PIX_FMT_xxx.
     * May be set by the demuxer if known from headers.
     * May be overridden by the decoder if it knows better.
     *
     * \note This field may not match the value of the last
     * AVFrame output by avcodec_receive_frame() due frame
     * reordering.
     *
     * - encoding: Set by user.
     * - decoding: Set by user if known, overridden by libavcodec while
     *             parsing the data.
     */
    public native @Cast("AVPixelFormat") int pix_fmt(); public native AVCodecContext pix_fmt(int setter);

    /**
     * If non NULL, 'draw_horiz_band' is called by the libavcodec
     * decoder to draw a horizontal band. It improves cache usage. Not
     * all codecs can do that. You must check the codec capabilities
     * beforehand.
     * When multithreading is used, it may be called from multiple threads
     * at the same time; threads might draw different parts of the same AVFrame,
     * or multiple AVFrames, and there is no guarantee that slices will be drawn
     * in order.
     * The function is also used by hardware acceleration APIs.
     * It is called at least once during frame decoding to pass
     * the data needed for hardware render.
     * In that mode instead of pixel data, AVFrame points to
     * a structure specific to the acceleration API. The application
     * reads the structure and can change some fields to indicate progress
     * or mark state.
     * - encoding: unused
     * - decoding: Set by user.
     * @param height the height of the slice
     * @param y the y position of the slice
     * @param type 1->top field, 2->bottom field, 3->frame
     * @param offset offset into the AVFrame.data from which the slice should be read
     */
    public static class Draw_horiz_band_AVCodecContext_AVFrame_IntPointer_int_int_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Draw_horiz_band_AVCodecContext_AVFrame_IntPointer_int_int_int(Pointer p) { super(p); }
        protected Draw_horiz_band_AVCodecContext_AVFrame_IntPointer_int_int_int() { allocate(); }
        private native void allocate();
        public native void call(AVCodecContext s,
                                @Const AVFrame src, IntPointer offset,
                                int y, int type, int height);
    }
    public native Draw_horiz_band_AVCodecContext_AVFrame_IntPointer_int_int_int draw_horiz_band(); public native AVCodecContext draw_horiz_band(Draw_horiz_band_AVCodecContext_AVFrame_IntPointer_int_int_int setter);

    /**
     * Callback to negotiate the pixel format. Decoding only, may be set by the
     * caller before avcodec_open2().
     *
     * Called by some decoders to select the pixel format that will be used for
     * the output frames. This is mainly used to set up hardware acceleration,
     * then the provided format list contains the corresponding hwaccel pixel
     * formats alongside the "software" one. The software pixel format may also
     * be retrieved from \ref sw_pix_fmt.
     *
     * This callback will be called when the coded frame properties (such as
     * resolution, pixel format, etc.) change and more than one output format is
     * supported for those new properties. If a hardware pixel format is chosen
     * and initialization for it fails, the callback may be called again
     * immediately.
     *
     * This callback may be called from different threads if the decoder is
     * multi-threaded, but not from more than one thread simultaneously.
     *
     * @param fmt list of formats which may be used in the current
     *            configuration, terminated by AV_PIX_FMT_NONE.
     * \warning Behavior is undefined if the callback returns a value other
     *          than one of the formats in fmt or AV_PIX_FMT_NONE.
     * @return the chosen format or AV_PIX_FMT_NONE
     */
    public static class Get_format_AVCodecContext_IntPointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_format_AVCodecContext_IntPointer(Pointer p) { super(p); }
        protected Get_format_AVCodecContext_IntPointer() { allocate(); }
        private native void allocate();
        public native @Cast("AVPixelFormat") int call(AVCodecContext s, @Cast("const AVPixelFormat*") IntPointer fmt);
    }
    public native Get_format_AVCodecContext_IntPointer get_format(); public native AVCodecContext get_format(Get_format_AVCodecContext_IntPointer setter);

    /**
     * maximum number of B-frames between non-B-frames
     * Note: The output will be delayed by max_b_frames+1 relative to the input.
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int max_b_frames(); public native AVCodecContext max_b_frames(int setter);

    /**
     * qscale factor between IP and B-frames
     * If > 0 then the last P-frame quantizer will be used (q= lastp_q*factor+offset).
     * If < 0 then normal ratecontrol will be done (q= -normal_q*factor+offset).
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float b_quant_factor(); public native AVCodecContext b_quant_factor(float setter);

    /**
     * qscale offset between IP and B-frames
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float b_quant_offset(); public native AVCodecContext b_quant_offset(float setter);

    /**
     * Size of the frame reordering buffer in the decoder.
     * For MPEG-2 it is 1 IPB or 0 low delay IP.
     * - encoding: Set by libavcodec.
     * - decoding: Set by libavcodec.
     */
    public native int has_b_frames(); public native AVCodecContext has_b_frames(int setter);

    /**
     * qscale factor between P- and I-frames
     * If > 0 then the last P-frame quantizer will be used (q = lastp_q * factor + offset).
     * If < 0 then normal ratecontrol will be done (q= -normal_q*factor+offset).
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float i_quant_factor(); public native AVCodecContext i_quant_factor(float setter);

    /**
     * qscale offset between P and I-frames
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float i_quant_offset(); public native AVCodecContext i_quant_offset(float setter);

    /**
     * luminance masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float lumi_masking(); public native AVCodecContext lumi_masking(float setter);

    /**
     * temporary complexity masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float temporal_cplx_masking(); public native AVCodecContext temporal_cplx_masking(float setter);

    /**
     * spatial complexity masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float spatial_cplx_masking(); public native AVCodecContext spatial_cplx_masking(float setter);

    /**
     * p block masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float p_masking(); public native AVCodecContext p_masking(float setter);

    /**
     * darkness masking (0-> disabled)
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native float dark_masking(); public native AVCodecContext dark_masking(float setter);

// #if FF_API_SLICE_OFFSET
    /**
     * slice count
     * - encoding: Set by libavcodec.
     * - decoding: Set by user (or 0).
     */
    public native @Deprecated int slice_count(); public native AVCodecContext slice_count(int setter);

    /**
     * slice offsets in the frame in bytes
     * - encoding: Set/allocated by libavcodec.
     * - decoding: Set/allocated by user (or NULL).
     */
    public native @Deprecated IntPointer slice_offset(); public native AVCodecContext slice_offset(IntPointer setter);
// #endif

    /**
     * sample aspect ratio (0 if unknown)
     * That is the width of a pixel divided by the height of the pixel.
     * Numerator and denominator must be relatively prime and smaller than 256 for some video standards.
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     */
    public native @ByRef AVRational sample_aspect_ratio(); public native AVCodecContext sample_aspect_ratio(AVRational setter);

    /**
     * motion estimation comparison function
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int me_cmp(); public native AVCodecContext me_cmp(int setter);
    /**
     * subpixel motion estimation comparison function
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int me_sub_cmp(); public native AVCodecContext me_sub_cmp(int setter);
    /**
     * macroblock comparison function (not supported yet)
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int mb_cmp(); public native AVCodecContext mb_cmp(int setter);
    /**
     * interlaced DCT comparison function
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int ildct_cmp(); public native AVCodecContext ildct_cmp(int setter);
public static final int FF_CMP_SAD =          0;
public static final int FF_CMP_SSE =          1;
public static final int FF_CMP_SATD =         2;
public static final int FF_CMP_DCT =          3;
public static final int FF_CMP_PSNR =         4;
public static final int FF_CMP_BIT =          5;
public static final int FF_CMP_RD =           6;
public static final int FF_CMP_ZERO =         7;
public static final int FF_CMP_VSAD =         8;
public static final int FF_CMP_VSSE =         9;
public static final int FF_CMP_NSSE =         10;
public static final int FF_CMP_W53 =          11;
public static final int FF_CMP_W97 =          12;
public static final int FF_CMP_DCTMAX =       13;
public static final int FF_CMP_DCT264 =       14;
public static final int FF_CMP_MEDIAN_SAD =   15;
public static final int FF_CMP_CHROMA =       256;

    /**
     * ME diamond size & shape
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int dia_size(); public native AVCodecContext dia_size(int setter);

    /**
     * amount of previous MV predictors (2a+1 x 2a+1 square)
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int last_predictor_count(); public native AVCodecContext last_predictor_count(int setter);

    /**
     * motion estimation prepass comparison function
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int me_pre_cmp(); public native AVCodecContext me_pre_cmp(int setter);

    /**
     * ME prepass diamond size & shape
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int pre_dia_size(); public native AVCodecContext pre_dia_size(int setter);

    /**
     * subpel ME quality
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int me_subpel_quality(); public native AVCodecContext me_subpel_quality(int setter);

    /**
     * maximum motion estimation search range in subpel units
     * If 0 then no limit.
     *
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int me_range(); public native AVCodecContext me_range(int setter);

    /**
     * slice flags
     * - encoding: unused
     * - decoding: Set by user.
     */
    public native int slice_flags(); public native AVCodecContext slice_flags(int setter);
/** draw_horiz_band() is called in coded order instead of display */
public static final int SLICE_FLAG_CODED_ORDER =    0x0001;
/** allow draw_horiz_band() with field slices (MPEG-2 field pics) */
public static final int SLICE_FLAG_ALLOW_FIELD =    0x0002;
/** allow draw_horiz_band() with 1 component at a time (SVQ1) */
public static final int SLICE_FLAG_ALLOW_PLANE =    0x0004;

    /**
     * macroblock decision mode
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int mb_decision(); public native AVCodecContext mb_decision(int setter);
/** uses mb_cmp */
public static final int FF_MB_DECISION_SIMPLE = 0;
/** chooses the one which needs the fewest bits */
public static final int FF_MB_DECISION_BITS =   1;
/** rate distortion */
public static final int FF_MB_DECISION_RD =     2;

    /**
     * custom intra quantization matrix
     * Must be allocated with the av_malloc() family of functions, and will be freed in
     * avcodec_free_context().
     * - encoding: Set/allocated by user, freed by libavcodec. Can be NULL.
     * - decoding: Set/allocated/freed by libavcodec.
     */
    public native @Cast("uint16_t*") ShortPointer intra_matrix(); public native AVCodecContext intra_matrix(ShortPointer setter);

    /**
     * custom inter quantization matrix
     * Must be allocated with the av_malloc() family of functions, and will be freed in
     * avcodec_free_context().
     * - encoding: Set/allocated by user, freed by libavcodec. Can be NULL.
     * - decoding: Set/allocated/freed by libavcodec.
     */
    public native @Cast("uint16_t*") ShortPointer inter_matrix(); public native AVCodecContext inter_matrix(ShortPointer setter);

    /**
     * precision of the intra DC coefficient - 8
     * - encoding: Set by user.
     * - decoding: Set by libavcodec
     */
    public native int intra_dc_precision(); public native AVCodecContext intra_dc_precision(int setter);

    /**
     * Number of macroblock rows at the top which are skipped.
     * - encoding: unused
     * - decoding: Set by user.
     */
    public native int skip_top(); public native AVCodecContext skip_top(int setter);

    /**
     * Number of macroblock rows at the bottom which are skipped.
     * - encoding: unused
     * - decoding: Set by user.
     */
    public native int skip_bottom(); public native AVCodecContext skip_bottom(int setter);

    /**
     * minimum MB Lagrange multiplier
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int mb_lmin(); public native AVCodecContext mb_lmin(int setter);

    /**
     * maximum MB Lagrange multiplier
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int mb_lmax(); public native AVCodecContext mb_lmax(int setter);

    /**
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int bidir_refine(); public native AVCodecContext bidir_refine(int setter);

    /**
     * minimum GOP size
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int keyint_min(); public native AVCodecContext keyint_min(int setter);

    /**
     * number of reference frames
     * - encoding: Set by user.
     * - decoding: Set by lavc.
     */
    public native int refs(); public native AVCodecContext refs(int setter);

    /**
     * Note: Value depends upon the compare function used for fullpel ME.
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int mv0_threshold(); public native AVCodecContext mv0_threshold(int setter);

    /**
     * Chromaticity coordinates of the source primaries.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     */
    public native @Cast("AVColorPrimaries") int color_primaries(); public native AVCodecContext color_primaries(int setter);

    /**
     * Color Transfer Characteristic.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     */
    public native @Cast("AVColorTransferCharacteristic") int color_trc(); public native AVCodecContext color_trc(int setter);

    /**
     * YUV colorspace type.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     */
    public native @Cast("AVColorSpace") int colorspace(); public native AVCodecContext colorspace(int setter);

    /**
     * MPEG vs JPEG YUV range.
     * - encoding: Set by user to override the default output color range value,
     *   If not specified, libavcodec sets the color range depending on the
     *   output format.
     * - decoding: Set by libavcodec, can be set by the user to propagate the
     *   color range to components reading from the decoder context.
     */
    public native @Cast("AVColorRange") int color_range(); public native AVCodecContext color_range(int setter);

    /**
     * This defines the location of chroma samples.
     * - encoding: Set by user
     * - decoding: Set by libavcodec
     */
    public native @Cast("AVChromaLocation") int chroma_sample_location(); public native AVCodecContext chroma_sample_location(int setter);

    /**
     * Number of slices.
     * Indicates number of picture subdivisions. Used for parallelized
     * decoding.
     * - encoding: Set by user
     * - decoding: unused
     */
    public native int slices(); public native AVCodecContext slices(int setter);

    /** Field order
     * - encoding: set by libavcodec
     * - decoding: Set by user.
     */
    public native @Cast("AVFieldOrder") int field_order(); public native AVCodecContext field_order(int setter);

    /* audio only */
    /** samples per second */
    public native int sample_rate(); public native AVCodecContext sample_rate(int setter);

// #if FF_API_OLD_CHANNEL_LAYOUT
    /**
     * number of audio channels
     * @deprecated use ch_layout.nb_channels
     */
    public native @Deprecated int channels(); public native AVCodecContext channels(int setter);
// #endif

    /**
     * audio sample format
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     */
    /** sample format */
    public native @Cast("AVSampleFormat") int sample_fmt(); public native AVCodecContext sample_fmt(int setter);

    /* The following data should not be initialized. */
    /**
     * Number of samples per channel in an audio frame.
     *
     * - encoding: set by libavcodec in avcodec_open2(). Each submitted frame
     *   except the last must contain exactly frame_size samples per channel.
     *   May be 0 when the codec has AV_CODEC_CAP_VARIABLE_FRAME_SIZE set, then the
     *   frame size is not restricted.
     * - decoding: may be set by some decoders to indicate constant frame size
     */
    public native int frame_size(); public native AVCodecContext frame_size(int setter);

// #if FF_API_AVCTX_FRAME_NUMBER
    /**
     * Frame counter, set by libavcodec.
     *
     * - decoding: total number of frames returned from the decoder so far.
     * - encoding: total number of frames passed to the encoder so far.
     *
     *   \note the counter is not incremented if encoding/decoding resulted in
     *   an error.
     *   @deprecated use frame_num instead
     */
    public native @Deprecated int frame_number(); public native AVCodecContext frame_number(int setter);
// #endif

    /**
     * number of bytes per packet if constant and known or 0
     * Used by some WAV based audio codecs.
     */
    public native int block_align(); public native AVCodecContext block_align(int setter);

    /**
     * Audio cutoff bandwidth (0 means "automatic")
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int cutoff(); public native AVCodecContext cutoff(int setter);

// #if FF_API_OLD_CHANNEL_LAYOUT
    /**
     * Audio channel layout.
     * - encoding: set by user.
     * - decoding: set by user, may be overwritten by libavcodec.
     * @deprecated use ch_layout
     */
    public native @Cast("uint64_t") @Deprecated long channel_layout(); public native AVCodecContext channel_layout(long setter);

    /**
     * Request decoder to use this channel layout if it can (0 for default)
     * - encoding: unused
     * - decoding: Set by user.
     * @deprecated use "downmix" codec private option
     */
    public native @Cast("uint64_t") @Deprecated long request_channel_layout(); public native AVCodecContext request_channel_layout(long setter);
// #endif

    /**
     * Type of service that the audio stream conveys.
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     */
    public native @Cast("AVAudioServiceType") int audio_service_type(); public native AVCodecContext audio_service_type(int setter);

    /**
     * desired sample format
     * - encoding: Not used.
     * - decoding: Set by user.
     * Decoder will decode to this format if it can.
     */
    public native @Cast("AVSampleFormat") int request_sample_fmt(); public native AVCodecContext request_sample_fmt(int setter);

    /**
     * This callback is called at the beginning of each frame to get data
     * buffer(s) for it. There may be one contiguous buffer for all the data or
     * there may be a buffer per each data plane or anything in between. What
     * this means is, you may set however many entries in buf[] you feel necessary.
     * Each buffer must be reference-counted using the AVBuffer API (see description
     * of buf[] below).
     *
     * The following fields will be set in the frame before this callback is
     * called:
     * - format
     * - width, height (video only)
     * - sample_rate, channel_layout, nb_samples (audio only)
     * Their values may differ from the corresponding values in
     * AVCodecContext. This callback must use the frame values, not the codec
     * context values, to calculate the required buffer size.
     *
     * This callback must fill the following fields in the frame:
     * - data[]
     * - linesize[]
     * - extended_data:
     *   * if the data is planar audio with more than 8 channels, then this
     *     callback must allocate and fill extended_data to contain all pointers
     *     to all data planes. data[] must hold as many pointers as it can.
     *     extended_data must be allocated with av_malloc() and will be freed in
     *     av_frame_unref().
     *   * otherwise extended_data must point to data
     * - buf[] must contain one or more pointers to AVBufferRef structures. Each of
     *   the frame's data and extended_data pointers must be contained in these. That
     *   is, one AVBufferRef for each allocated chunk of memory, not necessarily one
     *   AVBufferRef per data[] entry. See: av_buffer_create(), av_buffer_alloc(),
     *   and av_buffer_ref().
     * - extended_buf and nb_extended_buf must be allocated with av_malloc() by
     *   this callback and filled with the extra buffers if there are more
     *   buffers than buf[] can hold. extended_buf will be freed in
     *   av_frame_unref().
     *
     * If AV_CODEC_CAP_DR1 is not set then get_buffer2() must call
     * avcodec_default_get_buffer2() instead of providing buffers allocated by
     * some other means.
     *
     * Each data plane must be aligned to the maximum required by the target
     * CPU.
     *
     * @see avcodec_default_get_buffer2()
     *
     * Video:
     *
     * If AV_GET_BUFFER_FLAG_REF is set in flags then the frame may be reused
     * (read and/or written to if it is writable) later by libavcodec.
     *
     * avcodec_align_dimensions2() should be used to find the required width and
     * height, as they normally need to be rounded up to the next multiple of 16.
     *
     * Some decoders do not support linesizes changing between frames.
     *
     * If frame multithreading is used, this callback may be called from a
     * different thread, but not from more than one at once. Does not need to be
     * reentrant.
     *
     * @see avcodec_align_dimensions2()
     *
     * Audio:
     *
     * Decoders request a buffer of a particular size by setting
     * AVFrame.nb_samples prior to calling get_buffer2(). The decoder may,
     * however, utilize only part of the buffer by setting AVFrame.nb_samples
     * to a smaller value in the output frame.
     *
     * As a convenience, av_samples_get_buffer_size() and
     * av_samples_fill_arrays() in libavutil may be used by custom get_buffer2()
     * functions to find the required data size and to fill data pointers and
     * linesize. In AVFrame.linesize, only linesize[0] may be set for audio
     * since all planes must be the same size.
     *
     * @see av_samples_get_buffer_size(), av_samples_fill_arrays()
     *
     * - encoding: unused
     * - decoding: Set by libavcodec, user can override.
     */
    public static class Get_buffer2_AVCodecContext_AVFrame_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_buffer2_AVCodecContext_AVFrame_int(Pointer p) { super(p); }
        protected Get_buffer2_AVCodecContext_AVFrame_int() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext s, AVFrame frame, int flags);
    }
    public native Get_buffer2_AVCodecContext_AVFrame_int get_buffer2(); public native AVCodecContext get_buffer2(Get_buffer2_AVCodecContext_AVFrame_int setter);

    /* - encoding parameters */
    /** amount of qscale change between easy & hard scenes (0.0-1.0) */
    public native float qcompress(); public native AVCodecContext qcompress(float setter);
    /** amount of qscale smoothing over time (0.0-1.0) */
    public native float qblur(); public native AVCodecContext qblur(float setter);

    /**
     * minimum quantizer
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int qmin(); public native AVCodecContext qmin(int setter);

    /**
     * maximum quantizer
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int qmax(); public native AVCodecContext qmax(int setter);

    /**
     * maximum quantizer difference between frames
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int max_qdiff(); public native AVCodecContext max_qdiff(int setter);

    /**
     * decoder bitstream buffer size
     * - encoding: Set by user.
     * - decoding: May be set by libavcodec.
     */
    public native int rc_buffer_size(); public native AVCodecContext rc_buffer_size(int setter);

    /**
     * ratecontrol override, see RcOverride
     * - encoding: Allocated/set/freed by user.
     * - decoding: unused
     */
    public native int rc_override_count(); public native AVCodecContext rc_override_count(int setter);
    public native RcOverride rc_override(); public native AVCodecContext rc_override(RcOverride setter);

    /**
     * maximum bitrate
     * - encoding: Set by user.
     * - decoding: Set by user, may be overwritten by libavcodec.
     */
    public native @Cast("int64_t") long rc_max_rate(); public native AVCodecContext rc_max_rate(long setter);

    /**
     * minimum bitrate
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native @Cast("int64_t") long rc_min_rate(); public native AVCodecContext rc_min_rate(long setter);

    /**
     * Ratecontrol attempt to use, at maximum, <value> of what can be used without an underflow.
     * - encoding: Set by user.
     * - decoding: unused.
     */
    public native float rc_max_available_vbv_use(); public native AVCodecContext rc_max_available_vbv_use(float setter);

    /**
     * Ratecontrol attempt to use, at least, <value> times the amount needed to prevent a vbv overflow.
     * - encoding: Set by user.
     * - decoding: unused.
     */
    public native float rc_min_vbv_overflow_use(); public native AVCodecContext rc_min_vbv_overflow_use(float setter);

    /**
     * Number of bits which should be loaded into the rc buffer before decoding starts.
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int rc_initial_buffer_occupancy(); public native AVCodecContext rc_initial_buffer_occupancy(int setter);

    /**
     * trellis RD quantization
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int trellis(); public native AVCodecContext trellis(int setter);

    /**
     * pass1 encoding statistics output buffer
     * - encoding: Set by libavcodec.
     * - decoding: unused
     */
    public native @Cast("char*") BytePointer stats_out(); public native AVCodecContext stats_out(BytePointer setter);

    /**
     * pass2 encoding statistics input buffer
     * Concatenated stuff from stats_out of pass1 should be placed here.
     * - encoding: Allocated/set/freed by user.
     * - decoding: unused
     */
    public native @Cast("char*") BytePointer stats_in(); public native AVCodecContext stats_in(BytePointer setter);

    /**
     * Work around bugs in encoders which sometimes cannot be detected automatically.
     * - encoding: Set by user
     * - decoding: Set by user
     */
    public native int workaround_bugs(); public native AVCodecContext workaround_bugs(int setter);
/** autodetection */
public static final int FF_BUG_AUTODETECT =       1;
public static final int FF_BUG_XVID_ILACE =       4;
public static final int FF_BUG_UMP4 =             8;
public static final int FF_BUG_NO_PADDING =       16;
public static final int FF_BUG_AMV =              32;
public static final int FF_BUG_QPEL_CHROMA =      64;
public static final int FF_BUG_STD_QPEL =         128;
public static final int FF_BUG_QPEL_CHROMA2 =     256;
public static final int FF_BUG_DIRECT_BLOCKSIZE = 512;
public static final int FF_BUG_EDGE =             1024;
public static final int FF_BUG_HPEL_CHROMA =      2048;
public static final int FF_BUG_DC_CLIP =          4096;
/** Work around various bugs in Microsoft's broken decoders. */
public static final int FF_BUG_MS =               8192;
public static final int FF_BUG_TRUNCATED =       16384;
public static final int FF_BUG_IEDGE =           32768;

    /**
     * strictly follow the standard (MPEG-4, ...).
     * - encoding: Set by user.
     * - decoding: Set by user.
     * Setting this to STRICT or higher means the encoder and decoder will
     * generally do stupid things, whereas setting it to unofficial or lower
     * will mean the encoder might produce output that is not supported by all
     * spec-compliant decoders. Decoders don't differentiate between normal,
     * unofficial and experimental (that is, they always try to decode things
     * when they can) unless they are explicitly asked to behave stupidly
     * (=strictly conform to the specs)
     * This may only be set to one of the FF_COMPLIANCE_* values in defs.h.
     */
    public native int strict_std_compliance(); public native AVCodecContext strict_std_compliance(int setter);

    /**
     * error concealment flags
     * - encoding: unused
     * - decoding: Set by user.
     */
    public native int error_concealment(); public native AVCodecContext error_concealment(int setter);
public static final int FF_EC_GUESS_MVS =   1;
public static final int FF_EC_DEBLOCK =     2;
public static final int FF_EC_FAVOR_INTER = 256;

    /**
     * debug
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native int debug(); public native AVCodecContext debug(int setter);
public static final int FF_DEBUG_PICT_INFO =   1;
public static final int FF_DEBUG_RC =          2;
public static final int FF_DEBUG_BITSTREAM =   4;
public static final int FF_DEBUG_MB_TYPE =     8;
public static final int FF_DEBUG_QP =          16;
public static final int FF_DEBUG_DCT_COEFF =   0x00000040;
public static final int FF_DEBUG_SKIP =        0x00000080;
public static final int FF_DEBUG_STARTCODE =   0x00000100;
public static final int FF_DEBUG_ER =          0x00000400;
public static final int FF_DEBUG_MMCO =        0x00000800;
public static final int FF_DEBUG_BUGS =        0x00001000;
public static final int FF_DEBUG_BUFFERS =     0x00008000;
public static final int FF_DEBUG_THREADS =     0x00010000;
public static final int FF_DEBUG_GREEN_MD =    0x00800000;
public static final int FF_DEBUG_NOMC =        0x01000000;

    /**
     * Error recognition; may misdetect some more or less valid parts as errors.
     * This is a bitfield of the AV_EF_* values defined in defs.h.
     *
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native int err_recognition(); public native AVCodecContext err_recognition(int setter);

// #if FF_API_REORDERED_OPAQUE
    /**
     * opaque 64-bit number (generally a PTS) that will be reordered and
     * output in AVFrame.reordered_opaque
     * - encoding: Set by libavcodec to the reordered_opaque of the input
     *             frame corresponding to the last returned packet. Only
     *             supported by encoders with the
     *             AV_CODEC_CAP_ENCODER_REORDERED_OPAQUE capability.
     * - decoding: Set by user.
     *
     * @deprecated Use AV_CODEC_FLAG_COPY_OPAQUE instead
     */
    public native @Cast("int64_t") @Deprecated long reordered_opaque(); public native AVCodecContext reordered_opaque(long setter);
// #endif

    /**
     * Hardware accelerator in use
     * - encoding: unused.
     * - decoding: Set by libavcodec
     */
    public native @Const AVHWAccel hwaccel(); public native AVCodecContext hwaccel(AVHWAccel setter);

    /**
     * Legacy hardware accelerator context.
     *
     * For some hardware acceleration methods, the caller may use this field to
     * signal hwaccel-specific data to the codec. The struct pointed to by this
     * pointer is hwaccel-dependent and defined in the respective header. Please
     * refer to the FFmpeg HW accelerator documentation to know how to fill
     * this.
     *
     * In most cases this field is optional - the necessary information may also
     * be provided to libavcodec through \ref hw_frames_ctx or \ref
     * hw_device_ctx (see avcodec_get_hw_config()). However, in some cases it
     * may be the only method of signalling some (optional) information.
     *
     * The struct and its contents are owned by the caller.
     *
     * - encoding: May be set by the caller before avcodec_open2(). Must remain
     *             valid until avcodec_free_context().
     * - decoding: May be set by the caller in the get_format() callback.
     *             Must remain valid until the next get_format() call,
     *             or avcodec_free_context() (whichever comes first).
     */
    public native Pointer hwaccel_context(); public native AVCodecContext hwaccel_context(Pointer setter);

    /**
     * error
     * - encoding: Set by libavcodec if flags & AV_CODEC_FLAG_PSNR.
     * - decoding: unused
     */
    public native @Cast("uint64_t") long error(int i); public native AVCodecContext error(int i, long setter);
    @MemberGetter public native @Cast("uint64_t*") LongPointer error();

    /**
     * DCT algorithm, see FF_DCT_* below
     * - encoding: Set by user.
     * - decoding: unused
     */
    public native int dct_algo(); public native AVCodecContext dct_algo(int setter);
public static final int FF_DCT_AUTO =    0;
public static final int FF_DCT_FASTINT = 1;
public static final int FF_DCT_INT =     2;
public static final int FF_DCT_MMX =     3;
public static final int FF_DCT_ALTIVEC = 5;
public static final int FF_DCT_FAAN =    6;

    /**
     * IDCT algorithm, see FF_IDCT_* below.
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native int idct_algo(); public native AVCodecContext idct_algo(int setter);
public static final int FF_IDCT_AUTO =          0;
public static final int FF_IDCT_INT =           1;
public static final int FF_IDCT_SIMPLE =        2;
public static final int FF_IDCT_SIMPLEMMX =     3;
public static final int FF_IDCT_ARM =           7;
public static final int FF_IDCT_ALTIVEC =       8;
public static final int FF_IDCT_SIMPLEARM =     10;
public static final int FF_IDCT_XVID =          14;
public static final int FF_IDCT_SIMPLEARMV5TE = 16;
public static final int FF_IDCT_SIMPLEARMV6 =   17;
public static final int FF_IDCT_FAAN =          20;
public static final int FF_IDCT_SIMPLENEON =    22;
// #if FF_API_IDCT_NONE
// formerly used by xvmc
public static final int FF_IDCT_NONE =          24;
// #endif
public static final int FF_IDCT_SIMPLEAUTO =    128;

    /**
     * bits per sample/pixel from the demuxer (needed for huffyuv).
     * - encoding: Set by libavcodec.
     * - decoding: Set by user.
     */
     public native int bits_per_coded_sample(); public native AVCodecContext bits_per_coded_sample(int setter);

    /**
     * Bits per sample/pixel of internal libavcodec pixel/sample format.
     * - encoding: set by user.
     * - decoding: set by libavcodec.
     */
    public native int bits_per_raw_sample(); public native AVCodecContext bits_per_raw_sample(int setter);

    /**
     * low resolution decoding, 1-> 1/2 size, 2->1/4 size
     * - encoding: unused
     * - decoding: Set by user.
     */
     public native int lowres(); public native AVCodecContext lowres(int setter);

    /**
     * thread count
     * is used to decide how many independent tasks should be passed to execute()
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native int thread_count(); public native AVCodecContext thread_count(int setter);

    /**
     * Which multithreading methods to use.
     * Use of FF_THREAD_FRAME will increase decoding delay by one frame per thread,
     * so clients which cannot provide future frames should not use it.
     *
     * - encoding: Set by user, otherwise the default is used.
     * - decoding: Set by user, otherwise the default is used.
     */
    public native int thread_type(); public native AVCodecContext thread_type(int setter);
/** Decode more than one frame at once */
public static final int FF_THREAD_FRAME =   1;
/** Decode more than one part of a single frame at once */
public static final int FF_THREAD_SLICE =   2;

    /**
     * Which multithreading methods are in use by the codec.
     * - encoding: Set by libavcodec.
     * - decoding: Set by libavcodec.
     */
    public native int active_thread_type(); public native AVCodecContext active_thread_type(int setter);

    /**
     * The codec may call this to execute several independent things.
     * It will return only after finishing all tasks.
     * The user may replace this with some multithreaded implementation,
     * the default implementation will execute the parts serially.
     * @param count the number of things to execute
     * - encoding: Set by libavcodec, user can override.
     * - decoding: Set by libavcodec, user can override.
     */
    public static class Func_AVCodecContext_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Func_AVCodecContext_Pointer(Pointer p) { super(p); }
        protected Func_AVCodecContext_Pointer() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext c2, Pointer arg);
    }
    public static class Execute_AVCodecContext_Func_AVCodecContext_Pointer_Pointer_IntPointer_int_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Execute_AVCodecContext_Func_AVCodecContext_Pointer_Pointer_IntPointer_int_int(Pointer p) { super(p); }
        protected Execute_AVCodecContext_Func_AVCodecContext_Pointer_Pointer_IntPointer_int_int() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext c, Func_AVCodecContext_Pointer func, Pointer arg2, IntPointer ret, int count, int size);
    }
    public native Execute_AVCodecContext_Func_AVCodecContext_Pointer_Pointer_IntPointer_int_int execute(); public native AVCodecContext execute(Execute_AVCodecContext_Func_AVCodecContext_Pointer_Pointer_IntPointer_int_int setter);

    /**
     * The codec may call this to execute several independent things.
     * It will return only after finishing all tasks.
     * The user may replace this with some multithreaded implementation,
     * the default implementation will execute the parts serially.
     * @param c context passed also to func
     * @param count the number of things to execute
     * @param arg2 argument passed unchanged to func
     * @param ret return values of executed functions, must have space for "count" values. May be NULL.
     * @param func function that will be called count times, with jobnr from 0 to count-1.
     *             threadnr will be in the range 0 to c->thread_count-1 < MAX_THREADS and so that no
     *             two instances of func executing at the same time will have the same threadnr.
     * @return always 0 currently, but code should handle a future improvement where when any call to func
     *         returns < 0 no further calls to func may be done and < 0 is returned.
     * - encoding: Set by libavcodec, user can override.
     * - decoding: Set by libavcodec, user can override.
     */
    public static class Func_AVCodecContext_Pointer_int_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Func_AVCodecContext_Pointer_int_int(Pointer p) { super(p); }
        protected Func_AVCodecContext_Pointer_int_int() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext c2, Pointer arg, int jobnr, int threadnr);
    }
    public static class Execute2_AVCodecContext_Func_AVCodecContext_Pointer_int_int_Pointer_IntPointer_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Execute2_AVCodecContext_Func_AVCodecContext_Pointer_int_int_Pointer_IntPointer_int(Pointer p) { super(p); }
        protected Execute2_AVCodecContext_Func_AVCodecContext_Pointer_int_int_Pointer_IntPointer_int() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext c, Func_AVCodecContext_Pointer_int_int func, Pointer arg2, IntPointer ret, int count);
    }
    public native Execute2_AVCodecContext_Func_AVCodecContext_Pointer_int_int_Pointer_IntPointer_int execute2(); public native AVCodecContext execute2(Execute2_AVCodecContext_Func_AVCodecContext_Pointer_int_int_Pointer_IntPointer_int setter);

    /**
     * noise vs. sse weight for the nsse comparison function
     * - encoding: Set by user.
     * - decoding: unused
     */
     public native int nsse_weight(); public native AVCodecContext nsse_weight(int setter);

    /**
     * profile
     * - encoding: Set by user.
     * - decoding: Set by libavcodec.
     * See the AV_PROFILE_* defines in defs.h.
     */
     public native int profile(); public native AVCodecContext profile(int setter);
// #if FF_API_FF_PROFILE_LEVEL
    /** @deprecated The following defines are deprecated; use AV_PROFILE_*
     * in defs.h instead. */
public static final int FF_PROFILE_UNKNOWN = -99;
public static final int FF_PROFILE_RESERVED = -100;

public static final int FF_PROFILE_AAC_MAIN = 0;
public static final int FF_PROFILE_AAC_LOW =  1;
public static final int FF_PROFILE_AAC_SSR =  2;
public static final int FF_PROFILE_AAC_LTP =  3;
public static final int FF_PROFILE_AAC_HE =   4;
public static final int FF_PROFILE_AAC_HE_V2 = 28;
public static final int FF_PROFILE_AAC_LD =   22;
public static final int FF_PROFILE_AAC_ELD =  38;
public static final int FF_PROFILE_MPEG2_AAC_LOW = 128;
public static final int FF_PROFILE_MPEG2_AAC_HE =  131;

public static final int FF_PROFILE_DNXHD =         0;
public static final int FF_PROFILE_DNXHR_LB =      1;
public static final int FF_PROFILE_DNXHR_SQ =      2;
public static final int FF_PROFILE_DNXHR_HQ =      3;
public static final int FF_PROFILE_DNXHR_HQX =     4;
public static final int FF_PROFILE_DNXHR_444 =     5;

public static final int FF_PROFILE_DTS =                20;
public static final int FF_PROFILE_DTS_ES =             30;
public static final int FF_PROFILE_DTS_96_24 =          40;
public static final int FF_PROFILE_DTS_HD_HRA =         50;
public static final int FF_PROFILE_DTS_HD_MA =          60;
public static final int FF_PROFILE_DTS_EXPRESS =        70;
public static final int FF_PROFILE_DTS_HD_MA_X =        61;
public static final int FF_PROFILE_DTS_HD_MA_X_IMAX =   62;


public static final int FF_PROFILE_EAC3_DDP_ATMOS =         30;

public static final int FF_PROFILE_TRUEHD_ATMOS =           30;

public static final int FF_PROFILE_MPEG2_422 =    0;
public static final int FF_PROFILE_MPEG2_HIGH =   1;
public static final int FF_PROFILE_MPEG2_SS =     2;
public static final int FF_PROFILE_MPEG2_SNR_SCALABLE =  3;
public static final int FF_PROFILE_MPEG2_MAIN =   4;
public static final int FF_PROFILE_MPEG2_SIMPLE = 5;

public static final int FF_PROFILE_H264_CONSTRAINED =  (1<<9);  // 8+1; constraint_set1_flag
public static final int FF_PROFILE_H264_INTRA =        (1<<11); // 8+3; constraint_set3_flag

public static final int FF_PROFILE_H264_BASELINE =             66;
public static final int FF_PROFILE_H264_CONSTRAINED_BASELINE = (66|FF_PROFILE_H264_CONSTRAINED);
public static final int FF_PROFILE_H264_MAIN =                 77;
public static final int FF_PROFILE_H264_EXTENDED =             88;
public static final int FF_PROFILE_H264_HIGH =                 100;
public static final int FF_PROFILE_H264_HIGH_10 =              110;
public static final int FF_PROFILE_H264_HIGH_10_INTRA =        (110|FF_PROFILE_H264_INTRA);
public static final int FF_PROFILE_H264_MULTIVIEW_HIGH =       118;
public static final int FF_PROFILE_H264_HIGH_422 =             122;
public static final int FF_PROFILE_H264_HIGH_422_INTRA =       (122|FF_PROFILE_H264_INTRA);
public static final int FF_PROFILE_H264_STEREO_HIGH =          128;
public static final int FF_PROFILE_H264_HIGH_444 =             144;
public static final int FF_PROFILE_H264_HIGH_444_PREDICTIVE =  244;
public static final int FF_PROFILE_H264_HIGH_444_INTRA =       (244|FF_PROFILE_H264_INTRA);
public static final int FF_PROFILE_H264_CAVLC_444 =            44;

public static final int FF_PROFILE_VC1_SIMPLE =   0;
public static final int FF_PROFILE_VC1_MAIN =     1;
public static final int FF_PROFILE_VC1_COMPLEX =  2;
public static final int FF_PROFILE_VC1_ADVANCED = 3;

public static final int FF_PROFILE_MPEG4_SIMPLE =                     0;
public static final int FF_PROFILE_MPEG4_SIMPLE_SCALABLE =            1;
public static final int FF_PROFILE_MPEG4_CORE =                       2;
public static final int FF_PROFILE_MPEG4_MAIN =                       3;
public static final int FF_PROFILE_MPEG4_N_BIT =                      4;
public static final int FF_PROFILE_MPEG4_SCALABLE_TEXTURE =           5;
public static final int FF_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION =      6;
public static final int FF_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE =     7;
public static final int FF_PROFILE_MPEG4_HYBRID =                     8;
public static final int FF_PROFILE_MPEG4_ADVANCED_REAL_TIME =         9;
public static final int FF_PROFILE_MPEG4_CORE_SCALABLE =             10;
public static final int FF_PROFILE_MPEG4_ADVANCED_CODING =           11;
public static final int FF_PROFILE_MPEG4_ADVANCED_CORE =             12;
public static final int FF_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE = 13;
public static final int FF_PROFILE_MPEG4_SIMPLE_STUDIO =             14;
public static final int FF_PROFILE_MPEG4_ADVANCED_SIMPLE =           15;

public static final int FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0 =   1;
public static final int FF_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1 =   2;
public static final int FF_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION =  32768;
public static final int FF_PROFILE_JPEG2000_DCINEMA_2K =              3;
public static final int FF_PROFILE_JPEG2000_DCINEMA_4K =              4;

public static final int FF_PROFILE_VP9_0 =                            0;
public static final int FF_PROFILE_VP9_1 =                            1;
public static final int FF_PROFILE_VP9_2 =                            2;
public static final int FF_PROFILE_VP9_3 =                            3;

public static final int FF_PROFILE_HEVC_MAIN =                        1;
public static final int FF_PROFILE_HEVC_MAIN_10 =                     2;
public static final int FF_PROFILE_HEVC_MAIN_STILL_PICTURE =          3;
public static final int FF_PROFILE_HEVC_REXT =                        4;
public static final int FF_PROFILE_HEVC_SCC =                         9;

public static final int FF_PROFILE_VVC_MAIN_10 =                      1;
public static final int FF_PROFILE_VVC_MAIN_10_444 =                 33;

public static final int FF_PROFILE_AV1_MAIN =                         0;
public static final int FF_PROFILE_AV1_HIGH =                         1;
public static final int FF_PROFILE_AV1_PROFESSIONAL =                 2;

public static final int FF_PROFILE_MJPEG_HUFFMAN_BASELINE_DCT =            0xc0;
public static final int FF_PROFILE_MJPEG_HUFFMAN_EXTENDED_SEQUENTIAL_DCT = 0xc1;
public static final int FF_PROFILE_MJPEG_HUFFMAN_PROGRESSIVE_DCT =         0xc2;
public static final int FF_PROFILE_MJPEG_HUFFMAN_LOSSLESS =                0xc3;
public static final int FF_PROFILE_MJPEG_JPEG_LS =                         0xf7;

public static final int FF_PROFILE_SBC_MSBC =                         1;

public static final int FF_PROFILE_PRORES_PROXY =     0;
public static final int FF_PROFILE_PRORES_LT =        1;
public static final int FF_PROFILE_PRORES_STANDARD =  2;
public static final int FF_PROFILE_PRORES_HQ =        3;
public static final int FF_PROFILE_PRORES_4444 =      4;
public static final int FF_PROFILE_PRORES_XQ =        5;

public static final int FF_PROFILE_ARIB_PROFILE_A = 0;
public static final int FF_PROFILE_ARIB_PROFILE_C = 1;

public static final int FF_PROFILE_KLVA_SYNC = 0;
public static final int FF_PROFILE_KLVA_ASYNC = 1;

public static final int FF_PROFILE_EVC_BASELINE =             0;
public static final int FF_PROFILE_EVC_MAIN =                 1;
// #endif

    /**
     * Encoding level descriptor.
     * - encoding: Set by user, corresponds to a specific level defined by the
     *   codec, usually corresponding to the profile level, if not specified it
     *   is set to FF_LEVEL_UNKNOWN.
     * - decoding: Set by libavcodec.
     * See AV_LEVEL_* in defs.h.
     */
     public native int level(); public native AVCodecContext level(int setter);
// #if FF_API_FF_PROFILE_LEVEL
    /** @deprecated The following define is deprecated; use AV_LEVEL_UNKOWN
     * in defs.h instead. */
public static final int FF_LEVEL_UNKNOWN = -99;
// #endif

    /**
     * Skip loop filtering for selected frames.
     * - encoding: unused
     * - decoding: Set by user.
     */
    public native @Cast("AVDiscard") int skip_loop_filter(); public native AVCodecContext skip_loop_filter(int setter);

    /**
     * Skip IDCT/dequantization for selected frames.
     * - encoding: unused
     * - decoding: Set by user.
     */
    public native @Cast("AVDiscard") int skip_idct(); public native AVCodecContext skip_idct(int setter);

    /**
     * Skip decoding for selected frames.
     * - encoding: unused
     * - decoding: Set by user.
     */
    public native @Cast("AVDiscard") int skip_frame(); public native AVCodecContext skip_frame(int setter);

    /**
     * Header containing style information for text subtitles.
     * For SUBTITLE_ASS subtitle type, it should contain the whole ASS
     * [Script Info] and [V4+ Styles] section, plus the [Events] line and
     * the Format line following. It shouldn't include any Dialogue line.
     * - encoding: Set/allocated/freed by user (before avcodec_open2())
     * - decoding: Set/allocated/freed by libavcodec (by avcodec_open2())
     */
    public native @Cast("uint8_t*") BytePointer subtitle_header(); public native AVCodecContext subtitle_header(BytePointer setter);
    public native int subtitle_header_size(); public native AVCodecContext subtitle_header_size(int setter);

    /**
     * Audio only. The number of "priming" samples (padding) inserted by the
     * encoder at the beginning of the audio. I.e. this number of leading
     * decoded samples must be discarded by the caller to get the original audio
     * without leading padding.
     *
     * - decoding: unused
     * - encoding: Set by libavcodec. The timestamps on the output packets are
     *             adjusted by the encoder so that they always refer to the
     *             first sample of the data actually contained in the packet,
     *             including any added padding.  E.g. if the timebase is
     *             1/samplerate and the timestamp of the first input sample is
     *             0, the timestamp of the first output packet will be
     *             -initial_padding.
     */
    public native int initial_padding(); public native AVCodecContext initial_padding(int setter);

    /**
     * - decoding: For codecs that store a framerate value in the compressed
     *             bitstream, the decoder may export it here. { 0, 1} when
     *             unknown.
     * - encoding: May be used to signal the framerate of CFR content to an
     *             encoder.
     */
    public native @ByRef AVRational framerate(); public native AVCodecContext framerate(AVRational setter);

    /**
     * Nominal unaccelerated pixel format, see AV_PIX_FMT_xxx.
     * - encoding: unused.
     * - decoding: Set by libavcodec before calling get_format()
     */
    public native @Cast("AVPixelFormat") int sw_pix_fmt(); public native AVCodecContext sw_pix_fmt(int setter);

    /**
     * Timebase in which pkt_dts/pts and AVPacket.dts/pts are expressed.
     * - encoding: unused.
     * - decoding: set by user.
     */
    public native @ByRef AVRational pkt_timebase(); public native AVCodecContext pkt_timebase(AVRational setter);

    /**
     * AVCodecDescriptor
     * - encoding: unused.
     * - decoding: set by libavcodec.
     */
    public native @Const AVCodecDescriptor codec_descriptor(); public native AVCodecContext codec_descriptor(AVCodecDescriptor setter);

    /**
     * Current statistics for PTS correction.
     * - decoding: maintained and used by libavcodec, not intended to be used by user apps
     * - encoding: unused
     */
    public native @Cast("int64_t") long pts_correction_num_faulty_pts(); public native AVCodecContext pts_correction_num_faulty_pts(long setter); /** Number of incorrect PTS values so far */
    public native @Cast("int64_t") long pts_correction_num_faulty_dts(); public native AVCodecContext pts_correction_num_faulty_dts(long setter); /** Number of incorrect DTS values so far */
    public native @Cast("int64_t") long pts_correction_last_pts(); public native AVCodecContext pts_correction_last_pts(long setter);       /** PTS of the last frame */
    public native @Cast("int64_t") long pts_correction_last_dts(); public native AVCodecContext pts_correction_last_dts(long setter);       /** DTS of the last frame
    <p>
    /**
     * Character encoding of the input subtitles file.
     * - decoding: set by user
     * - encoding: unused
     */
    public native @Cast("char*") BytePointer sub_charenc(); public native AVCodecContext sub_charenc(BytePointer setter);

    /**
     * Subtitles character encoding mode. Formats or codecs might be adjusting
     * this setting (if they are doing the conversion themselves for instance).
     * - decoding: set by libavcodec
     * - encoding: unused
     */
    public native int sub_charenc_mode(); public native AVCodecContext sub_charenc_mode(int setter);
/** do nothing (demuxer outputs a stream supposed to be already in UTF-8, or the codec is bitmap for instance) */
public static final int FF_SUB_CHARENC_MODE_DO_NOTHING =  -1;
/** libavcodec will select the mode itself */
public static final int FF_SUB_CHARENC_MODE_AUTOMATIC =    0;
/** the AVPacket data needs to be recoded to UTF-8 before being fed to the decoder, requires iconv */
public static final int FF_SUB_CHARENC_MODE_PRE_DECODER =  1;
/** neither convert the subtitles, nor check them for valid UTF-8 */
public static final int FF_SUB_CHARENC_MODE_IGNORE =       2;

    /**
     * Skip processing alpha if supported by codec.
     * Note that if the format uses pre-multiplied alpha (common with VP6,
     * and recommended due to better video quality/compression)
     * the image will look as if alpha-blended onto a black background.
     * However for formats that do not use pre-multiplied alpha
     * there might be serious artefacts (though e.g. libswscale currently
     * assumes pre-multiplied alpha anyway).
     *
     * - decoding: set by user
     * - encoding: unused
     */
    public native int skip_alpha(); public native AVCodecContext skip_alpha(int setter);

    /**
     * Number of samples to skip after a discontinuity
     * - decoding: unused
     * - encoding: set by libavcodec
     */
    public native int seek_preroll(); public native AVCodecContext seek_preroll(int setter);

    /**
     * custom intra quantization matrix
     * - encoding: Set by user, can be NULL.
     * - decoding: unused.
     */
    public native @Cast("uint16_t*") ShortPointer chroma_intra_matrix(); public native AVCodecContext chroma_intra_matrix(ShortPointer setter);

    /**
     * dump format separator.
     * can be ", " or "\n      " or anything else
     * - encoding: Set by user.
     * - decoding: Set by user.
     */
    public native @Cast("uint8_t*") BytePointer dump_separator(); public native AVCodecContext dump_separator(BytePointer setter);

    /**
     * ',' separated list of allowed decoders.
     * If NULL then all are allowed
     * - encoding: unused
     * - decoding: set by user
     */
    public native @Cast("char*") BytePointer codec_whitelist(); public native AVCodecContext codec_whitelist(BytePointer setter);

    /**
     * Properties of the stream that gets decoded
     * - encoding: unused
     * - decoding: set by libavcodec
     */
    public native @Cast("unsigned") int properties(); public native AVCodecContext properties(int setter);
public static final int FF_CODEC_PROPERTY_LOSSLESS =        0x00000001;
public static final int FF_CODEC_PROPERTY_CLOSED_CAPTIONS = 0x00000002;
public static final int FF_CODEC_PROPERTY_FILM_GRAIN =      0x00000004;

    /**
     * Additional data associated with the entire coded stream.
     *
     * - decoding: may be set by user before calling avcodec_open2().
     * - encoding: may be set by libavcodec after avcodec_open2().
     */
    public native AVPacketSideData coded_side_data(); public native AVCodecContext coded_side_data(AVPacketSideData setter);
    public native int nb_coded_side_data(); public native AVCodecContext nb_coded_side_data(int setter);

    /**
     * A reference to the AVHWFramesContext describing the input (for encoding)
     * or output (decoding) frames. The reference is set by the caller and
     * afterwards owned (and freed) by libavcodec - it should never be read by
     * the caller after being set.
     *
     * - decoding: This field should be set by the caller from the get_format()
     *             callback. The previous reference (if any) will always be
     *             unreffed by libavcodec before the get_format() call.
     *
     *             If the default get_buffer2() is used with a hwaccel pixel
     *             format, then this AVHWFramesContext will be used for
     *             allocating the frame buffers.
     *
     * - encoding: For hardware encoders configured to use a hwaccel pixel
     *             format, this field should be set by the caller to a reference
     *             to the AVHWFramesContext describing input frames.
     *             AVHWFramesContext.format must be equal to
     *             AVCodecContext.pix_fmt.
     *
     *             This field should be set before avcodec_open2() is called.
     */
    public native AVBufferRef hw_frames_ctx(); public native AVCodecContext hw_frames_ctx(AVBufferRef setter);

    /**
     * Audio only. The amount of padding (in samples) appended by the encoder to
     * the end of the audio. I.e. this number of decoded samples must be
     * discarded by the caller from the end of the stream to get the original
     * audio without any trailing padding.
     *
     * - decoding: unused
     * - encoding: unused
     */
    public native int trailing_padding(); public native AVCodecContext trailing_padding(int setter);

    /**
     * The number of pixels per image to maximally accept.
     *
     * - decoding: set by user
     * - encoding: set by user
     */
    public native @Cast("int64_t") long max_pixels(); public native AVCodecContext max_pixels(long setter);

    /**
     * A reference to the AVHWDeviceContext describing the device which will
     * be used by a hardware encoder/decoder.  The reference is set by the
     * caller and afterwards owned (and freed) by libavcodec.
     *
     * This should be used if either the codec device does not require
     * hardware frames or any that are used are to be allocated internally by
     * libavcodec.  If the user wishes to supply any of the frames used as
     * encoder input or decoder output then hw_frames_ctx should be used
     * instead.  When hw_frames_ctx is set in get_format() for a decoder, this
     * field will be ignored while decoding the associated stream segment, but
     * may again be used on a following one after another get_format() call.
     *
     * For both encoders and decoders this field should be set before
     * avcodec_open2() is called and must not be written to thereafter.
     *
     * Note that some decoders may require this field to be set initially in
     * order to support hw_frames_ctx at all - in that case, all frames
     * contexts used must be created on the same device.
     */
    public native AVBufferRef hw_device_ctx(); public native AVCodecContext hw_device_ctx(AVBufferRef setter);

    /**
     * Bit set of AV_HWACCEL_FLAG_* flags, which affect hardware accelerated
     * decoding (if active).
     * - encoding: unused
     * - decoding: Set by user (either before avcodec_open2(), or in the
     *             AVCodecContext.get_format callback)
     */
    public native int hwaccel_flags(); public native AVCodecContext hwaccel_flags(int setter);

    /**
     * Video decoding only. Certain video codecs support cropping, meaning that
     * only a sub-rectangle of the decoded frame is intended for display.  This
     * option controls how cropping is handled by libavcodec.
     *
     * When set to 1 (the default), libavcodec will apply cropping internally.
     * I.e. it will modify the output frame width/height fields and offset the
     * data pointers (only by as much as possible while preserving alignment, or
     * by the full amount if the AV_CODEC_FLAG_UNALIGNED flag is set) so that
     * the frames output by the decoder refer only to the cropped area. The
     * crop_* fields of the output frames will be zero.
     *
     * When set to 0, the width/height fields of the output frames will be set
     * to the coded dimensions and the crop_* fields will describe the cropping
     * rectangle. Applying the cropping is left to the caller.
     *
     * \warning When hardware acceleration with opaque output frames is used,
     * libavcodec is unable to apply cropping from the top/left border.
     *
     * \note when this option is set to zero, the width/height fields of the
     * AVCodecContext and output AVFrames have different meanings. The codec
     * context fields store display dimensions (with the coded dimensions in
     * coded_width/height), while the frame fields store the coded dimensions
     * (with the display dimensions being determined by the crop_* fields).
     */
    public native int apply_cropping(); public native AVCodecContext apply_cropping(int setter);

    /*
     * Video decoding only.  Sets the number of extra hardware frames which
     * the decoder will allocate for use by the caller.  This must be set
     * before avcodec_open2() is called.
     *
     * Some hardware decoders require all frames that they will use for
     * output to be defined in advance before decoding starts.  For such
     * decoders, the hardware frame pool must therefore be of a fixed size.
     * The extra frames set here are on top of any number that the decoder
     * needs internally in order to operate normally (for example, frames
     * used as reference pictures).
     */
    public native int extra_hw_frames(); public native AVCodecContext extra_hw_frames(int setter);

    /**
     * The percentage of damaged samples to discard a frame.
     *
     * - decoding: set by user
     * - encoding: unused
     */
    public native int discard_damaged_percentage(); public native AVCodecContext discard_damaged_percentage(int setter);

    /**
     * The number of samples per frame to maximally accept.
     *
     * - decoding: set by user
     * - encoding: set by user
     */
    public native @Cast("int64_t") long max_samples(); public native AVCodecContext max_samples(long setter);

    /**
     * Bit set of AV_CODEC_EXPORT_DATA_* flags, which affects the kind of
     * metadata exported in frame, packet, or coded stream side data by
     * decoders and encoders.
     *
     * - decoding: set by user
     * - encoding: set by user
     */
    public native int export_side_data(); public native AVCodecContext export_side_data(int setter);

    /**
     * This callback is called at the beginning of each packet to get a data
     * buffer for it.
     *
     * The following field will be set in the packet before this callback is
     * called:
     * - size
     * This callback must use the above value to calculate the required buffer size,
     * which must padded by at least AV_INPUT_BUFFER_PADDING_SIZE bytes.
     *
     * In some specific cases, the encoder may not use the entire buffer allocated by this
     * callback. This will be reflected in the size value in the packet once returned by
     * avcodec_receive_packet().
     *
     * This callback must fill the following fields in the packet:
     * - data: alignment requirements for AVPacket apply, if any. Some architectures and
     *   encoders may benefit from having aligned data.
     * - buf: must contain a pointer to an AVBufferRef structure. The packet's
     *   data pointer must be contained in it. See: av_buffer_create(), av_buffer_alloc(),
     *   and av_buffer_ref().
     *
     * If AV_CODEC_CAP_DR1 is not set then get_encode_buffer() must call
     * avcodec_default_get_encode_buffer() instead of providing a buffer allocated by
     * some other means.
     *
     * The flags field may contain a combination of AV_GET_ENCODE_BUFFER_FLAG_ flags.
     * They may be used for example to hint what use the buffer may get after being
     * created.
     * Implementations of this callback may ignore flags they don't understand.
     * If AV_GET_ENCODE_BUFFER_FLAG_REF is set in flags then the packet may be reused
     * (read and/or written to if it is writable) later by libavcodec.
     *
     * This callback must be thread-safe, as when frame threading is used, it may
     * be called from multiple threads simultaneously.
     *
     * @see avcodec_default_get_encode_buffer()
     *
     * - encoding: Set by libavcodec, user can override.
     * - decoding: unused
     */
    public static class Get_encode_buffer_AVCodecContext_AVPacket_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_encode_buffer_AVCodecContext_AVPacket_int(Pointer p) { super(p); }
        protected Get_encode_buffer_AVCodecContext_AVPacket_int() { allocate(); }
        private native void allocate();
        public native int call(AVCodecContext s, AVPacket pkt, int flags);
    }
    public native Get_encode_buffer_AVCodecContext_AVPacket_int get_encode_buffer(); public native AVCodecContext get_encode_buffer(Get_encode_buffer_AVCodecContext_AVPacket_int setter);

    /**
     * Audio channel layout.
     * - encoding: must be set by the caller, to one of AVCodec.ch_layouts.
     * - decoding: may be set by the caller if known e.g. from the container.
     *             The decoder can then override during decoding as needed.
     */
    public native @ByRef AVChannelLayout ch_layout(); public native AVCodecContext ch_layout(AVChannelLayout setter);

    /**
     * Frame counter, set by libavcodec.
     *
     * - decoding: total number of frames returned from the decoder so far.
     * - encoding: total number of frames passed to the encoder so far.
     *
     *   \note the counter is not incremented if encoding/decoding resulted in
     *   an error.
     */
    public native @Cast("int64_t") long frame_num(); public native AVCodecContext frame_num(long setter);
}
