/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main.scan;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.citrusframework.TestClass;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.main.scan.AbstractTestScanner;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarFileTestScanner
extends AbstractTestScanner {
    private static final Logger logger = LoggerFactory.getLogger(JarFileTestScanner.class);
    private final File artifact;

    public JarFileTestScanner(File artifact, String ... includes) {
        super(includes);
        this.artifact = artifact;
    }

    public List<TestClass> findTestsInPackage(String packageToScan) {
        boolean packageIsEmpty = packageToScan.isEmpty();
        String packageAsPath = packageToScan.replace(".", "/");
        ArrayList<TestClass> testClasses = new ArrayList<TestClass>();
        if (this.artifact != null && this.artifact.isFile()) {
            try (JarFile jar = new JarFile(this.artifact);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String className = FileUtils.getBaseName(entry.getName()).replace("/", ".");
                    boolean isTestClass = (packageIsEmpty || packageAsPath.startsWith(entry.getName())) && entry.getName().endsWith(".class") && this.isIncluded(className);
                    if (!isTestClass) continue;
                    logger.info("Found test class candidate in test jar file: {}", (Object)entry.getName());
                    testClasses.add(TestClass.fromString((String)className));
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to access jar file artifact", (Throwable)e);
            }
        }
        return testClasses;
    }
}

