/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.selector;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageSelector;
import org.citrusframework.message.selector.AbstractMessageSelector;

public class PayloadMatchingMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_ID = "payload";

    public PayloadMatchingMessageSelector(String selectKey, String matchingValue, TestContext context) {
        super(selectKey, matchingValue, context);
        if (!selectKey.equals(SELECTOR_ID)) {
            throw new CitrusRuntimeException(String.format("Invalid usage of payload matching message selector - usage restricted to key '%s' but was '%s'", SELECTOR_ID, selectKey));
        }
    }

    public boolean accept(Message message) {
        return this.evaluate(this.getPayloadAsString(message));
    }

    public static class Factory
    implements MessageSelector.MessageSelectorFactory {
        public boolean supports(String key) {
            return key.equals(PayloadMatchingMessageSelector.SELECTOR_ID);
        }

        public PayloadMatchingMessageSelector create(String key, String value, TestContext context) {
            return new PayloadMatchingMessageSelector(key, value, context);
        }
    }
}

