/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.concurrent.CountDownLatch;
import org.citrusframework.report.LoggingReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputStreamReporter
extends LoggingReporter {
    private static final Logger logger = LoggerFactory.getLogger(OutputStreamReporter.class);
    private Writer logWriter;
    private String format = "%s\t| %s%n";
    private CountDownLatch failedCounter = new CountDownLatch(5);

    public OutputStreamReporter(OutputStream logStream) {
        this(new BufferedWriter(new OutputStreamWriter(logStream)));
    }

    public OutputStreamReporter(Writer logWriter) {
        this.logWriter = logWriter;
    }

    @Override
    protected void info(String line) {
        this.writeSafely("INFO", line);
    }

    @Override
    protected void debug(String line) {
        if (this.isDebugEnabled()) {
            this.writeSafely("DEBUG", line);
        }
    }

    @Override
    protected void error(String line, Throwable cause) {
        this.writeSafely("ERROR", line + ": " + cause.getMessage());
    }

    @Override
    protected boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    private synchronized void writeSafely(String level, String line) {
        if (this.logWriter != null && this.failedCounter.getCount() > 0L) {
            try {
                this.logWriter.write(String.format(this.format, level, line));
            }
            catch (IOException e) {
                this.failedCounter.countDown();
                logger.warn("Failed to write logging event to output stream", (Throwable)e);
            }
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Writer getLogWriter() {
        return this.logWriter;
    }

    protected void setLogWriter(Writer writer) {
        this.logWriter = writer;
    }
}

