/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.ShutdownPhase;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.context.TestContextFactoryBean;
import org.citrusframework.endpoint.AbstractEndpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jms.endpoint.JmsConsumer;
import org.citrusframework.jms.endpoint.JmsEndpointConfiguration;
import org.citrusframework.jms.endpoint.JmsProducer;
import org.citrusframework.jms.endpoint.JmsTopicSubscriber;
import org.citrusframework.messaging.Producer;
import org.citrusframework.messaging.SelectiveConsumer;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public class JmsEndpoint
extends AbstractEndpoint
implements InitializingPhase,
ShutdownPhase,
ReferenceResolverAware {
    private JmsProducer jmsProducer;
    private JmsConsumer jmsConsumer;
    private ReferenceResolver referenceResolver;

    public JmsEndpoint() {
        super((EndpointConfiguration)new JmsEndpointConfiguration());
    }

    public JmsEndpoint(JmsEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public SelectiveConsumer createConsumer() {
        if (this.jmsConsumer == null) {
            if (this.getEndpointConfiguration().isAutoStart()) {
                TestContextFactory testContextFactory = this.getTestContextFactory();
                JmsTopicSubscriber jmsTopicSubscriber = new JmsTopicSubscriber(this.getSubscriberName(), this.getEndpointConfiguration(), testContextFactory);
                this.jmsConsumer = jmsTopicSubscriber;
                jmsTopicSubscriber.start();
            } else {
                this.jmsConsumer = new JmsConsumer(this.getConsumerName(), this.getEndpointConfiguration());
            }
        }
        return this.jmsConsumer;
    }

    private TestContextFactory getTestContextFactory() {
        if (this.referenceResolver != null && !this.referenceResolver.resolveAll(TestContextFactoryBean.class).isEmpty()) {
            return (TestContextFactory)this.referenceResolver.resolve(TestContextFactoryBean.class);
        }
        return TestContextFactory.newInstance();
    }

    public Producer createProducer() {
        if (this.jmsProducer == null) {
            this.jmsProducer = new JmsProducer(this.getProducerName(), this.getEndpointConfiguration());
        }
        return this.jmsProducer;
    }

    protected String getSubscriberName() {
        return this.getName() + ":subscriber";
    }

    public JmsEndpointConfiguration getEndpointConfiguration() {
        return (JmsEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void destroy() {
        if (this.jmsConsumer instanceof JmsTopicSubscriber) {
            ((JmsTopicSubscriber)this.jmsConsumer).stop();
        }
    }

    public void initialize() {
        if (this.getEndpointConfiguration().isAutoStart()) {
            if (!this.getEndpointConfiguration().isPubSubDomain()) {
                throw new CitrusRuntimeException("Invalid endpoint configuration - caching subscriber enabled but pubSubDomain is set to false - please enable pubSubDomain");
            }
            this.createConsumer();
        }
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

