/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicSession;
import java.util.Objects;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.PollableEndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ReplyMessageTimeoutException;
import org.citrusframework.jms.endpoint.JmsProducer;
import org.citrusframework.jms.endpoint.JmsSyncEndpointConfiguration;
import org.citrusframework.message.correlation.CorrelationManager;
import org.citrusframework.message.correlation.PollingCorrelationManager;
import org.citrusframework.messaging.ReplyConsumer;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

public class JmsSyncProducer
extends JmsProducer
implements ReplyConsumer {
    private Connection connection = null;
    private Session session = null;
    private CorrelationManager<org.citrusframework.message.Message> correlationManager;
    private final JmsSyncEndpointConfiguration endpointConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(JmsSyncProducer.class);

    public JmsSyncProducer(String name, JmsSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    @Override
    public void send(org.citrusframework.message.Message message, TestContext context) {
        ObjectHelper.assertNotNull((Object)message, (String)"Message is empty - unable to send empty message");
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        context.onOutboundMessage(message);
        MessageProducer messageProducer = null;
        MessageConsumer messageConsumer = null;
        Destination replyToDestination = null;
        try {
            Message jmsReplyMessage;
            Destination destination;
            this.createConnection();
            this.createSession(this.connection);
            Message jmsRequest = this.endpointConfiguration.getMessageConverter().createJmsMessage(message, this.session, this.endpointConfiguration, context);
            this.endpointConfiguration.getMessageConverter().convertOutbound(jmsRequest, message, this.endpointConfiguration, context);
            if (this.endpointConfiguration.getDestination() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending JMS message to destination: '" + this.endpointConfiguration.getDestinationName(this.endpointConfiguration.getDestination()) + "'");
                }
                destination = this.endpointConfiguration.getDestination();
            } else if (StringUtils.hasText((String)this.endpointConfiguration.getDestinationName())) {
                destination = this.endpointConfiguration.getDestinationNameResolver() != null ? this.resolveDestination(context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationNameResolver().resolveEndpointUri(message, this.endpointConfiguration.getDestinationName()))) : this.resolveDestination(context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationName()));
            } else if (this.endpointConfiguration.getJmsTemplate().getDefaultDestination() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending JMS message to destination: '" + this.endpointConfiguration.getDestinationName(this.endpointConfiguration.getJmsTemplate().getDefaultDestination()) + "'");
                }
                destination = this.endpointConfiguration.getJmsTemplate().getDefaultDestination();
            } else if (StringUtils.hasText((String)this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName())) {
                destination = this.resolveDestination(context.replaceDynamicContentInString(this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName()));
            } else {
                throw new CitrusRuntimeException("Unable to send message - JMS destination not set");
            }
            messageProducer = this.session.createProducer(destination);
            replyToDestination = this.getReplyDestination(this.session, message);
            context.setVariable("citrus_message_replyTo_" + correlationKeyName, (Object)replyToDestination);
            if (replyToDestination instanceof TemporaryQueue || replyToDestination instanceof TemporaryTopic) {
                messageConsumer = this.session.createConsumer(replyToDestination);
            }
            jmsRequest.setJMSReplyTo(replyToDestination);
            messageProducer.send(jmsRequest);
            if (messageConsumer == null) {
                messageConsumer = this.createMessageConsumer(replyToDestination, jmsRequest.getJMSMessageID());
            }
            logger.info("Message was sent to JMS destination: '{}'", (Object)this.endpointConfiguration.getDestinationName(destination));
            logger.debug("Receiving reply message on destination: '{}'", (Object)replyToDestination);
            Message message2 = jmsReplyMessage = this.endpointConfiguration.getTimeout() >= 0L ? messageConsumer.receive(this.endpointConfiguration.getTimeout()) : messageConsumer.receive();
            if (jmsReplyMessage == null) {
                throw new ReplyMessageTimeoutException(this.endpointConfiguration.getTimeout(), Objects.toString(replyToDestination));
            }
            org.citrusframework.message.Message responseMessage = this.endpointConfiguration.getMessageConverter().convertInbound(jmsReplyMessage, this.endpointConfiguration, context);
            logger.info("Received reply message on JMS destination: '{}'", (Object)replyToDestination);
            context.onInboundMessage(responseMessage);
            this.correlationManager.store(correlationKey, (Object)responseMessage);
        }
        catch (JMSException e) {
            try {
                throw new CitrusRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageProducer(messageProducer);
                JmsUtils.closeMessageConsumer(messageConsumer);
                this.deleteTemporaryDestination(replyToDestination);
                throw throwable;
            }
        }
        JmsUtils.closeMessageProducer((MessageProducer)messageProducer);
        JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        this.deleteTemporaryDestination(replyToDestination);
    }

    public org.citrusframework.message.Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public org.citrusframework.message.Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.endpointConfiguration.getTimeout());
    }

    public org.citrusframework.message.Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public org.citrusframework.message.Message receive(String selector, TestContext context, long timeout) {
        org.citrusframework.message.Message message = (org.citrusframework.message.Message)this.correlationManager.find(selector, timeout);
        String replyToDestination = context.getVariables().containsKey("citrus_message_replyTo_" + selector) ? context.getVariable("citrus_message_replyTo_" + selector) : this.getName();
        if (message == null) {
            throw new ReplyMessageTimeoutException(timeout, replyToDestination);
        }
        return message;
    }

    protected void createConnection() throws JMSException {
        if (this.connection == null) {
            if (!this.endpointConfiguration.isPubSubDomain() && this.endpointConfiguration.getConnectionFactory() instanceof QueueConnectionFactory) {
                this.connection = ((QueueConnectionFactory)this.endpointConfiguration.getConnectionFactory()).createQueueConnection();
            } else if (this.endpointConfiguration.isPubSubDomain() && this.endpointConfiguration.getConnectionFactory() instanceof TopicConnectionFactory) {
                this.connection = ((TopicConnectionFactory)this.endpointConfiguration.getConnectionFactory()).createTopicConnection();
                this.connection.setClientID(this.getName());
            } else {
                logger.warn("Not able to create a connection with connection factory '" + this.endpointConfiguration.getConnectionFactory() + "' when using setting 'publish-subscribe-domain' (=" + this.endpointConfiguration.isPubSubDomain() + ")");
                this.connection = this.endpointConfiguration.getConnectionFactory().createConnection();
            }
            this.connection.start();
        }
    }

    protected void createSession(Connection connection) throws JMSException {
        if (this.session == null) {
            if (!this.endpointConfiguration.isPubSubDomain() && connection instanceof QueueConnection) {
                this.session = ((QueueConnection)connection).createQueueSession(false, 1);
            } else if (this.endpointConfiguration.isPubSubDomain() && this.endpointConfiguration.getConnectionFactory() instanceof TopicConnectionFactory) {
                this.session = ((TopicConnection)connection).createTopicSession(false, 1);
            } else {
                logger.warn("Not able to create a session with connection factory '" + this.endpointConfiguration.getConnectionFactory() + "' when using setting 'publish-subscribe-domain' (=" + this.endpointConfiguration.isPubSubDomain() + ")");
                this.session = connection.createSession(false, 1);
            }
        }
    }

    private MessageConsumer createMessageConsumer(Destination replyToDestination, String messageId) throws JMSException {
        Object messageConsumer = replyToDestination instanceof Queue ? this.session.createConsumer(replyToDestination, "JMSCorrelationID = '" + messageId.replaceAll("'", "''") + "'") : this.session.createDurableSubscriber((Topic)replyToDestination, this.getName(), "JMSCorrelationID = '" + messageId.replaceAll("'", "''") + "'", false);
        return messageConsumer;
    }

    private void deleteTemporaryDestination(Destination destination) {
        logger.debug("Delete temporary destination: '{}'", (Object)destination);
        try {
            if (destination instanceof TemporaryQueue) {
                ((TemporaryQueue)destination).delete();
            } else if (destination instanceof TemporaryTopic) {
                ((TemporaryTopic)destination).delete();
            }
        }
        catch (JMSException e) {
            logger.error("Error while deleting temporary destination '" + destination + "'", (Throwable)e);
        }
    }

    private Destination getReplyDestination(Session session, org.citrusframework.message.Message message) throws JMSException {
        if (message.getHeader("replyChannel") != null) {
            if (message.getHeader("replyChannel") instanceof Destination) {
                return (Destination)message.getHeader("replyChannel");
            }
            return this.resolveDestinationName(message.getHeader("replyChannel").toString(), session);
        }
        if (this.endpointConfiguration.getReplyDestination() != null) {
            return this.endpointConfiguration.getReplyDestination();
        }
        if (StringUtils.hasText((String)this.endpointConfiguration.getReplyDestinationName())) {
            return this.resolveDestinationName(this.endpointConfiguration.getReplyDestinationName(), session);
        }
        if (this.endpointConfiguration.isPubSubDomain() && session instanceof TopicSession) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }

    private Destination resolveDestination(String destinationName) throws JMSException {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending JMS message to destination: '" + destinationName + "'");
        }
        return this.resolveDestinationName(destinationName, this.session);
    }

    private Destination resolveDestinationName(String name, Session session) throws JMSException {
        if (this.endpointConfiguration.getDestinationResolver() != null) {
            return this.endpointConfiguration.getDestinationResolver().resolveDestinationName(session, name, this.endpointConfiguration.isPubSubDomain());
        }
        return new DynamicDestinationResolver().resolveDestinationName(session, name, this.endpointConfiguration.isPubSubDomain());
    }

    public void destroy() {
        JmsUtils.closeSession((Session)this.session);
        if (this.connection != null) {
            ConnectionFactoryUtils.releaseConnection((Connection)this.connection, (ConnectionFactory)this.endpointConfiguration.getConnectionFactory(), (boolean)true);
        }
    }

    public CorrelationManager<org.citrusframework.message.Message> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<org.citrusframework.message.Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

