/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jms.endpoint.resolver;

import java.util.Map;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.util.StringUtils;

public class DynamicDestinationNameResolver
implements EndpointUriResolver {
    public static final String DESTINATION_HEADER_NAME = "citrus_jms_destination_name";
    private String defaultDestinationName;

    public String resolveEndpointUri(Message message, String defaultName) {
        Map headers = message.getHeaders();
        String destinationName = headers.containsKey(DESTINATION_HEADER_NAME) ? headers.get(DESTINATION_HEADER_NAME).toString() : (StringUtils.hasText((String)defaultName) ? defaultName : this.defaultDestinationName);
        if (destinationName == null) {
            throw new CitrusRuntimeException("Unable to resolve dynamic destination name! Neither header entry 'citrus_jms_destination_name' nor default destination name is set");
        }
        return destinationName;
    }

    public String getDefaultDestinationName() {
        return this.defaultDestinationName;
    }

    public void setDefaultDestinationName(String defaultDestinationName) {
        this.defaultDestinationName = defaultDestinationName;
    }
}

