// Compiled by ClojureScript 0.0-3119 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string.StringBuffer');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3119";
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
 * Var bound to the name value of the compiler build :target option.
 * For example, if the compiler build :target is :nodejs, *target* will be bound
 * to "nodejs". *target* is a Google Closure define and can be set by compiler
 * :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = "default";
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 * Whatever function *print-fn* is bound to will be passed any
 * Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 * Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 * This is to work around the implicit newlines emitted by standard JavaScript
 * console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 * non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 * Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 * be printed in a form that can be read back by the reader.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 * print nested objects. If it is bound to logical false, there is no
 * limit. Otherwise, it must be bound to an integer indicating the maximum
 * level to print. Each argument to print is at level 0; if an argument is a
 * collection, its items are at level 1; and so on. If an object is a
 * collection and is at a level greater than or equal to the value bound to
 * *print-level*, the printer prints '#' to represent it. The root binding
 * is nil indicating no limit.
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__5235__delegate = function (args){
return console.log.apply(console,(function (){var G__5234 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__5234) : cljs.core.into_array.call(null,G__5234));
})());
};
var G__5235 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__5236__i = 0, G__5236__a = new Array(arguments.length -  0);
while (G__5236__i < G__5236__a.length) {G__5236__a[G__5236__i] = arguments[G__5236__i + 0]; ++G__5236__i;}
  args = new cljs.core.IndexedSeq(G__5236__a,0);
} 
return G__5235__delegate.call(this,args);};
G__5235.cljs$lang$maxFixedArity = 0;
G__5235.cljs$lang$applyTo = (function (arglist__5237){
var args = cljs.core.seq(arglist__5237);
return G__5235__delegate(args);
});
G__5235.cljs$core$IFn$_invoke$arity$variadic = G__5235__delegate;
return G__5235;
})()
;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(n){
return typeof n === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
var G__5239 = x;
return goog.isString(G__5239);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__5241 = x__$1;
return goog.typeOf(G__5241);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever
 * function *main-fn* is set to will be called with the command-line
 * argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__3728__auto__ = ty;
if(cljs.core.truth_(and__3728__auto__)){
return ty.cljs$lang$type;
} else {
return and__3728__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__5243 = obj;
return goog.typeOf(G__5243);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4124__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4124__auto__)){
var s = temp__4124__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__5245 = Symbol;
return goog.typeOf(G__5245);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 * argument for compatibility with Clojure.
 */
cljs.core.make_array = (function() {
var cljs$core$make_array = null;
var cljs$core$make_array__1 = (function (size){
return (new Array(size));
});
var cljs$core$make_array__2 = (function (type,size){
return cljs$core$make_array.cljs$core$IFn$_invoke$arity$1(size);
});
cljs$core$make_array = function(type,size){
switch(arguments.length){
case 1:
return cljs$core$make_array__1.call(this,type);
case 2:
return cljs$core$make_array__2.call(this,type,size);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$make_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$make_array__1;
cljs$core$make_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$make_array__2;
return cljs$core$make_array;
})()
;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4625__auto___5247 = len;
var i_5248 = (0);
while(true){
if((i_5248 < n__4625__auto___5247)){
(new_arr[i_5248] = (arr[i_5248]));

var G__5249 = (i_5248 + (1));
i_5248 = G__5249;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__5250 = (i + (1));
i = G__5250;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 * @param {...*} var_args
 */
cljs.core.aget = (function() {
var cljs$core$aget = null;
var cljs$core$aget__2 = (function (array,i){
return (array[i]);
});
var cljs$core$aget__3 = (function() { 
var G__5259__delegate = function (array,i,idxs){
var G__5256 = cljs$core$aget;
var G__5257 = cljs$core$aget.cljs$core$IFn$_invoke$arity$2(array,i);
var G__5258 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__5256,G__5257,G__5258) : cljs.core.apply.call(null,G__5256,G__5257,G__5258));
};
var G__5259 = function (array,i,var_args){
var idxs = null;
if (arguments.length > 2) {
var G__5260__i = 0, G__5260__a = new Array(arguments.length -  2);
while (G__5260__i < G__5260__a.length) {G__5260__a[G__5260__i] = arguments[G__5260__i + 2]; ++G__5260__i;}
  idxs = new cljs.core.IndexedSeq(G__5260__a,0);
} 
return G__5259__delegate.call(this,array,i,idxs);};
G__5259.cljs$lang$maxFixedArity = 2;
G__5259.cljs$lang$applyTo = (function (arglist__5261){
var array = cljs.core.first(arglist__5261);
arglist__5261 = cljs.core.next(arglist__5261);
var i = cljs.core.first(arglist__5261);
var idxs = cljs.core.rest(arglist__5261);
return G__5259__delegate(array,i,idxs);
});
G__5259.cljs$core$IFn$_invoke$arity$variadic = G__5259__delegate;
return G__5259;
})()
;
cljs$core$aget = function(array,i,var_args){
var idxs = var_args;
switch(arguments.length){
case 2:
return cljs$core$aget__2.call(this,array,i);
default:
var G__5262 = null;
if (arguments.length > 2) {
var G__5263__i = 0, G__5263__a = new Array(arguments.length -  2);
while (G__5263__i < G__5263__a.length) {G__5263__a[G__5263__i] = arguments[G__5263__i + 2]; ++G__5263__i;}
G__5262 = new cljs.core.IndexedSeq(G__5263__a,0);
}
return cljs$core$aget__3.cljs$core$IFn$_invoke$arity$variadic(array,i, G__5262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$aget.cljs$lang$maxFixedArity = 2;
cljs$core$aget.cljs$lang$applyTo = cljs$core$aget__3.cljs$lang$applyTo;
cljs$core$aget.cljs$core$IFn$_invoke$arity$2 = cljs$core$aget__2;
cljs$core$aget.cljs$core$IFn$_invoke$arity$variadic = cljs$core$aget__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$aget;
})()
;
/**
 * Sets the value at the index.
 * @param {...*} var_args
 */
cljs.core.aset = (function() {
var cljs$core$aset = null;
var cljs$core$aset__3 = (function (array,i,val){
return (array[i] = val);
});
var cljs$core$aset__4 = (function() { 
var G__5272__delegate = function (array,idx,idx2,idxv){
var G__5268 = cljs$core$aset;
var G__5269 = (array[idx]);
var G__5270 = idx2;
var G__5271 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__5268,G__5269,G__5270,G__5271) : cljs.core.apply.call(null,G__5268,G__5269,G__5270,G__5271));
};
var G__5272 = function (array,idx,idx2,var_args){
var idxv = null;
if (arguments.length > 3) {
var G__5273__i = 0, G__5273__a = new Array(arguments.length -  3);
while (G__5273__i < G__5273__a.length) {G__5273__a[G__5273__i] = arguments[G__5273__i + 3]; ++G__5273__i;}
  idxv = new cljs.core.IndexedSeq(G__5273__a,0);
} 
return G__5272__delegate.call(this,array,idx,idx2,idxv);};
G__5272.cljs$lang$maxFixedArity = 3;
G__5272.cljs$lang$applyTo = (function (arglist__5274){
var array = cljs.core.first(arglist__5274);
arglist__5274 = cljs.core.next(arglist__5274);
var idx = cljs.core.first(arglist__5274);
arglist__5274 = cljs.core.next(arglist__5274);
var idx2 = cljs.core.first(arglist__5274);
var idxv = cljs.core.rest(arglist__5274);
return G__5272__delegate(array,idx,idx2,idxv);
});
G__5272.cljs$core$IFn$_invoke$arity$variadic = G__5272__delegate;
return G__5272;
})()
;
cljs$core$aset = function(array,idx,idx2,var_args){
var idxv = var_args;
switch(arguments.length){
case 3:
return cljs$core$aset__3.call(this,array,idx,idx2);
default:
var G__5275 = null;
if (arguments.length > 3) {
var G__5276__i = 0, G__5276__a = new Array(arguments.length -  3);
while (G__5276__i < G__5276__a.length) {G__5276__a[G__5276__i] = arguments[G__5276__i + 3]; ++G__5276__i;}
G__5275 = new cljs.core.IndexedSeq(G__5276__a,0);
}
return cljs$core$aset__4.cljs$core$IFn$_invoke$arity$variadic(array,idx,idx2, G__5275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$aset.cljs$lang$maxFixedArity = 3;
cljs$core$aset.cljs$lang$applyTo = cljs$core$aset__4.cljs$lang$applyTo;
cljs$core$aset.cljs$core$IFn$_invoke$arity$3 = cljs$core$aset__3;
cljs$core$aset.cljs$core$IFn$_invoke$arity$variadic = cljs$core$aset__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$aset;
})()
;
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 * argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function() {
var cljs$core$into_array = null;
var cljs$core$into_array__1 = (function (aseq){
return cljs$core$into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});
var cljs$core$into_array__2 = (function (type,aseq){
var G__5282 = (function (a,x){
a.push(x);

return a;
});
var G__5283 = [];
var G__5284 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__5282,G__5283,G__5284) : cljs.core.reduce.call(null,G__5282,G__5283,G__5284));
});
cljs$core$into_array = function(type,aseq){
switch(arguments.length){
case 1:
return cljs$core$into_array__1.call(this,type);
case 2:
return cljs$core$into_array__2.call(this,type,aseq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$into_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$into_array__1;
cljs$core$into_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$into_array__2;
return cljs$core$into_array;
})()
;
/**
 * Invoke JavaScript object method via string. Needed when the
 * string is not a valid unquoted property name.
 * @param {...*} var_args
 */
cljs.core.js_invoke = (function() { 
var cljs$core$js_invoke__delegate = function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
var cljs$core$js_invoke = function (obj,s,var_args){
var args = null;
if (arguments.length > 2) {
var G__5285__i = 0, G__5285__a = new Array(arguments.length -  2);
while (G__5285__i < G__5285__a.length) {G__5285__a[G__5285__i] = arguments[G__5285__i + 2]; ++G__5285__i;}
  args = new cljs.core.IndexedSeq(G__5285__a,0);
} 
return cljs$core$js_invoke__delegate.call(this,obj,s,args);};
cljs$core$js_invoke.cljs$lang$maxFixedArity = 2;
cljs$core$js_invoke.cljs$lang$applyTo = (function (arglist__5286){
var obj = cljs.core.first(arglist__5286);
arglist__5286 = cljs.core.next(arglist__5286);
var s = cljs.core.first(arglist__5286);
var args = cljs.core.rest(arglist__5286);
return cljs$core$js_invoke__delegate(obj,s,args);
});
cljs$core$js_invoke.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js_invoke__delegate;
return cljs$core$js_invoke;
})()
;

/**
 * Marker protocol
 */
cljs.core.Fn = (function (){var obj5288 = {};
return obj5288;
})();


/**
 * Protocol for adding the ability to invoke an object as a function.
 * For example, a vector can also be used to look up a value:
 * ([1 2 3 4] 1) => 2
 */
cljs.core.IFn = (function (){var obj5290 = {};
return obj5290;
})();

cljs.core._invoke = (function() {
var cljs$core$_invoke = null;
var cljs$core$_invoke__1 = (function (this$){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5336 = x__4376__auto__;
return goog.typeOf(G__5336);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});
var cljs$core$_invoke__2 = (function (this$,a){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5338 = x__4376__auto__;
return goog.typeOf(G__5338);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});
var cljs$core$_invoke__3 = (function (this$,a,b){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5340 = x__4376__auto__;
return goog.typeOf(G__5340);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});
var cljs$core$_invoke__4 = (function (this$,a,b,c){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5342 = x__4376__auto__;
return goog.typeOf(G__5342);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});
var cljs$core$_invoke__5 = (function (this$,a,b,c,d){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5344 = x__4376__auto__;
return goog.typeOf(G__5344);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});
var cljs$core$_invoke__6 = (function (this$,a,b,c,d,e){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5346 = x__4376__auto__;
return goog.typeOf(G__5346);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});
var cljs$core$_invoke__7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5348 = x__4376__auto__;
return goog.typeOf(G__5348);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});
var cljs$core$_invoke__8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5350 = x__4376__auto__;
return goog.typeOf(G__5350);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});
var cljs$core$_invoke__9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5352 = x__4376__auto__;
return goog.typeOf(G__5352);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});
var cljs$core$_invoke__10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5354 = x__4376__auto__;
return goog.typeOf(G__5354);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});
var cljs$core$_invoke__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5356 = x__4376__auto__;
return goog.typeOf(G__5356);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});
var cljs$core$_invoke__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5358 = x__4376__auto__;
return goog.typeOf(G__5358);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});
var cljs$core$_invoke__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5360 = x__4376__auto__;
return goog.typeOf(G__5360);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});
var cljs$core$_invoke__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5362 = x__4376__auto__;
return goog.typeOf(G__5362);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});
var cljs$core$_invoke__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5364 = x__4376__auto__;
return goog.typeOf(G__5364);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});
var cljs$core$_invoke__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5366 = x__4376__auto__;
return goog.typeOf(G__5366);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});
var cljs$core$_invoke__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5368 = x__4376__auto__;
return goog.typeOf(G__5368);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});
var cljs$core$_invoke__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5370 = x__4376__auto__;
return goog.typeOf(G__5370);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});
var cljs$core$_invoke__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5372 = x__4376__auto__;
return goog.typeOf(G__5372);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});
var cljs$core$_invoke__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5374 = x__4376__auto__;
return goog.typeOf(G__5374);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});
var cljs$core$_invoke__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5376 = x__4376__auto__;
return goog.typeOf(G__5376);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});
var cljs$core$_invoke__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._invoke[(function (){var G__5378 = x__4376__auto__;
return goog.typeOf(G__5378);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._invoke["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});
cljs$core$_invoke = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$_invoke__1.call(this,this$);
case 2:
return cljs$core$_invoke__2.call(this,this$,a);
case 3:
return cljs$core$_invoke__3.call(this,this$,a,b);
case 4:
return cljs$core$_invoke__4.call(this,this$,a,b,c);
case 5:
return cljs$core$_invoke__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$_invoke__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$_invoke__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$_invoke__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$_invoke__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$_invoke__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$_invoke__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$_invoke__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$_invoke__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$_invoke__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$_invoke__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$_invoke__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$_invoke__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$_invoke__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$_invoke__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$_invoke__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$_invoke__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$_invoke__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$1 = cljs$core$_invoke__1;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$2 = cljs$core$_invoke__2;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$3 = cljs$core$_invoke__3;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$4 = cljs$core$_invoke__4;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$5 = cljs$core$_invoke__5;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$6 = cljs$core$_invoke__6;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$7 = cljs$core$_invoke__7;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$8 = cljs$core$_invoke__8;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$9 = cljs$core$_invoke__9;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$10 = cljs$core$_invoke__10;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$11 = cljs$core$_invoke__11;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$12 = cljs$core$_invoke__12;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$13 = cljs$core$_invoke__13;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$14 = cljs$core$_invoke__14;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$15 = cljs$core$_invoke__15;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$16 = cljs$core$_invoke__16;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$17 = cljs$core$_invoke__17;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$18 = cljs$core$_invoke__18;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$19 = cljs$core$_invoke__19;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$20 = cljs$core$_invoke__20;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$21 = cljs$core$_invoke__21;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$22 = cljs$core$_invoke__22;
return cljs$core$_invoke;
})()
;


/**
 * Protocol for cloning a value.
 */
cljs.core.ICloneable = (function (){var obj5380 = {};
return obj5380;
})();

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((function (){var and__3728__auto__ = value;
if(and__3728__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__3728__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4376__auto__ = (((value == null))?null:value);
return (function (){var or__3740__auto__ = (cljs.core._clone[(function (){var G__5384 = x__4376__auto__;
return goog.typeOf(G__5384);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._clone["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 */
cljs.core.ICounted = (function (){var obj5386 = {};
return obj5386;
})();

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._count[(function (){var G__5390 = x__4376__auto__;
return goog.typeOf(G__5390);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._count["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for creating an empty collection.
 */
cljs.core.IEmptyableCollection = (function (){var obj5392 = {};
return obj5392;
})();

/**
 * Returns an empty collection of the same category as coll. Used
 * by cljs.core/count.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._empty[(function (){var G__5396 = x__4376__auto__;
return goog.typeOf(G__5396);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._empty["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding to a collection.
 */
cljs.core.ICollection = (function (){var obj5398 = {};
return obj5398;
})();

/**
 * Returns a new collection of coll with o added to it. The new item
 * should be added to the most efficient place, e.g.
 * (conj [1 2 3 4] 5) => [1 2 3 4 5]
 * (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._conj[(function (){var G__5402 = x__4376__auto__;
return goog.typeOf(G__5402);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._conj["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


/**
 * Protocol for collections to provide idexed-based access to their items.
 */
cljs.core.IIndexed = (function (){var obj5404 = {};
return obj5404;
})();

/**
 * Returns the value at the index n in the collection coll.
 * Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function() {
var cljs$core$_nth = null;
var cljs$core$_nth__2 = (function (coll,n){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._nth[(function (){var G__5410 = x__4376__auto__;
return goog.typeOf(G__5410);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._nth["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});
var cljs$core$_nth__3 = (function (coll,n,not_found){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._nth[(function (){var G__5412 = x__4376__auto__;
return goog.typeOf(G__5412);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._nth["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});
cljs$core$_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$_nth__2.call(this,coll,n);
case 3:
return cljs$core$_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$_nth__2;
cljs$core$_nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$_nth__3;
return cljs$core$_nth;
})()
;


/**
 * Marker protocol indicating an array sequence.
 */
cljs.core.ASeq = (function (){var obj5414 = {};
return obj5414;
})();


/**
 * Protocol for collections to provide access to their items as sequences.
 */
cljs.core.ISeq = (function (){var obj5416 = {};
return obj5416;
})();

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._first[(function (){var G__5420 = x__4376__auto__;
return goog.typeOf(G__5420);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._first["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new collection of coll without the first item. It should
 * always return a seq, e.g.
 * (rest []) => ()
 * (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._rest[(function (){var G__5424 = x__4376__auto__;
return goog.typeOf(G__5424);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._rest["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 */
cljs.core.INext = (function (){var obj5426 = {};
return obj5426;
})();

/**
 * Returns a new collection of coll without the first item. In contrast to
 * rest, it should return nil if there are no more items, e.g.
 * (next []) => nil
 * (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._next[(function (){var G__5430 = x__4376__auto__;
return goog.typeOf(G__5430);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._next["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 */
cljs.core.ILookup = (function (){var obj5432 = {};
return obj5432;
})();

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 * a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function() {
var cljs$core$_lookup = null;
var cljs$core$_lookup__2 = (function (o,k){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._lookup[(function (){var G__5438 = x__4376__auto__;
return goog.typeOf(G__5438);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._lookup["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});
var cljs$core$_lookup__3 = (function (o,k,not_found){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._lookup[(function (){var G__5440 = x__4376__auto__;
return goog.typeOf(G__5440);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._lookup["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});
cljs$core$_lookup = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$_lookup__2.call(this,o,k);
case 3:
return cljs$core$_lookup__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_lookup.cljs$core$IFn$_invoke$arity$2 = cljs$core$_lookup__2;
cljs$core$_lookup.cljs$core$IFn$_invoke$arity$3 = cljs$core$_lookup__3;
return cljs$core$_lookup;
})()
;


/**
 * Protocol for adding associativity to collections.
 */
cljs.core.IAssociative = (function (){var obj5442 = {};
return obj5442;
})();

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__5446 = x__4376__auto__;
return goog.typeOf(G__5446);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 * value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._assoc[(function (){var G__5450 = x__4376__auto__;
return goog.typeOf(G__5450);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._assoc["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 */
cljs.core.IMap = (function (){var obj5452 = {};
return obj5452;
})();

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._dissoc[(function (){var G__5456 = x__4376__auto__;
return goog.typeOf(G__5456);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._dissoc["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


/**
 * Protocol for examining a map entry.
 */
cljs.core.IMapEntry = (function (){var obj5458 = {};
return obj5458;
})();

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._key[(function (){var G__5462 = x__4376__auto__;
return goog.typeOf(G__5462);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._key["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._val[(function (){var G__5466 = x__4376__auto__;
return goog.typeOf(G__5466);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._val["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 */
cljs.core.ISet = (function (){var obj5468 = {};
return obj5468;
})();

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._disjoin[(function (){var G__5472 = x__4376__auto__;
return goog.typeOf(G__5472);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._disjoin["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 * of the stack should be accessed in the most efficient way for the different
 * data structures.
 */
cljs.core.IStack = (function (){var obj5474 = {};
return obj5474;
})();

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._peek[(function (){var G__5478 = x__4376__auto__;
return goog.typeOf(G__5478);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._peek["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 * by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._pop[(function (){var G__5482 = x__4376__auto__;
return goog.typeOf(G__5482);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._pop["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 */
cljs.core.IVector = (function (){var obj5484 = {};
return obj5484;
})();

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._assoc_n[(function (){var G__5488 = x__4376__auto__;
return goog.typeOf(G__5488);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 */
cljs.core.IDeref = (function (){var obj5490 = {};
return obj5490;
})();

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._deref[(function (){var G__5494 = x__4376__auto__;
return goog.typeOf(G__5494);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._deref["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj5496 = {};
return obj5496;
})();

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._deref_with_timeout[(function (){var G__5500 = x__4376__auto__;
return goog.typeOf(G__5500);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 */
cljs.core.IMeta = (function (){var obj5502 = {};
return obj5502;
})();

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._meta[(function (){var G__5506 = x__4376__auto__;
return goog.typeOf(G__5506);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._meta["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding metadata to an object.
 */
cljs.core.IWithMeta = (function (){var obj5508 = {};
return obj5508;
})();

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._with_meta[(function (){var G__5512 = x__4376__auto__;
return goog.typeOf(G__5512);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._with_meta["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 * Called by cljs.core/reduce.
 */
cljs.core.IReduce = (function (){var obj5514 = {};
return obj5514;
})();

/**
 * f should be a function of 2 arguments. If start is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function() {
var cljs$core$_reduce = null;
var cljs$core$_reduce__2 = (function (coll,f){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._reduce[(function (){var G__5520 = x__4376__auto__;
return goog.typeOf(G__5520);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._reduce["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});
var cljs$core$_reduce__3 = (function (coll,f,start){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._reduce[(function (){var G__5522 = x__4376__auto__;
return goog.typeOf(G__5522);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._reduce["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});
cljs$core$_reduce = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$_reduce__2.call(this,coll,f);
case 3:
return cljs$core$_reduce__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$_reduce__2;
cljs$core$_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$_reduce__3;
return cljs$core$_reduce;
})()
;


/**
 * Protocol for associative types that can reduce themselves
 * via a function of key and val. Called by cljs.core/reduce-kv.
 */
cljs.core.IKVReduce = (function (){var obj5524 = {};
return obj5524;
})();

/**
 * Reduces an associative collection and returns the result. f should be
 * a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._kv_reduce[(function (){var G__5528 = x__4376__auto__;
return goog.typeOf(G__5528);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 */
cljs.core.IEquiv = (function (){var obj5530 = {};
return obj5530;
})();

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._equiv[(function (){var G__5534 = x__4376__auto__;
return goog.typeOf(G__5534);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._equiv["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 */
cljs.core.IHash = (function (){var obj5536 = {};
return obj5536;
})();

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._hash[(function (){var G__5540 = x__4376__auto__;
return goog.typeOf(G__5540);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._hash["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 */
cljs.core.ISeqable = (function (){var obj5542 = {};
return obj5542;
})();

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._seq[(function (){var G__5546 = x__4376__auto__;
return goog.typeOf(G__5546);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._seq["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 */
cljs.core.ISequential = (function (){var obj5548 = {};
return obj5548;
})();


/**
 * Marker interface indicating a persistent list
 */
cljs.core.IList = (function (){var obj5550 = {};
return obj5550;
})();


/**
 * Marker interface indicating a record object
 */
cljs.core.IRecord = (function (){var obj5552 = {};
return obj5552;
})();


/**
 * Protocol for reversing a seq.
 */
cljs.core.IReversible = (function (){var obj5554 = {};
return obj5554;
})();

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._rseq[(function (){var G__5558 = x__4376__auto__;
return goog.typeOf(G__5558);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._rseq["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for a collection which can represent their items
 * in a sorted manner.
 */
cljs.core.ISorted = (function (){var obj5560 = {};
return obj5560;
})();

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._sorted_seq[(function (){var G__5564 = x__4376__auto__;
return goog.typeOf(G__5564);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 * If ascending is true, the result should contain all items which are > or >=
 * than k. If ascending is false, the result should contain all items which
 * are < or <= than k, e.g.
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._sorted_seq_from[(function (){var G__5568 = x__4376__auto__;
return goog.typeOf(G__5568);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._entry_key[(function (){var G__5572 = x__4376__auto__;
return goog.typeOf(G__5572);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._entry_key["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._comparator[(function (){var G__5576 = x__4376__auto__;
return goog.typeOf(G__5576);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._comparator["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 */
cljs.core.IWriter = (function (){var obj5578 = {};
return obj5578;
})();

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((function (){var and__3728__auto__ = writer;
if(and__3728__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__3728__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4376__auto__ = (((writer == null))?null:writer);
return (function (){var or__3740__auto__ = (cljs.core._write[(function (){var G__5582 = x__4376__auto__;
return goog.typeOf(G__5582);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._write["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((function (){var and__3728__auto__ = writer;
if(and__3728__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__3728__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4376__auto__ = (((writer == null))?null:writer);
return (function (){var or__3740__auto__ = (cljs.core._flush[(function (){var G__5586 = x__4376__auto__;
return goog.typeOf(G__5586);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._flush["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 */
cljs.core.IPrintWithWriter = (function (){var obj5588 = {};
return obj5588;
})();

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._pr_writer[(function (){var G__5592 = x__4376__auto__;
return goog.typeOf(G__5592);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 * implemented by Delay.
 */
cljs.core.IPending = (function (){var obj5594 = {};
return obj5594;
})();

/**
 * Returns true if a value for d has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(d){
if((function (){var and__3728__auto__ = d;
if(and__3728__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__3728__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4376__auto__ = (((d == null))?null:d);
return (function (){var or__3740__auto__ = (cljs.core._realized_QMARK_[(function (){var G__5598 = x__4376__auto__;
return goog.typeOf(G__5598);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 */
cljs.core.IWatchable = (function (){var obj5600 = {};
return obj5600;
})();

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._notify_watches[(function (){var G__5604 = x__4376__auto__;
return goog.typeOf(G__5604);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 * and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._add_watch[(function (){var G__5608 = x__4376__auto__;
return goog.typeOf(G__5608);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._add_watch["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((function (){var and__3728__auto__ = this$;
if(and__3728__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__3728__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4376__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3740__auto__ = (cljs.core._remove_watch[(function (){var G__5612 = x__4376__auto__;
return goog.typeOf(G__5612);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 */
cljs.core.IEditableCollection = (function (){var obj5614 = {};
return obj5614;
})();

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._as_transient[(function (){var G__5618 = x__4376__auto__;
return goog.typeOf(G__5618);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._as_transient["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 */
cljs.core.ITransientCollection = (function (){var obj5620 = {};
return obj5620;
})();

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((function (){var and__3728__auto__ = tcoll;
if(and__3728__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__3728__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4376__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3740__auto__ = (cljs.core._conj_BANG_[(function (){var G__5624 = x__4376__auto__;
return goog.typeOf(G__5624);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((function (){var and__3728__auto__ = tcoll;
if(and__3728__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__3728__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4376__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3740__auto__ = (cljs.core._persistent_BANG_[(function (){var G__5628 = x__4376__auto__;
return goog.typeOf(G__5628);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 */
cljs.core.ITransientAssociative = (function (){var obj5630 = {};
return obj5630;
})();

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 * val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((function (){var and__3728__auto__ = tcoll;
if(and__3728__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__3728__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4376__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3740__auto__ = (cljs.core._assoc_BANG_[(function (){var G__5634 = x__4376__auto__;
return goog.typeOf(G__5634);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 */
cljs.core.ITransientMap = (function (){var obj5636 = {};
return obj5636;
})();

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((function (){var and__3728__auto__ = tcoll;
if(and__3728__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__3728__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4376__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3740__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__5640 = x__4376__auto__;
return goog.typeOf(G__5640);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 */
cljs.core.ITransientVector = (function (){var obj5642 = {};
return obj5642;
})();

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3728__auto__ = tcoll;
if(and__3728__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__3728__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4376__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3740__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__5646 = x__4376__auto__;
return goog.typeOf(G__5646);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((function (){var and__3728__auto__ = tcoll;
if(and__3728__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__3728__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4376__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3740__auto__ = (cljs.core._pop_BANG_[(function (){var G__5650 = x__4376__auto__;
return goog.typeOf(G__5650);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 */
cljs.core.ITransientSet = (function (){var obj5652 = {};
return obj5652;
})();

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((function (){var and__3728__auto__ = tcoll;
if(and__3728__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__3728__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4376__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3740__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__5656 = x__4376__auto__;
return goog.typeOf(G__5656);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 */
cljs.core.IComparable = (function (){var obj5658 = {};
return obj5658;
})();

/**
 * Returns a negative number, zero, or a positive number when x is logically
 * 'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((function (){var and__3728__auto__ = x;
if(and__3728__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__3728__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4376__auto__ = (((x == null))?null:x);
return (function (){var or__3740__auto__ = (cljs.core._compare[(function (){var G__5662 = x__4376__auto__;
return goog.typeOf(G__5662);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._compare["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 */
cljs.core.IChunk = (function (){var obj5664 = {};
return obj5664;
})();

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._drop_first[(function (){var G__5668 = x__4376__auto__;
return goog.typeOf(G__5668);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._drop_first["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 */
cljs.core.IChunkedSeq = (function (){var obj5670 = {};
return obj5670;
})();

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._chunked_first[(function (){var G__5674 = x__4376__auto__;
return goog.typeOf(G__5674);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._chunked_rest[(function (){var G__5678 = x__4376__auto__;
return goog.typeOf(G__5678);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 */
cljs.core.IChunkedNext = (function (){var obj5680 = {};
return obj5680;
})();

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._chunked_next[(function (){var G__5684 = x__4376__auto__;
return goog.typeOf(G__5684);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding a name.
 */
cljs.core.INamed = (function (){var obj5686 = {};
return obj5686;
})();

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((function (){var and__3728__auto__ = x;
if(and__3728__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__3728__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4376__auto__ = (((x == null))?null:x);
return (function (){var or__3740__auto__ = (cljs.core._name[(function (){var G__5690 = x__4376__auto__;
return goog.typeOf(G__5690);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._name["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((function (){var and__3728__auto__ = x;
if(and__3728__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__3728__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4376__auto__ = (((x == null))?null:x);
return (function (){var or__3740__auto__ = (cljs.core._namespace[(function (){var G__5694 = x__4376__auto__;
return goog.typeOf(G__5694);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._namespace["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


/**
 * Marker protocol indicating an atom.
 */
cljs.core.IAtom = (function (){var obj5696 = {};
return obj5696;
})();


/**
 * Protocol for adding resetting functionality.
 */
cljs.core.IReset = (function (){var obj5698 = {};
return obj5698;
})();

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._reset_BANG_[(function (){var G__5702 = x__4376__auto__;
return goog.typeOf(G__5702);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 */
cljs.core.ISwap = (function (){var obj5704 = {};
return obj5704;
})();

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function() {
var cljs$core$_swap_BANG_ = null;
var cljs$core$_swap_BANG___2 = (function (o,f){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._swap_BANG_[(function (){var G__5714 = x__4376__auto__;
return goog.typeOf(G__5714);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});
var cljs$core$_swap_BANG___3 = (function (o,f,a){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._swap_BANG_[(function (){var G__5716 = x__4376__auto__;
return goog.typeOf(G__5716);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});
var cljs$core$_swap_BANG___4 = (function (o,f,a,b){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._swap_BANG_[(function (){var G__5718 = x__4376__auto__;
return goog.typeOf(G__5718);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});
var cljs$core$_swap_BANG___5 = (function (o,f,a,b,xs){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._swap_BANG_[(function (){var G__5720 = x__4376__auto__;
return goog.typeOf(G__5720);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});
cljs$core$_swap_BANG_ = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$_swap_BANG___2.call(this,o,f);
case 3:
return cljs$core$_swap_BANG___3.call(this,o,f,a);
case 4:
return cljs$core$_swap_BANG___4.call(this,o,f,a,b);
case 5:
return cljs$core$_swap_BANG___5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_swap_BANG___2;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$_swap_BANG___3;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = cljs$core$_swap_BANG___4;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = cljs$core$_swap_BANG___5;
return cljs$core$_swap_BANG_;
})()
;


/**
 * Protocol for adding volatile functionality.
 */
cljs.core.IVolatile = (function (){var obj5722 = {};
return obj5722;
})();

/**
 * Sets the value of volatile o to new-value without regard for the
 * current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((function (){var and__3728__auto__ = o;
if(and__3728__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__3728__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4376__auto__ = (((o == null))?null:o);
return (function (){var or__3740__auto__ = (cljs.core._vreset_BANG_[(function (){var G__5726 = x__4376__auto__;
return goog.typeOf(G__5726);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 */
cljs.core.IIterable = (function (){var obj5728 = {};
return obj5728;
})();

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((function (){var and__3728__auto__ = coll;
if(and__3728__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__3728__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4376__auto__ = (((coll == null))?null:coll);
return (function (){var or__3740__auto__ = (cljs.core._iterator[(function (){var G__5732 = x__4376__auto__;
return goog.typeOf(G__5732);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._iterator["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__5735 = (4294967295);
var G__5736 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__5735,G__5736) : Math.imul.call(null,G__5735,G__5736));
})() === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
var G__5739 = a;
var G__5740 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__5739,G__5740) : Math.imul.call(null,G__5739,G__5740));
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__5741 = (i + (2));
var G__5742 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__5741;
h1 = G__5742;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj5744 = {};
return obj5744;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__5745 = (i + (1));
var G__5746 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__5745;
hash = G__5746;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj5750 = {};
return obj5750;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((function (){var G__5753 = o;
if(G__5753){
var bit__4407__auto__ = (G__5753.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4407__auto__) || (G__5753.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__5754 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__5754) : Math.floor.call(null,G__5754));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 * c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(t,o){
return (o instanceof t);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3728__auto__ = cljs.core.not(a.ns);
if(and__3728__auto__){
return b.ns;
} else {
return and__3728__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__5761 = a.ns;
var G__5762 = b.ns;
return goog.array.defaultCompare(G__5761,G__5762);
})();
if(((0) === nsc)){
var G__5763 = a.name;
var G__5764 = b.name;
return goog.array.defaultCompare(G__5763,G__5764);
} else {
return nsc;
}
}
} else {
var G__5765 = a.name;
var G__5766 = b.name;
return goog.array.defaultCompare(G__5765,G__5766);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4156__auto__ = self__._hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.call = (function() {
var G__5768 = null;
var G__5768__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__5768__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__5768 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__5768__2.call(this,self__,coll);
case 3:
return G__5768__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5768.cljs$core$IFn$_invoke$arity$2 = G__5768__2;
G__5768.cljs$core$IFn$_invoke$arity$3 = G__5768__3;
return G__5768;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args5767){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5767)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function() {
var cljs$core$symbol = null;
var cljs$core$symbol__1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return cljs$core$symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});
var cljs$core$symbol__2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});
cljs$core$symbol = function(ns,name){
switch(arguments.length){
case 1:
return cljs$core$symbol__1.call(this,ns);
case 2:
return cljs$core$symbol__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$symbol.cljs$core$IFn$_invoke$arity$1 = cljs$core$symbol__1;
cljs$core$symbol.cljs$core$IFn$_invoke$arity$2 = cljs$core$symbol__2;
return cljs$core$symbol;
})()
;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 163841;
})
cljs.core.Var.prototype.call = (function() {
var G__5816 = null;
var G__5816__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__5816__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__5816__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__5816__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__5816__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__5816__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__5816__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__5816__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__5816__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__5816__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__5816__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__5816__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__5816__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__5816__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__5816__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__5816__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__5816__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__5816__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__5816__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__5816__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__5816__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__5816__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5772 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__5773 = a;
var G__5774 = b;
var G__5775 = c;
var G__5776 = d;
var G__5777 = e;
var G__5778 = f;
var G__5779 = g;
var G__5780 = h;
var G__5781 = i;
var G__5782 = j;
var G__5783 = k;
var G__5784 = l;
var G__5785 = m;
var G__5786 = n;
var G__5787 = o;
var G__5788 = p;
var G__5789 = q;
var G__5790 = r;
var G__5791 = s;
var G__5792 = t;
var G__5793 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__5772,G__5773,G__5774,G__5775,G__5776,G__5777,G__5778,G__5779,G__5780,G__5781,G__5782,G__5783,G__5784,G__5785,G__5786,G__5787,G__5788,G__5789,G__5790,G__5791,G__5792,G__5793) : cljs.core.apply.call(null,G__5772,G__5773,G__5774,G__5775,G__5776,G__5777,G__5778,G__5779,G__5780,G__5781,G__5782,G__5783,G__5784,G__5785,G__5786,G__5787,G__5788,G__5789,G__5790,G__5791,G__5792,G__5793));
});
G__5816 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__5816__1.call(this,self__);
case 2:
return G__5816__2.call(this,self__,a);
case 3:
return G__5816__3.call(this,self__,a,b);
case 4:
return G__5816__4.call(this,self__,a,b,c);
case 5:
return G__5816__5.call(this,self__,a,b,c,d);
case 6:
return G__5816__6.call(this,self__,a,b,c,d,e);
case 7:
return G__5816__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__5816__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__5816__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__5816__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__5816__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__5816__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__5816__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__5816__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__5816__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__5816__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__5816__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__5816__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__5816__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__5816__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__5816__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__5816__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5816.cljs$core$IFn$_invoke$arity$1 = G__5816__1;
G__5816.cljs$core$IFn$_invoke$arity$2 = G__5816__2;
G__5816.cljs$core$IFn$_invoke$arity$3 = G__5816__3;
G__5816.cljs$core$IFn$_invoke$arity$4 = G__5816__4;
G__5816.cljs$core$IFn$_invoke$arity$5 = G__5816__5;
G__5816.cljs$core$IFn$_invoke$arity$6 = G__5816__6;
G__5816.cljs$core$IFn$_invoke$arity$7 = G__5816__7;
G__5816.cljs$core$IFn$_invoke$arity$8 = G__5816__8;
G__5816.cljs$core$IFn$_invoke$arity$9 = G__5816__9;
G__5816.cljs$core$IFn$_invoke$arity$10 = G__5816__10;
G__5816.cljs$core$IFn$_invoke$arity$11 = G__5816__11;
G__5816.cljs$core$IFn$_invoke$arity$12 = G__5816__12;
G__5816.cljs$core$IFn$_invoke$arity$13 = G__5816__13;
G__5816.cljs$core$IFn$_invoke$arity$14 = G__5816__14;
G__5816.cljs$core$IFn$_invoke$arity$15 = G__5816__15;
G__5816.cljs$core$IFn$_invoke$arity$16 = G__5816__16;
G__5816.cljs$core$IFn$_invoke$arity$17 = G__5816__17;
G__5816.cljs$core$IFn$_invoke$arity$18 = G__5816__18;
G__5816.cljs$core$IFn$_invoke$arity$19 = G__5816__19;
G__5816.cljs$core$IFn$_invoke$arity$20 = G__5816__20;
G__5816.cljs$core$IFn$_invoke$arity$21 = G__5816__21;
G__5816.cljs$core$IFn$_invoke$arity$22 = G__5816__22;
return G__5816;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args5771){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5771)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__5794 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__5795 = a;
var G__5796 = b;
var G__5797 = c;
var G__5798 = d;
var G__5799 = e;
var G__5800 = f;
var G__5801 = g;
var G__5802 = h;
var G__5803 = i;
var G__5804 = j;
var G__5805 = k;
var G__5806 = l;
var G__5807 = m;
var G__5808 = n;
var G__5809 = o;
var G__5810 = p;
var G__5811 = q;
var G__5812 = r;
var G__5813 = s;
var G__5814 = t;
var G__5815 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__5794,G__5795,G__5796,G__5797,G__5798,G__5799,G__5800,G__5801,G__5802,G__5803,G__5804,G__5805,G__5806,G__5807,G__5808,G__5809,G__5810,G__5811,G__5812,G__5813,G__5814,G__5815) : cljs.core.apply.call(null,G__5794,G__5795,G__5796,G__5797,G__5798,G__5799,G__5800,G__5801,G__5802,G__5803,G__5804,G__5805,G__5806,G__5807,G__5808,G__5809,G__5810,G__5811,G__5812,G__5813,G__5814,G__5815));
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
var G__5818 = x;
if(G__5818){
var bit__4414__auto__ = null;
if(cljs.core.truth_((function (){var or__3740__auto__ = bit__4414__auto__;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return G__5818.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__5818.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__5818);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__5818);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
var G__5820 = value;
if(G__5820){
var bit__4414__auto__ = (G__5820.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4414__auto__) || (G__5820.cljs$core$ICloneable$)){
return true;
} else {
if((!G__5820.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__5820);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__5820);
}
});
/**
 * Returns a seq on the collection. If the collection is
 * empty, returns nil.  (seq nil) returns nil. seq also works on
 * Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5822 = coll;
if(G__5822){
var bit__4407__auto__ = (G__5822.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4407__auto__) || (G__5822.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 * argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5824 = coll;
if(G__5824){
var bit__4407__auto__ = (G__5824.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4407__auto__) || (G__5824.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 * argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if((function (){var G__5826 = coll;
if(G__5826){
var bit__4407__auto__ = (G__5826.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4407__auto__) || (G__5826.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 * argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5828 = coll;
if(G__5828){
var bit__4407__auto__ = (G__5828.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4407__auto__) || (G__5828.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 * numbers and collections in a type-independent manner.  Clojure's immutable data
 * structures define -equiv (and thus =) as a value, not an identity,
 * comparison.
 * @param {...*} var_args
 */
cljs.core._EQ_ = (function() {
var cljs$core$_EQ_ = null;
var cljs$core$_EQ___1 = (function (x){
return true;
});
var cljs$core$_EQ___2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});
var cljs$core$_EQ___3 = (function() { 
var G__5833__delegate = function (x,y,more){
while(true){
if(cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__5834 = y;
var G__5835 = cljs.core.first(more);
var G__5836 = cljs.core.next(more);
x = G__5834;
y = G__5835;
more = G__5836;
continue;
} else {
return cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__5833 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__5837__i = 0, G__5837__a = new Array(arguments.length -  2);
while (G__5837__i < G__5837__a.length) {G__5837__a[G__5837__i] = arguments[G__5837__i + 2]; ++G__5837__i;}
  more = new cljs.core.IndexedSeq(G__5837__a,0);
} 
return G__5833__delegate.call(this,x,y,more);};
G__5833.cljs$lang$maxFixedArity = 2;
G__5833.cljs$lang$applyTo = (function (arglist__5838){
var x = cljs.core.first(arglist__5838);
arglist__5838 = cljs.core.next(arglist__5838);
var y = cljs.core.first(arglist__5838);
var more = cljs.core.rest(arglist__5838);
return G__5833__delegate(x,y,more);
});
G__5833.cljs$core$IFn$_invoke$arity$variadic = G__5833__delegate;
return G__5833;
})()
;
cljs$core$_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_EQ___1.call(this,x);
case 2:
return cljs$core$_EQ___2.call(this,x,y);
default:
var G__5839 = null;
if (arguments.length > 2) {
var G__5840__i = 0, G__5840__a = new Array(arguments.length -  2);
while (G__5840__i < G__5840__a.length) {G__5840__a[G__5840__i] = arguments[G__5840__i + 2]; ++G__5840__i;}
G__5839 = new cljs.core.IndexedSeq(G__5840__a,0);
}
return cljs$core$_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__5839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_EQ_.cljs$lang$applyTo = cljs$core$_EQ___3.cljs$lang$applyTo;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_EQ___1;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_EQ___2;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_EQ_;
})()
;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": x};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__5841 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__5841) : cljs.core.es6_iterator_seq.call(null,G__5841));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__5842 = (n + (1));
var G__5843 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__5844 = cljs.core.next(coll__$1);
n = G__5842;
hash_code = G__5843;
coll__$1 = G__5844;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 * (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__5845 = (n + (1));
var G__5846 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__5847 = cljs.core.next(coll__$1);
n = G__5845;
hash_code = G__5846;
coll__$1 = G__5847;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
var G__5848 = this$__$1.valueOf();
var G__5849 = other.valueOf();
return goog.array.defaultCompare(G__5848,G__5849);
});

Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));

(cljs.core.Fn["function"] = true);
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__5850 = o;
return goog.getUid(G__5850);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__5852 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__5852) : cljs.core.deref.call(null,G__5852));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function() {
var cljs$core$ci_reduce = null;
var cljs$core$ci_reduce__2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__5859 = val;
var G__5860 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5859,G__5860) : f.call(null,G__5859,G__5860));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5865 = nval;
var G__5866 = (n + (1));
val = G__5865;
n = G__5866;
continue;
}
} else {
return val;
}
break;
}
}
});
var cljs$core$ci_reduce__3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__5861 = val__$1;
var G__5862 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5861,G__5862) : f.call(null,G__5861,G__5862));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5867 = nval;
var G__5868 = (n + (1));
val__$1 = G__5867;
n = G__5868;
continue;
}
} else {
return val__$1;
}
break;
}
});
var cljs$core$ci_reduce__4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__5863 = val__$1;
var G__5864 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5863,G__5864) : f.call(null,G__5863,G__5864));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5869 = nval;
var G__5870 = (n + (1));
val__$1 = G__5869;
n = G__5870;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$ci_reduce = function(cicoll,f,val,idx){
switch(arguments.length){
case 2:
return cljs$core$ci_reduce__2.call(this,cicoll,f);
case 3:
return cljs$core$ci_reduce__3.call(this,cicoll,f,val);
case 4:
return cljs$core$ci_reduce__4.call(this,cicoll,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$ci_reduce__2;
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$ci_reduce__3;
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$ci_reduce__4;
return cljs$core$ci_reduce;
})()
;
cljs.core.array_reduce = (function() {
var cljs$core$array_reduce = null;
var cljs$core$array_reduce__2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__5877 = val;
var G__5878 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5877,G__5878) : f.call(null,G__5877,G__5878));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5883 = nval;
var G__5884 = (n + (1));
val = G__5883;
n = G__5884;
continue;
}
} else {
return val;
}
break;
}
}
});
var cljs$core$array_reduce__3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__5879 = val__$1;
var G__5880 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5879,G__5880) : f.call(null,G__5879,G__5880));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5885 = nval;
var G__5886 = (n + (1));
val__$1 = G__5885;
n = G__5886;
continue;
}
} else {
return val__$1;
}
break;
}
});
var cljs$core$array_reduce__4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__5881 = val__$1;
var G__5882 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5881,G__5882) : f.call(null,G__5881,G__5882));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5887 = nval;
var G__5888 = (n + (1));
val__$1 = G__5887;
n = G__5888;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$array_reduce = function(arr,f,val,idx){
switch(arguments.length){
case 2:
return cljs$core$array_reduce__2.call(this,arr,f);
case 3:
return cljs$core$array_reduce__3.call(this,arr,f,val);
case 4:
return cljs$core$array_reduce__4.call(this,arr,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_reduce__2;
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$array_reduce__3;
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$array_reduce__4;
return cljs$core$array_reduce;
})()
;



/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
var G__5890 = x;
if(G__5890){
var bit__4414__auto__ = (G__5890.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4414__auto__) || (G__5890.cljs$core$ICounted$)){
return true;
} else {
if((!G__5890.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__5890);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__5890);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
var G__5892 = x;
if(G__5892){
var bit__4414__auto__ = (G__5892.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4414__auto__) || (G__5892.cljs$core$IIndexed$)){
return true;
} else {
if((!G__5892.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__5892);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__5892);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__5893 = coll__$1;
var G__5894 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__5893,G__5894) : cljs.core.equiv_sequential.call(null,G__5893,G__5894));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__5895 = o;
var G__5896 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__5895,G__5896) : cljs.core.cons.call(null,G__5895,G__5896));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function() {
var cljs$core$prim_seq = null;
var cljs$core$prim_seq__1 = (function (prim){
return cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});
var cljs$core$prim_seq__2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});
cljs$core$prim_seq = function(prim,i){
switch(arguments.length){
case 1:
return cljs$core$prim_seq__1.call(this,prim);
case 2:
return cljs$core$prim_seq__2.call(this,prim,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$prim_seq__1;
cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$2 = cljs$core$prim_seq__2;
return cljs$core$prim_seq;
})()
;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function() {
var cljs$core$array_seq = null;
var cljs$core$array_seq__1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});
var cljs$core$array_seq__2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});
cljs$core$array_seq = function(array,i){
switch(arguments.length){
case 1:
return cljs$core$array_seq__1.call(this,array);
case 2:
return cljs$core$array_seq__2.call(this,array,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$array_seq__1;
cljs$core$array_seq.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_seq__2;
return cljs$core$array_seq;
})()
;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__5899 = coll__$1;
var G__5900 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__5899,G__5900) : cljs.core.equiv_sequential.call(null,G__5899,G__5900));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__5901 = cljs.core.List.EMPTY;
var G__5902 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__5901,G__5902) : cljs.core.with_meta.call(null,G__5901,G__5902));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__5903 = f;
var G__5904 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__5903,G__5904) : cljs.core.seq_reduce.call(null,G__5903,G__5904));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__5905 = f;
var G__5906 = start;
var G__5907 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__5905,G__5906,G__5907) : cljs.core.seq_reduce.call(null,G__5905,G__5906,G__5907));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__5908 = o;
var G__5909 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__5908,G__5909) : cljs.core.cons.call(null,G__5908,G__5909));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__5910 = sn;
s = G__5910;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 * 'added'. (conj nil item) returns (item).  The 'addition' may
 * happen at different 'places' depending on the concrete type.
 * @param {...*} var_args
 */
cljs.core.conj = (function() {
var cljs$core$conj = null;
var cljs$core$conj__0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});
var cljs$core$conj__1 = (function (coll){
return coll;
});
var cljs$core$conj__2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});
var cljs$core$conj__3 = (function() { 
var G__5915__delegate = function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__5916 = cljs$core$conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__5917 = cljs.core.first(xs);
var G__5918 = cljs.core.next(xs);
coll = G__5916;
x = G__5917;
xs = G__5918;
continue;
} else {
return cljs$core$conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
};
var G__5915 = function (coll,x,var_args){
var xs = null;
if (arguments.length > 2) {
var G__5919__i = 0, G__5919__a = new Array(arguments.length -  2);
while (G__5919__i < G__5919__a.length) {G__5919__a[G__5919__i] = arguments[G__5919__i + 2]; ++G__5919__i;}
  xs = new cljs.core.IndexedSeq(G__5919__a,0);
} 
return G__5915__delegate.call(this,coll,x,xs);};
G__5915.cljs$lang$maxFixedArity = 2;
G__5915.cljs$lang$applyTo = (function (arglist__5920){
var coll = cljs.core.first(arglist__5920);
arglist__5920 = cljs.core.next(arglist__5920);
var x = cljs.core.first(arglist__5920);
var xs = cljs.core.rest(arglist__5920);
return G__5915__delegate(coll,x,xs);
});
G__5915.cljs$core$IFn$_invoke$arity$variadic = G__5915__delegate;
return G__5915;
})()
;
cljs$core$conj = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 0:
return cljs$core$conj__0.call(this);
case 1:
return cljs$core$conj__1.call(this,coll);
case 2:
return cljs$core$conj__2.call(this,coll,x);
default:
var G__5921 = null;
if (arguments.length > 2) {
var G__5922__i = 0, G__5922__a = new Array(arguments.length -  2);
while (G__5922__i < G__5922__a.length) {G__5922__a[G__5922__i] = arguments[G__5922__i + 2]; ++G__5922__i;}
G__5921 = new cljs.core.IndexedSeq(G__5922__a,0);
}
return cljs$core$conj__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, G__5921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$conj.cljs$lang$maxFixedArity = 2;
cljs$core$conj.cljs$lang$applyTo = cljs$core$conj__3.cljs$lang$applyTo;
cljs$core$conj.cljs$core$IFn$_invoke$arity$0 = cljs$core$conj__0;
cljs$core$conj.cljs$core$IFn$_invoke$arity$1 = cljs$core$conj__1;
cljs$core$conj.cljs$core$IFn$_invoke$arity$2 = cljs$core$conj__2;
cljs$core$conj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$conj__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$conj;
})()
;
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__5923 = cljs.core.next(s);
var G__5924 = (acc + (1));
s = G__5923;
acc = G__5924;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 * 0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if((function (){var G__5926 = coll;
if(G__5926){
var bit__4407__auto__ = (G__5926.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4407__auto__) || (G__5926.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function() {
var cljs$core$linear_traversal_nth = null;
var cljs$core$linear_traversal_nth__2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__5927 = cljs.core.next(coll);
var G__5928 = (n - (1));
coll = G__5927;
n = G__5928;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});
var cljs$core$linear_traversal_nth__3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__5929 = cljs.core.next(coll);
var G__5930 = (n - (1));
var G__5931 = not_found;
coll = G__5929;
n = G__5930;
not_found = G__5931;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});
cljs$core$linear_traversal_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$linear_traversal_nth__2.call(this,coll,n);
case 3:
return cljs$core$linear_traversal_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$linear_traversal_nth__2;
cljs$core$linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$linear_traversal_nth__3;
return cljs$core$linear_traversal_nth;
})()
;
/**
 * Returns the value at the index. get returns nil if index out of
 * bounds, nth throws an exception unless not-found is supplied.  nth
 * also works for strings, arrays, regex Matchers and Lists, and,
 * in O(n) time, for sequences.
 */
cljs.core.nth = (function() {
var cljs$core$nth = null;
var cljs$core$nth__2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__5936 = coll;
if(G__5936){
var bit__4407__auto__ = (G__5936.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4407__auto__) || (G__5936.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__5937 = coll;
if(G__5937){
var bit__4414__auto__ = (G__5937.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4414__auto__) || (G__5937.cljs$core$ISeq$)){
return true;
} else {
if((!G__5937.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5937);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5937);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
var cljs$core$nth__3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__5938 = coll;
if(G__5938){
var bit__4407__auto__ = (G__5938.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4407__auto__) || (G__5938.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__5939 = coll;
if(G__5939){
var bit__4414__auto__ = (G__5939.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4414__auto__) || (G__5939.cljs$core$ISeq$)){
return true;
} else {
if((!G__5939.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5939);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5939);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
cljs$core$nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$nth__2.call(this,coll,n);
case 3:
return cljs$core$nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$nth__2;
cljs$core$nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$nth__3;
return cljs$core$nth;
})()
;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__5940 = (n__$1 - (1));
var G__5941 = cljs.core.rest(xs);
n__$1 = G__5940;
xs = G__5941;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function() {
var cljs$core$get = null;
var cljs$core$get__2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__5944 = o;
if(G__5944){
var bit__4407__auto__ = (G__5944.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4407__auto__) || (G__5944.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});
var cljs$core$get__3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__5945 = o;
if(G__5945){
var bit__4407__auto__ = (G__5945.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4407__auto__) || (G__5945.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});
cljs$core$get = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$get__2.call(this,o,k);
case 3:
return cljs$core$get__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$get.cljs$core$IFn$_invoke$arity$2 = cljs$core$get__2;
cljs$core$get.cljs$core$IFn$_invoke$arity$3 = cljs$core$get__3;
return cljs$core$get;
})()
;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 * @param {...*} var_args
 */
cljs.core.assoc = (function() {
var cljs$core$assoc = null;
var cljs$core$assoc__3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});
var cljs$core$assoc__4 = (function() { 
var G__5949__delegate = function (coll,k,v,kvs){
while(true){
var ret = cljs$core$assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__5950 = ret;
var G__5951 = cljs.core.first(kvs);
var G__5952 = cljs.core.second(kvs);
var G__5953 = cljs.core.nnext(kvs);
coll = G__5950;
k = G__5951;
v = G__5952;
kvs = G__5953;
continue;
} else {
return ret;
}
break;
}
};
var G__5949 = function (coll,k,v,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__5954__i = 0, G__5954__a = new Array(arguments.length -  3);
while (G__5954__i < G__5954__a.length) {G__5954__a[G__5954__i] = arguments[G__5954__i + 3]; ++G__5954__i;}
  kvs = new cljs.core.IndexedSeq(G__5954__a,0);
} 
return G__5949__delegate.call(this,coll,k,v,kvs);};
G__5949.cljs$lang$maxFixedArity = 3;
G__5949.cljs$lang$applyTo = (function (arglist__5955){
var coll = cljs.core.first(arglist__5955);
arglist__5955 = cljs.core.next(arglist__5955);
var k = cljs.core.first(arglist__5955);
arglist__5955 = cljs.core.next(arglist__5955);
var v = cljs.core.first(arglist__5955);
var kvs = cljs.core.rest(arglist__5955);
return G__5949__delegate(coll,k,v,kvs);
});
G__5949.cljs$core$IFn$_invoke$arity$variadic = G__5949__delegate;
return G__5949;
})()
;
cljs$core$assoc = function(coll,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return cljs$core$assoc__3.call(this,coll,k,v);
default:
var G__5956 = null;
if (arguments.length > 3) {
var G__5957__i = 0, G__5957__a = new Array(arguments.length -  3);
while (G__5957__i < G__5957__a.length) {G__5957__a[G__5957__i] = arguments[G__5957__i + 3]; ++G__5957__i;}
G__5956 = new cljs.core.IndexedSeq(G__5957__a,0);
}
return cljs$core$assoc__4.cljs$core$IFn$_invoke$arity$variadic(coll,k,v, G__5956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$assoc.cljs$lang$maxFixedArity = 3;
cljs$core$assoc.cljs$lang$applyTo = cljs$core$assoc__4.cljs$lang$applyTo;
cljs$core$assoc.cljs$core$IFn$_invoke$arity$3 = cljs$core$assoc__3;
cljs$core$assoc.cljs$core$IFn$_invoke$arity$variadic = cljs$core$assoc__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$assoc;
})()
;
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 * that does not contain a mapping for key(s).
 * @param {...*} var_args
 */
cljs.core.dissoc = (function() {
var cljs$core$dissoc = null;
var cljs$core$dissoc__1 = (function (coll){
return coll;
});
var cljs$core$dissoc__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});
var cljs$core$dissoc__3 = (function() { 
var G__5960__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs$core$dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__5961 = ret;
var G__5962 = cljs.core.first(ks);
var G__5963 = cljs.core.next(ks);
coll = G__5961;
k = G__5962;
ks = G__5963;
continue;
} else {
return ret;
}
}
break;
}
};
var G__5960 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__5964__i = 0, G__5964__a = new Array(arguments.length -  2);
while (G__5964__i < G__5964__a.length) {G__5964__a[G__5964__i] = arguments[G__5964__i + 2]; ++G__5964__i;}
  ks = new cljs.core.IndexedSeq(G__5964__a,0);
} 
return G__5960__delegate.call(this,coll,k,ks);};
G__5960.cljs$lang$maxFixedArity = 2;
G__5960.cljs$lang$applyTo = (function (arglist__5965){
var coll = cljs.core.first(arglist__5965);
arglist__5965 = cljs.core.next(arglist__5965);
var k = cljs.core.first(arglist__5965);
var ks = cljs.core.rest(arglist__5965);
return G__5960__delegate(coll,k,ks);
});
G__5960.cljs$core$IFn$_invoke$arity$variadic = G__5960__delegate;
return G__5960;
})()
;
cljs$core$dissoc = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return cljs$core$dissoc__1.call(this,coll);
case 2:
return cljs$core$dissoc__2.call(this,coll,k);
default:
var G__5966 = null;
if (arguments.length > 2) {
var G__5967__i = 0, G__5967__a = new Array(arguments.length -  2);
while (G__5967__i < G__5967__a.length) {G__5967__a[G__5967__i] = arguments[G__5967__i + 2]; ++G__5967__i;}
G__5966 = new cljs.core.IndexedSeq(G__5967__a,0);
}
return cljs$core$dissoc__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__5966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dissoc.cljs$lang$maxFixedArity = 2;
cljs$core$dissoc.cljs$lang$applyTo = cljs$core$dissoc__3.cljs$lang$applyTo;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$1 = cljs$core$dissoc__1;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$2 = cljs$core$dissoc__2;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$variadic = cljs$core$dissoc__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$dissoc;
})()
;
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__3740__auto__ = (function (){var G__5972 = f;
return goog.isFunction(G__5972);
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var G__5973 = f;
if(G__5973){
var bit__4414__auto__ = null;
if(cljs.core.truth_((function (){var or__3740__auto____$1 = bit__4414__auto__;
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
return G__5973.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__5973.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__5973);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__5973);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393217;
})
cljs.core.MetaFn.prototype.call = (function() {
var G__6439 = null;
var G__6439__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__6439__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5975 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__5975) : self__.afn.call(null,G__5975));
});
var G__6439__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5976 = a;
var G__5977 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__5976,G__5977) : self__.afn.call(null,G__5976,G__5977));
});
var G__6439__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5978 = a;
var G__5979 = b;
var G__5980 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__5978,G__5979,G__5980) : self__.afn.call(null,G__5978,G__5979,G__5980));
});
var G__6439__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5981 = a;
var G__5982 = b;
var G__5983 = c;
var G__5984 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__5981,G__5982,G__5983,G__5984) : self__.afn.call(null,G__5981,G__5982,G__5983,G__5984));
});
var G__6439__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5985 = a;
var G__5986 = b;
var G__5987 = c;
var G__5988 = d;
var G__5989 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__5985,G__5986,G__5987,G__5988,G__5989) : self__.afn.call(null,G__5985,G__5986,G__5987,G__5988,G__5989));
});
var G__6439__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5990 = a;
var G__5991 = b;
var G__5992 = c;
var G__5993 = d;
var G__5994 = e;
var G__5995 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__5990,G__5991,G__5992,G__5993,G__5994,G__5995) : self__.afn.call(null,G__5990,G__5991,G__5992,G__5993,G__5994,G__5995));
});
var G__6439__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5996 = a;
var G__5997 = b;
var G__5998 = c;
var G__5999 = d;
var G__6000 = e;
var G__6001 = f;
var G__6002 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__5996,G__5997,G__5998,G__5999,G__6000,G__6001,G__6002) : self__.afn.call(null,G__5996,G__5997,G__5998,G__5999,G__6000,G__6001,G__6002));
});
var G__6439__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6003 = a;
var G__6004 = b;
var G__6005 = c;
var G__6006 = d;
var G__6007 = e;
var G__6008 = f;
var G__6009 = g;
var G__6010 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6003,G__6004,G__6005,G__6006,G__6007,G__6008,G__6009,G__6010) : self__.afn.call(null,G__6003,G__6004,G__6005,G__6006,G__6007,G__6008,G__6009,G__6010));
});
var G__6439__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6011 = a;
var G__6012 = b;
var G__6013 = c;
var G__6014 = d;
var G__6015 = e;
var G__6016 = f;
var G__6017 = g;
var G__6018 = h;
var G__6019 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6011,G__6012,G__6013,G__6014,G__6015,G__6016,G__6017,G__6018,G__6019) : self__.afn.call(null,G__6011,G__6012,G__6013,G__6014,G__6015,G__6016,G__6017,G__6018,G__6019));
});
var G__6439__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6020 = a;
var G__6021 = b;
var G__6022 = c;
var G__6023 = d;
var G__6024 = e;
var G__6025 = f;
var G__6026 = g;
var G__6027 = h;
var G__6028 = i;
var G__6029 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6020,G__6021,G__6022,G__6023,G__6024,G__6025,G__6026,G__6027,G__6028,G__6029) : self__.afn.call(null,G__6020,G__6021,G__6022,G__6023,G__6024,G__6025,G__6026,G__6027,G__6028,G__6029));
});
var G__6439__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6030 = a;
var G__6031 = b;
var G__6032 = c;
var G__6033 = d;
var G__6034 = e;
var G__6035 = f;
var G__6036 = g;
var G__6037 = h;
var G__6038 = i;
var G__6039 = j;
var G__6040 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6030,G__6031,G__6032,G__6033,G__6034,G__6035,G__6036,G__6037,G__6038,G__6039,G__6040) : self__.afn.call(null,G__6030,G__6031,G__6032,G__6033,G__6034,G__6035,G__6036,G__6037,G__6038,G__6039,G__6040));
});
var G__6439__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6041 = a;
var G__6042 = b;
var G__6043 = c;
var G__6044 = d;
var G__6045 = e;
var G__6046 = f;
var G__6047 = g;
var G__6048 = h;
var G__6049 = i;
var G__6050 = j;
var G__6051 = k;
var G__6052 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6041,G__6042,G__6043,G__6044,G__6045,G__6046,G__6047,G__6048,G__6049,G__6050,G__6051,G__6052) : self__.afn.call(null,G__6041,G__6042,G__6043,G__6044,G__6045,G__6046,G__6047,G__6048,G__6049,G__6050,G__6051,G__6052));
});
var G__6439__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6053 = a;
var G__6054 = b;
var G__6055 = c;
var G__6056 = d;
var G__6057 = e;
var G__6058 = f;
var G__6059 = g;
var G__6060 = h;
var G__6061 = i;
var G__6062 = j;
var G__6063 = k;
var G__6064 = l;
var G__6065 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6053,G__6054,G__6055,G__6056,G__6057,G__6058,G__6059,G__6060,G__6061,G__6062,G__6063,G__6064,G__6065) : self__.afn.call(null,G__6053,G__6054,G__6055,G__6056,G__6057,G__6058,G__6059,G__6060,G__6061,G__6062,G__6063,G__6064,G__6065));
});
var G__6439__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6066 = a;
var G__6067 = b;
var G__6068 = c;
var G__6069 = d;
var G__6070 = e;
var G__6071 = f;
var G__6072 = g;
var G__6073 = h;
var G__6074 = i;
var G__6075 = j;
var G__6076 = k;
var G__6077 = l;
var G__6078 = m;
var G__6079 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6066,G__6067,G__6068,G__6069,G__6070,G__6071,G__6072,G__6073,G__6074,G__6075,G__6076,G__6077,G__6078,G__6079) : self__.afn.call(null,G__6066,G__6067,G__6068,G__6069,G__6070,G__6071,G__6072,G__6073,G__6074,G__6075,G__6076,G__6077,G__6078,G__6079));
});
var G__6439__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6080 = a;
var G__6081 = b;
var G__6082 = c;
var G__6083 = d;
var G__6084 = e;
var G__6085 = f;
var G__6086 = g;
var G__6087 = h;
var G__6088 = i;
var G__6089 = j;
var G__6090 = k;
var G__6091 = l;
var G__6092 = m;
var G__6093 = n;
var G__6094 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6080,G__6081,G__6082,G__6083,G__6084,G__6085,G__6086,G__6087,G__6088,G__6089,G__6090,G__6091,G__6092,G__6093,G__6094) : self__.afn.call(null,G__6080,G__6081,G__6082,G__6083,G__6084,G__6085,G__6086,G__6087,G__6088,G__6089,G__6090,G__6091,G__6092,G__6093,G__6094));
});
var G__6439__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6095 = a;
var G__6096 = b;
var G__6097 = c;
var G__6098 = d;
var G__6099 = e;
var G__6100 = f;
var G__6101 = g;
var G__6102 = h;
var G__6103 = i;
var G__6104 = j;
var G__6105 = k;
var G__6106 = l;
var G__6107 = m;
var G__6108 = n;
var G__6109 = o;
var G__6110 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6095,G__6096,G__6097,G__6098,G__6099,G__6100,G__6101,G__6102,G__6103,G__6104,G__6105,G__6106,G__6107,G__6108,G__6109,G__6110) : self__.afn.call(null,G__6095,G__6096,G__6097,G__6098,G__6099,G__6100,G__6101,G__6102,G__6103,G__6104,G__6105,G__6106,G__6107,G__6108,G__6109,G__6110));
});
var G__6439__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6111 = a;
var G__6112 = b;
var G__6113 = c;
var G__6114 = d;
var G__6115 = e;
var G__6116 = f;
var G__6117 = g;
var G__6118 = h;
var G__6119 = i;
var G__6120 = j;
var G__6121 = k;
var G__6122 = l;
var G__6123 = m;
var G__6124 = n;
var G__6125 = o;
var G__6126 = p;
var G__6127 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6111,G__6112,G__6113,G__6114,G__6115,G__6116,G__6117,G__6118,G__6119,G__6120,G__6121,G__6122,G__6123,G__6124,G__6125,G__6126,G__6127) : self__.afn.call(null,G__6111,G__6112,G__6113,G__6114,G__6115,G__6116,G__6117,G__6118,G__6119,G__6120,G__6121,G__6122,G__6123,G__6124,G__6125,G__6126,G__6127));
});
var G__6439__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6128 = a;
var G__6129 = b;
var G__6130 = c;
var G__6131 = d;
var G__6132 = e;
var G__6133 = f;
var G__6134 = g;
var G__6135 = h;
var G__6136 = i;
var G__6137 = j;
var G__6138 = k;
var G__6139 = l;
var G__6140 = m;
var G__6141 = n;
var G__6142 = o;
var G__6143 = p;
var G__6144 = q;
var G__6145 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6128,G__6129,G__6130,G__6131,G__6132,G__6133,G__6134,G__6135,G__6136,G__6137,G__6138,G__6139,G__6140,G__6141,G__6142,G__6143,G__6144,G__6145) : self__.afn.call(null,G__6128,G__6129,G__6130,G__6131,G__6132,G__6133,G__6134,G__6135,G__6136,G__6137,G__6138,G__6139,G__6140,G__6141,G__6142,G__6143,G__6144,G__6145));
});
var G__6439__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6146 = a;
var G__6147 = b;
var G__6148 = c;
var G__6149 = d;
var G__6150 = e;
var G__6151 = f;
var G__6152 = g;
var G__6153 = h;
var G__6154 = i;
var G__6155 = j;
var G__6156 = k;
var G__6157 = l;
var G__6158 = m;
var G__6159 = n;
var G__6160 = o;
var G__6161 = p;
var G__6162 = q;
var G__6163 = r;
var G__6164 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6146,G__6147,G__6148,G__6149,G__6150,G__6151,G__6152,G__6153,G__6154,G__6155,G__6156,G__6157,G__6158,G__6159,G__6160,G__6161,G__6162,G__6163,G__6164) : self__.afn.call(null,G__6146,G__6147,G__6148,G__6149,G__6150,G__6151,G__6152,G__6153,G__6154,G__6155,G__6156,G__6157,G__6158,G__6159,G__6160,G__6161,G__6162,G__6163,G__6164));
});
var G__6439__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6165 = a;
var G__6166 = b;
var G__6167 = c;
var G__6168 = d;
var G__6169 = e;
var G__6170 = f;
var G__6171 = g;
var G__6172 = h;
var G__6173 = i;
var G__6174 = j;
var G__6175 = k;
var G__6176 = l;
var G__6177 = m;
var G__6178 = n;
var G__6179 = o;
var G__6180 = p;
var G__6181 = q;
var G__6182 = r;
var G__6183 = s;
var G__6184 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6165,G__6166,G__6167,G__6168,G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176,G__6177,G__6178,G__6179,G__6180,G__6181,G__6182,G__6183,G__6184) : self__.afn.call(null,G__6165,G__6166,G__6167,G__6168,G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176,G__6177,G__6178,G__6179,G__6180,G__6181,G__6182,G__6183,G__6184));
});
var G__6439__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6185 = self__.afn;
var G__6186 = a;
var G__6187 = b;
var G__6188 = c;
var G__6189 = d;
var G__6190 = e;
var G__6191 = f;
var G__6192 = g;
var G__6193 = h;
var G__6194 = i;
var G__6195 = j;
var G__6196 = k;
var G__6197 = l;
var G__6198 = m;
var G__6199 = n;
var G__6200 = o;
var G__6201 = p;
var G__6202 = q;
var G__6203 = r;
var G__6204 = s;
var G__6205 = t;
var G__6206 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6185,G__6186,G__6187,G__6188,G__6189,G__6190,G__6191,G__6192,G__6193,G__6194,G__6195,G__6196,G__6197,G__6198,G__6199,G__6200,G__6201,G__6202,G__6203,G__6204,G__6205,G__6206) : cljs.core.apply.call(null,G__6185,G__6186,G__6187,G__6188,G__6189,G__6190,G__6191,G__6192,G__6193,G__6194,G__6195,G__6196,G__6197,G__6198,G__6199,G__6200,G__6201,G__6202,G__6203,G__6204,G__6205,G__6206));
});
G__6439 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__6439__1.call(this,self__);
case 2:
return G__6439__2.call(this,self__,a);
case 3:
return G__6439__3.call(this,self__,a,b);
case 4:
return G__6439__4.call(this,self__,a,b,c);
case 5:
return G__6439__5.call(this,self__,a,b,c,d);
case 6:
return G__6439__6.call(this,self__,a,b,c,d,e);
case 7:
return G__6439__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__6439__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__6439__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__6439__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__6439__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__6439__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__6439__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__6439__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__6439__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__6439__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__6439__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__6439__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__6439__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__6439__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__6439__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__6439__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6439.cljs$core$IFn$_invoke$arity$1 = G__6439__1;
G__6439.cljs$core$IFn$_invoke$arity$2 = G__6439__2;
G__6439.cljs$core$IFn$_invoke$arity$3 = G__6439__3;
G__6439.cljs$core$IFn$_invoke$arity$4 = G__6439__4;
G__6439.cljs$core$IFn$_invoke$arity$5 = G__6439__5;
G__6439.cljs$core$IFn$_invoke$arity$6 = G__6439__6;
G__6439.cljs$core$IFn$_invoke$arity$7 = G__6439__7;
G__6439.cljs$core$IFn$_invoke$arity$8 = G__6439__8;
G__6439.cljs$core$IFn$_invoke$arity$9 = G__6439__9;
G__6439.cljs$core$IFn$_invoke$arity$10 = G__6439__10;
G__6439.cljs$core$IFn$_invoke$arity$11 = G__6439__11;
G__6439.cljs$core$IFn$_invoke$arity$12 = G__6439__12;
G__6439.cljs$core$IFn$_invoke$arity$13 = G__6439__13;
G__6439.cljs$core$IFn$_invoke$arity$14 = G__6439__14;
G__6439.cljs$core$IFn$_invoke$arity$15 = G__6439__15;
G__6439.cljs$core$IFn$_invoke$arity$16 = G__6439__16;
G__6439.cljs$core$IFn$_invoke$arity$17 = G__6439__17;
G__6439.cljs$core$IFn$_invoke$arity$18 = G__6439__18;
G__6439.cljs$core$IFn$_invoke$arity$19 = G__6439__19;
G__6439.cljs$core$IFn$_invoke$arity$20 = G__6439__20;
G__6439.cljs$core$IFn$_invoke$arity$21 = G__6439__21;
G__6439.cljs$core$IFn$_invoke$arity$22 = G__6439__22;
return G__6439;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args5974){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5974)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__6207 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6207) : self__.afn.call(null,G__6207));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__6208 = a;
var G__6209 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6208,G__6209) : self__.afn.call(null,G__6208,G__6209));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__6210 = a;
var G__6211 = b;
var G__6212 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6210,G__6211,G__6212) : self__.afn.call(null,G__6210,G__6211,G__6212));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__6213 = a;
var G__6214 = b;
var G__6215 = c;
var G__6216 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6213,G__6214,G__6215,G__6216) : self__.afn.call(null,G__6213,G__6214,G__6215,G__6216));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__6217 = a;
var G__6218 = b;
var G__6219 = c;
var G__6220 = d;
var G__6221 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6217,G__6218,G__6219,G__6220,G__6221) : self__.afn.call(null,G__6217,G__6218,G__6219,G__6220,G__6221));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__6222 = a;
var G__6223 = b;
var G__6224 = c;
var G__6225 = d;
var G__6226 = e;
var G__6227 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6222,G__6223,G__6224,G__6225,G__6226,G__6227) : self__.afn.call(null,G__6222,G__6223,G__6224,G__6225,G__6226,G__6227));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__6228 = a;
var G__6229 = b;
var G__6230 = c;
var G__6231 = d;
var G__6232 = e;
var G__6233 = f;
var G__6234 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6228,G__6229,G__6230,G__6231,G__6232,G__6233,G__6234) : self__.afn.call(null,G__6228,G__6229,G__6230,G__6231,G__6232,G__6233,G__6234));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__6235 = a;
var G__6236 = b;
var G__6237 = c;
var G__6238 = d;
var G__6239 = e;
var G__6240 = f;
var G__6241 = g;
var G__6242 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6235,G__6236,G__6237,G__6238,G__6239,G__6240,G__6241,G__6242) : self__.afn.call(null,G__6235,G__6236,G__6237,G__6238,G__6239,G__6240,G__6241,G__6242));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__6243 = a;
var G__6244 = b;
var G__6245 = c;
var G__6246 = d;
var G__6247 = e;
var G__6248 = f;
var G__6249 = g;
var G__6250 = h;
var G__6251 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6243,G__6244,G__6245,G__6246,G__6247,G__6248,G__6249,G__6250,G__6251) : self__.afn.call(null,G__6243,G__6244,G__6245,G__6246,G__6247,G__6248,G__6249,G__6250,G__6251));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__6252 = a;
var G__6253 = b;
var G__6254 = c;
var G__6255 = d;
var G__6256 = e;
var G__6257 = f;
var G__6258 = g;
var G__6259 = h;
var G__6260 = i;
var G__6261 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6252,G__6253,G__6254,G__6255,G__6256,G__6257,G__6258,G__6259,G__6260,G__6261) : self__.afn.call(null,G__6252,G__6253,G__6254,G__6255,G__6256,G__6257,G__6258,G__6259,G__6260,G__6261));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__6262 = a;
var G__6263 = b;
var G__6264 = c;
var G__6265 = d;
var G__6266 = e;
var G__6267 = f;
var G__6268 = g;
var G__6269 = h;
var G__6270 = i;
var G__6271 = j;
var G__6272 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6262,G__6263,G__6264,G__6265,G__6266,G__6267,G__6268,G__6269,G__6270,G__6271,G__6272) : self__.afn.call(null,G__6262,G__6263,G__6264,G__6265,G__6266,G__6267,G__6268,G__6269,G__6270,G__6271,G__6272));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__6273 = a;
var G__6274 = b;
var G__6275 = c;
var G__6276 = d;
var G__6277 = e;
var G__6278 = f;
var G__6279 = g;
var G__6280 = h;
var G__6281 = i;
var G__6282 = j;
var G__6283 = k;
var G__6284 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6273,G__6274,G__6275,G__6276,G__6277,G__6278,G__6279,G__6280,G__6281,G__6282,G__6283,G__6284) : self__.afn.call(null,G__6273,G__6274,G__6275,G__6276,G__6277,G__6278,G__6279,G__6280,G__6281,G__6282,G__6283,G__6284));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__6285 = a;
var G__6286 = b;
var G__6287 = c;
var G__6288 = d;
var G__6289 = e;
var G__6290 = f;
var G__6291 = g;
var G__6292 = h;
var G__6293 = i;
var G__6294 = j;
var G__6295 = k;
var G__6296 = l;
var G__6297 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6285,G__6286,G__6287,G__6288,G__6289,G__6290,G__6291,G__6292,G__6293,G__6294,G__6295,G__6296,G__6297) : self__.afn.call(null,G__6285,G__6286,G__6287,G__6288,G__6289,G__6290,G__6291,G__6292,G__6293,G__6294,G__6295,G__6296,G__6297));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__6298 = a;
var G__6299 = b;
var G__6300 = c;
var G__6301 = d;
var G__6302 = e;
var G__6303 = f;
var G__6304 = g;
var G__6305 = h;
var G__6306 = i;
var G__6307 = j;
var G__6308 = k;
var G__6309 = l;
var G__6310 = m;
var G__6311 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6298,G__6299,G__6300,G__6301,G__6302,G__6303,G__6304,G__6305,G__6306,G__6307,G__6308,G__6309,G__6310,G__6311) : self__.afn.call(null,G__6298,G__6299,G__6300,G__6301,G__6302,G__6303,G__6304,G__6305,G__6306,G__6307,G__6308,G__6309,G__6310,G__6311));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__6312 = a;
var G__6313 = b;
var G__6314 = c;
var G__6315 = d;
var G__6316 = e;
var G__6317 = f;
var G__6318 = g;
var G__6319 = h;
var G__6320 = i;
var G__6321 = j;
var G__6322 = k;
var G__6323 = l;
var G__6324 = m;
var G__6325 = n;
var G__6326 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6312,G__6313,G__6314,G__6315,G__6316,G__6317,G__6318,G__6319,G__6320,G__6321,G__6322,G__6323,G__6324,G__6325,G__6326) : self__.afn.call(null,G__6312,G__6313,G__6314,G__6315,G__6316,G__6317,G__6318,G__6319,G__6320,G__6321,G__6322,G__6323,G__6324,G__6325,G__6326));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__6327 = a;
var G__6328 = b;
var G__6329 = c;
var G__6330 = d;
var G__6331 = e;
var G__6332 = f;
var G__6333 = g;
var G__6334 = h;
var G__6335 = i;
var G__6336 = j;
var G__6337 = k;
var G__6338 = l;
var G__6339 = m;
var G__6340 = n;
var G__6341 = o;
var G__6342 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6327,G__6328,G__6329,G__6330,G__6331,G__6332,G__6333,G__6334,G__6335,G__6336,G__6337,G__6338,G__6339,G__6340,G__6341,G__6342) : self__.afn.call(null,G__6327,G__6328,G__6329,G__6330,G__6331,G__6332,G__6333,G__6334,G__6335,G__6336,G__6337,G__6338,G__6339,G__6340,G__6341,G__6342));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__6343 = a;
var G__6344 = b;
var G__6345 = c;
var G__6346 = d;
var G__6347 = e;
var G__6348 = f;
var G__6349 = g;
var G__6350 = h;
var G__6351 = i;
var G__6352 = j;
var G__6353 = k;
var G__6354 = l;
var G__6355 = m;
var G__6356 = n;
var G__6357 = o;
var G__6358 = p;
var G__6359 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6343,G__6344,G__6345,G__6346,G__6347,G__6348,G__6349,G__6350,G__6351,G__6352,G__6353,G__6354,G__6355,G__6356,G__6357,G__6358,G__6359) : self__.afn.call(null,G__6343,G__6344,G__6345,G__6346,G__6347,G__6348,G__6349,G__6350,G__6351,G__6352,G__6353,G__6354,G__6355,G__6356,G__6357,G__6358,G__6359));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__6360 = a;
var G__6361 = b;
var G__6362 = c;
var G__6363 = d;
var G__6364 = e;
var G__6365 = f;
var G__6366 = g;
var G__6367 = h;
var G__6368 = i;
var G__6369 = j;
var G__6370 = k;
var G__6371 = l;
var G__6372 = m;
var G__6373 = n;
var G__6374 = o;
var G__6375 = p;
var G__6376 = q;
var G__6377 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6360,G__6361,G__6362,G__6363,G__6364,G__6365,G__6366,G__6367,G__6368,G__6369,G__6370,G__6371,G__6372,G__6373,G__6374,G__6375,G__6376,G__6377) : self__.afn.call(null,G__6360,G__6361,G__6362,G__6363,G__6364,G__6365,G__6366,G__6367,G__6368,G__6369,G__6370,G__6371,G__6372,G__6373,G__6374,G__6375,G__6376,G__6377));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__6378 = a;
var G__6379 = b;
var G__6380 = c;
var G__6381 = d;
var G__6382 = e;
var G__6383 = f;
var G__6384 = g;
var G__6385 = h;
var G__6386 = i;
var G__6387 = j;
var G__6388 = k;
var G__6389 = l;
var G__6390 = m;
var G__6391 = n;
var G__6392 = o;
var G__6393 = p;
var G__6394 = q;
var G__6395 = r;
var G__6396 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6378,G__6379,G__6380,G__6381,G__6382,G__6383,G__6384,G__6385,G__6386,G__6387,G__6388,G__6389,G__6390,G__6391,G__6392,G__6393,G__6394,G__6395,G__6396) : self__.afn.call(null,G__6378,G__6379,G__6380,G__6381,G__6382,G__6383,G__6384,G__6385,G__6386,G__6387,G__6388,G__6389,G__6390,G__6391,G__6392,G__6393,G__6394,G__6395,G__6396));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__6397 = a;
var G__6398 = b;
var G__6399 = c;
var G__6400 = d;
var G__6401 = e;
var G__6402 = f;
var G__6403 = g;
var G__6404 = h;
var G__6405 = i;
var G__6406 = j;
var G__6407 = k;
var G__6408 = l;
var G__6409 = m;
var G__6410 = n;
var G__6411 = o;
var G__6412 = p;
var G__6413 = q;
var G__6414 = r;
var G__6415 = s;
var G__6416 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6397,G__6398,G__6399,G__6400,G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408,G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416) : self__.afn.call(null,G__6397,G__6398,G__6399,G__6400,G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408,G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__6417 = self__.afn;
var G__6418 = a;
var G__6419 = b;
var G__6420 = c;
var G__6421 = d;
var G__6422 = e;
var G__6423 = f;
var G__6424 = g;
var G__6425 = h;
var G__6426 = i;
var G__6427 = j;
var G__6428 = k;
var G__6429 = l;
var G__6430 = m;
var G__6431 = n;
var G__6432 = o;
var G__6433 = p;
var G__6434 = q;
var G__6435 = r;
var G__6436 = s;
var G__6437 = t;
var G__6438 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6417,G__6418,G__6419,G__6420,G__6421,G__6422,G__6423,G__6424,G__6425,G__6426,G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438) : cljs.core.apply.call(null,G__6417,G__6418,G__6419,G__6420,G__6421,G__6422,G__6423,G__6424,G__6425,G__6426,G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 * map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__6443 = o;
if(G__6443){
var bit__4414__auto__ = (G__6443.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4414__auto__) || (G__6443.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__6443.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__6443);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__6443);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__3728__auto__ = !((o == null));
if(and__3728__auto__){
var G__6447 = o;
if(G__6447){
var bit__4414__auto__ = (G__6447.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4414__auto__) || (G__6447.cljs$core$IMeta$)){
return true;
} else {
if((!G__6447.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__6447);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__6447);
}
} else {
return and__3728__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 * more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 * item, for a vector, returns a new vector without the last item.
 * Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 * does not contain key(s).
 * @param {...*} var_args
 */
cljs.core.disj = (function() {
var cljs$core$disj = null;
var cljs$core$disj__1 = (function (coll){
return coll;
});
var cljs$core$disj__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});
var cljs$core$disj__3 = (function() { 
var G__6450__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs$core$disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__6451 = ret;
var G__6452 = cljs.core.first(ks);
var G__6453 = cljs.core.next(ks);
coll = G__6451;
k = G__6452;
ks = G__6453;
continue;
} else {
return ret;
}
}
break;
}
};
var G__6450 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__6454__i = 0, G__6454__a = new Array(arguments.length -  2);
while (G__6454__i < G__6454__a.length) {G__6454__a[G__6454__i] = arguments[G__6454__i + 2]; ++G__6454__i;}
  ks = new cljs.core.IndexedSeq(G__6454__a,0);
} 
return G__6450__delegate.call(this,coll,k,ks);};
G__6450.cljs$lang$maxFixedArity = 2;
G__6450.cljs$lang$applyTo = (function (arglist__6455){
var coll = cljs.core.first(arglist__6455);
arglist__6455 = cljs.core.next(arglist__6455);
var k = cljs.core.first(arglist__6455);
var ks = cljs.core.rest(arglist__6455);
return G__6450__delegate(coll,k,ks);
});
G__6450.cljs$core$IFn$_invoke$arity$variadic = G__6450__delegate;
return G__6450;
})()
;
cljs$core$disj = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return cljs$core$disj__1.call(this,coll);
case 2:
return cljs$core$disj__2.call(this,coll,k);
default:
var G__6456 = null;
if (arguments.length > 2) {
var G__6457__i = 0, G__6457__a = new Array(arguments.length -  2);
while (G__6457__i < G__6457__a.length) {G__6457__a[G__6457__i] = arguments[G__6457__i + 2]; ++G__6457__i;}
G__6456 = new cljs.core.IndexedSeq(G__6457__a,0);
}
return cljs$core$disj__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__6456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$disj.cljs$lang$maxFixedArity = 2;
cljs$core$disj.cljs$lang$applyTo = cljs$core$disj__3.cljs$lang$applyTo;
cljs$core$disj.cljs$core$IFn$_invoke$arity$1 = cljs$core$disj__1;
cljs$core$disj.cljs$core$IFn$_invoke$arity$2 = cljs$core$disj__2;
cljs$core$disj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$disj__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$disj;
})()
;
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 * Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6459 = x;
if(G__6459){
var bit__4414__auto__ = (G__6459.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4414__auto__) || (G__6459.cljs$core$ICollection$)){
return true;
} else {
if((!G__6459.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__6459);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__6459);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6461 = x;
if(G__6461){
var bit__4414__auto__ = (G__6461.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4414__auto__) || (G__6461.cljs$core$ISet$)){
return true;
} else {
if((!G__6461.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__6461);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__6461);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
var G__6463 = x;
if(G__6463){
var bit__4414__auto__ = (G__6463.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4414__auto__) || (G__6463.cljs$core$IAssociative$)){
return true;
} else {
if((!G__6463.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__6463);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__6463);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
var G__6465 = x;
if(G__6465){
var bit__4414__auto__ = (G__6465.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4414__auto__) || (G__6465.cljs$core$ISequential$)){
return true;
} else {
if((!G__6465.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__6465);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__6465);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
var G__6467 = x;
if(G__6467){
var bit__4414__auto__ = (G__6467.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4414__auto__) || (G__6467.cljs$core$ISorted$)){
return true;
} else {
if((!G__6467.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__6467);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__6467);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
var G__6469 = x;
if(G__6469){
var bit__4414__auto__ = (G__6469.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4414__auto__) || (G__6469.cljs$core$IReduce$)){
return true;
} else {
if((!G__6469.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__6469);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__6469);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6471 = x;
if(G__6471){
var bit__4414__auto__ = (G__6471.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4414__auto__) || (G__6471.cljs$core$IMap$)){
return true;
} else {
if((!G__6471.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__6471);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__6471);
}
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
var G__6473 = x;
if(G__6473){
var bit__4414__auto__ = (G__6473.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4414__auto__) || (G__6473.cljs$core$IVector$)){
return true;
} else {
if((!G__6473.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__6473);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__6473);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
var G__6475 = x;
if(G__6475){
var bit__4407__auto__ = (G__6475.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4407__auto__) || (G__6475.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 * interleaved keys and values.
 * @param {...*} var_args
 */
cljs.core.js_obj = (function() {
var cljs$core$js_obj = null;
var cljs$core$js_obj__0 = (function (){
var obj6481 = {};
return obj6481;
});
var cljs$core$js_obj__1 = (function() { 
var G__6484__delegate = function (keyvals){
var G__6482 = goog.object.create;
var G__6483 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__6482,G__6483) : cljs.core.apply.call(null,G__6482,G__6483));
};
var G__6484 = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__6485__i = 0, G__6485__a = new Array(arguments.length -  0);
while (G__6485__i < G__6485__a.length) {G__6485__a[G__6485__i] = arguments[G__6485__i + 0]; ++G__6485__i;}
  keyvals = new cljs.core.IndexedSeq(G__6485__a,0);
} 
return G__6484__delegate.call(this,keyvals);};
G__6484.cljs$lang$maxFixedArity = 0;
G__6484.cljs$lang$applyTo = (function (arglist__6486){
var keyvals = cljs.core.seq(arglist__6486);
return G__6484__delegate(keyvals);
});
G__6484.cljs$core$IFn$_invoke$arity$variadic = G__6484__delegate;
return G__6484;
})()
;
cljs$core$js_obj = function(var_args){
var keyvals = var_args;
switch(arguments.length){
case 0:
return cljs$core$js_obj__0.call(this);
default:
var G__6487 = null;
if (arguments.length > 0) {
var G__6488__i = 0, G__6488__a = new Array(arguments.length -  0);
while (G__6488__i < G__6488__a.length) {G__6488__a[G__6488__i] = arguments[G__6488__i + 0]; ++G__6488__i;}
G__6487 = new cljs.core.IndexedSeq(G__6488__a,0);
}
return cljs$core$js_obj__1.cljs$core$IFn$_invoke$arity$variadic(G__6487);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$js_obj.cljs$lang$maxFixedArity = 0;
cljs$core$js_obj.cljs$lang$applyTo = cljs$core$js_obj__1.cljs$lang$applyTo;
cljs$core$js_obj.cljs$core$IFn$_invoke$arity$0 = cljs$core$js_obj__0;
cljs$core$js_obj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js_obj__1.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$js_obj;
})()
;
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__6491_6493 = obj;
var G__6492_6494 = ((function (G__6491_6493,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__6491_6493,keys))
;
goog.object.forEach(G__6491_6493,G__6492_6494);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__6495 = (i__$1 + (1));
var G__6496 = (j__$1 + (1));
var G__6497 = (len__$1 - (1));
i__$1 = G__6495;
j__$1 = G__6496;
len__$1 = G__6497;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__6498 = (i__$1 - (1));
var G__6499 = (j__$1 - (1));
var G__6500 = (len__$1 - (1));
i__$1 = G__6498;
j__$1 = G__6499;
len__$1 = G__6500;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj6502 = {};
return obj6502;
})();
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__6504 = s;
if(G__6504){
var bit__4414__auto__ = (G__6504.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4414__auto__) || (G__6504.cljs$core$ISeq$)){
return true;
} else {
if((!G__6504.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6504);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6504);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var G__6506 = s;
if(G__6506){
var bit__4414__auto__ = (G__6506.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4414__auto__) || (G__6506.cljs$core$ISeqable$)){
return true;
} else {
if((!G__6506.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__6506);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__6506);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__3740__auto__ = cljs.core.fn_QMARK_(f);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var G__6510 = f;
if(G__6510){
var bit__4414__auto__ = (G__6510.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4414__auto__) || (G__6510.cljs$core$IFn$)){
return true;
} else {
if((!G__6510.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__6510);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__6510);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__6523 = n;
return isNaN(G__6523);
})())) && (!((n === Infinity))) && (((function (){var G__6524 = n;
return parseFloat(G__6524);
})() === (function (){var G__6525 = n;
var G__6526 = (10);
return parseInt(G__6525,G__6526);
})()));
});
/**
 * Returns true if key is present in the given collection, otherwise
 * returns false.  Note that for numerically indexed collections like
 * vectors and arrays, this tests if the numeric key is within the
 * range of indexes. 'contains?' operates constant or logarithmic time;
 * it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 * @param {...*} var_args
 */
cljs.core.distinct_QMARK_ = (function() {
var cljs$core$distinct_QMARK_ = null;
var cljs$core$distinct_QMARK___1 = (function (x){
return true;
});
var cljs$core$distinct_QMARK___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var cljs$core$distinct_QMARK___3 = (function() { 
var G__6527__delegate = function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__6528 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__6529 = etc;
s = G__6528;
xs = G__6529;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
};
var G__6527 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6530__i = 0, G__6530__a = new Array(arguments.length -  2);
while (G__6530__i < G__6530__a.length) {G__6530__a[G__6530__i] = arguments[G__6530__i + 2]; ++G__6530__i;}
  more = new cljs.core.IndexedSeq(G__6530__a,0);
} 
return G__6527__delegate.call(this,x,y,more);};
G__6527.cljs$lang$maxFixedArity = 2;
G__6527.cljs$lang$applyTo = (function (arglist__6531){
var x = cljs.core.first(arglist__6531);
arglist__6531 = cljs.core.next(arglist__6531);
var y = cljs.core.first(arglist__6531);
var more = cljs.core.rest(arglist__6531);
return G__6527__delegate(x,y,more);
});
G__6527.cljs$core$IFn$_invoke$arity$variadic = G__6527__delegate;
return G__6527;
})()
;
cljs$core$distinct_QMARK_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$distinct_QMARK___1.call(this,x);
case 2:
return cljs$core$distinct_QMARK___2.call(this,x,y);
default:
var G__6532 = null;
if (arguments.length > 2) {
var G__6533__i = 0, G__6533__a = new Array(arguments.length -  2);
while (G__6533__i < G__6533__a.length) {G__6533__a[G__6533__i] = arguments[G__6533__i + 2]; ++G__6533__i;}
G__6532 = new cljs.core.IndexedSeq(G__6533__a,0);
}
return cljs$core$distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs$core$distinct_QMARK_.cljs$lang$applyTo = cljs$core$distinct_QMARK___3.cljs$lang$applyTo;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = cljs$core$distinct_QMARK___1;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = cljs$core$distinct_QMARK___2;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$distinct_QMARK_;
})()
;
/**
 * Comparator. Returns a negative number, zero, or a positive number
 * when x is logically 'less than', 'equal to', or 'greater than'
 * y. Uses IComparable if available and google.array.defaultCompare for objects
 * of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__6537 = x;
if(G__6537){
var bit__4407__auto__ = (G__6537.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4407__auto__) || (G__6537.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__6538 = x;
var G__6539 = y;
return goog.array.defaultCompare(G__6538,G__6539);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function() {
var cljs$core$compare_indexed = null;
var cljs$core$compare_indexed__2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
return cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
});
var cljs$core$compare_indexed__4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__6544 = xs;
var G__6545 = ys;
var G__6546 = len;
var G__6547 = (n + (1));
xs = G__6544;
ys = G__6545;
len = G__6546;
n = G__6547;
continue;
} else {
return d;
}
break;
}
});
cljs$core$compare_indexed = function(xs,ys,len,n){
switch(arguments.length){
case 2:
return cljs$core$compare_indexed__2.call(this,xs,ys);
case 4:
return cljs$core$compare_indexed__4.call(this,xs,ys,len,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$compare_indexed__2;
cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$4 = cljs$core$compare_indexed__4;
return cljs$core$compare_indexed;
})()
;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__6552 = x;
var G__6553 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6552,G__6553) : f.call(null,G__6552,G__6553));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__6554 = y;
var G__6555 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6554,G__6555) : f.call(null,G__6554,G__6555));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function() {
var cljs$core$sort = null;
var cljs$core$sort__1 = (function (coll){
return cljs$core$sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});
var cljs$core$sort__2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__6561 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__6561) : cljs.core.to_array.call(null,G__6561));
})();
var G__6562_6564 = a;
var G__6563_6565 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__6562_6564,G__6563_6565);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});
cljs$core$sort = function(comp,coll){
switch(arguments.length){
case 1:
return cljs$core$sort__1.call(this,comp);
case 2:
return cljs$core$sort__2.call(this,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sort.cljs$core$IFn$_invoke$arity$1 = cljs$core$sort__1;
cljs$core$sort.cljs$core$IFn$_invoke$arity$2 = cljs$core$sort__2;
return cljs$core$sort;
})()
;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function() {
var cljs$core$sort_by = null;
var cljs$core$sort_by__2 = (function (keyfn,coll){
return cljs$core$sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});
var cljs$core$sort_by__3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__6571 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__6571) : keyfn.call(null,G__6571));
})(),(function (){var G__6572 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__6572) : keyfn.call(null,G__6572));
})());
}),coll);
});
cljs$core$sort_by = function(keyfn,comp,coll){
switch(arguments.length){
case 2:
return cljs$core$sort_by__2.call(this,keyfn,comp);
case 3:
return cljs$core$sort_by__3.call(this,keyfn,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sort_by.cljs$core$IFn$_invoke$arity$2 = cljs$core$sort_by__2;
cljs$core$sort_by.cljs$core$IFn$_invoke$arity$3 = cljs$core$sort_by__3;
return cljs$core$sort_by;
})()
;
cljs.core.seq_reduce = (function() {
var cljs$core$seq_reduce = null;
var cljs$core$seq_reduce__2 = (function (f,coll){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
var G__6578 = f;
var G__6579 = cljs.core.first(s);
var G__6580 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__6578,G__6579,G__6580) : cljs.core.reduce.call(null,G__6578,G__6579,G__6580));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});
var cljs$core$seq_reduce__3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__6581 = val__$1;
var G__6582 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6581,G__6582) : f.call(null,G__6581,G__6582));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6583 = nval;
var G__6584 = cljs.core.next(coll__$1);
val__$1 = G__6583;
coll__$1 = G__6584;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$seq_reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return cljs$core$seq_reduce__2.call(this,f,val);
case 3:
return cljs$core$seq_reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$seq_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$seq_reduce__2;
cljs$core$seq_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$seq_reduce__3;
return cljs$core$seq_reduce;
})()
;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (function (){var G__6588 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__6588) : cljs.core.to_array.call(null,G__6588));
})();
var G__6589_6591 = a;
goog.array.shuffle(G__6589_6591);

var G__6590 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__6590) : cljs.core.vec.call(null,G__6590));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc. If coll contains no
 * items, f must accept no arguments as well, and reduce returns the
 * result of calling f with no arguments.  If coll has only 1 item, it
 * is returned and f is not called.  If val is supplied, returns the
 * result of applying f to val and the first item in coll, then
 * applying f to that result and the 2nd item, etc. If coll contains no
 * items, returns val and f is not called.
 */
cljs.core.reduce = (function() {
var cljs$core$reduce = null;
var cljs$core$reduce__2 = (function (f,coll){
if((function (){var G__6594 = coll;
if(G__6594){
var bit__4407__auto__ = (G__6594.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4407__auto__) || (G__6594.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});
var cljs$core$reduce__3 = (function (f,val,coll){
if((function (){var G__6595 = coll;
if(G__6595){
var bit__4407__auto__ = (G__6595.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4407__auto__) || (G__6595.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});
cljs$core$reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return cljs$core$reduce__2.call(this,f,val);
case 3:
return cljs$core$reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$reduce__2;
cljs$core$reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$reduce__3;
return cljs$core$reduce;
})()
;
/**
 * Reduces an associative collection. f should be a function of 3
 * arguments. Returns the result of applying f to init, the first key
 * and the first value in coll, then applying f to that result and the
 * 2nd key and value, etc. If coll contains no entries, returns init
 * and f is not called. Note that reduce-kv is supported on vectors,
 * where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 * transduce by adding an arity-1 signature that calls cf (default -
 * identity) on the result argument.
 */
cljs.core.completing = (function() {
var cljs$core$completing = null;
var cljs$core$completing__1 = (function (f){
return cljs$core$completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});
var cljs$core$completing__2 = (function (f,cf){
return (function() {
var G__6604 = null;
var G__6604__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__6604__1 = (function (x){
var G__6601 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__6601) : cf.call(null,G__6601));
});
var G__6604__2 = (function (x,y){
var G__6602 = x;
var G__6603 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6602,G__6603) : f.call(null,G__6602,G__6603));
});
G__6604 = function(x,y){
switch(arguments.length){
case 0:
return G__6604__0.call(this);
case 1:
return G__6604__1.call(this,x);
case 2:
return G__6604__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6604.cljs$core$IFn$_invoke$arity$0 = G__6604__0;
G__6604.cljs$core$IFn$_invoke$arity$1 = G__6604__1;
G__6604.cljs$core$IFn$_invoke$arity$2 = G__6604__2;
return G__6604;
})()
});
cljs$core$completing = function(f,cf){
switch(arguments.length){
case 1:
return cljs$core$completing__1.call(this,f);
case 2:
return cljs$core$completing__2.call(this,f,cf);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$completing.cljs$core$IFn$_invoke$arity$1 = cljs$core$completing__1;
cljs$core$completing.cljs$core$IFn$_invoke$arity$2 = cljs$core$completing__2;
return cljs$core$completing;
})()
;
/**
 * reduce with a transformation of f (xf). If init is not
 * supplied, (f) will be called to produce it. f should be a reducing
 * step function that accepts both 1 and 2 arguments, if it accepts
 * only 2 you can add the arity-1 with 'completing'. Returns the result
 * of applying (the transformed) xf to init and the first item in coll,
 * then applying xf to that result and the 2nd item, etc. If coll
 * contains no items, returns init and f is not called. Note that
 * certain transforms may inject or skip items.
 */
cljs.core.transduce = (function() {
var cljs$core$transduce = null;
var cljs$core$transduce__3 = (function (xform,f,coll){
return cljs$core$transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});
var cljs$core$transduce__4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__6611 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__6611) : xform.call(null,G__6611));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__6612 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__6612) : f__$1.call(null,G__6612));
});
cljs$core$transduce = function(xform,f,init,coll){
switch(arguments.length){
case 3:
return cljs$core$transduce__3.call(this,xform,f,init);
case 4:
return cljs$core$transduce__4.call(this,xform,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$transduce__3;
cljs$core$transduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$transduce__4;
return cljs$core$transduce;
})()
;
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core._PLUS_ = (function() {
var cljs$core$_PLUS_ = null;
var cljs$core$_PLUS___0 = (function (){
return (0);
});
var cljs$core$_PLUS___1 = (function (x){
return x;
});
var cljs$core$_PLUS___2 = (function (x,y){
return (x + y);
});
var cljs$core$_PLUS___3 = (function() { 
var G__6613__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_PLUS_,(x + y),more);
};
var G__6613 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6614__i = 0, G__6614__a = new Array(arguments.length -  2);
while (G__6614__i < G__6614__a.length) {G__6614__a[G__6614__i] = arguments[G__6614__i + 2]; ++G__6614__i;}
  more = new cljs.core.IndexedSeq(G__6614__a,0);
} 
return G__6613__delegate.call(this,x,y,more);};
G__6613.cljs$lang$maxFixedArity = 2;
G__6613.cljs$lang$applyTo = (function (arglist__6615){
var x = cljs.core.first(arglist__6615);
arglist__6615 = cljs.core.next(arglist__6615);
var y = cljs.core.first(arglist__6615);
var more = cljs.core.rest(arglist__6615);
return G__6613__delegate(x,y,more);
});
G__6613.cljs$core$IFn$_invoke$arity$variadic = G__6613__delegate;
return G__6613;
})()
;
cljs$core$_PLUS_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$_PLUS___0.call(this);
case 1:
return cljs$core$_PLUS___1.call(this,x);
case 2:
return cljs$core$_PLUS___2.call(this,x,y);
default:
var G__6616 = null;
if (arguments.length > 2) {
var G__6617__i = 0, G__6617__a = new Array(arguments.length -  2);
while (G__6617__i < G__6617__a.length) {G__6617__a[G__6617__i] = arguments[G__6617__i + 2]; ++G__6617__i;}
G__6616 = new cljs.core.IndexedSeq(G__6617__a,0);
}
return cljs$core$_PLUS___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_PLUS_.cljs$lang$maxFixedArity = 2;
cljs$core$_PLUS_.cljs$lang$applyTo = cljs$core$_PLUS___3.cljs$lang$applyTo;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$0 = cljs$core$_PLUS___0;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_PLUS___1;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_PLUS___2;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_PLUS___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_PLUS_;
})()
;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core._ = (function() {
var cljs$core$_ = null;
var cljs$core$___1 = (function (x){
return (- x);
});
var cljs$core$___2 = (function (x,y){
return (x - y);
});
var cljs$core$___3 = (function() { 
var G__6618__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_,(x - y),more);
};
var G__6618 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6619__i = 0, G__6619__a = new Array(arguments.length -  2);
while (G__6619__i < G__6619__a.length) {G__6619__a[G__6619__i] = arguments[G__6619__i + 2]; ++G__6619__i;}
  more = new cljs.core.IndexedSeq(G__6619__a,0);
} 
return G__6618__delegate.call(this,x,y,more);};
G__6618.cljs$lang$maxFixedArity = 2;
G__6618.cljs$lang$applyTo = (function (arglist__6620){
var x = cljs.core.first(arglist__6620);
arglist__6620 = cljs.core.next(arglist__6620);
var y = cljs.core.first(arglist__6620);
var more = cljs.core.rest(arglist__6620);
return G__6618__delegate(x,y,more);
});
G__6618.cljs$core$IFn$_invoke$arity$variadic = G__6618__delegate;
return G__6618;
})()
;
cljs$core$_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$___1.call(this,x);
case 2:
return cljs$core$___2.call(this,x,y);
default:
var G__6621 = null;
if (arguments.length > 2) {
var G__6622__i = 0, G__6622__a = new Array(arguments.length -  2);
while (G__6622__i < G__6622__a.length) {G__6622__a[G__6622__i] = arguments[G__6622__i + 2]; ++G__6622__i;}
G__6621 = new cljs.core.IndexedSeq(G__6622__a,0);
}
return cljs$core$___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_.cljs$lang$maxFixedArity = 2;
cljs$core$_.cljs$lang$applyTo = cljs$core$___3.cljs$lang$applyTo;
cljs$core$_.cljs$core$IFn$_invoke$arity$1 = cljs$core$___1;
cljs$core$_.cljs$core$IFn$_invoke$arity$2 = cljs$core$___2;
cljs$core$_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_;
})()
;
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core._STAR_ = (function() {
var cljs$core$_STAR_ = null;
var cljs$core$_STAR___0 = (function (){
return (1);
});
var cljs$core$_STAR___1 = (function (x){
return x;
});
var cljs$core$_STAR___2 = (function (x,y){
return (x * y);
});
var cljs$core$_STAR___3 = (function() { 
var G__6623__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_STAR_,(x * y),more);
};
var G__6623 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6624__i = 0, G__6624__a = new Array(arguments.length -  2);
while (G__6624__i < G__6624__a.length) {G__6624__a[G__6624__i] = arguments[G__6624__i + 2]; ++G__6624__i;}
  more = new cljs.core.IndexedSeq(G__6624__a,0);
} 
return G__6623__delegate.call(this,x,y,more);};
G__6623.cljs$lang$maxFixedArity = 2;
G__6623.cljs$lang$applyTo = (function (arglist__6625){
var x = cljs.core.first(arglist__6625);
arglist__6625 = cljs.core.next(arglist__6625);
var y = cljs.core.first(arglist__6625);
var more = cljs.core.rest(arglist__6625);
return G__6623__delegate(x,y,more);
});
G__6623.cljs$core$IFn$_invoke$arity$variadic = G__6623__delegate;
return G__6623;
})()
;
cljs$core$_STAR_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$_STAR___0.call(this);
case 1:
return cljs$core$_STAR___1.call(this,x);
case 2:
return cljs$core$_STAR___2.call(this,x,y);
default:
var G__6626 = null;
if (arguments.length > 2) {
var G__6627__i = 0, G__6627__a = new Array(arguments.length -  2);
while (G__6627__i < G__6627__a.length) {G__6627__a[G__6627__i] = arguments[G__6627__i + 2]; ++G__6627__i;}
G__6626 = new cljs.core.IndexedSeq(G__6627__a,0);
}
return cljs$core$_STAR___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_STAR_.cljs$lang$maxFixedArity = 2;
cljs$core$_STAR_.cljs$lang$applyTo = cljs$core$_STAR___3.cljs$lang$applyTo;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$0 = cljs$core$_STAR___0;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_STAR___1;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_STAR___2;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_STAR___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_STAR_;
})()
;
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 * @param {...*} var_args
 */
cljs.core._SLASH_ = (function() {
var cljs$core$_SLASH_ = null;
var cljs$core$_SLASH___1 = (function (x){
return cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2((1),x);
});
var cljs$core$_SLASH___2 = (function (x,y){
return (x / y);
});
var cljs$core$_SLASH___3 = (function() { 
var G__6632__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_SLASH_,cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__6632 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6633__i = 0, G__6633__a = new Array(arguments.length -  2);
while (G__6633__i < G__6633__a.length) {G__6633__a[G__6633__i] = arguments[G__6633__i + 2]; ++G__6633__i;}
  more = new cljs.core.IndexedSeq(G__6633__a,0);
} 
return G__6632__delegate.call(this,x,y,more);};
G__6632.cljs$lang$maxFixedArity = 2;
G__6632.cljs$lang$applyTo = (function (arglist__6634){
var x = cljs.core.first(arglist__6634);
arglist__6634 = cljs.core.next(arglist__6634);
var y = cljs.core.first(arglist__6634);
var more = cljs.core.rest(arglist__6634);
return G__6632__delegate(x,y,more);
});
G__6632.cljs$core$IFn$_invoke$arity$variadic = G__6632__delegate;
return G__6632;
})()
;
cljs$core$_SLASH_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_SLASH___1.call(this,x);
case 2:
return cljs$core$_SLASH___2.call(this,x,y);
default:
var G__6635 = null;
if (arguments.length > 2) {
var G__6636__i = 0, G__6636__a = new Array(arguments.length -  2);
while (G__6636__i < G__6636__a.length) {G__6636__a[G__6636__i] = arguments[G__6636__i + 2]; ++G__6636__i;}
G__6635 = new cljs.core.IndexedSeq(G__6636__a,0);
}
return cljs$core$_SLASH___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_SLASH_.cljs$lang$maxFixedArity = 2;
cljs$core$_SLASH_.cljs$lang$applyTo = cljs$core$_SLASH___3.cljs$lang$applyTo;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_SLASH___1;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_SLASH___2;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_SLASH___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_SLASH_;
})()
;
/**
 * Returns non-nil if nums are in monotonically increasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._LT_ = (function() {
var cljs$core$_LT_ = null;
var cljs$core$_LT___1 = (function (x){
return true;
});
var cljs$core$_LT___2 = (function (x,y){
return (x < y);
});
var cljs$core$_LT___3 = (function() { 
var G__6637__delegate = function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__6638 = y;
var G__6639 = cljs.core.first(more);
var G__6640 = cljs.core.next(more);
x = G__6638;
y = G__6639;
more = G__6640;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6637 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6641__i = 0, G__6641__a = new Array(arguments.length -  2);
while (G__6641__i < G__6641__a.length) {G__6641__a[G__6641__i] = arguments[G__6641__i + 2]; ++G__6641__i;}
  more = new cljs.core.IndexedSeq(G__6641__a,0);
} 
return G__6637__delegate.call(this,x,y,more);};
G__6637.cljs$lang$maxFixedArity = 2;
G__6637.cljs$lang$applyTo = (function (arglist__6642){
var x = cljs.core.first(arglist__6642);
arglist__6642 = cljs.core.next(arglist__6642);
var y = cljs.core.first(arglist__6642);
var more = cljs.core.rest(arglist__6642);
return G__6637__delegate(x,y,more);
});
G__6637.cljs$core$IFn$_invoke$arity$variadic = G__6637__delegate;
return G__6637;
})()
;
cljs$core$_LT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_LT___1.call(this,x);
case 2:
return cljs$core$_LT___2.call(this,x,y);
default:
var G__6643 = null;
if (arguments.length > 2) {
var G__6644__i = 0, G__6644__a = new Array(arguments.length -  2);
while (G__6644__i < G__6644__a.length) {G__6644__a[G__6644__i] = arguments[G__6644__i + 2]; ++G__6644__i;}
G__6643 = new cljs.core.IndexedSeq(G__6644__a,0);
}
return cljs$core$_LT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_LT_.cljs$lang$maxFixedArity = 2;
cljs$core$_LT_.cljs$lang$applyTo = cljs$core$_LT___3.cljs$lang$applyTo;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_LT___1;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_LT___2;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_LT___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_LT_;
})()
;
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._LT__EQ_ = (function() {
var cljs$core$_LT__EQ_ = null;
var cljs$core$_LT__EQ___1 = (function (x){
return true;
});
var cljs$core$_LT__EQ___2 = (function (x,y){
return (x <= y);
});
var cljs$core$_LT__EQ___3 = (function() { 
var G__6645__delegate = function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__6646 = y;
var G__6647 = cljs.core.first(more);
var G__6648 = cljs.core.next(more);
x = G__6646;
y = G__6647;
more = G__6648;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6645 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6649__i = 0, G__6649__a = new Array(arguments.length -  2);
while (G__6649__i < G__6649__a.length) {G__6649__a[G__6649__i] = arguments[G__6649__i + 2]; ++G__6649__i;}
  more = new cljs.core.IndexedSeq(G__6649__a,0);
} 
return G__6645__delegate.call(this,x,y,more);};
G__6645.cljs$lang$maxFixedArity = 2;
G__6645.cljs$lang$applyTo = (function (arglist__6650){
var x = cljs.core.first(arglist__6650);
arglist__6650 = cljs.core.next(arglist__6650);
var y = cljs.core.first(arglist__6650);
var more = cljs.core.rest(arglist__6650);
return G__6645__delegate(x,y,more);
});
G__6645.cljs$core$IFn$_invoke$arity$variadic = G__6645__delegate;
return G__6645;
})()
;
cljs$core$_LT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_LT__EQ___1.call(this,x);
case 2:
return cljs$core$_LT__EQ___2.call(this,x,y);
default:
var G__6651 = null;
if (arguments.length > 2) {
var G__6652__i = 0, G__6652__a = new Array(arguments.length -  2);
while (G__6652__i < G__6652__a.length) {G__6652__a[G__6652__i] = arguments[G__6652__i + 2]; ++G__6652__i;}
G__6651 = new cljs.core.IndexedSeq(G__6652__a,0);
}
return cljs$core$_LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_LT__EQ_.cljs$lang$applyTo = cljs$core$_LT__EQ___3.cljs$lang$applyTo;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_LT__EQ___1;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_LT__EQ___2;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_LT__EQ_;
})()
;
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._GT_ = (function() {
var cljs$core$_GT_ = null;
var cljs$core$_GT___1 = (function (x){
return true;
});
var cljs$core$_GT___2 = (function (x,y){
return (x > y);
});
var cljs$core$_GT___3 = (function() { 
var G__6653__delegate = function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__6654 = y;
var G__6655 = cljs.core.first(more);
var G__6656 = cljs.core.next(more);
x = G__6654;
y = G__6655;
more = G__6656;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6653 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6657__i = 0, G__6657__a = new Array(arguments.length -  2);
while (G__6657__i < G__6657__a.length) {G__6657__a[G__6657__i] = arguments[G__6657__i + 2]; ++G__6657__i;}
  more = new cljs.core.IndexedSeq(G__6657__a,0);
} 
return G__6653__delegate.call(this,x,y,more);};
G__6653.cljs$lang$maxFixedArity = 2;
G__6653.cljs$lang$applyTo = (function (arglist__6658){
var x = cljs.core.first(arglist__6658);
arglist__6658 = cljs.core.next(arglist__6658);
var y = cljs.core.first(arglist__6658);
var more = cljs.core.rest(arglist__6658);
return G__6653__delegate(x,y,more);
});
G__6653.cljs$core$IFn$_invoke$arity$variadic = G__6653__delegate;
return G__6653;
})()
;
cljs$core$_GT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_GT___1.call(this,x);
case 2:
return cljs$core$_GT___2.call(this,x,y);
default:
var G__6659 = null;
if (arguments.length > 2) {
var G__6660__i = 0, G__6660__a = new Array(arguments.length -  2);
while (G__6660__i < G__6660__a.length) {G__6660__a[G__6660__i] = arguments[G__6660__i + 2]; ++G__6660__i;}
G__6659 = new cljs.core.IndexedSeq(G__6660__a,0);
}
return cljs$core$_GT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_GT_.cljs$lang$maxFixedArity = 2;
cljs$core$_GT_.cljs$lang$applyTo = cljs$core$_GT___3.cljs$lang$applyTo;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_GT___1;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_GT___2;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_GT___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_GT_;
})()
;
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._GT__EQ_ = (function() {
var cljs$core$_GT__EQ_ = null;
var cljs$core$_GT__EQ___1 = (function (x){
return true;
});
var cljs$core$_GT__EQ___2 = (function (x,y){
return (x >= y);
});
var cljs$core$_GT__EQ___3 = (function() { 
var G__6661__delegate = function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__6662 = y;
var G__6663 = cljs.core.first(more);
var G__6664 = cljs.core.next(more);
x = G__6662;
y = G__6663;
more = G__6664;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6661 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6665__i = 0, G__6665__a = new Array(arguments.length -  2);
while (G__6665__i < G__6665__a.length) {G__6665__a[G__6665__i] = arguments[G__6665__i + 2]; ++G__6665__i;}
  more = new cljs.core.IndexedSeq(G__6665__a,0);
} 
return G__6661__delegate.call(this,x,y,more);};
G__6661.cljs$lang$maxFixedArity = 2;
G__6661.cljs$lang$applyTo = (function (arglist__6666){
var x = cljs.core.first(arglist__6666);
arglist__6666 = cljs.core.next(arglist__6666);
var y = cljs.core.first(arglist__6666);
var more = cljs.core.rest(arglist__6666);
return G__6661__delegate(x,y,more);
});
G__6661.cljs$core$IFn$_invoke$arity$variadic = G__6661__delegate;
return G__6661;
})()
;
cljs$core$_GT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_GT__EQ___1.call(this,x);
case 2:
return cljs$core$_GT__EQ___2.call(this,x,y);
default:
var G__6667 = null;
if (arguments.length > 2) {
var G__6668__i = 0, G__6668__a = new Array(arguments.length -  2);
while (G__6668__i < G__6668__a.length) {G__6668__a[G__6668__i] = arguments[G__6668__i + 2]; ++G__6668__i;}
G__6667 = new cljs.core.IndexedSeq(G__6668__a,0);
}
return cljs$core$_GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_GT__EQ_.cljs$lang$applyTo = cljs$core$_GT__EQ___3.cljs$lang$applyTo;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_GT__EQ___1;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_GT__EQ___2;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_GT__EQ_;
})()
;
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 * @param {...*} var_args
 */
cljs.core.max = (function() {
var cljs$core$max = null;
var cljs$core$max__1 = (function (x){
return x;
});
var cljs$core$max__2 = (function (x,y){
var x__4052__auto__ = x;
var y__4053__auto__ = y;
return ((x__4052__auto__ > y__4053__auto__) ? x__4052__auto__ : y__4053__auto__);
});
var cljs$core$max__3 = (function() { 
var G__6669__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$max,(function (){var x__4052__auto__ = x;
var y__4053__auto__ = y;
return ((x__4052__auto__ > y__4053__auto__) ? x__4052__auto__ : y__4053__auto__);
})(),more);
};
var G__6669 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6670__i = 0, G__6670__a = new Array(arguments.length -  2);
while (G__6670__i < G__6670__a.length) {G__6670__a[G__6670__i] = arguments[G__6670__i + 2]; ++G__6670__i;}
  more = new cljs.core.IndexedSeq(G__6670__a,0);
} 
return G__6669__delegate.call(this,x,y,more);};
G__6669.cljs$lang$maxFixedArity = 2;
G__6669.cljs$lang$applyTo = (function (arglist__6671){
var x = cljs.core.first(arglist__6671);
arglist__6671 = cljs.core.next(arglist__6671);
var y = cljs.core.first(arglist__6671);
var more = cljs.core.rest(arglist__6671);
return G__6669__delegate(x,y,more);
});
G__6669.cljs$core$IFn$_invoke$arity$variadic = G__6669__delegate;
return G__6669;
})()
;
cljs$core$max = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$max__1.call(this,x);
case 2:
return cljs$core$max__2.call(this,x,y);
default:
var G__6672 = null;
if (arguments.length > 2) {
var G__6673__i = 0, G__6673__a = new Array(arguments.length -  2);
while (G__6673__i < G__6673__a.length) {G__6673__a[G__6673__i] = arguments[G__6673__i + 2]; ++G__6673__i;}
G__6672 = new cljs.core.IndexedSeq(G__6673__a,0);
}
return cljs$core$max__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$max.cljs$lang$maxFixedArity = 2;
cljs$core$max.cljs$lang$applyTo = cljs$core$max__3.cljs$lang$applyTo;
cljs$core$max.cljs$core$IFn$_invoke$arity$1 = cljs$core$max__1;
cljs$core$max.cljs$core$IFn$_invoke$arity$2 = cljs$core$max__2;
cljs$core$max.cljs$core$IFn$_invoke$arity$variadic = cljs$core$max__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$max;
})()
;
/**
 * Returns the least of the nums.
 * @param {...*} var_args
 */
cljs.core.min = (function() {
var cljs$core$min = null;
var cljs$core$min__1 = (function (x){
return x;
});
var cljs$core$min__2 = (function (x,y){
var x__4059__auto__ = x;
var y__4060__auto__ = y;
return ((x__4059__auto__ < y__4060__auto__) ? x__4059__auto__ : y__4060__auto__);
});
var cljs$core$min__3 = (function() { 
var G__6674__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$min,(function (){var x__4059__auto__ = x;
var y__4060__auto__ = y;
return ((x__4059__auto__ < y__4060__auto__) ? x__4059__auto__ : y__4060__auto__);
})(),more);
};
var G__6674 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6675__i = 0, G__6675__a = new Array(arguments.length -  2);
while (G__6675__i < G__6675__a.length) {G__6675__a[G__6675__i] = arguments[G__6675__i + 2]; ++G__6675__i;}
  more = new cljs.core.IndexedSeq(G__6675__a,0);
} 
return G__6674__delegate.call(this,x,y,more);};
G__6674.cljs$lang$maxFixedArity = 2;
G__6674.cljs$lang$applyTo = (function (arglist__6676){
var x = cljs.core.first(arglist__6676);
arglist__6676 = cljs.core.next(arglist__6676);
var y = cljs.core.first(arglist__6676);
var more = cljs.core.rest(arglist__6676);
return G__6674__delegate(x,y,more);
});
G__6674.cljs$core$IFn$_invoke$arity$variadic = G__6674__delegate;
return G__6674;
})()
;
cljs$core$min = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$min__1.call(this,x);
case 2:
return cljs$core$min__2.call(this,x,y);
default:
var G__6677 = null;
if (arguments.length > 2) {
var G__6678__i = 0, G__6678__a = new Array(arguments.length -  2);
while (G__6678__i < G__6678__a.length) {G__6678__a[G__6678__i] = arguments[G__6678__i + 2]; ++G__6678__i;}
G__6677 = new cljs.core.IndexedSeq(G__6678__a,0);
}
return cljs$core$min__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$min.cljs$lang$maxFixedArity = 2;
cljs$core$min.cljs$lang$applyTo = cljs$core$min__3.cljs$lang$applyTo;
cljs$core$min.cljs$core$IFn$_invoke$arity$1 = cljs$core$min__1;
cljs$core$min.cljs$core$IFn$_invoke$arity$2 = cljs$core$min__2;
cljs$core$min.cljs$core$IFn$_invoke$arity$variadic = cljs$core$min__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$min;
})()
;
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core.unchecked_add = (function() {
var cljs$core$unchecked_add = null;
var cljs$core$unchecked_add__0 = (function (){
return (0);
});
var cljs$core$unchecked_add__1 = (function (x){
return x;
});
var cljs$core$unchecked_add__2 = (function (x,y){
return (x + y);
});
var cljs$core$unchecked_add__3 = (function() { 
var G__6679__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_add,(x + y),more);
};
var G__6679 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6680__i = 0, G__6680__a = new Array(arguments.length -  2);
while (G__6680__i < G__6680__a.length) {G__6680__a[G__6680__i] = arguments[G__6680__i + 2]; ++G__6680__i;}
  more = new cljs.core.IndexedSeq(G__6680__a,0);
} 
return G__6679__delegate.call(this,x,y,more);};
G__6679.cljs$lang$maxFixedArity = 2;
G__6679.cljs$lang$applyTo = (function (arglist__6681){
var x = cljs.core.first(arglist__6681);
arglist__6681 = cljs.core.next(arglist__6681);
var y = cljs.core.first(arglist__6681);
var more = cljs.core.rest(arglist__6681);
return G__6679__delegate(x,y,more);
});
G__6679.cljs$core$IFn$_invoke$arity$variadic = G__6679__delegate;
return G__6679;
})()
;
cljs$core$unchecked_add = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_add__0.call(this);
case 1:
return cljs$core$unchecked_add__1.call(this,x);
case 2:
return cljs$core$unchecked_add__2.call(this,x,y);
default:
var G__6682 = null;
if (arguments.length > 2) {
var G__6683__i = 0, G__6683__a = new Array(arguments.length -  2);
while (G__6683__i < G__6683__a.length) {G__6683__a[G__6683__i] = arguments[G__6683__i + 2]; ++G__6683__i;}
G__6682 = new cljs.core.IndexedSeq(G__6683__a,0);
}
return cljs$core$unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_add.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_add.cljs$lang$applyTo = cljs$core$unchecked_add__3.cljs$lang$applyTo;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_add__0;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_add__1;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_add__2;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_add;
})()
;
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core.unchecked_add_int = (function() {
var cljs$core$unchecked_add_int = null;
var cljs$core$unchecked_add_int__0 = (function (){
return (0);
});
var cljs$core$unchecked_add_int__1 = (function (x){
return x;
});
var cljs$core$unchecked_add_int__2 = (function (x,y){
return (x + y);
});
var cljs$core$unchecked_add_int__3 = (function() { 
var G__6684__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_add_int,(x + y),more);
};
var G__6684 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6685__i = 0, G__6685__a = new Array(arguments.length -  2);
while (G__6685__i < G__6685__a.length) {G__6685__a[G__6685__i] = arguments[G__6685__i + 2]; ++G__6685__i;}
  more = new cljs.core.IndexedSeq(G__6685__a,0);
} 
return G__6684__delegate.call(this,x,y,more);};
G__6684.cljs$lang$maxFixedArity = 2;
G__6684.cljs$lang$applyTo = (function (arglist__6686){
var x = cljs.core.first(arglist__6686);
arglist__6686 = cljs.core.next(arglist__6686);
var y = cljs.core.first(arglist__6686);
var more = cljs.core.rest(arglist__6686);
return G__6684__delegate(x,y,more);
});
G__6684.cljs$core$IFn$_invoke$arity$variadic = G__6684__delegate;
return G__6684;
})()
;
cljs$core$unchecked_add_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_add_int__0.call(this);
case 1:
return cljs$core$unchecked_add_int__1.call(this,x);
case 2:
return cljs$core$unchecked_add_int__2.call(this,x,y);
default:
var G__6687 = null;
if (arguments.length > 2) {
var G__6688__i = 0, G__6688__a = new Array(arguments.length -  2);
while (G__6688__i < G__6688__a.length) {G__6688__a[G__6688__i] = arguments[G__6688__i + 2]; ++G__6688__i;}
G__6687 = new cljs.core.IndexedSeq(G__6688__a,0);
}
return cljs$core$unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_add_int.cljs$lang$applyTo = cljs$core$unchecked_add_int__3.cljs$lang$applyTo;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_add_int__0;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_add_int__1;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_add_int__2;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_add_int;
})()
;
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 * @param {...*} var_args
 */
cljs.core.unchecked_divide_int = (function() {
var cljs$core$unchecked_divide_int = null;
var cljs$core$unchecked_divide_int__1 = (function (x){
return cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((1),x);
});
var cljs$core$unchecked_divide_int__2 = (function (x,y){
return (x / y);
});
var cljs$core$unchecked_divide_int__3 = (function() { 
var G__6693__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_divide_int,cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__6693 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6694__i = 0, G__6694__a = new Array(arguments.length -  2);
while (G__6694__i < G__6694__a.length) {G__6694__a[G__6694__i] = arguments[G__6694__i + 2]; ++G__6694__i;}
  more = new cljs.core.IndexedSeq(G__6694__a,0);
} 
return G__6693__delegate.call(this,x,y,more);};
G__6693.cljs$lang$maxFixedArity = 2;
G__6693.cljs$lang$applyTo = (function (arglist__6695){
var x = cljs.core.first(arglist__6695);
arglist__6695 = cljs.core.next(arglist__6695);
var y = cljs.core.first(arglist__6695);
var more = cljs.core.rest(arglist__6695);
return G__6693__delegate(x,y,more);
});
G__6693.cljs$core$IFn$_invoke$arity$variadic = G__6693__delegate;
return G__6693;
})()
;
cljs$core$unchecked_divide_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_divide_int__1.call(this,x);
case 2:
return cljs$core$unchecked_divide_int__2.call(this,x,y);
default:
var G__6696 = null;
if (arguments.length > 2) {
var G__6697__i = 0, G__6697__a = new Array(arguments.length -  2);
while (G__6697__i < G__6697__a.length) {G__6697__a[G__6697__i] = arguments[G__6697__i + 2]; ++G__6697__i;}
G__6696 = new cljs.core.IndexedSeq(G__6697__a,0);
}
return cljs$core$unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_divide_int.cljs$lang$applyTo = cljs$core$unchecked_divide_int__3.cljs$lang$applyTo;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_divide_int__1;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_divide_int__2;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_divide_int;
})()
;
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core.unchecked_multiply = (function() {
var cljs$core$unchecked_multiply = null;
var cljs$core$unchecked_multiply__0 = (function (){
return (1);
});
var cljs$core$unchecked_multiply__1 = (function (x){
return x;
});
var cljs$core$unchecked_multiply__2 = (function (x,y){
return (x * y);
});
var cljs$core$unchecked_multiply__3 = (function() { 
var G__6698__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_multiply,(x * y),more);
};
var G__6698 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6699__i = 0, G__6699__a = new Array(arguments.length -  2);
while (G__6699__i < G__6699__a.length) {G__6699__a[G__6699__i] = arguments[G__6699__i + 2]; ++G__6699__i;}
  more = new cljs.core.IndexedSeq(G__6699__a,0);
} 
return G__6698__delegate.call(this,x,y,more);};
G__6698.cljs$lang$maxFixedArity = 2;
G__6698.cljs$lang$applyTo = (function (arglist__6700){
var x = cljs.core.first(arglist__6700);
arglist__6700 = cljs.core.next(arglist__6700);
var y = cljs.core.first(arglist__6700);
var more = cljs.core.rest(arglist__6700);
return G__6698__delegate(x,y,more);
});
G__6698.cljs$core$IFn$_invoke$arity$variadic = G__6698__delegate;
return G__6698;
})()
;
cljs$core$unchecked_multiply = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_multiply__0.call(this);
case 1:
return cljs$core$unchecked_multiply__1.call(this,x);
case 2:
return cljs$core$unchecked_multiply__2.call(this,x,y);
default:
var G__6701 = null;
if (arguments.length > 2) {
var G__6702__i = 0, G__6702__a = new Array(arguments.length -  2);
while (G__6702__i < G__6702__a.length) {G__6702__a[G__6702__i] = arguments[G__6702__i + 2]; ++G__6702__i;}
G__6701 = new cljs.core.IndexedSeq(G__6702__a,0);
}
return cljs$core$unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_multiply.cljs$lang$applyTo = cljs$core$unchecked_multiply__3.cljs$lang$applyTo;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_multiply__0;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_multiply__1;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_multiply__2;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_multiply;
})()
;
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core.unchecked_multiply_int = (function() {
var cljs$core$unchecked_multiply_int = null;
var cljs$core$unchecked_multiply_int__0 = (function (){
return (1);
});
var cljs$core$unchecked_multiply_int__1 = (function (x){
return x;
});
var cljs$core$unchecked_multiply_int__2 = (function (x,y){
return (x * y);
});
var cljs$core$unchecked_multiply_int__3 = (function() { 
var G__6703__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_multiply_int,(x * y),more);
};
var G__6703 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6704__i = 0, G__6704__a = new Array(arguments.length -  2);
while (G__6704__i < G__6704__a.length) {G__6704__a[G__6704__i] = arguments[G__6704__i + 2]; ++G__6704__i;}
  more = new cljs.core.IndexedSeq(G__6704__a,0);
} 
return G__6703__delegate.call(this,x,y,more);};
G__6703.cljs$lang$maxFixedArity = 2;
G__6703.cljs$lang$applyTo = (function (arglist__6705){
var x = cljs.core.first(arglist__6705);
arglist__6705 = cljs.core.next(arglist__6705);
var y = cljs.core.first(arglist__6705);
var more = cljs.core.rest(arglist__6705);
return G__6703__delegate(x,y,more);
});
G__6703.cljs$core$IFn$_invoke$arity$variadic = G__6703__delegate;
return G__6703;
})()
;
cljs$core$unchecked_multiply_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_multiply_int__0.call(this);
case 1:
return cljs$core$unchecked_multiply_int__1.call(this,x);
case 2:
return cljs$core$unchecked_multiply_int__2.call(this,x,y);
default:
var G__6706 = null;
if (arguments.length > 2) {
var G__6707__i = 0, G__6707__a = new Array(arguments.length -  2);
while (G__6707__i < G__6707__a.length) {G__6707__a[G__6707__i] = arguments[G__6707__i + 2]; ++G__6707__i;}
G__6706 = new cljs.core.IndexedSeq(G__6707__a,0);
}
return cljs$core$unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_multiply_int.cljs$lang$applyTo = cljs$core$unchecked_multiply_int__3.cljs$lang$applyTo;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_multiply_int__0;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_multiply_int__1;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_multiply_int__2;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_multiply_int;
})()
;
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
var G__6710 = x;
var G__6711 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__6710,G__6711) : cljs.core.mod.call(null,G__6710,G__6711));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core.unchecked_subtract = (function() {
var cljs$core$unchecked_subtract = null;
var cljs$core$unchecked_subtract__1 = (function (x){
return (- x);
});
var cljs$core$unchecked_subtract__2 = (function (x,y){
return (x - y);
});
var cljs$core$unchecked_subtract__3 = (function() { 
var G__6712__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_subtract,(x - y),more);
};
var G__6712 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6713__i = 0, G__6713__a = new Array(arguments.length -  2);
while (G__6713__i < G__6713__a.length) {G__6713__a[G__6713__i] = arguments[G__6713__i + 2]; ++G__6713__i;}
  more = new cljs.core.IndexedSeq(G__6713__a,0);
} 
return G__6712__delegate.call(this,x,y,more);};
G__6712.cljs$lang$maxFixedArity = 2;
G__6712.cljs$lang$applyTo = (function (arglist__6714){
var x = cljs.core.first(arglist__6714);
arglist__6714 = cljs.core.next(arglist__6714);
var y = cljs.core.first(arglist__6714);
var more = cljs.core.rest(arglist__6714);
return G__6712__delegate(x,y,more);
});
G__6712.cljs$core$IFn$_invoke$arity$variadic = G__6712__delegate;
return G__6712;
})()
;
cljs$core$unchecked_subtract = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_subtract__1.call(this,x);
case 2:
return cljs$core$unchecked_subtract__2.call(this,x,y);
default:
var G__6715 = null;
if (arguments.length > 2) {
var G__6716__i = 0, G__6716__a = new Array(arguments.length -  2);
while (G__6716__i < G__6716__a.length) {G__6716__a[G__6716__i] = arguments[G__6716__i + 2]; ++G__6716__i;}
G__6715 = new cljs.core.IndexedSeq(G__6716__a,0);
}
return cljs$core$unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_subtract.cljs$lang$applyTo = cljs$core$unchecked_subtract__3.cljs$lang$applyTo;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_subtract__1;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_subtract__2;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_subtract;
})()
;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core.unchecked_subtract_int = (function() {
var cljs$core$unchecked_subtract_int = null;
var cljs$core$unchecked_subtract_int__1 = (function (x){
return (- x);
});
var cljs$core$unchecked_subtract_int__2 = (function (x,y){
return (x - y);
});
var cljs$core$unchecked_subtract_int__3 = (function() { 
var G__6717__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_subtract_int,(x - y),more);
};
var G__6717 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6718__i = 0, G__6718__a = new Array(arguments.length -  2);
while (G__6718__i < G__6718__a.length) {G__6718__a[G__6718__i] = arguments[G__6718__i + 2]; ++G__6718__i;}
  more = new cljs.core.IndexedSeq(G__6718__a,0);
} 
return G__6717__delegate.call(this,x,y,more);};
G__6717.cljs$lang$maxFixedArity = 2;
G__6717.cljs$lang$applyTo = (function (arglist__6719){
var x = cljs.core.first(arglist__6719);
arglist__6719 = cljs.core.next(arglist__6719);
var y = cljs.core.first(arglist__6719);
var more = cljs.core.rest(arglist__6719);
return G__6717__delegate(x,y,more);
});
G__6717.cljs$core$IFn$_invoke$arity$variadic = G__6717__delegate;
return G__6717;
})()
;
cljs$core$unchecked_subtract_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_subtract_int__1.call(this,x);
case 2:
return cljs$core$unchecked_subtract_int__2.call(this,x,y);
default:
var G__6720 = null;
if (arguments.length > 2) {
var G__6721__i = 0, G__6721__a = new Array(arguments.length -  2);
while (G__6721__i < G__6721__a.length) {G__6721__a[G__6721__i] = arguments[G__6721__i + 2]; ++G__6721__i;}
G__6720 = new cljs.core.IndexedSeq(G__6721__a,0);
}
return cljs$core$unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_subtract_int.cljs$lang$applyTo = cljs$core$unchecked_subtract_int__3.cljs$lang$applyTo;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_subtract_int__1;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_subtract_int__2;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_subtract_int;
})()
;
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
var G__6724 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__6724) : Math.floor.call(null,G__6724));
} else {
var G__6725 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__6725) : Math.ceil.call(null,G__6725));
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 * @param {...*} var_args
 */
cljs.core.bit_xor = (function() {
var cljs$core$bit_xor = null;
var cljs$core$bit_xor__2 = (function (x,y){
return (x ^ y);
});
var cljs$core$bit_xor__3 = (function() { 
var G__6726__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_xor,(x ^ y),more);
};
var G__6726 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6727__i = 0, G__6727__a = new Array(arguments.length -  2);
while (G__6727__i < G__6727__a.length) {G__6727__a[G__6727__i] = arguments[G__6727__i + 2]; ++G__6727__i;}
  more = new cljs.core.IndexedSeq(G__6727__a,0);
} 
return G__6726__delegate.call(this,x,y,more);};
G__6726.cljs$lang$maxFixedArity = 2;
G__6726.cljs$lang$applyTo = (function (arglist__6728){
var x = cljs.core.first(arglist__6728);
arglist__6728 = cljs.core.next(arglist__6728);
var y = cljs.core.first(arglist__6728);
var more = cljs.core.rest(arglist__6728);
return G__6726__delegate(x,y,more);
});
G__6726.cljs$core$IFn$_invoke$arity$variadic = G__6726__delegate;
return G__6726;
})()
;
cljs$core$bit_xor = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_xor__2.call(this,x,y);
default:
var G__6729 = null;
if (arguments.length > 2) {
var G__6730__i = 0, G__6730__a = new Array(arguments.length -  2);
while (G__6730__i < G__6730__a.length) {G__6730__a[G__6730__i] = arguments[G__6730__i + 2]; ++G__6730__i;}
G__6729 = new cljs.core.IndexedSeq(G__6730__a,0);
}
return cljs$core$bit_xor__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_xor.cljs$lang$maxFixedArity = 2;
cljs$core$bit_xor.cljs$lang$applyTo = cljs$core$bit_xor__3.cljs$lang$applyTo;
cljs$core$bit_xor.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_xor__2;
cljs$core$bit_xor.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_xor__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_xor;
})()
;
/**
 * Bitwise and
 * @param {...*} var_args
 */
cljs.core.bit_and = (function() {
var cljs$core$bit_and = null;
var cljs$core$bit_and__2 = (function (x,y){
return (x & y);
});
var cljs$core$bit_and__3 = (function() { 
var G__6731__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_and,(x & y),more);
};
var G__6731 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6732__i = 0, G__6732__a = new Array(arguments.length -  2);
while (G__6732__i < G__6732__a.length) {G__6732__a[G__6732__i] = arguments[G__6732__i + 2]; ++G__6732__i;}
  more = new cljs.core.IndexedSeq(G__6732__a,0);
} 
return G__6731__delegate.call(this,x,y,more);};
G__6731.cljs$lang$maxFixedArity = 2;
G__6731.cljs$lang$applyTo = (function (arglist__6733){
var x = cljs.core.first(arglist__6733);
arglist__6733 = cljs.core.next(arglist__6733);
var y = cljs.core.first(arglist__6733);
var more = cljs.core.rest(arglist__6733);
return G__6731__delegate(x,y,more);
});
G__6731.cljs$core$IFn$_invoke$arity$variadic = G__6731__delegate;
return G__6731;
})()
;
cljs$core$bit_and = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_and__2.call(this,x,y);
default:
var G__6734 = null;
if (arguments.length > 2) {
var G__6735__i = 0, G__6735__a = new Array(arguments.length -  2);
while (G__6735__i < G__6735__a.length) {G__6735__a[G__6735__i] = arguments[G__6735__i + 2]; ++G__6735__i;}
G__6734 = new cljs.core.IndexedSeq(G__6735__a,0);
}
return cljs$core$bit_and__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_and.cljs$lang$maxFixedArity = 2;
cljs$core$bit_and.cljs$lang$applyTo = cljs$core$bit_and__3.cljs$lang$applyTo;
cljs$core$bit_and.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_and__2;
cljs$core$bit_and.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_and__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_and;
})()
;
/**
 * Bitwise or
 * @param {...*} var_args
 */
cljs.core.bit_or = (function() {
var cljs$core$bit_or = null;
var cljs$core$bit_or__2 = (function (x,y){
return (x | y);
});
var cljs$core$bit_or__3 = (function() { 
var G__6736__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_or,(x | y),more);
};
var G__6736 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6737__i = 0, G__6737__a = new Array(arguments.length -  2);
while (G__6737__i < G__6737__a.length) {G__6737__a[G__6737__i] = arguments[G__6737__i + 2]; ++G__6737__i;}
  more = new cljs.core.IndexedSeq(G__6737__a,0);
} 
return G__6736__delegate.call(this,x,y,more);};
G__6736.cljs$lang$maxFixedArity = 2;
G__6736.cljs$lang$applyTo = (function (arglist__6738){
var x = cljs.core.first(arglist__6738);
arglist__6738 = cljs.core.next(arglist__6738);
var y = cljs.core.first(arglist__6738);
var more = cljs.core.rest(arglist__6738);
return G__6736__delegate(x,y,more);
});
G__6736.cljs$core$IFn$_invoke$arity$variadic = G__6736__delegate;
return G__6736;
})()
;
cljs$core$bit_or = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_or__2.call(this,x,y);
default:
var G__6739 = null;
if (arguments.length > 2) {
var G__6740__i = 0, G__6740__a = new Array(arguments.length -  2);
while (G__6740__i < G__6740__a.length) {G__6740__a[G__6740__i] = arguments[G__6740__i + 2]; ++G__6740__i;}
G__6739 = new cljs.core.IndexedSeq(G__6740__a,0);
}
return cljs$core$bit_or__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6739);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_or.cljs$lang$maxFixedArity = 2;
cljs$core$bit_or.cljs$lang$applyTo = cljs$core$bit_or__3.cljs$lang$applyTo;
cljs$core$bit_or.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_or__2;
cljs$core$bit_or.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_or__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_or;
})()
;
/**
 * Bitwise and
 * @param {...*} var_args
 */
cljs.core.bit_and_not = (function() {
var cljs$core$bit_and_not = null;
var cljs$core$bit_and_not__2 = (function (x,y){
return (x & ~y);
});
var cljs$core$bit_and_not__3 = (function() { 
var G__6741__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_and_not,(x & ~y),more);
};
var G__6741 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6742__i = 0, G__6742__a = new Array(arguments.length -  2);
while (G__6742__i < G__6742__a.length) {G__6742__a[G__6742__i] = arguments[G__6742__i + 2]; ++G__6742__i;}
  more = new cljs.core.IndexedSeq(G__6742__a,0);
} 
return G__6741__delegate.call(this,x,y,more);};
G__6741.cljs$lang$maxFixedArity = 2;
G__6741.cljs$lang$applyTo = (function (arglist__6743){
var x = cljs.core.first(arglist__6743);
arglist__6743 = cljs.core.next(arglist__6743);
var y = cljs.core.first(arglist__6743);
var more = cljs.core.rest(arglist__6743);
return G__6741__delegate(x,y,more);
});
G__6741.cljs$core$IFn$_invoke$arity$variadic = G__6741__delegate;
return G__6741;
})()
;
cljs$core$bit_and_not = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_and_not__2.call(this,x,y);
default:
var G__6744 = null;
if (arguments.length > 2) {
var G__6745__i = 0, G__6745__a = new Array(arguments.length -  2);
while (G__6745__i < G__6745__a.length) {G__6745__a[G__6745__i] = arguments[G__6745__i + 2]; ++G__6745__i;}
G__6744 = new cljs.core.IndexedSeq(G__6745__a,0);
}
return cljs$core$bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_and_not.cljs$lang$maxFixedArity = 2;
cljs$core$bit_and_not.cljs$lang$applyTo = cljs$core$bit_and_not__3.cljs$lang$applyTo;
cljs$core$bit_and_not.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_and_not__2;
cljs$core$bit_and_not.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_and_not;
})()
;
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 * value, otherwise false. Behavior on non nums is
 * undefined.
 * @param {...*} var_args
 */
cljs.core._EQ__EQ_ = (function() {
var cljs$core$_EQ__EQ_ = null;
var cljs$core$_EQ__EQ___1 = (function (x){
return true;
});
var cljs$core$_EQ__EQ___2 = (function (x,y){
return cljs.core._equiv(x,y);
});
var cljs$core$_EQ__EQ___3 = (function() { 
var G__6750__delegate = function (x,y,more){
while(true){
if(cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__6751 = y;
var G__6752 = cljs.core.first(more);
var G__6753 = cljs.core.next(more);
x = G__6751;
y = G__6752;
more = G__6753;
continue;
} else {
return cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6750 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6754__i = 0, G__6754__a = new Array(arguments.length -  2);
while (G__6754__i < G__6754__a.length) {G__6754__a[G__6754__i] = arguments[G__6754__i + 2]; ++G__6754__i;}
  more = new cljs.core.IndexedSeq(G__6754__a,0);
} 
return G__6750__delegate.call(this,x,y,more);};
G__6750.cljs$lang$maxFixedArity = 2;
G__6750.cljs$lang$applyTo = (function (arglist__6755){
var x = cljs.core.first(arglist__6755);
arglist__6755 = cljs.core.next(arglist__6755);
var y = cljs.core.first(arglist__6755);
var more = cljs.core.rest(arglist__6755);
return G__6750__delegate(x,y,more);
});
G__6750.cljs$core$IFn$_invoke$arity$variadic = G__6750__delegate;
return G__6750;
})()
;
cljs$core$_EQ__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_EQ__EQ___1.call(this,x);
case 2:
return cljs$core$_EQ__EQ___2.call(this,x,y);
default:
var G__6756 = null;
if (arguments.length > 2) {
var G__6757__i = 0, G__6757__a = new Array(arguments.length -  2);
while (G__6757__i < G__6757__a.length) {G__6757__a[G__6757__i] = arguments[G__6757__i + 2]; ++G__6757__i;}
G__6756 = new cljs.core.IndexedSeq(G__6757__a,0);
}
return cljs$core$_EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_EQ__EQ_.cljs$lang$applyTo = cljs$core$_EQ__EQ___3.cljs$lang$applyTo;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_EQ__EQ___1;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_EQ__EQ___2;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_EQ__EQ_;
})()
;
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__6758 = (n__$1 - (1));
var G__6759 = cljs.core.next(xs);
n__$1 = G__6758;
xs = G__6759;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 * x.toString().  (str nil) returns the empty string. With more than
 * one arg, returns the concatenation of the str values of the args.
 * @param {...*} var_args
 */
cljs.core.str = (function() {
var cljs$core$str = null;
var cljs$core$str__0 = (function (){
return "";
});
var cljs$core$str__1 = (function (x){
if((x == null)){
return "";
} else {
var G__6763 = x;
return goog.string.buildString(G__6763);
}
});
var cljs$core$str__2 = (function() { 
var G__6764__delegate = function (x,ys){
var sb = (new goog.string.StringBuffer(cljs$core$str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__6765 = sb.append(cljs$core$str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__6766 = cljs.core.next(more);
sb = G__6765;
more = G__6766;
continue;
} else {
return sb.toString();
}
break;
}
};
var G__6764 = function (x,var_args){
var ys = null;
if (arguments.length > 1) {
var G__6767__i = 0, G__6767__a = new Array(arguments.length -  1);
while (G__6767__i < G__6767__a.length) {G__6767__a[G__6767__i] = arguments[G__6767__i + 1]; ++G__6767__i;}
  ys = new cljs.core.IndexedSeq(G__6767__a,0);
} 
return G__6764__delegate.call(this,x,ys);};
G__6764.cljs$lang$maxFixedArity = 1;
G__6764.cljs$lang$applyTo = (function (arglist__6768){
var x = cljs.core.first(arglist__6768);
var ys = cljs.core.rest(arglist__6768);
return G__6764__delegate(x,ys);
});
G__6764.cljs$core$IFn$_invoke$arity$variadic = G__6764__delegate;
return G__6764;
})()
;
cljs$core$str = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return cljs$core$str__0.call(this);
case 1:
return cljs$core$str__1.call(this,x);
default:
var G__6769 = null;
if (arguments.length > 1) {
var G__6770__i = 0, G__6770__a = new Array(arguments.length -  1);
while (G__6770__i < G__6770__a.length) {G__6770__a[G__6770__i] = arguments[G__6770__i + 1]; ++G__6770__i;}
G__6769 = new cljs.core.IndexedSeq(G__6770__a,0);
}
return cljs$core$str__2.cljs$core$IFn$_invoke$arity$variadic(x, G__6769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$str.cljs$lang$maxFixedArity = 1;
cljs$core$str.cljs$lang$applyTo = cljs$core$str__2.cljs$lang$applyTo;
cljs$core$str.cljs$core$IFn$_invoke$arity$0 = cljs$core$str__0;
cljs$core$str.cljs$core$IFn$_invoke$arity$1 = cljs$core$str__1;
cljs$core$str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$str__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$str;
})()
;
/**
 * Returns the substring of s beginning at start inclusive, and ending
 * at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function() {
var cljs$core$subs = null;
var cljs$core$subs__2 = (function (s,start){
return s.substring(start);
});
var cljs$core$subs__3 = (function (s,start,end){
return s.substring(start,end);
});
cljs$core$subs = function(s,start,end){
switch(arguments.length){
case 2:
return cljs$core$subs__2.call(this,s,start);
case 3:
return cljs$core$subs__3.call(this,s,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subs.cljs$core$IFn$_invoke$arity$2 = cljs$core$subs__2;
cljs$core$subs.cljs$core$IFn$_invoke$arity$3 = cljs$core$subs__3;
return cljs$core$subs;
})()
;

/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 * returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__6771 = cljs.core.next(xs);
var G__6772 = cljs.core.next(ys);
xs = G__6771;
ys = G__6772;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__6773 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__6774 = cljs.core.next(s);
res = G__6773;
s = G__6774;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__6779 = ((h + (cljs.core.hash((function (){var G__6777 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__6777) : cljs.core.key.call(null,G__6777));
})()) ^ cljs.core.hash((function (){var G__6778 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__6778) : cljs.core.val.call(null,G__6778));
})()))) % (4503599627370496));
var G__6780 = cljs.core.next(s);
h = G__6779;
s = G__6780;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__6781 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__6782 = cljs.core.next(s__$1);
h = G__6781;
s__$1 = G__6782;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 * attaches said functions as methods on the object.  Any references to
 * JavaScript's implicit this (via the this-as macro) will resolve to the
 * object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__6793_6803 = cljs.core.seq(fn_map);
var chunk__6794_6804 = null;
var count__6795_6805 = (0);
var i__6796_6806 = (0);
while(true){
if((i__6796_6806 < count__6795_6805)){
var vec__6797_6807 = chunk__6794_6804.cljs$core$IIndexed$_nth$arity$2(null,i__6796_6806);
var key_name_6808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6797_6807,(0),null);
var f_6809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6797_6807,(1),null);
var str_name_6810 = (function (){var G__6798 = key_name_6808;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6798) : cljs.core.name.call(null,G__6798));
})();
(obj[str_name_6810] = f_6809);

var G__6811 = seq__6793_6803;
var G__6812 = chunk__6794_6804;
var G__6813 = count__6795_6805;
var G__6814 = (i__6796_6806 + (1));
seq__6793_6803 = G__6811;
chunk__6794_6804 = G__6812;
count__6795_6805 = G__6813;
i__6796_6806 = G__6814;
continue;
} else {
var temp__4126__auto___6815 = cljs.core.seq(seq__6793_6803);
if(temp__4126__auto___6815){
var seq__6793_6816__$1 = temp__4126__auto___6815;
if(cljs.core.chunked_seq_QMARK_(seq__6793_6816__$1)){
var c__4525__auto___6817 = (function (){var G__6799 = seq__6793_6816__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__6799) : cljs.core.chunk_first.call(null,G__6799));
})();
var G__6818 = (function (){var G__6800 = seq__6793_6816__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__6800) : cljs.core.chunk_rest.call(null,G__6800));
})();
var G__6819 = c__4525__auto___6817;
var G__6820 = cljs.core.count(c__4525__auto___6817);
var G__6821 = (0);
seq__6793_6803 = G__6818;
chunk__6794_6804 = G__6819;
count__6795_6805 = G__6820;
i__6796_6806 = G__6821;
continue;
} else {
var vec__6801_6822 = cljs.core.first(seq__6793_6816__$1);
var key_name_6823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6801_6822,(0),null);
var f_6824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6801_6822,(1),null);
var str_name_6825 = (function (){var G__6802 = key_name_6823;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6802) : cljs.core.name.call(null,G__6802));
})();
(obj[str_name_6825] = f_6824);

var G__6826 = cljs.core.next(seq__6793_6816__$1);
var G__6827 = null;
var G__6828 = (0);
var G__6829 = (0);
seq__6793_6803 = G__6826;
chunk__6794_6804 = G__6827;
count__6795_6805 = G__6828;
i__6796_6806 = G__6829;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
var G__6831 = coll;
if(G__6831){
var bit__4414__auto__ = (G__6831.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4414__auto__) || (G__6831.cljs$core$IReversible$)){
return true;
} else {
if((!G__6831.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__6831);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__6831);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 * can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(coll){
return cljs.core._rseq(coll);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 * @param {...*} var_args
 */
cljs.core.list = (function() { 
var cljs$core$list__delegate = function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__6832 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__6832;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__6833 = (i - (1));
var G__6834 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__6833;
r = G__6834;
continue;
} else {
return r;
}
break;
}
};
var cljs$core$list = function (var_args){
var xs = null;
if (arguments.length > 0) {
var G__6835__i = 0, G__6835__a = new Array(arguments.length -  0);
while (G__6835__i < G__6835__a.length) {G__6835__a[G__6835__i] = arguments[G__6835__i + 0]; ++G__6835__i;}
  xs = new cljs.core.IndexedSeq(G__6835__a,0);
} 
return cljs$core$list__delegate.call(this,xs);};
cljs$core$list.cljs$lang$maxFixedArity = 0;
cljs$core$list.cljs$lang$applyTo = (function (arglist__6836){
var xs = cljs.core.seq(arglist__6836);
return cljs$core$list__delegate(xs);
});
cljs$core$list.cljs$core$IFn$_invoke$arity$variadic = cljs$core$list__delegate;
return cljs$core$list;
})()
;

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__3740__auto__ = (coll == null);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var G__6840 = coll;
if(G__6840){
var bit__4407__auto__ = (G__6840.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4407__auto__) || (G__6840.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
var G__6842 = x;
if(G__6842){
var bit__4414__auto__ = (G__6842.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4414__auto__) || (G__6842.cljs$core$IList$)){
return true;
} else {
if((!G__6842.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__6842);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__6842);
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3728__auto__ = cljs.core.not(a.ns);
if(and__3728__auto__){
return b.ns;
} else {
return and__3728__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__6849 = a.ns;
var G__6850 = b.ns;
return goog.array.defaultCompare(G__6849,G__6850);
})();
if(((0) === nsc)){
var G__6851 = a.name;
var G__6852 = b.name;
return goog.array.defaultCompare(G__6851,G__6852);
} else {
return nsc;
}
}
} else {
var G__6853 = a.name;
var G__6854 = b.name;
return goog.array.defaultCompare(G__6853,G__6854);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4156__auto__ = self__._hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__6856 = null;
var G__6856__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__6856__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__6856 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__6856__2.call(this,self__,coll);
case 3:
return G__6856__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6856.cljs$core$IFn$_invoke$arity$2 = G__6856__2;
G__6856.cljs$core$IFn$_invoke$arity$3 = G__6856__3;
return G__6856;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args6855){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6855)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((function (){var G__6858 = x;
if(G__6858){
var bit__4407__auto__ = (G__6858.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4407__auto__) || (G__6858.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 * in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function() {
var cljs$core$keyword = null;
var cljs$core$keyword__1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__6860 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6860) : cljs.core.name.call(null,G__6860));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});
var cljs$core$keyword__2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});
cljs$core$keyword = function(ns,name){
switch(arguments.length){
case 1:
return cljs$core$keyword__1.call(this,ns);
case 2:
return cljs$core$keyword__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keyword.cljs$core$IFn$_invoke$arity$1 = cljs$core$keyword__1;
cljs$core$keyword.cljs$core$IFn$_invoke$arity$2 = cljs$core$keyword__2;
return cljs$core$keyword;
})()
;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__6861 = ls.sval();
ls = G__6861;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function() {
var cljs$core$array_chunk = null;
var cljs$core$array_chunk__1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});
var cljs$core$array_chunk__2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});
var cljs$core$array_chunk__3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});
cljs$core$array_chunk = function(arr,off,end){
switch(arguments.length){
case 1:
return cljs$core$array_chunk__1.call(this,arr);
case 2:
return cljs$core$array_chunk__2.call(this,arr,off);
case 3:
return cljs$core$array_chunk__3.call(this,arr,off,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$1 = cljs$core$array_chunk__1;
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_chunk__2;
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$3 = cljs$core$array_chunk__3;
return cljs$core$array_chunk;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((function (){var G__6863 = s;
if(G__6863){
var bit__4407__auto__ = (G__6863.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4407__auto__) || (G__6863.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__6864 = cljs.core.next(s__$1);
s__$1 = G__6864;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 * containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_6865 = (0);
var xs_6866 = cljs.core.seq(coll);
while(true){
if(xs_6866){
(ret[i_6865] = cljs.core.to_array(cljs.core.first(xs_6866)));

var G__6867 = (i_6865 + (1));
var G__6868 = cljs.core.next(xs_6866);
i_6865 = G__6867;
xs_6866 = G__6868;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.int_array = (function() {
var cljs$core$int_array = null;
var cljs$core$int_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$int_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6871 = (i + (1));
var G__6872 = cljs.core.next(s__$1);
i = G__6871;
s__$1 = G__6872;
continue;
} else {
return a;
}
break;
}
} else {
var n__4625__auto___6873 = size;
var i_6874 = (0);
while(true){
if((i_6874 < n__4625__auto___6873)){
(a[i_6874] = init_val_or_seq);

var G__6875 = (i_6874 + (1));
i_6874 = G__6875;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$int_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$int_array__1.call(this,size);
case 2:
return cljs$core$int_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$int_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$int_array__1;
cljs$core$int_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$int_array__2;
return cljs$core$int_array;
})()
;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.long_array = (function() {
var cljs$core$long_array = null;
var cljs$core$long_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$long_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6878 = (i + (1));
var G__6879 = cljs.core.next(s__$1);
i = G__6878;
s__$1 = G__6879;
continue;
} else {
return a;
}
break;
}
} else {
var n__4625__auto___6880 = size;
var i_6881 = (0);
while(true){
if((i_6881 < n__4625__auto___6880)){
(a[i_6881] = init_val_or_seq);

var G__6882 = (i_6881 + (1));
i_6881 = G__6882;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$long_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$long_array__1.call(this,size);
case 2:
return cljs$core$long_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$long_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$long_array__1;
cljs$core$long_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$long_array__2;
return cljs$core$long_array;
})()
;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.double_array = (function() {
var cljs$core$double_array = null;
var cljs$core$double_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$double_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6885 = (i + (1));
var G__6886 = cljs.core.next(s__$1);
i = G__6885;
s__$1 = G__6886;
continue;
} else {
return a;
}
break;
}
} else {
var n__4625__auto___6887 = size;
var i_6888 = (0);
while(true){
if((i_6888 < n__4625__auto___6887)){
(a[i_6888] = init_val_or_seq);

var G__6889 = (i_6888 + (1));
i_6888 = G__6889;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$double_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$double_array__1.call(this,size);
case 2:
return cljs$core$double_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$double_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$double_array__1;
cljs$core$double_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$double_array__2;
return cljs$core$double_array;
})()
;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.object_array = (function() {
var cljs$core$object_array = null;
var cljs$core$object_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$object_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6892 = (i + (1));
var G__6893 = cljs.core.next(s__$1);
i = G__6892;
s__$1 = G__6893;
continue;
} else {
return a;
}
break;
}
} else {
var n__4625__auto___6894 = size;
var i_6895 = (0);
while(true){
if((i_6895 < n__4625__auto___6894)){
(a[i_6895] = init_val_or_seq);

var G__6896 = (i_6895 + (1));
i_6895 = G__6896;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$object_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$object_array__1.call(this,size);
case 2:
return cljs$core$object_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$object_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$object_array__1;
cljs$core$object_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$object_array__2;
return cljs$core$object_array;
})()
;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__6897 = cljs.core.next(s__$1);
var G__6898 = (i - (1));
var G__6899 = (sum + (1));
s__$1 = G__6897;
i = G__6898;
sum = G__6899;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 * @param {...*} var_args
 */
cljs.core.concat = (function() {
var cljs$core$concat = null;
var cljs$core$concat__0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});
var cljs$core$concat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});
var cljs$core$concat__2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs$core$concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs$core$concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});
var cljs$core$concat__3 = (function() { 
var G__6919__delegate = function (x,y,zs){
var cat = (function cljs$core$concat_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$concat_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$concat_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$concat_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs$core$concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
};
var G__6919 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__6920__i = 0, G__6920__a = new Array(arguments.length -  2);
while (G__6920__i < G__6920__a.length) {G__6920__a[G__6920__i] = arguments[G__6920__i + 2]; ++G__6920__i;}
  zs = new cljs.core.IndexedSeq(G__6920__a,0);
} 
return G__6919__delegate.call(this,x,y,zs);};
G__6919.cljs$lang$maxFixedArity = 2;
G__6919.cljs$lang$applyTo = (function (arglist__6921){
var x = cljs.core.first(arglist__6921);
arglist__6921 = cljs.core.next(arglist__6921);
var y = cljs.core.first(arglist__6921);
var zs = cljs.core.rest(arglist__6921);
return G__6919__delegate(x,y,zs);
});
G__6919.cljs$core$IFn$_invoke$arity$variadic = G__6919__delegate;
return G__6919;
})()
;
cljs$core$concat = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$concat__0.call(this);
case 1:
return cljs$core$concat__1.call(this,x);
case 2:
return cljs$core$concat__2.call(this,x,y);
default:
var G__6922 = null;
if (arguments.length > 2) {
var G__6923__i = 0, G__6923__a = new Array(arguments.length -  2);
while (G__6923__i < G__6923__a.length) {G__6923__a[G__6923__i] = arguments[G__6923__i + 2]; ++G__6923__i;}
G__6922 = new cljs.core.IndexedSeq(G__6923__a,0);
}
return cljs$core$concat__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$concat.cljs$lang$maxFixedArity = 2;
cljs$core$concat.cljs$lang$applyTo = cljs$core$concat__3.cljs$lang$applyTo;
cljs$core$concat.cljs$core$IFn$_invoke$arity$0 = cljs$core$concat__0;
cljs$core$concat.cljs$core$IFn$_invoke$arity$1 = cljs$core$concat__1;
cljs$core$concat.cljs$core$IFn$_invoke$arity$2 = cljs$core$concat__2;
cljs$core$concat.cljs$core$IFn$_invoke$arity$variadic = cljs$core$concat__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$concat;
})()
;
/**
 * Creates a new list containing the items prepended to the rest, the
 * last of which will be treated as a sequence.
 * @param {...*} var_args
 */
cljs.core.list_STAR_ = (function() {
var cljs$core$list_STAR_ = null;
var cljs$core$list_STAR___1 = (function (args){
return cljs.core.seq(args);
});
var cljs$core$list_STAR___2 = (function (a,args){
return cljs.core.cons(a,args);
});
var cljs$core$list_STAR___3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});
var cljs$core$list_STAR___4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});
var cljs$core$list_STAR___5 = (function() { 
var G__6924__delegate = function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
};
var G__6924 = function (a,b,c,d,var_args){
var more = null;
if (arguments.length > 4) {
var G__6925__i = 0, G__6925__a = new Array(arguments.length -  4);
while (G__6925__i < G__6925__a.length) {G__6925__a[G__6925__i] = arguments[G__6925__i + 4]; ++G__6925__i;}
  more = new cljs.core.IndexedSeq(G__6925__a,0);
} 
return G__6924__delegate.call(this,a,b,c,d,more);};
G__6924.cljs$lang$maxFixedArity = 4;
G__6924.cljs$lang$applyTo = (function (arglist__6926){
var a = cljs.core.first(arglist__6926);
arglist__6926 = cljs.core.next(arglist__6926);
var b = cljs.core.first(arglist__6926);
arglist__6926 = cljs.core.next(arglist__6926);
var c = cljs.core.first(arglist__6926);
arglist__6926 = cljs.core.next(arglist__6926);
var d = cljs.core.first(arglist__6926);
var more = cljs.core.rest(arglist__6926);
return G__6924__delegate(a,b,c,d,more);
});
G__6924.cljs$core$IFn$_invoke$arity$variadic = G__6924__delegate;
return G__6924;
})()
;
cljs$core$list_STAR_ = function(a,b,c,d,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$list_STAR___1.call(this,a);
case 2:
return cljs$core$list_STAR___2.call(this,a,b);
case 3:
return cljs$core$list_STAR___3.call(this,a,b,c);
case 4:
return cljs$core$list_STAR___4.call(this,a,b,c,d);
default:
var G__6927 = null;
if (arguments.length > 4) {
var G__6928__i = 0, G__6928__a = new Array(arguments.length -  4);
while (G__6928__i < G__6928__a.length) {G__6928__a[G__6928__i] = arguments[G__6928__i + 4]; ++G__6928__i;}
G__6927 = new cljs.core.IndexedSeq(G__6928__a,0);
}
return cljs$core$list_STAR___5.cljs$core$IFn$_invoke$arity$variadic(a,b,c,d, G__6927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$list_STAR_.cljs$lang$maxFixedArity = 4;
cljs$core$list_STAR_.cljs$lang$applyTo = cljs$core$list_STAR___5.cljs$lang$applyTo;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$1 = cljs$core$list_STAR___1;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$2 = cljs$core$list_STAR___2;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$3 = cljs$core$list_STAR___3;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$4 = cljs$core$list_STAR___4;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$list_STAR___5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$list_STAR_;
})()
;
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 * constant time. The transient collection cannot be used after this
 * call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 * may happen at different 'places' depending on the concrete type.
 * @param {...*} var_args
 */
cljs.core.conj_BANG_ = (function() {
var cljs$core$conj_BANG_ = null;
var cljs$core$conj_BANG___0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});
var cljs$core$conj_BANG___1 = (function (coll){
return coll;
});
var cljs$core$conj_BANG___2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});
var cljs$core$conj_BANG___3 = (function() { 
var G__6929__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__6930 = ntcoll;
var G__6931 = cljs.core.first(vals);
var G__6932 = cljs.core.next(vals);
tcoll = G__6930;
val = G__6931;
vals = G__6932;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6929 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__6933__i = 0, G__6933__a = new Array(arguments.length -  2);
while (G__6933__i < G__6933__a.length) {G__6933__a[G__6933__i] = arguments[G__6933__i + 2]; ++G__6933__i;}
  vals = new cljs.core.IndexedSeq(G__6933__a,0);
} 
return G__6929__delegate.call(this,tcoll,val,vals);};
G__6929.cljs$lang$maxFixedArity = 2;
G__6929.cljs$lang$applyTo = (function (arglist__6934){
var tcoll = cljs.core.first(arglist__6934);
arglist__6934 = cljs.core.next(arglist__6934);
var val = cljs.core.first(arglist__6934);
var vals = cljs.core.rest(arglist__6934);
return G__6929__delegate(tcoll,val,vals);
});
G__6929.cljs$core$IFn$_invoke$arity$variadic = G__6929__delegate;
return G__6929;
})()
;
cljs$core$conj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 0:
return cljs$core$conj_BANG___0.call(this);
case 1:
return cljs$core$conj_BANG___1.call(this,tcoll);
case 2:
return cljs$core$conj_BANG___2.call(this,tcoll,val);
default:
var G__6935 = null;
if (arguments.length > 2) {
var G__6936__i = 0, G__6936__a = new Array(arguments.length -  2);
while (G__6936__i < G__6936__a.length) {G__6936__a[G__6936__i] = arguments[G__6936__i + 2]; ++G__6936__i;}
G__6935 = new cljs.core.IndexedSeq(G__6936__a,0);
}
return cljs$core$conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__6935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$conj_BANG_.cljs$lang$applyTo = cljs$core$conj_BANG___3.cljs$lang$applyTo;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$0 = cljs$core$conj_BANG___0;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$1 = cljs$core$conj_BANG___1;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$conj_BANG___2;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$conj_BANG_;
})()
;
/**
 * When applied to a transient map, adds mapping of key(s) to
 * val(s). When applied to a transient vector, sets the val at index.
 * Note - index must be <= (count vector). Returns coll.
 * @param {...*} var_args
 */
cljs.core.assoc_BANG_ = (function() {
var cljs$core$assoc_BANG_ = null;
var cljs$core$assoc_BANG___3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});
var cljs$core$assoc_BANG___4 = (function() { 
var G__6937__delegate = function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__6938 = ntcoll;
var G__6939 = cljs.core.first(kvs);
var G__6940 = cljs.core.second(kvs);
var G__6941 = cljs.core.nnext(kvs);
tcoll = G__6938;
key = G__6939;
val = G__6940;
kvs = G__6941;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6937 = function (tcoll,key,val,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__6942__i = 0, G__6942__a = new Array(arguments.length -  3);
while (G__6942__i < G__6942__a.length) {G__6942__a[G__6942__i] = arguments[G__6942__i + 3]; ++G__6942__i;}
  kvs = new cljs.core.IndexedSeq(G__6942__a,0);
} 
return G__6937__delegate.call(this,tcoll,key,val,kvs);};
G__6937.cljs$lang$maxFixedArity = 3;
G__6937.cljs$lang$applyTo = (function (arglist__6943){
var tcoll = cljs.core.first(arglist__6943);
arglist__6943 = cljs.core.next(arglist__6943);
var key = cljs.core.first(arglist__6943);
arglist__6943 = cljs.core.next(arglist__6943);
var val = cljs.core.first(arglist__6943);
var kvs = cljs.core.rest(arglist__6943);
return G__6937__delegate(tcoll,key,val,kvs);
});
G__6937.cljs$core$IFn$_invoke$arity$variadic = G__6937__delegate;
return G__6937;
})()
;
cljs$core$assoc_BANG_ = function(tcoll,key,val,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return cljs$core$assoc_BANG___3.call(this,tcoll,key,val);
default:
var G__6944 = null;
if (arguments.length > 3) {
var G__6945__i = 0, G__6945__a = new Array(arguments.length -  3);
while (G__6945__i < G__6945__a.length) {G__6945__a[G__6945__i] = arguments[G__6945__i + 3]; ++G__6945__i;}
G__6944 = new cljs.core.IndexedSeq(G__6945__a,0);
}
return cljs$core$assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic(tcoll,key,val, G__6944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs$core$assoc_BANG_.cljs$lang$applyTo = cljs$core$assoc_BANG___4.cljs$lang$applyTo;
cljs$core$assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$assoc_BANG___3;
cljs$core$assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$assoc_BANG_;
})()
;
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 * @param {...*} var_args
 */
cljs.core.dissoc_BANG_ = (function() {
var cljs$core$dissoc_BANG_ = null;
var cljs$core$dissoc_BANG___2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});
var cljs$core$dissoc_BANG___3 = (function() { 
var G__6946__delegate = function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__6947 = ntcoll;
var G__6948 = cljs.core.first(ks);
var G__6949 = cljs.core.next(ks);
tcoll = G__6947;
key = G__6948;
ks = G__6949;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6946 = function (tcoll,key,var_args){
var ks = null;
if (arguments.length > 2) {
var G__6950__i = 0, G__6950__a = new Array(arguments.length -  2);
while (G__6950__i < G__6950__a.length) {G__6950__a[G__6950__i] = arguments[G__6950__i + 2]; ++G__6950__i;}
  ks = new cljs.core.IndexedSeq(G__6950__a,0);
} 
return G__6946__delegate.call(this,tcoll,key,ks);};
G__6946.cljs$lang$maxFixedArity = 2;
G__6946.cljs$lang$applyTo = (function (arglist__6951){
var tcoll = cljs.core.first(arglist__6951);
arglist__6951 = cljs.core.next(arglist__6951);
var key = cljs.core.first(arglist__6951);
var ks = cljs.core.rest(arglist__6951);
return G__6946__delegate(tcoll,key,ks);
});
G__6946.cljs$core$IFn$_invoke$arity$variadic = G__6946__delegate;
return G__6946;
})()
;
cljs$core$dissoc_BANG_ = function(tcoll,key,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return cljs$core$dissoc_BANG___2.call(this,tcoll,key);
default:
var G__6952 = null;
if (arguments.length > 2) {
var G__6953__i = 0, G__6953__a = new Array(arguments.length -  2);
while (G__6953__i < G__6953__a.length) {G__6953__a[G__6953__i] = arguments[G__6953__i + 2]; ++G__6953__i;}
G__6952 = new cljs.core.IndexedSeq(G__6953__a,0);
}
return cljs$core$dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,key, G__6952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$dissoc_BANG_.cljs$lang$applyTo = cljs$core$dissoc_BANG___3.cljs$lang$applyTo;
cljs$core$dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$dissoc_BANG___2;
cljs$core$dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$dissoc_BANG_;
})()
;
/**
 * Removes the last item from a transient vector. If
 * the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 * does not contain key(s).
 * @param {...*} var_args
 */
cljs.core.disj_BANG_ = (function() {
var cljs$core$disj_BANG_ = null;
var cljs$core$disj_BANG___2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});
var cljs$core$disj_BANG___3 = (function() { 
var G__6954__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__6955 = ntcoll;
var G__6956 = cljs.core.first(vals);
var G__6957 = cljs.core.next(vals);
tcoll = G__6955;
val = G__6956;
vals = G__6957;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6954 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__6958__i = 0, G__6958__a = new Array(arguments.length -  2);
while (G__6958__i < G__6958__a.length) {G__6958__a[G__6958__i] = arguments[G__6958__i + 2]; ++G__6958__i;}
  vals = new cljs.core.IndexedSeq(G__6958__a,0);
} 
return G__6954__delegate.call(this,tcoll,val,vals);};
G__6954.cljs$lang$maxFixedArity = 2;
G__6954.cljs$lang$applyTo = (function (arglist__6959){
var tcoll = cljs.core.first(arglist__6959);
arglist__6959 = cljs.core.next(arglist__6959);
var val = cljs.core.first(arglist__6959);
var vals = cljs.core.rest(arglist__6959);
return G__6954__delegate(tcoll,val,vals);
});
G__6954.cljs$core$IFn$_invoke$arity$variadic = G__6954__delegate;
return G__6954;
})()
;
cljs$core$disj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 2:
return cljs$core$disj_BANG___2.call(this,tcoll,val);
default:
var G__6960 = null;
if (arguments.length > 2) {
var G__6961__i = 0, G__6961__a = new Array(arguments.length -  2);
while (G__6961__i < G__6961__a.length) {G__6961__a[G__6961__i] = arguments[G__6961__i + 2]; ++G__6961__i;}
G__6960 = new cljs.core.IndexedSeq(G__6961__a,0);
}
return cljs$core$disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__6960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$disj_BANG_.cljs$lang$applyTo = cljs$core$disj_BANG___3.cljs$lang$applyTo;
cljs$core$disj_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$disj_BANG___2;
cljs$core$disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$disj_BANG_;
})()
;

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a4669 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a4669);
} else {
var G__7172 = a4669;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7172) : f.call(null,G__7172));
}
} else {
var b4670 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a4669,b4670);
} else {
var G__7173 = a4669;
var G__7174 = b4670;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7173,G__7174) : f.call(null,G__7173,G__7174));
}
} else {
var c4671 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a4669,b4670,c4671);
} else {
var G__7175 = a4669;
var G__7176 = b4670;
var G__7177 = c4671;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7175,G__7176,G__7177) : f.call(null,G__7175,G__7176,G__7177));
}
} else {
var d4672 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a4669,b4670,c4671,d4672);
} else {
var G__7178 = a4669;
var G__7179 = b4670;
var G__7180 = c4671;
var G__7181 = d4672;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7178,G__7179,G__7180,G__7181) : f.call(null,G__7178,G__7179,G__7180,G__7181));
}
} else {
var e4673 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a4669,b4670,c4671,d4672,e4673);
} else {
var G__7182 = a4669;
var G__7183 = b4670;
var G__7184 = c4671;
var G__7185 = d4672;
var G__7186 = e4673;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7182,G__7183,G__7184,G__7185,G__7186) : f.call(null,G__7182,G__7183,G__7184,G__7185,G__7186));
}
} else {
var f4674 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a4669,b4670,c4671,d4672,e4673,f4674);
} else {
var G__7187 = a4669;
var G__7188 = b4670;
var G__7189 = c4671;
var G__7190 = d4672;
var G__7191 = e4673;
var G__7192 = f4674;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7187,G__7188,G__7189,G__7190,G__7191,G__7192) : f.call(null,G__7187,G__7188,G__7189,G__7190,G__7191,G__7192));
}
} else {
var g4675 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a4669,b4670,c4671,d4672,e4673,f4674,g4675);
} else {
var G__7193 = a4669;
var G__7194 = b4670;
var G__7195 = c4671;
var G__7196 = d4672;
var G__7197 = e4673;
var G__7198 = f4674;
var G__7199 = g4675;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__7193,G__7194,G__7195,G__7196,G__7197,G__7198,G__7199) : f.call(null,G__7193,G__7194,G__7195,G__7196,G__7197,G__7198,G__7199));
}
} else {
var h4676 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676);
} else {
var G__7200 = a4669;
var G__7201 = b4670;
var G__7202 = c4671;
var G__7203 = d4672;
var G__7204 = e4673;
var G__7205 = f4674;
var G__7206 = g4675;
var G__7207 = h4676;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__7200,G__7201,G__7202,G__7203,G__7204,G__7205,G__7206,G__7207) : f.call(null,G__7200,G__7201,G__7202,G__7203,G__7204,G__7205,G__7206,G__7207));
}
} else {
var i4677 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677);
} else {
var G__7208 = a4669;
var G__7209 = b4670;
var G__7210 = c4671;
var G__7211 = d4672;
var G__7212 = e4673;
var G__7213 = f4674;
var G__7214 = g4675;
var G__7215 = h4676;
var G__7216 = i4677;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__7208,G__7209,G__7210,G__7211,G__7212,G__7213,G__7214,G__7215,G__7216) : f.call(null,G__7208,G__7209,G__7210,G__7211,G__7212,G__7213,G__7214,G__7215,G__7216));
}
} else {
var j4678 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678);
} else {
var G__7217 = a4669;
var G__7218 = b4670;
var G__7219 = c4671;
var G__7220 = d4672;
var G__7221 = e4673;
var G__7222 = f4674;
var G__7223 = g4675;
var G__7224 = h4676;
var G__7225 = i4677;
var G__7226 = j4678;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__7217,G__7218,G__7219,G__7220,G__7221,G__7222,G__7223,G__7224,G__7225,G__7226) : f.call(null,G__7217,G__7218,G__7219,G__7220,G__7221,G__7222,G__7223,G__7224,G__7225,G__7226));
}
} else {
var k4679 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679);
} else {
var G__7227 = a4669;
var G__7228 = b4670;
var G__7229 = c4671;
var G__7230 = d4672;
var G__7231 = e4673;
var G__7232 = f4674;
var G__7233 = g4675;
var G__7234 = h4676;
var G__7235 = i4677;
var G__7236 = j4678;
var G__7237 = k4679;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__7227,G__7228,G__7229,G__7230,G__7231,G__7232,G__7233,G__7234,G__7235,G__7236,G__7237) : f.call(null,G__7227,G__7228,G__7229,G__7230,G__7231,G__7232,G__7233,G__7234,G__7235,G__7236,G__7237));
}
} else {
var l4680 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680);
} else {
var G__7238 = a4669;
var G__7239 = b4670;
var G__7240 = c4671;
var G__7241 = d4672;
var G__7242 = e4673;
var G__7243 = f4674;
var G__7244 = g4675;
var G__7245 = h4676;
var G__7246 = i4677;
var G__7247 = j4678;
var G__7248 = k4679;
var G__7249 = l4680;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__7238,G__7239,G__7240,G__7241,G__7242,G__7243,G__7244,G__7245,G__7246,G__7247,G__7248,G__7249) : f.call(null,G__7238,G__7239,G__7240,G__7241,G__7242,G__7243,G__7244,G__7245,G__7246,G__7247,G__7248,G__7249));
}
} else {
var m4681 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681);
} else {
var G__7250 = a4669;
var G__7251 = b4670;
var G__7252 = c4671;
var G__7253 = d4672;
var G__7254 = e4673;
var G__7255 = f4674;
var G__7256 = g4675;
var G__7257 = h4676;
var G__7258 = i4677;
var G__7259 = j4678;
var G__7260 = k4679;
var G__7261 = l4680;
var G__7262 = m4681;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__7250,G__7251,G__7252,G__7253,G__7254,G__7255,G__7256,G__7257,G__7258,G__7259,G__7260,G__7261,G__7262) : f.call(null,G__7250,G__7251,G__7252,G__7253,G__7254,G__7255,G__7256,G__7257,G__7258,G__7259,G__7260,G__7261,G__7262));
}
} else {
var n4682 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681,n4682);
} else {
var G__7263 = a4669;
var G__7264 = b4670;
var G__7265 = c4671;
var G__7266 = d4672;
var G__7267 = e4673;
var G__7268 = f4674;
var G__7269 = g4675;
var G__7270 = h4676;
var G__7271 = i4677;
var G__7272 = j4678;
var G__7273 = k4679;
var G__7274 = l4680;
var G__7275 = m4681;
var G__7276 = n4682;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__7263,G__7264,G__7265,G__7266,G__7267,G__7268,G__7269,G__7270,G__7271,G__7272,G__7273,G__7274,G__7275,G__7276) : f.call(null,G__7263,G__7264,G__7265,G__7266,G__7267,G__7268,G__7269,G__7270,G__7271,G__7272,G__7273,G__7274,G__7275,G__7276));
}
} else {
var o4683 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681,n4682,o4683);
} else {
var G__7277 = a4669;
var G__7278 = b4670;
var G__7279 = c4671;
var G__7280 = d4672;
var G__7281 = e4673;
var G__7282 = f4674;
var G__7283 = g4675;
var G__7284 = h4676;
var G__7285 = i4677;
var G__7286 = j4678;
var G__7287 = k4679;
var G__7288 = l4680;
var G__7289 = m4681;
var G__7290 = n4682;
var G__7291 = o4683;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__7277,G__7278,G__7279,G__7280,G__7281,G__7282,G__7283,G__7284,G__7285,G__7286,G__7287,G__7288,G__7289,G__7290,G__7291) : f.call(null,G__7277,G__7278,G__7279,G__7280,G__7281,G__7282,G__7283,G__7284,G__7285,G__7286,G__7287,G__7288,G__7289,G__7290,G__7291));
}
} else {
var p4684 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681,n4682,o4683,p4684);
} else {
var G__7292 = a4669;
var G__7293 = b4670;
var G__7294 = c4671;
var G__7295 = d4672;
var G__7296 = e4673;
var G__7297 = f4674;
var G__7298 = g4675;
var G__7299 = h4676;
var G__7300 = i4677;
var G__7301 = j4678;
var G__7302 = k4679;
var G__7303 = l4680;
var G__7304 = m4681;
var G__7305 = n4682;
var G__7306 = o4683;
var G__7307 = p4684;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__7292,G__7293,G__7294,G__7295,G__7296,G__7297,G__7298,G__7299,G__7300,G__7301,G__7302,G__7303,G__7304,G__7305,G__7306,G__7307) : f.call(null,G__7292,G__7293,G__7294,G__7295,G__7296,G__7297,G__7298,G__7299,G__7300,G__7301,G__7302,G__7303,G__7304,G__7305,G__7306,G__7307));
}
} else {
var q4685 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681,n4682,o4683,p4684,q4685);
} else {
var G__7308 = a4669;
var G__7309 = b4670;
var G__7310 = c4671;
var G__7311 = d4672;
var G__7312 = e4673;
var G__7313 = f4674;
var G__7314 = g4675;
var G__7315 = h4676;
var G__7316 = i4677;
var G__7317 = j4678;
var G__7318 = k4679;
var G__7319 = l4680;
var G__7320 = m4681;
var G__7321 = n4682;
var G__7322 = o4683;
var G__7323 = p4684;
var G__7324 = q4685;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__7308,G__7309,G__7310,G__7311,G__7312,G__7313,G__7314,G__7315,G__7316,G__7317,G__7318,G__7319,G__7320,G__7321,G__7322,G__7323,G__7324) : f.call(null,G__7308,G__7309,G__7310,G__7311,G__7312,G__7313,G__7314,G__7315,G__7316,G__7317,G__7318,G__7319,G__7320,G__7321,G__7322,G__7323,G__7324));
}
} else {
var r4686 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681,n4682,o4683,p4684,q4685,r4686);
} else {
var G__7325 = a4669;
var G__7326 = b4670;
var G__7327 = c4671;
var G__7328 = d4672;
var G__7329 = e4673;
var G__7330 = f4674;
var G__7331 = g4675;
var G__7332 = h4676;
var G__7333 = i4677;
var G__7334 = j4678;
var G__7335 = k4679;
var G__7336 = l4680;
var G__7337 = m4681;
var G__7338 = n4682;
var G__7339 = o4683;
var G__7340 = p4684;
var G__7341 = q4685;
var G__7342 = r4686;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__7325,G__7326,G__7327,G__7328,G__7329,G__7330,G__7331,G__7332,G__7333,G__7334,G__7335,G__7336,G__7337,G__7338,G__7339,G__7340,G__7341,G__7342) : f.call(null,G__7325,G__7326,G__7327,G__7328,G__7329,G__7330,G__7331,G__7332,G__7333,G__7334,G__7335,G__7336,G__7337,G__7338,G__7339,G__7340,G__7341,G__7342));
}
} else {
var s4687 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681,n4682,o4683,p4684,q4685,r4686,s4687);
} else {
var G__7343 = a4669;
var G__7344 = b4670;
var G__7345 = c4671;
var G__7346 = d4672;
var G__7347 = e4673;
var G__7348 = f4674;
var G__7349 = g4675;
var G__7350 = h4676;
var G__7351 = i4677;
var G__7352 = j4678;
var G__7353 = k4679;
var G__7354 = l4680;
var G__7355 = m4681;
var G__7356 = n4682;
var G__7357 = o4683;
var G__7358 = p4684;
var G__7359 = q4685;
var G__7360 = r4686;
var G__7361 = s4687;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__7343,G__7344,G__7345,G__7346,G__7347,G__7348,G__7349,G__7350,G__7351,G__7352,G__7353,G__7354,G__7355,G__7356,G__7357,G__7358,G__7359,G__7360,G__7361) : f.call(null,G__7343,G__7344,G__7345,G__7346,G__7347,G__7348,G__7349,G__7350,G__7351,G__7352,G__7353,G__7354,G__7355,G__7356,G__7357,G__7358,G__7359,G__7360,G__7361));
}
} else {
var t4688 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a4669,b4670,c4671,d4672,e4673,f4674,g4675,h4676,i4677,j4678,k4679,l4680,m4681,n4682,o4683,p4684,q4685,r4686,s4687,t4688);
} else {
var G__7362 = a4669;
var G__7363 = b4670;
var G__7364 = c4671;
var G__7365 = d4672;
var G__7366 = e4673;
var G__7367 = f4674;
var G__7368 = g4675;
var G__7369 = h4676;
var G__7370 = i4677;
var G__7371 = j4678;
var G__7372 = k4679;
var G__7373 = l4680;
var G__7374 = m4681;
var G__7375 = n4682;
var G__7376 = o4683;
var G__7377 = p4684;
var G__7378 = q4685;
var G__7379 = r4686;
var G__7380 = s4687;
var G__7381 = t4688;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__7362,G__7363,G__7364,G__7365,G__7366,G__7367,G__7368,G__7369,G__7370,G__7371,G__7372,G__7373,G__7374,G__7375,G__7376,G__7377,G__7378,G__7379,G__7380,G__7381) : f.call(null,G__7362,G__7363,G__7364,G__7365,G__7366,G__7367,G__7368,G__7369,G__7370,G__7371,G__7372,G__7373,G__7374,G__7375,G__7376,G__7377,G__7378,G__7379,G__7380,G__7381));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 * @param {...*} var_args
 */
cljs.core.apply = (function() {
var cljs$core$apply = null;
var cljs$core$apply__2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});
var cljs$core$apply__3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__6 = (function() { 
var G__7382__delegate = function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
};
var G__7382 = function (f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 5) {
var G__7383__i = 0, G__7383__a = new Array(arguments.length -  5);
while (G__7383__i < G__7383__a.length) {G__7383__a[G__7383__i] = arguments[G__7383__i + 5]; ++G__7383__i;}
  args = new cljs.core.IndexedSeq(G__7383__a,0);
} 
return G__7382__delegate.call(this,f,a,b,c,d,args);};
G__7382.cljs$lang$maxFixedArity = 5;
G__7382.cljs$lang$applyTo = (function (arglist__7384){
var f = cljs.core.first(arglist__7384);
arglist__7384 = cljs.core.next(arglist__7384);
var a = cljs.core.first(arglist__7384);
arglist__7384 = cljs.core.next(arglist__7384);
var b = cljs.core.first(arglist__7384);
arglist__7384 = cljs.core.next(arglist__7384);
var c = cljs.core.first(arglist__7384);
arglist__7384 = cljs.core.next(arglist__7384);
var d = cljs.core.first(arglist__7384);
var args = cljs.core.rest(arglist__7384);
return G__7382__delegate(f,a,b,c,d,args);
});
G__7382.cljs$core$IFn$_invoke$arity$variadic = G__7382__delegate;
return G__7382;
})()
;
cljs$core$apply = function(f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return cljs$core$apply__2.call(this,f,a);
case 3:
return cljs$core$apply__3.call(this,f,a,b);
case 4:
return cljs$core$apply__4.call(this,f,a,b,c);
case 5:
return cljs$core$apply__5.call(this,f,a,b,c,d);
default:
var G__7385 = null;
if (arguments.length > 5) {
var G__7386__i = 0, G__7386__a = new Array(arguments.length -  5);
while (G__7386__i < G__7386__a.length) {G__7386__a[G__7386__i] = arguments[G__7386__i + 5]; ++G__7386__i;}
G__7385 = new cljs.core.IndexedSeq(G__7386__a,0);
}
return cljs$core$apply__6.cljs$core$IFn$_invoke$arity$variadic(f,a,b,c,d, G__7385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$apply.cljs$lang$maxFixedArity = 5;
cljs$core$apply.cljs$lang$applyTo = cljs$core$apply__6.cljs$lang$applyTo;
cljs$core$apply.cljs$core$IFn$_invoke$arity$2 = cljs$core$apply__2;
cljs$core$apply.cljs$core$IFn$_invoke$arity$3 = cljs$core$apply__3;
cljs$core$apply.cljs$core$IFn$_invoke$arity$4 = cljs$core$apply__4;
cljs$core$apply.cljs$core$IFn$_invoke$arity$5 = cljs$core$apply__5;
cljs$core$apply.cljs$core$IFn$_invoke$arity$variadic = cljs$core$apply__6.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$apply;
})()
;
/**
 * Returns an object of the same type and value as obj, with
 * (apply f (meta obj) args) as its metadata.
 * @param {...*} var_args
 */
cljs.core.vary_meta = (function() {
var cljs$core$vary_meta = null;
var cljs$core$vary_meta__2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__7402 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7402) : f.call(null,G__7402));
})());
});
var cljs$core$vary_meta__3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__7403 = cljs.core.meta(obj);
var G__7404 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7403,G__7404) : f.call(null,G__7403,G__7404));
})());
});
var cljs$core$vary_meta__4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__7405 = cljs.core.meta(obj);
var G__7406 = a;
var G__7407 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7405,G__7406,G__7407) : f.call(null,G__7405,G__7406,G__7407));
})());
});
var cljs$core$vary_meta__5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__7408 = cljs.core.meta(obj);
var G__7409 = a;
var G__7410 = b;
var G__7411 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7408,G__7409,G__7410,G__7411) : f.call(null,G__7408,G__7409,G__7410,G__7411));
})());
});
var cljs$core$vary_meta__6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__7412 = cljs.core.meta(obj);
var G__7413 = a;
var G__7414 = b;
var G__7415 = c;
var G__7416 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7412,G__7413,G__7414,G__7415,G__7416) : f.call(null,G__7412,G__7413,G__7414,G__7415,G__7416));
})());
});
var cljs$core$vary_meta__7 = (function() { 
var G__7417__delegate = function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
};
var G__7417 = function (obj,f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 6) {
var G__7418__i = 0, G__7418__a = new Array(arguments.length -  6);
while (G__7418__i < G__7418__a.length) {G__7418__a[G__7418__i] = arguments[G__7418__i + 6]; ++G__7418__i;}
  args = new cljs.core.IndexedSeq(G__7418__a,0);
} 
return G__7417__delegate.call(this,obj,f,a,b,c,d,args);};
G__7417.cljs$lang$maxFixedArity = 6;
G__7417.cljs$lang$applyTo = (function (arglist__7419){
var obj = cljs.core.first(arglist__7419);
arglist__7419 = cljs.core.next(arglist__7419);
var f = cljs.core.first(arglist__7419);
arglist__7419 = cljs.core.next(arglist__7419);
var a = cljs.core.first(arglist__7419);
arglist__7419 = cljs.core.next(arglist__7419);
var b = cljs.core.first(arglist__7419);
arglist__7419 = cljs.core.next(arglist__7419);
var c = cljs.core.first(arglist__7419);
arglist__7419 = cljs.core.next(arglist__7419);
var d = cljs.core.first(arglist__7419);
var args = cljs.core.rest(arglist__7419);
return G__7417__delegate(obj,f,a,b,c,d,args);
});
G__7417.cljs$core$IFn$_invoke$arity$variadic = G__7417__delegate;
return G__7417;
})()
;
cljs$core$vary_meta = function(obj,f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return cljs$core$vary_meta__2.call(this,obj,f);
case 3:
return cljs$core$vary_meta__3.call(this,obj,f,a);
case 4:
return cljs$core$vary_meta__4.call(this,obj,f,a,b);
case 5:
return cljs$core$vary_meta__5.call(this,obj,f,a,b,c);
case 6:
return cljs$core$vary_meta__6.call(this,obj,f,a,b,c,d);
default:
var G__7420 = null;
if (arguments.length > 6) {
var G__7421__i = 0, G__7421__a = new Array(arguments.length -  6);
while (G__7421__i < G__7421__a.length) {G__7421__a[G__7421__i] = arguments[G__7421__i + 6]; ++G__7421__i;}
G__7420 = new cljs.core.IndexedSeq(G__7421__a,0);
}
return cljs$core$vary_meta__7.cljs$core$IFn$_invoke$arity$variadic(obj,f,a,b,c,d, G__7420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$vary_meta.cljs$lang$maxFixedArity = 6;
cljs$core$vary_meta.cljs$lang$applyTo = cljs$core$vary_meta__7.cljs$lang$applyTo;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$2 = cljs$core$vary_meta__2;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$3 = cljs$core$vary_meta__3;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$4 = cljs$core$vary_meta__4;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$5 = cljs$core$vary_meta__5;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$6 = cljs$core$vary_meta__6;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$variadic = cljs$core$vary_meta__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$vary_meta;
})()
;
/**
 * Same as (not (= obj1 obj2))
 * @param {...*} var_args
 */
cljs.core.not_EQ_ = (function() {
var cljs$core$not_EQ_ = null;
var cljs$core$not_EQ___1 = (function (x){
return false;
});
var cljs$core$not_EQ___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var cljs$core$not_EQ___3 = (function() { 
var G__7422__delegate = function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
};
var G__7422 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7423__i = 0, G__7423__a = new Array(arguments.length -  2);
while (G__7423__i < G__7423__a.length) {G__7423__a[G__7423__i] = arguments[G__7423__i + 2]; ++G__7423__i;}
  more = new cljs.core.IndexedSeq(G__7423__a,0);
} 
return G__7422__delegate.call(this,x,y,more);};
G__7422.cljs$lang$maxFixedArity = 2;
G__7422.cljs$lang$applyTo = (function (arglist__7424){
var x = cljs.core.first(arglist__7424);
arglist__7424 = cljs.core.next(arglist__7424);
var y = cljs.core.first(arglist__7424);
var more = cljs.core.rest(arglist__7424);
return G__7422__delegate(x,y,more);
});
G__7422.cljs$core$IFn$_invoke$arity$variadic = G__7422__delegate;
return G__7422;
})()
;
cljs$core$not_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$not_EQ___1.call(this,x);
case 2:
return cljs$core$not_EQ___2.call(this,x,y);
default:
var G__7425 = null;
if (arguments.length > 2) {
var G__7426__i = 0, G__7426__a = new Array(arguments.length -  2);
while (G__7426__i < G__7426__a.length) {G__7426__a[G__7426__i] = arguments[G__7426__i + 2]; ++G__7426__i;}
G__7425 = new cljs.core.IndexedSeq(G__7426__a,0);
}
return cljs$core$not_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$not_EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$not_EQ_.cljs$lang$applyTo = cljs$core$not_EQ___3.cljs$lang$applyTo;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$not_EQ___1;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$not_EQ___2;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$not_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$not_EQ_;
})()
;
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t7430 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t7430 = (function (nil_iter,meta7431){
this.nil_iter = nil_iter;
this.meta7431 = meta7431;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.t7430.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t7430.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t7430.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t7430.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_7432){
var self__ = this;
var _7432__$1 = this;
return self__.meta7431;
});

cljs.core.t7430.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_7432,meta7431__$1){
var self__ = this;
var _7432__$1 = this;
return (new cljs.core.t7430(self__.nil_iter,meta7431__$1));
});

cljs.core.t7430.cljs$lang$type = true;

cljs.core.t7430.cljs$lang$ctorStr = "cljs.core/t7430";

cljs.core.t7430.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/t7430");
});

cljs.core.__GT_t7430 = (function cljs$core$nil_iter_$___GT_t7430(nil_iter__$1,meta7431){
return (new cljs.core.t7430(nil_iter__$1,meta7431));
});

}

return (new cljs.core.t7430(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3728__auto__ = !((lt.stepper == null));
if(and__3728__auto__){
return self__.iter.hasNext();
} else {
return and__3728__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__7433 = lt;
var G__7434 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__7433,G__7434) : self__.xform.call(null,G__7433,G__7434));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__7435 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__7435) : self__.xform.call(null,G__7435));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__7437 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7437) : xform.call(null,G__7437));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__7439 = cljs.core.next(iters__$1);
iters__$1 = G__7439;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__4625__auto___7440 = self__.iters.length;
var i_7441 = (0);
while(true){
if((i_7441 < n__4625__auto___7440)){
(self__.nexts[i_7441] = (self__.iters[i_7441]).next());

var G__7442 = (i_7441 + (1));
i_7441 = G__7442;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3728__auto__ = !((lt.stepper == null));
if(and__3728__auto__){
return this$.hasNext();
} else {
return and__3728__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__7438 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__7438) : self__.xform.call(null,G__7438));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function() {
var cljs$core$multi_stepper = null;
var cljs$core$multi_stepper__2 = (function (xform,iters){
return cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});
var cljs$core$multi_stepper__3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$multi_stepper_$_stepfn = null;
var cljs$core$multi_stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$multi_stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$multi_stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$multi_stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$multi_stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$multi_stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$multi_stepper_$_stepfn__1;
cljs$core$multi_stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$multi_stepper_$_stepfn__2;
return cljs$core$multi_stepper_$_stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__7447 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7447) : xform.call(null,G__7447));
})(),iters,nexts));
});
cljs$core$multi_stepper = function(xform,iters,nexts){
switch(arguments.length){
case 2:
return cljs$core$multi_stepper__2.call(this,xform,iters);
case 3:
return cljs$core$multi_stepper__3.call(this,xform,iters,nexts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$2 = cljs$core$multi_stepper__2;
cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$3 = cljs$core$multi_stepper__3;
return cljs$core$multi_stepper;
})()
;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
})
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__7448_7452 = cljs.core.seq(colls);
var chunk__7449_7453 = null;
var count__7450_7454 = (0);
var i__7451_7455 = (0);
while(true){
if((i__7451_7455 < count__7450_7454)){
var coll_7456 = chunk__7449_7453.cljs$core$IIndexed$_nth$arity$2(null,i__7451_7455);
iters.push(cljs.core.iter(coll_7456));

var G__7457 = seq__7448_7452;
var G__7458 = chunk__7449_7453;
var G__7459 = count__7450_7454;
var G__7460 = (i__7451_7455 + (1));
seq__7448_7452 = G__7457;
chunk__7449_7453 = G__7458;
count__7450_7454 = G__7459;
i__7451_7455 = G__7460;
continue;
} else {
var temp__4126__auto___7461 = cljs.core.seq(seq__7448_7452);
if(temp__4126__auto___7461){
var seq__7448_7462__$1 = temp__4126__auto___7461;
if(cljs.core.chunked_seq_QMARK_(seq__7448_7462__$1)){
var c__4525__auto___7463 = cljs.core.chunk_first(seq__7448_7462__$1);
var G__7464 = cljs.core.chunk_rest(seq__7448_7462__$1);
var G__7465 = c__4525__auto___7463;
var G__7466 = cljs.core.count(c__4525__auto___7463);
var G__7467 = (0);
seq__7448_7452 = G__7464;
chunk__7449_7453 = G__7465;
count__7450_7454 = G__7466;
i__7451_7455 = G__7467;
continue;
} else {
var coll_7468 = cljs.core.first(seq__7448_7462__$1);
iters.push(cljs.core.iter(coll_7468));

var G__7469 = cljs.core.next(seq__7448_7462__$1);
var G__7470 = null;
var G__7471 = (0);
var G__7472 = (0);
seq__7448_7452 = G__7469;
chunk__7449_7453 = G__7470;
count__7450_7454 = G__7471;
i__7451_7455 = G__7472;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 * one. Will not force a lazy seq. (sequence nil) yields (), When a
 * transducer is supplied, returns a lazy sequence of applications of
 * the transform to the items in coll(s), i.e. to the set of first
 * items of each coll, followed by the set of second
 * items in each coll, until any one of the colls is exhausted.  Any
 * remaining items in other colls are ignored. The transform should accept
 * number-of-colls arguments
 * @param {...*} var_args
 */
cljs.core.sequence = (function() {
var cljs$core$sequence = null;
var cljs$core$sequence__1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__3740__auto__ = cljs.core.seq(coll);
if(or__3740__auto__){
return or__3740__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});
var cljs$core$sequence__2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});
var cljs$core$sequence__3 = (function() { 
var G__7473__delegate = function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
};
var G__7473 = function (xform,coll,var_args){
var colls = null;
if (arguments.length > 2) {
var G__7474__i = 0, G__7474__a = new Array(arguments.length -  2);
while (G__7474__i < G__7474__a.length) {G__7474__a[G__7474__i] = arguments[G__7474__i + 2]; ++G__7474__i;}
  colls = new cljs.core.IndexedSeq(G__7474__a,0);
} 
return G__7473__delegate.call(this,xform,coll,colls);};
G__7473.cljs$lang$maxFixedArity = 2;
G__7473.cljs$lang$applyTo = (function (arglist__7475){
var xform = cljs.core.first(arglist__7475);
arglist__7475 = cljs.core.next(arglist__7475);
var coll = cljs.core.first(arglist__7475);
var colls = cljs.core.rest(arglist__7475);
return G__7473__delegate(xform,coll,colls);
});
G__7473.cljs$core$IFn$_invoke$arity$variadic = G__7473__delegate;
return G__7473;
})()
;
cljs$core$sequence = function(xform,coll,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$sequence__1.call(this,xform);
case 2:
return cljs$core$sequence__2.call(this,xform,coll);
default:
var G__7476 = null;
if (arguments.length > 2) {
var G__7477__i = 0, G__7477__a = new Array(arguments.length -  2);
while (G__7477__i < G__7477__a.length) {G__7477__a[G__7477__i] = arguments[G__7477__i + 2]; ++G__7477__i;}
G__7476 = new cljs.core.IndexedSeq(G__7477__a,0);
}
return cljs$core$sequence__3.cljs$core$IFn$_invoke$arity$variadic(xform,coll, G__7476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sequence.cljs$lang$maxFixedArity = 2;
cljs$core$sequence.cljs$lang$applyTo = cljs$core$sequence__3.cljs$lang$applyTo;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$1 = cljs$core$sequence__1;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$2 = cljs$core$sequence__2;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sequence__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sequence;
})()
;
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 * false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__7479 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__7479) : pred.call(null,G__7479));
})())){
var G__7480 = pred;
var G__7481 = cljs.core.next(coll);
pred = G__7480;
coll = G__7481;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 * coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 * else nil.  One common idiom is to use a set as pred, for example
 * this will return :fred if :fred is in the sequence, otherwise nil:
 * (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__3740__auto__ = (function (){var G__7485 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__7485) : pred.call(null,G__7485));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var G__7486 = pred;
var G__7487 = cljs.core.next(coll);
pred = G__7486;
coll = G__7487;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 * else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 * has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__7494 = null;
var G__7494__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__7494__1 = (function (x){
return cljs.core.not((function (){var G__7491 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7491) : f.call(null,G__7491));
})());
});
var G__7494__2 = (function (x,y){
return cljs.core.not((function (){var G__7492 = x;
var G__7493 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7492,G__7493) : f.call(null,G__7492,G__7493));
})());
});
var G__7494__3 = (function() { 
var G__7495__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__7495 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__7496__i = 0, G__7496__a = new Array(arguments.length -  2);
while (G__7496__i < G__7496__a.length) {G__7496__a[G__7496__i] = arguments[G__7496__i + 2]; ++G__7496__i;}
  zs = new cljs.core.IndexedSeq(G__7496__a,0);
} 
return G__7495__delegate.call(this,x,y,zs);};
G__7495.cljs$lang$maxFixedArity = 2;
G__7495.cljs$lang$applyTo = (function (arglist__7497){
var x = cljs.core.first(arglist__7497);
arglist__7497 = cljs.core.next(arglist__7497);
var y = cljs.core.first(arglist__7497);
var zs = cljs.core.rest(arglist__7497);
return G__7495__delegate(x,y,zs);
});
G__7495.cljs$core$IFn$_invoke$arity$variadic = G__7495__delegate;
return G__7495;
})()
;
G__7494 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__7494__0.call(this);
case 1:
return G__7494__1.call(this,x);
case 2:
return G__7494__2.call(this,x,y);
default:
var G__7498 = null;
if (arguments.length > 2) {
var G__7499__i = 0, G__7499__a = new Array(arguments.length -  2);
while (G__7499__i < G__7499__a.length) {G__7499__a[G__7499__i] = arguments[G__7499__i + 2]; ++G__7499__i;}
G__7498 = new cljs.core.IndexedSeq(G__7499__a,0);
}
return G__7494__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7494.cljs$lang$maxFixedArity = 2;
G__7494.cljs$lang$applyTo = G__7494__3.cljs$lang$applyTo;
G__7494.cljs$core$IFn$_invoke$arity$0 = G__7494__0;
G__7494.cljs$core$IFn$_invoke$arity$1 = G__7494__1;
G__7494.cljs$core$IFn$_invoke$arity$2 = G__7494__2;
G__7494.cljs$core$IFn$_invoke$arity$variadic = G__7494__3.cljs$core$IFn$_invoke$arity$variadic;
return G__7494;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__7500__delegate = function (args){
return x;
};
var G__7500 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7501__i = 0, G__7501__a = new Array(arguments.length -  0);
while (G__7501__i < G__7501__a.length) {G__7501__a[G__7501__i] = arguments[G__7501__i + 0]; ++G__7501__i;}
  args = new cljs.core.IndexedSeq(G__7501__a,0);
} 
return G__7500__delegate.call(this,args);};
G__7500.cljs$lang$maxFixedArity = 0;
G__7500.cljs$lang$applyTo = (function (arglist__7502){
var args = cljs.core.seq(arglist__7502);
return G__7500__delegate(args);
});
G__7500.cljs$core$IFn$_invoke$arity$variadic = G__7500__delegate;
return G__7500;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 * of those fns.  The returned fn takes a variable number of args,
 * applies the rightmost of fns to the args, the next
 * fn (right-to-left) to the result, etc.
 * @param {...*} var_args
 */
cljs.core.comp = (function() {
var cljs$core$comp = null;
var cljs$core$comp__0 = (function (){
return cljs.core.identity;
});
var cljs$core$comp__1 = (function (f){
return f;
});
var cljs$core$comp__2 = (function (f,g){
return (function() {
var G__7557 = null;
var G__7557__0 = (function (){
var G__7530 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7530) : f.call(null,G__7530));
});
var G__7557__1 = (function (x){
var G__7531 = (function (){var G__7532 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7532) : g.call(null,G__7532));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7531) : f.call(null,G__7531));
});
var G__7557__2 = (function (x,y){
var G__7533 = (function (){var G__7534 = x;
var G__7535 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__7534,G__7535) : g.call(null,G__7534,G__7535));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7533) : f.call(null,G__7533));
});
var G__7557__3 = (function (x,y,z){
var G__7536 = (function (){var G__7537 = x;
var G__7538 = y;
var G__7539 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__7537,G__7538,G__7539) : g.call(null,G__7537,G__7538,G__7539));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7536) : f.call(null,G__7536));
});
var G__7557__4 = (function() { 
var G__7558__delegate = function (x,y,z,args){
var G__7540 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7540) : f.call(null,G__7540));
};
var G__7558 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7559__i = 0, G__7559__a = new Array(arguments.length -  3);
while (G__7559__i < G__7559__a.length) {G__7559__a[G__7559__i] = arguments[G__7559__i + 3]; ++G__7559__i;}
  args = new cljs.core.IndexedSeq(G__7559__a,0);
} 
return G__7558__delegate.call(this,x,y,z,args);};
G__7558.cljs$lang$maxFixedArity = 3;
G__7558.cljs$lang$applyTo = (function (arglist__7560){
var x = cljs.core.first(arglist__7560);
arglist__7560 = cljs.core.next(arglist__7560);
var y = cljs.core.first(arglist__7560);
arglist__7560 = cljs.core.next(arglist__7560);
var z = cljs.core.first(arglist__7560);
var args = cljs.core.rest(arglist__7560);
return G__7558__delegate(x,y,z,args);
});
G__7558.cljs$core$IFn$_invoke$arity$variadic = G__7558__delegate;
return G__7558;
})()
;
G__7557 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7557__0.call(this);
case 1:
return G__7557__1.call(this,x);
case 2:
return G__7557__2.call(this,x,y);
case 3:
return G__7557__3.call(this,x,y,z);
default:
var G__7561 = null;
if (arguments.length > 3) {
var G__7562__i = 0, G__7562__a = new Array(arguments.length -  3);
while (G__7562__i < G__7562__a.length) {G__7562__a[G__7562__i] = arguments[G__7562__i + 3]; ++G__7562__i;}
G__7561 = new cljs.core.IndexedSeq(G__7562__a,0);
}
return G__7557__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7557.cljs$lang$maxFixedArity = 3;
G__7557.cljs$lang$applyTo = G__7557__4.cljs$lang$applyTo;
G__7557.cljs$core$IFn$_invoke$arity$0 = G__7557__0;
G__7557.cljs$core$IFn$_invoke$arity$1 = G__7557__1;
G__7557.cljs$core$IFn$_invoke$arity$2 = G__7557__2;
G__7557.cljs$core$IFn$_invoke$arity$3 = G__7557__3;
G__7557.cljs$core$IFn$_invoke$arity$variadic = G__7557__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7557;
})()
});
var cljs$core$comp__3 = (function (f,g,h){
return (function() {
var G__7563 = null;
var G__7563__0 = (function (){
var G__7541 = (function (){var G__7542 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7542) : g.call(null,G__7542));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7541) : f.call(null,G__7541));
});
var G__7563__1 = (function (x){
var G__7543 = (function (){var G__7544 = (function (){var G__7545 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__7545) : h.call(null,G__7545));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7544) : g.call(null,G__7544));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7543) : f.call(null,G__7543));
});
var G__7563__2 = (function (x,y){
var G__7546 = (function (){var G__7547 = (function (){var G__7548 = x;
var G__7549 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__7548,G__7549) : h.call(null,G__7548,G__7549));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7547) : g.call(null,G__7547));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7546) : f.call(null,G__7546));
});
var G__7563__3 = (function (x,y,z){
var G__7550 = (function (){var G__7551 = (function (){var G__7552 = x;
var G__7553 = y;
var G__7554 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__7552,G__7553,G__7554) : h.call(null,G__7552,G__7553,G__7554));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7551) : g.call(null,G__7551));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7550) : f.call(null,G__7550));
});
var G__7563__4 = (function() { 
var G__7564__delegate = function (x,y,z,args){
var G__7555 = (function (){var G__7556 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7556) : g.call(null,G__7556));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7555) : f.call(null,G__7555));
};
var G__7564 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7565__i = 0, G__7565__a = new Array(arguments.length -  3);
while (G__7565__i < G__7565__a.length) {G__7565__a[G__7565__i] = arguments[G__7565__i + 3]; ++G__7565__i;}
  args = new cljs.core.IndexedSeq(G__7565__a,0);
} 
return G__7564__delegate.call(this,x,y,z,args);};
G__7564.cljs$lang$maxFixedArity = 3;
G__7564.cljs$lang$applyTo = (function (arglist__7566){
var x = cljs.core.first(arglist__7566);
arglist__7566 = cljs.core.next(arglist__7566);
var y = cljs.core.first(arglist__7566);
arglist__7566 = cljs.core.next(arglist__7566);
var z = cljs.core.first(arglist__7566);
var args = cljs.core.rest(arglist__7566);
return G__7564__delegate(x,y,z,args);
});
G__7564.cljs$core$IFn$_invoke$arity$variadic = G__7564__delegate;
return G__7564;
})()
;
G__7563 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7563__0.call(this);
case 1:
return G__7563__1.call(this,x);
case 2:
return G__7563__2.call(this,x,y);
case 3:
return G__7563__3.call(this,x,y,z);
default:
var G__7567 = null;
if (arguments.length > 3) {
var G__7568__i = 0, G__7568__a = new Array(arguments.length -  3);
while (G__7568__i < G__7568__a.length) {G__7568__a[G__7568__i] = arguments[G__7568__i + 3]; ++G__7568__i;}
G__7567 = new cljs.core.IndexedSeq(G__7568__a,0);
}
return G__7563__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7563.cljs$lang$maxFixedArity = 3;
G__7563.cljs$lang$applyTo = G__7563__4.cljs$lang$applyTo;
G__7563.cljs$core$IFn$_invoke$arity$0 = G__7563__0;
G__7563.cljs$core$IFn$_invoke$arity$1 = G__7563__1;
G__7563.cljs$core$IFn$_invoke$arity$2 = G__7563__2;
G__7563.cljs$core$IFn$_invoke$arity$3 = G__7563__3;
G__7563.cljs$core$IFn$_invoke$arity$variadic = G__7563__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7563;
})()
});
var cljs$core$comp__4 = (function() { 
var G__7569__delegate = function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__7570__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__7571 = cljs.core.first(fs__$2).call(null,ret);
var G__7572 = cljs.core.next(fs__$2);
ret = G__7571;
fs__$2 = G__7572;
continue;
} else {
return ret;
}
break;
}
};
var G__7570 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7573__i = 0, G__7573__a = new Array(arguments.length -  0);
while (G__7573__i < G__7573__a.length) {G__7573__a[G__7573__i] = arguments[G__7573__i + 0]; ++G__7573__i;}
  args = new cljs.core.IndexedSeq(G__7573__a,0);
} 
return G__7570__delegate.call(this,args);};
G__7570.cljs$lang$maxFixedArity = 0;
G__7570.cljs$lang$applyTo = (function (arglist__7574){
var args = cljs.core.seq(arglist__7574);
return G__7570__delegate(args);
});
G__7570.cljs$core$IFn$_invoke$arity$variadic = G__7570__delegate;
return G__7570;
})()
;
;})(fs__$1))
};
var G__7569 = function (f1,f2,f3,var_args){
var fs = null;
if (arguments.length > 3) {
var G__7575__i = 0, G__7575__a = new Array(arguments.length -  3);
while (G__7575__i < G__7575__a.length) {G__7575__a[G__7575__i] = arguments[G__7575__i + 3]; ++G__7575__i;}
  fs = new cljs.core.IndexedSeq(G__7575__a,0);
} 
return G__7569__delegate.call(this,f1,f2,f3,fs);};
G__7569.cljs$lang$maxFixedArity = 3;
G__7569.cljs$lang$applyTo = (function (arglist__7576){
var f1 = cljs.core.first(arglist__7576);
arglist__7576 = cljs.core.next(arglist__7576);
var f2 = cljs.core.first(arglist__7576);
arglist__7576 = cljs.core.next(arglist__7576);
var f3 = cljs.core.first(arglist__7576);
var fs = cljs.core.rest(arglist__7576);
return G__7569__delegate(f1,f2,f3,fs);
});
G__7569.cljs$core$IFn$_invoke$arity$variadic = G__7569__delegate;
return G__7569;
})()
;
cljs$core$comp = function(f1,f2,f3,var_args){
var fs = var_args;
switch(arguments.length){
case 0:
return cljs$core$comp__0.call(this);
case 1:
return cljs$core$comp__1.call(this,f1);
case 2:
return cljs$core$comp__2.call(this,f1,f2);
case 3:
return cljs$core$comp__3.call(this,f1,f2,f3);
default:
var G__7577 = null;
if (arguments.length > 3) {
var G__7578__i = 0, G__7578__a = new Array(arguments.length -  3);
while (G__7578__i < G__7578__a.length) {G__7578__a[G__7578__i] = arguments[G__7578__i + 3]; ++G__7578__i;}
G__7577 = new cljs.core.IndexedSeq(G__7578__a,0);
}
return cljs$core$comp__4.cljs$core$IFn$_invoke$arity$variadic(f1,f2,f3, G__7577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$comp.cljs$lang$maxFixedArity = 3;
cljs$core$comp.cljs$lang$applyTo = cljs$core$comp__4.cljs$lang$applyTo;
cljs$core$comp.cljs$core$IFn$_invoke$arity$0 = cljs$core$comp__0;
cljs$core$comp.cljs$core$IFn$_invoke$arity$1 = cljs$core$comp__1;
cljs$core$comp.cljs$core$IFn$_invoke$arity$2 = cljs$core$comp__2;
cljs$core$comp.cljs$core$IFn$_invoke$arity$3 = cljs$core$comp__3;
cljs$core$comp.cljs$core$IFn$_invoke$arity$variadic = cljs$core$comp__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$comp;
})()
;
/**
 * Takes a function f and fewer than the normal arguments to f, and
 * returns a fn that takes a variable number of additional args. When
 * called, the returned function calls f with args + additional args.
 * @param {...*} var_args
 */
cljs.core.partial = (function() {
var cljs$core$partial = null;
var cljs$core$partial__1 = (function (f){
return f;
});
var cljs$core$partial__2 = (function (f,arg1){
return (function() {
var G__7663 = null;
var G__7663__0 = (function (){
var G__7621 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7621) : f.call(null,G__7621));
});
var G__7663__1 = (function (x){
var G__7622 = arg1;
var G__7623 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7622,G__7623) : f.call(null,G__7622,G__7623));
});
var G__7663__2 = (function (x,y){
var G__7624 = arg1;
var G__7625 = x;
var G__7626 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7624,G__7625,G__7626) : f.call(null,G__7624,G__7625,G__7626));
});
var G__7663__3 = (function (x,y,z){
var G__7627 = arg1;
var G__7628 = x;
var G__7629 = y;
var G__7630 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7627,G__7628,G__7629,G__7630) : f.call(null,G__7627,G__7628,G__7629,G__7630));
});
var G__7663__4 = (function() { 
var G__7664__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__7664 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7665__i = 0, G__7665__a = new Array(arguments.length -  3);
while (G__7665__i < G__7665__a.length) {G__7665__a[G__7665__i] = arguments[G__7665__i + 3]; ++G__7665__i;}
  args = new cljs.core.IndexedSeq(G__7665__a,0);
} 
return G__7664__delegate.call(this,x,y,z,args);};
G__7664.cljs$lang$maxFixedArity = 3;
G__7664.cljs$lang$applyTo = (function (arglist__7666){
var x = cljs.core.first(arglist__7666);
arglist__7666 = cljs.core.next(arglist__7666);
var y = cljs.core.first(arglist__7666);
arglist__7666 = cljs.core.next(arglist__7666);
var z = cljs.core.first(arglist__7666);
var args = cljs.core.rest(arglist__7666);
return G__7664__delegate(x,y,z,args);
});
G__7664.cljs$core$IFn$_invoke$arity$variadic = G__7664__delegate;
return G__7664;
})()
;
G__7663 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7663__0.call(this);
case 1:
return G__7663__1.call(this,x);
case 2:
return G__7663__2.call(this,x,y);
case 3:
return G__7663__3.call(this,x,y,z);
default:
var G__7667 = null;
if (arguments.length > 3) {
var G__7668__i = 0, G__7668__a = new Array(arguments.length -  3);
while (G__7668__i < G__7668__a.length) {G__7668__a[G__7668__i] = arguments[G__7668__i + 3]; ++G__7668__i;}
G__7667 = new cljs.core.IndexedSeq(G__7668__a,0);
}
return G__7663__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7667);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7663.cljs$lang$maxFixedArity = 3;
G__7663.cljs$lang$applyTo = G__7663__4.cljs$lang$applyTo;
G__7663.cljs$core$IFn$_invoke$arity$0 = G__7663__0;
G__7663.cljs$core$IFn$_invoke$arity$1 = G__7663__1;
G__7663.cljs$core$IFn$_invoke$arity$2 = G__7663__2;
G__7663.cljs$core$IFn$_invoke$arity$3 = G__7663__3;
G__7663.cljs$core$IFn$_invoke$arity$variadic = G__7663__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7663;
})()
});
var cljs$core$partial__3 = (function (f,arg1,arg2){
return (function() {
var G__7669 = null;
var G__7669__0 = (function (){
var G__7631 = arg1;
var G__7632 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7631,G__7632) : f.call(null,G__7631,G__7632));
});
var G__7669__1 = (function (x){
var G__7633 = arg1;
var G__7634 = arg2;
var G__7635 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7633,G__7634,G__7635) : f.call(null,G__7633,G__7634,G__7635));
});
var G__7669__2 = (function (x,y){
var G__7636 = arg1;
var G__7637 = arg2;
var G__7638 = x;
var G__7639 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7636,G__7637,G__7638,G__7639) : f.call(null,G__7636,G__7637,G__7638,G__7639));
});
var G__7669__3 = (function (x,y,z){
var G__7640 = arg1;
var G__7641 = arg2;
var G__7642 = x;
var G__7643 = y;
var G__7644 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7640,G__7641,G__7642,G__7643,G__7644) : f.call(null,G__7640,G__7641,G__7642,G__7643,G__7644));
});
var G__7669__4 = (function() { 
var G__7670__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__7670 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7671__i = 0, G__7671__a = new Array(arguments.length -  3);
while (G__7671__i < G__7671__a.length) {G__7671__a[G__7671__i] = arguments[G__7671__i + 3]; ++G__7671__i;}
  args = new cljs.core.IndexedSeq(G__7671__a,0);
} 
return G__7670__delegate.call(this,x,y,z,args);};
G__7670.cljs$lang$maxFixedArity = 3;
G__7670.cljs$lang$applyTo = (function (arglist__7672){
var x = cljs.core.first(arglist__7672);
arglist__7672 = cljs.core.next(arglist__7672);
var y = cljs.core.first(arglist__7672);
arglist__7672 = cljs.core.next(arglist__7672);
var z = cljs.core.first(arglist__7672);
var args = cljs.core.rest(arglist__7672);
return G__7670__delegate(x,y,z,args);
});
G__7670.cljs$core$IFn$_invoke$arity$variadic = G__7670__delegate;
return G__7670;
})()
;
G__7669 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7669__0.call(this);
case 1:
return G__7669__1.call(this,x);
case 2:
return G__7669__2.call(this,x,y);
case 3:
return G__7669__3.call(this,x,y,z);
default:
var G__7673 = null;
if (arguments.length > 3) {
var G__7674__i = 0, G__7674__a = new Array(arguments.length -  3);
while (G__7674__i < G__7674__a.length) {G__7674__a[G__7674__i] = arguments[G__7674__i + 3]; ++G__7674__i;}
G__7673 = new cljs.core.IndexedSeq(G__7674__a,0);
}
return G__7669__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7669.cljs$lang$maxFixedArity = 3;
G__7669.cljs$lang$applyTo = G__7669__4.cljs$lang$applyTo;
G__7669.cljs$core$IFn$_invoke$arity$0 = G__7669__0;
G__7669.cljs$core$IFn$_invoke$arity$1 = G__7669__1;
G__7669.cljs$core$IFn$_invoke$arity$2 = G__7669__2;
G__7669.cljs$core$IFn$_invoke$arity$3 = G__7669__3;
G__7669.cljs$core$IFn$_invoke$arity$variadic = G__7669__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7669;
})()
});
var cljs$core$partial__4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__7675 = null;
var G__7675__0 = (function (){
var G__7645 = arg1;
var G__7646 = arg2;
var G__7647 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7645,G__7646,G__7647) : f.call(null,G__7645,G__7646,G__7647));
});
var G__7675__1 = (function (x){
var G__7648 = arg1;
var G__7649 = arg2;
var G__7650 = arg3;
var G__7651 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7648,G__7649,G__7650,G__7651) : f.call(null,G__7648,G__7649,G__7650,G__7651));
});
var G__7675__2 = (function (x,y){
var G__7652 = arg1;
var G__7653 = arg2;
var G__7654 = arg3;
var G__7655 = x;
var G__7656 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7652,G__7653,G__7654,G__7655,G__7656) : f.call(null,G__7652,G__7653,G__7654,G__7655,G__7656));
});
var G__7675__3 = (function (x,y,z){
var G__7657 = arg1;
var G__7658 = arg2;
var G__7659 = arg3;
var G__7660 = x;
var G__7661 = y;
var G__7662 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7657,G__7658,G__7659,G__7660,G__7661,G__7662) : f.call(null,G__7657,G__7658,G__7659,G__7660,G__7661,G__7662));
});
var G__7675__4 = (function() { 
var G__7676__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__7676 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7677__i = 0, G__7677__a = new Array(arguments.length -  3);
while (G__7677__i < G__7677__a.length) {G__7677__a[G__7677__i] = arguments[G__7677__i + 3]; ++G__7677__i;}
  args = new cljs.core.IndexedSeq(G__7677__a,0);
} 
return G__7676__delegate.call(this,x,y,z,args);};
G__7676.cljs$lang$maxFixedArity = 3;
G__7676.cljs$lang$applyTo = (function (arglist__7678){
var x = cljs.core.first(arglist__7678);
arglist__7678 = cljs.core.next(arglist__7678);
var y = cljs.core.first(arglist__7678);
arglist__7678 = cljs.core.next(arglist__7678);
var z = cljs.core.first(arglist__7678);
var args = cljs.core.rest(arglist__7678);
return G__7676__delegate(x,y,z,args);
});
G__7676.cljs$core$IFn$_invoke$arity$variadic = G__7676__delegate;
return G__7676;
})()
;
G__7675 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7675__0.call(this);
case 1:
return G__7675__1.call(this,x);
case 2:
return G__7675__2.call(this,x,y);
case 3:
return G__7675__3.call(this,x,y,z);
default:
var G__7679 = null;
if (arguments.length > 3) {
var G__7680__i = 0, G__7680__a = new Array(arguments.length -  3);
while (G__7680__i < G__7680__a.length) {G__7680__a[G__7680__i] = arguments[G__7680__i + 3]; ++G__7680__i;}
G__7679 = new cljs.core.IndexedSeq(G__7680__a,0);
}
return G__7675__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7675.cljs$lang$maxFixedArity = 3;
G__7675.cljs$lang$applyTo = G__7675__4.cljs$lang$applyTo;
G__7675.cljs$core$IFn$_invoke$arity$0 = G__7675__0;
G__7675.cljs$core$IFn$_invoke$arity$1 = G__7675__1;
G__7675.cljs$core$IFn$_invoke$arity$2 = G__7675__2;
G__7675.cljs$core$IFn$_invoke$arity$3 = G__7675__3;
G__7675.cljs$core$IFn$_invoke$arity$variadic = G__7675__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7675;
})()
});
var cljs$core$partial__5 = (function() { 
var G__7681__delegate = function (f,arg1,arg2,arg3,more){
return (function() { 
var G__7682__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__7682 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7683__i = 0, G__7683__a = new Array(arguments.length -  0);
while (G__7683__i < G__7683__a.length) {G__7683__a[G__7683__i] = arguments[G__7683__i + 0]; ++G__7683__i;}
  args = new cljs.core.IndexedSeq(G__7683__a,0);
} 
return G__7682__delegate.call(this,args);};
G__7682.cljs$lang$maxFixedArity = 0;
G__7682.cljs$lang$applyTo = (function (arglist__7684){
var args = cljs.core.seq(arglist__7684);
return G__7682__delegate(args);
});
G__7682.cljs$core$IFn$_invoke$arity$variadic = G__7682__delegate;
return G__7682;
})()
;
};
var G__7681 = function (f,arg1,arg2,arg3,var_args){
var more = null;
if (arguments.length > 4) {
var G__7685__i = 0, G__7685__a = new Array(arguments.length -  4);
while (G__7685__i < G__7685__a.length) {G__7685__a[G__7685__i] = arguments[G__7685__i + 4]; ++G__7685__i;}
  more = new cljs.core.IndexedSeq(G__7685__a,0);
} 
return G__7681__delegate.call(this,f,arg1,arg2,arg3,more);};
G__7681.cljs$lang$maxFixedArity = 4;
G__7681.cljs$lang$applyTo = (function (arglist__7686){
var f = cljs.core.first(arglist__7686);
arglist__7686 = cljs.core.next(arglist__7686);
var arg1 = cljs.core.first(arglist__7686);
arglist__7686 = cljs.core.next(arglist__7686);
var arg2 = cljs.core.first(arglist__7686);
arglist__7686 = cljs.core.next(arglist__7686);
var arg3 = cljs.core.first(arglist__7686);
var more = cljs.core.rest(arglist__7686);
return G__7681__delegate(f,arg1,arg2,arg3,more);
});
G__7681.cljs$core$IFn$_invoke$arity$variadic = G__7681__delegate;
return G__7681;
})()
;
cljs$core$partial = function(f,arg1,arg2,arg3,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$partial__1.call(this,f);
case 2:
return cljs$core$partial__2.call(this,f,arg1);
case 3:
return cljs$core$partial__3.call(this,f,arg1,arg2);
case 4:
return cljs$core$partial__4.call(this,f,arg1,arg2,arg3);
default:
var G__7687 = null;
if (arguments.length > 4) {
var G__7688__i = 0, G__7688__a = new Array(arguments.length -  4);
while (G__7688__i < G__7688__a.length) {G__7688__a[G__7688__i] = arguments[G__7688__i + 4]; ++G__7688__i;}
G__7687 = new cljs.core.IndexedSeq(G__7688__a,0);
}
return cljs$core$partial__5.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3, G__7687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partial.cljs$lang$maxFixedArity = 4;
cljs$core$partial.cljs$lang$applyTo = cljs$core$partial__5.cljs$lang$applyTo;
cljs$core$partial.cljs$core$IFn$_invoke$arity$1 = cljs$core$partial__1;
cljs$core$partial.cljs$core$IFn$_invoke$arity$2 = cljs$core$partial__2;
cljs$core$partial.cljs$core$IFn$_invoke$arity$3 = cljs$core$partial__3;
cljs$core$partial.cljs$core$IFn$_invoke$arity$4 = cljs$core$partial__4;
cljs$core$partial.cljs$core$IFn$_invoke$arity$variadic = cljs$core$partial__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$partial;
})()
;
/**
 * Takes a function f, and returns a function that calls f, replacing
 * a nil first argument to f with the supplied value x. Higher arity
 * versions can replace arguments in the second and third
 * positions (y, z). Note that the function f can take any number of
 * arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function() {
var cljs$core$fnil = null;
var cljs$core$fnil__2 = (function (f,x){
return (function() {
var G__7721 = null;
var G__7721__1 = (function (a){
var G__7705 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7705) : f.call(null,G__7705));
});
var G__7721__2 = (function (a,b){
var G__7706 = (((a == null))?x:a);
var G__7707 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7706,G__7707) : f.call(null,G__7706,G__7707));
});
var G__7721__3 = (function (a,b,c){
var G__7708 = (((a == null))?x:a);
var G__7709 = b;
var G__7710 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7708,G__7709,G__7710) : f.call(null,G__7708,G__7709,G__7710));
});
var G__7721__4 = (function() { 
var G__7722__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__7722 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7723__i = 0, G__7723__a = new Array(arguments.length -  3);
while (G__7723__i < G__7723__a.length) {G__7723__a[G__7723__i] = arguments[G__7723__i + 3]; ++G__7723__i;}
  ds = new cljs.core.IndexedSeq(G__7723__a,0);
} 
return G__7722__delegate.call(this,a,b,c,ds);};
G__7722.cljs$lang$maxFixedArity = 3;
G__7722.cljs$lang$applyTo = (function (arglist__7724){
var a = cljs.core.first(arglist__7724);
arglist__7724 = cljs.core.next(arglist__7724);
var b = cljs.core.first(arglist__7724);
arglist__7724 = cljs.core.next(arglist__7724);
var c = cljs.core.first(arglist__7724);
var ds = cljs.core.rest(arglist__7724);
return G__7722__delegate(a,b,c,ds);
});
G__7722.cljs$core$IFn$_invoke$arity$variadic = G__7722__delegate;
return G__7722;
})()
;
G__7721 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__7721__1.call(this,a);
case 2:
return G__7721__2.call(this,a,b);
case 3:
return G__7721__3.call(this,a,b,c);
default:
var G__7725 = null;
if (arguments.length > 3) {
var G__7726__i = 0, G__7726__a = new Array(arguments.length -  3);
while (G__7726__i < G__7726__a.length) {G__7726__a[G__7726__i] = arguments[G__7726__i + 3]; ++G__7726__i;}
G__7725 = new cljs.core.IndexedSeq(G__7726__a,0);
}
return G__7721__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7721.cljs$lang$maxFixedArity = 3;
G__7721.cljs$lang$applyTo = G__7721__4.cljs$lang$applyTo;
G__7721.cljs$core$IFn$_invoke$arity$1 = G__7721__1;
G__7721.cljs$core$IFn$_invoke$arity$2 = G__7721__2;
G__7721.cljs$core$IFn$_invoke$arity$3 = G__7721__3;
G__7721.cljs$core$IFn$_invoke$arity$variadic = G__7721__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7721;
})()
});
var cljs$core$fnil__3 = (function (f,x,y){
return (function() {
var G__7727 = null;
var G__7727__2 = (function (a,b){
var G__7711 = (((a == null))?x:a);
var G__7712 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7711,G__7712) : f.call(null,G__7711,G__7712));
});
var G__7727__3 = (function (a,b,c){
var G__7713 = (((a == null))?x:a);
var G__7714 = (((b == null))?y:b);
var G__7715 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7713,G__7714,G__7715) : f.call(null,G__7713,G__7714,G__7715));
});
var G__7727__4 = (function() { 
var G__7728__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__7728 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7729__i = 0, G__7729__a = new Array(arguments.length -  3);
while (G__7729__i < G__7729__a.length) {G__7729__a[G__7729__i] = arguments[G__7729__i + 3]; ++G__7729__i;}
  ds = new cljs.core.IndexedSeq(G__7729__a,0);
} 
return G__7728__delegate.call(this,a,b,c,ds);};
G__7728.cljs$lang$maxFixedArity = 3;
G__7728.cljs$lang$applyTo = (function (arglist__7730){
var a = cljs.core.first(arglist__7730);
arglist__7730 = cljs.core.next(arglist__7730);
var b = cljs.core.first(arglist__7730);
arglist__7730 = cljs.core.next(arglist__7730);
var c = cljs.core.first(arglist__7730);
var ds = cljs.core.rest(arglist__7730);
return G__7728__delegate(a,b,c,ds);
});
G__7728.cljs$core$IFn$_invoke$arity$variadic = G__7728__delegate;
return G__7728;
})()
;
G__7727 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__7727__2.call(this,a,b);
case 3:
return G__7727__3.call(this,a,b,c);
default:
var G__7731 = null;
if (arguments.length > 3) {
var G__7732__i = 0, G__7732__a = new Array(arguments.length -  3);
while (G__7732__i < G__7732__a.length) {G__7732__a[G__7732__i] = arguments[G__7732__i + 3]; ++G__7732__i;}
G__7731 = new cljs.core.IndexedSeq(G__7732__a,0);
}
return G__7727__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7727.cljs$lang$maxFixedArity = 3;
G__7727.cljs$lang$applyTo = G__7727__4.cljs$lang$applyTo;
G__7727.cljs$core$IFn$_invoke$arity$2 = G__7727__2;
G__7727.cljs$core$IFn$_invoke$arity$3 = G__7727__3;
G__7727.cljs$core$IFn$_invoke$arity$variadic = G__7727__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7727;
})()
});
var cljs$core$fnil__4 = (function (f,x,y,z){
return (function() {
var G__7733 = null;
var G__7733__2 = (function (a,b){
var G__7716 = (((a == null))?x:a);
var G__7717 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7716,G__7717) : f.call(null,G__7716,G__7717));
});
var G__7733__3 = (function (a,b,c){
var G__7718 = (((a == null))?x:a);
var G__7719 = (((b == null))?y:b);
var G__7720 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7718,G__7719,G__7720) : f.call(null,G__7718,G__7719,G__7720));
});
var G__7733__4 = (function() { 
var G__7734__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__7734 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7735__i = 0, G__7735__a = new Array(arguments.length -  3);
while (G__7735__i < G__7735__a.length) {G__7735__a[G__7735__i] = arguments[G__7735__i + 3]; ++G__7735__i;}
  ds = new cljs.core.IndexedSeq(G__7735__a,0);
} 
return G__7734__delegate.call(this,a,b,c,ds);};
G__7734.cljs$lang$maxFixedArity = 3;
G__7734.cljs$lang$applyTo = (function (arglist__7736){
var a = cljs.core.first(arglist__7736);
arglist__7736 = cljs.core.next(arglist__7736);
var b = cljs.core.first(arglist__7736);
arglist__7736 = cljs.core.next(arglist__7736);
var c = cljs.core.first(arglist__7736);
var ds = cljs.core.rest(arglist__7736);
return G__7734__delegate(a,b,c,ds);
});
G__7734.cljs$core$IFn$_invoke$arity$variadic = G__7734__delegate;
return G__7734;
})()
;
G__7733 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__7733__2.call(this,a,b);
case 3:
return G__7733__3.call(this,a,b,c);
default:
var G__7737 = null;
if (arguments.length > 3) {
var G__7738__i = 0, G__7738__a = new Array(arguments.length -  3);
while (G__7738__i < G__7738__a.length) {G__7738__a[G__7738__i] = arguments[G__7738__i + 3]; ++G__7738__i;}
G__7737 = new cljs.core.IndexedSeq(G__7738__a,0);
}
return G__7733__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7733.cljs$lang$maxFixedArity = 3;
G__7733.cljs$lang$applyTo = G__7733__4.cljs$lang$applyTo;
G__7733.cljs$core$IFn$_invoke$arity$2 = G__7733__2;
G__7733.cljs$core$IFn$_invoke$arity$3 = G__7733__3;
G__7733.cljs$core$IFn$_invoke$arity$variadic = G__7733__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7733;
})()
});
cljs$core$fnil = function(f,x,y,z){
switch(arguments.length){
case 2:
return cljs$core$fnil__2.call(this,f,x);
case 3:
return cljs$core$fnil__3.call(this,f,x,y);
case 4:
return cljs$core$fnil__4.call(this,f,x,y,z);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fnil.cljs$core$IFn$_invoke$arity$2 = cljs$core$fnil__2;
cljs$core$fnil.cljs$core$IFn$_invoke$arity$3 = cljs$core$fnil__3;
cljs$core$fnil.cljs$core$IFn$_invoke$arity$4 = cljs$core$fnil__4;
return cljs$core$fnil;
})()
;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 * and the first item of coll, followed by applying f to 1 and the second
 * item in coll, etc, until coll is exhausted. Thus function f should
 * accept 2 arguments, index and item.
 */
cljs.core.map_indexed = (function() {
var cljs$core$map_indexed = null;
var cljs$core$map_indexed__1 = (function (f){
return (function (rf){
var i = (function (){var G__7769 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__7769) : cljs.core.volatile_BANG_.call(null,G__7769));
})();
return ((function (i){
return (function() {
var G__7799 = null;
var G__7799__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7799__1 = (function (result){
var G__7770 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7770) : rf.call(null,G__7770));
});
var G__7799__2 = (function (result,input){
var G__7771 = result;
var G__7772 = (function (){var G__7773 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__7774 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7773,G__7774) : f.call(null,G__7773,G__7774));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7771,G__7772) : rf.call(null,G__7771,G__7772));
});
G__7799 = function(result,input){
switch(arguments.length){
case 0:
return G__7799__0.call(this);
case 1:
return G__7799__1.call(this,result);
case 2:
return G__7799__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7799.cljs$core$IFn$_invoke$arity$0 = G__7799__0;
G__7799.cljs$core$IFn$_invoke$arity$1 = G__7799__1;
G__7799.cljs$core$IFn$_invoke$arity$2 = G__7799__2;
return G__7799;
})()
;})(i))
});
});
var cljs$core$map_indexed__2 = (function (f,coll){
var mapi = (function cljs$core$map_indexed_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4625__auto___7800 = size;
var i_7801 = (0);
while(true){
if((i_7801 < n__4625__auto___7800)){
cljs.core.chunk_append(b,(function (){var G__7795 = (idx + i_7801);
var G__7796 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7801);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7795,G__7796) : f.call(null,G__7795,G__7796));
})());

var G__7802 = (i_7801 + (1));
i_7801 = G__7802;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$map_indexed_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__7797 = idx;
var G__7798 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7797,G__7798) : f.call(null,G__7797,G__7798));
})(),cljs$core$map_indexed_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});
cljs$core$map_indexed = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$map_indexed__1.call(this,f);
case 2:
return cljs$core$map_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$map_indexed.cljs$core$IFn$_invoke$arity$1 = cljs$core$map_indexed__1;
cljs$core$map_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$map_indexed__2;
return cljs$core$map_indexed;
})()
;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function() {
var cljs$core$keep = null;
var cljs$core$keep__1 = (function (f){
return (function (rf){
return (function() {
var G__7821 = null;
var G__7821__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7821__1 = (function (result){
var G__7815 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7815) : rf.call(null,G__7815));
});
var G__7821__2 = (function (result,input){
var v = (function (){var G__7816 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7816) : f.call(null,G__7816));
})();
if((v == null)){
return result;
} else {
var G__7817 = result;
var G__7818 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7817,G__7818) : rf.call(null,G__7817,G__7818));
}
});
G__7821 = function(result,input){
switch(arguments.length){
case 0:
return G__7821__0.call(this);
case 1:
return G__7821__1.call(this,result);
case 2:
return G__7821__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7821.cljs$core$IFn$_invoke$arity$0 = G__7821__0;
G__7821.cljs$core$IFn$_invoke$arity$1 = G__7821__1;
G__7821.cljs$core$IFn$_invoke$arity$2 = G__7821__2;
return G__7821;
})()
});
});
var cljs$core$keep__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4625__auto___7822 = size;
var i_7823 = (0);
while(true){
if((i_7823 < n__4625__auto___7822)){
var x_7824 = (function (){var G__7819 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7823);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7819) : f.call(null,G__7819));
})();
if((x_7824 == null)){
} else {
cljs.core.chunk_append(b,x_7824);
}

var G__7825 = (i_7823 + (1));
i_7823 = G__7825;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__7820 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7820) : f.call(null,G__7820));
})();
if((x == null)){
return cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
cljs$core$keep = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$keep__1.call(this,f);
case 2:
return cljs$core$keep__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keep.cljs$core$IFn$_invoke$arity$1 = cljs$core$keep__1;
cljs$core$keep.cljs$core$IFn$_invoke$arity$2 = cljs$core$keep__2;
return cljs$core$keep;
})()
;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
this.cljs$lang$protocol_mask$partition1$ = 16386;
})
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__7826 = this$__$1;
return goog.getUid(G__7826);
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__7827 = cljs.core.seq(self__.watches);
var chunk__7828 = null;
var count__7829 = (0);
var i__7830 = (0);
while(true){
if((i__7830 < count__7829)){
var vec__7831 = chunk__7828.cljs$core$IIndexed$_nth$arity$2(null,i__7830);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7831,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7831,(1),null);
var G__7832_7841 = key;
var G__7833_7842 = this$__$1;
var G__7834_7843 = oldval;
var G__7835_7844 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7832_7841,G__7833_7842,G__7834_7843,G__7835_7844) : f.call(null,G__7832_7841,G__7833_7842,G__7834_7843,G__7835_7844));

var G__7845 = seq__7827;
var G__7846 = chunk__7828;
var G__7847 = count__7829;
var G__7848 = (i__7830 + (1));
seq__7827 = G__7845;
chunk__7828 = G__7846;
count__7829 = G__7847;
i__7830 = G__7848;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__7827);
if(temp__4126__auto__){
var seq__7827__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7827__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__7827__$1);
var G__7849 = cljs.core.chunk_rest(seq__7827__$1);
var G__7850 = c__4525__auto__;
var G__7851 = cljs.core.count(c__4525__auto__);
var G__7852 = (0);
seq__7827 = G__7849;
chunk__7828 = G__7850;
count__7829 = G__7851;
i__7830 = G__7852;
continue;
} else {
var vec__7836 = cljs.core.first(seq__7827__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7836,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7836,(1),null);
var G__7837_7853 = key;
var G__7838_7854 = this$__$1;
var G__7839_7855 = oldval;
var G__7840_7856 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7837_7853,G__7838_7854,G__7839_7855,G__7840_7856) : f.call(null,G__7837_7853,G__7838_7854,G__7839_7855,G__7840_7856));

var G__7857 = cljs.core.next(seq__7827__$1);
var G__7858 = null;
var G__7859 = (0);
var G__7860 = (0);
seq__7827 = G__7857;
chunk__7828 = G__7858;
count__7829 = G__7859;
i__7830 = G__7860;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 * more options (in any order):
 * 
 * :meta metadata-map
 * 
 * :validator validate-fn
 * 
 * If metadata-map is supplied, it will be come the metadata on the
 * atom. validate-fn must be nil or a side-effect-free fn of one
 * argument, which will be passed the intended new state on any state
 * change. If the new state is unacceptable, the validate-fn should
 * return false or throw an Error.  If either of these error conditions
 * occur, then the value of the atom will not change.
 * @param {...*} var_args
 */
cljs.core.atom = (function() {
var cljs$core$atom = null;
var cljs$core$atom__1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});
var cljs$core$atom__2 = (function() { 
var G__7864__delegate = function (x,p__7861){
var map__7863 = p__7861;
var map__7863__$1 = ((cljs.core.seq_QMARK_(map__7863))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__7863):map__7863);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7863__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7863__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
return (new cljs.core.Atom(x,meta,validator,null));
};
var G__7864 = function (x,var_args){
var p__7861 = null;
if (arguments.length > 1) {
var G__7865__i = 0, G__7865__a = new Array(arguments.length -  1);
while (G__7865__i < G__7865__a.length) {G__7865__a[G__7865__i] = arguments[G__7865__i + 1]; ++G__7865__i;}
  p__7861 = new cljs.core.IndexedSeq(G__7865__a,0);
} 
return G__7864__delegate.call(this,x,p__7861);};
G__7864.cljs$lang$maxFixedArity = 1;
G__7864.cljs$lang$applyTo = (function (arglist__7866){
var x = cljs.core.first(arglist__7866);
var p__7861 = cljs.core.rest(arglist__7866);
return G__7864__delegate(x,p__7861);
});
G__7864.cljs$core$IFn$_invoke$arity$variadic = G__7864__delegate;
return G__7864;
})()
;
cljs$core$atom = function(x,var_args){
var p__7861 = var_args;
switch(arguments.length){
case 1:
return cljs$core$atom__1.call(this,x);
default:
var G__7867 = null;
if (arguments.length > 1) {
var G__7868__i = 0, G__7868__a = new Array(arguments.length -  1);
while (G__7868__i < G__7868__a.length) {G__7868__a[G__7868__i] = arguments[G__7868__i + 1]; ++G__7868__i;}
G__7867 = new cljs.core.IndexedSeq(G__7868__a,0);
}
return cljs$core$atom__2.cljs$core$IFn$_invoke$arity$variadic(x, G__7867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$atom.cljs$lang$maxFixedArity = 1;
cljs$core$atom.cljs$lang$applyTo = cljs$core$atom__2.cljs$lang$applyTo;
cljs$core$atom.cljs$core$IFn$_invoke$arity$1 = cljs$core$atom__1;
cljs$core$atom.cljs$core$IFn$_invoke$arity$variadic = cljs$core$atom__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$atom;
})()
;
/**
 * Sets the value of atom to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__7871 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__7871) : validate.call(null,G__7871));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__7872 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__7872) : cljs.core.pr_str.call(null,G__7872));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 * (apply f current-value-of-atom args). Note that f may be called
 * multiple times, and thus should be free of side effects.  Returns
 * the value that was swapped in.
 * @param {...*} var_args
 */
cljs.core.swap_BANG_ = (function() {
var cljs$core$swap_BANG_ = null;
var cljs$core$swap_BANG___2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7879 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7879) : f.call(null,G__7879));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});
var cljs$core$swap_BANG___3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7880 = a.state;
var G__7881 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7880,G__7881) : f.call(null,G__7880,G__7881));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});
var cljs$core$swap_BANG___4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7882 = a.state;
var G__7883 = x;
var G__7884 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7882,G__7883,G__7884) : f.call(null,G__7882,G__7883,G__7884));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});
var cljs$core$swap_BANG___5 = (function() { 
var G__7885__delegate = function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
};
var G__7885 = function (a,f,x,y,var_args){
var more = null;
if (arguments.length > 4) {
var G__7886__i = 0, G__7886__a = new Array(arguments.length -  4);
while (G__7886__i < G__7886__a.length) {G__7886__a[G__7886__i] = arguments[G__7886__i + 4]; ++G__7886__i;}
  more = new cljs.core.IndexedSeq(G__7886__a,0);
} 
return G__7885__delegate.call(this,a,f,x,y,more);};
G__7885.cljs$lang$maxFixedArity = 4;
G__7885.cljs$lang$applyTo = (function (arglist__7887){
var a = cljs.core.first(arglist__7887);
arglist__7887 = cljs.core.next(arglist__7887);
var f = cljs.core.first(arglist__7887);
arglist__7887 = cljs.core.next(arglist__7887);
var x = cljs.core.first(arglist__7887);
arglist__7887 = cljs.core.next(arglist__7887);
var y = cljs.core.first(arglist__7887);
var more = cljs.core.rest(arglist__7887);
return G__7885__delegate(a,f,x,y,more);
});
G__7885.cljs$core$IFn$_invoke$arity$variadic = G__7885__delegate;
return G__7885;
})()
;
cljs$core$swap_BANG_ = function(a,f,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$swap_BANG___2.call(this,a,f);
case 3:
return cljs$core$swap_BANG___3.call(this,a,f,x);
case 4:
return cljs$core$swap_BANG___4.call(this,a,f,x,y);
default:
var G__7888 = null;
if (arguments.length > 4) {
var G__7889__i = 0, G__7889__a = new Array(arguments.length -  4);
while (G__7889__i < G__7889__a.length) {G__7889__a[G__7889__i] = arguments[G__7889__i + 4]; ++G__7889__i;}
G__7888 = new cljs.core.IndexedSeq(G__7889__a,0);
}
return cljs$core$swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic(a,f,x,y, G__7888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs$core$swap_BANG_.cljs$lang$applyTo = cljs$core$swap_BANG___5.cljs$lang$applyTo;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$swap_BANG___2;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$swap_BANG___3;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$4 = cljs$core$swap_BANG___4;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$swap_BANG_;
})()
;
/**
 * Atomically sets the value of atom to newval if and only if the
 * current value of the atom is equal to oldval. Returns true if
 * set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 * side-effect-free fn of one argument, which will be passed the intended
 * new state on any state change. If the new state is unacceptable, the
 * validator-fn should return false or throw an Error. If the current state
 * is not acceptable to the new validator, an Error will be thrown and the
 * validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a stateful transducer when no collection is
 * provided.
 */
cljs.core.keep_indexed = (function() {
var cljs$core$keep_indexed = null;
var cljs$core$keep_indexed__1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__7956 = null;
var G__7956__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7956__1 = (function (result){
var G__7923 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7923) : rf.call(null,G__7923));
});
var G__7956__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (function (){var G__7924 = i;
var G__7925 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7924,G__7925) : f.call(null,G__7924,G__7925));
})();
if((v == null)){
return result;
} else {
var G__7926 = result;
var G__7927 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7926,G__7927) : rf.call(null,G__7926,G__7927));
}
});
G__7956 = function(result,input){
switch(arguments.length){
case 0:
return G__7956__0.call(this);
case 1:
return G__7956__1.call(this,result);
case 2:
return G__7956__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7956.cljs$core$IFn$_invoke$arity$0 = G__7956__0;
G__7956.cljs$core$IFn$_invoke$arity$1 = G__7956__1;
G__7956.cljs$core$IFn$_invoke$arity$2 = G__7956__2;
return G__7956;
})()
;})(ia))
});
});
var cljs$core$keep_indexed__2 = (function (f,coll){
var keepi = (function cljs$core$keep_indexed_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4625__auto___7957 = size;
var i_7958 = (0);
while(true){
if((i_7958 < n__4625__auto___7957)){
var x_7959 = (function (){var G__7952 = (idx + i_7958);
var G__7953 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7958);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7952,G__7953) : f.call(null,G__7952,G__7953));
})();
if((x_7959 == null)){
} else {
cljs.core.chunk_append(b,x_7959);
}

var G__7960 = (i_7958 + (1));
i_7958 = G__7960;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keep_indexed_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__7954 = idx;
var G__7955 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7954,G__7955) : f.call(null,G__7954,G__7955));
})();
if((x == null)){
return cljs$core$keep_indexed_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keep_indexed_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});
cljs$core$keep_indexed = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$keep_indexed__1.call(this,f);
case 2:
return cljs$core$keep_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keep_indexed.cljs$core$IFn$_invoke$arity$1 = cljs$core$keep_indexed__1;
cljs$core$keep_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$keep_indexed__2;
return cljs$core$keep_indexed;
})()
;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 * composing predicates return a logical true value against all of its arguments, else it returns
 * false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical false result against the original predicates.
 * @param {...*} var_args
 */
cljs.core.every_pred = (function() {
var cljs$core$every_pred = null;
var cljs$core$every_pred__1 = (function (p){
return (function() {
var cljs$core$every_pred_$_ep1 = null;
var cljs$core$every_pred_$_ep1__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__8174 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8174) : p.call(null,G__8174));
})());
});
var cljs$core$every_pred_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8176 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8176) : p.call(null,G__8176));
})();
if(cljs.core.truth_(and__3728__auto__)){
var G__8177 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8177) : p.call(null,G__8177));
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8179 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8179) : p.call(null,G__8179));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8181 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8181) : p.call(null,G__8181));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var G__8182 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8182) : p.call(null,G__8182));
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep1__4 = (function() { 
var G__8351__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(p,args)));
};
var G__8351 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8352__i = 0, G__8352__a = new Array(arguments.length -  3);
while (G__8352__i < G__8352__a.length) {G__8352__a[G__8352__i] = arguments[G__8352__i + 3]; ++G__8352__i;}
  args = new cljs.core.IndexedSeq(G__8352__a,0);
} 
return G__8351__delegate.call(this,x,y,z,args);};
G__8351.cljs$lang$maxFixedArity = 3;
G__8351.cljs$lang$applyTo = (function (arglist__8353){
var x = cljs.core.first(arglist__8353);
arglist__8353 = cljs.core.next(arglist__8353);
var y = cljs.core.first(arglist__8353);
arglist__8353 = cljs.core.next(arglist__8353);
var z = cljs.core.first(arglist__8353);
var args = cljs.core.rest(arglist__8353);
return G__8351__delegate(x,y,z,args);
});
G__8351.cljs$core$IFn$_invoke$arity$variadic = G__8351__delegate;
return G__8351;
})()
;
cljs$core$every_pred_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep1__0.call(this);
case 1:
return cljs$core$every_pred_$_ep1__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep1__3.call(this,x,y,z);
default:
var G__8354 = null;
if (arguments.length > 3) {
var G__8355__i = 0, G__8355__a = new Array(arguments.length -  3);
while (G__8355__i < G__8355__a.length) {G__8355__a[G__8355__i] = arguments[G__8355__i + 3]; ++G__8355__i;}
G__8354 = new cljs.core.IndexedSeq(G__8355__a,0);
}
return cljs$core$every_pred_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep1.cljs$lang$applyTo = cljs$core$every_pred_$_ep1__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep1__0;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep1__1;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep1__2;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep1__3;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep1;
})()
});
var cljs$core$every_pred__2 = (function (p1,p2){
return (function() {
var cljs$core$every_pred_$_ep2 = null;
var cljs$core$every_pred_$_ep2__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8214 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8214) : p1.call(null,G__8214));
})();
if(cljs.core.truth_(and__3728__auto__)){
var G__8215 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8215) : p2.call(null,G__8215));
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8217 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8217) : p1.call(null,G__8217));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8219 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8219) : p1.call(null,G__8219));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var and__3728__auto____$2 = (function (){var G__8221 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8221) : p2.call(null,G__8221));
})();
if(cljs.core.truth_(and__3728__auto____$2)){
var G__8222 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8222) : p2.call(null,G__8222));
} else {
return and__3728__auto____$2;
}
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8224 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8224) : p1.call(null,G__8224));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8226 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8226) : p1.call(null,G__8226));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var and__3728__auto____$2 = (function (){var G__8228 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8228) : p1.call(null,G__8228));
})();
if(cljs.core.truth_(and__3728__auto____$2)){
var and__3728__auto____$3 = (function (){var G__8230 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8230) : p2.call(null,G__8230));
})();
if(cljs.core.truth_(and__3728__auto____$3)){
var and__3728__auto____$4 = (function (){var G__8232 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8232) : p2.call(null,G__8232));
})();
if(cljs.core.truth_(and__3728__auto____$4)){
var G__8233 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8233) : p2.call(null,G__8233));
} else {
return and__3728__auto____$4;
}
} else {
return and__3728__auto____$3;
}
} else {
return and__3728__auto____$2;
}
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__4 = (function() { 
var G__8356__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__7961_SHARP_){
var and__3728__auto__ = (function (){var G__8238 = p1__7961_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8238) : p1.call(null,G__8238));
})();
if(cljs.core.truth_(and__3728__auto__)){
var G__8239 = p1__7961_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8239) : p2.call(null,G__8239));
} else {
return and__3728__auto__;
}
}),args)));
};
var G__8356 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8357__i = 0, G__8357__a = new Array(arguments.length -  3);
while (G__8357__i < G__8357__a.length) {G__8357__a[G__8357__i] = arguments[G__8357__i + 3]; ++G__8357__i;}
  args = new cljs.core.IndexedSeq(G__8357__a,0);
} 
return G__8356__delegate.call(this,x,y,z,args);};
G__8356.cljs$lang$maxFixedArity = 3;
G__8356.cljs$lang$applyTo = (function (arglist__8358){
var x = cljs.core.first(arglist__8358);
arglist__8358 = cljs.core.next(arglist__8358);
var y = cljs.core.first(arglist__8358);
arglist__8358 = cljs.core.next(arglist__8358);
var z = cljs.core.first(arglist__8358);
var args = cljs.core.rest(arglist__8358);
return G__8356__delegate(x,y,z,args);
});
G__8356.cljs$core$IFn$_invoke$arity$variadic = G__8356__delegate;
return G__8356;
})()
;
cljs$core$every_pred_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep2__0.call(this);
case 1:
return cljs$core$every_pred_$_ep2__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep2__3.call(this,x,y,z);
default:
var G__8359 = null;
if (arguments.length > 3) {
var G__8360__i = 0, G__8360__a = new Array(arguments.length -  3);
while (G__8360__i < G__8360__a.length) {G__8360__a[G__8360__i] = arguments[G__8360__i + 3]; ++G__8360__i;}
G__8359 = new cljs.core.IndexedSeq(G__8360__a,0);
}
return cljs$core$every_pred_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep2.cljs$lang$applyTo = cljs$core$every_pred_$_ep2__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep2__0;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep2__1;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep2__2;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep2__3;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep2;
})()
});
var cljs$core$every_pred__3 = (function (p1,p2,p3){
return (function() {
var cljs$core$every_pred_$_ep3 = null;
var cljs$core$every_pred_$_ep3__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8285 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8285) : p1.call(null,G__8285));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8287 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8287) : p2.call(null,G__8287));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var G__8288 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8288) : p3.call(null,G__8288));
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8290 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8290) : p1.call(null,G__8290));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8292 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8292) : p2.call(null,G__8292));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var and__3728__auto____$2 = (function (){var G__8294 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8294) : p3.call(null,G__8294));
})();
if(cljs.core.truth_(and__3728__auto____$2)){
var and__3728__auto____$3 = (function (){var G__8296 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8296) : p1.call(null,G__8296));
})();
if(cljs.core.truth_(and__3728__auto____$3)){
var and__3728__auto____$4 = (function (){var G__8298 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8298) : p2.call(null,G__8298));
})();
if(cljs.core.truth_(and__3728__auto____$4)){
var G__8299 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8299) : p3.call(null,G__8299));
} else {
return and__3728__auto____$4;
}
} else {
return and__3728__auto____$3;
}
} else {
return and__3728__auto____$2;
}
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3728__auto__ = (function (){var G__8301 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8301) : p1.call(null,G__8301));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8303 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8303) : p2.call(null,G__8303));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var and__3728__auto____$2 = (function (){var G__8305 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8305) : p3.call(null,G__8305));
})();
if(cljs.core.truth_(and__3728__auto____$2)){
var and__3728__auto____$3 = (function (){var G__8307 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8307) : p1.call(null,G__8307));
})();
if(cljs.core.truth_(and__3728__auto____$3)){
var and__3728__auto____$4 = (function (){var G__8309 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8309) : p2.call(null,G__8309));
})();
if(cljs.core.truth_(and__3728__auto____$4)){
var and__3728__auto____$5 = (function (){var G__8311 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8311) : p3.call(null,G__8311));
})();
if(cljs.core.truth_(and__3728__auto____$5)){
var and__3728__auto____$6 = (function (){var G__8313 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8313) : p1.call(null,G__8313));
})();
if(cljs.core.truth_(and__3728__auto____$6)){
var and__3728__auto____$7 = (function (){var G__8315 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8315) : p2.call(null,G__8315));
})();
if(cljs.core.truth_(and__3728__auto____$7)){
var G__8316 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8316) : p3.call(null,G__8316));
} else {
return and__3728__auto____$7;
}
} else {
return and__3728__auto____$6;
}
} else {
return and__3728__auto____$5;
}
} else {
return and__3728__auto____$4;
}
} else {
return and__3728__auto____$3;
}
} else {
return and__3728__auto____$2;
}
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__4 = (function() { 
var G__8361__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__7962_SHARP_){
var and__3728__auto__ = (function (){var G__8323 = p1__7962_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8323) : p1.call(null,G__8323));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8325 = p1__7962_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8325) : p2.call(null,G__8325));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var G__8326 = p1__7962_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8326) : p3.call(null,G__8326));
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
}),args)));
};
var G__8361 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8362__i = 0, G__8362__a = new Array(arguments.length -  3);
while (G__8362__i < G__8362__a.length) {G__8362__a[G__8362__i] = arguments[G__8362__i + 3]; ++G__8362__i;}
  args = new cljs.core.IndexedSeq(G__8362__a,0);
} 
return G__8361__delegate.call(this,x,y,z,args);};
G__8361.cljs$lang$maxFixedArity = 3;
G__8361.cljs$lang$applyTo = (function (arglist__8363){
var x = cljs.core.first(arglist__8363);
arglist__8363 = cljs.core.next(arglist__8363);
var y = cljs.core.first(arglist__8363);
arglist__8363 = cljs.core.next(arglist__8363);
var z = cljs.core.first(arglist__8363);
var args = cljs.core.rest(arglist__8363);
return G__8361__delegate(x,y,z,args);
});
G__8361.cljs$core$IFn$_invoke$arity$variadic = G__8361__delegate;
return G__8361;
})()
;
cljs$core$every_pred_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep3__0.call(this);
case 1:
return cljs$core$every_pred_$_ep3__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep3__3.call(this,x,y,z);
default:
var G__8364 = null;
if (arguments.length > 3) {
var G__8365__i = 0, G__8365__a = new Array(arguments.length -  3);
while (G__8365__i < G__8365__a.length) {G__8365__a[G__8365__i] = arguments[G__8365__i + 3]; ++G__8365__i;}
G__8364 = new cljs.core.IndexedSeq(G__8365__a,0);
}
return cljs$core$every_pred_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep3.cljs$lang$applyTo = cljs$core$every_pred_$_ep3__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep3__0;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep3__1;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep3__2;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep3__3;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep3;
})()
});
var cljs$core$every_pred__4 = (function() { 
var G__8366__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$every_pred_$_epn = null;
var cljs$core$every_pred_$_epn__0 = (function (){
return true;
});
var cljs$core$every_pred_$_epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7963_SHARP_){
var G__8342 = x;
return (p1__7963_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7963_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8342) : p1__7963_SHARP_.call(null,G__8342));
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7964_SHARP_){
var and__3728__auto__ = (function (){var G__8344 = x;
return (p1__7964_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7964_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8344) : p1__7964_SHARP_.call(null,G__8344));
})();
if(cljs.core.truth_(and__3728__auto__)){
var G__8345 = y;
return (p1__7964_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7964_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8345) : p1__7964_SHARP_.call(null,G__8345));
} else {
return and__3728__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7965_SHARP_){
var and__3728__auto__ = (function (){var G__8347 = x;
return (p1__7965_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7965_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8347) : p1__7965_SHARP_.call(null,G__8347));
})();
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__8349 = y;
return (p1__7965_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7965_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8349) : p1__7965_SHARP_.call(null,G__8349));
})();
if(cljs.core.truth_(and__3728__auto____$1)){
var G__8350 = z;
return (p1__7965_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7965_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8350) : p1__7965_SHARP_.call(null,G__8350));
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__4 = (function() { 
var G__8367__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7966_SHARP_){
return cljs.core.every_QMARK_(p1__7966_SHARP_,args);
});})(ps__$1))
,ps__$1)));
};
var G__8367 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8368__i = 0, G__8368__a = new Array(arguments.length -  3);
while (G__8368__i < G__8368__a.length) {G__8368__a[G__8368__i] = arguments[G__8368__i + 3]; ++G__8368__i;}
  args = new cljs.core.IndexedSeq(G__8368__a,0);
} 
return G__8367__delegate.call(this,x,y,z,args);};
G__8367.cljs$lang$maxFixedArity = 3;
G__8367.cljs$lang$applyTo = (function (arglist__8369){
var x = cljs.core.first(arglist__8369);
arglist__8369 = cljs.core.next(arglist__8369);
var y = cljs.core.first(arglist__8369);
arglist__8369 = cljs.core.next(arglist__8369);
var z = cljs.core.first(arglist__8369);
var args = cljs.core.rest(arglist__8369);
return G__8367__delegate(x,y,z,args);
});
G__8367.cljs$core$IFn$_invoke$arity$variadic = G__8367__delegate;
return G__8367;
})()
;
cljs$core$every_pred_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_epn__0.call(this);
case 1:
return cljs$core$every_pred_$_epn__1.call(this,x);
case 2:
return cljs$core$every_pred_$_epn__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_epn__3.call(this,x,y,z);
default:
var G__8370 = null;
if (arguments.length > 3) {
var G__8371__i = 0, G__8371__a = new Array(arguments.length -  3);
while (G__8371__i < G__8371__a.length) {G__8371__a[G__8371__i] = arguments[G__8371__i + 3]; ++G__8371__i;}
G__8370 = new cljs.core.IndexedSeq(G__8371__a,0);
}
return cljs$core$every_pred_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_epn.cljs$lang$applyTo = cljs$core$every_pred_$_epn__4.cljs$lang$applyTo;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_epn__0;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_epn__1;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_epn__2;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_epn__3;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_epn;
})()
;})(ps__$1))
};
var G__8366 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__8372__i = 0, G__8372__a = new Array(arguments.length -  3);
while (G__8372__i < G__8372__a.length) {G__8372__a[G__8372__i] = arguments[G__8372__i + 3]; ++G__8372__i;}
  ps = new cljs.core.IndexedSeq(G__8372__a,0);
} 
return G__8366__delegate.call(this,p1,p2,p3,ps);};
G__8366.cljs$lang$maxFixedArity = 3;
G__8366.cljs$lang$applyTo = (function (arglist__8373){
var p1 = cljs.core.first(arglist__8373);
arglist__8373 = cljs.core.next(arglist__8373);
var p2 = cljs.core.first(arglist__8373);
arglist__8373 = cljs.core.next(arglist__8373);
var p3 = cljs.core.first(arglist__8373);
var ps = cljs.core.rest(arglist__8373);
return G__8366__delegate(p1,p2,p3,ps);
});
G__8366.cljs$core$IFn$_invoke$arity$variadic = G__8366__delegate;
return G__8366;
})()
;
cljs$core$every_pred = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return cljs$core$every_pred__1.call(this,p1);
case 2:
return cljs$core$every_pred__2.call(this,p1,p2);
case 3:
return cljs$core$every_pred__3.call(this,p1,p2,p3);
default:
var G__8374 = null;
if (arguments.length > 3) {
var G__8375__i = 0, G__8375__a = new Array(arguments.length -  3);
while (G__8375__i < G__8375__a.length) {G__8375__a[G__8375__i] = arguments[G__8375__i + 3]; ++G__8375__i;}
G__8374 = new cljs.core.IndexedSeq(G__8375__a,0);
}
return cljs$core$every_pred__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__8374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred.cljs$lang$applyTo = cljs$core$every_pred__4.cljs$lang$applyTo;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred__1;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred__2;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred__3;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred;
})()
;
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 * returned by one of its composing predicates against any of its arguments, else it returns
 * logical false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical true result against the original predicates.
 * @param {...*} var_args
 */
cljs.core.some_fn = (function() {
var cljs$core$some_fn = null;
var cljs$core$some_fn__1 = (function (p){
return (function() {
var cljs$core$some_fn_$_sp1 = null;
var cljs$core$some_fn_$_sp1__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp1__1 = (function (x){
var G__8581 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8581) : p.call(null,G__8581));
});
var cljs$core$some_fn_$_sp1__2 = (function (x,y){
var or__3740__auto__ = (function (){var G__8583 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8583) : p.call(null,G__8583));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var G__8584 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8584) : p.call(null,G__8584));
}
});
var cljs$core$some_fn_$_sp1__3 = (function (x,y,z){
var or__3740__auto__ = (function (){var G__8586 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8586) : p.call(null,G__8586));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (function (){var G__8588 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8588) : p.call(null,G__8588));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var G__8589 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8589) : p.call(null,G__8589));
}
}
});
var cljs$core$some_fn_$_sp1__4 = (function() { 
var G__8750__delegate = function (x,y,z,args){
var or__3740__auto__ = cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__8750 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8751__i = 0, G__8751__a = new Array(arguments.length -  3);
while (G__8751__i < G__8751__a.length) {G__8751__a[G__8751__i] = arguments[G__8751__i + 3]; ++G__8751__i;}
  args = new cljs.core.IndexedSeq(G__8751__a,0);
} 
return G__8750__delegate.call(this,x,y,z,args);};
G__8750.cljs$lang$maxFixedArity = 3;
G__8750.cljs$lang$applyTo = (function (arglist__8752){
var x = cljs.core.first(arglist__8752);
arglist__8752 = cljs.core.next(arglist__8752);
var y = cljs.core.first(arglist__8752);
arglist__8752 = cljs.core.next(arglist__8752);
var z = cljs.core.first(arglist__8752);
var args = cljs.core.rest(arglist__8752);
return G__8750__delegate(x,y,z,args);
});
G__8750.cljs$core$IFn$_invoke$arity$variadic = G__8750__delegate;
return G__8750;
})()
;
cljs$core$some_fn_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp1__0.call(this);
case 1:
return cljs$core$some_fn_$_sp1__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp1__3.call(this,x,y,z);
default:
var G__8753 = null;
if (arguments.length > 3) {
var G__8754__i = 0, G__8754__a = new Array(arguments.length -  3);
while (G__8754__i < G__8754__a.length) {G__8754__a[G__8754__i] = arguments[G__8754__i + 3]; ++G__8754__i;}
G__8753 = new cljs.core.IndexedSeq(G__8754__a,0);
}
return cljs$core$some_fn_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp1.cljs$lang$applyTo = cljs$core$some_fn_$_sp1__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp1__0;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp1__1;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp1__2;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp1__3;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp1;
})()
});
var cljs$core$some_fn__2 = (function (p1,p2){
return (function() {
var cljs$core$some_fn_$_sp2 = null;
var cljs$core$some_fn_$_sp2__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp2__1 = (function (x){
var or__3740__auto__ = (function (){var G__8621 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8621) : p1.call(null,G__8621));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var G__8622 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8622) : p2.call(null,G__8622));
}
});
var cljs$core$some_fn_$_sp2__2 = (function (x,y){
var or__3740__auto__ = (function (){var G__8624 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8624) : p1.call(null,G__8624));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (function (){var G__8626 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8626) : p1.call(null,G__8626));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var or__3740__auto____$2 = (function (){var G__8628 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8628) : p2.call(null,G__8628));
})();
if(cljs.core.truth_(or__3740__auto____$2)){
return or__3740__auto____$2;
} else {
var G__8629 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8629) : p2.call(null,G__8629));
}
}
}
});
var cljs$core$some_fn_$_sp2__3 = (function (x,y,z){
var or__3740__auto__ = (function (){var G__8631 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8631) : p1.call(null,G__8631));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (function (){var G__8633 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8633) : p1.call(null,G__8633));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var or__3740__auto____$2 = (function (){var G__8635 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8635) : p1.call(null,G__8635));
})();
if(cljs.core.truth_(or__3740__auto____$2)){
return or__3740__auto____$2;
} else {
var or__3740__auto____$3 = (function (){var G__8637 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8637) : p2.call(null,G__8637));
})();
if(cljs.core.truth_(or__3740__auto____$3)){
return or__3740__auto____$3;
} else {
var or__3740__auto____$4 = (function (){var G__8639 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8639) : p2.call(null,G__8639));
})();
if(cljs.core.truth_(or__3740__auto____$4)){
return or__3740__auto____$4;
} else {
var G__8640 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8640) : p2.call(null,G__8640));
}
}
}
}
}
});
var cljs$core$some_fn_$_sp2__4 = (function() { 
var G__8755__delegate = function (x,y,z,args){
var or__3740__auto__ = cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return cljs.core.some(((function (or__3740__auto__){
return (function (p1__8376_SHARP_){
var or__3740__auto____$1 = (function (){var G__8642 = p1__8376_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8642) : p1.call(null,G__8642));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var G__8643 = p1__8376_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8643) : p2.call(null,G__8643));
}
});})(or__3740__auto__))
,args);
}
};
var G__8755 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8756__i = 0, G__8756__a = new Array(arguments.length -  3);
while (G__8756__i < G__8756__a.length) {G__8756__a[G__8756__i] = arguments[G__8756__i + 3]; ++G__8756__i;}
  args = new cljs.core.IndexedSeq(G__8756__a,0);
} 
return G__8755__delegate.call(this,x,y,z,args);};
G__8755.cljs$lang$maxFixedArity = 3;
G__8755.cljs$lang$applyTo = (function (arglist__8757){
var x = cljs.core.first(arglist__8757);
arglist__8757 = cljs.core.next(arglist__8757);
var y = cljs.core.first(arglist__8757);
arglist__8757 = cljs.core.next(arglist__8757);
var z = cljs.core.first(arglist__8757);
var args = cljs.core.rest(arglist__8757);
return G__8755__delegate(x,y,z,args);
});
G__8755.cljs$core$IFn$_invoke$arity$variadic = G__8755__delegate;
return G__8755;
})()
;
cljs$core$some_fn_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp2__0.call(this);
case 1:
return cljs$core$some_fn_$_sp2__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp2__3.call(this,x,y,z);
default:
var G__8758 = null;
if (arguments.length > 3) {
var G__8759__i = 0, G__8759__a = new Array(arguments.length -  3);
while (G__8759__i < G__8759__a.length) {G__8759__a[G__8759__i] = arguments[G__8759__i + 3]; ++G__8759__i;}
G__8758 = new cljs.core.IndexedSeq(G__8759__a,0);
}
return cljs$core$some_fn_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp2.cljs$lang$applyTo = cljs$core$some_fn_$_sp2__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp2__0;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp2__1;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp2__2;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp2__3;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp2;
})()
});
var cljs$core$some_fn__3 = (function (p1,p2,p3){
return (function() {
var cljs$core$some_fn_$_sp3 = null;
var cljs$core$some_fn_$_sp3__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp3__1 = (function (x){
var or__3740__auto__ = (function (){var G__8689 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8689) : p1.call(null,G__8689));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (function (){var G__8691 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8691) : p2.call(null,G__8691));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var G__8692 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8692) : p3.call(null,G__8692));
}
}
});
var cljs$core$some_fn_$_sp3__2 = (function (x,y){
var or__3740__auto__ = (function (){var G__8694 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8694) : p1.call(null,G__8694));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (function (){var G__8696 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8696) : p2.call(null,G__8696));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var or__3740__auto____$2 = (function (){var G__8698 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8698) : p3.call(null,G__8698));
})();
if(cljs.core.truth_(or__3740__auto____$2)){
return or__3740__auto____$2;
} else {
var or__3740__auto____$3 = (function (){var G__8700 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8700) : p1.call(null,G__8700));
})();
if(cljs.core.truth_(or__3740__auto____$3)){
return or__3740__auto____$3;
} else {
var or__3740__auto____$4 = (function (){var G__8702 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8702) : p2.call(null,G__8702));
})();
if(cljs.core.truth_(or__3740__auto____$4)){
return or__3740__auto____$4;
} else {
var G__8703 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8703) : p3.call(null,G__8703));
}
}
}
}
}
});
var cljs$core$some_fn_$_sp3__3 = (function (x,y,z){
var or__3740__auto__ = (function (){var G__8705 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8705) : p1.call(null,G__8705));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (function (){var G__8707 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8707) : p2.call(null,G__8707));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var or__3740__auto____$2 = (function (){var G__8709 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8709) : p3.call(null,G__8709));
})();
if(cljs.core.truth_(or__3740__auto____$2)){
return or__3740__auto____$2;
} else {
var or__3740__auto____$3 = (function (){var G__8711 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8711) : p1.call(null,G__8711));
})();
if(cljs.core.truth_(or__3740__auto____$3)){
return or__3740__auto____$3;
} else {
var or__3740__auto____$4 = (function (){var G__8713 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8713) : p2.call(null,G__8713));
})();
if(cljs.core.truth_(or__3740__auto____$4)){
return or__3740__auto____$4;
} else {
var or__3740__auto____$5 = (function (){var G__8715 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8715) : p3.call(null,G__8715));
})();
if(cljs.core.truth_(or__3740__auto____$5)){
return or__3740__auto____$5;
} else {
var or__3740__auto____$6 = (function (){var G__8717 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8717) : p1.call(null,G__8717));
})();
if(cljs.core.truth_(or__3740__auto____$6)){
return or__3740__auto____$6;
} else {
var or__3740__auto____$7 = (function (){var G__8719 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8719) : p2.call(null,G__8719));
})();
if(cljs.core.truth_(or__3740__auto____$7)){
return or__3740__auto____$7;
} else {
var G__8720 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8720) : p3.call(null,G__8720));
}
}
}
}
}
}
}
}
});
var cljs$core$some_fn_$_sp3__4 = (function() { 
var G__8760__delegate = function (x,y,z,args){
var or__3740__auto__ = cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return cljs.core.some(((function (or__3740__auto__){
return (function (p1__8377_SHARP_){
var or__3740__auto____$1 = (function (){var G__8722 = p1__8377_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8722) : p1.call(null,G__8722));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var or__3740__auto____$2 = (function (){var G__8724 = p1__8377_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8724) : p2.call(null,G__8724));
})();
if(cljs.core.truth_(or__3740__auto____$2)){
return or__3740__auto____$2;
} else {
var G__8725 = p1__8377_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8725) : p3.call(null,G__8725));
}
}
});})(or__3740__auto__))
,args);
}
};
var G__8760 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8761__i = 0, G__8761__a = new Array(arguments.length -  3);
while (G__8761__i < G__8761__a.length) {G__8761__a[G__8761__i] = arguments[G__8761__i + 3]; ++G__8761__i;}
  args = new cljs.core.IndexedSeq(G__8761__a,0);
} 
return G__8760__delegate.call(this,x,y,z,args);};
G__8760.cljs$lang$maxFixedArity = 3;
G__8760.cljs$lang$applyTo = (function (arglist__8762){
var x = cljs.core.first(arglist__8762);
arglist__8762 = cljs.core.next(arglist__8762);
var y = cljs.core.first(arglist__8762);
arglist__8762 = cljs.core.next(arglist__8762);
var z = cljs.core.first(arglist__8762);
var args = cljs.core.rest(arglist__8762);
return G__8760__delegate(x,y,z,args);
});
G__8760.cljs$core$IFn$_invoke$arity$variadic = G__8760__delegate;
return G__8760;
})()
;
cljs$core$some_fn_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp3__0.call(this);
case 1:
return cljs$core$some_fn_$_sp3__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp3__3.call(this,x,y,z);
default:
var G__8763 = null;
if (arguments.length > 3) {
var G__8764__i = 0, G__8764__a = new Array(arguments.length -  3);
while (G__8764__i < G__8764__a.length) {G__8764__a[G__8764__i] = arguments[G__8764__i + 3]; ++G__8764__i;}
G__8763 = new cljs.core.IndexedSeq(G__8764__a,0);
}
return cljs$core$some_fn_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp3.cljs$lang$applyTo = cljs$core$some_fn_$_sp3__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp3__0;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp3__1;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp3__2;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp3__3;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp3;
})()
});
var cljs$core$some_fn__4 = (function() { 
var G__8765__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$some_fn_$_spn = null;
var cljs$core$some_fn_$_spn__0 = (function (){
return null;
});
var cljs$core$some_fn_$_spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__8378_SHARP_){
var G__8741 = x;
return (p1__8378_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8378_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8741) : p1__8378_SHARP_.call(null,G__8741));
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__8379_SHARP_){
var or__3740__auto__ = (function (){var G__8743 = x;
return (p1__8379_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8379_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8743) : p1__8379_SHARP_.call(null,G__8743));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var G__8744 = y;
return (p1__8379_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8379_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8744) : p1__8379_SHARP_.call(null,G__8744));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__8380_SHARP_){
var or__3740__auto__ = (function (){var G__8746 = x;
return (p1__8380_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8380_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8746) : p1__8380_SHARP_.call(null,G__8746));
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (function (){var G__8748 = y;
return (p1__8380_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8380_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8748) : p1__8380_SHARP_.call(null,G__8748));
})();
if(cljs.core.truth_(or__3740__auto____$1)){
return or__3740__auto____$1;
} else {
var G__8749 = z;
return (p1__8380_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8380_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8749) : p1__8380_SHARP_.call(null,G__8749));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__4 = (function() { 
var G__8766__delegate = function (x,y,z,args){
var or__3740__auto__ = cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return cljs.core.some(((function (or__3740__auto__,ps__$1){
return (function (p1__8381_SHARP_){
return cljs.core.some(p1__8381_SHARP_,args);
});})(or__3740__auto__,ps__$1))
,ps__$1);
}
};
var G__8766 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8767__i = 0, G__8767__a = new Array(arguments.length -  3);
while (G__8767__i < G__8767__a.length) {G__8767__a[G__8767__i] = arguments[G__8767__i + 3]; ++G__8767__i;}
  args = new cljs.core.IndexedSeq(G__8767__a,0);
} 
return G__8766__delegate.call(this,x,y,z,args);};
G__8766.cljs$lang$maxFixedArity = 3;
G__8766.cljs$lang$applyTo = (function (arglist__8768){
var x = cljs.core.first(arglist__8768);
arglist__8768 = cljs.core.next(arglist__8768);
var y = cljs.core.first(arglist__8768);
arglist__8768 = cljs.core.next(arglist__8768);
var z = cljs.core.first(arglist__8768);
var args = cljs.core.rest(arglist__8768);
return G__8766__delegate(x,y,z,args);
});
G__8766.cljs$core$IFn$_invoke$arity$variadic = G__8766__delegate;
return G__8766;
})()
;
cljs$core$some_fn_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_spn__0.call(this);
case 1:
return cljs$core$some_fn_$_spn__1.call(this,x);
case 2:
return cljs$core$some_fn_$_spn__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_spn__3.call(this,x,y,z);
default:
var G__8769 = null;
if (arguments.length > 3) {
var G__8770__i = 0, G__8770__a = new Array(arguments.length -  3);
while (G__8770__i < G__8770__a.length) {G__8770__a[G__8770__i] = arguments[G__8770__i + 3]; ++G__8770__i;}
G__8769 = new cljs.core.IndexedSeq(G__8770__a,0);
}
return cljs$core$some_fn_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_spn.cljs$lang$applyTo = cljs$core$some_fn_$_spn__4.cljs$lang$applyTo;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_spn__0;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_spn__1;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_spn__2;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_spn__3;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_spn;
})()
;})(ps__$1))
};
var G__8765 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__8771__i = 0, G__8771__a = new Array(arguments.length -  3);
while (G__8771__i < G__8771__a.length) {G__8771__a[G__8771__i] = arguments[G__8771__i + 3]; ++G__8771__i;}
  ps = new cljs.core.IndexedSeq(G__8771__a,0);
} 
return G__8765__delegate.call(this,p1,p2,p3,ps);};
G__8765.cljs$lang$maxFixedArity = 3;
G__8765.cljs$lang$applyTo = (function (arglist__8772){
var p1 = cljs.core.first(arglist__8772);
arglist__8772 = cljs.core.next(arglist__8772);
var p2 = cljs.core.first(arglist__8772);
arglist__8772 = cljs.core.next(arglist__8772);
var p3 = cljs.core.first(arglist__8772);
var ps = cljs.core.rest(arglist__8772);
return G__8765__delegate(p1,p2,p3,ps);
});
G__8765.cljs$core$IFn$_invoke$arity$variadic = G__8765__delegate;
return G__8765;
})()
;
cljs$core$some_fn = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return cljs$core$some_fn__1.call(this,p1);
case 2:
return cljs$core$some_fn__2.call(this,p1,p2);
case 3:
return cljs$core$some_fn__3.call(this,p1,p2,p3);
default:
var G__8773 = null;
if (arguments.length > 3) {
var G__8774__i = 0, G__8774__a = new Array(arguments.length -  3);
while (G__8774__i < G__8774__a.length) {G__8774__a[G__8774__i] = arguments[G__8774__i + 3]; ++G__8774__i;}
G__8773 = new cljs.core.IndexedSeq(G__8774__a,0);
}
return cljs$core$some_fn__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__8773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn.cljs$lang$applyTo = cljs$core$some_fn__4.cljs$lang$applyTo;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn__1;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn__2;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn__3;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn;
})()
;
/**
 * Returns a lazy sequence consisting of the result of applying f to
 * the set of first items of each coll, followed by applying f to the
 * set of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments. Returns a transducer when
 * no collection is provided.
 * @param {...*} var_args
 */
cljs.core.map = (function() {
var cljs$core$map = null;
var cljs$core$map__1 = (function (f){
return (function (rf){
return (function() {
var G__8829 = null;
var G__8829__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8829__1 = (function (result){
var G__8815 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8815) : rf.call(null,G__8815));
});
var G__8829__2 = (function (result,input){
var G__8816 = result;
var G__8817 = (function (){var G__8818 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8818) : f.call(null,G__8818));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8816,G__8817) : rf.call(null,G__8816,G__8817));
});
var G__8829__3 = (function() { 
var G__8830__delegate = function (result,input,inputs){
var G__8819 = result;
var G__8820 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8819,G__8820) : rf.call(null,G__8819,G__8820));
};
var G__8830 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__8831__i = 0, G__8831__a = new Array(arguments.length -  2);
while (G__8831__i < G__8831__a.length) {G__8831__a[G__8831__i] = arguments[G__8831__i + 2]; ++G__8831__i;}
  inputs = new cljs.core.IndexedSeq(G__8831__a,0);
} 
return G__8830__delegate.call(this,result,input,inputs);};
G__8830.cljs$lang$maxFixedArity = 2;
G__8830.cljs$lang$applyTo = (function (arglist__8832){
var result = cljs.core.first(arglist__8832);
arglist__8832 = cljs.core.next(arglist__8832);
var input = cljs.core.first(arglist__8832);
var inputs = cljs.core.rest(arglist__8832);
return G__8830__delegate(result,input,inputs);
});
G__8830.cljs$core$IFn$_invoke$arity$variadic = G__8830__delegate;
return G__8830;
})()
;
G__8829 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__8829__0.call(this);
case 1:
return G__8829__1.call(this,result);
case 2:
return G__8829__2.call(this,result,input);
default:
var G__8833 = null;
if (arguments.length > 2) {
var G__8834__i = 0, G__8834__a = new Array(arguments.length -  2);
while (G__8834__i < G__8834__a.length) {G__8834__a[G__8834__i] = arguments[G__8834__i + 2]; ++G__8834__i;}
G__8833 = new cljs.core.IndexedSeq(G__8834__a,0);
}
return G__8829__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__8833);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8829.cljs$lang$maxFixedArity = 2;
G__8829.cljs$lang$applyTo = G__8829__3.cljs$lang$applyTo;
G__8829.cljs$core$IFn$_invoke$arity$0 = G__8829__0;
G__8829.cljs$core$IFn$_invoke$arity$1 = G__8829__1;
G__8829.cljs$core$IFn$_invoke$arity$2 = G__8829__2;
G__8829.cljs$core$IFn$_invoke$arity$variadic = G__8829__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8829;
})()
});
});
var cljs$core$map__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4625__auto___8835 = size;
var i_8836 = (0);
while(true){
if((i_8836 < n__4625__auto___8835)){
cljs.core.chunk_append(b,(function (){var G__8821 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8836);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8821) : f.call(null,G__8821));
})());

var G__8837 = (i_8836 + (1));
i_8836 = G__8837;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__8822 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8822) : f.call(null,G__8822));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
var cljs$core$map__3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__8823 = cljs.core.first(s1);
var G__8824 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8823,G__8824) : f.call(null,G__8823,G__8824));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});
var cljs$core$map__4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__8825 = cljs.core.first(s1);
var G__8826 = cljs.core.first(s2);
var G__8827 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8825,G__8826,G__8827) : f.call(null,G__8825,G__8826,G__8827));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});
var cljs$core$map__5 = (function() { 
var G__8838__delegate = function (f,c1,c2,c3,colls){
var step = (function cljs$core$map_$_step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$map_$_step(cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs$core$map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__8775_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__8775_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
};
var G__8838 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__8839__i = 0, G__8839__a = new Array(arguments.length -  4);
while (G__8839__i < G__8839__a.length) {G__8839__a[G__8839__i] = arguments[G__8839__i + 4]; ++G__8839__i;}
  colls = new cljs.core.IndexedSeq(G__8839__a,0);
} 
return G__8838__delegate.call(this,f,c1,c2,c3,colls);};
G__8838.cljs$lang$maxFixedArity = 4;
G__8838.cljs$lang$applyTo = (function (arglist__8840){
var f = cljs.core.first(arglist__8840);
arglist__8840 = cljs.core.next(arglist__8840);
var c1 = cljs.core.first(arglist__8840);
arglist__8840 = cljs.core.next(arglist__8840);
var c2 = cljs.core.first(arglist__8840);
arglist__8840 = cljs.core.next(arglist__8840);
var c3 = cljs.core.first(arglist__8840);
var colls = cljs.core.rest(arglist__8840);
return G__8838__delegate(f,c1,c2,c3,colls);
});
G__8838.cljs$core$IFn$_invoke$arity$variadic = G__8838__delegate;
return G__8838;
})()
;
cljs$core$map = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$map__1.call(this,f);
case 2:
return cljs$core$map__2.call(this,f,c1);
case 3:
return cljs$core$map__3.call(this,f,c1,c2);
case 4:
return cljs$core$map__4.call(this,f,c1,c2,c3);
default:
var G__8841 = null;
if (arguments.length > 4) {
var G__8842__i = 0, G__8842__a = new Array(arguments.length -  4);
while (G__8842__i < G__8842__a.length) {G__8842__a[G__8842__i] = arguments[G__8842__i + 4]; ++G__8842__i;}
G__8841 = new cljs.core.IndexedSeq(G__8842__a,0);
}
return cljs$core$map__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__8841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$map.cljs$lang$maxFixedArity = 4;
cljs$core$map.cljs$lang$applyTo = cljs$core$map__5.cljs$lang$applyTo;
cljs$core$map.cljs$core$IFn$_invoke$arity$1 = cljs$core$map__1;
cljs$core$map.cljs$core$IFn$_invoke$arity$2 = cljs$core$map__2;
cljs$core$map.cljs$core$IFn$_invoke$arity$3 = cljs$core$map__3;
cljs$core$map.cljs$core$IFn$_invoke$arity$4 = cljs$core$map__4;
cljs$core$map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$map__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$map;
})()
;
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 * there are fewer than n.  Returns a stateful transducer when
 * no collection is provided.
 */
cljs.core.take = (function() {
var cljs$core$take = null;
var cljs$core$take__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8851 = null;
var G__8851__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8851__1 = (function (result){
var G__8848 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8848) : rf.call(null,G__8848));
});
var G__8851__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__8849 = result;
var G__8850 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8849,G__8850) : rf.call(null,G__8849,G__8850));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__8851 = function(result,input){
switch(arguments.length){
case 0:
return G__8851__0.call(this);
case 1:
return G__8851__1.call(this,result);
case 2:
return G__8851__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8851.cljs$core$IFn$_invoke$arity$0 = G__8851__0;
G__8851.cljs$core$IFn$_invoke$arity$1 = G__8851__1;
G__8851.cljs$core$IFn$_invoke$arity$2 = G__8851__2;
return G__8851;
})()
;})(na))
});
});
var cljs$core$take__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs$core$take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
cljs$core$take = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$take__1.call(this,n);
case 2:
return cljs$core$take__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take.cljs$core$IFn$_invoke$arity$1 = cljs$core$take__1;
cljs$core$take.cljs$core$IFn$_invoke$arity$2 = cljs$core$take__2;
return cljs$core$take;
})()
;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 * Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function() {
var cljs$core$drop = null;
var cljs$core$drop__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8858 = null;
var G__8858__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8858__1 = (function (result){
var G__8855 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8855) : rf.call(null,G__8855));
});
var G__8858__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__8856 = result;
var G__8857 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8856,G__8857) : rf.call(null,G__8856,G__8857));
}
});
G__8858 = function(result,input){
switch(arguments.length){
case 0:
return G__8858__0.call(this);
case 1:
return G__8858__1.call(this,result);
case 2:
return G__8858__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8858.cljs$core$IFn$_invoke$arity$0 = G__8858__0;
G__8858.cljs$core$IFn$_invoke$arity$1 = G__8858__1;
G__8858.cljs$core$IFn$_invoke$arity$2 = G__8858__2;
return G__8858;
})()
;})(na))
});
});
var cljs$core$drop__2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__8859 = (n__$1 - (1));
var G__8860 = cljs.core.rest(s);
n__$1 = G__8859;
coll__$1 = G__8860;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});
cljs$core$drop = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$drop__1.call(this,n);
case 2:
return cljs$core$drop__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop__1;
cljs$core$drop.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop__2;
return cljs$core$drop;
})()
;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function() {
var cljs$core$drop_last = null;
var cljs$core$drop_last__1 = (function (s){
return cljs$core$drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});
var cljs$core$drop_last__2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});
cljs$core$drop_last = function(n,s){
switch(arguments.length){
case 1:
return cljs$core$drop_last__1.call(this,n);
case 2:
return cljs$core$drop_last__2.call(this,n,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop_last.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop_last__1;
cljs$core$drop_last.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop_last__2;
return cljs$core$drop_last;
})()
;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 * of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__8863 = cljs.core.next(s);
var G__8864 = cljs.core.next(lead);
s = G__8863;
lead = G__8864;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 * first item for which (pred item) returns logical false.  Returns a
 * stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function() {
var cljs$core$drop_while = null;
var cljs$core$drop_while__1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__8877 = null;
var G__8877__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8877__1 = (function (result){
var G__8871 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8871) : rf.call(null,G__8871));
});
var G__8877__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__3728__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__3728__auto__)){
var G__8872 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8872) : pred.call(null,G__8872));
} else {
return and__3728__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__8873 = result;
var G__8874 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8873,G__8874) : rf.call(null,G__8873,G__8874));
}
});
G__8877 = function(result,input){
switch(arguments.length){
case 0:
return G__8877__0.call(this);
case 1:
return G__8877__1.call(this,result);
case 2:
return G__8877__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8877.cljs$core$IFn$_invoke$arity$0 = G__8877__0;
G__8877.cljs$core$IFn$_invoke$arity$1 = G__8877__1;
G__8877.cljs$core$IFn$_invoke$arity$2 = G__8877__2;
return G__8877;
})()
;})(da))
});
});
var cljs$core$drop_while__2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__3728__auto__ = s;
if(and__3728__auto__){
var G__8876 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__8876) : pred__$1.call(null,G__8876));
} else {
return and__3728__auto__;
}
})())){
var G__8878 = pred__$1;
var G__8879 = cljs.core.rest(s);
pred__$1 = G__8878;
coll__$1 = G__8879;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});
cljs$core$drop_while = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$drop_while__1.call(this,pred);
case 2:
return cljs$core$drop_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop_while.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop_while__1;
cljs$core$drop_while.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop_while__2;
return cljs$core$drop_while;
})()
;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function() {
var cljs$core$repeat = null;
var cljs$core$repeat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs$core$repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});
var cljs$core$repeat__2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs$core$repeat.cljs$core$IFn$_invoke$arity$1(x));
});
cljs$core$repeat = function(n,x){
switch(arguments.length){
case 1:
return cljs$core$repeat__1.call(this,n);
case 2:
return cljs$core$repeat__2.call(this,n,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$repeat.cljs$core$IFn$_invoke$arity$1 = cljs$core$repeat__1;
cljs$core$repeat.cljs$core$IFn$_invoke$arity$2 = cljs$core$repeat__2;
return cljs$core$repeat;
})()
;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 * returns an infinite (or length n if supplied) lazy sequence of calls
 * to it
 */
cljs.core.repeatedly = (function() {
var cljs$core$repeatedly = null;
var cljs$core$repeatedly__1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});
var cljs$core$repeatedly__2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});
cljs$core$repeatedly = function(n,f){
switch(arguments.length){
case 1:
return cljs$core$repeatedly__1.call(this,n);
case 2:
return cljs$core$repeatedly__2.call(this,n,f);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1 = cljs$core$repeatedly__1;
cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$2 = cljs$core$repeatedly__2;
return cljs$core$repeatedly;
})()
;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(function (){var G__8888 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8888) : f.call(null,G__8888));
})());
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 * @param {...*} var_args
 */
cljs.core.interleave = (function() {
var cljs$core$interleave = null;
var cljs$core$interleave__2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs$core$interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});
var cljs$core$interleave__3 = (function() { 
var G__8891__delegate = function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs$core$interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
};
var G__8891 = function (c1,c2,var_args){
var colls = null;
if (arguments.length > 2) {
var G__8892__i = 0, G__8892__a = new Array(arguments.length -  2);
while (G__8892__i < G__8892__a.length) {G__8892__a[G__8892__i] = arguments[G__8892__i + 2]; ++G__8892__i;}
  colls = new cljs.core.IndexedSeq(G__8892__a,0);
} 
return G__8891__delegate.call(this,c1,c2,colls);};
G__8891.cljs$lang$maxFixedArity = 2;
G__8891.cljs$lang$applyTo = (function (arglist__8893){
var c1 = cljs.core.first(arglist__8893);
arglist__8893 = cljs.core.next(arglist__8893);
var c2 = cljs.core.first(arglist__8893);
var colls = cljs.core.rest(arglist__8893);
return G__8891__delegate(c1,c2,colls);
});
G__8891.cljs$core$IFn$_invoke$arity$variadic = G__8891__delegate;
return G__8891;
})()
;
cljs$core$interleave = function(c1,c2,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return cljs$core$interleave__2.call(this,c1,c2);
default:
var G__8894 = null;
if (arguments.length > 2) {
var G__8895__i = 0, G__8895__a = new Array(arguments.length -  2);
while (G__8895__i < G__8895__a.length) {G__8895__a[G__8895__i] = arguments[G__8895__i + 2]; ++G__8895__i;}
G__8894 = new cljs.core.IndexedSeq(G__8895__a,0);
}
return cljs$core$interleave__3.cljs$core$IFn$_invoke$arity$variadic(c1,c2, G__8894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$interleave.cljs$lang$maxFixedArity = 2;
cljs$core$interleave.cljs$lang$applyTo = cljs$core$interleave__3.cljs$lang$applyTo;
cljs$core$interleave.cljs$core$IFn$_invoke$arity$2 = cljs$core$interleave__2;
cljs$core$interleave.cljs$core$IFn$_invoke$arity$variadic = cljs$core$interleave__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$interleave;
})()
;
/**
 * Returns a lazy seq of the elements of coll separated by sep
 */
cljs.core.interpose = (function() {
var cljs$core$interpose = null;
var cljs$core$interpose__1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__8910 = null;
var G__8910__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8910__1 = (function (result){
var G__8903 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8903) : rf.call(null,G__8903));
});
var G__8910__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__8904 = result;
var G__8905 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8904,G__8905) : rf.call(null,G__8904,G__8905));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__8906 = sepr;
var G__8907 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8906,G__8907) : rf.call(null,G__8906,G__8907));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__8908 = result;
var G__8909 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8908,G__8909) : rf.call(null,G__8908,G__8909));
}
});
G__8910 = function(result,input){
switch(arguments.length){
case 0:
return G__8910__0.call(this);
case 1:
return G__8910__1.call(this,result);
case 2:
return G__8910__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8910.cljs$core$IFn$_invoke$arity$0 = G__8910__0;
G__8910.cljs$core$IFn$_invoke$arity$1 = G__8910__1;
G__8910.cljs$core$IFn$_invoke$arity$2 = G__8910__2;
return G__8910;
})()
;})(started))
});
});
var cljs$core$interpose__2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});
cljs$core$interpose = function(sep,coll){
switch(arguments.length){
case 1:
return cljs$core$interpose__1.call(this,sep);
case 2:
return cljs$core$interpose__2.call(this,sep,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$interpose.cljs$core$IFn$_invoke$arity$1 = cljs$core$interpose__1;
cljs$core$interpose.cljs$core$IFn$_invoke$arity$2 = cljs$core$interpose__2;
return cljs$core$interpose;
})()
;
/**
 * Take a collection of collections, and return a lazy seq
 * of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var coll__$1 = temp__4124__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 * to f and colls.  Thus function f should return a collection. Returns
 * a transducer when no collections are provided
 * @param {...*} var_args
 */
cljs.core.mapcat = (function() {
var cljs$core$mapcat = null;
var cljs$core$mapcat__1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});
var cljs$core$mapcat__2 = (function() { 
var G__8919__delegate = function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
};
var G__8919 = function (f,var_args){
var colls = null;
if (arguments.length > 1) {
var G__8920__i = 0, G__8920__a = new Array(arguments.length -  1);
while (G__8920__i < G__8920__a.length) {G__8920__a[G__8920__i] = arguments[G__8920__i + 1]; ++G__8920__i;}
  colls = new cljs.core.IndexedSeq(G__8920__a,0);
} 
return G__8919__delegate.call(this,f,colls);};
G__8919.cljs$lang$maxFixedArity = 1;
G__8919.cljs$lang$applyTo = (function (arglist__8921){
var f = cljs.core.first(arglist__8921);
var colls = cljs.core.rest(arglist__8921);
return G__8919__delegate(f,colls);
});
G__8919.cljs$core$IFn$_invoke$arity$variadic = G__8919__delegate;
return G__8919;
})()
;
cljs$core$mapcat = function(f,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$mapcat__1.call(this,f);
default:
var G__8922 = null;
if (arguments.length > 1) {
var G__8923__i = 0, G__8923__a = new Array(arguments.length -  1);
while (G__8923__i < G__8923__a.length) {G__8923__a[G__8923__i] = arguments[G__8923__i + 1]; ++G__8923__i;}
G__8922 = new cljs.core.IndexedSeq(G__8923__a,0);
}
return cljs$core$mapcat__2.cljs$core$IFn$_invoke$arity$variadic(f, G__8922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$mapcat.cljs$lang$maxFixedArity = 1;
cljs$core$mapcat.cljs$lang$applyTo = cljs$core$mapcat__2.cljs$lang$applyTo;
cljs$core$mapcat.cljs$core$IFn$_invoke$arity$1 = cljs$core$mapcat__1;
cljs$core$mapcat.cljs$core$IFn$_invoke$arity$variadic = cljs$core$mapcat__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$mapcat;
})()
;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function() {
var cljs$core$filter = null;
var cljs$core$filter__1 = (function (pred){
return (function (rf){
return (function() {
var G__8942 = null;
var G__8942__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8942__1 = (function (result){
var G__8936 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8936) : rf.call(null,G__8936));
});
var G__8942__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__8937 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8937) : pred.call(null,G__8937));
})())){
var G__8938 = result;
var G__8939 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8938,G__8939) : rf.call(null,G__8938,G__8939));
} else {
return result;
}
});
G__8942 = function(result,input){
switch(arguments.length){
case 0:
return G__8942__0.call(this);
case 1:
return G__8942__1.call(this,result);
case 2:
return G__8942__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8942.cljs$core$IFn$_invoke$arity$0 = G__8942__0;
G__8942.cljs$core$IFn$_invoke$arity$1 = G__8942__1;
G__8942.cljs$core$IFn$_invoke$arity$2 = G__8942__2;
return G__8942;
})()
});
});
var cljs$core$filter__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4625__auto___8943 = size;
var i_8944 = (0);
while(true){
if((i_8944 < n__4625__auto___8943)){
if(cljs.core.truth_((function (){var G__8940 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8944);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8940) : pred.call(null,G__8940));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8944));
} else {
}

var G__8945 = (i_8944 + (1));
i_8944 = G__8945;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__8941 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8941) : pred.call(null,G__8941));
})())){
return cljs.core.cons(f,cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});
cljs$core$filter = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$filter__1.call(this,pred);
case 2:
return cljs$core$filter__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$filter.cljs$core$IFn$_invoke$arity$1 = cljs$core$filter__1;
cljs$core$filter.cljs$core$IFn$_invoke$arity$2 = cljs$core$filter__2;
return cljs$core$filter;
})()
;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns false. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function() {
var cljs$core$remove = null;
var cljs$core$remove__1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});
var cljs$core$remove__2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});
cljs$core$remove = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$remove__1.call(this,pred);
case 2:
return cljs$core$remove__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$remove.cljs$core$IFn$_invoke$arity$1 = cljs$core$remove__1;
cljs$core$remove.cljs$core$IFn$_invoke$arity$2 = cljs$core$remove__2;
return cljs$core$remove;
})()
;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 * tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__8952 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__8952) : branch_QMARK_.call(null,G__8952));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(function (){var G__8953 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__8953) : children.call(null,G__8953));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 * etc.) and returns their contents as a single, flat sequence.
 * (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__8954_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__8954_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 * from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function() {
var cljs$core$into = null;
var cljs$core$into__2 = (function (to,from){
if(!((to == null))){
if((function (){var G__8957 = to;
if(G__8957){
var bit__4407__auto__ = (G__8957.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4407__auto__) || (G__8957.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});
var cljs$core$into__3 = (function (to,xform,from){
if((function (){var G__8958 = to;
if(G__8958){
var bit__4407__auto__ = (G__8958.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4407__auto__) || (G__8958.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});
cljs$core$into = function(to,xform,from){
switch(arguments.length){
case 2:
return cljs$core$into__2.call(this,to,xform);
case 3:
return cljs$core$into__3.call(this,to,xform,from);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$into.cljs$core$IFn$_invoke$arity$2 = cljs$core$into__2;
cljs$core$into.cljs$core$IFn$_invoke$arity$3 = cljs$core$into__3;
return cljs$core$into;
})()
;
/**
 * Returns a vector consisting of the result of applying f to the
 * set of first items of each coll, followed by applying f to the set
 * of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments.
 * @param {...*} var_args
 */
cljs.core.mapv = (function() {
var cljs$core$mapv = null;
var cljs$core$mapv__2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__8960 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8960) : f.call(null,G__8960));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
var cljs$core$mapv__3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});
var cljs$core$mapv__4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});
var cljs$core$mapv__5 = (function() { 
var G__8961__delegate = function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
};
var G__8961 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__8962__i = 0, G__8962__a = new Array(arguments.length -  4);
while (G__8962__i < G__8962__a.length) {G__8962__a[G__8962__i] = arguments[G__8962__i + 4]; ++G__8962__i;}
  colls = new cljs.core.IndexedSeq(G__8962__a,0);
} 
return G__8961__delegate.call(this,f,c1,c2,c3,colls);};
G__8961.cljs$lang$maxFixedArity = 4;
G__8961.cljs$lang$applyTo = (function (arglist__8963){
var f = cljs.core.first(arglist__8963);
arglist__8963 = cljs.core.next(arglist__8963);
var c1 = cljs.core.first(arglist__8963);
arglist__8963 = cljs.core.next(arglist__8963);
var c2 = cljs.core.first(arglist__8963);
arglist__8963 = cljs.core.next(arglist__8963);
var c3 = cljs.core.first(arglist__8963);
var colls = cljs.core.rest(arglist__8963);
return G__8961__delegate(f,c1,c2,c3,colls);
});
G__8961.cljs$core$IFn$_invoke$arity$variadic = G__8961__delegate;
return G__8961;
})()
;
cljs$core$mapv = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return cljs$core$mapv__2.call(this,f,c1);
case 3:
return cljs$core$mapv__3.call(this,f,c1,c2);
case 4:
return cljs$core$mapv__4.call(this,f,c1,c2,c3);
default:
var G__8964 = null;
if (arguments.length > 4) {
var G__8965__i = 0, G__8965__a = new Array(arguments.length -  4);
while (G__8965__i < G__8965__a.length) {G__8965__a[G__8965__i] = arguments[G__8965__i + 4]; ++G__8965__i;}
G__8964 = new cljs.core.IndexedSeq(G__8965__a,0);
}
return cljs$core$mapv__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__8964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$mapv.cljs$lang$maxFixedArity = 4;
cljs$core$mapv.cljs$lang$applyTo = cljs$core$mapv__5.cljs$lang$applyTo;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$2 = cljs$core$mapv__2;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$3 = cljs$core$mapv__3;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$4 = cljs$core$mapv__4;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$variadic = cljs$core$mapv__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$mapv;
})()
;
/**
 * Returns a vector of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__8967 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8967) : pred.call(null,G__8967));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 * apart. If step is not supplied, defaults to n, i.e. the partitions
 * do not overlap. If a pad collection is supplied, use its elements as
 * necessary to complete last partition up to n items. In case there are
 * not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function() {
var cljs$core$partition = null;
var cljs$core$partition__2 = (function (n,coll){
return cljs$core$partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var cljs$core$partition__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs$core$partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
var cljs$core$partition__4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs$core$partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});
cljs$core$partition = function(n,step,pad,coll){
switch(arguments.length){
case 2:
return cljs$core$partition__2.call(this,n,step);
case 3:
return cljs$core$partition__3.call(this,n,step,pad);
case 4:
return cljs$core$partition__4.call(this,n,step,pad,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition__2;
cljs$core$partition.cljs$core$IFn$_invoke$arity$3 = cljs$core$partition__3;
cljs$core$partition.cljs$core$IFn$_invoke$arity$4 = cljs$core$partition__4;
return cljs$core$partition;
})()
;
/**
 * Returns the value in a nested associative structure,
 * where ks is a sequence of keys. Returns nil if the key is not present,
 * or the not-found value if supplied.
 */
cljs.core.get_in = (function() {
var cljs$core$get_in = null;
var cljs$core$get_in__2 = (function (m,ks){
return cljs$core$get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});
var cljs$core$get_in__3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__8982 = m__$1;
if(G__8982){
var bit__4414__auto__ = (G__8982.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4414__auto__) || (G__8982.cljs$core$ILookup$)){
return true;
} else {
if((!G__8982.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__8982);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__8982);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__8983 = sentinel;
var G__8984 = m__$2;
var G__8985 = cljs.core.next(ks__$1);
sentinel = G__8983;
m__$1 = G__8984;
ks__$1 = G__8985;
continue;
}
}
} else {
return m__$1;
}
break;
}
});
cljs$core$get_in = function(m,ks,not_found){
switch(arguments.length){
case 2:
return cljs$core$get_in__2.call(this,m,ks);
case 3:
return cljs$core$get_in__3.call(this,m,ks,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$get_in.cljs$core$IFn$_invoke$arity$2 = cljs$core$get_in__2;
cljs$core$get_in.cljs$core$IFn$_invoke$arity$3 = cljs$core$get_in__3;
return cljs$core$get_in;
})()
;
/**
 * Associates a value in a nested associative structure, where ks is a
 * sequence of keys and v is the new value and returns a new nested structure.
 * If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__8986,v){
var vec__8991 = p__8986;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8991,(0),null);
var ks = cljs.core.nthnext(vec__8991,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 * sequence of keys and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * nested structure.  If any levels do not exist, hash-maps will be
 * created.
 * @param {...*} var_args
 */
cljs.core.update_in = (function() {
var cljs$core$update_in = null;
var cljs$core$update_in__3 = (function (m,p__8992,f){
var vec__9030 = p__8992;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9030,(0),null);
var ks = cljs.core.nthnext(vec__9030,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9031) : f.call(null,G__9031));
})());
}
});
var cljs$core$update_in__4 = (function (m,p__8993,f,a){
var vec__9032 = p__8993;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9032,(0),null);
var ks = cljs.core.nthnext(vec__9032,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9033 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9034 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9033,G__9034) : f.call(null,G__9033,G__9034));
})());
}
});
var cljs$core$update_in__5 = (function (m,p__8994,f,a,b){
var vec__9035 = p__8994;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9035,(0),null);
var ks = cljs.core.nthnext(vec__9035,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9036 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9037 = a;
var G__9038 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9036,G__9037,G__9038) : f.call(null,G__9036,G__9037,G__9038));
})());
}
});
var cljs$core$update_in__6 = (function (m,p__8995,f,a,b,c){
var vec__9039 = p__8995;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9039,(0),null);
var ks = cljs.core.nthnext(vec__9039,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9041 = a;
var G__9042 = b;
var G__9043 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9040,G__9041,G__9042,G__9043) : f.call(null,G__9040,G__9041,G__9042,G__9043));
})());
}
});
var cljs$core$update_in__7 = (function() { 
var G__9045__delegate = function (m,p__8996,f,a,b,c,args){
var vec__9044 = p__8996;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9044,(0),null);
var ks = cljs.core.nthnext(vec__9044,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs$core$update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
};
var G__9045 = function (m,p__8996,f,a,b,c,var_args){
var args = null;
if (arguments.length > 6) {
var G__9046__i = 0, G__9046__a = new Array(arguments.length -  6);
while (G__9046__i < G__9046__a.length) {G__9046__a[G__9046__i] = arguments[G__9046__i + 6]; ++G__9046__i;}
  args = new cljs.core.IndexedSeq(G__9046__a,0);
} 
return G__9045__delegate.call(this,m,p__8996,f,a,b,c,args);};
G__9045.cljs$lang$maxFixedArity = 6;
G__9045.cljs$lang$applyTo = (function (arglist__9047){
var m = cljs.core.first(arglist__9047);
arglist__9047 = cljs.core.next(arglist__9047);
var p__8996 = cljs.core.first(arglist__9047);
arglist__9047 = cljs.core.next(arglist__9047);
var f = cljs.core.first(arglist__9047);
arglist__9047 = cljs.core.next(arglist__9047);
var a = cljs.core.first(arglist__9047);
arglist__9047 = cljs.core.next(arglist__9047);
var b = cljs.core.first(arglist__9047);
arglist__9047 = cljs.core.next(arglist__9047);
var c = cljs.core.first(arglist__9047);
var args = cljs.core.rest(arglist__9047);
return G__9045__delegate(m,p__8996,f,a,b,c,args);
});
G__9045.cljs$core$IFn$_invoke$arity$variadic = G__9045__delegate;
return G__9045;
})()
;
cljs$core$update_in = function(m,p__8996,f,a,b,c,var_args){
var args = var_args;
switch(arguments.length){
case 3:
return cljs$core$update_in__3.call(this,m,p__8996,f);
case 4:
return cljs$core$update_in__4.call(this,m,p__8996,f,a);
case 5:
return cljs$core$update_in__5.call(this,m,p__8996,f,a,b);
case 6:
return cljs$core$update_in__6.call(this,m,p__8996,f,a,b,c);
default:
var G__9048 = null;
if (arguments.length > 6) {
var G__9049__i = 0, G__9049__a = new Array(arguments.length -  6);
while (G__9049__i < G__9049__a.length) {G__9049__a[G__9049__i] = arguments[G__9049__i + 6]; ++G__9049__i;}
G__9048 = new cljs.core.IndexedSeq(G__9049__a,0);
}
return cljs$core$update_in__7.cljs$core$IFn$_invoke$arity$variadic(m,p__8996,f,a,b,c, G__9048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$update_in.cljs$lang$maxFixedArity = 6;
cljs$core$update_in.cljs$lang$applyTo = cljs$core$update_in__7.cljs$lang$applyTo;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$3 = cljs$core$update_in__3;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$4 = cljs$core$update_in__4;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$5 = cljs$core$update_in__5;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$6 = cljs$core$update_in__6;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$variadic = cljs$core$update_in__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$update_in;
})()
;
/**
 * 'Updates' a value in an associative structure, where k is a
 * key and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * structure.  If the key does not exist, nil is passed as the old value.
 * @param {...*} var_args
 */
cljs.core.update = (function() {
var cljs$core$update = null;
var cljs$core$update__3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9060 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9060) : f.call(null,G__9060));
})());
});
var cljs$core$update__4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9061 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9062 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9061,G__9062) : f.call(null,G__9061,G__9062));
})());
});
var cljs$core$update__5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9063 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9064 = x;
var G__9065 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9063,G__9064,G__9065) : f.call(null,G__9063,G__9064,G__9065));
})());
});
var cljs$core$update__6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9066 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9067 = x;
var G__9068 = y;
var G__9069 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9066,G__9067,G__9068,G__9069) : f.call(null,G__9066,G__9067,G__9068,G__9069));
})());
});
var cljs$core$update__7 = (function() { 
var G__9070__delegate = function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
};
var G__9070 = function (m,k,f,x,y,z,var_args){
var more = null;
if (arguments.length > 6) {
var G__9071__i = 0, G__9071__a = new Array(arguments.length -  6);
while (G__9071__i < G__9071__a.length) {G__9071__a[G__9071__i] = arguments[G__9071__i + 6]; ++G__9071__i;}
  more = new cljs.core.IndexedSeq(G__9071__a,0);
} 
return G__9070__delegate.call(this,m,k,f,x,y,z,more);};
G__9070.cljs$lang$maxFixedArity = 6;
G__9070.cljs$lang$applyTo = (function (arglist__9072){
var m = cljs.core.first(arglist__9072);
arglist__9072 = cljs.core.next(arglist__9072);
var k = cljs.core.first(arglist__9072);
arglist__9072 = cljs.core.next(arglist__9072);
var f = cljs.core.first(arglist__9072);
arglist__9072 = cljs.core.next(arglist__9072);
var x = cljs.core.first(arglist__9072);
arglist__9072 = cljs.core.next(arglist__9072);
var y = cljs.core.first(arglist__9072);
arglist__9072 = cljs.core.next(arglist__9072);
var z = cljs.core.first(arglist__9072);
var more = cljs.core.rest(arglist__9072);
return G__9070__delegate(m,k,f,x,y,z,more);
});
G__9070.cljs$core$IFn$_invoke$arity$variadic = G__9070__delegate;
return G__9070;
})()
;
cljs$core$update = function(m,k,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 3:
return cljs$core$update__3.call(this,m,k,f);
case 4:
return cljs$core$update__4.call(this,m,k,f,x);
case 5:
return cljs$core$update__5.call(this,m,k,f,x,y);
case 6:
return cljs$core$update__6.call(this,m,k,f,x,y,z);
default:
var G__9073 = null;
if (arguments.length > 6) {
var G__9074__i = 0, G__9074__a = new Array(arguments.length -  6);
while (G__9074__i < G__9074__a.length) {G__9074__a[G__9074__i] = arguments[G__9074__i + 6]; ++G__9074__i;}
G__9073 = new cljs.core.IndexedSeq(G__9074__a,0);
}
return cljs$core$update__7.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x,y,z, G__9073);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$update.cljs$lang$maxFixedArity = 6;
cljs$core$update.cljs$lang$applyTo = cljs$core$update__7.cljs$lang$applyTo;
cljs$core$update.cljs$core$IFn$_invoke$arity$3 = cljs$core$update__3;
cljs$core$update.cljs$core$IFn$_invoke$arity$4 = cljs$core$update__4;
cljs$core$update.cljs$core$IFn$_invoke$arity$5 = cljs$core$update__5;
cljs$core$update.cljs$core$IFn$_invoke$arity$6 = cljs$core$update__6;
cljs$core$update.cljs$core$IFn$_invoke$arity$variadic = cljs$core$update__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$update;
})()
;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__9075 = (ll - (5));
var G__9076 = r;
ll = G__9075;
ret = G__9076;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9081 = cljs.core.pv_aget(node,(0));
var G__9082 = (level - (5));
node = G__9081;
level = G__9082;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9083 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__9084 = (level - (5));
node = G__9083;
level = G__9084;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9094 = init__$2;
var G__9095 = (j + i);
var G__9096 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9094,G__9095,G__9096) : f.call(null,G__9094,G__9095,G__9096));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9107 = (j + (1));
var G__9108 = init__$3;
j = G__9107;
init__$2 = G__9108;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9097 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9097) : cljs.core.deref.call(null,G__9097));
} else {
var G__9109 = (i + len);
var G__9110 = init__$2;
i = G__9109;
init__$1 = G__9110;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__9098 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__9098) : cljs.core.tv_editable_root.call(null,G__9098));
})(),(function (){var G__9099 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__9099) : cljs.core.tv_editable_tail.call(null,G__9099));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9100 = init__$2;
var G__9101 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9100,G__9101) : f.call(null,G__9100,G__9101));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9111 = (j + (1));
var G__9112 = init__$3;
j = G__9111;
init__$2 = G__9112;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9102 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9102) : cljs.core.deref.call(null,G__9102));
} else {
var G__9113 = (i + len);
var G__9114 = init__$2;
i = G__9113;
init__$1 = G__9114;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__9103 = coll__$1;
var G__9104 = cljs.core.first_array_for_longvec(coll__$1);
var G__9105 = (0);
var G__9106 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9103,G__9104,G__9105,G__9106) : cljs.core.chunked_seq.call(null,G__9103,G__9104,G__9105,G__9106));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4625__auto___9115 = len;
var i_9116 = (0);
while(true){
if((i_9116 < n__4625__auto___9115)){
(new_tail[i_9116] = (self__.tail[i_9116]));

var G__9117 = (i_9116 + (1));
i_9116 = G__9117;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__9118 = null;
var G__9118__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9118__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9118 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9118__2.call(this,self__,k);
case 3:
return G__9118__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9118.cljs$core$IFn$_invoke$arity$2 = G__9118__2;
G__9118.cljs$core$IFn$_invoke$arity$3 = G__9118__3;
return G__9118;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args9093){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9093)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__9119 = (i + (1));
var G__9120 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__9119;
out = G__9120;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 * will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 * @param {...*} var_args
 */
cljs.core.vector = (function() { 
var cljs$core$vector__delegate = function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
};
var cljs$core$vector = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9121__i = 0, G__9121__a = new Array(arguments.length -  0);
while (G__9121__i < G__9121__a.length) {G__9121__a[G__9121__i] = arguments[G__9121__i + 0]; ++G__9121__i;}
  args = new cljs.core.IndexedSeq(G__9121__a,0);
} 
return cljs$core$vector__delegate.call(this,args);};
cljs$core$vector.cljs$lang$maxFixedArity = 0;
cljs$core$vector.cljs$lang$applyTo = (function (arglist__9122){
var args = cljs.core.seq(arglist__9122);
return cljs$core$vector__delegate(args);
});
cljs$core$vector.cljs$core$IFn$_invoke$arity$variadic = cljs$core$vector__delegate;
return cljs$core$vector;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9123 = self__.vec;
var G__9124 = self__.node;
var G__9125 = self__.i;
var G__9126 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9123,G__9124,G__9125,G__9126) : cljs.core.chunked_seq.call(null,G__9123,G__9124,G__9125,G__9126));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__9127 = self__.vec;
var G__9128 = (self__.i + self__.off);
var G__9129 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9127,G__9128,G__9129) : cljs.core.subvec.call(null,G__9127,G__9128,G__9129));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__9130 = self__.vec;
var G__9131 = (self__.i + self__.off);
var G__9132 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9130,G__9131,G__9132) : cljs.core.subvec.call(null,G__9130,G__9131,G__9132));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9133 = self__.vec;
var G__9134 = self__.node;
var G__9135 = self__.i;
var G__9136 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9133,G__9134,G__9135,G__9136) : cljs.core.chunked_seq.call(null,G__9133,G__9134,G__9135,G__9136));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9137 = self__.vec;
var G__9138 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9139 = end;
var G__9140 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9137,G__9138,G__9139,G__9140) : cljs.core.chunked_seq.call(null,G__9137,G__9138,G__9139,G__9140));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__9141 = self__.vec;
var G__9142 = self__.node;
var G__9143 = self__.i;
var G__9144 = self__.off;
var G__9145 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__9141,G__9142,G__9143,G__9144,G__9145) : cljs.core.chunked_seq.call(null,G__9141,G__9142,G__9143,G__9144,G__9145));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9146 = self__.vec;
var G__9147 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9148 = end;
var G__9149 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9146,G__9147,G__9148,G__9149) : cljs.core.chunked_seq.call(null,G__9146,G__9147,G__9148,G__9149));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.chunked_seq = (function() {
var cljs$core$chunked_seq = null;
var cljs$core$chunked_seq__3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});
var cljs$core$chunked_seq__4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});
var cljs$core$chunked_seq__5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});
cljs$core$chunked_seq = function(vec,node,i,off,meta){
switch(arguments.length){
case 3:
return cljs$core$chunked_seq__3.call(this,vec,node,i);
case 4:
return cljs$core$chunked_seq__4.call(this,vec,node,i,off);
case 5:
return cljs$core$chunked_seq__5.call(this,vec,node,i,off,meta);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$3 = cljs$core$chunked_seq__3;
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$4 = cljs$core$chunked_seq__4;
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$5 = cljs$core$chunked_seq__5;
return cljs$core$chunked_seq;
})()
;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__9151 = init__$1;
var G__9152 = j;
var G__9153 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9151,G__9152,G__9153) : f.call(null,G__9151,G__9152,G__9153));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9154 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9154) : cljs.core.deref.call(null,G__9154));
} else {
var G__9176 = (i + (1));
var G__9177 = (j + (1));
var G__9178 = init__$2;
i = G__9176;
j = G__9177;
init__$1 = G__9178;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__9155 = self__.meta;
var G__9156 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__9157 = self__.start;
var G__9158 = (function (){var x__4052__auto__ = self__.end;
var y__4053__auto__ = (v_pos + (1));
return ((x__4052__auto__ > y__4053__auto__) ? x__4052__auto__ : y__4053__auto__);
})();
var G__9159 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9155,G__9156,G__9157,G__9158,G__9159) : cljs.core.build_subvec.call(null,G__9155,G__9156,G__9157,G__9158,G__9159));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__9160 = self__.meta;
var G__9161 = self__.v;
var G__9162 = self__.start;
var G__9163 = (self__.end - (1));
var G__9164 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9160,G__9161,G__9162,G__9163,G__9164) : cljs.core.build_subvec.call(null,G__9160,G__9161,G__9162,G__9163,G__9164));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__9166 = meta__$1;
var G__9167 = self__.v;
var G__9168 = self__.start;
var G__9169 = self__.end;
var G__9170 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9166,G__9167,G__9168,G__9169,G__9170) : cljs.core.build_subvec.call(null,G__9166,G__9167,G__9168,G__9169,G__9170));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__9171 = self__.meta;
var G__9172 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__9173 = self__.start;
var G__9174 = (self__.end + (1));
var G__9175 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9171,G__9172,G__9173,G__9174,G__9175) : cljs.core.build_subvec.call(null,G__9171,G__9172,G__9173,G__9174,G__9175));
});

cljs.core.Subvec.prototype.call = (function() {
var G__9179 = null;
var G__9179__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9179__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9179 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9179__2.call(this,self__,k);
case 3:
return G__9179__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9179.cljs$core$IFn$_invoke$arity$2 = G__9179__2;
G__9179.cljs$core$IFn$_invoke$arity$3 = G__9179__3;
return G__9179;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args9150){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9150)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__9180 = meta;
var G__9181 = v.v;
var G__9182 = (v.start + start);
var G__9183 = (v.start + end);
var G__9184 = __hash;
meta = G__9180;
v = G__9181;
start = G__9182;
end = G__9183;
__hash = G__9184;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 * start (inclusive) to end (exclusive).  If end is not supplied,
 * defaults to (count vector). This operation is O(1) and very fast, as
 * the resulting vector shares structure with the original and no
 * trimming is done.
 */
cljs.core.subvec = (function() {
var cljs$core$subvec = null;
var cljs$core$subvec__2 = (function (v,start){
return cljs$core$subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});
var cljs$core$subvec__3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});
cljs$core$subvec = function(v,start,end){
switch(arguments.length){
case 2:
return cljs$core$subvec__2.call(this,v,start);
case 3:
return cljs$core$subvec__3.call(this,v,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subvec.cljs$core$IFn$_invoke$arity$2 = cljs$core$subvec__2;
cljs$core$subvec.cljs$core$IFn$_invoke$arity$3 = cljs$core$subvec__3;
return cljs$core$subvec;
})()
;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj9191 = {};
return obj9191;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__9199 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__9200 = (level - (5));
node = G__9199;
level = G__9200;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 88;
})
cljs.core.TransientVector.prototype.call = (function() {
var G__9204 = null;
var G__9204__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9204__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9204 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9204__2.call(this,self__,k);
case 3:
return G__9204__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9204.cljs$core$IFn$_invoke$arity$2 = G__9204__2;
G__9204.cljs$core$IFn$_invoke$arity$3 = G__9204__3;
return G__9204;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args9201){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9201)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__3740__auto__ = self__.front;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3740__auto__ = self__.rear;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 * false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__9205 = (i + incr);
i = G__9205;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__9206 = (i + (1));
var G__9207 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__9206;
out = G__9207;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = (function (){var obj9211 = {};
return obj9211;
})();
var l = ks.length;
var i_9212 = (0);
while(true){
if((i_9212 < l)){
var k_9213 = (ks[i_9212]);
(new_obj[k_9213] = (obj[k_9213]));

var G__9214 = (i_9212 + (1));
i_9212 = G__9214;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3728__auto__ = (function (){var G__9218 = k;
return goog.isString(G__9218);
})();
if(cljs.core.truth_(and__3728__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3728__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__9219 = init__$1;
var G__9220 = k;
var G__9221 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9219,G__9220,G__9221) : f.call(null,G__9219,G__9220,G__9221));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9222 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9222) : cljs.core.deref.call(null,G__9222));
} else {
var G__9228 = cljs.core.rest(keys__$1);
var G__9229 = init__$2;
keys__$1 = G__9228;
init__$1 = G__9229;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3728__auto__ = (function (){var G__9224 = k;
return goog.isString(G__9224);
})();
if(cljs.core.truth_(and__3728__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3728__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__9225 = k;
return goog.isString(G__9225);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3728__auto__ = (function (){var G__9227 = k;
return goog.isString(G__9227);
})();
if(cljs.core.truth_(and__3728__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3728__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__9215_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__9215_SHARP_,(self__.strobj[p1__9215_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__9230 = null;
var G__9230__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9230__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9230 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9230__2.call(this,self__,k);
case 3:
return G__9230__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9230.cljs$core$IFn$_invoke$arity$2 = G__9230__2;
G__9230.cljs$core$IFn$_invoke$arity$3 = G__9230__3;
return G__9230;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args9216){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9216)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj9232 = {};
return obj9232;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__9233 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9233,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9233,(1),null);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [k,v]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [x,x]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_map_index_of_nil_QMARK_ = (function cljs$core$array_map_index_of_nil_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__9234 = (i + (2));
i = G__9234;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_keyword_QMARK_ = (function cljs$core$array_map_index_of_keyword_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__9235 = (i + (2));
i = G__9235;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_symbol_QMARK_ = (function cljs$core$array_map_index_of_symbol_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__9236 = (i + (2));
i = G__9236;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_identical_QMARK_ = (function cljs$core$array_map_index_of_identical_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__9237 = (i + (2));
i = G__9237;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_equiv_QMARK_ = (function cljs$core$array_map_index_of_equiv_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__9238 = (i + (2));
i = G__9238;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
var arr = m.arr;
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_map_index_of_keyword_QMARK_(arr,m,k);
} else {
if(cljs.core.truth_((function (){var or__3740__auto__ = (function (){var G__9242 = k;
return goog.isString(G__9242);
})();
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_map_index_of_identical_QMARK_(arr,m,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_map_index_of_symbol_QMARK_(arr,m,k);
} else {
if((k == null)){
return cljs.core.array_map_index_of_nil_QMARK_(arr,m,k);
} else {
return cljs.core.array_map_index_of_equiv_QMARK_(arr,m,k);

}
}
}
}
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
var arr = m.arr;
var l = arr.length;
var narr = (new Array((l + (2))));
var i_9243 = (0);
while(true){
if((i_9243 < l)){
(narr[i_9243] = (arr[i_9243]));

var G__9244 = (i_9243 + (1));
i_9243 = G__9244;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9246 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9246) : cljs.core.keys.call(null,G__9246));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9247 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9247) : cljs.core.vals.call(null,G__9247));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9248 = cljs.core.seq(coll);
var chunk__9249 = null;
var count__9250 = (0);
var i__9251 = (0);
while(true){
if((i__9251 < count__9250)){
var vec__9252 = chunk__9249.cljs$core$IIndexed$_nth$arity$2(null,i__9251);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9252,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9252,(1),null);
var G__9253_9266 = v;
var G__9254_9267 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9253_9266,G__9254_9267) : f.call(null,G__9253_9266,G__9254_9267));

var G__9268 = seq__9248;
var G__9269 = chunk__9249;
var G__9270 = count__9250;
var G__9271 = (i__9251 + (1));
seq__9248 = G__9268;
chunk__9249 = G__9269;
count__9250 = G__9270;
i__9251 = G__9271;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9248);
if(temp__4126__auto__){
var seq__9248__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9248__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__9248__$1);
var G__9272 = cljs.core.chunk_rest(seq__9248__$1);
var G__9273 = c__4525__auto__;
var G__9274 = cljs.core.count(c__4525__auto__);
var G__9275 = (0);
seq__9248 = G__9272;
chunk__9249 = G__9273;
count__9250 = G__9274;
i__9251 = G__9275;
continue;
} else {
var vec__9255 = cljs.core.first(seq__9248__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9255,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9255,(1),null);
var G__9256_9276 = v;
var G__9257_9277 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9256_9276,G__9257_9277) : f.call(null,G__9256_9276,G__9257_9277));

var G__9278 = cljs.core.next(seq__9248__$1);
var G__9279 = null;
var G__9280 = (0);
var G__9281 = (0);
seq__9248 = G__9278;
chunk__9249 = G__9279;
count__9250 = G__9280;
i__9251 = G__9281;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__9258 = init__$1;
var G__9259 = (self__.arr[i]);
var G__9260 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9258,G__9259,G__9260) : f.call(null,G__9258,G__9259,G__9260));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9261 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9261) : cljs.core.deref.call(null,G__9261));
} else {
var G__9282 = (i + (2));
var G__9283 = init__$2;
i = G__9282;
init__$1 = G__9283;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__9262 = other;
if(G__9262){
var bit__4407__auto__ = (G__9262.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4407__auto__) || (G__9262.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__9284 = (i + (2));
i = G__9284;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj9264 = {};
return obj9264;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__9285 = (s + (2));
var G__9286 = d;
s = G__9285;
d = G__9286;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__9287 = (s + (2));
var G__9288 = (d + (2));
s = G__9287;
d = G__9288;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__9265 = cljs.core.aclone(self__.arr);
(G__9265[(idx + (1))] = v);

return G__9265;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9289 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9290 = cljs.core.next(es);
ret = G__9289;
es = G__9290;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__9291 = null;
var G__9291__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9291__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9291 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9291__2.call(this,self__,k);
case 3:
return G__9291__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9291.cljs$core$IFn$_invoke$arity$2 = G__9291__2;
G__9291.cljs$core$IFn$_invoke$arity$3 = G__9291__3;
return G__9291;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args9245){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9245)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
if(no_check){
var cnt = (arr__$1.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$1,null));
} else {
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9292 = (i + (2));
var G__9293 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9292;
ret = G__9293;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__9294_9302 = self__.arr;
G__9294_9302.pop();

G__9294_9302.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__9295 = self__.len;
var G__9296 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__9295,G__9296) : cljs.core.array__GT_transient_hash_map.call(null,G__9295,G__9296));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__9297 = o;
if(G__9297){
var bit__4414__auto__ = (G__9297.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4414__auto__) || (G__9297.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9297.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9297);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9297);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__9298 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9298) : cljs.core.key.call(null,G__9298));
})(),(function (){var G__9299 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9299) : cljs.core.val.call(null,G__9299));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__9303 = cljs.core.next(es);
var G__9304 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__9300 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9300) : cljs.core.key.call(null,G__9300));
})(),(function (){var G__9301 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9301) : cljs.core.val.call(null,G__9301));
})());
es = G__9303;
tcoll__$2 = G__9304;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__9305 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__9306 = (i + (2));
out = G__9305;
i = G__9306;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function() {
var cljs$core$clone_and_set = null;
var cljs$core$clone_and_set__3 = (function (arr,i,a){
var G__9309 = cljs.core.aclone(arr);
(G__9309[i] = a);

return G__9309;
});
var cljs$core$clone_and_set__5 = (function (arr,i,a,j,b){
var G__9310 = cljs.core.aclone(arr);
(G__9310[i] = a);

(G__9310[j] = b);

return G__9310;
});
cljs$core$clone_and_set = function(arr,i,a,j,b){
switch(arguments.length){
case 3:
return cljs$core$clone_and_set__3.call(this,arr,i,a);
case 5:
return cljs$core$clone_and_set__5.call(this,arr,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$clone_and_set.cljs$core$IFn$_invoke$arity$3 = cljs$core$clone_and_set__3;
cljs$core$clone_and_set.cljs$core$IFn$_invoke$arity$5 = cljs$core$clone_and_set__5;
return cljs$core$clone_and_set;
})()
;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function() {
var cljs$core$edit_and_set = null;
var cljs$core$edit_and_set__4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});
var cljs$core$edit_and_set__6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});
cljs$core$edit_and_set = function(inode,edit,i,a,j,b){
switch(arguments.length){
case 4:
return cljs$core$edit_and_set__4.call(this,inode,edit,i,a);
case 6:
return cljs$core$edit_and_set__6.call(this,inode,edit,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$edit_and_set.cljs$core$IFn$_invoke$arity$4 = cljs$core$edit_and_set__4;
cljs$core$edit_and_set.cljs$core$IFn$_invoke$arity$6 = cljs$core$edit_and_set__6;
return cljs$core$edit_and_set;
})()
;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__9315 = init__$1;
var G__9316 = k;
var G__9317 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9315,G__9316,G__9317) : f.call(null,G__9315,G__9316,G__9317));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9318 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9318) : cljs.core.deref.call(null,G__9318));
} else {
var G__9319 = (i + (2));
var G__9320 = init__$2;
i = G__9319;
init__$1 = G__9320;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9321 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9321) : cljs.core.create_inode_seq.call(null,G__9321));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9335 = (0);
var j_9336 = (0);
while(true){
if((i_9335 < (32))){
if((((self__.bitmap >>> i_9335) & (1)) === (0))){
var G__9337 = (i_9335 + (1));
var G__9338 = j_9336;
i_9335 = G__9337;
j_9336 = G__9338;
continue;
} else {
(nodes[i_9335] = ((!(((self__.arr[j_9336]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_9336])),(self__.arr[j_9336]),(self__.arr[(j_9336 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9336 + (1))])));

var G__9339 = (i_9335 + (1));
var G__9340 = (j_9336 + (2));
i_9335 = G__9339;
j_9336 = G__9340;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9322 = edit__$1;
var G__9323 = (shift + (5));
var G__9324 = key_or_nil;
var G__9325 = val_or_node;
var G__9326 = hash;
var G__9327 = key;
var G__9328 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__9322,G__9323,G__9324,G__9325,G__9326,G__9327,G__9328) : cljs.core.create_node.call(null,G__9322,G__9323,G__9324,G__9325,G__9326,G__9327,G__9328));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9341 = (0);
var j_9342 = (0);
while(true){
if((i_9341 < (32))){
if((((self__.bitmap >>> i_9341) & (1)) === (0))){
var G__9343 = (i_9341 + (1));
var G__9344 = j_9342;
i_9341 = G__9343;
j_9342 = G__9344;
continue;
} else {
(nodes[i_9341] = ((!(((self__.arr[j_9342]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_9342])),(self__.arr[j_9342]),(self__.arr[(j_9342 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9342 + (1))])));

var G__9345 = (i_9341 + (1));
var G__9346 = (j_9342 + (2));
i_9341 = G__9345;
j_9342 = G__9346;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9329 = (shift + (5));
var G__9330 = key_or_nil;
var G__9331 = val_or_node;
var G__9332 = hash;
var G__9333 = key;
var G__9334 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__9329,G__9330,G__9331,G__9332,G__9333,G__9334) : cljs.core.create_node.call(null,G__9329,G__9330,G__9331,G__9332,G__9333,G__9334));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__9347 = (i + (1));
var G__9348 = (j + (2));
var G__9349 = (bitmap | ((1) << i));
i = G__9347;
j = G__9348;
bitmap = G__9349;
continue;
} else {
var G__9350 = (i + (1));
var G__9351 = j;
var G__9352 = bitmap;
i = G__9350;
j = G__9351;
bitmap = G__9352;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9353 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__9353) : cljs.core.create_array_node_seq.call(null,G__9353));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9354 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9354) : cljs.core.deref.call(null,G__9354));
} else {
var G__9355 = (i + (1));
var G__9356 = init__$2;
i = G__9355;
init__$1 = G__9356;
continue;
}
} else {
var G__9357 = (i + (1));
var G__9358 = init__$1;
i = G__9357;
init__$1 = G__9358;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__9359 = (i + (2));
i = G__9359;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9360 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9360) : cljs.core.create_inode_seq.call(null,G__9360));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function() {
var cljs$core$create_node = null;
var cljs$core$create_node__6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
var cljs$core$create_node__7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
cljs$core$create_node = function(edit,shift,key1,val1,key2hash,key2,val2){
switch(arguments.length){
case 6:
return cljs$core$create_node__6.call(this,edit,shift,key1,val1,key2hash,key2);
case 7:
return cljs$core$create_node__7.call(this,edit,shift,key1,val1,key2hash,key2,val2);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_node.cljs$core$IFn$_invoke$arity$6 = cljs$core$create_node__6;
cljs$core$create_node.cljs$core$IFn$_invoke$arity$7 = cljs$core$create_node__7;
return cljs$core$create_node;
})()
;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__9361 = self__.nodes;
var G__9362 = (self__.i + (2));
var G__9363 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9361,G__9362,G__9363) : cljs.core.create_inode_seq.call(null,G__9361,G__9362,G__9363));
} else {
var G__9364 = self__.nodes;
var G__9365 = self__.i;
var G__9366 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9364,G__9365,G__9366) : cljs.core.create_inode_seq.call(null,G__9364,G__9365,G__9366));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.create_inode_seq = (function() {
var cljs$core$create_inode_seq = null;
var cljs$core$create_inode_seq__1 = (function (nodes){
return cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});
var cljs$core$create_inode_seq__3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4124__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4124__auto__)){
var node = temp__4124__auto__;
var temp__4124__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var node_seq = temp__4124__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__9370 = (j + (2));
j = G__9370;
continue;
}
} else {
var G__9371 = (j + (2));
j = G__9371;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});
cljs$core$create_inode_seq = function(nodes,i,s){
switch(arguments.length){
case 1:
return cljs$core$create_inode_seq__1.call(this,nodes);
case 3:
return cljs$core$create_inode_seq__3.call(this,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$create_inode_seq__1;
cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$3 = cljs$core$create_inode_seq__3;
return cljs$core$create_inode_seq;
})()
;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__9372 = null;
var G__9373 = self__.nodes;
var G__9374 = self__.i;
var G__9375 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__9372,G__9373,G__9374,G__9375) : cljs.core.create_array_node_seq.call(null,G__9372,G__9373,G__9374,G__9375));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.create_array_node_seq = (function() {
var cljs$core$create_array_node_seq = null;
var cljs$core$create_array_node_seq__1 = (function (nodes){
return cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});
var cljs$core$create_array_node_seq__4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4124__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4124__auto__)){
var nj = temp__4124__auto__;
var temp__4124__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var ns = temp__4124__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__9380 = (j + (1));
j = G__9380;
continue;
}
} else {
var G__9381 = (j + (1));
j = G__9381;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});
cljs$core$create_array_node_seq = function(meta,nodes,i,s){
switch(arguments.length){
case 1:
return cljs$core$create_array_node_seq__1.call(this,meta);
case 4:
return cljs$core$create_array_node_seq__4.call(this,meta,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$create_array_node_seq__1;
cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = cljs$core$create_array_node_seq__4;
return cljs$core$create_array_node_seq;
})()
;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9383 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9383) : cljs.core.keys.call(null,G__9383));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9384 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9384) : cljs.core.vals.call(null,G__9384));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9385 = cljs.core.seq(coll);
var chunk__9386 = null;
var count__9387 = (0);
var i__9388 = (0);
while(true){
if((i__9388 < count__9387)){
var vec__9389 = chunk__9386.cljs$core$IIndexed$_nth$arity$2(null,i__9388);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9389,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9389,(1),null);
var G__9390_9401 = v;
var G__9391_9402 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9390_9401,G__9391_9402) : f.call(null,G__9390_9401,G__9391_9402));

var G__9403 = seq__9385;
var G__9404 = chunk__9386;
var G__9405 = count__9387;
var G__9406 = (i__9388 + (1));
seq__9385 = G__9403;
chunk__9386 = G__9404;
count__9387 = G__9405;
i__9388 = G__9406;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9385);
if(temp__4126__auto__){
var seq__9385__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9385__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__9385__$1);
var G__9407 = cljs.core.chunk_rest(seq__9385__$1);
var G__9408 = c__4525__auto__;
var G__9409 = cljs.core.count(c__4525__auto__);
var G__9410 = (0);
seq__9385 = G__9407;
chunk__9386 = G__9408;
count__9387 = G__9409;
i__9388 = G__9410;
continue;
} else {
var vec__9392 = cljs.core.first(seq__9385__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9392,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9392,(1),null);
var G__9393_9411 = v;
var G__9394_9412 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9393_9411,G__9394_9412) : f.call(null,G__9393_9411,G__9394_9412));

var G__9413 = cljs.core.next(seq__9385__$1);
var G__9414 = null;
var G__9415 = (0);
var G__9416 = (0);
seq__9385 = G__9413;
chunk__9386 = G__9414;
count__9387 = G__9415;
i__9388 = G__9416;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__9395 = init;
var G__9396 = null;
var G__9397 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9395,G__9396,G__9397) : f.call(null,G__9395,G__9396,G__9397));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9398 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9398) : cljs.core.deref.call(null,G__9398));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj9400 = {};
return obj9400;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9417 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9418 = cljs.core.next(es);
ret = G__9417;
es = G__9418;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__9419 = null;
var G__9419__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9419__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9419 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9419__2.call(this,self__,k);
case 3:
return G__9419__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9419.cljs$core$IFn$_invoke$arity$2 = G__9419__2;
G__9419.cljs$core$IFn$_invoke$arity$3 = G__9419__3;
return G__9419;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args9382){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9382)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9420 = (i + (2));
var G__9421 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9420;
ret = G__9421;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9422 = (i + (1));
var G__9423 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__9422;
out = G__9423;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__9424 = o;
if(G__9424){
var bit__4414__auto__ = (G__9424.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4414__auto__) || (G__9424.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9424.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9424);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9424);
}
})()){
return tcoll.assoc_BANG_((function (){var G__9425 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9425) : cljs.core.key.call(null,G__9425));
})(),(function (){var G__9426 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9426) : cljs.core.val.call(null,G__9426));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__9429 = cljs.core.next(es);
var G__9430 = tcoll__$1.assoc_BANG_((function (){var G__9427 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9427) : cljs.core.key.call(null,G__9427));
})(),(function (){var G__9428 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9428) : cljs.core.val.call(null,G__9428));
})());
es = G__9429;
tcoll__$1 = G__9430;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__9431 = ((ascending_QMARK_)?t.left:t.right);
var G__9432 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__9431;
stack__$1 = G__9432;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9445 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9445) : cljs.core.deref.call(null,G__9445));
} else {
var init__$2 = (function (){var G__9446 = init__$1;
var G__9447 = node.key;
var G__9448 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9446,G__9447,G__9448) : f.call(null,G__9446,G__9447,G__9448));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9449 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9449) : cljs.core.deref.call(null,G__9449));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__9450 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9450) : cljs.core.deref.call(null,G__9450));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__9452 = null;
var G__9452__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9452__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9452 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9452__2.call(this,self__,k);
case 3:
return G__9452__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9452.cljs$core$IFn$_invoke$arity$2 = G__9452__2;
G__9452.cljs$core$IFn$_invoke$arity$3 = G__9452__3;
return G__9452;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args9451){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9451)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__9454 = null;
var G__9454__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9454__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9454 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9454__2.call(this,self__,k);
case 3:
return G__9454__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9454.cljs$core$IFn$_invoke$arity$2 = G__9454__2;
G__9454.cljs$core$IFn$_invoke$arity$3 = G__9454__3;
return G__9454;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args9453){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9453)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__9467 = k;
var G__9468 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9467,G__9468) : comp.call(null,G__9467,G__9468));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__9487 = k;
var G__9488 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9487,G__9488) : comp.call(null,G__9487,G__9488));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__9499 = k;
var G__9500 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9499,G__9500) : comp.call(null,G__9499,G__9500));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9502 = cljs.core.seq(coll);
var chunk__9503 = null;
var count__9504 = (0);
var i__9505 = (0);
while(true){
if((i__9505 < count__9504)){
var vec__9506 = chunk__9503.cljs$core$IIndexed$_nth$arity$2(null,i__9505);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9506,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9506,(1),null);
var G__9507_9519 = v;
var G__9508_9520 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9507_9519,G__9508_9520) : f.call(null,G__9507_9519,G__9508_9520));

var G__9521 = seq__9502;
var G__9522 = chunk__9503;
var G__9523 = count__9504;
var G__9524 = (i__9505 + (1));
seq__9502 = G__9521;
chunk__9503 = G__9522;
count__9504 = G__9523;
i__9505 = G__9524;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9502);
if(temp__4126__auto__){
var seq__9502__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9502__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__9502__$1);
var G__9525 = cljs.core.chunk_rest(seq__9502__$1);
var G__9526 = c__4525__auto__;
var G__9527 = cljs.core.count(c__4525__auto__);
var G__9528 = (0);
seq__9502 = G__9525;
chunk__9503 = G__9526;
count__9504 = G__9527;
i__9505 = G__9528;
continue;
} else {
var vec__9509 = cljs.core.first(seq__9502__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9509,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9509,(1),null);
var G__9510_9529 = v;
var G__9511_9530 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9510_9529,G__9511_9530) : f.call(null,G__9510_9529,G__9511_9530));

var G__9531 = cljs.core.next(seq__9502__$1);
var G__9532 = null;
var G__9533 = (0);
var G__9534 = (0);
seq__9502 = G__9531;
chunk__9503 = G__9532;
count__9504 = G__9533;
i__9505 = G__9534;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9512 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9512) : cljs.core.keys.call(null,G__9512));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9513 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9513) : cljs.core.vals.call(null,G__9513));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9514 = k;
var G__9515 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9514,G__9515) : self__.comp.call(null,G__9514,G__9515));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__9535 = t.left;
t = G__9535;
continue;
} else {
var G__9536 = t.right;
t = G__9536;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9537 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9538 = cljs.core.next(es);
ret = G__9537;
es = G__9538;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__9539 = null;
var G__9539__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9539__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9539 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9539__2.call(this,self__,k);
case 3:
return G__9539__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9539.cljs$core$IFn$_invoke$arity$2 = G__9539__2;
G__9539.cljs$core$IFn$_invoke$arity$3 = G__9539__3;
return G__9539;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args9501){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9501)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9516 = k;
var G__9517 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9516,G__9517) : self__.comp.call(null,G__9516,G__9517));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__9540 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9541 = t.left;
stack = G__9540;
t = G__9541;
continue;
} else {
var G__9542 = stack;
var G__9543 = t.right;
stack = G__9542;
t = G__9543;
continue;
}
} else {
if((c > (0))){
var G__9544 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9545 = t.right;
stack = G__9544;
t = G__9545;
continue;
} else {
var G__9546 = stack;
var G__9547 = t.left;
stack = G__9546;
t = G__9547;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__9518 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9518) : cljs.core.key.call(null,G__9518));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * keyval => key val
 * Returns a new hash map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.hash_map = (function() { 
var cljs$core$hash_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__9548 = cljs.core.nnext(in$);
var G__9549 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9548;
out = G__9549;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
};
var cljs$core$hash_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9550__i = 0, G__9550__a = new Array(arguments.length -  0);
while (G__9550__i < G__9550__a.length) {G__9550__a[G__9550__i] = arguments[G__9550__i + 0]; ++G__9550__i;}
  keyvals = new cljs.core.IndexedSeq(G__9550__a,0);
} 
return cljs$core$hash_map__delegate.call(this,keyvals);};
cljs$core$hash_map.cljs$lang$maxFixedArity = 0;
cljs$core$hash_map.cljs$lang$applyTo = (function (arglist__9551){
var keyvals = cljs.core.seq(arglist__9551);
return cljs$core$hash_map__delegate(keyvals);
});
cljs$core$hash_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$hash_map__delegate;
return cljs$core$hash_map;
})()
;
/**
 * keyval => key val
 * Returns a new array map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.array_map = (function() { 
var cljs$core$array_map__delegate = function (keyvals){
return cljs.core.PersistentArrayMap.fromArray(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array,keyvals),true,false);
};
var cljs$core$array_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9552__i = 0, G__9552__a = new Array(arguments.length -  0);
while (G__9552__i < G__9552__a.length) {G__9552__a[G__9552__i] = arguments[G__9552__i + 0]; ++G__9552__i;}
  keyvals = new cljs.core.IndexedSeq(G__9552__a,0);
} 
return cljs$core$array_map__delegate.call(this,keyvals);};
cljs$core$array_map.cljs$lang$maxFixedArity = 0;
cljs$core$array_map.cljs$lang$applyTo = (function (arglist__9553){
var keyvals = cljs.core.seq(arglist__9553);
return cljs$core$array_map__delegate(keyvals);
});
cljs$core$array_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$array_map__delegate;
return cljs$core$array_map;
})()
;
/**
 * keyval => key val
 * Returns a new object map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.obj_map = (function() { 
var cljs$core$obj_map__delegate = function (keyvals){
var ks = [];
var obj = (function (){var obj9557 = {};
return obj9557;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__9558 = cljs.core.nnext(kvs);
kvs = G__9558;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
};
var cljs$core$obj_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9559__i = 0, G__9559__a = new Array(arguments.length -  0);
while (G__9559__i < G__9559__a.length) {G__9559__a[G__9559__i] = arguments[G__9559__i + 0]; ++G__9559__i;}
  keyvals = new cljs.core.IndexedSeq(G__9559__a,0);
} 
return cljs$core$obj_map__delegate.call(this,keyvals);};
cljs$core$obj_map.cljs$lang$maxFixedArity = 0;
cljs$core$obj_map.cljs$lang$applyTo = (function (arglist__9560){
var keyvals = cljs.core.seq(arglist__9560);
return cljs$core$obj_map__delegate(keyvals);
});
cljs$core$obj_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$obj_map__delegate;
return cljs$core$obj_map;
})()
;
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.sorted_map = (function() { 
var cljs$core$sorted_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__9561 = cljs.core.nnext(in$);
var G__9562 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9561;
out = G__9562;
continue;
} else {
return out;
}
break;
}
};
var cljs$core$sorted_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9563__i = 0, G__9563__a = new Array(arguments.length -  0);
while (G__9563__i < G__9563__a.length) {G__9563__a[G__9563__i] = arguments[G__9563__i + 0]; ++G__9563__i;}
  keyvals = new cljs.core.IndexedSeq(G__9563__a,0);
} 
return cljs$core$sorted_map__delegate.call(this,keyvals);};
cljs$core$sorted_map.cljs$lang$maxFixedArity = 0;
cljs$core$sorted_map.cljs$lang$applyTo = (function (arglist__9564){
var keyvals = cljs.core.seq(arglist__9564);
return cljs$core$sorted_map__delegate(keyvals);
});
cljs$core$sorted_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_map__delegate;
return cljs$core$sorted_map;
})()
;
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings, using the supplied comparator.
 * @param {...*} var_args
 */
cljs.core.sorted_map_by = (function() { 
var cljs$core$sorted_map_by__delegate = function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__9565 = cljs.core.nnext(in$);
var G__9566 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9565;
out = G__9566;
continue;
} else {
return out;
}
break;
}
};
var cljs$core$sorted_map_by = function (comparator,var_args){
var keyvals = null;
if (arguments.length > 1) {
var G__9567__i = 0, G__9567__a = new Array(arguments.length -  1);
while (G__9567__i < G__9567__a.length) {G__9567__a[G__9567__i] = arguments[G__9567__i + 1]; ++G__9567__i;}
  keyvals = new cljs.core.IndexedSeq(G__9567__a,0);
} 
return cljs$core$sorted_map_by__delegate.call(this,comparator,keyvals);};
cljs$core$sorted_map_by.cljs$lang$maxFixedArity = 1;
cljs$core$sorted_map_by.cljs$lang$applyTo = (function (arglist__9568){
var comparator = cljs.core.first(arglist__9568);
var keyvals = cljs.core.rest(arglist__9568);
return cljs$core$sorted_map_by__delegate(comparator,keyvals);
});
cljs$core$sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_map_by__delegate;
return cljs$core$sorted_map_by;
})()
;

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9569 = self__.mseq;
if(G__9569){
var bit__4414__auto__ = (G__9569.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4414__auto__) || (G__9569.cljs$core$INext$)){
return true;
} else {
if((!G__9569.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9569);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9569);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9570 = self__.mseq;
if(G__9570){
var bit__4414__auto__ = (G__9570.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4414__auto__) || (G__9570.cljs$core$INext$)){
return true;
} else {
if((!G__9570.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9570);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9570);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9571 = self__.mseq;
if(G__9571){
var bit__4414__auto__ = (G__9571.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4414__auto__) || (G__9571.cljs$core$INext$)){
return true;
} else {
if((!G__9571.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9571);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9571);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9572 = self__.mseq;
if(G__9572){
var bit__4414__auto__ = (G__9572.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4414__auto__) || (G__9572.cljs$core$INext$)){
return true;
} else {
if((!G__9572.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9572);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9572);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping from
 * the latter (left-to-right) will be the mapping in the result.
 * @param {...*} var_args
 */
cljs.core.merge = (function() { 
var cljs$core$merge__delegate = function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__9573_SHARP_,p2__9574_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3740__auto__ = p1__9573_SHARP_;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__9574_SHARP_);
}),maps);
} else {
return null;
}
};
var cljs$core$merge = function (var_args){
var maps = null;
if (arguments.length > 0) {
var G__9575__i = 0, G__9575__a = new Array(arguments.length -  0);
while (G__9575__i < G__9575__a.length) {G__9575__a[G__9575__i] = arguments[G__9575__i + 0]; ++G__9575__i;}
  maps = new cljs.core.IndexedSeq(G__9575__a,0);
} 
return cljs$core$merge__delegate.call(this,maps);};
cljs$core$merge.cljs$lang$maxFixedArity = 0;
cljs$core$merge.cljs$lang$applyTo = (function (arglist__9576){
var maps = cljs.core.seq(arglist__9576);
return cljs$core$merge__delegate(maps);
});
cljs$core$merge.cljs$core$IFn$_invoke$arity$variadic = cljs$core$merge__delegate;
return cljs$core$merge;
})()
;
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping(s)
 * from the latter (left-to-right) will be combined with the mapping in
 * the result by calling (f val-in-result val-in-latter).
 * @param {...*} var_args
 */
cljs.core.merge_with = (function() { 
var cljs$core$merge_with__delegate = function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9580 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9579,G__9580) : f.call(null,G__9579,G__9580));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__3740__auto__ = m1;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
};
var cljs$core$merge_with = function (f,var_args){
var maps = null;
if (arguments.length > 1) {
var G__9581__i = 0, G__9581__a = new Array(arguments.length -  1);
while (G__9581__i < G__9581__a.length) {G__9581__a[G__9581__i] = arguments[G__9581__i + 1]; ++G__9581__i;}
  maps = new cljs.core.IndexedSeq(G__9581__a,0);
} 
return cljs$core$merge_with__delegate.call(this,f,maps);};
cljs$core$merge_with.cljs$lang$maxFixedArity = 1;
cljs$core$merge_with.cljs$lang$applyTo = (function (arglist__9582){
var f = cljs.core.first(arglist__9582);
var maps = cljs.core.rest(arglist__9582);
return cljs$core$merge_with__delegate(f,maps);
});
cljs$core$merge_with.cljs$core$IFn$_invoke$arity$variadic = cljs$core$merge_with__delegate;
return cljs$core$merge_with;
})()
;
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__9583 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__9584 = cljs.core.next(keys);
ret = G__9583;
keys = G__9584;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9587 = cljs.core.seq(coll);
var chunk__9588 = null;
var count__9589 = (0);
var i__9590 = (0);
while(true){
if((i__9590 < count__9589)){
var vec__9591 = chunk__9588.cljs$core$IIndexed$_nth$arity$2(null,i__9590);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9591,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9591,(1),null);
var G__9592_9597 = v;
var G__9593_9598 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9592_9597,G__9593_9598) : f.call(null,G__9592_9597,G__9593_9598));

var G__9599 = seq__9587;
var G__9600 = chunk__9588;
var G__9601 = count__9589;
var G__9602 = (i__9590 + (1));
seq__9587 = G__9599;
chunk__9588 = G__9600;
count__9589 = G__9601;
i__9590 = G__9602;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9587);
if(temp__4126__auto__){
var seq__9587__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9587__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__9587__$1);
var G__9603 = cljs.core.chunk_rest(seq__9587__$1);
var G__9604 = c__4525__auto__;
var G__9605 = cljs.core.count(c__4525__auto__);
var G__9606 = (0);
seq__9587 = G__9603;
chunk__9588 = G__9604;
count__9589 = G__9605;
i__9590 = G__9606;
continue;
} else {
var vec__9594 = cljs.core.first(seq__9587__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9594,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9594,(1),null);
var G__9595_9607 = v;
var G__9596_9608 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9595_9607,G__9596_9608) : f.call(null,G__9595_9607,G__9596_9608));

var G__9609 = cljs.core.next(seq__9587__$1);
var G__9610 = null;
var G__9611 = (0);
var G__9612 = (0);
seq__9587 = G__9609;
chunk__9588 = G__9610;
count__9589 = G__9611;
i__9590 = G__9612;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9585_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9585_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__9613 = null;
var G__9613__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9613__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9613 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9613__2.call(this,self__,k);
case 3:
return G__9613__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9613.cljs$core$IFn$_invoke$arity$2 = G__9613__2;
G__9613.cljs$core$IFn$_invoke$arity$3 = G__9613__3;
return G__9613;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args9586){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9586)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9614 = (i + (1));
var G__9615 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__9614;
out = G__9615;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__9616 = (i + (1));
var G__9617 = cljs.core._conj_BANG_(out,(items[i]));
i = G__9616;
out = G__9617;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 136;
})
cljs.core.TransientHashSet.prototype.call = (function() {
var G__9619 = null;
var G__9619__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__9619__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__9619 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9619__2.call(this,self__,k);
case 3:
return G__9619__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9619.cljs$core$IFn$_invoke$arity$2 = G__9619__2;
G__9619.cljs$core$IFn$_invoke$arity$3 = G__9619__3;
return G__9619;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args9618){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9618)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9622 = cljs.core.seq(coll);
var chunk__9623 = null;
var count__9624 = (0);
var i__9625 = (0);
while(true){
if((i__9625 < count__9624)){
var vec__9626 = chunk__9623.cljs$core$IIndexed$_nth$arity$2(null,i__9625);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9626,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9626,(1),null);
var G__9627_9632 = v;
var G__9628_9633 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9627_9632,G__9628_9633) : f.call(null,G__9627_9632,G__9628_9633));

var G__9634 = seq__9622;
var G__9635 = chunk__9623;
var G__9636 = count__9624;
var G__9637 = (i__9625 + (1));
seq__9622 = G__9634;
chunk__9623 = G__9635;
count__9624 = G__9636;
i__9625 = G__9637;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9622);
if(temp__4126__auto__){
var seq__9622__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9622__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__9622__$1);
var G__9638 = cljs.core.chunk_rest(seq__9622__$1);
var G__9639 = c__4525__auto__;
var G__9640 = cljs.core.count(c__4525__auto__);
var G__9641 = (0);
seq__9622 = G__9638;
chunk__9623 = G__9639;
count__9624 = G__9640;
i__9625 = G__9641;
continue;
} else {
var vec__9629 = cljs.core.first(seq__9622__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9629,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9629,(1),null);
var G__9630_9642 = v;
var G__9631_9643 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9630_9642,G__9631_9643) : f.call(null,G__9630_9642,G__9631_9643));

var G__9644 = cljs.core.next(seq__9622__$1);
var G__9645 = null;
var G__9646 = (0);
var G__9647 = (0);
seq__9622 = G__9644;
chunk__9623 = G__9645;
count__9624 = G__9646;
i__9625 = G__9647;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9620_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9620_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__9648 = null;
var G__9648__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9648__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9648 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9648__2.call(this,self__,k);
case 3:
return G__9648__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9648.cljs$core$IFn$_invoke$arity$2 = G__9648__2;
G__9648.cljs$core$IFn$_invoke$arity$3 = G__9648__3;
return G__9648;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args9621){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9621)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4619__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__4619__auto__.length)){
var G__9649 = (i + (1));
var G__9650 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__9649;
res = G__9650;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__9651 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__9652 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__9651;
out = G__9652;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 * handled as if by repeated uses of conj.
 * @param {...*} var_args
 */
cljs.core.hash_set = (function() {
var cljs$core$hash_set = null;
var cljs$core$hash_set__0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});
var cljs$core$hash_set__1 = (function() { 
var G__9653__delegate = function (keys){
return cljs.core.set(keys);
};
var G__9653 = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__9654__i = 0, G__9654__a = new Array(arguments.length -  0);
while (G__9654__i < G__9654__a.length) {G__9654__a[G__9654__i] = arguments[G__9654__i + 0]; ++G__9654__i;}
  keys = new cljs.core.IndexedSeq(G__9654__a,0);
} 
return G__9653__delegate.call(this,keys);};
G__9653.cljs$lang$maxFixedArity = 0;
G__9653.cljs$lang$applyTo = (function (arglist__9655){
var keys = cljs.core.seq(arglist__9655);
return G__9653__delegate(keys);
});
G__9653.cljs$core$IFn$_invoke$arity$variadic = G__9653__delegate;
return G__9653;
})()
;
cljs$core$hash_set = function(var_args){
var keys = var_args;
switch(arguments.length){
case 0:
return cljs$core$hash_set__0.call(this);
default:
var G__9656 = null;
if (arguments.length > 0) {
var G__9657__i = 0, G__9657__a = new Array(arguments.length -  0);
while (G__9657__i < G__9657__a.length) {G__9657__a[G__9657__i] = arguments[G__9657__i + 0]; ++G__9657__i;}
G__9656 = new cljs.core.IndexedSeq(G__9657__a,0);
}
return cljs$core$hash_set__1.cljs$core$IFn$_invoke$arity$variadic(G__9656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$hash_set.cljs$lang$maxFixedArity = 0;
cljs$core$hash_set.cljs$lang$applyTo = cljs$core$hash_set__1.cljs$lang$applyTo;
cljs$core$hash_set.cljs$core$IFn$_invoke$arity$0 = cljs$core$hash_set__0;
cljs$core$hash_set.cljs$core$IFn$_invoke$arity$variadic = cljs$core$hash_set__1.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$hash_set;
})()
;
/**
 * Returns a new sorted set with supplied keys.
 * @param {...*} var_args
 */
cljs.core.sorted_set = (function() { 
var cljs$core$sorted_set__delegate = function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
};
var cljs$core$sorted_set = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__9658__i = 0, G__9658__a = new Array(arguments.length -  0);
while (G__9658__i < G__9658__a.length) {G__9658__a[G__9658__i] = arguments[G__9658__i + 0]; ++G__9658__i;}
  keys = new cljs.core.IndexedSeq(G__9658__a,0);
} 
return cljs$core$sorted_set__delegate.call(this,keys);};
cljs$core$sorted_set.cljs$lang$maxFixedArity = 0;
cljs$core$sorted_set.cljs$lang$applyTo = (function (arglist__9659){
var keys = cljs.core.seq(arglist__9659);
return cljs$core$sorted_set__delegate(keys);
});
cljs$core$sorted_set.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_set__delegate;
return cljs$core$sorted_set;
})()
;
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 * @param {...*} var_args
 */
cljs.core.sorted_set_by = (function() { 
var cljs$core$sorted_set_by__delegate = function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
};
var cljs$core$sorted_set_by = function (comparator,var_args){
var keys = null;
if (arguments.length > 1) {
var G__9660__i = 0, G__9660__a = new Array(arguments.length -  1);
while (G__9660__i < G__9660__a.length) {G__9660__a[G__9660__i] = arguments[G__9660__i + 1]; ++G__9660__i;}
  keys = new cljs.core.IndexedSeq(G__9660__a,0);
} 
return cljs$core$sorted_set_by__delegate.call(this,comparator,keys);};
cljs$core$sorted_set_by.cljs$lang$maxFixedArity = 1;
cljs$core$sorted_set_by.cljs$lang$applyTo = (function (arglist__9661){
var comparator = cljs.core.first(arglist__9661);
var keys = cljs.core.rest(arglist__9661);
return cljs$core$sorted_set_by__delegate(comparator,keys);
});
cljs$core$sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_set_by__delegate;
return cljs$core$sorted_set_by;
})()
;
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 * vector/seq with any elements = a key in smap replaced with the
 * corresponding val in smap.  Returns a transducer when no collection
 * is provided.
 */
cljs.core.replace = (function() {
var cljs$core$replace = null;
var cljs$core$replace__1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9662_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__9662_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.val(e);
} else {
return p1__9662_SHARP_;
}
}));
});
var cljs$core$replace__2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4124__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9663_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__9663_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.second(e);
} else {
return p1__9663_SHARP_;
}
}),coll);
}
});
cljs$core$replace = function(smap,coll){
switch(arguments.length){
case 1:
return cljs$core$replace__1.call(this,smap);
case 2:
return cljs$core$replace__2.call(this,smap,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$replace.cljs$core$IFn$_invoke$arity$1 = cljs$core$replace__1;
cljs$core$replace.cljs$core$IFn$_invoke$arity$2 = cljs$core$replace__2;
return cljs$core$replace;
})()
;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed
 */
cljs.core.distinct = (function() {
var cljs$core$distinct = null;
var cljs$core$distinct__0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__9684 = null;
var G__9684__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9684__1 = (function (result){
var G__9674 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9674) : rf.call(null,G__9674));
});
var G__9684__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__9675 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9675) : cljs.core.deref.call(null,G__9675));
})(),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

var G__9676 = result;
var G__9677 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9676,G__9677) : rf.call(null,G__9676,G__9677));
}
});
G__9684 = function(result,input){
switch(arguments.length){
case 0:
return G__9684__0.call(this);
case 1:
return G__9684__1.call(this,result);
case 2:
return G__9684__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9684.cljs$core$IFn$_invoke$arity$0 = G__9684__0;
G__9684.cljs$core$IFn$_invoke$arity$1 = G__9684__1;
G__9684.cljs$core$IFn$_invoke$arity$2 = G__9684__2;
return G__9684;
})()
;})(seen))
});
});
var cljs$core$distinct__1 = (function (coll){
var step = (function cljs$core$distinct_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__9682,seen__$1){
while(true){
var vec__9683 = p__9682;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9683,(0),null);
var xs__$1 = vec__9683;
var temp__4126__auto__ = cljs.core.seq(xs__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__9685 = cljs.core.rest(s);
var G__9686 = seen__$1;
p__9682 = G__9685;
seen__$1 = G__9686;
continue;
} else {
return cljs.core.cons(f,cljs$core$distinct_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
cljs$core$distinct = function(coll){
switch(arguments.length){
case 0:
return cljs$core$distinct__0.call(this);
case 1:
return cljs$core$distinct__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$distinct.cljs$core$IFn$_invoke$arity$0 = cljs$core$distinct__0;
cljs$core$distinct.cljs$core$IFn$_invoke$arity$1 = cljs$core$distinct__1;
return cljs$core$distinct;
})()
;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__9687 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__9688 = cljs.core.next(s__$1);
ret = G__9687;
s__$1 = G__9688;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((function (){var G__9690 = x;
if(G__9690){
var bit__4407__auto__ = (G__9690.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4407__auto__) || (G__9690.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__9691 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__9692 = cljs.core.next(ks);
var G__9693 = cljs.core.next(vs);
map = G__9691;
ks = G__9692;
vs = G__9693;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 * @param {...*} var_args
 */
cljs.core.max_key = (function() {
var cljs$core$max_key = null;
var cljs$core$max_key__2 = (function (k,x){
return x;
});
var cljs$core$max_key__3 = (function (k,x,y){
if(((function (){var G__9704 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9704) : k.call(null,G__9704));
})() > (function (){var G__9705 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9705) : k.call(null,G__9705));
})())){
return x;
} else {
return y;
}
});
var cljs$core$max_key__4 = (function() { 
var G__9706__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9694_SHARP_,p2__9695_SHARP_){
return cljs$core$max_key.cljs$core$IFn$_invoke$arity$3(k,p1__9694_SHARP_,p2__9695_SHARP_);
}),cljs$core$max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__9706 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__9707__i = 0, G__9707__a = new Array(arguments.length -  3);
while (G__9707__i < G__9707__a.length) {G__9707__a[G__9707__i] = arguments[G__9707__i + 3]; ++G__9707__i;}
  more = new cljs.core.IndexedSeq(G__9707__a,0);
} 
return G__9706__delegate.call(this,k,x,y,more);};
G__9706.cljs$lang$maxFixedArity = 3;
G__9706.cljs$lang$applyTo = (function (arglist__9708){
var k = cljs.core.first(arglist__9708);
arglist__9708 = cljs.core.next(arglist__9708);
var x = cljs.core.first(arglist__9708);
arglist__9708 = cljs.core.next(arglist__9708);
var y = cljs.core.first(arglist__9708);
var more = cljs.core.rest(arglist__9708);
return G__9706__delegate(k,x,y,more);
});
G__9706.cljs$core$IFn$_invoke$arity$variadic = G__9706__delegate;
return G__9706;
})()
;
cljs$core$max_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$max_key__2.call(this,k,x);
case 3:
return cljs$core$max_key__3.call(this,k,x,y);
default:
var G__9709 = null;
if (arguments.length > 3) {
var G__9710__i = 0, G__9710__a = new Array(arguments.length -  3);
while (G__9710__i < G__9710__a.length) {G__9710__a[G__9710__i] = arguments[G__9710__i + 3]; ++G__9710__i;}
G__9709 = new cljs.core.IndexedSeq(G__9710__a,0);
}
return cljs$core$max_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__9709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$max_key.cljs$lang$maxFixedArity = 3;
cljs$core$max_key.cljs$lang$applyTo = cljs$core$max_key__4.cljs$lang$applyTo;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$2 = cljs$core$max_key__2;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$3 = cljs$core$max_key__3;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$variadic = cljs$core$max_key__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$max_key;
})()
;
/**
 * Returns the x for which (k x), a number, is least.
 * @param {...*} var_args
 */
cljs.core.min_key = (function() {
var cljs$core$min_key = null;
var cljs$core$min_key__2 = (function (k,x){
return x;
});
var cljs$core$min_key__3 = (function (k,x,y){
if(((function (){var G__9721 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9721) : k.call(null,G__9721));
})() < (function (){var G__9722 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9722) : k.call(null,G__9722));
})())){
return x;
} else {
return y;
}
});
var cljs$core$min_key__4 = (function() { 
var G__9723__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9711_SHARP_,p2__9712_SHARP_){
return cljs$core$min_key.cljs$core$IFn$_invoke$arity$3(k,p1__9711_SHARP_,p2__9712_SHARP_);
}),cljs$core$min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__9723 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__9724__i = 0, G__9724__a = new Array(arguments.length -  3);
while (G__9724__i < G__9724__a.length) {G__9724__a[G__9724__i] = arguments[G__9724__i + 3]; ++G__9724__i;}
  more = new cljs.core.IndexedSeq(G__9724__a,0);
} 
return G__9723__delegate.call(this,k,x,y,more);};
G__9723.cljs$lang$maxFixedArity = 3;
G__9723.cljs$lang$applyTo = (function (arglist__9725){
var k = cljs.core.first(arglist__9725);
arglist__9725 = cljs.core.next(arglist__9725);
var x = cljs.core.first(arglist__9725);
arglist__9725 = cljs.core.next(arglist__9725);
var y = cljs.core.first(arglist__9725);
var more = cljs.core.rest(arglist__9725);
return G__9723__delegate(k,x,y,more);
});
G__9723.cljs$core$IFn$_invoke$arity$variadic = G__9723__delegate;
return G__9723;
})()
;
cljs$core$min_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$min_key__2.call(this,k,x);
case 3:
return cljs$core$min_key__3.call(this,k,x,y);
default:
var G__9726 = null;
if (arguments.length > 3) {
var G__9727__i = 0, G__9727__a = new Array(arguments.length -  3);
while (G__9727__i < G__9727__a.length) {G__9727__a[G__9727__i] = arguments[G__9727__i + 3]; ++G__9727__i;}
G__9726 = new cljs.core.IndexedSeq(G__9727__a,0);
}
return cljs$core$min_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__9726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$min_key.cljs$lang$maxFixedArity = 3;
cljs$core$min_key.cljs$lang$applyTo = cljs$core$min_key__4.cljs$lang$applyTo;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$2 = cljs$core$min_key__2;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$3 = cljs$core$min_key__3;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$variadic = cljs$core$min_key__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$min_key;
})()
;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 * partitions with fewer than n items at the end.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_all = (function() {
var cljs$core$partition_all = null;
var cljs$core$partition_all__1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__9744 = null;
var G__9744__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9744__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9739 = result;
var G__9740 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9739,G__9740) : rf.call(null,G__9739,G__9740));
})());
})());
var G__9741 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9741) : rf.call(null,G__9741));
});
var G__9744__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__9742 = result;
var G__9743 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9742,G__9743) : rf.call(null,G__9742,G__9743));
} else {
return result;
}
});
G__9744 = function(result,input){
switch(arguments.length){
case 0:
return G__9744__0.call(this);
case 1:
return G__9744__1.call(this,result);
case 2:
return G__9744__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9744.cljs$core$IFn$_invoke$arity$0 = G__9744__0;
G__9744.cljs$core$IFn$_invoke$arity$1 = G__9744__1;
G__9744.cljs$core$IFn$_invoke$arity$2 = G__9744__2;
return G__9744;
})()
;})(a))
});
});
var cljs$core$partition_all__2 = (function (n,coll){
return cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var cljs$core$partition_all__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});
cljs$core$partition_all = function(n,step,coll){
switch(arguments.length){
case 1:
return cljs$core$partition_all__1.call(this,n);
case 2:
return cljs$core$partition_all__2.call(this,n,step);
case 3:
return cljs$core$partition_all__3.call(this,n,step,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$1 = cljs$core$partition_all__1;
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition_all__2;
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3 = cljs$core$partition_all__3;
return cljs$core$partition_all;
})()
;
/**
 * Returns a lazy sequence of successive items from coll while
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function() {
var cljs$core$take_while = null;
var cljs$core$take_while__1 = (function (pred){
return (function (rf){
return (function() {
var G__9757 = null;
var G__9757__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9757__1 = (function (result){
var G__9752 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9752) : rf.call(null,G__9752));
});
var G__9757__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__9753 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9753) : pred.call(null,G__9753));
})())){
var G__9754 = result;
var G__9755 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9754,G__9755) : rf.call(null,G__9754,G__9755));
} else {
return cljs.core.reduced(result);
}
});
G__9757 = function(result,input){
switch(arguments.length){
case 0:
return G__9757__0.call(this);
case 1:
return G__9757__1.call(this,result);
case 2:
return G__9757__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9757.cljs$core$IFn$_invoke$arity$0 = G__9757__0;
G__9757.cljs$core$IFn$_invoke$arity$1 = G__9757__1;
G__9757.cljs$core$IFn$_invoke$arity$2 = G__9757__2;
return G__9757;
})()
});
});
var cljs$core$take_while__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.truth_((function (){var G__9756 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9756) : pred.call(null,G__9756));
})())){
return cljs.core.cons(cljs.core.first(s),cljs$core$take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
cljs$core$take_while = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$take_while__1.call(this,pred);
case 2:
return cljs$core$take_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take_while.cljs$core$IFn$_invoke$arity$1 = cljs$core$take_while__1;
cljs$core$take_while.cljs$core$IFn$_invoke$arity$2 = cljs$core$take_while__2;
return cljs$core$take_while;
})()
;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__9762 = (function (){var G__9764 = cljs.core._entry_key(sc,e);
var G__9765 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9764,G__9765) : comp.call(null,G__9764,G__9765));
})();
var G__9763 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__9762,G__9763) : test.call(null,G__9762,G__9763));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function() {
var cljs$core$subseq = null;
var cljs$core$subseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9769 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9769,(0),null);
var s = vec__9769;
if(cljs.core.truth_((function (){var G__9770 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9770) : include.call(null,G__9770));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});
var cljs$core$subseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9771 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9771,(0),null);
var s = vec__9771;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
cljs$core$subseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return cljs$core$subseq__3.call(this,sc,start_test,start_key);
case 5:
return cljs$core$subseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subseq.cljs$core$IFn$_invoke$arity$3 = cljs$core$subseq__3;
cljs$core$subseq.cljs$core$IFn$_invoke$arity$5 = cljs$core$subseq__5;
return cljs$core$subseq;
})()
;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a reverse seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function() {
var cljs$core$rsubseq = null;
var cljs$core$rsubseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9775 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9775,(0),null);
var s = vec__9775;
if(cljs.core.truth_((function (){var G__9776 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9776) : include.call(null,G__9776));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});
var cljs$core$rsubseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9777 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9777,(0),null);
var s = vec__9777;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
cljs$core$rsubseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return cljs$core$rsubseq__3.call(this,sc,start_test,start_key);
case 5:
return cljs$core$rsubseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$rsubseq.cljs$core$IFn$_invoke$arity$3 = cljs$core$rsubseq__3;
cljs$core$rsubseq.cljs$core$IFn$_invoke$arity$5 = cljs$core$rsubseq__5;
return cljs$core$rsubseq;
})()
;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__9778 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__9778) : Math.ceil.call(null,G__9778));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4156__auto__ = self__.__hash;
if(!((h__4156__auto__ == null))){
return h__4156__auto__;
} else {
var h__4156__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4156__auto____$1;

return h__4156__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__9779 = ret;
var G__9780 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9779,G__9780) : f.call(null,G__9779,G__9780));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__9781 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9781) : cljs.core.deref.call(null,G__9781));
} else {
var G__9782 = (i + self__.step);
var G__9783 = ret__$1;
i = G__9782;
ret = G__9783;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function() {
var cljs$core$range = null;
var cljs$core$range__0 = (function (){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});
var cljs$core$range__1 = (function (end){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});
var cljs$core$range__2 = (function (start,end){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});
var cljs$core$range__3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});
cljs$core$range = function(start,end,step){
switch(arguments.length){
case 0:
return cljs$core$range__0.call(this);
case 1:
return cljs$core$range__1.call(this,start);
case 2:
return cljs$core$range__2.call(this,start,end);
case 3:
return cljs$core$range__3.call(this,start,end,step);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$range.cljs$core$IFn$_invoke$arity$0 = cljs$core$range__0;
cljs$core$range.cljs$core$IFn$_invoke$arity$1 = cljs$core$range__1;
cljs$core$range.cljs$core$IFn$_invoke$arity$2 = cljs$core$range__2;
cljs$core$range.cljs$core$IFn$_invoke$arity$3 = cljs$core$range__3;
return cljs$core$range;
})()
;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.take_nth = (function() {
var cljs$core$take_nth = null;
var cljs$core$take_nth__1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__9801 = null;
var G__9801__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9801__1 = (function (result){
var G__9798 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9798) : rf.call(null,G__9798));
});
var G__9801__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__9799 = result;
var G__9800 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9799,G__9800) : rf.call(null,G__9799,G__9800));
} else {
return result;
}
});
G__9801 = function(result,input){
switch(arguments.length){
case 0:
return G__9801__0.call(this);
case 1:
return G__9801__1.call(this,result);
case 2:
return G__9801__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9801.cljs$core$IFn$_invoke$arity$0 = G__9801__0;
G__9801.cljs$core$IFn$_invoke$arity$1 = G__9801__1;
G__9801.cljs$core$IFn$_invoke$arity$2 = G__9801__2;
return G__9801;
})()
;})(ia))
});
});
var cljs$core$take_nth__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs$core$take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});
cljs$core$take_nth = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$take_nth__1.call(this,n);
case 2:
return cljs$core$take_nth__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take_nth.cljs$core$IFn$_invoke$arity$1 = cljs$core$take_nth__1;
cljs$core$take_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$take_nth__2;
return cljs$core$take_nth;
})()
;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function() {
var cljs$core$partition_by = null;
var cljs$core$partition_by__1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__9823 = null;
var G__9823__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9823__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9814 = result;
var G__9815 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9814,G__9815) : rf.call(null,G__9814,G__9815));
})());
})());
var G__9816 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9816) : rf.call(null,G__9816));
});
var G__9823__2 = (function (result,input){
var pval = (function (){var G__9817 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9817) : cljs.core.deref.call(null,G__9817));
})();
var val = (function (){var G__9818 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9818) : f.call(null,G__9818));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__9819 = result;
var G__9820 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9819,G__9820) : rf.call(null,G__9819,G__9820));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__9823 = function(result,input){
switch(arguments.length){
case 0:
return G__9823__0.call(this);
case 1:
return G__9823__1.call(this,result);
case 2:
return G__9823__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9823.cljs$core$IFn$_invoke$arity$0 = G__9823__0;
G__9823.cljs$core$IFn$_invoke$arity$1 = G__9823__1;
G__9823.cljs$core$IFn$_invoke$arity$2 = G__9823__2;
return G__9823;
})()
;})(a,pa))
});
});
var cljs$core$partition_by__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__9821 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9821) : f.call(null,G__9821));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4126__auto__){
return (function (p1__9802_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__9822 = p1__9802_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9822) : f.call(null,G__9822));
})());
});})(fst,fv,s,temp__4126__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs$core$partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});
cljs$core$partition_by = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$partition_by__1.call(this,f);
case 2:
return cljs$core$partition_by__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition_by.cljs$core$IFn$_invoke$arity$1 = cljs$core$partition_by__1;
cljs$core$partition_by.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition_by__2;
return cljs$core$partition_by;
})()
;
/**
 * Returns a map from distinct items in coll to the number of times
 * they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 * per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function() {
var cljs$core$reductions = null;
var cljs$core$reductions__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
return cljs$core$reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});
var cljs$core$reductions__3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs$core$reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__9832 = init;
var G__9833 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9832,G__9833) : f.call(null,G__9832,G__9833));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});
cljs$core$reductions = function(f,init,coll){
switch(arguments.length){
case 2:
return cljs$core$reductions__2.call(this,f,init);
case 3:
return cljs$core$reductions__3.call(this,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$reductions.cljs$core$IFn$_invoke$arity$2 = cljs$core$reductions__2;
cljs$core$reductions.cljs$core$IFn$_invoke$arity$3 = cljs$core$reductions__3;
return cljs$core$reductions;
})()
;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 * of those fns.  The returned fn takes a variable number of args, and
 * returns a vector containing the result of applying each fn to the
 * args (left-to-right).
 * ((juxt a b c) x) => [(a x) (b x) (c x)]
 * @param {...*} var_args
 */
cljs.core.juxt = (function() {
var cljs$core$juxt = null;
var cljs$core$juxt__1 = (function (f){
return (function() {
var G__9928 = null;
var G__9928__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__9928__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9886 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9886) : f.call(null,G__9886));
})()],null));
});
var G__9928__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9887 = x;
var G__9888 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9887,G__9888) : f.call(null,G__9887,G__9888));
})()],null));
});
var G__9928__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9889 = x;
var G__9890 = y;
var G__9891 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9889,G__9890,G__9891) : f.call(null,G__9889,G__9890,G__9891));
})()],null));
});
var G__9928__4 = (function() { 
var G__9929__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__9929 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9930__i = 0, G__9930__a = new Array(arguments.length -  3);
while (G__9930__i < G__9930__a.length) {G__9930__a[G__9930__i] = arguments[G__9930__i + 3]; ++G__9930__i;}
  args = new cljs.core.IndexedSeq(G__9930__a,0);
} 
return G__9929__delegate.call(this,x,y,z,args);};
G__9929.cljs$lang$maxFixedArity = 3;
G__9929.cljs$lang$applyTo = (function (arglist__9931){
var x = cljs.core.first(arglist__9931);
arglist__9931 = cljs.core.next(arglist__9931);
var y = cljs.core.first(arglist__9931);
arglist__9931 = cljs.core.next(arglist__9931);
var z = cljs.core.first(arglist__9931);
var args = cljs.core.rest(arglist__9931);
return G__9929__delegate(x,y,z,args);
});
G__9929.cljs$core$IFn$_invoke$arity$variadic = G__9929__delegate;
return G__9929;
})()
;
G__9928 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9928__0.call(this);
case 1:
return G__9928__1.call(this,x);
case 2:
return G__9928__2.call(this,x,y);
case 3:
return G__9928__3.call(this,x,y,z);
default:
var G__9932 = null;
if (arguments.length > 3) {
var G__9933__i = 0, G__9933__a = new Array(arguments.length -  3);
while (G__9933__i < G__9933__a.length) {G__9933__a[G__9933__i] = arguments[G__9933__i + 3]; ++G__9933__i;}
G__9932 = new cljs.core.IndexedSeq(G__9933__a,0);
}
return G__9928__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9928.cljs$lang$maxFixedArity = 3;
G__9928.cljs$lang$applyTo = G__9928__4.cljs$lang$applyTo;
G__9928.cljs$core$IFn$_invoke$arity$0 = G__9928__0;
G__9928.cljs$core$IFn$_invoke$arity$1 = G__9928__1;
G__9928.cljs$core$IFn$_invoke$arity$2 = G__9928__2;
G__9928.cljs$core$IFn$_invoke$arity$3 = G__9928__3;
G__9928.cljs$core$IFn$_invoke$arity$variadic = G__9928__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9928;
})()
});
var cljs$core$juxt__2 = (function (f,g){
return (function() {
var G__9934 = null;
var G__9934__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__9934__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9892 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9892) : f.call(null,G__9892));
})(),(function (){var G__9893 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9893) : g.call(null,G__9893));
})()],null));
});
var G__9934__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9894 = x;
var G__9895 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9894,G__9895) : f.call(null,G__9894,G__9895));
})(),(function (){var G__9896 = x;
var G__9897 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9896,G__9897) : g.call(null,G__9896,G__9897));
})()],null));
});
var G__9934__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9898 = x;
var G__9899 = y;
var G__9900 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9898,G__9899,G__9900) : f.call(null,G__9898,G__9899,G__9900));
})(),(function (){var G__9901 = x;
var G__9902 = y;
var G__9903 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9901,G__9902,G__9903) : g.call(null,G__9901,G__9902,G__9903));
})()],null));
});
var G__9934__4 = (function() { 
var G__9935__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__9935 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9936__i = 0, G__9936__a = new Array(arguments.length -  3);
while (G__9936__i < G__9936__a.length) {G__9936__a[G__9936__i] = arguments[G__9936__i + 3]; ++G__9936__i;}
  args = new cljs.core.IndexedSeq(G__9936__a,0);
} 
return G__9935__delegate.call(this,x,y,z,args);};
G__9935.cljs$lang$maxFixedArity = 3;
G__9935.cljs$lang$applyTo = (function (arglist__9937){
var x = cljs.core.first(arglist__9937);
arglist__9937 = cljs.core.next(arglist__9937);
var y = cljs.core.first(arglist__9937);
arglist__9937 = cljs.core.next(arglist__9937);
var z = cljs.core.first(arglist__9937);
var args = cljs.core.rest(arglist__9937);
return G__9935__delegate(x,y,z,args);
});
G__9935.cljs$core$IFn$_invoke$arity$variadic = G__9935__delegate;
return G__9935;
})()
;
G__9934 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9934__0.call(this);
case 1:
return G__9934__1.call(this,x);
case 2:
return G__9934__2.call(this,x,y);
case 3:
return G__9934__3.call(this,x,y,z);
default:
var G__9938 = null;
if (arguments.length > 3) {
var G__9939__i = 0, G__9939__a = new Array(arguments.length -  3);
while (G__9939__i < G__9939__a.length) {G__9939__a[G__9939__i] = arguments[G__9939__i + 3]; ++G__9939__i;}
G__9938 = new cljs.core.IndexedSeq(G__9939__a,0);
}
return G__9934__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9934.cljs$lang$maxFixedArity = 3;
G__9934.cljs$lang$applyTo = G__9934__4.cljs$lang$applyTo;
G__9934.cljs$core$IFn$_invoke$arity$0 = G__9934__0;
G__9934.cljs$core$IFn$_invoke$arity$1 = G__9934__1;
G__9934.cljs$core$IFn$_invoke$arity$2 = G__9934__2;
G__9934.cljs$core$IFn$_invoke$arity$3 = G__9934__3;
G__9934.cljs$core$IFn$_invoke$arity$variadic = G__9934__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9934;
})()
});
var cljs$core$juxt__3 = (function (f,g,h){
return (function() {
var G__9940 = null;
var G__9940__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__9940__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9904 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9904) : f.call(null,G__9904));
})(),(function (){var G__9905 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9905) : g.call(null,G__9905));
})(),(function (){var G__9906 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__9906) : h.call(null,G__9906));
})()],null));
});
var G__9940__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9907 = x;
var G__9908 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9907,G__9908) : f.call(null,G__9907,G__9908));
})(),(function (){var G__9909 = x;
var G__9910 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9909,G__9910) : g.call(null,G__9909,G__9910));
})(),(function (){var G__9911 = x;
var G__9912 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__9911,G__9912) : h.call(null,G__9911,G__9912));
})()],null));
});
var G__9940__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9913 = x;
var G__9914 = y;
var G__9915 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9913,G__9914,G__9915) : f.call(null,G__9913,G__9914,G__9915));
})(),(function (){var G__9916 = x;
var G__9917 = y;
var G__9918 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9916,G__9917,G__9918) : g.call(null,G__9916,G__9917,G__9918));
})(),(function (){var G__9919 = x;
var G__9920 = y;
var G__9921 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__9919,G__9920,G__9921) : h.call(null,G__9919,G__9920,G__9921));
})()],null));
});
var G__9940__4 = (function() { 
var G__9941__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__9941 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9942__i = 0, G__9942__a = new Array(arguments.length -  3);
while (G__9942__i < G__9942__a.length) {G__9942__a[G__9942__i] = arguments[G__9942__i + 3]; ++G__9942__i;}
  args = new cljs.core.IndexedSeq(G__9942__a,0);
} 
return G__9941__delegate.call(this,x,y,z,args);};
G__9941.cljs$lang$maxFixedArity = 3;
G__9941.cljs$lang$applyTo = (function (arglist__9943){
var x = cljs.core.first(arglist__9943);
arglist__9943 = cljs.core.next(arglist__9943);
var y = cljs.core.first(arglist__9943);
arglist__9943 = cljs.core.next(arglist__9943);
var z = cljs.core.first(arglist__9943);
var args = cljs.core.rest(arglist__9943);
return G__9941__delegate(x,y,z,args);
});
G__9941.cljs$core$IFn$_invoke$arity$variadic = G__9941__delegate;
return G__9941;
})()
;
G__9940 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9940__0.call(this);
case 1:
return G__9940__1.call(this,x);
case 2:
return G__9940__2.call(this,x,y);
case 3:
return G__9940__3.call(this,x,y,z);
default:
var G__9944 = null;
if (arguments.length > 3) {
var G__9945__i = 0, G__9945__a = new Array(arguments.length -  3);
while (G__9945__i < G__9945__a.length) {G__9945__a[G__9945__i] = arguments[G__9945__i + 3]; ++G__9945__i;}
G__9944 = new cljs.core.IndexedSeq(G__9945__a,0);
}
return G__9940__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9940.cljs$lang$maxFixedArity = 3;
G__9940.cljs$lang$applyTo = G__9940__4.cljs$lang$applyTo;
G__9940.cljs$core$IFn$_invoke$arity$0 = G__9940__0;
G__9940.cljs$core$IFn$_invoke$arity$1 = G__9940__1;
G__9940.cljs$core$IFn$_invoke$arity$2 = G__9940__2;
G__9940.cljs$core$IFn$_invoke$arity$3 = G__9940__3;
G__9940.cljs$core$IFn$_invoke$arity$variadic = G__9940__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9940;
})()
});
var cljs$core$juxt__4 = (function() { 
var G__9946__delegate = function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__9947 = null;
var G__9947__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9834_SHARP_,p2__9835_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9834_SHARP_,(function (){return (p2__9835_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__9835_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__9835_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9947__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9836_SHARP_,p2__9837_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9836_SHARP_,(function (){var G__9922 = x;
return (p2__9837_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__9837_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9922) : p2__9837_SHARP_.call(null,G__9922));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9947__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9838_SHARP_,p2__9839_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9838_SHARP_,(function (){var G__9923 = x;
var G__9924 = y;
return (p2__9839_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__9839_SHARP_.cljs$core$IFn$_invoke$arity$2(G__9923,G__9924) : p2__9839_SHARP_.call(null,G__9923,G__9924));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9947__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9840_SHARP_,p2__9841_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9840_SHARP_,(function (){var G__9925 = x;
var G__9926 = y;
var G__9927 = z;
return (p2__9841_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__9841_SHARP_.cljs$core$IFn$_invoke$arity$3(G__9925,G__9926,G__9927) : p2__9841_SHARP_.call(null,G__9925,G__9926,G__9927));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9947__4 = (function() { 
var G__9948__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9842_SHARP_,p2__9843_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9842_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__9843_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__9948 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9949__i = 0, G__9949__a = new Array(arguments.length -  3);
while (G__9949__i < G__9949__a.length) {G__9949__a[G__9949__i] = arguments[G__9949__i + 3]; ++G__9949__i;}
  args = new cljs.core.IndexedSeq(G__9949__a,0);
} 
return G__9948__delegate.call(this,x,y,z,args);};
G__9948.cljs$lang$maxFixedArity = 3;
G__9948.cljs$lang$applyTo = (function (arglist__9950){
var x = cljs.core.first(arglist__9950);
arglist__9950 = cljs.core.next(arglist__9950);
var y = cljs.core.first(arglist__9950);
arglist__9950 = cljs.core.next(arglist__9950);
var z = cljs.core.first(arglist__9950);
var args = cljs.core.rest(arglist__9950);
return G__9948__delegate(x,y,z,args);
});
G__9948.cljs$core$IFn$_invoke$arity$variadic = G__9948__delegate;
return G__9948;
})()
;
G__9947 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9947__0.call(this);
case 1:
return G__9947__1.call(this,x);
case 2:
return G__9947__2.call(this,x,y);
case 3:
return G__9947__3.call(this,x,y,z);
default:
var G__9951 = null;
if (arguments.length > 3) {
var G__9952__i = 0, G__9952__a = new Array(arguments.length -  3);
while (G__9952__i < G__9952__a.length) {G__9952__a[G__9952__i] = arguments[G__9952__i + 3]; ++G__9952__i;}
G__9951 = new cljs.core.IndexedSeq(G__9952__a,0);
}
return G__9947__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9947.cljs$lang$maxFixedArity = 3;
G__9947.cljs$lang$applyTo = G__9947__4.cljs$lang$applyTo;
G__9947.cljs$core$IFn$_invoke$arity$0 = G__9947__0;
G__9947.cljs$core$IFn$_invoke$arity$1 = G__9947__1;
G__9947.cljs$core$IFn$_invoke$arity$2 = G__9947__2;
G__9947.cljs$core$IFn$_invoke$arity$3 = G__9947__3;
G__9947.cljs$core$IFn$_invoke$arity$variadic = G__9947__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9947;
})()
;})(fs__$1))
};
var G__9946 = function (f,g,h,var_args){
var fs = null;
if (arguments.length > 3) {
var G__9953__i = 0, G__9953__a = new Array(arguments.length -  3);
while (G__9953__i < G__9953__a.length) {G__9953__a[G__9953__i] = arguments[G__9953__i + 3]; ++G__9953__i;}
  fs = new cljs.core.IndexedSeq(G__9953__a,0);
} 
return G__9946__delegate.call(this,f,g,h,fs);};
G__9946.cljs$lang$maxFixedArity = 3;
G__9946.cljs$lang$applyTo = (function (arglist__9954){
var f = cljs.core.first(arglist__9954);
arglist__9954 = cljs.core.next(arglist__9954);
var g = cljs.core.first(arglist__9954);
arglist__9954 = cljs.core.next(arglist__9954);
var h = cljs.core.first(arglist__9954);
var fs = cljs.core.rest(arglist__9954);
return G__9946__delegate(f,g,h,fs);
});
G__9946.cljs$core$IFn$_invoke$arity$variadic = G__9946__delegate;
return G__9946;
})()
;
cljs$core$juxt = function(f,g,h,var_args){
var fs = var_args;
switch(arguments.length){
case 1:
return cljs$core$juxt__1.call(this,f);
case 2:
return cljs$core$juxt__2.call(this,f,g);
case 3:
return cljs$core$juxt__3.call(this,f,g,h);
default:
var G__9955 = null;
if (arguments.length > 3) {
var G__9956__i = 0, G__9956__a = new Array(arguments.length -  3);
while (G__9956__i < G__9956__a.length) {G__9956__a[G__9956__i] = arguments[G__9956__i + 3]; ++G__9956__i;}
G__9955 = new cljs.core.IndexedSeq(G__9956__a,0);
}
return cljs$core$juxt__4.cljs$core$IFn$_invoke$arity$variadic(f,g,h, G__9955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$juxt.cljs$lang$maxFixedArity = 3;
cljs$core$juxt.cljs$lang$applyTo = cljs$core$juxt__4.cljs$lang$applyTo;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$1 = cljs$core$juxt__1;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$2 = cljs$core$juxt__2;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$3 = cljs$core$juxt__3;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$variadic = cljs$core$juxt__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$juxt;
})()
;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. dorun can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function() {
var cljs$core$dorun = null;
var cljs$core$dorun__1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__9957 = cljs.core.next(coll);
coll = G__9957;
continue;
} else {
return null;
}
break;
}
});
var cljs$core$dorun__2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__9958 = (n - (1));
var G__9959 = cljs.core.next(coll);
n = G__9958;
coll = G__9959;
continue;
} else {
return null;
}
break;
}
});
cljs$core$dorun = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$dorun__1.call(this,n);
case 2:
return cljs$core$dorun__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dorun.cljs$core$IFn$_invoke$arity$1 = cljs$core$dorun__1;
cljs$core$dorun.cljs$core$IFn$_invoke$arity$2 = cljs$core$dorun__2;
return cljs$core$dorun;
})()
;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. doall can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, retains the head and returns it, thus causing the entire
 * seq to reside in memory at one time.
 */
cljs.core.doall = (function() {
var cljs$core$doall = null;
var cljs$core$doall__1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});
var cljs$core$doall__2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});
cljs$core$doall = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$doall__1.call(this,n);
case 2:
return cljs$core$doall__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$doall.cljs$core$IFn$_invoke$arity$1 = cljs$core$doall__1;
cljs$core$doall.cljs$core$IFn$_invoke$arity$2 = cljs$core$doall__2;
return cljs$core$doall;
})()
;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 * re.exec(s). Returns a vector, containing first the matching
 * substring, then any capturing groups if the regular expression contains
 * capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__9963 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9963,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9963,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__3740__auto__ = flags;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_9971 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__3740__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__9972_9978 = cljs.core.first(coll);
var G__9973_9979 = writer;
var G__9974_9980 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9972_9978,G__9973_9979,G__9974_9980) : print_one.call(null,G__9972_9978,G__9973_9979,G__9974_9980));
} else {
}

var coll_9981__$1 = cljs.core.next(coll);
var n_9982 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_9981__$1) && (((n_9982 == null)) || (!((n_9982 === (0)))))){
cljs.core._write(writer,sep);

var G__9975_9983 = cljs.core.first(coll_9981__$1);
var G__9976_9984 = writer;
var G__9977_9985 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9975_9983,G__9976_9984,G__9977_9985) : print_one.call(null,G__9975_9983,G__9976_9984,G__9977_9985));

var G__9986 = cljs.core.next(coll_9981__$1);
var G__9987 = (n_9982 - (1));
coll_9981__$1 = G__9986;
n_9982 = G__9987;
continue;
} else {
if((cljs.core.seq(coll_9981__$1)) && ((n_9982 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__3740__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_9971;
}});
/**
 * @param {...*} var_args
 */
cljs.core.write_all = (function() { 
var cljs$core$write_all__delegate = function (writer,ss){
var seq__9992 = cljs.core.seq(ss);
var chunk__9993 = null;
var count__9994 = (0);
var i__9995 = (0);
while(true){
if((i__9995 < count__9994)){
var s = chunk__9993.cljs$core$IIndexed$_nth$arity$2(null,i__9995);
cljs.core._write(writer,s);

var G__9996 = seq__9992;
var G__9997 = chunk__9993;
var G__9998 = count__9994;
var G__9999 = (i__9995 + (1));
seq__9992 = G__9996;
chunk__9993 = G__9997;
count__9994 = G__9998;
i__9995 = G__9999;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9992);
if(temp__4126__auto__){
var seq__9992__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9992__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__9992__$1);
var G__10000 = cljs.core.chunk_rest(seq__9992__$1);
var G__10001 = c__4525__auto__;
var G__10002 = cljs.core.count(c__4525__auto__);
var G__10003 = (0);
seq__9992 = G__10000;
chunk__9993 = G__10001;
count__9994 = G__10002;
i__9995 = G__10003;
continue;
} else {
var s = cljs.core.first(seq__9992__$1);
cljs.core._write(writer,s);

var G__10004 = cljs.core.next(seq__9992__$1);
var G__10005 = null;
var G__10006 = (0);
var G__10007 = (0);
seq__9992 = G__10004;
chunk__9993 = G__10005;
count__9994 = G__10006;
i__9995 = G__10007;
continue;
}
} else {
return null;
}
}
break;
}
};
var cljs$core$write_all = function (writer,var_args){
var ss = null;
if (arguments.length > 1) {
var G__10008__i = 0, G__10008__a = new Array(arguments.length -  1);
while (G__10008__i < G__10008__a.length) {G__10008__a[G__10008__i] = arguments[G__10008__i + 1]; ++G__10008__i;}
  ss = new cljs.core.IndexedSeq(G__10008__a,0);
} 
return cljs$core$write_all__delegate.call(this,writer,ss);};
cljs$core$write_all.cljs$lang$maxFixedArity = 1;
cljs$core$write_all.cljs$lang$applyTo = (function (arglist__10009){
var writer = cljs.core.first(arglist__10009);
var ss = cljs.core.rest(arglist__10009);
return cljs$core$write_all__delegate(writer,ss);
});
cljs$core$write_all.cljs$core$IFn$_invoke$arity$variadic = cljs$core$write_all__delegate;
return cljs$core$write_all;
})()
;
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj10011 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj10011;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__10014 = "[\\\\\"\b\f\n\r\t]";
var G__10015 = "g";
return RegExp(G__10014,G__10015);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__3728__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__3728__auto__)){
var and__3728__auto____$1 = (function (){var G__10029 = obj;
if(G__10029){
var bit__4414__auto__ = (G__10029.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4414__auto__) || (G__10029.cljs$core$IMeta$)){
return true;
} else {
if((!G__10029.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__10029);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__10029);
}
})();
if(and__3728__auto____$1){
return cljs.core.meta(obj);
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
})())){
cljs.core._write(writer,"^");

var G__10030_10040 = cljs.core.meta(obj);
var G__10031_10041 = writer;
var G__10032_10042 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__10030_10040,G__10031_10041,G__10032_10042) : cljs.core.pr_writer.call(null,G__10030_10040,G__10031_10041,G__10032_10042));

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__10033 = obj;
if(G__10033){
var bit__4407__auto__ = (G__10033.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4407__auto__) || (G__10033.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__10034 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__10035 = cljs.core.pr_writer;
var G__10036 = writer;
var G__10037 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__10034,G__10035,G__10036,G__10037) : cljs.core.print_map.call(null,G__10034,G__10035,G__10036,G__10037));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__10038 = obj;
return goog.isString(G__10038);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__10043 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__10043;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__10039 = obj;
if(G__10039){
var bit__4414__auto__ = (G__10039.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4414__auto__) || (G__10039.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__10039.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__10039);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__10039);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4124__auto__ = new cljs.core.Keyword(null,"alt-impl","alt-impl",670969595).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4124__auto__)){
var alt_impl = temp__4124__auto__;
var G__10047 = obj;
var G__10048 = writer;
var G__10049 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"fallback-impl","fallback-impl",-1501286995),cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__10047,G__10048,G__10049) : alt_impl.call(null,G__10047,G__10048,G__10049));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__10054 = cljs.core.seq(cljs.core.next(objs));
var chunk__10055 = null;
var count__10056 = (0);
var i__10057 = (0);
while(true){
if((i__10057 < count__10056)){
var obj = chunk__10055.cljs$core$IIndexed$_nth$arity$2(null,i__10057);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10058 = seq__10054;
var G__10059 = chunk__10055;
var G__10060 = count__10056;
var G__10061 = (i__10057 + (1));
seq__10054 = G__10058;
chunk__10055 = G__10059;
count__10056 = G__10060;
i__10057 = G__10061;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10054);
if(temp__4126__auto__){
var seq__10054__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10054__$1)){
var c__4525__auto__ = cljs.core.chunk_first(seq__10054__$1);
var G__10062 = cljs.core.chunk_rest(seq__10054__$1);
var G__10063 = c__4525__auto__;
var G__10064 = cljs.core.count(c__4525__auto__);
var G__10065 = (0);
seq__10054 = G__10062;
chunk__10055 = G__10063;
count__10056 = G__10064;
i__10057 = G__10065;
continue;
} else {
var obj = cljs.core.first(seq__10054__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10066 = cljs.core.next(seq__10054__$1);
var G__10067 = null;
var G__10068 = (0);
var G__10069 = (0);
seq__10054 = G__10066;
chunk__10055 = G__10067;
count__10056 = G__10068;
i__10057 = G__10069;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 * options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 * the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 * @param {...*} var_args
 */
cljs.core.pr_str = (function() { 
var cljs$core$pr_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$pr_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10070__i = 0, G__10070__a = new Array(arguments.length -  0);
while (G__10070__i < G__10070__a.length) {G__10070__a[G__10070__i] = arguments[G__10070__i + 0]; ++G__10070__i;}
  objs = new cljs.core.IndexedSeq(G__10070__a,0);
} 
return cljs$core$pr_str__delegate.call(this,objs);};
cljs$core$pr_str.cljs$lang$maxFixedArity = 0;
cljs$core$pr_str.cljs$lang$applyTo = (function (arglist__10071){
var objs = cljs.core.seq(arglist__10071);
return cljs$core$pr_str__delegate(objs);
});
cljs$core$pr_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$pr_str__delegate;
return cljs$core$pr_str;
})()
;
/**
 * Same as pr-str followed by (newline)
 * @param {...*} var_args
 */
cljs.core.prn_str = (function() { 
var cljs$core$prn_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$prn_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10072__i = 0, G__10072__a = new Array(arguments.length -  0);
while (G__10072__i < G__10072__a.length) {G__10072__a[G__10072__i] = arguments[G__10072__i + 0]; ++G__10072__i;}
  objs = new cljs.core.IndexedSeq(G__10072__a,0);
} 
return cljs$core$prn_str__delegate.call(this,objs);};
cljs$core$prn_str.cljs$lang$maxFixedArity = 0;
cljs$core$prn_str.cljs$lang$applyTo = (function (arglist__10073){
var objs = cljs.core.seq(arglist__10073);
return cljs$core$prn_str__delegate(objs);
});
cljs$core$prn_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$prn_str__delegate;
return cljs$core$prn_str;
})()
;
/**
 * Prints the object(s) using string-print.  Prints the
 * object(s), separated by spaces if there is more than one.
 * By default, pr and prn print in a way that objects can be
 * read by the reader
 * @param {...*} var_args
 */
cljs.core.pr = (function() { 
var cljs$core$pr__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$pr = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10074__i = 0, G__10074__a = new Array(arguments.length -  0);
while (G__10074__i < G__10074__a.length) {G__10074__a[G__10074__i] = arguments[G__10074__i + 0]; ++G__10074__i;}
  objs = new cljs.core.IndexedSeq(G__10074__a,0);
} 
return cljs$core$pr__delegate.call(this,objs);};
cljs$core$pr.cljs$lang$maxFixedArity = 0;
cljs$core$pr.cljs$lang$applyTo = (function (arglist__10075){
var objs = cljs.core.seq(arglist__10075);
return cljs$core$pr__delegate(objs);
});
cljs$core$pr.cljs$core$IFn$_invoke$arity$variadic = cljs$core$pr__delegate;
return cljs$core$pr;
})()
;
/**
 * Prints the object(s) using string-print.
 * print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10076__i = 0, G__10076__a = new Array(arguments.length -  0);
while (G__10076__i < G__10076__a.length) {G__10076__a[G__10076__i] = arguments[G__10076__i + 0]; ++G__10076__i;}
  objs = new cljs.core.IndexedSeq(G__10076__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__10077){
var objs = cljs.core.seq(arglist__10077);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 * @param {...*} var_args
 */
cljs.core.print_str = (function() { 
var cljs$core$print_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$print_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10078__i = 0, G__10078__a = new Array(arguments.length -  0);
while (G__10078__i < G__10078__a.length) {G__10078__a[G__10078__i] = arguments[G__10078__i + 0]; ++G__10078__i;}
  objs = new cljs.core.IndexedSeq(G__10078__a,0);
} 
return cljs$core$print_str__delegate.call(this,objs);};
cljs$core$print_str.cljs$lang$maxFixedArity = 0;
cljs$core$print_str.cljs$lang$applyTo = (function (arglist__10079){
var objs = cljs.core.seq(arglist__10079);
return cljs$core$print_str__delegate(objs);
});
cljs$core$print_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$print_str__delegate;
return cljs$core$print_str;
})()
;
/**
 * Same as print followed by (newline)
 * @param {...*} var_args
 */
cljs.core.println = (function() { 
var cljs$core$println__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var cljs$core$println = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10080__i = 0, G__10080__a = new Array(arguments.length -  0);
while (G__10080__i < G__10080__a.length) {G__10080__a[G__10080__i] = arguments[G__10080__i + 0]; ++G__10080__i;}
  objs = new cljs.core.IndexedSeq(G__10080__a,0);
} 
return cljs$core$println__delegate.call(this,objs);};
cljs$core$println.cljs$lang$maxFixedArity = 0;
cljs$core$println.cljs$lang$applyTo = (function (arglist__10081){
var objs = cljs.core.seq(arglist__10081);
return cljs$core$println__delegate(objs);
});
cljs$core$println.cljs$core$IFn$_invoke$arity$variadic = cljs$core$println__delegate;
return cljs$core$println;
})()
;
/**
 * println to a string, returning it
 * @param {...*} var_args
 */
cljs.core.println_str = (function() { 
var cljs$core$println_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$println_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10082__i = 0, G__10082__a = new Array(arguments.length -  0);
while (G__10082__i < G__10082__a.length) {G__10082__a[G__10082__i] = arguments[G__10082__i + 0]; ++G__10082__i;}
  objs = new cljs.core.IndexedSeq(G__10082__a,0);
} 
return cljs$core$println_str__delegate.call(this,objs);};
cljs$core$println_str.cljs$lang$maxFixedArity = 0;
cljs$core$println_str.cljs$lang$applyTo = (function (arglist__10083){
var objs = cljs.core.seq(arglist__10083);
return cljs$core$println_str__delegate(objs);
});
cljs$core$println_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$println_str__delegate;
return cljs$core$println_str;
})()
;
/**
 * Same as pr followed by (newline).
 * @param {...*} var_args
 */
cljs.core.prn = (function() { 
var cljs$core$prn__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var cljs$core$prn = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10084__i = 0, G__10084__a = new Array(arguments.length -  0);
while (G__10084__i < G__10084__a.length) {G__10084__a[G__10084__i] = arguments[G__10084__i + 0]; ++G__10084__i;}
  objs = new cljs.core.IndexedSeq(G__10084__a,0);
} 
return cljs$core$prn__delegate.call(this,objs);};
cljs$core$prn.cljs$lang$maxFixedArity = 0;
cljs$core$prn.cljs$lang$applyTo = (function (arglist__10085){
var objs = cljs.core.seq(arglist__10085);
return cljs$core$prn__delegate(objs);
});
cljs$core$prn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$prn__delegate;
return cljs$core$prn;
})()
;
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__10092_10098 = cljs.core.key(e);
var G__10093_10099 = w;
var G__10094_10100 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10092_10098,G__10093_10099,G__10094_10100) : print_one.call(null,G__10092_10098,G__10093_10099,G__10094_10100));

cljs.core._write(w," ");

var G__10095 = cljs.core.val(e);
var G__10096 = w;
var G__10097 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10095,G__10096,G__10097) : print_one.call(null,G__10095,G__10096,G__10097));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 * (apply f its-current-meta args)
 * 
 * f must be free of side-effects
 * @param {...*} var_args
 */
cljs.core.alter_meta_BANG_ = (function() { 
var cljs$core$alter_meta_BANG___delegate = function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
};
var cljs$core$alter_meta_BANG_ = function (iref,f,var_args){
var args = null;
if (arguments.length > 2) {
var G__10101__i = 0, G__10101__a = new Array(arguments.length -  2);
while (G__10101__i < G__10101__a.length) {G__10101__a[G__10101__i] = arguments[G__10101__i + 2]; ++G__10101__i;}
  args = new cljs.core.IndexedSeq(G__10101__a,0);
} 
return cljs$core$alter_meta_BANG___delegate.call(this,iref,f,args);};
cljs$core$alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$alter_meta_BANG_.cljs$lang$applyTo = (function (arglist__10102){
var iref = cljs.core.first(arglist__10102);
arglist__10102 = cljs.core.next(arglist__10102);
var f = cljs.core.first(arglist__10102);
var args = cljs.core.rest(arglist__10102);
return cljs$core$alter_meta_BANG___delegate(iref,f,args);
});
cljs$core$alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$alter_meta_BANG___delegate;
return cljs$core$alter_meta_BANG_;
})()
;
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Alpha - subject to change.
 * 
 * Adds a watch function to an atom reference. The watch fn must be a
 * fn of 4 args: a key, the reference, its old-state, its
 * new-state. Whenever the reference's state might have been changed,
 * any registered watches will have their functions called. The watch
 * fn will be called synchronously. Note that an atom's state
 * may have changed again prior to the fn call, so use old/new-state
 * rather than derefing the reference. Keys must be unique per
 * reference, and can be used to remove the watch with remove-watch,
 * but are otherwise considered opaque by the watch mechanism.  Bear in
 * mind that regardless of the result or action of the watch fns the
 * atom's value will change.  Example:
 * 
 * (def a (atom 0))
 * (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 * (swap! a inc)
 * ;; Assertion Error
 * (deref a)
 * ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Alpha - subject to change.
 * 
 * Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 * supplied, the name is prefix# where # is some unique number. If
 * prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function() {
var cljs$core$gensym = null;
var cljs$core$gensym__0 = (function (){
return cljs$core$gensym.cljs$core$IFn$_invoke$arity$1("G__");
});
var cljs$core$gensym__1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__10105 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10105) : cljs.core.atom.call(null,G__10105));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});
cljs$core$gensym = function(prefix_string){
switch(arguments.length){
case 0:
return cljs$core$gensym__0.call(this);
case 1:
return cljs$core$gensym__1.call(this,prefix_string);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$gensym.cljs$core$IFn$_invoke$arity$0 = cljs$core$gensym__0;
cljs$core$gensym.cljs$core$IFn$_invoke$arity$1 = cljs$core$gensym__1;
return cljs$core$gensym;
})()
;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
var G__10107 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10107) : cljs.core.deref.call(null,G__10107));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a promise, delay, future or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__10108_SHARP_,p2__10109_SHARP_){
var ret = (function (){var G__10112 = p1__10108_SHARP_;
var G__10113 = p2__10109_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10112,G__10113) : rf.call(null,G__10112,G__10113));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 * collection, into the reduction.
 */
cljs.core.cat = (function cljs$core$cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__10116 = null;
var G__10116__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10116__1 = (function (result){
var G__10115 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10115) : rf.call(null,G__10115));
});
var G__10116__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__10116 = function(result,input){
switch(arguments.length){
case 0:
return G__10116__0.call(this);
case 1:
return G__10116__1.call(this,result);
case 2:
return G__10116__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10116.cljs$core$IFn$_invoke$arity$0 = G__10116__0;
G__10116.cljs$core$IFn$_invoke$arity$1 = G__10116__1;
G__10116.cljs$core$IFn$_invoke$arity$2 = G__10116__2;
return G__10116;
})()
;})(rf1))
});
/**
 * Returns a lazy sequence removing consecutive duplicates in coll.
 * Returns a transducer when no collection is provided.
 */
cljs.core.dedupe = (function() {
var cljs$core$dedupe = null;
var cljs$core$dedupe__0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__10125 = null;
var G__10125__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10125__1 = (function (result){
var G__10121 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10121) : rf.call(null,G__10121));
});
var G__10125__2 = (function (result,input){
var prior = (function (){var G__10122 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10122) : cljs.core.deref.call(null,G__10122));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__10123 = result;
var G__10124 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10123,G__10124) : rf.call(null,G__10123,G__10124));
}
});
G__10125 = function(result,input){
switch(arguments.length){
case 0:
return G__10125__0.call(this);
case 1:
return G__10125__1.call(this,result);
case 2:
return G__10125__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10125.cljs$core$IFn$_invoke$arity$0 = G__10125__0;
G__10125.cljs$core$IFn$_invoke$arity$1 = G__10125__1;
G__10125.cljs$core$IFn$_invoke$arity$2 = G__10125__2;
return G__10125;
})()
;})(pa))
});
});
var cljs$core$dedupe__1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs$core$dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});
cljs$core$dedupe = function(coll){
switch(arguments.length){
case 0:
return cljs$core$dedupe__0.call(this);
case 1:
return cljs$core$dedupe__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dedupe.cljs$core$IFn$_invoke$arity$0 = cljs$core$dedupe__0;
cljs$core$dedupe.cljs$core$IFn$_invoke$arity$1 = cljs$core$dedupe__1;
return cljs$core$dedupe;
})()
;
/**
 * Returns items from coll with random probability of prob (0.0 -
 * 1.0).  Returns a transducer when no collection is provided.
 */
cljs.core.random_sample = (function() {
var cljs$core$random_sample = null;
var cljs$core$random_sample__1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});
var cljs$core$random_sample__2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});
cljs$core$random_sample = function(prob,coll){
switch(arguments.length){
case 1:
return cljs$core$random_sample__1.call(this,prob);
case 2:
return cljs$core$random_sample__2.call(this,prob,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$random_sample.cljs$core$IFn$_invoke$arity$1 = cljs$core$random_sample__1;
cljs$core$random_sample.cljs$core$IFn$_invoke$arity$2 = cljs$core$random_sample__2;
return cljs$core$random_sample;
})()
;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
})
cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4319__auto__,writer__4320__auto__,opt__4321__auto__){
return cljs.core._write(writer__4320__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function cljs$core$__GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4716__auto__ = this;
return cljs.core.es6_iterator(this__4716__auto__);
}));
/**
 * Returns a reducible/iterable/seqable application of
 * the transducer to the items in coll. Note that these applications
 * will be performed every time iterator/seq/reduce is called.
 */
cljs.core.eduction = (function cljs$core$eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
 * Runs the supplied procedure (via reduce), for purposes of side
 * effects, on successive items in the collection. Returns nil
 */
cljs.core.run_BANG_ = (function cljs$core$run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__10127_SHARP_,p2__10126_SHARP_){
var G__10129 = p2__10126_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__10129) : proc.call(null,G__10129));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj10131 = {};
return obj10131;
})();

/**
 * Recursively transforms clj values to JavaScript
 */
cljs.core._clj__GT_js = (function cljs$core$_clj__GT_js(x){
if((function (){var and__3728__auto__ = x;
if(and__3728__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__3728__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4376__auto__ = (((x == null))?null:x);
return (function (){var or__3740__auto__ = (cljs.core._clj__GT_js[(function (){var G__10135 = x__4376__auto__;
return goog.typeOf(G__10135);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

/**
 * Transforms map keys to valid JavaScript keys. Arbitrary keys are
 * encoded to their string representation via (pr-str x)
 */
cljs.core._key__GT_js = (function cljs$core$_key__GT_js(x){
if((function (){var and__3728__auto__ = x;
if(and__3728__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__3728__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4376__auto__ = (((x == null))?null:x);
return (function (){var or__3740__auto__ = (cljs.core._key__GT_js[(function (){var G__10139 = x__4376__auto__;
return goog.typeOf(G__10139);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function cljs$core$key__GT_js(k){
if((function (){var G__10142 = k;
if(G__10142){
var bit__4414__auto__ = null;
if(cljs.core.truth_((function (){var or__3740__auto__ = bit__4414__auto__;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return G__10142.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10142.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10142);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10142);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__10143 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__10143) : cljs.core.clj__GT_js.call(null,G__10143));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
 * Maps become Objects. Arbitrary keys are encoded to by key->js.
 */
cljs.core.clj__GT_js = (function cljs$core$clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__10159 = x;
if(G__10159){
var bit__4414__auto__ = null;
if(cljs.core.truth_((function (){var or__3740__auto__ = bit__4414__auto__;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return G__10159.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10159.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10159);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10159);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj10161 = {};
return obj10161;
})();
var seq__10162_10172 = cljs.core.seq(x);
var chunk__10163_10173 = null;
var count__10164_10174 = (0);
var i__10165_10175 = (0);
while(true){
if((i__10165_10175 < count__10164_10174)){
var vec__10166_10176 = chunk__10163_10173.cljs$core$IIndexed$_nth$arity$2(null,i__10165_10175);
var k_10177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10166_10176,(0),null);
var v_10178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10166_10176,(1),null);
(m[cljs.core.key__GT_js(k_10177)] = cljs$core$clj__GT_js(v_10178));

var G__10179 = seq__10162_10172;
var G__10180 = chunk__10163_10173;
var G__10181 = count__10164_10174;
var G__10182 = (i__10165_10175 + (1));
seq__10162_10172 = G__10179;
chunk__10163_10173 = G__10180;
count__10164_10174 = G__10181;
i__10165_10175 = G__10182;
continue;
} else {
var temp__4126__auto___10183 = cljs.core.seq(seq__10162_10172);
if(temp__4126__auto___10183){
var seq__10162_10184__$1 = temp__4126__auto___10183;
if(cljs.core.chunked_seq_QMARK_(seq__10162_10184__$1)){
var c__4525__auto___10185 = cljs.core.chunk_first(seq__10162_10184__$1);
var G__10186 = cljs.core.chunk_rest(seq__10162_10184__$1);
var G__10187 = c__4525__auto___10185;
var G__10188 = cljs.core.count(c__4525__auto___10185);
var G__10189 = (0);
seq__10162_10172 = G__10186;
chunk__10163_10173 = G__10187;
count__10164_10174 = G__10188;
i__10165_10175 = G__10189;
continue;
} else {
var vec__10167_10190 = cljs.core.first(seq__10162_10184__$1);
var k_10191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10167_10190,(0),null);
var v_10192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10167_10190,(1),null);
(m[cljs.core.key__GT_js(k_10191)] = cljs$core$clj__GT_js(v_10192));

var G__10193 = cljs.core.next(seq__10162_10184__$1);
var G__10194 = null;
var G__10195 = (0);
var G__10196 = (0);
seq__10162_10172 = G__10193;
chunk__10163_10173 = G__10194;
count__10164_10174 = G__10195;
i__10165_10175 = G__10196;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__10168_10197 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$clj__GT_js,x));
var chunk__10169_10198 = null;
var count__10170_10199 = (0);
var i__10171_10200 = (0);
while(true){
if((i__10171_10200 < count__10170_10199)){
var x_10201__$1 = chunk__10169_10198.cljs$core$IIndexed$_nth$arity$2(null,i__10171_10200);
arr.push(x_10201__$1);

var G__10202 = seq__10168_10197;
var G__10203 = chunk__10169_10198;
var G__10204 = count__10170_10199;
var G__10205 = (i__10171_10200 + (1));
seq__10168_10197 = G__10202;
chunk__10169_10198 = G__10203;
count__10170_10199 = G__10204;
i__10171_10200 = G__10205;
continue;
} else {
var temp__4126__auto___10206 = cljs.core.seq(seq__10168_10197);
if(temp__4126__auto___10206){
var seq__10168_10207__$1 = temp__4126__auto___10206;
if(cljs.core.chunked_seq_QMARK_(seq__10168_10207__$1)){
var c__4525__auto___10208 = cljs.core.chunk_first(seq__10168_10207__$1);
var G__10209 = cljs.core.chunk_rest(seq__10168_10207__$1);
var G__10210 = c__4525__auto___10208;
var G__10211 = cljs.core.count(c__4525__auto___10208);
var G__10212 = (0);
seq__10168_10197 = G__10209;
chunk__10169_10198 = G__10210;
count__10170_10199 = G__10211;
i__10171_10200 = G__10212;
continue;
} else {
var x_10213__$1 = cljs.core.first(seq__10168_10207__$1);
arr.push(x_10213__$1);

var G__10214 = cljs.core.next(seq__10168_10207__$1);
var G__10215 = null;
var G__10216 = (0);
var G__10217 = (0);
seq__10168_10197 = G__10214;
chunk__10169_10198 = G__10215;
count__10170_10199 = G__10216;
i__10171_10200 = G__10217;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj10219 = {};
return obj10219;
})();

/**
 * Transforms JavaScript values to Clojure
 */
cljs.core._js__GT_clj = (function cljs$core$_js__GT_clj(x,options){
if((function (){var and__3728__auto__ = x;
if(and__3728__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__3728__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4376__auto__ = (((x == null))?null:x);
return (function (){var or__3740__auto__ = (cljs.core._js__GT_clj[(function (){var G__10223 = x__4376__auto__;
return goog.typeOf(G__10223);
})()]);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 * vectors, and JavaScript objects into ClojureScript maps.  With
 * option ':keywordize-keys true' will convert object fields from
 * strings to keywords.
 * @param {...*} var_args
 */
cljs.core.js__GT_clj = (function() {
var cljs$core$js__GT_clj = null;
var cljs$core$js__GT_clj__1 = (function (x){
return cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});
var cljs$core$js__GT_clj__2 = (function() { 
var G__10280__delegate = function (x,opts){
var map__10253 = opts;
var map__10253__$1 = ((cljs.core.seq_QMARK_(map__10253))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10253):map__10253);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10253__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__10253,map__10253__$1,keywordize_keys,keyfn){
return (function cljs$core$js__GT_clj_$_thisfn(x__$1){
if((function (){var G__10269 = x__$1;
if(G__10269){
var bit__4414__auto__ = null;
if(cljs.core.truth_((function (){var or__3740__auto__ = bit__4414__auto__;
if(cljs.core.truth_(or__3740__auto__)){
return or__3740__auto__;
} else {
return G__10269.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__10269.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10269);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10269);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if(cljs.core.array_QMARK_(x__$1)){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4494__auto__ = ((function (map__10253,map__10253__$1,keywordize_keys,keyfn){
return (function cljs$core$js__GT_clj_$_thisfn_$_iter__10270(s__10271){
return (new cljs.core.LazySeq(null,((function (map__10253,map__10253__$1,keywordize_keys,keyfn){
return (function (){
var s__10271__$1 = s__10271;
while(true){
var temp__4126__auto__ = cljs.core.seq(s__10271__$1);
if(temp__4126__auto__){
var s__10271__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s__10271__$2)){
var c__4492__auto__ = cljs.core.chunk_first(s__10271__$2);
var size__4493__auto__ = cljs.core.count(c__4492__auto__);
var b__10273 = cljs.core.chunk_buffer(size__4493__auto__);
if((function (){var i__10272 = (0);
while(true){
if((i__10272 < size__4493__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4492__auto__,i__10272);
cljs.core.chunk_append(b__10273,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10278 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10278) : keyfn.call(null,G__10278));
})(),cljs$core$js__GT_clj_$_thisfn((x__$1[k]))], null));

var G__10281 = (i__10272 + (1));
i__10272 = G__10281;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__10273),cljs$core$js__GT_clj_$_thisfn_$_iter__10270(cljs.core.chunk_rest(s__10271__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__10273),null);
}
} else {
var k = cljs.core.first(s__10271__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10279 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10279) : keyfn.call(null,G__10279));
})(),cljs$core$js__GT_clj_$_thisfn((x__$1[k]))], null),cljs$core$js__GT_clj_$_thisfn_$_iter__10270(cljs.core.rest(s__10271__$2)));
}
} else {
return null;
}
break;
}
});})(map__10253,map__10253__$1,keywordize_keys,keyfn))
,null,null));
});})(map__10253,map__10253__$1,keywordize_keys,keyfn))
;
return iter__4494__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__10253,map__10253__$1,keywordize_keys,keyfn))
;
return f(x);
};
var G__10280 = function (x,var_args){
var opts = null;
if (arguments.length > 1) {
var G__10282__i = 0, G__10282__a = new Array(arguments.length -  1);
while (G__10282__i < G__10282__a.length) {G__10282__a[G__10282__i] = arguments[G__10282__i + 1]; ++G__10282__i;}
  opts = new cljs.core.IndexedSeq(G__10282__a,0);
} 
return G__10280__delegate.call(this,x,opts);};
G__10280.cljs$lang$maxFixedArity = 1;
G__10280.cljs$lang$applyTo = (function (arglist__10283){
var x = cljs.core.first(arglist__10283);
var opts = cljs.core.rest(arglist__10283);
return G__10280__delegate(x,opts);
});
G__10280.cljs$core$IFn$_invoke$arity$variadic = G__10280__delegate;
return G__10280;
})()
;
cljs$core$js__GT_clj = function(x,var_args){
var opts = var_args;
switch(arguments.length){
case 1:
return cljs$core$js__GT_clj__1.call(this,x);
default:
var G__10284 = null;
if (arguments.length > 1) {
var G__10285__i = 0, G__10285__a = new Array(arguments.length -  1);
while (G__10285__i < G__10285__a.length) {G__10285__a[G__10285__i] = arguments[G__10285__i + 1]; ++G__10285__i;}
G__10284 = new cljs.core.IndexedSeq(G__10285__a,0);
}
return cljs$core$js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic(x, G__10284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$js__GT_clj.cljs$lang$maxFixedArity = 1;
cljs$core$js__GT_clj.cljs$lang$applyTo = cljs$core$js__GT_clj__2.cljs$lang$applyTo;
cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$1 = cljs$core$js__GT_clj__1;
cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$js__GT_clj;
})()
;
/**
 * Returns a memoized version of a referentially transparent function. The
 * memoized version of the function keeps a cache of the mapping from arguments
 * to results and, when calls with the same arguments are repeated often, has
 * higher performance at the expense of higher memory use.
 */
cljs.core.memoize = (function cljs$core$memoize(f){
var mem = (function (){var G__10288 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10288) : cljs.core.atom.call(null,G__10288));
})();
return ((function (mem){
return (function() { 
var G__10290__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__10289 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10289) : cljs.core.deref.call(null,G__10289));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__10290 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10291__i = 0, G__10291__a = new Array(arguments.length -  0);
while (G__10291__i < G__10291__a.length) {G__10291__a[G__10291__i] = arguments[G__10291__i + 0]; ++G__10291__i;}
  args = new cljs.core.IndexedSeq(G__10291__a,0);
} 
return G__10290__delegate.call(this,args);};
G__10290.cljs$lang$maxFixedArity = 0;
G__10290.cljs$lang$applyTo = (function (arglist__10292){
var args = cljs.core.seq(arglist__10292);
return G__10290__delegate(args);
});
G__10290.cljs$core$IFn$_invoke$arity$variadic = G__10290__delegate;
return G__10290;
})()
;
;})(mem))
});
/**
 * trampoline can be used to convert algorithms requiring mutual
 * recursion without stack consumption. Calls f with supplied args, if
 * any. If f returns a fn, calls that fn with no arguments, and
 * continues to repeat, until the return value is not a fn, then
 * returns that non-fn value. Note that if you want to return a fn as a
 * final value, you must wrap it in some data structure and unpack it
 * after trampoline returns.
 * @param {...*} var_args
 */
cljs.core.trampoline = (function() {
var cljs$core$trampoline = null;
var cljs$core$trampoline__1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__10294 = ret;
f = G__10294;
continue;
} else {
return ret;
}
break;
}
});
var cljs$core$trampoline__2 = (function() { 
var G__10295__delegate = function (f,args){
return cljs$core$trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
};
var G__10295 = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__10296__i = 0, G__10296__a = new Array(arguments.length -  1);
while (G__10296__i < G__10296__a.length) {G__10296__a[G__10296__i] = arguments[G__10296__i + 1]; ++G__10296__i;}
  args = new cljs.core.IndexedSeq(G__10296__a,0);
} 
return G__10295__delegate.call(this,f,args);};
G__10295.cljs$lang$maxFixedArity = 1;
G__10295.cljs$lang$applyTo = (function (arglist__10297){
var f = cljs.core.first(arglist__10297);
var args = cljs.core.rest(arglist__10297);
return G__10295__delegate(f,args);
});
G__10295.cljs$core$IFn$_invoke$arity$variadic = G__10295__delegate;
return G__10295;
})()
;
cljs$core$trampoline = function(f,var_args){
var args = var_args;
switch(arguments.length){
case 1:
return cljs$core$trampoline__1.call(this,f);
default:
var G__10298 = null;
if (arguments.length > 1) {
var G__10299__i = 0, G__10299__a = new Array(arguments.length -  1);
while (G__10299__i < G__10299__a.length) {G__10299__a[G__10299__i] = arguments[G__10299__i + 1]; ++G__10299__i;}
G__10298 = new cljs.core.IndexedSeq(G__10299__a,0);
}
return cljs$core$trampoline__2.cljs$core$IFn$_invoke$arity$variadic(f, G__10298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$trampoline.cljs$lang$maxFixedArity = 1;
cljs$core$trampoline.cljs$lang$applyTo = cljs$core$trampoline__2.cljs$lang$applyTo;
cljs$core$trampoline.cljs$core$IFn$_invoke$arity$1 = cljs$core$trampoline__1;
cljs$core$trampoline.cljs$core$IFn$_invoke$arity$variadic = cljs$core$trampoline__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$trampoline;
})()
;
/**
 * Returns a random floating point number between 0 (inclusive) and
 * n (default 1) (exclusive).
 */
cljs.core.rand = (function() {
var cljs$core$rand = null;
var cljs$core$rand__0 = (function (){
return cljs$core$rand.cljs$core$IFn$_invoke$arity$1((1));
});
var cljs$core$rand__1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});
cljs$core$rand = function(n){
switch(arguments.length){
case 0:
return cljs$core$rand__0.call(this);
case 1:
return cljs$core$rand__1.call(this,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$rand.cljs$core$IFn$_invoke$arity$0 = cljs$core$rand__0;
cljs$core$rand.cljs$core$IFn$_invoke$arity$1 = cljs$core$rand__1;
return cljs$core$rand;
})()
;
/**
 * Returns a random integer between 0 (inclusive) and n (exclusive).
 */
cljs.core.rand_int = (function cljs$core$rand_int(n){
var G__10302 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__10302) : Math.floor.call(null,G__10302));
});
/**
 * Return a random element of the (sequential) collection. Will have
 * the same performance characteristics as nth for the given
 * collection.
 */
cljs.core.rand_nth = (function cljs$core$rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
 * Returns a map of the elements of coll keyed by the result of
 * f on each element. The value at each key will be a vector of the
 * corresponding elements, in the order they appeared in coll.
 */
cljs.core.group_by = (function cljs$core$group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__10304 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10304) : f.call(null,G__10304));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Creates a hierarchy object for use with derive, isa? etc.
 */
cljs.core.make_hierarchy = (function cljs$core$make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function cljs$core$get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__10306 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10306) : cljs.core.atom.call(null,G__10306));
})();
} else {
}

return cljs.core._global_hierarchy;
});
/**
 * @param {...*} var_args
 */
cljs.core.swap_global_hierarchy_BANG_ = (function() { 
var cljs$core$swap_global_hierarchy_BANG___delegate = function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
};
var cljs$core$swap_global_hierarchy_BANG_ = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__10307__i = 0, G__10307__a = new Array(arguments.length -  1);
while (G__10307__i < G__10307__a.length) {G__10307__a[G__10307__i] = arguments[G__10307__i + 1]; ++G__10307__i;}
  args = new cljs.core.IndexedSeq(G__10307__a,0);
} 
return cljs$core$swap_global_hierarchy_BANG___delegate.call(this,f,args);};
cljs$core$swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = 1;
cljs$core$swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (arglist__10308){
var f = cljs.core.first(arglist__10308);
var args = cljs.core.rest(arglist__10308);
return cljs$core$swap_global_hierarchy_BANG___delegate(f,args);
});
cljs$core$swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$swap_global_hierarchy_BANG___delegate;
return cljs$core$swap_global_hierarchy_BANG_;
})()
;
/**
 * Returns true if (= child parent), or child is directly or indirectly derived from
 * parent, either via a JavaScript type inheritance relationship or a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy
 */
cljs.core.isa_QMARK_ = (function() {
var cljs$core$isa_QMARK_ = null;
var cljs$core$isa_QMARK___2 = (function (child,parent){
return cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__10373 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10373) : cljs.core.deref.call(null,G__10373));
})(),child,parent);
});
var cljs$core$isa_QMARK___3 = (function (h,child,parent){
var or__3740__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__3740__auto__){
return or__3740__auto__;
} else {
var or__3740__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__3740__auto____$1){
return or__3740__auto____$1;
} else {
var and__3728__auto__ = cljs.core.vector_QMARK_(parent);
if(and__3728__auto__){
var and__3728__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__3728__auto____$1){
var and__3728__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__3728__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__10398 = cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__10396 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__10396) : child.call(null,G__10396));
})(),(function (){var G__10397 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__10397) : parent.call(null,G__10397));
})());
var G__10399 = (i + (1));
ret = G__10398;
i = G__10399;
continue;
}
break;
}
} else {
return and__3728__auto____$2;
}
} else {
return and__3728__auto____$1;
}
} else {
return and__3728__auto__;
}
}
}
});
cljs$core$isa_QMARK_ = function(h,child,parent){
switch(arguments.length){
case 2:
return cljs$core$isa_QMARK___2.call(this,h,child);
case 3:
return cljs$core$isa_QMARK___3.call(this,h,child,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = cljs$core$isa_QMARK___2;
cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = cljs$core$isa_QMARK___3;
return cljs$core$isa_QMARK_;
})()
;
/**
 * Returns the immediate parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.parents = (function() {
var cljs$core$parents = null;
var cljs$core$parents__1 = (function (tag){
return cljs$core$parents.cljs$core$IFn$_invoke$arity$2((function (){var G__10403 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10403) : cljs.core.deref.call(null,G__10403));
})(),tag);
});
var cljs$core$parents__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$parents = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$parents__1.call(this,h);
case 2:
return cljs$core$parents__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$parents.cljs$core$IFn$_invoke$arity$1 = cljs$core$parents__1;
cljs$core$parents.cljs$core$IFn$_invoke$arity$2 = cljs$core$parents__2;
return cljs$core$parents;
})()
;
/**
 * Returns the immediate and indirect parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.ancestors = (function() {
var cljs$core$ancestors = null;
var cljs$core$ancestors__1 = (function (tag){
return cljs$core$ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__10407 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10407) : cljs.core.deref.call(null,G__10407));
})(),tag);
});
var cljs$core$ancestors__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$ancestors = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$ancestors__1.call(this,h);
case 2:
return cljs$core$ancestors__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ancestors.cljs$core$IFn$_invoke$arity$1 = cljs$core$ancestors__1;
cljs$core$ancestors.cljs$core$IFn$_invoke$arity$2 = cljs$core$ancestors__2;
return cljs$core$ancestors;
})()
;
/**
 * Returns the immediate and indirect children of tag, through a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy. Note: does not work on JavaScript type inheritance
 * relationships.
 */
cljs.core.descendants = (function() {
var cljs$core$descendants = null;
var cljs$core$descendants__1 = (function (tag){
return cljs$core$descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__10411 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10411) : cljs.core.deref.call(null,G__10411));
})(),tag);
});
var cljs$core$descendants__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$descendants = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$descendants__1.call(this,h);
case 2:
return cljs$core$descendants__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$descendants.cljs$core$IFn$_invoke$arity$1 = cljs$core$descendants__1;
cljs$core$descendants.cljs$core$IFn$_invoke$arity$2 = cljs$core$descendants__2;
return cljs$core$descendants;
})()
;
/**
 * Establishes a parent/child relationship between parent and
 * tag. Parent must be a namespace-qualified symbol or keyword and
 * child can be either a namespace-qualified symbol or keyword or a
 * class. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.derive = (function() {
var cljs$core$derive = null;
var cljs$core$derive__2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs$core$derive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var cljs$core$derive__3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__10420 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__10420) : targets.call(null,G__10420));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__10421 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__10421) : sources.call(null,G__10421));
})()));
});})(tp,td,ta))
;
var or__3740__auto__ = ((cljs.core.contains_QMARK_((function (){var G__10425 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__10425) : tp.call(null,G__10425));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__10426 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10426) : ta.call(null,G__10426));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__10427 = parent;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10427) : 