// Compiled by ClojureScript 0.0-3169 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string.StringBuffer');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3169";
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
 * Var bound to the name value of the compiler build :target option.
 * For example, if the compiler build :target is :nodejs, *target* will be bound
 * to "nodejs". *target* is a Google Closure define and can be set by compiler
 * :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = "default";
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 * Whatever function *print-fn* is bound to will be passed any
 * Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 * Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 * This is to work around the implicit newlines emitted by standard JavaScript
 * console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 * non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 * Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 * be printed in a form that can be read back by the reader.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 * print nested objects. If it is bound to logical false, there is no
 * limit. Otherwise, it must be bound to an integer indicating the maximum
 * level to print. Each argument to print is at level 0; if an argument is a
 * collection, its items are at level 1; and so on. If an object is a
 * collection and is at a level greater than or equal to the value bound to
 * *print-level*, the printer prints '#' to represent it. The root binding
 * is nil indicating no limit.
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__5284__delegate = function (args){
return console.log.apply(console,(function (){var G__5283 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__5283) : cljs.core.into_array.call(null,G__5283));
})());
};
var G__5284 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__5285__i = 0, G__5285__a = new Array(arguments.length -  0);
while (G__5285__i < G__5285__a.length) {G__5285__a[G__5285__i] = arguments[G__5285__i + 0]; ++G__5285__i;}
  args = new cljs.core.IndexedSeq(G__5285__a,0);
} 
return G__5284__delegate.call(this,args);};
G__5284.cljs$lang$maxFixedArity = 0;
G__5284.cljs$lang$applyTo = (function (arglist__5286){
var args = cljs.core.seq(arglist__5286);
return G__5284__delegate(args);
});
G__5284.cljs$core$IFn$_invoke$arity$variadic = G__5284__delegate;
return G__5284;
})()
;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(n){
return typeof n === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
var G__5288 = x;
return goog.isString(G__5288);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__5290 = x__$1;
return goog.typeOf(G__5290);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever
 * function *main-fn* is set to will be called with the command-line
 * argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__3755__auto__ = ty;
if(cljs.core.truth_(and__3755__auto__)){
return ty.cljs$lang$type;
} else {
return and__3755__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__5292 = obj;
return goog.typeOf(G__5292);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4124__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4124__auto__)){
var s = temp__4124__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__5294 = Symbol;
return goog.typeOf(G__5294);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 * argument for compatibility with Clojure.
 */
cljs.core.make_array = (function() {
var cljs$core$make_array = null;
var cljs$core$make_array__1 = (function (size){
return (new Array(size));
});
var cljs$core$make_array__2 = (function (type,size){
return cljs$core$make_array.cljs$core$IFn$_invoke$arity$1(size);
});
cljs$core$make_array = function(type,size){
switch(arguments.length){
case 1:
return cljs$core$make_array__1.call(this,type);
case 2:
return cljs$core$make_array__2.call(this,type,size);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$make_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$make_array__1;
cljs$core$make_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$make_array__2;
return cljs$core$make_array;
})()
;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4652__auto___5296 = len;
var i_5297 = (0);
while(true){
if((i_5297 < n__4652__auto___5296)){
(new_arr[i_5297] = (arr[i_5297]));

var G__5298 = (i_5297 + (1));
i_5297 = G__5298;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__5299 = (i + (1));
i = G__5299;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 * @param {...*} var_args
 */
cljs.core.aget = (function() {
var cljs$core$aget = null;
var cljs$core$aget__2 = (function (array,i){
return (array[i]);
});
var cljs$core$aget__3 = (function() { 
var G__5308__delegate = function (array,i,idxs){
var G__5305 = cljs$core$aget;
var G__5306 = cljs$core$aget.cljs$core$IFn$_invoke$arity$2(array,i);
var G__5307 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__5305,G__5306,G__5307) : cljs.core.apply.call(null,G__5305,G__5306,G__5307));
};
var G__5308 = function (array,i,var_args){
var idxs = null;
if (arguments.length > 2) {
var G__5309__i = 0, G__5309__a = new Array(arguments.length -  2);
while (G__5309__i < G__5309__a.length) {G__5309__a[G__5309__i] = arguments[G__5309__i + 2]; ++G__5309__i;}
  idxs = new cljs.core.IndexedSeq(G__5309__a,0);
} 
return G__5308__delegate.call(this,array,i,idxs);};
G__5308.cljs$lang$maxFixedArity = 2;
G__5308.cljs$lang$applyTo = (function (arglist__5310){
var array = cljs.core.first(arglist__5310);
arglist__5310 = cljs.core.next(arglist__5310);
var i = cljs.core.first(arglist__5310);
var idxs = cljs.core.rest(arglist__5310);
return G__5308__delegate(array,i,idxs);
});
G__5308.cljs$core$IFn$_invoke$arity$variadic = G__5308__delegate;
return G__5308;
})()
;
cljs$core$aget = function(array,i,var_args){
var idxs = var_args;
switch(arguments.length){
case 2:
return cljs$core$aget__2.call(this,array,i);
default:
var G__5311 = null;
if (arguments.length > 2) {
var G__5312__i = 0, G__5312__a = new Array(arguments.length -  2);
while (G__5312__i < G__5312__a.length) {G__5312__a[G__5312__i] = arguments[G__5312__i + 2]; ++G__5312__i;}
G__5311 = new cljs.core.IndexedSeq(G__5312__a,0);
}
return cljs$core$aget__3.cljs$core$IFn$_invoke$arity$variadic(array,i, G__5311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$aget.cljs$lang$maxFixedArity = 2;
cljs$core$aget.cljs$lang$applyTo = cljs$core$aget__3.cljs$lang$applyTo;
cljs$core$aget.cljs$core$IFn$_invoke$arity$2 = cljs$core$aget__2;
cljs$core$aget.cljs$core$IFn$_invoke$arity$variadic = cljs$core$aget__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$aget;
})()
;
/**
 * Sets the value at the index.
 * @param {...*} var_args
 */
cljs.core.aset = (function() {
var cljs$core$aset = null;
var cljs$core$aset__3 = (function (array,i,val){
return (array[i] = val);
});
var cljs$core$aset__4 = (function() { 
var G__5321__delegate = function (array,idx,idx2,idxv){
var G__5317 = cljs$core$aset;
var G__5318 = (array[idx]);
var G__5319 = idx2;
var G__5320 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__5317,G__5318,G__5319,G__5320) : cljs.core.apply.call(null,G__5317,G__5318,G__5319,G__5320));
};
var G__5321 = function (array,idx,idx2,var_args){
var idxv = null;
if (arguments.length > 3) {
var G__5322__i = 0, G__5322__a = new Array(arguments.length -  3);
while (G__5322__i < G__5322__a.length) {G__5322__a[G__5322__i] = arguments[G__5322__i + 3]; ++G__5322__i;}
  idxv = new cljs.core.IndexedSeq(G__5322__a,0);
} 
return G__5321__delegate.call(this,array,idx,idx2,idxv);};
G__5321.cljs$lang$maxFixedArity = 3;
G__5321.cljs$lang$applyTo = (function (arglist__5323){
var array = cljs.core.first(arglist__5323);
arglist__5323 = cljs.core.next(arglist__5323);
var idx = cljs.core.first(arglist__5323);
arglist__5323 = cljs.core.next(arglist__5323);
var idx2 = cljs.core.first(arglist__5323);
var idxv = cljs.core.rest(arglist__5323);
return G__5321__delegate(array,idx,idx2,idxv);
});
G__5321.cljs$core$IFn$_invoke$arity$variadic = G__5321__delegate;
return G__5321;
})()
;
cljs$core$aset = function(array,idx,idx2,var_args){
var idxv = var_args;
switch(arguments.length){
case 3:
return cljs$core$aset__3.call(this,array,idx,idx2);
default:
var G__5324 = null;
if (arguments.length > 3) {
var G__5325__i = 0, G__5325__a = new Array(arguments.length -  3);
while (G__5325__i < G__5325__a.length) {G__5325__a[G__5325__i] = arguments[G__5325__i + 3]; ++G__5325__i;}
G__5324 = new cljs.core.IndexedSeq(G__5325__a,0);
}
return cljs$core$aset__4.cljs$core$IFn$_invoke$arity$variadic(array,idx,idx2, G__5324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$aset.cljs$lang$maxFixedArity = 3;
cljs$core$aset.cljs$lang$applyTo = cljs$core$aset__4.cljs$lang$applyTo;
cljs$core$aset.cljs$core$IFn$_invoke$arity$3 = cljs$core$aset__3;
cljs$core$aset.cljs$core$IFn$_invoke$arity$variadic = cljs$core$aset__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$aset;
})()
;
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 * argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function() {
var cljs$core$into_array = null;
var cljs$core$into_array__1 = (function (aseq){
return cljs$core$into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});
var cljs$core$into_array__2 = (function (type,aseq){
var G__5331 = (function (a,x){
a.push(x);

return a;
});
var G__5332 = [];
var G__5333 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__5331,G__5332,G__5333) : cljs.core.reduce.call(null,G__5331,G__5332,G__5333));
});
cljs$core$into_array = function(type,aseq){
switch(arguments.length){
case 1:
return cljs$core$into_array__1.call(this,type);
case 2:
return cljs$core$into_array__2.call(this,type,aseq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$into_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$into_array__1;
cljs$core$into_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$into_array__2;
return cljs$core$into_array;
})()
;
/**
 * Invoke JavaScript object method via string. Needed when the
 * string is not a valid unquoted property name.
 * @param {...*} var_args
 */
cljs.core.js_invoke = (function() { 
var cljs$core$js_invoke__delegate = function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
var cljs$core$js_invoke = function (obj,s,var_args){
var args = null;
if (arguments.length > 2) {
var G__5334__i = 0, G__5334__a = new Array(arguments.length -  2);
while (G__5334__i < G__5334__a.length) {G__5334__a[G__5334__i] = arguments[G__5334__i + 2]; ++G__5334__i;}
  args = new cljs.core.IndexedSeq(G__5334__a,0);
} 
return cljs$core$js_invoke__delegate.call(this,obj,s,args);};
cljs$core$js_invoke.cljs$lang$maxFixedArity = 2;
cljs$core$js_invoke.cljs$lang$applyTo = (function (arglist__5335){
var obj = cljs.core.first(arglist__5335);
arglist__5335 = cljs.core.next(arglist__5335);
var s = cljs.core.first(arglist__5335);
var args = cljs.core.rest(arglist__5335);
return cljs$core$js_invoke__delegate(obj,s,args);
});
cljs$core$js_invoke.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js_invoke__delegate;
return cljs$core$js_invoke;
})()
;

/**
 * Marker protocol
 */
cljs.core.Fn = (function (){var obj5337 = {};
return obj5337;
})();


/**
 * Protocol for adding the ability to invoke an object as a function.
 * For example, a vector can also be used to look up a value:
 * ([1 2 3 4] 1) => 2
 */
cljs.core.IFn = (function (){var obj5339 = {};
return obj5339;
})();

cljs.core._invoke = (function() {
var cljs$core$_invoke = null;
var cljs$core$_invoke__1 = (function (this$){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5385 = x__4403__auto__;
return goog.typeOf(G__5385);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});
var cljs$core$_invoke__2 = (function (this$,a){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5387 = x__4403__auto__;
return goog.typeOf(G__5387);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});
var cljs$core$_invoke__3 = (function (this$,a,b){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5389 = x__4403__auto__;
return goog.typeOf(G__5389);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});
var cljs$core$_invoke__4 = (function (this$,a,b,c){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5391 = x__4403__auto__;
return goog.typeOf(G__5391);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});
var cljs$core$_invoke__5 = (function (this$,a,b,c,d){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5393 = x__4403__auto__;
return goog.typeOf(G__5393);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});
var cljs$core$_invoke__6 = (function (this$,a,b,c,d,e){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5395 = x__4403__auto__;
return goog.typeOf(G__5395);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});
var cljs$core$_invoke__7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5397 = x__4403__auto__;
return goog.typeOf(G__5397);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});
var cljs$core$_invoke__8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5399 = x__4403__auto__;
return goog.typeOf(G__5399);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});
var cljs$core$_invoke__9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5401 = x__4403__auto__;
return goog.typeOf(G__5401);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});
var cljs$core$_invoke__10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5403 = x__4403__auto__;
return goog.typeOf(G__5403);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});
var cljs$core$_invoke__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5405 = x__4403__auto__;
return goog.typeOf(G__5405);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});
var cljs$core$_invoke__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5407 = x__4403__auto__;
return goog.typeOf(G__5407);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});
var cljs$core$_invoke__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5409 = x__4403__auto__;
return goog.typeOf(G__5409);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});
var cljs$core$_invoke__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5411 = x__4403__auto__;
return goog.typeOf(G__5411);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});
var cljs$core$_invoke__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5413 = x__4403__auto__;
return goog.typeOf(G__5413);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});
var cljs$core$_invoke__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5415 = x__4403__auto__;
return goog.typeOf(G__5415);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});
var cljs$core$_invoke__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5417 = x__4403__auto__;
return goog.typeOf(G__5417);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});
var cljs$core$_invoke__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5419 = x__4403__auto__;
return goog.typeOf(G__5419);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});
var cljs$core$_invoke__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5421 = x__4403__auto__;
return goog.typeOf(G__5421);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});
var cljs$core$_invoke__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5423 = x__4403__auto__;
return goog.typeOf(G__5423);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});
var cljs$core$_invoke__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5425 = x__4403__auto__;
return goog.typeOf(G__5425);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});
var cljs$core$_invoke__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._invoke[(function (){var G__5427 = x__4403__auto__;
return goog.typeOf(G__5427);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._invoke["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});
cljs$core$_invoke = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$_invoke__1.call(this,this$);
case 2:
return cljs$core$_invoke__2.call(this,this$,a);
case 3:
return cljs$core$_invoke__3.call(this,this$,a,b);
case 4:
return cljs$core$_invoke__4.call(this,this$,a,b,c);
case 5:
return cljs$core$_invoke__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$_invoke__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$_invoke__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$_invoke__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$_invoke__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$_invoke__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$_invoke__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$_invoke__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$_invoke__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$_invoke__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$_invoke__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$_invoke__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$_invoke__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$_invoke__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$_invoke__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$_invoke__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$_invoke__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$_invoke__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$1 = cljs$core$_invoke__1;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$2 = cljs$core$_invoke__2;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$3 = cljs$core$_invoke__3;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$4 = cljs$core$_invoke__4;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$5 = cljs$core$_invoke__5;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$6 = cljs$core$_invoke__6;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$7 = cljs$core$_invoke__7;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$8 = cljs$core$_invoke__8;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$9 = cljs$core$_invoke__9;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$10 = cljs$core$_invoke__10;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$11 = cljs$core$_invoke__11;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$12 = cljs$core$_invoke__12;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$13 = cljs$core$_invoke__13;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$14 = cljs$core$_invoke__14;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$15 = cljs$core$_invoke__15;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$16 = cljs$core$_invoke__16;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$17 = cljs$core$_invoke__17;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$18 = cljs$core$_invoke__18;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$19 = cljs$core$_invoke__19;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$20 = cljs$core$_invoke__20;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$21 = cljs$core$_invoke__21;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$22 = cljs$core$_invoke__22;
return cljs$core$_invoke;
})()
;


/**
 * Protocol for cloning a value.
 */
cljs.core.ICloneable = (function (){var obj5429 = {};
return obj5429;
})();

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((function (){var and__3755__auto__ = value;
if(and__3755__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__3755__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4403__auto__ = (((value == null))?null:value);
return (function (){var or__3767__auto__ = (cljs.core._clone[(function (){var G__5433 = x__4403__auto__;
return goog.typeOf(G__5433);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._clone["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 */
cljs.core.ICounted = (function (){var obj5435 = {};
return obj5435;
})();

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._count[(function (){var G__5439 = x__4403__auto__;
return goog.typeOf(G__5439);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._count["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for creating an empty collection.
 */
cljs.core.IEmptyableCollection = (function (){var obj5441 = {};
return obj5441;
})();

/**
 * Returns an empty collection of the same category as coll. Used
 * by cljs.core/count.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._empty[(function (){var G__5445 = x__4403__auto__;
return goog.typeOf(G__5445);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._empty["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding to a collection.
 */
cljs.core.ICollection = (function (){var obj5447 = {};
return obj5447;
})();

/**
 * Returns a new collection of coll with o added to it. The new item
 * should be added to the most efficient place, e.g.
 * (conj [1 2 3 4] 5) => [1 2 3 4 5]
 * (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._conj[(function (){var G__5451 = x__4403__auto__;
return goog.typeOf(G__5451);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._conj["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


/**
 * Protocol for collections to provide idexed-based access to their items.
 */
cljs.core.IIndexed = (function (){var obj5453 = {};
return obj5453;
})();

/**
 * Returns the value at the index n in the collection coll.
 * Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function() {
var cljs$core$_nth = null;
var cljs$core$_nth__2 = (function (coll,n){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._nth[(function (){var G__5459 = x__4403__auto__;
return goog.typeOf(G__5459);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._nth["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});
var cljs$core$_nth__3 = (function (coll,n,not_found){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._nth[(function (){var G__5461 = x__4403__auto__;
return goog.typeOf(G__5461);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._nth["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});
cljs$core$_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$_nth__2.call(this,coll,n);
case 3:
return cljs$core$_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$_nth__2;
cljs$core$_nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$_nth__3;
return cljs$core$_nth;
})()
;


/**
 * Marker protocol indicating an array sequence.
 */
cljs.core.ASeq = (function (){var obj5463 = {};
return obj5463;
})();


/**
 * Protocol for collections to provide access to their items as sequences.
 */
cljs.core.ISeq = (function (){var obj5465 = {};
return obj5465;
})();

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._first[(function (){var G__5469 = x__4403__auto__;
return goog.typeOf(G__5469);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._first["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new collection of coll without the first item. It should
 * always return a seq, e.g.
 * (rest []) => ()
 * (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._rest[(function (){var G__5473 = x__4403__auto__;
return goog.typeOf(G__5473);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._rest["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 */
cljs.core.INext = (function (){var obj5475 = {};
return obj5475;
})();

/**
 * Returns a new collection of coll without the first item. In contrast to
 * rest, it should return nil if there are no more items, e.g.
 * (next []) => nil
 * (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._next[(function (){var G__5479 = x__4403__auto__;
return goog.typeOf(G__5479);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._next["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 */
cljs.core.ILookup = (function (){var obj5481 = {};
return obj5481;
})();

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 * a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function() {
var cljs$core$_lookup = null;
var cljs$core$_lookup__2 = (function (o,k){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._lookup[(function (){var G__5487 = x__4403__auto__;
return goog.typeOf(G__5487);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._lookup["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});
var cljs$core$_lookup__3 = (function (o,k,not_found){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._lookup[(function (){var G__5489 = x__4403__auto__;
return goog.typeOf(G__5489);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._lookup["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});
cljs$core$_lookup = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$_lookup__2.call(this,o,k);
case 3:
return cljs$core$_lookup__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_lookup.cljs$core$IFn$_invoke$arity$2 = cljs$core$_lookup__2;
cljs$core$_lookup.cljs$core$IFn$_invoke$arity$3 = cljs$core$_lookup__3;
return cljs$core$_lookup;
})()
;


/**
 * Protocol for adding associativity to collections.
 */
cljs.core.IAssociative = (function (){var obj5491 = {};
return obj5491;
})();

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__5495 = x__4403__auto__;
return goog.typeOf(G__5495);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 * value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._assoc[(function (){var G__5499 = x__4403__auto__;
return goog.typeOf(G__5499);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._assoc["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 */
cljs.core.IMap = (function (){var obj5501 = {};
return obj5501;
})();

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._dissoc[(function (){var G__5505 = x__4403__auto__;
return goog.typeOf(G__5505);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._dissoc["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


/**
 * Protocol for examining a map entry.
 */
cljs.core.IMapEntry = (function (){var obj5507 = {};
return obj5507;
})();

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._key[(function (){var G__5511 = x__4403__auto__;
return goog.typeOf(G__5511);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._key["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._val[(function (){var G__5515 = x__4403__auto__;
return goog.typeOf(G__5515);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._val["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 */
cljs.core.ISet = (function (){var obj5517 = {};
return obj5517;
})();

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._disjoin[(function (){var G__5521 = x__4403__auto__;
return goog.typeOf(G__5521);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._disjoin["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 * of the stack should be accessed in the most efficient way for the different
 * data structures.
 */
cljs.core.IStack = (function (){var obj5523 = {};
return obj5523;
})();

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._peek[(function (){var G__5527 = x__4403__auto__;
return goog.typeOf(G__5527);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._peek["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 * by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._pop[(function (){var G__5531 = x__4403__auto__;
return goog.typeOf(G__5531);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._pop["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 */
cljs.core.IVector = (function (){var obj5533 = {};
return obj5533;
})();

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._assoc_n[(function (){var G__5537 = x__4403__auto__;
return goog.typeOf(G__5537);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 */
cljs.core.IDeref = (function (){var obj5539 = {};
return obj5539;
})();

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._deref[(function (){var G__5543 = x__4403__auto__;
return goog.typeOf(G__5543);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._deref["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj5545 = {};
return obj5545;
})();

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._deref_with_timeout[(function (){var G__5549 = x__4403__auto__;
return goog.typeOf(G__5549);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 */
cljs.core.IMeta = (function (){var obj5551 = {};
return obj5551;
})();

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._meta[(function (){var G__5555 = x__4403__auto__;
return goog.typeOf(G__5555);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._meta["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding metadata to an object.
 */
cljs.core.IWithMeta = (function (){var obj5557 = {};
return obj5557;
})();

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._with_meta[(function (){var G__5561 = x__4403__auto__;
return goog.typeOf(G__5561);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._with_meta["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 * Called by cljs.core/reduce.
 */
cljs.core.IReduce = (function (){var obj5563 = {};
return obj5563;
})();

/**
 * f should be a function of 2 arguments. If start is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function() {
var cljs$core$_reduce = null;
var cljs$core$_reduce__2 = (function (coll,f){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._reduce[(function (){var G__5569 = x__4403__auto__;
return goog.typeOf(G__5569);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._reduce["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});
var cljs$core$_reduce__3 = (function (coll,f,start){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._reduce[(function (){var G__5571 = x__4403__auto__;
return goog.typeOf(G__5571);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._reduce["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});
cljs$core$_reduce = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$_reduce__2.call(this,coll,f);
case 3:
return cljs$core$_reduce__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$_reduce__2;
cljs$core$_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$_reduce__3;
return cljs$core$_reduce;
})()
;


/**
 * Protocol for associative types that can reduce themselves
 * via a function of key and val. Called by cljs.core/reduce-kv.
 */
cljs.core.IKVReduce = (function (){var obj5573 = {};
return obj5573;
})();

/**
 * Reduces an associative collection and returns the result. f should be
 * a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._kv_reduce[(function (){var G__5577 = x__4403__auto__;
return goog.typeOf(G__5577);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 */
cljs.core.IEquiv = (function (){var obj5579 = {};
return obj5579;
})();

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._equiv[(function (){var G__5583 = x__4403__auto__;
return goog.typeOf(G__5583);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._equiv["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 */
cljs.core.IHash = (function (){var obj5585 = {};
return obj5585;
})();

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._hash[(function (){var G__5589 = x__4403__auto__;
return goog.typeOf(G__5589);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._hash["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 */
cljs.core.ISeqable = (function (){var obj5591 = {};
return obj5591;
})();

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._seq[(function (){var G__5595 = x__4403__auto__;
return goog.typeOf(G__5595);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._seq["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 */
cljs.core.ISequential = (function (){var obj5597 = {};
return obj5597;
})();


/**
 * Marker interface indicating a persistent list
 */
cljs.core.IList = (function (){var obj5599 = {};
return obj5599;
})();


/**
 * Marker interface indicating a record object
 */
cljs.core.IRecord = (function (){var obj5601 = {};
return obj5601;
})();


/**
 * Protocol for reversing a seq.
 */
cljs.core.IReversible = (function (){var obj5603 = {};
return obj5603;
})();

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._rseq[(function (){var G__5607 = x__4403__auto__;
return goog.typeOf(G__5607);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._rseq["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for a collection which can represent their items
 * in a sorted manner.
 */
cljs.core.ISorted = (function (){var obj5609 = {};
return obj5609;
})();

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._sorted_seq[(function (){var G__5613 = x__4403__auto__;
return goog.typeOf(G__5613);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 * If ascending is true, the result should contain all items which are > or >=
 * than k. If ascending is false, the result should contain all items which
 * are < or <= than k, e.g.
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._sorted_seq_from[(function (){var G__5617 = x__4403__auto__;
return goog.typeOf(G__5617);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._entry_key[(function (){var G__5621 = x__4403__auto__;
return goog.typeOf(G__5621);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._entry_key["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._comparator[(function (){var G__5625 = x__4403__auto__;
return goog.typeOf(G__5625);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._comparator["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 */
cljs.core.IWriter = (function (){var obj5627 = {};
return obj5627;
})();

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((function (){var and__3755__auto__ = writer;
if(and__3755__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__3755__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4403__auto__ = (((writer == null))?null:writer);
return (function (){var or__3767__auto__ = (cljs.core._write[(function (){var G__5631 = x__4403__auto__;
return goog.typeOf(G__5631);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._write["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((function (){var and__3755__auto__ = writer;
if(and__3755__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__3755__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4403__auto__ = (((writer == null))?null:writer);
return (function (){var or__3767__auto__ = (cljs.core._flush[(function (){var G__5635 = x__4403__auto__;
return goog.typeOf(G__5635);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._flush["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 */
cljs.core.IPrintWithWriter = (function (){var obj5637 = {};
return obj5637;
})();

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._pr_writer[(function (){var G__5641 = x__4403__auto__;
return goog.typeOf(G__5641);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 * implemented by Delay.
 */
cljs.core.IPending = (function (){var obj5643 = {};
return obj5643;
})();

/**
 * Returns true if a value for d has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(d){
if((function (){var and__3755__auto__ = d;
if(and__3755__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__3755__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4403__auto__ = (((d == null))?null:d);
return (function (){var or__3767__auto__ = (cljs.core._realized_QMARK_[(function (){var G__5647 = x__4403__auto__;
return goog.typeOf(G__5647);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 */
cljs.core.IWatchable = (function (){var obj5649 = {};
return obj5649;
})();

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._notify_watches[(function (){var G__5653 = x__4403__auto__;
return goog.typeOf(G__5653);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 * and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._add_watch[(function (){var G__5657 = x__4403__auto__;
return goog.typeOf(G__5657);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._add_watch["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((function (){var and__3755__auto__ = this$;
if(and__3755__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__3755__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4403__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3767__auto__ = (cljs.core._remove_watch[(function (){var G__5661 = x__4403__auto__;
return goog.typeOf(G__5661);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 */
cljs.core.IEditableCollection = (function (){var obj5663 = {};
return obj5663;
})();

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._as_transient[(function (){var G__5667 = x__4403__auto__;
return goog.typeOf(G__5667);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._as_transient["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 */
cljs.core.ITransientCollection = (function (){var obj5669 = {};
return obj5669;
})();

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((function (){var and__3755__auto__ = tcoll;
if(and__3755__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__3755__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4403__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3767__auto__ = (cljs.core._conj_BANG_[(function (){var G__5673 = x__4403__auto__;
return goog.typeOf(G__5673);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((function (){var and__3755__auto__ = tcoll;
if(and__3755__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__3755__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4403__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3767__auto__ = (cljs.core._persistent_BANG_[(function (){var G__5677 = x__4403__auto__;
return goog.typeOf(G__5677);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 */
cljs.core.ITransientAssociative = (function (){var obj5679 = {};
return obj5679;
})();

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 * val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((function (){var and__3755__auto__ = tcoll;
if(and__3755__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__3755__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4403__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3767__auto__ = (cljs.core._assoc_BANG_[(function (){var G__5683 = x__4403__auto__;
return goog.typeOf(G__5683);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 */
cljs.core.ITransientMap = (function (){var obj5685 = {};
return obj5685;
})();

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((function (){var and__3755__auto__ = tcoll;
if(and__3755__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__3755__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4403__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3767__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__5689 = x__4403__auto__;
return goog.typeOf(G__5689);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 */
cljs.core.ITransientVector = (function (){var obj5691 = {};
return obj5691;
})();

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3755__auto__ = tcoll;
if(and__3755__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__3755__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4403__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3767__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__5695 = x__4403__auto__;
return goog.typeOf(G__5695);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((function (){var and__3755__auto__ = tcoll;
if(and__3755__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__3755__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4403__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3767__auto__ = (cljs.core._pop_BANG_[(function (){var G__5699 = x__4403__auto__;
return goog.typeOf(G__5699);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 */
cljs.core.ITransientSet = (function (){var obj5701 = {};
return obj5701;
})();

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((function (){var and__3755__auto__ = tcoll;
if(and__3755__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__3755__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4403__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3767__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__5705 = x__4403__auto__;
return goog.typeOf(G__5705);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 */
cljs.core.IComparable = (function (){var obj5707 = {};
return obj5707;
})();

/**
 * Returns a negative number, zero, or a positive number when x is logically
 * 'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((function (){var and__3755__auto__ = x;
if(and__3755__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__3755__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4403__auto__ = (((x == null))?null:x);
return (function (){var or__3767__auto__ = (cljs.core._compare[(function (){var G__5711 = x__4403__auto__;
return goog.typeOf(G__5711);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._compare["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 */
cljs.core.IChunk = (function (){var obj5713 = {};
return obj5713;
})();

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._drop_first[(function (){var G__5717 = x__4403__auto__;
return goog.typeOf(G__5717);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._drop_first["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 */
cljs.core.IChunkedSeq = (function (){var obj5719 = {};
return obj5719;
})();

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._chunked_first[(function (){var G__5723 = x__4403__auto__;
return goog.typeOf(G__5723);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._chunked_rest[(function (){var G__5727 = x__4403__auto__;
return goog.typeOf(G__5727);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 */
cljs.core.IChunkedNext = (function (){var obj5729 = {};
return obj5729;
})();

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._chunked_next[(function (){var G__5733 = x__4403__auto__;
return goog.typeOf(G__5733);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding a name.
 */
cljs.core.INamed = (function (){var obj5735 = {};
return obj5735;
})();

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((function (){var and__3755__auto__ = x;
if(and__3755__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__3755__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4403__auto__ = (((x == null))?null:x);
return (function (){var or__3767__auto__ = (cljs.core._name[(function (){var G__5739 = x__4403__auto__;
return goog.typeOf(G__5739);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._name["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((function (){var and__3755__auto__ = x;
if(and__3755__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__3755__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4403__auto__ = (((x == null))?null:x);
return (function (){var or__3767__auto__ = (cljs.core._namespace[(function (){var G__5743 = x__4403__auto__;
return goog.typeOf(G__5743);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._namespace["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


/**
 * Marker protocol indicating an atom.
 */
cljs.core.IAtom = (function (){var obj5745 = {};
return obj5745;
})();


/**
 * Protocol for adding resetting functionality.
 */
cljs.core.IReset = (function (){var obj5747 = {};
return obj5747;
})();

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._reset_BANG_[(function (){var G__5751 = x__4403__auto__;
return goog.typeOf(G__5751);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 */
cljs.core.ISwap = (function (){var obj5753 = {};
return obj5753;
})();

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function() {
var cljs$core$_swap_BANG_ = null;
var cljs$core$_swap_BANG___2 = (function (o,f){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._swap_BANG_[(function (){var G__5763 = x__4403__auto__;
return goog.typeOf(G__5763);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});
var cljs$core$_swap_BANG___3 = (function (o,f,a){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._swap_BANG_[(function (){var G__5765 = x__4403__auto__;
return goog.typeOf(G__5765);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});
var cljs$core$_swap_BANG___4 = (function (o,f,a,b){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._swap_BANG_[(function (){var G__5767 = x__4403__auto__;
return goog.typeOf(G__5767);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});
var cljs$core$_swap_BANG___5 = (function (o,f,a,b,xs){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._swap_BANG_[(function (){var G__5769 = x__4403__auto__;
return goog.typeOf(G__5769);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});
cljs$core$_swap_BANG_ = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$_swap_BANG___2.call(this,o,f);
case 3:
return cljs$core$_swap_BANG___3.call(this,o,f,a);
case 4:
return cljs$core$_swap_BANG___4.call(this,o,f,a,b);
case 5:
return cljs$core$_swap_BANG___5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_swap_BANG___2;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$_swap_BANG___3;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = cljs$core$_swap_BANG___4;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = cljs$core$_swap_BANG___5;
return cljs$core$_swap_BANG_;
})()
;


/**
 * Protocol for adding volatile functionality.
 */
cljs.core.IVolatile = (function (){var obj5771 = {};
return obj5771;
})();

/**
 * Sets the value of volatile o to new-value without regard for the
 * current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((function (){var and__3755__auto__ = o;
if(and__3755__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__3755__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4403__auto__ = (((o == null))?null:o);
return (function (){var or__3767__auto__ = (cljs.core._vreset_BANG_[(function (){var G__5775 = x__4403__auto__;
return goog.typeOf(G__5775);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 */
cljs.core.IIterable = (function (){var obj5777 = {};
return obj5777;
})();

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((function (){var and__3755__auto__ = coll;
if(and__3755__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__3755__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4403__auto__ = (((coll == null))?null:coll);
return (function (){var or__3767__auto__ = (cljs.core._iterator[(function (){var G__5781 = x__4403__auto__;
return goog.typeOf(G__5781);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._iterator["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__5784 = (4294967295);
var G__5785 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__5784,G__5785) : Math.imul.call(null,G__5784,G__5785));
})() === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
var G__5788 = a;
var G__5789 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__5788,G__5789) : Math.imul.call(null,G__5788,G__5789));
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__5790 = (i + (2));
var G__5791 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__5790;
h1 = G__5791;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj5793 = {};
return obj5793;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__5794 = (i + (1));
var G__5795 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__5794;
hash = G__5795;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj5799 = {};
return obj5799;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((function (){var G__5802 = o;
if(G__5802){
var bit__4434__auto__ = (G__5802.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4434__auto__) || (G__5802.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__5803 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__5803) : Math.floor.call(null,G__5803));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 * c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(t,o){
return (o instanceof t);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3755__auto__ = cljs.core.not(a.ns);
if(and__3755__auto__){
return b.ns;
} else {
return and__3755__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__5810 = a.ns;
var G__5811 = b.ns;
return goog.array.defaultCompare(G__5810,G__5811);
})();
if(((0) === nsc)){
var G__5812 = a.name;
var G__5813 = b.name;
return goog.array.defaultCompare(G__5812,G__5813);
} else {
return nsc;
}
}
} else {
var G__5814 = a.name;
var G__5815 = b.name;
return goog.array.defaultCompare(G__5814,G__5815);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4183__auto__ = self__._hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.call = (function() {
var G__5817 = null;
var G__5817__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__5817__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__5817 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__5817__2.call(this,self__,coll);
case 3:
return G__5817__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5817.cljs$core$IFn$_invoke$arity$2 = G__5817__2;
G__5817.cljs$core$IFn$_invoke$arity$3 = G__5817__3;
return G__5817;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args5816){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5816)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function() {
var cljs$core$symbol = null;
var cljs$core$symbol__1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return cljs$core$symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});
var cljs$core$symbol__2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});
cljs$core$symbol = function(ns,name){
switch(arguments.length){
case 1:
return cljs$core$symbol__1.call(this,ns);
case 2:
return cljs$core$symbol__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$symbol.cljs$core$IFn$_invoke$arity$1 = cljs$core$symbol__1;
cljs$core$symbol.cljs$core$IFn$_invoke$arity$2 = cljs$core$symbol__2;
return cljs$core$symbol;
})()
;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 163841;
})
cljs.core.Var.prototype.call = (function() {
var G__5865 = null;
var G__5865__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__5865__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__5865__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__5865__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__5865__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__5865__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__5865__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__5865__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__5865__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__5865__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__5865__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__5865__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__5865__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__5865__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__5865__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__5865__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__5865__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__5865__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__5865__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__5865__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__5865__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__5865__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5821 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__5822 = a;
var G__5823 = b;
var G__5824 = c;
var G__5825 = d;
var G__5826 = e;
var G__5827 = f;
var G__5828 = g;
var G__5829 = h;
var G__5830 = i;
var G__5831 = j;
var G__5832 = k;
var G__5833 = l;
var G__5834 = m;
var G__5835 = n;
var G__5836 = o;
var G__5837 = p;
var G__5838 = q;
var G__5839 = r;
var G__5840 = s;
var G__5841 = t;
var G__5842 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__5821,G__5822,G__5823,G__5824,G__5825,G__5826,G__5827,G__5828,G__5829,G__5830,G__5831,G__5832,G__5833,G__5834,G__5835,G__5836,G__5837,G__5838,G__5839,G__5840,G__5841,G__5842) : cljs.core.apply.call(null,G__5821,G__5822,G__5823,G__5824,G__5825,G__5826,G__5827,G__5828,G__5829,G__5830,G__5831,G__5832,G__5833,G__5834,G__5835,G__5836,G__5837,G__5838,G__5839,G__5840,G__5841,G__5842));
});
G__5865 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__5865__1.call(this,self__);
case 2:
return G__5865__2.call(this,self__,a);
case 3:
return G__5865__3.call(this,self__,a,b);
case 4:
return G__5865__4.call(this,self__,a,b,c);
case 5:
return G__5865__5.call(this,self__,a,b,c,d);
case 6:
return G__5865__6.call(this,self__,a,b,c,d,e);
case 7:
return G__5865__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__5865__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__5865__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__5865__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__5865__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__5865__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__5865__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__5865__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__5865__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__5865__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__5865__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__5865__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__5865__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__5865__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__5865__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__5865__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5865.cljs$core$IFn$_invoke$arity$1 = G__5865__1;
G__5865.cljs$core$IFn$_invoke$arity$2 = G__5865__2;
G__5865.cljs$core$IFn$_invoke$arity$3 = G__5865__3;
G__5865.cljs$core$IFn$_invoke$arity$4 = G__5865__4;
G__5865.cljs$core$IFn$_invoke$arity$5 = G__5865__5;
G__5865.cljs$core$IFn$_invoke$arity$6 = G__5865__6;
G__5865.cljs$core$IFn$_invoke$arity$7 = G__5865__7;
G__5865.cljs$core$IFn$_invoke$arity$8 = G__5865__8;
G__5865.cljs$core$IFn$_invoke$arity$9 = G__5865__9;
G__5865.cljs$core$IFn$_invoke$arity$10 = G__5865__10;
G__5865.cljs$core$IFn$_invoke$arity$11 = G__5865__11;
G__5865.cljs$core$IFn$_invoke$arity$12 = G__5865__12;
G__5865.cljs$core$IFn$_invoke$arity$13 = G__5865__13;
G__5865.cljs$core$IFn$_invoke$arity$14 = G__5865__14;
G__5865.cljs$core$IFn$_invoke$arity$15 = G__5865__15;
G__5865.cljs$core$IFn$_invoke$arity$16 = G__5865__16;
G__5865.cljs$core$IFn$_invoke$arity$17 = G__5865__17;
G__5865.cljs$core$IFn$_invoke$arity$18 = G__5865__18;
G__5865.cljs$core$IFn$_invoke$arity$19 = G__5865__19;
G__5865.cljs$core$IFn$_invoke$arity$20 = G__5865__20;
G__5865.cljs$core$IFn$_invoke$arity$21 = G__5865__21;
G__5865.cljs$core$IFn$_invoke$arity$22 = G__5865__22;
return G__5865;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args5820){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5820)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__5843 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__5844 = a;
var G__5845 = b;
var G__5846 = c;
var G__5847 = d;
var G__5848 = e;
var G__5849 = f;
var G__5850 = g;
var G__5851 = h;
var G__5852 = i;
var G__5853 = j;
var G__5854 = k;
var G__5855 = l;
var G__5856 = m;
var G__5857 = n;
var G__5858 = o;
var G__5859 = p;
var G__5860 = q;
var G__5861 = r;
var G__5862 = s;
var G__5863 = t;
var G__5864 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__5843,G__5844,G__5845,G__5846,G__5847,G__5848,G__5849,G__5850,G__5851,G__5852,G__5853,G__5854,G__5855,G__5856,G__5857,G__5858,G__5859,G__5860,G__5861,G__5862,G__5863,G__5864) : cljs.core.apply.call(null,G__5843,G__5844,G__5845,G__5846,G__5847,G__5848,G__5849,G__5850,G__5851,G__5852,G__5853,G__5854,G__5855,G__5856,G__5857,G__5858,G__5859,G__5860,G__5861,G__5862,G__5863,G__5864));
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
var G__5867 = x;
if(G__5867){
var bit__4441__auto__ = null;
if(cljs.core.truth_((function (){var or__3767__auto__ = bit__4441__auto__;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return G__5867.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__5867.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__5867);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__5867);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
var G__5869 = value;
if(G__5869){
var bit__4441__auto__ = (G__5869.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4441__auto__) || (G__5869.cljs$core$ICloneable$)){
return true;
} else {
if((!G__5869.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__5869);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__5869);
}
});
/**
 * Returns a seq on the collection. If the collection is
 * empty, returns nil.  (seq nil) returns nil. seq also works on
 * Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5871 = coll;
if(G__5871){
var bit__4434__auto__ = (G__5871.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4434__auto__) || (G__5871.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 * argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5873 = coll;
if(G__5873){
var bit__4434__auto__ = (G__5873.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4434__auto__) || (G__5873.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 * argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if((function (){var G__5875 = coll;
if(G__5875){
var bit__4434__auto__ = (G__5875.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4434__auto__) || (G__5875.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 * argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5877 = coll;
if(G__5877){
var bit__4434__auto__ = (G__5877.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4434__auto__) || (G__5877.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 * numbers and collections in a type-independent manner.  Clojure's immutable data
 * structures define -equiv (and thus =) as a value, not an identity,
 * comparison.
 * @param {...*} var_args
 */
cljs.core._EQ_ = (function() {
var cljs$core$_EQ_ = null;
var cljs$core$_EQ___1 = (function (x){
return true;
});
var cljs$core$_EQ___2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});
var cljs$core$_EQ___3 = (function() { 
var G__5882__delegate = function (x,y,more){
while(true){
if(cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__5883 = y;
var G__5884 = cljs.core.first(more);
var G__5885 = cljs.core.next(more);
x = G__5883;
y = G__5884;
more = G__5885;
continue;
} else {
return cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__5882 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__5886__i = 0, G__5886__a = new Array(arguments.length -  2);
while (G__5886__i < G__5886__a.length) {G__5886__a[G__5886__i] = arguments[G__5886__i + 2]; ++G__5886__i;}
  more = new cljs.core.IndexedSeq(G__5886__a,0);
} 
return G__5882__delegate.call(this,x,y,more);};
G__5882.cljs$lang$maxFixedArity = 2;
G__5882.cljs$lang$applyTo = (function (arglist__5887){
var x = cljs.core.first(arglist__5887);
arglist__5887 = cljs.core.next(arglist__5887);
var y = cljs.core.first(arglist__5887);
var more = cljs.core.rest(arglist__5887);
return G__5882__delegate(x,y,more);
});
G__5882.cljs$core$IFn$_invoke$arity$variadic = G__5882__delegate;
return G__5882;
})()
;
cljs$core$_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_EQ___1.call(this,x);
case 2:
return cljs$core$_EQ___2.call(this,x,y);
default:
var G__5888 = null;
if (arguments.length > 2) {
var G__5889__i = 0, G__5889__a = new Array(arguments.length -  2);
while (G__5889__i < G__5889__a.length) {G__5889__a[G__5889__i] = arguments[G__5889__i + 2]; ++G__5889__i;}
G__5888 = new cljs.core.IndexedSeq(G__5889__a,0);
}
return cljs$core$_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__5888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_EQ_.cljs$lang$applyTo = cljs$core$_EQ___3.cljs$lang$applyTo;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_EQ___1;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_EQ___2;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_EQ_;
})()
;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": x};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__5890 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__5890) : cljs.core.es6_iterator_seq.call(null,G__5890));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__5891 = (n + (1));
var G__5892 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__5893 = cljs.core.next(coll__$1);
n = G__5891;
hash_code = G__5892;
coll__$1 = G__5893;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 * (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__5894 = (n + (1));
var G__5895 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__5896 = cljs.core.next(coll__$1);
n = G__5894;
hash_code = G__5895;
coll__$1 = G__5896;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
var G__5897 = this$__$1.valueOf();
var G__5898 = other.valueOf();
return goog.array.defaultCompare(G__5897,G__5898);
});

Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));

(cljs.core.Fn["function"] = true);
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__5899 = o;
return goog.getUid(G__5899);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__5901 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__5901) : cljs.core.deref.call(null,G__5901));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function() {
var cljs$core$ci_reduce = null;
var cljs$core$ci_reduce__2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__5908 = val;
var G__5909 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5908,G__5909) : f.call(null,G__5908,G__5909));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5914 = nval;
var G__5915 = (n + (1));
val = G__5914;
n = G__5915;
continue;
}
} else {
return val;
}
break;
}
}
});
var cljs$core$ci_reduce__3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__5910 = val__$1;
var G__5911 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5910,G__5911) : f.call(null,G__5910,G__5911));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5916 = nval;
var G__5917 = (n + (1));
val__$1 = G__5916;
n = G__5917;
continue;
}
} else {
return val__$1;
}
break;
}
});
var cljs$core$ci_reduce__4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__5912 = val__$1;
var G__5913 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5912,G__5913) : f.call(null,G__5912,G__5913));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5918 = nval;
var G__5919 = (n + (1));
val__$1 = G__5918;
n = G__5919;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$ci_reduce = function(cicoll,f,val,idx){
switch(arguments.length){
case 2:
return cljs$core$ci_reduce__2.call(this,cicoll,f);
case 3:
return cljs$core$ci_reduce__3.call(this,cicoll,f,val);
case 4:
return cljs$core$ci_reduce__4.call(this,cicoll,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$ci_reduce__2;
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$ci_reduce__3;
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$ci_reduce__4;
return cljs$core$ci_reduce;
})()
;
cljs.core.array_reduce = (function() {
var cljs$core$array_reduce = null;
var cljs$core$array_reduce__2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__5926 = val;
var G__5927 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5926,G__5927) : f.call(null,G__5926,G__5927));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5932 = nval;
var G__5933 = (n + (1));
val = G__5932;
n = G__5933;
continue;
}
} else {
return val;
}
break;
}
}
});
var cljs$core$array_reduce__3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__5928 = val__$1;
var G__5929 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5928,G__5929) : f.call(null,G__5928,G__5929));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5934 = nval;
var G__5935 = (n + (1));
val__$1 = G__5934;
n = G__5935;
continue;
}
} else {
return val__$1;
}
break;
}
});
var cljs$core$array_reduce__4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__5930 = val__$1;
var G__5931 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5930,G__5931) : f.call(null,G__5930,G__5931));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5936 = nval;
var G__5937 = (n + (1));
val__$1 = G__5936;
n = G__5937;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$array_reduce = function(arr,f,val,idx){
switch(arguments.length){
case 2:
return cljs$core$array_reduce__2.call(this,arr,f);
case 3:
return cljs$core$array_reduce__3.call(this,arr,f,val);
case 4:
return cljs$core$array_reduce__4.call(this,arr,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_reduce__2;
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$array_reduce__3;
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$array_reduce__4;
return cljs$core$array_reduce;
})()
;



/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
var G__5939 = x;
if(G__5939){
var bit__4441__auto__ = (G__5939.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4441__auto__) || (G__5939.cljs$core$ICounted$)){
return true;
} else {
if((!G__5939.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__5939);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__5939);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
var G__5941 = x;
if(G__5941){
var bit__4441__auto__ = (G__5941.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4441__auto__) || (G__5941.cljs$core$IIndexed$)){
return true;
} else {
if((!G__5941.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__5941);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__5941);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__5942 = coll__$1;
var G__5943 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__5942,G__5943) : cljs.core.equiv_sequential.call(null,G__5942,G__5943));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__5944 = o;
var G__5945 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__5944,G__5945) : cljs.core.cons.call(null,G__5944,G__5945));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function() {
var cljs$core$prim_seq = null;
var cljs$core$prim_seq__1 = (function (prim){
return cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});
var cljs$core$prim_seq__2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});
cljs$core$prim_seq = function(prim,i){
switch(arguments.length){
case 1:
return cljs$core$prim_seq__1.call(this,prim);
case 2:
return cljs$core$prim_seq__2.call(this,prim,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$prim_seq__1;
cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$2 = cljs$core$prim_seq__2;
return cljs$core$prim_seq;
})()
;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function() {
var cljs$core$array_seq = null;
var cljs$core$array_seq__1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});
var cljs$core$array_seq__2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});
cljs$core$array_seq = function(array,i){
switch(arguments.length){
case 1:
return cljs$core$array_seq__1.call(this,array);
case 2:
return cljs$core$array_seq__2.call(this,array,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$array_seq__1;
cljs$core$array_seq.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_seq__2;
return cljs$core$array_seq;
})()
;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__5948 = coll__$1;
var G__5949 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__5948,G__5949) : cljs.core.equiv_sequential.call(null,G__5948,G__5949));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__5950 = cljs.core.List.EMPTY;
var G__5951 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__5950,G__5951) : cljs.core.with_meta.call(null,G__5950,G__5951));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__5952 = f;
var G__5953 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__5952,G__5953) : cljs.core.seq_reduce.call(null,G__5952,G__5953));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__5954 = f;
var G__5955 = start;
var G__5956 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__5954,G__5955,G__5956) : cljs.core.seq_reduce.call(null,G__5954,G__5955,G__5956));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__5957 = o;
var G__5958 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__5957,G__5958) : cljs.core.cons.call(null,G__5957,G__5958));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__5959 = sn;
s = G__5959;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 * 'added'. (conj nil item) returns (item).  The 'addition' may
 * happen at different 'places' depending on the concrete type.
 * @param {...*} var_args
 */
cljs.core.conj = (function() {
var cljs$core$conj = null;
var cljs$core$conj__0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});
var cljs$core$conj__1 = (function (coll){
return coll;
});
var cljs$core$conj__2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});
var cljs$core$conj__3 = (function() { 
var G__5964__delegate = function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__5965 = cljs$core$conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__5966 = cljs.core.first(xs);
var G__5967 = cljs.core.next(xs);
coll = G__5965;
x = G__5966;
xs = G__5967;
continue;
} else {
return cljs$core$conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
};
var G__5964 = function (coll,x,var_args){
var xs = null;
if (arguments.length > 2) {
var G__5968__i = 0, G__5968__a = new Array(arguments.length -  2);
while (G__5968__i < G__5968__a.length) {G__5968__a[G__5968__i] = arguments[G__5968__i + 2]; ++G__5968__i;}
  xs = new cljs.core.IndexedSeq(G__5968__a,0);
} 
return G__5964__delegate.call(this,coll,x,xs);};
G__5964.cljs$lang$maxFixedArity = 2;
G__5964.cljs$lang$applyTo = (function (arglist__5969){
var coll = cljs.core.first(arglist__5969);
arglist__5969 = cljs.core.next(arglist__5969);
var x = cljs.core.first(arglist__5969);
var xs = cljs.core.rest(arglist__5969);
return G__5964__delegate(coll,x,xs);
});
G__5964.cljs$core$IFn$_invoke$arity$variadic = G__5964__delegate;
return G__5964;
})()
;
cljs$core$conj = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 0:
return cljs$core$conj__0.call(this);
case 1:
return cljs$core$conj__1.call(this,coll);
case 2:
return cljs$core$conj__2.call(this,coll,x);
default:
var G__5970 = null;
if (arguments.length > 2) {
var G__5971__i = 0, G__5971__a = new Array(arguments.length -  2);
while (G__5971__i < G__5971__a.length) {G__5971__a[G__5971__i] = arguments[G__5971__i + 2]; ++G__5971__i;}
G__5970 = new cljs.core.IndexedSeq(G__5971__a,0);
}
return cljs$core$conj__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, G__5970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$conj.cljs$lang$maxFixedArity = 2;
cljs$core$conj.cljs$lang$applyTo = cljs$core$conj__3.cljs$lang$applyTo;
cljs$core$conj.cljs$core$IFn$_invoke$arity$0 = cljs$core$conj__0;
cljs$core$conj.cljs$core$IFn$_invoke$arity$1 = cljs$core$conj__1;
cljs$core$conj.cljs$core$IFn$_invoke$arity$2 = cljs$core$conj__2;
cljs$core$conj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$conj__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$conj;
})()
;
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__5972 = cljs.core.next(s);
var G__5973 = (acc + (1));
s = G__5972;
acc = G__5973;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 * 0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if((function (){var G__5975 = coll;
if(G__5975){
var bit__4434__auto__ = (G__5975.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4434__auto__) || (G__5975.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function() {
var cljs$core$linear_traversal_nth = null;
var cljs$core$linear_traversal_nth__2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__5976 = cljs.core.next(coll);
var G__5977 = (n - (1));
coll = G__5976;
n = G__5977;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});
var cljs$core$linear_traversal_nth__3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__5978 = cljs.core.next(coll);
var G__5979 = (n - (1));
var G__5980 = not_found;
coll = G__5978;
n = G__5979;
not_found = G__5980;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});
cljs$core$linear_traversal_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$linear_traversal_nth__2.call(this,coll,n);
case 3:
return cljs$core$linear_traversal_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$linear_traversal_nth__2;
cljs$core$linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$linear_traversal_nth__3;
return cljs$core$linear_traversal_nth;
})()
;
/**
 * Returns the value at the index. get returns nil if index out of
 * bounds, nth throws an exception unless not-found is supplied.  nth
 * also works for strings, arrays, regex Matchers and Lists, and,
 * in O(n) time, for sequences.
 */
cljs.core.nth = (function() {
var cljs$core$nth = null;
var cljs$core$nth__2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__5985 = coll;
if(G__5985){
var bit__4434__auto__ = (G__5985.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4434__auto__) || (G__5985.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__5986 = coll;
if(G__5986){
var bit__4441__auto__ = (G__5986.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4441__auto__) || (G__5986.cljs$core$ISeq$)){
return true;
} else {
if((!G__5986.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5986);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5986);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
var cljs$core$nth__3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__5987 = coll;
if(G__5987){
var bit__4434__auto__ = (G__5987.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4434__auto__) || (G__5987.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__5988 = coll;
if(G__5988){
var bit__4441__auto__ = (G__5988.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4441__auto__) || (G__5988.cljs$core$ISeq$)){
return true;
} else {
if((!G__5988.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5988);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5988);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
cljs$core$nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$nth__2.call(this,coll,n);
case 3:
return cljs$core$nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$nth__2;
cljs$core$nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$nth__3;
return cljs$core$nth;
})()
;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__5989 = (n__$1 - (1));
var G__5990 = cljs.core.rest(xs);
n__$1 = G__5989;
xs = G__5990;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function() {
var cljs$core$get = null;
var cljs$core$get__2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__5993 = o;
if(G__5993){
var bit__4434__auto__ = (G__5993.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4434__auto__) || (G__5993.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});
var cljs$core$get__3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__5994 = o;
if(G__5994){
var bit__4434__auto__ = (G__5994.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4434__auto__) || (G__5994.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});
cljs$core$get = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$get__2.call(this,o,k);
case 3:
return cljs$core$get__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$get.cljs$core$IFn$_invoke$arity$2 = cljs$core$get__2;
cljs$core$get.cljs$core$IFn$_invoke$arity$3 = cljs$core$get__3;
return cljs$core$get;
})()
;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 * @param {...*} var_args
 */
cljs.core.assoc = (function() {
var cljs$core$assoc = null;
var cljs$core$assoc__3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});
var cljs$core$assoc__4 = (function() { 
var G__5998__delegate = function (coll,k,v,kvs){
while(true){
var ret = cljs$core$assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__5999 = ret;
var G__6000 = cljs.core.first(kvs);
var G__6001 = cljs.core.second(kvs);
var G__6002 = cljs.core.nnext(kvs);
coll = G__5999;
k = G__6000;
v = G__6001;
kvs = G__6002;
continue;
} else {
return ret;
}
break;
}
};
var G__5998 = function (coll,k,v,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__6003__i = 0, G__6003__a = new Array(arguments.length -  3);
while (G__6003__i < G__6003__a.length) {G__6003__a[G__6003__i] = arguments[G__6003__i + 3]; ++G__6003__i;}
  kvs = new cljs.core.IndexedSeq(G__6003__a,0);
} 
return G__5998__delegate.call(this,coll,k,v,kvs);};
G__5998.cljs$lang$maxFixedArity = 3;
G__5998.cljs$lang$applyTo = (function (arglist__6004){
var coll = cljs.core.first(arglist__6004);
arglist__6004 = cljs.core.next(arglist__6004);
var k = cljs.core.first(arglist__6004);
arglist__6004 = cljs.core.next(arglist__6004);
var v = cljs.core.first(arglist__6004);
var kvs = cljs.core.rest(arglist__6004);
return G__5998__delegate(coll,k,v,kvs);
});
G__5998.cljs$core$IFn$_invoke$arity$variadic = G__5998__delegate;
return G__5998;
})()
;
cljs$core$assoc = function(coll,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return cljs$core$assoc__3.call(this,coll,k,v);
default:
var G__6005 = null;
if (arguments.length > 3) {
var G__6006__i = 0, G__6006__a = new Array(arguments.length -  3);
while (G__6006__i < G__6006__a.length) {G__6006__a[G__6006__i] = arguments[G__6006__i + 3]; ++G__6006__i;}
G__6005 = new cljs.core.IndexedSeq(G__6006__a,0);
}
return cljs$core$assoc__4.cljs$core$IFn$_invoke$arity$variadic(coll,k,v, G__6005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$assoc.cljs$lang$maxFixedArity = 3;
cljs$core$assoc.cljs$lang$applyTo = cljs$core$assoc__4.cljs$lang$applyTo;
cljs$core$assoc.cljs$core$IFn$_invoke$arity$3 = cljs$core$assoc__3;
cljs$core$assoc.cljs$core$IFn$_invoke$arity$variadic = cljs$core$assoc__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$assoc;
})()
;
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 * that does not contain a mapping for key(s).
 * @param {...*} var_args
 */
cljs.core.dissoc = (function() {
var cljs$core$dissoc = null;
var cljs$core$dissoc__1 = (function (coll){
return coll;
});
var cljs$core$dissoc__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});
var cljs$core$dissoc__3 = (function() { 
var G__6009__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs$core$dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__6010 = ret;
var G__6011 = cljs.core.first(ks);
var G__6012 = cljs.core.next(ks);
coll = G__6010;
k = G__6011;
ks = G__6012;
continue;
} else {
return ret;
}
}
break;
}
};
var G__6009 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__6013__i = 0, G__6013__a = new Array(arguments.length -  2);
while (G__6013__i < G__6013__a.length) {G__6013__a[G__6013__i] = arguments[G__6013__i + 2]; ++G__6013__i;}
  ks = new cljs.core.IndexedSeq(G__6013__a,0);
} 
return G__6009__delegate.call(this,coll,k,ks);};
G__6009.cljs$lang$maxFixedArity = 2;
G__6009.cljs$lang$applyTo = (function (arglist__6014){
var coll = cljs.core.first(arglist__6014);
arglist__6014 = cljs.core.next(arglist__6014);
var k = cljs.core.first(arglist__6014);
var ks = cljs.core.rest(arglist__6014);
return G__6009__delegate(coll,k,ks);
});
G__6009.cljs$core$IFn$_invoke$arity$variadic = G__6009__delegate;
return G__6009;
})()
;
cljs$core$dissoc = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return cljs$core$dissoc__1.call(this,coll);
case 2:
return cljs$core$dissoc__2.call(this,coll,k);
default:
var G__6015 = null;
if (arguments.length > 2) {
var G__6016__i = 0, G__6016__a = new Array(arguments.length -  2);
while (G__6016__i < G__6016__a.length) {G__6016__a[G__6016__i] = arguments[G__6016__i + 2]; ++G__6016__i;}
G__6015 = new cljs.core.IndexedSeq(G__6016__a,0);
}
return cljs$core$dissoc__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__6015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dissoc.cljs$lang$maxFixedArity = 2;
cljs$core$dissoc.cljs$lang$applyTo = cljs$core$dissoc__3.cljs$lang$applyTo;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$1 = cljs$core$dissoc__1;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$2 = cljs$core$dissoc__2;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$variadic = cljs$core$dissoc__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$dissoc;
})()
;
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__3767__auto__ = (function (){var G__6021 = f;
return goog.isFunction(G__6021);
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var G__6022 = f;
if(G__6022){
var bit__4441__auto__ = null;
if(cljs.core.truth_((function (){var or__3767__auto____$1 = bit__4441__auto__;
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
return G__6022.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__6022.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__6022);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__6022);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393217;
})
cljs.core.MetaFn.prototype.call = (function() {
var G__6488 = null;
var G__6488__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__6488__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6024 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6024) : self__.afn.call(null,G__6024));
});
var G__6488__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6025 = a;
var G__6026 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6025,G__6026) : self__.afn.call(null,G__6025,G__6026));
});
var G__6488__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6027 = a;
var G__6028 = b;
var G__6029 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6027,G__6028,G__6029) : self__.afn.call(null,G__6027,G__6028,G__6029));
});
var G__6488__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6030 = a;
var G__6031 = b;
var G__6032 = c;
var G__6033 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6030,G__6031,G__6032,G__6033) : self__.afn.call(null,G__6030,G__6031,G__6032,G__6033));
});
var G__6488__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6034 = a;
var G__6035 = b;
var G__6036 = c;
var G__6037 = d;
var G__6038 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6034,G__6035,G__6036,G__6037,G__6038) : self__.afn.call(null,G__6034,G__6035,G__6036,G__6037,G__6038));
});
var G__6488__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6039 = a;
var G__6040 = b;
var G__6041 = c;
var G__6042 = d;
var G__6043 = e;
var G__6044 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6039,G__6040,G__6041,G__6042,G__6043,G__6044) : self__.afn.call(null,G__6039,G__6040,G__6041,G__6042,G__6043,G__6044));
});
var G__6488__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6045 = a;
var G__6046 = b;
var G__6047 = c;
var G__6048 = d;
var G__6049 = e;
var G__6050 = f;
var G__6051 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6045,G__6046,G__6047,G__6048,G__6049,G__6050,G__6051) : self__.afn.call(null,G__6045,G__6046,G__6047,G__6048,G__6049,G__6050,G__6051));
});
var G__6488__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6052 = a;
var G__6053 = b;
var G__6054 = c;
var G__6055 = d;
var G__6056 = e;
var G__6057 = f;
var G__6058 = g;
var G__6059 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6052,G__6053,G__6054,G__6055,G__6056,G__6057,G__6058,G__6059) : self__.afn.call(null,G__6052,G__6053,G__6054,G__6055,G__6056,G__6057,G__6058,G__6059));
});
var G__6488__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6060 = a;
var G__6061 = b;
var G__6062 = c;
var G__6063 = d;
var G__6064 = e;
var G__6065 = f;
var G__6066 = g;
var G__6067 = h;
var G__6068 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6060,G__6061,G__6062,G__6063,G__6064,G__6065,G__6066,G__6067,G__6068) : self__.afn.call(null,G__6060,G__6061,G__6062,G__6063,G__6064,G__6065,G__6066,G__6067,G__6068));
});
var G__6488__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6069 = a;
var G__6070 = b;
var G__6071 = c;
var G__6072 = d;
var G__6073 = e;
var G__6074 = f;
var G__6075 = g;
var G__6076 = h;
var G__6077 = i;
var G__6078 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6069,G__6070,G__6071,G__6072,G__6073,G__6074,G__6075,G__6076,G__6077,G__6078) : self__.afn.call(null,G__6069,G__6070,G__6071,G__6072,G__6073,G__6074,G__6075,G__6076,G__6077,G__6078));
});
var G__6488__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6079 = a;
var G__6080 = b;
var G__6081 = c;
var G__6082 = d;
var G__6083 = e;
var G__6084 = f;
var G__6085 = g;
var G__6086 = h;
var G__6087 = i;
var G__6088 = j;
var G__6089 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6079,G__6080,G__6081,G__6082,G__6083,G__6084,G__6085,G__6086,G__6087,G__6088,G__6089) : self__.afn.call(null,G__6079,G__6080,G__6081,G__6082,G__6083,G__6084,G__6085,G__6086,G__6087,G__6088,G__6089));
});
var G__6488__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6090 = a;
var G__6091 = b;
var G__6092 = c;
var G__6093 = d;
var G__6094 = e;
var G__6095 = f;
var G__6096 = g;
var G__6097 = h;
var G__6098 = i;
var G__6099 = j;
var G__6100 = k;
var G__6101 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6090,G__6091,G__6092,G__6093,G__6094,G__6095,G__6096,G__6097,G__6098,G__6099,G__6100,G__6101) : self__.afn.call(null,G__6090,G__6091,G__6092,G__6093,G__6094,G__6095,G__6096,G__6097,G__6098,G__6099,G__6100,G__6101));
});
var G__6488__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6102 = a;
var G__6103 = b;
var G__6104 = c;
var G__6105 = d;
var G__6106 = e;
var G__6107 = f;
var G__6108 = g;
var G__6109 = h;
var G__6110 = i;
var G__6111 = j;
var G__6112 = k;
var G__6113 = l;
var G__6114 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6102,G__6103,G__6104,G__6105,G__6106,G__6107,G__6108,G__6109,G__6110,G__6111,G__6112,G__6113,G__6114) : self__.afn.call(null,G__6102,G__6103,G__6104,G__6105,G__6106,G__6107,G__6108,G__6109,G__6110,G__6111,G__6112,G__6113,G__6114));
});
var G__6488__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6115 = a;
var G__6116 = b;
var G__6117 = c;
var G__6118 = d;
var G__6119 = e;
var G__6120 = f;
var G__6121 = g;
var G__6122 = h;
var G__6123 = i;
var G__6124 = j;
var G__6125 = k;
var G__6126 = l;
var G__6127 = m;
var G__6128 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6115,G__6116,G__6117,G__6118,G__6119,G__6120,G__6121,G__6122,G__6123,G__6124,G__6125,G__6126,G__6127,G__6128) : self__.afn.call(null,G__6115,G__6116,G__6117,G__6118,G__6119,G__6120,G__6121,G__6122,G__6123,G__6124,G__6125,G__6126,G__6127,G__6128));
});
var G__6488__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6129 = a;
var G__6130 = b;
var G__6131 = c;
var G__6132 = d;
var G__6133 = e;
var G__6134 = f;
var G__6135 = g;
var G__6136 = h;
var G__6137 = i;
var G__6138 = j;
var G__6139 = k;
var G__6140 = l;
var G__6141 = m;
var G__6142 = n;
var G__6143 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6129,G__6130,G__6131,G__6132,G__6133,G__6134,G__6135,G__6136,G__6137,G__6138,G__6139,G__6140,G__6141,G__6142,G__6143) : self__.afn.call(null,G__6129,G__6130,G__6131,G__6132,G__6133,G__6134,G__6135,G__6136,G__6137,G__6138,G__6139,G__6140,G__6141,G__6142,G__6143));
});
var G__6488__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6144 = a;
var G__6145 = b;
var G__6146 = c;
var G__6147 = d;
var G__6148 = e;
var G__6149 = f;
var G__6150 = g;
var G__6151 = h;
var G__6152 = i;
var G__6153 = j;
var G__6154 = k;
var G__6155 = l;
var G__6156 = m;
var G__6157 = n;
var G__6158 = o;
var G__6159 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6144,G__6145,G__6146,G__6147,G__6148,G__6149,G__6150,G__6151,G__6152,G__6153,G__6154,G__6155,G__6156,G__6157,G__6158,G__6159) : self__.afn.call(null,G__6144,G__6145,G__6146,G__6147,G__6148,G__6149,G__6150,G__6151,G__6152,G__6153,G__6154,G__6155,G__6156,G__6157,G__6158,G__6159));
});
var G__6488__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6160 = a;
var G__6161 = b;
var G__6162 = c;
var G__6163 = d;
var G__6164 = e;
var G__6165 = f;
var G__6166 = g;
var G__6167 = h;
var G__6168 = i;
var G__6169 = j;
var G__6170 = k;
var G__6171 = l;
var G__6172 = m;
var G__6173 = n;
var G__6174 = o;
var G__6175 = p;
var G__6176 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6160,G__6161,G__6162,G__6163,G__6164,G__6165,G__6166,G__6167,G__6168,G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176) : self__.afn.call(null,G__6160,G__6161,G__6162,G__6163,G__6164,G__6165,G__6166,G__6167,G__6168,G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176));
});
var G__6488__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6177 = a;
var G__6178 = b;
var G__6179 = c;
var G__6180 = d;
var G__6181 = e;
var G__6182 = f;
var G__6183 = g;
var G__6184 = h;
var G__6185 = i;
var G__6186 = j;
var G__6187 = k;
var G__6188 = l;
var G__6189 = m;
var G__6190 = n;
var G__6191 = o;
var G__6192 = p;
var G__6193 = q;
var G__6194 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6177,G__6178,G__6179,G__6180,G__6181,G__6182,G__6183,G__6184,G__6185,G__6186,G__6187,G__6188,G__6189,G__6190,G__6191,G__6192,G__6193,G__6194) : self__.afn.call(null,G__6177,G__6178,G__6179,G__6180,G__6181,G__6182,G__6183,G__6184,G__6185,G__6186,G__6187,G__6188,G__6189,G__6190,G__6191,G__6192,G__6193,G__6194));
});
var G__6488__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6195 = a;
var G__6196 = b;
var G__6197 = c;
var G__6198 = d;
var G__6199 = e;
var G__6200 = f;
var G__6201 = g;
var G__6202 = h;
var G__6203 = i;
var G__6204 = j;
var G__6205 = k;
var G__6206 = l;
var G__6207 = m;
var G__6208 = n;
var G__6209 = o;
var G__6210 = p;
var G__6211 = q;
var G__6212 = r;
var G__6213 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6195,G__6196,G__6197,G__6198,G__6199,G__6200,G__6201,G__6202,G__6203,G__6204,G__6205,G__6206,G__6207,G__6208,G__6209,G__6210,G__6211,G__6212,G__6213) : self__.afn.call(null,G__6195,G__6196,G__6197,G__6198,G__6199,G__6200,G__6201,G__6202,G__6203,G__6204,G__6205,G__6206,G__6207,G__6208,G__6209,G__6210,G__6211,G__6212,G__6213));
});
var G__6488__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6214 = a;
var G__6215 = b;
var G__6216 = c;
var G__6217 = d;
var G__6218 = e;
var G__6219 = f;
var G__6220 = g;
var G__6221 = h;
var G__6222 = i;
var G__6223 = j;
var G__6224 = k;
var G__6225 = l;
var G__6226 = m;
var G__6227 = n;
var G__6228 = o;
var G__6229 = p;
var G__6230 = q;
var G__6231 = r;
var G__6232 = s;
var G__6233 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6214,G__6215,G__6216,G__6217,G__6218,G__6219,G__6220,G__6221,G__6222,G__6223,G__6224,G__6225,G__6226,G__6227,G__6228,G__6229,G__6230,G__6231,G__6232,G__6233) : self__.afn.call(null,G__6214,G__6215,G__6216,G__6217,G__6218,G__6219,G__6220,G__6221,G__6222,G__6223,G__6224,G__6225,G__6226,G__6227,G__6228,G__6229,G__6230,G__6231,G__6232,G__6233));
});
var G__6488__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6234 = self__.afn;
var G__6235 = a;
var G__6236 = b;
var G__6237 = c;
var G__6238 = d;
var G__6239 = e;
var G__6240 = f;
var G__6241 = g;
var G__6242 = h;
var G__6243 = i;
var G__6244 = j;
var G__6245 = k;
var G__6246 = l;
var G__6247 = m;
var G__6248 = n;
var G__6249 = o;
var G__6250 = p;
var G__6251 = q;
var G__6252 = r;
var G__6253 = s;
var G__6254 = t;
var G__6255 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6234,G__6235,G__6236,G__6237,G__6238,G__6239,G__6240,G__6241,G__6242,G__6243,G__6244,G__6245,G__6246,G__6247,G__6248,G__6249,G__6250,G__6251,G__6252,G__6253,G__6254,G__6255) : cljs.core.apply.call(null,G__6234,G__6235,G__6236,G__6237,G__6238,G__6239,G__6240,G__6241,G__6242,G__6243,G__6244,G__6245,G__6246,G__6247,G__6248,G__6249,G__6250,G__6251,G__6252,G__6253,G__6254,G__6255));
});
G__6488 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__6488__1.call(this,self__);
case 2:
return G__6488__2.call(this,self__,a);
case 3:
return G__6488__3.call(this,self__,a,b);
case 4:
return G__6488__4.call(this,self__,a,b,c);
case 5:
return G__6488__5.call(this,self__,a,b,c,d);
case 6:
return G__6488__6.call(this,self__,a,b,c,d,e);
case 7:
return G__6488__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__6488__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__6488__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__6488__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__6488__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__6488__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__6488__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__6488__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__6488__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__6488__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__6488__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__6488__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__6488__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__6488__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__6488__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__6488__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6488.cljs$core$IFn$_invoke$arity$1 = G__6488__1;
G__6488.cljs$core$IFn$_invoke$arity$2 = G__6488__2;
G__6488.cljs$core$IFn$_invoke$arity$3 = G__6488__3;
G__6488.cljs$core$IFn$_invoke$arity$4 = G__6488__4;
G__6488.cljs$core$IFn$_invoke$arity$5 = G__6488__5;
G__6488.cljs$core$IFn$_invoke$arity$6 = G__6488__6;
G__6488.cljs$core$IFn$_invoke$arity$7 = G__6488__7;
G__6488.cljs$core$IFn$_invoke$arity$8 = G__6488__8;
G__6488.cljs$core$IFn$_invoke$arity$9 = G__6488__9;
G__6488.cljs$core$IFn$_invoke$arity$10 = G__6488__10;
G__6488.cljs$core$IFn$_invoke$arity$11 = G__6488__11;
G__6488.cljs$core$IFn$_invoke$arity$12 = G__6488__12;
G__6488.cljs$core$IFn$_invoke$arity$13 = G__6488__13;
G__6488.cljs$core$IFn$_invoke$arity$14 = G__6488__14;
G__6488.cljs$core$IFn$_invoke$arity$15 = G__6488__15;
G__6488.cljs$core$IFn$_invoke$arity$16 = G__6488__16;
G__6488.cljs$core$IFn$_invoke$arity$17 = G__6488__17;
G__6488.cljs$core$IFn$_invoke$arity$18 = G__6488__18;
G__6488.cljs$core$IFn$_invoke$arity$19 = G__6488__19;
G__6488.cljs$core$IFn$_invoke$arity$20 = G__6488__20;
G__6488.cljs$core$IFn$_invoke$arity$21 = G__6488__21;
G__6488.cljs$core$IFn$_invoke$arity$22 = G__6488__22;
return G__6488;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args6023){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6023)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__6256 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6256) : self__.afn.call(null,G__6256));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__6257 = a;
var G__6258 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6257,G__6258) : self__.afn.call(null,G__6257,G__6258));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__6259 = a;
var G__6260 = b;
var G__6261 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6259,G__6260,G__6261) : self__.afn.call(null,G__6259,G__6260,G__6261));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__6262 = a;
var G__6263 = b;
var G__6264 = c;
var G__6265 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6262,G__6263,G__6264,G__6265) : self__.afn.call(null,G__6262,G__6263,G__6264,G__6265));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__6266 = a;
var G__6267 = b;
var G__6268 = c;
var G__6269 = d;
var G__6270 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6266,G__6267,G__6268,G__6269,G__6270) : self__.afn.call(null,G__6266,G__6267,G__6268,G__6269,G__6270));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__6271 = a;
var G__6272 = b;
var G__6273 = c;
var G__6274 = d;
var G__6275 = e;
var G__6276 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6271,G__6272,G__6273,G__6274,G__6275,G__6276) : self__.afn.call(null,G__6271,G__6272,G__6273,G__6274,G__6275,G__6276));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__6277 = a;
var G__6278 = b;
var G__6279 = c;
var G__6280 = d;
var G__6281 = e;
var G__6282 = f;
var G__6283 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6277,G__6278,G__6279,G__6280,G__6281,G__6282,G__6283) : self__.afn.call(null,G__6277,G__6278,G__6279,G__6280,G__6281,G__6282,G__6283));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__6284 = a;
var G__6285 = b;
var G__6286 = c;
var G__6287 = d;
var G__6288 = e;
var G__6289 = f;
var G__6290 = g;
var G__6291 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6284,G__6285,G__6286,G__6287,G__6288,G__6289,G__6290,G__6291) : self__.afn.call(null,G__6284,G__6285,G__6286,G__6287,G__6288,G__6289,G__6290,G__6291));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__6292 = a;
var G__6293 = b;
var G__6294 = c;
var G__6295 = d;
var G__6296 = e;
var G__6297 = f;
var G__6298 = g;
var G__6299 = h;
var G__6300 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6292,G__6293,G__6294,G__6295,G__6296,G__6297,G__6298,G__6299,G__6300) : self__.afn.call(null,G__6292,G__6293,G__6294,G__6295,G__6296,G__6297,G__6298,G__6299,G__6300));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__6301 = a;
var G__6302 = b;
var G__6303 = c;
var G__6304 = d;
var G__6305 = e;
var G__6306 = f;
var G__6307 = g;
var G__6308 = h;
var G__6309 = i;
var G__6310 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6301,G__6302,G__6303,G__6304,G__6305,G__6306,G__6307,G__6308,G__6309,G__6310) : self__.afn.call(null,G__6301,G__6302,G__6303,G__6304,G__6305,G__6306,G__6307,G__6308,G__6309,G__6310));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__6311 = a;
var G__6312 = b;
var G__6313 = c;
var G__6314 = d;
var G__6315 = e;
var G__6316 = f;
var G__6317 = g;
var G__6318 = h;
var G__6319 = i;
var G__6320 = j;
var G__6321 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6311,G__6312,G__6313,G__6314,G__6315,G__6316,G__6317,G__6318,G__6319,G__6320,G__6321) : self__.afn.call(null,G__6311,G__6312,G__6313,G__6314,G__6315,G__6316,G__6317,G__6318,G__6319,G__6320,G__6321));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__6322 = a;
var G__6323 = b;
var G__6324 = c;
var G__6325 = d;
var G__6326 = e;
var G__6327 = f;
var G__6328 = g;
var G__6329 = h;
var G__6330 = i;
var G__6331 = j;
var G__6332 = k;
var G__6333 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6322,G__6323,G__6324,G__6325,G__6326,G__6327,G__6328,G__6329,G__6330,G__6331,G__6332,G__6333) : self__.afn.call(null,G__6322,G__6323,G__6324,G__6325,G__6326,G__6327,G__6328,G__6329,G__6330,G__6331,G__6332,G__6333));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__6334 = a;
var G__6335 = b;
var G__6336 = c;
var G__6337 = d;
var G__6338 = e;
var G__6339 = f;
var G__6340 = g;
var G__6341 = h;
var G__6342 = i;
var G__6343 = j;
var G__6344 = k;
var G__6345 = l;
var G__6346 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6334,G__6335,G__6336,G__6337,G__6338,G__6339,G__6340,G__6341,G__6342,G__6343,G__6344,G__6345,G__6346) : self__.afn.call(null,G__6334,G__6335,G__6336,G__6337,G__6338,G__6339,G__6340,G__6341,G__6342,G__6343,G__6344,G__6345,G__6346));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__6347 = a;
var G__6348 = b;
var G__6349 = c;
var G__6350 = d;
var G__6351 = e;
var G__6352 = f;
var G__6353 = g;
var G__6354 = h;
var G__6355 = i;
var G__6356 = j;
var G__6357 = k;
var G__6358 = l;
var G__6359 = m;
var G__6360 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6347,G__6348,G__6349,G__6350,G__6351,G__6352,G__6353,G__6354,G__6355,G__6356,G__6357,G__6358,G__6359,G__6360) : self__.afn.call(null,G__6347,G__6348,G__6349,G__6350,G__6351,G__6352,G__6353,G__6354,G__6355,G__6356,G__6357,G__6358,G__6359,G__6360));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__6361 = a;
var G__6362 = b;
var G__6363 = c;
var G__6364 = d;
var G__6365 = e;
var G__6366 = f;
var G__6367 = g;
var G__6368 = h;
var G__6369 = i;
var G__6370 = j;
var G__6371 = k;
var G__6372 = l;
var G__6373 = m;
var G__6374 = n;
var G__6375 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6361,G__6362,G__6363,G__6364,G__6365,G__6366,G__6367,G__6368,G__6369,G__6370,G__6371,G__6372,G__6373,G__6374,G__6375) : self__.afn.call(null,G__6361,G__6362,G__6363,G__6364,G__6365,G__6366,G__6367,G__6368,G__6369,G__6370,G__6371,G__6372,G__6373,G__6374,G__6375));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__6376 = a;
var G__6377 = b;
var G__6378 = c;
var G__6379 = d;
var G__6380 = e;
var G__6381 = f;
var G__6382 = g;
var G__6383 = h;
var G__6384 = i;
var G__6385 = j;
var G__6386 = k;
var G__6387 = l;
var G__6388 = m;
var G__6389 = n;
var G__6390 = o;
var G__6391 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6376,G__6377,G__6378,G__6379,G__6380,G__6381,G__6382,G__6383,G__6384,G__6385,G__6386,G__6387,G__6388,G__6389,G__6390,G__6391) : self__.afn.call(null,G__6376,G__6377,G__6378,G__6379,G__6380,G__6381,G__6382,G__6383,G__6384,G__6385,G__6386,G__6387,G__6388,G__6389,G__6390,G__6391));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__6392 = a;
var G__6393 = b;
var G__6394 = c;
var G__6395 = d;
var G__6396 = e;
var G__6397 = f;
var G__6398 = g;
var G__6399 = h;
var G__6400 = i;
var G__6401 = j;
var G__6402 = k;
var G__6403 = l;
var G__6404 = m;
var G__6405 = n;
var G__6406 = o;
var G__6407 = p;
var G__6408 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6392,G__6393,G__6394,G__6395,G__6396,G__6397,G__6398,G__6399,G__6400,G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408) : self__.afn.call(null,G__6392,G__6393,G__6394,G__6395,G__6396,G__6397,G__6398,G__6399,G__6400,G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__6409 = a;
var G__6410 = b;
var G__6411 = c;
var G__6412 = d;
var G__6413 = e;
var G__6414 = f;
var G__6415 = g;
var G__6416 = h;
var G__6417 = i;
var G__6418 = j;
var G__6419 = k;
var G__6420 = l;
var G__6421 = m;
var G__6422 = n;
var G__6423 = o;
var G__6424 = p;
var G__6425 = q;
var G__6426 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416,G__6417,G__6418,G__6419,G__6420,G__6421,G__6422,G__6423,G__6424,G__6425,G__6426) : self__.afn.call(null,G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416,G__6417,G__6418,G__6419,G__6420,G__6421,G__6422,G__6423,G__6424,G__6425,G__6426));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__6427 = a;
var G__6428 = b;
var G__6429 = c;
var G__6430 = d;
var G__6431 = e;
var G__6432 = f;
var G__6433 = g;
var G__6434 = h;
var G__6435 = i;
var G__6436 = j;
var G__6437 = k;
var G__6438 = l;
var G__6439 = m;
var G__6440 = n;
var G__6441 = o;
var G__6442 = p;
var G__6443 = q;
var G__6444 = r;
var G__6445 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438,G__6439,G__6440,G__6441,G__6442,G__6443,G__6444,G__6445) : self__.afn.call(null,G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438,G__6439,G__6440,G__6441,G__6442,G__6443,G__6444,G__6445));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__6446 = a;
var G__6447 = b;
var G__6448 = c;
var G__6449 = d;
var G__6450 = e;
var G__6451 = f;
var G__6452 = g;
var G__6453 = h;
var G__6454 = i;
var G__6455 = j;
var G__6456 = k;
var G__6457 = l;
var G__6458 = m;
var G__6459 = n;
var G__6460 = o;
var G__6461 = p;
var G__6462 = q;
var G__6463 = r;
var G__6464 = s;
var G__6465 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6446,G__6447,G__6448,G__6449,G__6450,G__6451,G__6452,G__6453,G__6454,G__6455,G__6456,G__6457,G__6458,G__6459,G__6460,G__6461,G__6462,G__6463,G__6464,G__6465) : self__.afn.call(null,G__6446,G__6447,G__6448,G__6449,G__6450,G__6451,G__6452,G__6453,G__6454,G__6455,G__6456,G__6457,G__6458,G__6459,G__6460,G__6461,G__6462,G__6463,G__6464,G__6465));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__6466 = self__.afn;
var G__6467 = a;
var G__6468 = b;
var G__6469 = c;
var G__6470 = d;
var G__6471 = e;
var G__6472 = f;
var G__6473 = g;
var G__6474 = h;
var G__6475 = i;
var G__6476 = j;
var G__6477 = k;
var G__6478 = l;
var G__6479 = m;
var G__6480 = n;
var G__6481 = o;
var G__6482 = p;
var G__6483 = q;
var G__6484 = r;
var G__6485 = s;
var G__6486 = t;
var G__6487 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6466,G__6467,G__6468,G__6469,G__6470,G__6471,G__6472,G__6473,G__6474,G__6475,G__6476,G__6477,G__6478,G__6479,G__6480,G__6481,G__6482,G__6483,G__6484,G__6485,G__6486,G__6487) : cljs.core.apply.call(null,G__6466,G__6467,G__6468,G__6469,G__6470,G__6471,G__6472,G__6473,G__6474,G__6475,G__6476,G__6477,G__6478,G__6479,G__6480,G__6481,G__6482,G__6483,G__6484,G__6485,G__6486,G__6487));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 * map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__6492 = o;
if(G__6492){
var bit__4441__auto__ = (G__6492.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4441__auto__) || (G__6492.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__6492.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__6492);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__6492);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__3755__auto__ = !((o == null));
if(and__3755__auto__){
var G__6496 = o;
if(G__6496){
var bit__4441__auto__ = (G__6496.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4441__auto__) || (G__6496.cljs$core$IMeta$)){
return true;
} else {
if((!G__6496.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__6496);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__6496);
}
} else {
return and__3755__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 * more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 * item, for a vector, returns a new vector without the last item.
 * Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 * does not contain key(s).
 * @param {...*} var_args
 */
cljs.core.disj = (function() {
var cljs$core$disj = null;
var cljs$core$disj__1 = (function (coll){
return coll;
});
var cljs$core$disj__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});
var cljs$core$disj__3 = (function() { 
var G__6499__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs$core$disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__6500 = ret;
var G__6501 = cljs.core.first(ks);
var G__6502 = cljs.core.next(ks);
coll = G__6500;
k = G__6501;
ks = G__6502;
continue;
} else {
return ret;
}
}
break;
}
};
var G__6499 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__6503__i = 0, G__6503__a = new Array(arguments.length -  2);
while (G__6503__i < G__6503__a.length) {G__6503__a[G__6503__i] = arguments[G__6503__i + 2]; ++G__6503__i;}
  ks = new cljs.core.IndexedSeq(G__6503__a,0);
} 
return G__6499__delegate.call(this,coll,k,ks);};
G__6499.cljs$lang$maxFixedArity = 2;
G__6499.cljs$lang$applyTo = (function (arglist__6504){
var coll = cljs.core.first(arglist__6504);
arglist__6504 = cljs.core.next(arglist__6504);
var k = cljs.core.first(arglist__6504);
var ks = cljs.core.rest(arglist__6504);
return G__6499__delegate(coll,k,ks);
});
G__6499.cljs$core$IFn$_invoke$arity$variadic = G__6499__delegate;
return G__6499;
})()
;
cljs$core$disj = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return cljs$core$disj__1.call(this,coll);
case 2:
return cljs$core$disj__2.call(this,coll,k);
default:
var G__6505 = null;
if (arguments.length > 2) {
var G__6506__i = 0, G__6506__a = new Array(arguments.length -  2);
while (G__6506__i < G__6506__a.length) {G__6506__a[G__6506__i] = arguments[G__6506__i + 2]; ++G__6506__i;}
G__6505 = new cljs.core.IndexedSeq(G__6506__a,0);
}
return cljs$core$disj__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__6505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$disj.cljs$lang$maxFixedArity = 2;
cljs$core$disj.cljs$lang$applyTo = cljs$core$disj__3.cljs$lang$applyTo;
cljs$core$disj.cljs$core$IFn$_invoke$arity$1 = cljs$core$disj__1;
cljs$core$disj.cljs$core$IFn$_invoke$arity$2 = cljs$core$disj__2;
cljs$core$disj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$disj__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$disj;
})()
;
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 * Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6508 = x;
if(G__6508){
var bit__4441__auto__ = (G__6508.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4441__auto__) || (G__6508.cljs$core$ICollection$)){
return true;
} else {
if((!G__6508.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__6508);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__6508);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6510 = x;
if(G__6510){
var bit__4441__auto__ = (G__6510.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4441__auto__) || (G__6510.cljs$core$ISet$)){
return true;
} else {
if((!G__6510.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__6510);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__6510);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
var G__6512 = x;
if(G__6512){
var bit__4441__auto__ = (G__6512.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4441__auto__) || (G__6512.cljs$core$IAssociative$)){
return true;
} else {
if((!G__6512.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__6512);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__6512);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
var G__6514 = x;
if(G__6514){
var bit__4441__auto__ = (G__6514.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4441__auto__) || (G__6514.cljs$core$ISequential$)){
return true;
} else {
if((!G__6514.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__6514);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__6514);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
var G__6516 = x;
if(G__6516){
var bit__4441__auto__ = (G__6516.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4441__auto__) || (G__6516.cljs$core$ISorted$)){
return true;
} else {
if((!G__6516.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__6516);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__6516);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
var G__6518 = x;
if(G__6518){
var bit__4441__auto__ = (G__6518.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4441__auto__) || (G__6518.cljs$core$IReduce$)){
return true;
} else {
if((!G__6518.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__6518);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__6518);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6520 = x;
if(G__6520){
var bit__4441__auto__ = (G__6520.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4441__auto__) || (G__6520.cljs$core$IMap$)){
return true;
} else {
if((!G__6520.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__6520);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__6520);
}
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
var G__6522 = x;
if(G__6522){
var bit__4441__auto__ = (G__6522.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4441__auto__) || (G__6522.cljs$core$IVector$)){
return true;
} else {
if((!G__6522.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__6522);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__6522);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
var G__6524 = x;
if(G__6524){
var bit__4434__auto__ = (G__6524.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4434__auto__) || (G__6524.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 * interleaved keys and values.
 * @param {...*} var_args
 */
cljs.core.js_obj = (function() {
var cljs$core$js_obj = null;
var cljs$core$js_obj__0 = (function (){
var obj6530 = {};
return obj6530;
});
var cljs$core$js_obj__1 = (function() { 
var G__6533__delegate = function (keyvals){
var G__6531 = goog.object.create;
var G__6532 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__6531,G__6532) : cljs.core.apply.call(null,G__6531,G__6532));
};
var G__6533 = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__6534__i = 0, G__6534__a = new Array(arguments.length -  0);
while (G__6534__i < G__6534__a.length) {G__6534__a[G__6534__i] = arguments[G__6534__i + 0]; ++G__6534__i;}
  keyvals = new cljs.core.IndexedSeq(G__6534__a,0);
} 
return G__6533__delegate.call(this,keyvals);};
G__6533.cljs$lang$maxFixedArity = 0;
G__6533.cljs$lang$applyTo = (function (arglist__6535){
var keyvals = cljs.core.seq(arglist__6535);
return G__6533__delegate(keyvals);
});
G__6533.cljs$core$IFn$_invoke$arity$variadic = G__6533__delegate;
return G__6533;
})()
;
cljs$core$js_obj = function(var_args){
var keyvals = var_args;
switch(arguments.length){
case 0:
return cljs$core$js_obj__0.call(this);
default:
var G__6536 = null;
if (arguments.length > 0) {
var G__6537__i = 0, G__6537__a = new Array(arguments.length -  0);
while (G__6537__i < G__6537__a.length) {G__6537__a[G__6537__i] = arguments[G__6537__i + 0]; ++G__6537__i;}
G__6536 = new cljs.core.IndexedSeq(G__6537__a,0);
}
return cljs$core$js_obj__1.cljs$core$IFn$_invoke$arity$variadic(G__6536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$js_obj.cljs$lang$maxFixedArity = 0;
cljs$core$js_obj.cljs$lang$applyTo = cljs$core$js_obj__1.cljs$lang$applyTo;
cljs$core$js_obj.cljs$core$IFn$_invoke$arity$0 = cljs$core$js_obj__0;
cljs$core$js_obj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js_obj__1.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$js_obj;
})()
;
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__6540_6542 = obj;
var G__6541_6543 = ((function (G__6540_6542,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__6540_6542,keys))
;
goog.object.forEach(G__6540_6542,G__6541_6543);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__6544 = (i__$1 + (1));
var G__6545 = (j__$1 + (1));
var G__6546 = (len__$1 - (1));
i__$1 = G__6544;
j__$1 = G__6545;
len__$1 = G__6546;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__6547 = (i__$1 - (1));
var G__6548 = (j__$1 - (1));
var G__6549 = (len__$1 - (1));
i__$1 = G__6547;
j__$1 = G__6548;
len__$1 = G__6549;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj6551 = {};
return obj6551;
})();
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__6553 = s;
if(G__6553){
var bit__4441__auto__ = (G__6553.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4441__auto__) || (G__6553.cljs$core$ISeq$)){
return true;
} else {
if((!G__6553.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6553);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6553);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var G__6555 = s;
if(G__6555){
var bit__4441__auto__ = (G__6555.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4441__auto__) || (G__6555.cljs$core$ISeqable$)){
return true;
} else {
if((!G__6555.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__6555);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__6555);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__3767__auto__ = cljs.core.fn_QMARK_(f);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var G__6559 = f;
if(G__6559){
var bit__4441__auto__ = (G__6559.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4441__auto__) || (G__6559.cljs$core$IFn$)){
return true;
} else {
if((!G__6559.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__6559);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__6559);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__6572 = n;
return isNaN(G__6572);
})())) && (!((n === Infinity))) && (((function (){var G__6573 = n;
return parseFloat(G__6573);
})() === (function (){var G__6574 = n;
var G__6575 = (10);
return parseInt(G__6574,G__6575);
})()));
});
/**
 * Returns true if key is present in the given collection, otherwise
 * returns false.  Note that for numerically indexed collections like
 * vectors and arrays, this tests if the numeric key is within the
 * range of indexes. 'contains?' operates constant or logarithmic time;
 * it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 * @param {...*} var_args
 */
cljs.core.distinct_QMARK_ = (function() {
var cljs$core$distinct_QMARK_ = null;
var cljs$core$distinct_QMARK___1 = (function (x){
return true;
});
var cljs$core$distinct_QMARK___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var cljs$core$distinct_QMARK___3 = (function() { 
var G__6576__delegate = function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__6577 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__6578 = etc;
s = G__6577;
xs = G__6578;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
};
var G__6576 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6579__i = 0, G__6579__a = new Array(arguments.length -  2);
while (G__6579__i < G__6579__a.length) {G__6579__a[G__6579__i] = arguments[G__6579__i + 2]; ++G__6579__i;}
  more = new cljs.core.IndexedSeq(G__6579__a,0);
} 
return G__6576__delegate.call(this,x,y,more);};
G__6576.cljs$lang$maxFixedArity = 2;
G__6576.cljs$lang$applyTo = (function (arglist__6580){
var x = cljs.core.first(arglist__6580);
arglist__6580 = cljs.core.next(arglist__6580);
var y = cljs.core.first(arglist__6580);
var more = cljs.core.rest(arglist__6580);
return G__6576__delegate(x,y,more);
});
G__6576.cljs$core$IFn$_invoke$arity$variadic = G__6576__delegate;
return G__6576;
})()
;
cljs$core$distinct_QMARK_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$distinct_QMARK___1.call(this,x);
case 2:
return cljs$core$distinct_QMARK___2.call(this,x,y);
default:
var G__6581 = null;
if (arguments.length > 2) {
var G__6582__i = 0, G__6582__a = new Array(arguments.length -  2);
while (G__6582__i < G__6582__a.length) {G__6582__a[G__6582__i] = arguments[G__6582__i + 2]; ++G__6582__i;}
G__6581 = new cljs.core.IndexedSeq(G__6582__a,0);
}
return cljs$core$distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs$core$distinct_QMARK_.cljs$lang$applyTo = cljs$core$distinct_QMARK___3.cljs$lang$applyTo;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = cljs$core$distinct_QMARK___1;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = cljs$core$distinct_QMARK___2;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$distinct_QMARK_;
})()
;
/**
 * Comparator. Returns a negative number, zero, or a positive number
 * when x is logically 'less than', 'equal to', or 'greater than'
 * y. Uses IComparable if available and google.array.defaultCompare for objects
 * of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__6586 = x;
if(G__6586){
var bit__4434__auto__ = (G__6586.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4434__auto__) || (G__6586.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__6587 = x;
var G__6588 = y;
return goog.array.defaultCompare(G__6587,G__6588);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function() {
var cljs$core$compare_indexed = null;
var cljs$core$compare_indexed__2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
return cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
});
var cljs$core$compare_indexed__4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__6593 = xs;
var G__6594 = ys;
var G__6595 = len;
var G__6596 = (n + (1));
xs = G__6593;
ys = G__6594;
len = G__6595;
n = G__6596;
continue;
} else {
return d;
}
break;
}
});
cljs$core$compare_indexed = function(xs,ys,len,n){
switch(arguments.length){
case 2:
return cljs$core$compare_indexed__2.call(this,xs,ys);
case 4:
return cljs$core$compare_indexed__4.call(this,xs,ys,len,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$compare_indexed__2;
cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$4 = cljs$core$compare_indexed__4;
return cljs$core$compare_indexed;
})()
;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__6601 = x;
var G__6602 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6601,G__6602) : f.call(null,G__6601,G__6602));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__6603 = y;
var G__6604 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6603,G__6604) : f.call(null,G__6603,G__6604));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function() {
var cljs$core$sort = null;
var cljs$core$sort__1 = (function (coll){
return cljs$core$sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});
var cljs$core$sort__2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__6610 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__6610) : cljs.core.to_array.call(null,G__6610));
})();
var G__6611_6613 = a;
var G__6612_6614 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__6611_6613,G__6612_6614);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});
cljs$core$sort = function(comp,coll){
switch(arguments.length){
case 1:
return cljs$core$sort__1.call(this,comp);
case 2:
return cljs$core$sort__2.call(this,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sort.cljs$core$IFn$_invoke$arity$1 = cljs$core$sort__1;
cljs$core$sort.cljs$core$IFn$_invoke$arity$2 = cljs$core$sort__2;
return cljs$core$sort;
})()
;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function() {
var cljs$core$sort_by = null;
var cljs$core$sort_by__2 = (function (keyfn,coll){
return cljs$core$sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});
var cljs$core$sort_by__3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__6620 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__6620) : keyfn.call(null,G__6620));
})(),(function (){var G__6621 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__6621) : keyfn.call(null,G__6621));
})());
}),coll);
});
cljs$core$sort_by = function(keyfn,comp,coll){
switch(arguments.length){
case 2:
return cljs$core$sort_by__2.call(this,keyfn,comp);
case 3:
return cljs$core$sort_by__3.call(this,keyfn,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sort_by.cljs$core$IFn$_invoke$arity$2 = cljs$core$sort_by__2;
cljs$core$sort_by.cljs$core$IFn$_invoke$arity$3 = cljs$core$sort_by__3;
return cljs$core$sort_by;
})()
;
cljs.core.seq_reduce = (function() {
var cljs$core$seq_reduce = null;
var cljs$core$seq_reduce__2 = (function (f,coll){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
var G__6627 = f;
var G__6628 = cljs.core.first(s);
var G__6629 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__6627,G__6628,G__6629) : cljs.core.reduce.call(null,G__6627,G__6628,G__6629));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});
var cljs$core$seq_reduce__3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__6630 = val__$1;
var G__6631 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6630,G__6631) : f.call(null,G__6630,G__6631));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6632 = nval;
var G__6633 = cljs.core.next(coll__$1);
val__$1 = G__6632;
coll__$1 = G__6633;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$seq_reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return cljs$core$seq_reduce__2.call(this,f,val);
case 3:
return cljs$core$seq_reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$seq_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$seq_reduce__2;
cljs$core$seq_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$seq_reduce__3;
return cljs$core$seq_reduce;
})()
;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (function (){var G__6637 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__6637) : cljs.core.to_array.call(null,G__6637));
})();
var G__6638_6640 = a;
goog.array.shuffle(G__6638_6640);

var G__6639 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__6639) : cljs.core.vec.call(null,G__6639));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc. If coll contains no
 * items, f must accept no arguments as well, and reduce returns the
 * result of calling f with no arguments.  If coll has only 1 item, it
 * is returned and f is not called.  If val is supplied, returns the
 * result of applying f to val and the first item in coll, then
 * applying f to that result and the 2nd item, etc. If coll contains no
 * items, returns val and f is not called.
 */
cljs.core.reduce = (function() {
var cljs$core$reduce = null;
var cljs$core$reduce__2 = (function (f,coll){
if((function (){var G__6643 = coll;
if(G__6643){
var bit__4434__auto__ = (G__6643.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4434__auto__) || (G__6643.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});
var cljs$core$reduce__3 = (function (f,val,coll){
if((function (){var G__6644 = coll;
if(G__6644){
var bit__4434__auto__ = (G__6644.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4434__auto__) || (G__6644.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});
cljs$core$reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return cljs$core$reduce__2.call(this,f,val);
case 3:
return cljs$core$reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$reduce__2;
cljs$core$reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$reduce__3;
return cljs$core$reduce;
})()
;
/**
 * Reduces an associative collection. f should be a function of 3
 * arguments. Returns the result of applying f to init, the first key
 * and the first value in coll, then applying f to that result and the
 * 2nd key and value, etc. If coll contains no entries, returns init
 * and f is not called. Note that reduce-kv is supported on vectors,
 * where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 * transduce by adding an arity-1 signature that calls cf (default -
 * identity) on the result argument.
 */
cljs.core.completing = (function() {
var cljs$core$completing = null;
var cljs$core$completing__1 = (function (f){
return cljs$core$completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});
var cljs$core$completing__2 = (function (f,cf){
return (function() {
var G__6653 = null;
var G__6653__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__6653__1 = (function (x){
var G__6650 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__6650) : cf.call(null,G__6650));
});
var G__6653__2 = (function (x,y){
var G__6651 = x;
var G__6652 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6651,G__6652) : f.call(null,G__6651,G__6652));
});
G__6653 = function(x,y){
switch(arguments.length){
case 0:
return G__6653__0.call(this);
case 1:
return G__6653__1.call(this,x);
case 2:
return G__6653__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6653.cljs$core$IFn$_invoke$arity$0 = G__6653__0;
G__6653.cljs$core$IFn$_invoke$arity$1 = G__6653__1;
G__6653.cljs$core$IFn$_invoke$arity$2 = G__6653__2;
return G__6653;
})()
});
cljs$core$completing = function(f,cf){
switch(arguments.length){
case 1:
return cljs$core$completing__1.call(this,f);
case 2:
return cljs$core$completing__2.call(this,f,cf);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$completing.cljs$core$IFn$_invoke$arity$1 = cljs$core$completing__1;
cljs$core$completing.cljs$core$IFn$_invoke$arity$2 = cljs$core$completing__2;
return cljs$core$completing;
})()
;
/**
 * reduce with a transformation of f (xf). If init is not
 * supplied, (f) will be called to produce it. f should be a reducing
 * step function that accepts both 1 and 2 arguments, if it accepts
 * only 2 you can add the arity-1 with 'completing'. Returns the result
 * of applying (the transformed) xf to init and the first item in coll,
 * then applying xf to that result and the 2nd item, etc. If coll
 * contains no items, returns init and f is not called. Note that
 * certain transforms may inject or skip items.
 */
cljs.core.transduce = (function() {
var cljs$core$transduce = null;
var cljs$core$transduce__3 = (function (xform,f,coll){
return cljs$core$transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});
var cljs$core$transduce__4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__6660 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__6660) : xform.call(null,G__6660));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__6661 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__6661) : f__$1.call(null,G__6661));
});
cljs$core$transduce = function(xform,f,init,coll){
switch(arguments.length){
case 3:
return cljs$core$transduce__3.call(this,xform,f,init);
case 4:
return cljs$core$transduce__4.call(this,xform,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$transduce__3;
cljs$core$transduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$transduce__4;
return cljs$core$transduce;
})()
;
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core._PLUS_ = (function() {
var cljs$core$_PLUS_ = null;
var cljs$core$_PLUS___0 = (function (){
return (0);
});
var cljs$core$_PLUS___1 = (function (x){
return x;
});
var cljs$core$_PLUS___2 = (function (x,y){
return (x + y);
});
var cljs$core$_PLUS___3 = (function() { 
var G__6662__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_PLUS_,(x + y),more);
};
var G__6662 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6663__i = 0, G__6663__a = new Array(arguments.length -  2);
while (G__6663__i < G__6663__a.length) {G__6663__a[G__6663__i] = arguments[G__6663__i + 2]; ++G__6663__i;}
  more = new cljs.core.IndexedSeq(G__6663__a,0);
} 
return G__6662__delegate.call(this,x,y,more);};
G__6662.cljs$lang$maxFixedArity = 2;
G__6662.cljs$lang$applyTo = (function (arglist__6664){
var x = cljs.core.first(arglist__6664);
arglist__6664 = cljs.core.next(arglist__6664);
var y = cljs.core.first(arglist__6664);
var more = cljs.core.rest(arglist__6664);
return G__6662__delegate(x,y,more);
});
G__6662.cljs$core$IFn$_invoke$arity$variadic = G__6662__delegate;
return G__6662;
})()
;
cljs$core$_PLUS_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$_PLUS___0.call(this);
case 1:
return cljs$core$_PLUS___1.call(this,x);
case 2:
return cljs$core$_PLUS___2.call(this,x,y);
default:
var G__6665 = null;
if (arguments.length > 2) {
var G__6666__i = 0, G__6666__a = new Array(arguments.length -  2);
while (G__6666__i < G__6666__a.length) {G__6666__a[G__6666__i] = arguments[G__6666__i + 2]; ++G__6666__i;}
G__6665 = new cljs.core.IndexedSeq(G__6666__a,0);
}
return cljs$core$_PLUS___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_PLUS_.cljs$lang$maxFixedArity = 2;
cljs$core$_PLUS_.cljs$lang$applyTo = cljs$core$_PLUS___3.cljs$lang$applyTo;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$0 = cljs$core$_PLUS___0;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_PLUS___1;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_PLUS___2;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_PLUS___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_PLUS_;
})()
;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core._ = (function() {
var cljs$core$_ = null;
var cljs$core$___1 = (function (x){
return (- x);
});
var cljs$core$___2 = (function (x,y){
return (x - y);
});
var cljs$core$___3 = (function() { 
var G__6667__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_,(x - y),more);
};
var G__6667 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6668__i = 0, G__6668__a = new Array(arguments.length -  2);
while (G__6668__i < G__6668__a.length) {G__6668__a[G__6668__i] = arguments[G__6668__i + 2]; ++G__6668__i;}
  more = new cljs.core.IndexedSeq(G__6668__a,0);
} 
return G__6667__delegate.call(this,x,y,more);};
G__6667.cljs$lang$maxFixedArity = 2;
G__6667.cljs$lang$applyTo = (function (arglist__6669){
var x = cljs.core.first(arglist__6669);
arglist__6669 = cljs.core.next(arglist__6669);
var y = cljs.core.first(arglist__6669);
var more = cljs.core.rest(arglist__6669);
return G__6667__delegate(x,y,more);
});
G__6667.cljs$core$IFn$_invoke$arity$variadic = G__6667__delegate;
return G__6667;
})()
;
cljs$core$_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$___1.call(this,x);
case 2:
return cljs$core$___2.call(this,x,y);
default:
var G__6670 = null;
if (arguments.length > 2) {
var G__6671__i = 0, G__6671__a = new Array(arguments.length -  2);
while (G__6671__i < G__6671__a.length) {G__6671__a[G__6671__i] = arguments[G__6671__i + 2]; ++G__6671__i;}
G__6670 = new cljs.core.IndexedSeq(G__6671__a,0);
}
return cljs$core$___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_.cljs$lang$maxFixedArity = 2;
cljs$core$_.cljs$lang$applyTo = cljs$core$___3.cljs$lang$applyTo;
cljs$core$_.cljs$core$IFn$_invoke$arity$1 = cljs$core$___1;
cljs$core$_.cljs$core$IFn$_invoke$arity$2 = cljs$core$___2;
cljs$core$_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_;
})()
;
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core._STAR_ = (function() {
var cljs$core$_STAR_ = null;
var cljs$core$_STAR___0 = (function (){
return (1);
});
var cljs$core$_STAR___1 = (function (x){
return x;
});
var cljs$core$_STAR___2 = (function (x,y){
return (x * y);
});
var cljs$core$_STAR___3 = (function() { 
var G__6672__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_STAR_,(x * y),more);
};
var G__6672 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6673__i = 0, G__6673__a = new Array(arguments.length -  2);
while (G__6673__i < G__6673__a.length) {G__6673__a[G__6673__i] = arguments[G__6673__i + 2]; ++G__6673__i;}
  more = new cljs.core.IndexedSeq(G__6673__a,0);
} 
return G__6672__delegate.call(this,x,y,more);};
G__6672.cljs$lang$maxFixedArity = 2;
G__6672.cljs$lang$applyTo = (function (arglist__6674){
var x = cljs.core.first(arglist__6674);
arglist__6674 = cljs.core.next(arglist__6674);
var y = cljs.core.first(arglist__6674);
var more = cljs.core.rest(arglist__6674);
return G__6672__delegate(x,y,more);
});
G__6672.cljs$core$IFn$_invoke$arity$variadic = G__6672__delegate;
return G__6672;
})()
;
cljs$core$_STAR_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$_STAR___0.call(this);
case 1:
return cljs$core$_STAR___1.call(this,x);
case 2:
return cljs$core$_STAR___2.call(this,x,y);
default:
var G__6675 = null;
if (arguments.length > 2) {
var G__6676__i = 0, G__6676__a = new Array(arguments.length -  2);
while (G__6676__i < G__6676__a.length) {G__6676__a[G__6676__i] = arguments[G__6676__i + 2]; ++G__6676__i;}
G__6675 = new cljs.core.IndexedSeq(G__6676__a,0);
}
return cljs$core$_STAR___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_STAR_.cljs$lang$maxFixedArity = 2;
cljs$core$_STAR_.cljs$lang$applyTo = cljs$core$_STAR___3.cljs$lang$applyTo;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$0 = cljs$core$_STAR___0;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_STAR___1;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_STAR___2;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_STAR___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_STAR_;
})()
;
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 * @param {...*} var_args
 */
cljs.core._SLASH_ = (function() {
var cljs$core$_SLASH_ = null;
var cljs$core$_SLASH___1 = (function (x){
return cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2((1),x);
});
var cljs$core$_SLASH___2 = (function (x,y){
return (x / y);
});
var cljs$core$_SLASH___3 = (function() { 
var G__6681__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_SLASH_,cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__6681 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6682__i = 0, G__6682__a = new Array(arguments.length -  2);
while (G__6682__i < G__6682__a.length) {G__6682__a[G__6682__i] = arguments[G__6682__i + 2]; ++G__6682__i;}
  more = new cljs.core.IndexedSeq(G__6682__a,0);
} 
return G__6681__delegate.call(this,x,y,more);};
G__6681.cljs$lang$maxFixedArity = 2;
G__6681.cljs$lang$applyTo = (function (arglist__6683){
var x = cljs.core.first(arglist__6683);
arglist__6683 = cljs.core.next(arglist__6683);
var y = cljs.core.first(arglist__6683);
var more = cljs.core.rest(arglist__6683);
return G__6681__delegate(x,y,more);
});
G__6681.cljs$core$IFn$_invoke$arity$variadic = G__6681__delegate;
return G__6681;
})()
;
cljs$core$_SLASH_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_SLASH___1.call(this,x);
case 2:
return cljs$core$_SLASH___2.call(this,x,y);
default:
var G__6684 = null;
if (arguments.length > 2) {
var G__6685__i = 0, G__6685__a = new Array(arguments.length -  2);
while (G__6685__i < G__6685__a.length) {G__6685__a[G__6685__i] = arguments[G__6685__i + 2]; ++G__6685__i;}
G__6684 = new cljs.core.IndexedSeq(G__6685__a,0);
}
return cljs$core$_SLASH___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_SLASH_.cljs$lang$maxFixedArity = 2;
cljs$core$_SLASH_.cljs$lang$applyTo = cljs$core$_SLASH___3.cljs$lang$applyTo;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_SLASH___1;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_SLASH___2;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_SLASH___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_SLASH_;
})()
;
/**
 * Returns non-nil if nums are in monotonically increasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._LT_ = (function() {
var cljs$core$_LT_ = null;
var cljs$core$_LT___1 = (function (x){
return true;
});
var cljs$core$_LT___2 = (function (x,y){
return (x < y);
});
var cljs$core$_LT___3 = (function() { 
var G__6686__delegate = function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__6687 = y;
var G__6688 = cljs.core.first(more);
var G__6689 = cljs.core.next(more);
x = G__6687;
y = G__6688;
more = G__6689;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6686 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6690__i = 0, G__6690__a = new Array(arguments.length -  2);
while (G__6690__i < G__6690__a.length) {G__6690__a[G__6690__i] = arguments[G__6690__i + 2]; ++G__6690__i;}
  more = new cljs.core.IndexedSeq(G__6690__a,0);
} 
return G__6686__delegate.call(this,x,y,more);};
G__6686.cljs$lang$maxFixedArity = 2;
G__6686.cljs$lang$applyTo = (function (arglist__6691){
var x = cljs.core.first(arglist__6691);
arglist__6691 = cljs.core.next(arglist__6691);
var y = cljs.core.first(arglist__6691);
var more = cljs.core.rest(arglist__6691);
return G__6686__delegate(x,y,more);
});
G__6686.cljs$core$IFn$_invoke$arity$variadic = G__6686__delegate;
return G__6686;
})()
;
cljs$core$_LT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_LT___1.call(this,x);
case 2:
return cljs$core$_LT___2.call(this,x,y);
default:
var G__6692 = null;
if (arguments.length > 2) {
var G__6693__i = 0, G__6693__a = new Array(arguments.length -  2);
while (G__6693__i < G__6693__a.length) {G__6693__a[G__6693__i] = arguments[G__6693__i + 2]; ++G__6693__i;}
G__6692 = new cljs.core.IndexedSeq(G__6693__a,0);
}
return cljs$core$_LT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_LT_.cljs$lang$maxFixedArity = 2;
cljs$core$_LT_.cljs$lang$applyTo = cljs$core$_LT___3.cljs$lang$applyTo;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_LT___1;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_LT___2;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_LT___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_LT_;
})()
;
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._LT__EQ_ = (function() {
var cljs$core$_LT__EQ_ = null;
var cljs$core$_LT__EQ___1 = (function (x){
return true;
});
var cljs$core$_LT__EQ___2 = (function (x,y){
return (x <= y);
});
var cljs$core$_LT__EQ___3 = (function() { 
var G__6694__delegate = function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__6695 = y;
var G__6696 = cljs.core.first(more);
var G__6697 = cljs.core.next(more);
x = G__6695;
y = G__6696;
more = G__6697;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6694 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6698__i = 0, G__6698__a = new Array(arguments.length -  2);
while (G__6698__i < G__6698__a.length) {G__6698__a[G__6698__i] = arguments[G__6698__i + 2]; ++G__6698__i;}
  more = new cljs.core.IndexedSeq(G__6698__a,0);
} 
return G__6694__delegate.call(this,x,y,more);};
G__6694.cljs$lang$maxFixedArity = 2;
G__6694.cljs$lang$applyTo = (function (arglist__6699){
var x = cljs.core.first(arglist__6699);
arglist__6699 = cljs.core.next(arglist__6699);
var y = cljs.core.first(arglist__6699);
var more = cljs.core.rest(arglist__6699);
return G__6694__delegate(x,y,more);
});
G__6694.cljs$core$IFn$_invoke$arity$variadic = G__6694__delegate;
return G__6694;
})()
;
cljs$core$_LT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_LT__EQ___1.call(this,x);
case 2:
return cljs$core$_LT__EQ___2.call(this,x,y);
default:
var G__6700 = null;
if (arguments.length > 2) {
var G__6701__i = 0, G__6701__a = new Array(arguments.length -  2);
while (G__6701__i < G__6701__a.length) {G__6701__a[G__6701__i] = arguments[G__6701__i + 2]; ++G__6701__i;}
G__6700 = new cljs.core.IndexedSeq(G__6701__a,0);
}
return cljs$core$_LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_LT__EQ_.cljs$lang$applyTo = cljs$core$_LT__EQ___3.cljs$lang$applyTo;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_LT__EQ___1;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_LT__EQ___2;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_LT__EQ_;
})()
;
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._GT_ = (function() {
var cljs$core$_GT_ = null;
var cljs$core$_GT___1 = (function (x){
return true;
});
var cljs$core$_GT___2 = (function (x,y){
return (x > y);
});
var cljs$core$_GT___3 = (function() { 
var G__6702__delegate = function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__6703 = y;
var G__6704 = cljs.core.first(more);
var G__6705 = cljs.core.next(more);
x = G__6703;
y = G__6704;
more = G__6705;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6702 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6706__i = 0, G__6706__a = new Array(arguments.length -  2);
while (G__6706__i < G__6706__a.length) {G__6706__a[G__6706__i] = arguments[G__6706__i + 2]; ++G__6706__i;}
  more = new cljs.core.IndexedSeq(G__6706__a,0);
} 
return G__6702__delegate.call(this,x,y,more);};
G__6702.cljs$lang$maxFixedArity = 2;
G__6702.cljs$lang$applyTo = (function (arglist__6707){
var x = cljs.core.first(arglist__6707);
arglist__6707 = cljs.core.next(arglist__6707);
var y = cljs.core.first(arglist__6707);
var more = cljs.core.rest(arglist__6707);
return G__6702__delegate(x,y,more);
});
G__6702.cljs$core$IFn$_invoke$arity$variadic = G__6702__delegate;
return G__6702;
})()
;
cljs$core$_GT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_GT___1.call(this,x);
case 2:
return cljs$core$_GT___2.call(this,x,y);
default:
var G__6708 = null;
if (arguments.length > 2) {
var G__6709__i = 0, G__6709__a = new Array(arguments.length -  2);
while (G__6709__i < G__6709__a.length) {G__6709__a[G__6709__i] = arguments[G__6709__i + 2]; ++G__6709__i;}
G__6708 = new cljs.core.IndexedSeq(G__6709__a,0);
}
return cljs$core$_GT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6708);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_GT_.cljs$lang$maxFixedArity = 2;
cljs$core$_GT_.cljs$lang$applyTo = cljs$core$_GT___3.cljs$lang$applyTo;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_GT___1;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_GT___2;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_GT___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_GT_;
})()
;
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._GT__EQ_ = (function() {
var cljs$core$_GT__EQ_ = null;
var cljs$core$_GT__EQ___1 = (function (x){
return true;
});
var cljs$core$_GT__EQ___2 = (function (x,y){
return (x >= y);
});
var cljs$core$_GT__EQ___3 = (function() { 
var G__6710__delegate = function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__6711 = y;
var G__6712 = cljs.core.first(more);
var G__6713 = cljs.core.next(more);
x = G__6711;
y = G__6712;
more = G__6713;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6710 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6714__i = 0, G__6714__a = new Array(arguments.length -  2);
while (G__6714__i < G__6714__a.length) {G__6714__a[G__6714__i] = arguments[G__6714__i + 2]; ++G__6714__i;}
  more = new cljs.core.IndexedSeq(G__6714__a,0);
} 
return G__6710__delegate.call(this,x,y,more);};
G__6710.cljs$lang$maxFixedArity = 2;
G__6710.cljs$lang$applyTo = (function (arglist__6715){
var x = cljs.core.first(arglist__6715);
arglist__6715 = cljs.core.next(arglist__6715);
var y = cljs.core.first(arglist__6715);
var more = cljs.core.rest(arglist__6715);
return G__6710__delegate(x,y,more);
});
G__6710.cljs$core$IFn$_invoke$arity$variadic = G__6710__delegate;
return G__6710;
})()
;
cljs$core$_GT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_GT__EQ___1.call(this,x);
case 2:
return cljs$core$_GT__EQ___2.call(this,x,y);
default:
var G__6716 = null;
if (arguments.length > 2) {
var G__6717__i = 0, G__6717__a = new Array(arguments.length -  2);
while (G__6717__i < G__6717__a.length) {G__6717__a[G__6717__i] = arguments[G__6717__i + 2]; ++G__6717__i;}
G__6716 = new cljs.core.IndexedSeq(G__6717__a,0);
}
return cljs$core$_GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_GT__EQ_.cljs$lang$applyTo = cljs$core$_GT__EQ___3.cljs$lang$applyTo;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_GT__EQ___1;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_GT__EQ___2;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_GT__EQ_;
})()
;
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 * @param {...*} var_args
 */
cljs.core.max = (function() {
var cljs$core$max = null;
var cljs$core$max__1 = (function (x){
return x;
});
var cljs$core$max__2 = (function (x,y){
var x__4079__auto__ = x;
var y__4080__auto__ = y;
return ((x__4079__auto__ > y__4080__auto__) ? x__4079__auto__ : y__4080__auto__);
});
var cljs$core$max__3 = (function() { 
var G__6718__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$max,(function (){var x__4079__auto__ = x;
var y__4080__auto__ = y;
return ((x__4079__auto__ > y__4080__auto__) ? x__4079__auto__ : y__4080__auto__);
})(),more);
};
var G__6718 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6719__i = 0, G__6719__a = new Array(arguments.length -  2);
while (G__6719__i < G__6719__a.length) {G__6719__a[G__6719__i] = arguments[G__6719__i + 2]; ++G__6719__i;}
  more = new cljs.core.IndexedSeq(G__6719__a,0);
} 
return G__6718__delegate.call(this,x,y,more);};
G__6718.cljs$lang$maxFixedArity = 2;
G__6718.cljs$lang$applyTo = (function (arglist__6720){
var x = cljs.core.first(arglist__6720);
arglist__6720 = cljs.core.next(arglist__6720);
var y = cljs.core.first(arglist__6720);
var more = cljs.core.rest(arglist__6720);
return G__6718__delegate(x,y,more);
});
G__6718.cljs$core$IFn$_invoke$arity$variadic = G__6718__delegate;
return G__6718;
})()
;
cljs$core$max = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$max__1.call(this,x);
case 2:
return cljs$core$max__2.call(this,x,y);
default:
var G__6721 = null;
if (arguments.length > 2) {
var G__6722__i = 0, G__6722__a = new Array(arguments.length -  2);
while (G__6722__i < G__6722__a.length) {G__6722__a[G__6722__i] = arguments[G__6722__i + 2]; ++G__6722__i;}
G__6721 = new cljs.core.IndexedSeq(G__6722__a,0);
}
return cljs$core$max__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$max.cljs$lang$maxFixedArity = 2;
cljs$core$max.cljs$lang$applyTo = cljs$core$max__3.cljs$lang$applyTo;
cljs$core$max.cljs$core$IFn$_invoke$arity$1 = cljs$core$max__1;
cljs$core$max.cljs$core$IFn$_invoke$arity$2 = cljs$core$max__2;
cljs$core$max.cljs$core$IFn$_invoke$arity$variadic = cljs$core$max__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$max;
})()
;
/**
 * Returns the least of the nums.
 * @param {...*} var_args
 */
cljs.core.min = (function() {
var cljs$core$min = null;
var cljs$core$min__1 = (function (x){
return x;
});
var cljs$core$min__2 = (function (x,y){
var x__4086__auto__ = x;
var y__4087__auto__ = y;
return ((x__4086__auto__ < y__4087__auto__) ? x__4086__auto__ : y__4087__auto__);
});
var cljs$core$min__3 = (function() { 
var G__6723__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$min,(function (){var x__4086__auto__ = x;
var y__4087__auto__ = y;
return ((x__4086__auto__ < y__4087__auto__) ? x__4086__auto__ : y__4087__auto__);
})(),more);
};
var G__6723 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6724__i = 0, G__6724__a = new Array(arguments.length -  2);
while (G__6724__i < G__6724__a.length) {G__6724__a[G__6724__i] = arguments[G__6724__i + 2]; ++G__6724__i;}
  more = new cljs.core.IndexedSeq(G__6724__a,0);
} 
return G__6723__delegate.call(this,x,y,more);};
G__6723.cljs$lang$maxFixedArity = 2;
G__6723.cljs$lang$applyTo = (function (arglist__6725){
var x = cljs.core.first(arglist__6725);
arglist__6725 = cljs.core.next(arglist__6725);
var y = cljs.core.first(arglist__6725);
var more = cljs.core.rest(arglist__6725);
return G__6723__delegate(x,y,more);
});
G__6723.cljs$core$IFn$_invoke$arity$variadic = G__6723__delegate;
return G__6723;
})()
;
cljs$core$min = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$min__1.call(this,x);
case 2:
return cljs$core$min__2.call(this,x,y);
default:
var G__6726 = null;
if (arguments.length > 2) {
var G__6727__i = 0, G__6727__a = new Array(arguments.length -  2);
while (G__6727__i < G__6727__a.length) {G__6727__a[G__6727__i] = arguments[G__6727__i + 2]; ++G__6727__i;}
G__6726 = new cljs.core.IndexedSeq(G__6727__a,0);
}
return cljs$core$min__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$min.cljs$lang$maxFixedArity = 2;
cljs$core$min.cljs$lang$applyTo = cljs$core$min__3.cljs$lang$applyTo;
cljs$core$min.cljs$core$IFn$_invoke$arity$1 = cljs$core$min__1;
cljs$core$min.cljs$core$IFn$_invoke$arity$2 = cljs$core$min__2;
cljs$core$min.cljs$core$IFn$_invoke$arity$variadic = cljs$core$min__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$min;
})()
;
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core.unchecked_add = (function() {
var cljs$core$unchecked_add = null;
var cljs$core$unchecked_add__0 = (function (){
return (0);
});
var cljs$core$unchecked_add__1 = (function (x){
return x;
});
var cljs$core$unchecked_add__2 = (function (x,y){
return (x + y);
});
var cljs$core$unchecked_add__3 = (function() { 
var G__6728__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_add,(x + y),more);
};
var G__6728 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6729__i = 0, G__6729__a = new Array(arguments.length -  2);
while (G__6729__i < G__6729__a.length) {G__6729__a[G__6729__i] = arguments[G__6729__i + 2]; ++G__6729__i;}
  more = new cljs.core.IndexedSeq(G__6729__a,0);
} 
return G__6728__delegate.call(this,x,y,more);};
G__6728.cljs$lang$maxFixedArity = 2;
G__6728.cljs$lang$applyTo = (function (arglist__6730){
var x = cljs.core.first(arglist__6730);
arglist__6730 = cljs.core.next(arglist__6730);
var y = cljs.core.first(arglist__6730);
var more = cljs.core.rest(arglist__6730);
return G__6728__delegate(x,y,more);
});
G__6728.cljs$core$IFn$_invoke$arity$variadic = G__6728__delegate;
return G__6728;
})()
;
cljs$core$unchecked_add = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_add__0.call(this);
case 1:
return cljs$core$unchecked_add__1.call(this,x);
case 2:
return cljs$core$unchecked_add__2.call(this,x,y);
default:
var G__6731 = null;
if (arguments.length > 2) {
var G__6732__i = 0, G__6732__a = new Array(arguments.length -  2);
while (G__6732__i < G__6732__a.length) {G__6732__a[G__6732__i] = arguments[G__6732__i + 2]; ++G__6732__i;}
G__6731 = new cljs.core.IndexedSeq(G__6732__a,0);
}
return cljs$core$unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_add.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_add.cljs$lang$applyTo = cljs$core$unchecked_add__3.cljs$lang$applyTo;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_add__0;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_add__1;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_add__2;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_add;
})()
;
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core.unchecked_add_int = (function() {
var cljs$core$unchecked_add_int = null;
var cljs$core$unchecked_add_int__0 = (function (){
return (0);
});
var cljs$core$unchecked_add_int__1 = (function (x){
return x;
});
var cljs$core$unchecked_add_int__2 = (function (x,y){
return (x + y);
});
var cljs$core$unchecked_add_int__3 = (function() { 
var G__6733__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_add_int,(x + y),more);
};
var G__6733 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6734__i = 0, G__6734__a = new Array(arguments.length -  2);
while (G__6734__i < G__6734__a.length) {G__6734__a[G__6734__i] = arguments[G__6734__i + 2]; ++G__6734__i;}
  more = new cljs.core.IndexedSeq(G__6734__a,0);
} 
return G__6733__delegate.call(this,x,y,more);};
G__6733.cljs$lang$maxFixedArity = 2;
G__6733.cljs$lang$applyTo = (function (arglist__6735){
var x = cljs.core.first(arglist__6735);
arglist__6735 = cljs.core.next(arglist__6735);
var y = cljs.core.first(arglist__6735);
var more = cljs.core.rest(arglist__6735);
return G__6733__delegate(x,y,more);
});
G__6733.cljs$core$IFn$_invoke$arity$variadic = G__6733__delegate;
return G__6733;
})()
;
cljs$core$unchecked_add_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_add_int__0.call(this);
case 1:
return cljs$core$unchecked_add_int__1.call(this,x);
case 2:
return cljs$core$unchecked_add_int__2.call(this,x,y);
default:
var G__6736 = null;
if (arguments.length > 2) {
var G__6737__i = 0, G__6737__a = new Array(arguments.length -  2);
while (G__6737__i < G__6737__a.length) {G__6737__a[G__6737__i] = arguments[G__6737__i + 2]; ++G__6737__i;}
G__6736 = new cljs.core.IndexedSeq(G__6737__a,0);
}
return cljs$core$unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_add_int.cljs$lang$applyTo = cljs$core$unchecked_add_int__3.cljs$lang$applyTo;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_add_int__0;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_add_int__1;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_add_int__2;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_add_int;
})()
;
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 * @param {...*} var_args
 */
cljs.core.unchecked_divide_int = (function() {
var cljs$core$unchecked_divide_int = null;
var cljs$core$unchecked_divide_int__1 = (function (x){
return cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((1),x);
});
var cljs$core$unchecked_divide_int__2 = (function (x,y){
return (x / y);
});
var cljs$core$unchecked_divide_int__3 = (function() { 
var G__6742__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_divide_int,cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__6742 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6743__i = 0, G__6743__a = new Array(arguments.length -  2);
while (G__6743__i < G__6743__a.length) {G__6743__a[G__6743__i] = arguments[G__6743__i + 2]; ++G__6743__i;}
  more = new cljs.core.IndexedSeq(G__6743__a,0);
} 
return G__6742__delegate.call(this,x,y,more);};
G__6742.cljs$lang$maxFixedArity = 2;
G__6742.cljs$lang$applyTo = (function (arglist__6744){
var x = cljs.core.first(arglist__6744);
arglist__6744 = cljs.core.next(arglist__6744);
var y = cljs.core.first(arglist__6744);
var more = cljs.core.rest(arglist__6744);
return G__6742__delegate(x,y,more);
});
G__6742.cljs$core$IFn$_invoke$arity$variadic = G__6742__delegate;
return G__6742;
})()
;
cljs$core$unchecked_divide_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_divide_int__1.call(this,x);
case 2:
return cljs$core$unchecked_divide_int__2.call(this,x,y);
default:
var G__6745 = null;
if (arguments.length > 2) {
var G__6746__i = 0, G__6746__a = new Array(arguments.length -  2);
while (G__6746__i < G__6746__a.length) {G__6746__a[G__6746__i] = arguments[G__6746__i + 2]; ++G__6746__i;}
G__6745 = new cljs.core.IndexedSeq(G__6746__a,0);
}
return cljs$core$unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_divide_int.cljs$lang$applyTo = cljs$core$unchecked_divide_int__3.cljs$lang$applyTo;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_divide_int__1;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_divide_int__2;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_divide_int;
})()
;
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core.unchecked_multiply = (function() {
var cljs$core$unchecked_multiply = null;
var cljs$core$unchecked_multiply__0 = (function (){
return (1);
});
var cljs$core$unchecked_multiply__1 = (function (x){
return x;
});
var cljs$core$unchecked_multiply__2 = (function (x,y){
return (x * y);
});
var cljs$core$unchecked_multiply__3 = (function() { 
var G__6747__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_multiply,(x * y),more);
};
var G__6747 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6748__i = 0, G__6748__a = new Array(arguments.length -  2);
while (G__6748__i < G__6748__a.length) {G__6748__a[G__6748__i] = arguments[G__6748__i + 2]; ++G__6748__i;}
  more = new cljs.core.IndexedSeq(G__6748__a,0);
} 
return G__6747__delegate.call(this,x,y,more);};
G__6747.cljs$lang$maxFixedArity = 2;
G__6747.cljs$lang$applyTo = (function (arglist__6749){
var x = cljs.core.first(arglist__6749);
arglist__6749 = cljs.core.next(arglist__6749);
var y = cljs.core.first(arglist__6749);
var more = cljs.core.rest(arglist__6749);
return G__6747__delegate(x,y,more);
});
G__6747.cljs$core$IFn$_invoke$arity$variadic = G__6747__delegate;
return G__6747;
})()
;
cljs$core$unchecked_multiply = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_multiply__0.call(this);
case 1:
return cljs$core$unchecked_multiply__1.call(this,x);
case 2:
return cljs$core$unchecked_multiply__2.call(this,x,y);
default:
var G__6750 = null;
if (arguments.length > 2) {
var G__6751__i = 0, G__6751__a = new Array(arguments.length -  2);
while (G__6751__i < G__6751__a.length) {G__6751__a[G__6751__i] = arguments[G__6751__i + 2]; ++G__6751__i;}
G__6750 = new cljs.core.IndexedSeq(G__6751__a,0);
}
return cljs$core$unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_multiply.cljs$lang$applyTo = cljs$core$unchecked_multiply__3.cljs$lang$applyTo;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_multiply__0;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_multiply__1;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_multiply__2;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_multiply;
})()
;
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core.unchecked_multiply_int = (function() {
var cljs$core$unchecked_multiply_int = null;
var cljs$core$unchecked_multiply_int__0 = (function (){
return (1);
});
var cljs$core$unchecked_multiply_int__1 = (function (x){
return x;
});
var cljs$core$unchecked_multiply_int__2 = (function (x,y){
return (x * y);
});
var cljs$core$unchecked_multiply_int__3 = (function() { 
var G__6752__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_multiply_int,(x * y),more);
};
var G__6752 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6753__i = 0, G__6753__a = new Array(arguments.length -  2);
while (G__6753__i < G__6753__a.length) {G__6753__a[G__6753__i] = arguments[G__6753__i + 2]; ++G__6753__i;}
  more = new cljs.core.IndexedSeq(G__6753__a,0);
} 
return G__6752__delegate.call(this,x,y,more);};
G__6752.cljs$lang$maxFixedArity = 2;
G__6752.cljs$lang$applyTo = (function (arglist__6754){
var x = cljs.core.first(arglist__6754);
arglist__6754 = cljs.core.next(arglist__6754);
var y = cljs.core.first(arglist__6754);
var more = cljs.core.rest(arglist__6754);
return G__6752__delegate(x,y,more);
});
G__6752.cljs$core$IFn$_invoke$arity$variadic = G__6752__delegate;
return G__6752;
})()
;
cljs$core$unchecked_multiply_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_multiply_int__0.call(this);
case 1:
return cljs$core$unchecked_multiply_int__1.call(this,x);
case 2:
return cljs$core$unchecked_multiply_int__2.call(this,x,y);
default:
var G__6755 = null;
if (arguments.length > 2) {
var G__6756__i = 0, G__6756__a = new Array(arguments.length -  2);
while (G__6756__i < G__6756__a.length) {G__6756__a[G__6756__i] = arguments[G__6756__i + 2]; ++G__6756__i;}
G__6755 = new cljs.core.IndexedSeq(G__6756__a,0);
}
return cljs$core$unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_multiply_int.cljs$lang$applyTo = cljs$core$unchecked_multiply_int__3.cljs$lang$applyTo;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_multiply_int__0;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_multiply_int__1;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_multiply_int__2;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_multiply_int;
})()
;
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
var G__6759 = x;
var G__6760 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__6759,G__6760) : cljs.core.mod.call(null,G__6759,G__6760));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core.unchecked_subtract = (function() {
var cljs$core$unchecked_subtract = null;
var cljs$core$unchecked_subtract__1 = (function (x){
return (- x);
});
var cljs$core$unchecked_subtract__2 = (function (x,y){
return (x - y);
});
var cljs$core$unchecked_subtract__3 = (function() { 
var G__6761__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_subtract,(x - y),more);
};
var G__6761 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6762__i = 0, G__6762__a = new Array(arguments.length -  2);
while (G__6762__i < G__6762__a.length) {G__6762__a[G__6762__i] = arguments[G__6762__i + 2]; ++G__6762__i;}
  more = new cljs.core.IndexedSeq(G__6762__a,0);
} 
return G__6761__delegate.call(this,x,y,more);};
G__6761.cljs$lang$maxFixedArity = 2;
G__6761.cljs$lang$applyTo = (function (arglist__6763){
var x = cljs.core.first(arglist__6763);
arglist__6763 = cljs.core.next(arglist__6763);
var y = cljs.core.first(arglist__6763);
var more = cljs.core.rest(arglist__6763);
return G__6761__delegate(x,y,more);
});
G__6761.cljs$core$IFn$_invoke$arity$variadic = G__6761__delegate;
return G__6761;
})()
;
cljs$core$unchecked_subtract = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_subtract__1.call(this,x);
case 2:
return cljs$core$unchecked_subtract__2.call(this,x,y);
default:
var G__6764 = null;
if (arguments.length > 2) {
var G__6765__i = 0, G__6765__a = new Array(arguments.length -  2);
while (G__6765__i < G__6765__a.length) {G__6765__a[G__6765__i] = arguments[G__6765__i + 2]; ++G__6765__i;}
G__6764 = new cljs.core.IndexedSeq(G__6765__a,0);
}
return cljs$core$unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_subtract.cljs$lang$applyTo = cljs$core$unchecked_subtract__3.cljs$lang$applyTo;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_subtract__1;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_subtract__2;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_subtract;
})()
;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core.unchecked_subtract_int = (function() {
var cljs$core$unchecked_subtract_int = null;
var cljs$core$unchecked_subtract_int__1 = (function (x){
return (- x);
});
var cljs$core$unchecked_subtract_int__2 = (function (x,y){
return (x - y);
});
var cljs$core$unchecked_subtract_int__3 = (function() { 
var G__6766__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_subtract_int,(x - y),more);
};
var G__6766 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6767__i = 0, G__6767__a = new Array(arguments.length -  2);
while (G__6767__i < G__6767__a.length) {G__6767__a[G__6767__i] = arguments[G__6767__i + 2]; ++G__6767__i;}
  more = new cljs.core.IndexedSeq(G__6767__a,0);
} 
return G__6766__delegate.call(this,x,y,more);};
G__6766.cljs$lang$maxFixedArity = 2;
G__6766.cljs$lang$applyTo = (function (arglist__6768){
var x = cljs.core.first(arglist__6768);
arglist__6768 = cljs.core.next(arglist__6768);
var y = cljs.core.first(arglist__6768);
var more = cljs.core.rest(arglist__6768);
return G__6766__delegate(x,y,more);
});
G__6766.cljs$core$IFn$_invoke$arity$variadic = G__6766__delegate;
return G__6766;
})()
;
cljs$core$unchecked_subtract_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_subtract_int__1.call(this,x);
case 2:
return cljs$core$unchecked_subtract_int__2.call(this,x,y);
default:
var G__6769 = null;
if (arguments.length > 2) {
var G__6770__i = 0, G__6770__a = new Array(arguments.length -  2);
while (G__6770__i < G__6770__a.length) {G__6770__a[G__6770__i] = arguments[G__6770__i + 2]; ++G__6770__i;}
G__6769 = new cljs.core.IndexedSeq(G__6770__a,0);
}
return cljs$core$unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_subtract_int.cljs$lang$applyTo = cljs$core$unchecked_subtract_int__3.cljs$lang$applyTo;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_subtract_int__1;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_subtract_int__2;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_subtract_int;
})()
;
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
var G__6773 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__6773) : Math.floor.call(null,G__6773));
} else {
var G__6774 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__6774) : Math.ceil.call(null,G__6774));
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 * @param {...*} var_args
 */
cljs.core.bit_xor = (function() {
var cljs$core$bit_xor = null;
var cljs$core$bit_xor__2 = (function (x,y){
return (x ^ y);
});
var cljs$core$bit_xor__3 = (function() { 
var G__6775__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_xor,(x ^ y),more);
};
var G__6775 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6776__i = 0, G__6776__a = new Array(arguments.length -  2);
while (G__6776__i < G__6776__a.length) {G__6776__a[G__6776__i] = arguments[G__6776__i + 2]; ++G__6776__i;}
  more = new cljs.core.IndexedSeq(G__6776__a,0);
} 
return G__6775__delegate.call(this,x,y,more);};
G__6775.cljs$lang$maxFixedArity = 2;
G__6775.cljs$lang$applyTo = (function (arglist__6777){
var x = cljs.core.first(arglist__6777);
arglist__6777 = cljs.core.next(arglist__6777);
var y = cljs.core.first(arglist__6777);
var more = cljs.core.rest(arglist__6777);
return G__6775__delegate(x,y,more);
});
G__6775.cljs$core$IFn$_invoke$arity$variadic = G__6775__delegate;
return G__6775;
})()
;
cljs$core$bit_xor = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_xor__2.call(this,x,y);
default:
var G__6778 = null;
if (arguments.length > 2) {
var G__6779__i = 0, G__6779__a = new Array(arguments.length -  2);
while (G__6779__i < G__6779__a.length) {G__6779__a[G__6779__i] = arguments[G__6779__i + 2]; ++G__6779__i;}
G__6778 = new cljs.core.IndexedSeq(G__6779__a,0);
}
return cljs$core$bit_xor__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_xor.cljs$lang$maxFixedArity = 2;
cljs$core$bit_xor.cljs$lang$applyTo = cljs$core$bit_xor__3.cljs$lang$applyTo;
cljs$core$bit_xor.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_xor__2;
cljs$core$bit_xor.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_xor__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_xor;
})()
;
/**
 * Bitwise and
 * @param {...*} var_args
 */
cljs.core.bit_and = (function() {
var cljs$core$bit_and = null;
var cljs$core$bit_and__2 = (function (x,y){
return (x & y);
});
var cljs$core$bit_and__3 = (function() { 
var G__6780__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_and,(x & y),more);
};
var G__6780 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6781__i = 0, G__6781__a = new Array(arguments.length -  2);
while (G__6781__i < G__6781__a.length) {G__6781__a[G__6781__i] = arguments[G__6781__i + 2]; ++G__6781__i;}
  more = new cljs.core.IndexedSeq(G__6781__a,0);
} 
return G__6780__delegate.call(this,x,y,more);};
G__6780.cljs$lang$maxFixedArity = 2;
G__6780.cljs$lang$applyTo = (function (arglist__6782){
var x = cljs.core.first(arglist__6782);
arglist__6782 = cljs.core.next(arglist__6782);
var y = cljs.core.first(arglist__6782);
var more = cljs.core.rest(arglist__6782);
return G__6780__delegate(x,y,more);
});
G__6780.cljs$core$IFn$_invoke$arity$variadic = G__6780__delegate;
return G__6780;
})()
;
cljs$core$bit_and = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_and__2.call(this,x,y);
default:
var G__6783 = null;
if (arguments.length > 2) {
var G__6784__i = 0, G__6784__a = new Array(arguments.length -  2);
while (G__6784__i < G__6784__a.length) {G__6784__a[G__6784__i] = arguments[G__6784__i + 2]; ++G__6784__i;}
G__6783 = new cljs.core.IndexedSeq(G__6784__a,0);
}
return cljs$core$bit_and__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_and.cljs$lang$maxFixedArity = 2;
cljs$core$bit_and.cljs$lang$applyTo = cljs$core$bit_and__3.cljs$lang$applyTo;
cljs$core$bit_and.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_and__2;
cljs$core$bit_and.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_and__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_and;
})()
;
/**
 * Bitwise or
 * @param {...*} var_args
 */
cljs.core.bit_or = (function() {
var cljs$core$bit_or = null;
var cljs$core$bit_or__2 = (function (x,y){
return (x | y);
});
var cljs$core$bit_or__3 = (function() { 
var G__6785__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_or,(x | y),more);
};
var G__6785 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6786__i = 0, G__6786__a = new Array(arguments.length -  2);
while (G__6786__i < G__6786__a.length) {G__6786__a[G__6786__i] = arguments[G__6786__i + 2]; ++G__6786__i;}
  more = new cljs.core.IndexedSeq(G__6786__a,0);
} 
return G__6785__delegate.call(this,x,y,more);};
G__6785.cljs$lang$maxFixedArity = 2;
G__6785.cljs$lang$applyTo = (function (arglist__6787){
var x = cljs.core.first(arglist__6787);
arglist__6787 = cljs.core.next(arglist__6787);
var y = cljs.core.first(arglist__6787);
var more = cljs.core.rest(arglist__6787);
return G__6785__delegate(x,y,more);
});
G__6785.cljs$core$IFn$_invoke$arity$variadic = G__6785__delegate;
return G__6785;
})()
;
cljs$core$bit_or = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_or__2.call(this,x,y);
default:
var G__6788 = null;
if (arguments.length > 2) {
var G__6789__i = 0, G__6789__a = new Array(arguments.length -  2);
while (G__6789__i < G__6789__a.length) {G__6789__a[G__6789__i] = arguments[G__6789__i + 2]; ++G__6789__i;}
G__6788 = new cljs.core.IndexedSeq(G__6789__a,0);
}
return cljs$core$bit_or__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6788);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_or.cljs$lang$maxFixedArity = 2;
cljs$core$bit_or.cljs$lang$applyTo = cljs$core$bit_or__3.cljs$lang$applyTo;
cljs$core$bit_or.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_or__2;
cljs$core$bit_or.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_or__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_or;
})()
;
/**
 * Bitwise and
 * @param {...*} var_args
 */
cljs.core.bit_and_not = (function() {
var cljs$core$bit_and_not = null;
var cljs$core$bit_and_not__2 = (function (x,y){
return (x & ~y);
});
var cljs$core$bit_and_not__3 = (function() { 
var G__6790__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_and_not,(x & ~y),more);
};
var G__6790 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6791__i = 0, G__6791__a = new Array(arguments.length -  2);
while (G__6791__i < G__6791__a.length) {G__6791__a[G__6791__i] = arguments[G__6791__i + 2]; ++G__6791__i;}
  more = new cljs.core.IndexedSeq(G__6791__a,0);
} 
return G__6790__delegate.call(this,x,y,more);};
G__6790.cljs$lang$maxFixedArity = 2;
G__6790.cljs$lang$applyTo = (function (arglist__6792){
var x = cljs.core.first(arglist__6792);
arglist__6792 = cljs.core.next(arglist__6792);
var y = cljs.core.first(arglist__6792);
var more = cljs.core.rest(arglist__6792);
return G__6790__delegate(x,y,more);
});
G__6790.cljs$core$IFn$_invoke$arity$variadic = G__6790__delegate;
return G__6790;
})()
;
cljs$core$bit_and_not = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_and_not__2.call(this,x,y);
default:
var G__6793 = null;
if (arguments.length > 2) {
var G__6794__i = 0, G__6794__a = new Array(arguments.length -  2);
while (G__6794__i < G__6794__a.length) {G__6794__a[G__6794__i] = arguments[G__6794__i + 2]; ++G__6794__i;}
G__6793 = new cljs.core.IndexedSeq(G__6794__a,0);
}
return cljs$core$bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_and_not.cljs$lang$maxFixedArity = 2;
cljs$core$bit_and_not.cljs$lang$applyTo = cljs$core$bit_and_not__3.cljs$lang$applyTo;
cljs$core$bit_and_not.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_and_not__2;
cljs$core$bit_and_not.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_and_not;
})()
;
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 * value, otherwise false. Behavior on non nums is
 * undefined.
 * @param {...*} var_args
 */
cljs.core._EQ__EQ_ = (function() {
var cljs$core$_EQ__EQ_ = null;
var cljs$core$_EQ__EQ___1 = (function (x){
return true;
});
var cljs$core$_EQ__EQ___2 = (function (x,y){
return cljs.core._equiv(x,y);
});
var cljs$core$_EQ__EQ___3 = (function() { 
var G__6799__delegate = function (x,y,more){
while(true){
if(cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__6800 = y;
var G__6801 = cljs.core.first(more);
var G__6802 = cljs.core.next(more);
x = G__6800;
y = G__6801;
more = G__6802;
continue;
} else {
return cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6799 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6803__i = 0, G__6803__a = new Array(arguments.length -  2);
while (G__6803__i < G__6803__a.length) {G__6803__a[G__6803__i] = arguments[G__6803__i + 2]; ++G__6803__i;}
  more = new cljs.core.IndexedSeq(G__6803__a,0);
} 
return G__6799__delegate.call(this,x,y,more);};
G__6799.cljs$lang$maxFixedArity = 2;
G__6799.cljs$lang$applyTo = (function (arglist__6804){
var x = cljs.core.first(arglist__6804);
arglist__6804 = cljs.core.next(arglist__6804);
var y = cljs.core.first(arglist__6804);
var more = cljs.core.rest(arglist__6804);
return G__6799__delegate(x,y,more);
});
G__6799.cljs$core$IFn$_invoke$arity$variadic = G__6799__delegate;
return G__6799;
})()
;
cljs$core$_EQ__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_EQ__EQ___1.call(this,x);
case 2:
return cljs$core$_EQ__EQ___2.call(this,x,y);
default:
var G__6805 = null;
if (arguments.length > 2) {
var G__6806__i = 0, G__6806__a = new Array(arguments.length -  2);
while (G__6806__i < G__6806__a.length) {G__6806__a[G__6806__i] = arguments[G__6806__i + 2]; ++G__6806__i;}
G__6805 = new cljs.core.IndexedSeq(G__6806__a,0);
}
return cljs$core$_EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_EQ__EQ_.cljs$lang$applyTo = cljs$core$_EQ__EQ___3.cljs$lang$applyTo;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_EQ__EQ___1;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_EQ__EQ___2;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_EQ__EQ_;
})()
;
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__6807 = (n__$1 - (1));
var G__6808 = cljs.core.next(xs);
n__$1 = G__6807;
xs = G__6808;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 * x.toString().  (str nil) returns the empty string. With more than
 * one arg, returns the concatenation of the str values of the args.
 * @param {...*} var_args
 */
cljs.core.str = (function() {
var cljs$core$str = null;
var cljs$core$str__0 = (function (){
return "";
});
var cljs$core$str__1 = (function (x){
if((x == null)){
return "";
} else {
var G__6812 = x;
return goog.string.buildString(G__6812);
}
});
var cljs$core$str__2 = (function() { 
var G__6813__delegate = function (x,ys){
var sb = (new goog.string.StringBuffer(cljs$core$str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__6814 = sb.append(cljs$core$str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__6815 = cljs.core.next(more);
sb = G__6814;
more = G__6815;
continue;
} else {
return sb.toString();
}
break;
}
};
var G__6813 = function (x,var_args){
var ys = null;
if (arguments.length > 1) {
var G__6816__i = 0, G__6816__a = new Array(arguments.length -  1);
while (G__6816__i < G__6816__a.length) {G__6816__a[G__6816__i] = arguments[G__6816__i + 1]; ++G__6816__i;}
  ys = new cljs.core.IndexedSeq(G__6816__a,0);
} 
return G__6813__delegate.call(this,x,ys);};
G__6813.cljs$lang$maxFixedArity = 1;
G__6813.cljs$lang$applyTo = (function (arglist__6817){
var x = cljs.core.first(arglist__6817);
var ys = cljs.core.rest(arglist__6817);
return G__6813__delegate(x,ys);
});
G__6813.cljs$core$IFn$_invoke$arity$variadic = G__6813__delegate;
return G__6813;
})()
;
cljs$core$str = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return cljs$core$str__0.call(this);
case 1:
return cljs$core$str__1.call(this,x);
default:
var G__6818 = null;
if (arguments.length > 1) {
var G__6819__i = 0, G__6819__a = new Array(arguments.length -  1);
while (G__6819__i < G__6819__a.length) {G__6819__a[G__6819__i] = arguments[G__6819__i + 1]; ++G__6819__i;}
G__6818 = new cljs.core.IndexedSeq(G__6819__a,0);
}
return cljs$core$str__2.cljs$core$IFn$_invoke$arity$variadic(x, G__6818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$str.cljs$lang$maxFixedArity = 1;
cljs$core$str.cljs$lang$applyTo = cljs$core$str__2.cljs$lang$applyTo;
cljs$core$str.cljs$core$IFn$_invoke$arity$0 = cljs$core$str__0;
cljs$core$str.cljs$core$IFn$_invoke$arity$1 = cljs$core$str__1;
cljs$core$str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$str__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$str;
})()
;
/**
 * Returns the substring of s beginning at start inclusive, and ending
 * at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function() {
var cljs$core$subs = null;
var cljs$core$subs__2 = (function (s,start){
return s.substring(start);
});
var cljs$core$subs__3 = (function (s,start,end){
return s.substring(start,end);
});
cljs$core$subs = function(s,start,end){
switch(arguments.length){
case 2:
return cljs$core$subs__2.call(this,s,start);
case 3:
return cljs$core$subs__3.call(this,s,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subs.cljs$core$IFn$_invoke$arity$2 = cljs$core$subs__2;
cljs$core$subs.cljs$core$IFn$_invoke$arity$3 = cljs$core$subs__3;
return cljs$core$subs;
})()
;

/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 * returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__6820 = cljs.core.next(xs);
var G__6821 = cljs.core.next(ys);
xs = G__6820;
ys = G__6821;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__6822 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__6823 = cljs.core.next(s);
res = G__6822;
s = G__6823;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__6828 = ((h + (cljs.core.hash((function (){var G__6826 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__6826) : cljs.core.key.call(null,G__6826));
})()) ^ cljs.core.hash((function (){var G__6827 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__6827) : cljs.core.val.call(null,G__6827));
})()))) % (4503599627370496));
var G__6829 = cljs.core.next(s);
h = G__6828;
s = G__6829;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__6830 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__6831 = cljs.core.next(s__$1);
h = G__6830;
s__$1 = G__6831;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 * attaches said functions as methods on the object.  Any references to
 * JavaScript's implicit this (via the this-as macro) will resolve to the
 * object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__6842_6852 = cljs.core.seq(fn_map);
var chunk__6843_6853 = null;
var count__6844_6854 = (0);
var i__6845_6855 = (0);
while(true){
if((i__6845_6855 < count__6844_6854)){
var vec__6846_6856 = chunk__6843_6853.cljs$core$IIndexed$_nth$arity$2(null,i__6845_6855);
var key_name_6857 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6846_6856,(0),null);
var f_6858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6846_6856,(1),null);
var str_name_6859 = (function (){var G__6847 = key_name_6857;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6847) : cljs.core.name.call(null,G__6847));
})();
(obj[str_name_6859] = f_6858);

var G__6860 = seq__6842_6852;
var G__6861 = chunk__6843_6853;
var G__6862 = count__6844_6854;
var G__6863 = (i__6845_6855 + (1));
seq__6842_6852 = G__6860;
chunk__6843_6853 = G__6861;
count__6844_6854 = G__6862;
i__6845_6855 = G__6863;
continue;
} else {
var temp__4126__auto___6864 = cljs.core.seq(seq__6842_6852);
if(temp__4126__auto___6864){
var seq__6842_6865__$1 = temp__4126__auto___6864;
if(cljs.core.chunked_seq_QMARK_(seq__6842_6865__$1)){
var c__4552__auto___6866 = (function (){var G__6848 = seq__6842_6865__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__6848) : cljs.core.chunk_first.call(null,G__6848));
})();
var G__6867 = (function (){var G__6849 = seq__6842_6865__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__6849) : cljs.core.chunk_rest.call(null,G__6849));
})();
var G__6868 = c__4552__auto___6866;
var G__6869 = cljs.core.count(c__4552__auto___6866);
var G__6870 = (0);
seq__6842_6852 = G__6867;
chunk__6843_6853 = G__6868;
count__6844_6854 = G__6869;
i__6845_6855 = G__6870;
continue;
} else {
var vec__6850_6871 = cljs.core.first(seq__6842_6865__$1);
var key_name_6872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6850_6871,(0),null);
var f_6873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6850_6871,(1),null);
var str_name_6874 = (function (){var G__6851 = key_name_6872;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6851) : cljs.core.name.call(null,G__6851));
})();
(obj[str_name_6874] = f_6873);

var G__6875 = cljs.core.next(seq__6842_6865__$1);
var G__6876 = null;
var G__6877 = (0);
var G__6878 = (0);
seq__6842_6852 = G__6875;
chunk__6843_6853 = G__6876;
count__6844_6854 = G__6877;
i__6845_6855 = G__6878;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
var G__6880 = coll;
if(G__6880){
var bit__4441__auto__ = (G__6880.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4441__auto__) || (G__6880.cljs$core$IReversible$)){
return true;
} else {
if((!G__6880.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__6880);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__6880);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 * can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(coll){
return cljs.core._rseq(coll);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 * @param {...*} var_args
 */
cljs.core.list = (function() { 
var cljs$core$list__delegate = function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__6881 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__6881;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__6882 = (i - (1));
var G__6883 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__6882;
r = G__6883;
continue;
} else {
return r;
}
break;
}
};
var cljs$core$list = function (var_args){
var xs = null;
if (arguments.length > 0) {
var G__6884__i = 0, G__6884__a = new Array(arguments.length -  0);
while (G__6884__i < G__6884__a.length) {G__6884__a[G__6884__i] = arguments[G__6884__i + 0]; ++G__6884__i;}
  xs = new cljs.core.IndexedSeq(G__6884__a,0);
} 
return cljs$core$list__delegate.call(this,xs);};
cljs$core$list.cljs$lang$maxFixedArity = 0;
cljs$core$list.cljs$lang$applyTo = (function (arglist__6885){
var xs = cljs.core.seq(arglist__6885);
return cljs$core$list__delegate(xs);
});
cljs$core$list.cljs$core$IFn$_invoke$arity$variadic = cljs$core$list__delegate;
return cljs$core$list;
})()
;

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__3767__auto__ = (coll == null);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var G__6889 = coll;
if(G__6889){
var bit__4434__auto__ = (G__6889.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4434__auto__) || (G__6889.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
var G__6891 = x;
if(G__6891){
var bit__4441__auto__ = (G__6891.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4441__auto__) || (G__6891.cljs$core$IList$)){
return true;
} else {
if((!G__6891.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__6891);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__6891);
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3755__auto__ = cljs.core.not(a.ns);
if(and__3755__auto__){
return b.ns;
} else {
return and__3755__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__6898 = a.ns;
var G__6899 = b.ns;
return goog.array.defaultCompare(G__6898,G__6899);
})();
if(((0) === nsc)){
var G__6900 = a.name;
var G__6901 = b.name;
return goog.array.defaultCompare(G__6900,G__6901);
} else {
return nsc;
}
}
} else {
var G__6902 = a.name;
var G__6903 = b.name;
return goog.array.defaultCompare(G__6902,G__6903);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4183__auto__ = self__._hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__6905 = null;
var G__6905__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__6905__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__6905 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__6905__2.call(this,self__,coll);
case 3:
return G__6905__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6905.cljs$core$IFn$_invoke$arity$2 = G__6905__2;
G__6905.cljs$core$IFn$_invoke$arity$3 = G__6905__3;
return G__6905;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args6904){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6904)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((function (){var G__6907 = x;
if(G__6907){
var bit__4434__auto__ = (G__6907.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4434__auto__) || (G__6907.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 * in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function() {
var cljs$core$keyword = null;
var cljs$core$keyword__1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__6909 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6909) : cljs.core.name.call(null,G__6909));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});
var cljs$core$keyword__2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});
cljs$core$keyword = function(ns,name){
switch(arguments.length){
case 1:
return cljs$core$keyword__1.call(this,ns);
case 2:
return cljs$core$keyword__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keyword.cljs$core$IFn$_invoke$arity$1 = cljs$core$keyword__1;
cljs$core$keyword.cljs$core$IFn$_invoke$arity$2 = cljs$core$keyword__2;
return cljs$core$keyword;
})()
;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__6910 = ls.sval();
ls = G__6910;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function() {
var cljs$core$array_chunk = null;
var cljs$core$array_chunk__1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});
var cljs$core$array_chunk__2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});
var cljs$core$array_chunk__3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});
cljs$core$array_chunk = function(arr,off,end){
switch(arguments.length){
case 1:
return cljs$core$array_chunk__1.call(this,arr);
case 2:
return cljs$core$array_chunk__2.call(this,arr,off);
case 3:
return cljs$core$array_chunk__3.call(this,arr,off,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$1 = cljs$core$array_chunk__1;
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_chunk__2;
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$3 = cljs$core$array_chunk__3;
return cljs$core$array_chunk;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((function (){var G__6912 = s;
if(G__6912){
var bit__4434__auto__ = (G__6912.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4434__auto__) || (G__6912.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__6913 = cljs.core.next(s__$1);
s__$1 = G__6913;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 * containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_6914 = (0);
var xs_6915 = cljs.core.seq(coll);
while(true){
if(xs_6915){
(ret[i_6914] = cljs.core.to_array(cljs.core.first(xs_6915)));

var G__6916 = (i_6914 + (1));
var G__6917 = cljs.core.next(xs_6915);
i_6914 = G__6916;
xs_6915 = G__6917;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.int_array = (function() {
var cljs$core$int_array = null;
var cljs$core$int_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$int_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6920 = (i + (1));
var G__6921 = cljs.core.next(s__$1);
i = G__6920;
s__$1 = G__6921;
continue;
} else {
return a;
}
break;
}
} else {
var n__4652__auto___6922 = size;
var i_6923 = (0);
while(true){
if((i_6923 < n__4652__auto___6922)){
(a[i_6923] = init_val_or_seq);

var G__6924 = (i_6923 + (1));
i_6923 = G__6924;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$int_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$int_array__1.call(this,size);
case 2:
return cljs$core$int_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$int_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$int_array__1;
cljs$core$int_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$int_array__2;
return cljs$core$int_array;
})()
;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.long_array = (function() {
var cljs$core$long_array = null;
var cljs$core$long_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$long_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6927 = (i + (1));
var G__6928 = cljs.core.next(s__$1);
i = G__6927;
s__$1 = G__6928;
continue;
} else {
return a;
}
break;
}
} else {
var n__4652__auto___6929 = size;
var i_6930 = (0);
while(true){
if((i_6930 < n__4652__auto___6929)){
(a[i_6930] = init_val_or_seq);

var G__6931 = (i_6930 + (1));
i_6930 = G__6931;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$long_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$long_array__1.call(this,size);
case 2:
return cljs$core$long_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$long_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$long_array__1;
cljs$core$long_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$long_array__2;
return cljs$core$long_array;
})()
;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.double_array = (function() {
var cljs$core$double_array = null;
var cljs$core$double_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$double_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6934 = (i + (1));
var G__6935 = cljs.core.next(s__$1);
i = G__6934;
s__$1 = G__6935;
continue;
} else {
return a;
}
break;
}
} else {
var n__4652__auto___6936 = size;
var i_6937 = (0);
while(true){
if((i_6937 < n__4652__auto___6936)){
(a[i_6937] = init_val_or_seq);

var G__6938 = (i_6937 + (1));
i_6937 = G__6938;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$double_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$double_array__1.call(this,size);
case 2:
return cljs$core$double_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$double_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$double_array__1;
cljs$core$double_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$double_array__2;
return cljs$core$double_array;
})()
;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.object_array = (function() {
var cljs$core$object_array = null;
var cljs$core$object_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$object_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6941 = (i + (1));
var G__6942 = cljs.core.next(s__$1);
i = G__6941;
s__$1 = G__6942;
continue;
} else {
return a;
}
break;
}
} else {
var n__4652__auto___6943 = size;
var i_6944 = (0);
while(true){
if((i_6944 < n__4652__auto___6943)){
(a[i_6944] = init_val_or_seq);

var G__6945 = (i_6944 + (1));
i_6944 = G__6945;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$object_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$object_array__1.call(this,size);
case 2:
return cljs$core$object_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$object_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$object_array__1;
cljs$core$object_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$object_array__2;
return cljs$core$object_array;
})()
;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__6946 = cljs.core.next(s__$1);
var G__6947 = (i - (1));
var G__6948 = (sum + (1));
s__$1 = G__6946;
i = G__6947;
sum = G__6948;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 * @param {...*} var_args
 */
cljs.core.concat = (function() {
var cljs$core$concat = null;
var cljs$core$concat__0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});
var cljs$core$concat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});
var cljs$core$concat__2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs$core$concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs$core$concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});
var cljs$core$concat__3 = (function() { 
var G__6968__delegate = function (x,y,zs){
var cat = (function cljs$core$concat_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$concat_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$concat_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$concat_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs$core$concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
};
var G__6968 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__6969__i = 0, G__6969__a = new Array(arguments.length -  2);
while (G__6969__i < G__6969__a.length) {G__6969__a[G__6969__i] = arguments[G__6969__i + 2]; ++G__6969__i;}
  zs = new cljs.core.IndexedSeq(G__6969__a,0);
} 
return G__6968__delegate.call(this,x,y,zs);};
G__6968.cljs$lang$maxFixedArity = 2;
G__6968.cljs$lang$applyTo = (function (arglist__6970){
var x = cljs.core.first(arglist__6970);
arglist__6970 = cljs.core.next(arglist__6970);
var y = cljs.core.first(arglist__6970);
var zs = cljs.core.rest(arglist__6970);
return G__6968__delegate(x,y,zs);
});
G__6968.cljs$core$IFn$_invoke$arity$variadic = G__6968__delegate;
return G__6968;
})()
;
cljs$core$concat = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$concat__0.call(this);
case 1:
return cljs$core$concat__1.call(this,x);
case 2:
return cljs$core$concat__2.call(this,x,y);
default:
var G__6971 = null;
if (arguments.length > 2) {
var G__6972__i = 0, G__6972__a = new Array(arguments.length -  2);
while (G__6972__i < G__6972__a.length) {G__6972__a[G__6972__i] = arguments[G__6972__i + 2]; ++G__6972__i;}
G__6971 = new cljs.core.IndexedSeq(G__6972__a,0);
}
return cljs$core$concat__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$concat.cljs$lang$maxFixedArity = 2;
cljs$core$concat.cljs$lang$applyTo = cljs$core$concat__3.cljs$lang$applyTo;
cljs$core$concat.cljs$core$IFn$_invoke$arity$0 = cljs$core$concat__0;
cljs$core$concat.cljs$core$IFn$_invoke$arity$1 = cljs$core$concat__1;
cljs$core$concat.cljs$core$IFn$_invoke$arity$2 = cljs$core$concat__2;
cljs$core$concat.cljs$core$IFn$_invoke$arity$variadic = cljs$core$concat__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$concat;
})()
;
/**
 * Creates a new list containing the items prepended to the rest, the
 * last of which will be treated as a sequence.
 * @param {...*} var_args
 */
cljs.core.list_STAR_ = (function() {
var cljs$core$list_STAR_ = null;
var cljs$core$list_STAR___1 = (function (args){
return cljs.core.seq(args);
});
var cljs$core$list_STAR___2 = (function (a,args){
return cljs.core.cons(a,args);
});
var cljs$core$list_STAR___3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});
var cljs$core$list_STAR___4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});
var cljs$core$list_STAR___5 = (function() { 
var G__6973__delegate = function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
};
var G__6973 = function (a,b,c,d,var_args){
var more = null;
if (arguments.length > 4) {
var G__6974__i = 0, G__6974__a = new Array(arguments.length -  4);
while (G__6974__i < G__6974__a.length) {G__6974__a[G__6974__i] = arguments[G__6974__i + 4]; ++G__6974__i;}
  more = new cljs.core.IndexedSeq(G__6974__a,0);
} 
return G__6973__delegate.call(this,a,b,c,d,more);};
G__6973.cljs$lang$maxFixedArity = 4;
G__6973.cljs$lang$applyTo = (function (arglist__6975){
var a = cljs.core.first(arglist__6975);
arglist__6975 = cljs.core.next(arglist__6975);
var b = cljs.core.first(arglist__6975);
arglist__6975 = cljs.core.next(arglist__6975);
var c = cljs.core.first(arglist__6975);
arglist__6975 = cljs.core.next(arglist__6975);
var d = cljs.core.first(arglist__6975);
var more = cljs.core.rest(arglist__6975);
return G__6973__delegate(a,b,c,d,more);
});
G__6973.cljs$core$IFn$_invoke$arity$variadic = G__6973__delegate;
return G__6973;
})()
;
cljs$core$list_STAR_ = function(a,b,c,d,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$list_STAR___1.call(this,a);
case 2:
return cljs$core$list_STAR___2.call(this,a,b);
case 3:
return cljs$core$list_STAR___3.call(this,a,b,c);
case 4:
return cljs$core$list_STAR___4.call(this,a,b,c,d);
default:
var G__6976 = null;
if (arguments.length > 4) {
var G__6977__i = 0, G__6977__a = new Array(arguments.length -  4);
while (G__6977__i < G__6977__a.length) {G__6977__a[G__6977__i] = arguments[G__6977__i + 4]; ++G__6977__i;}
G__6976 = new cljs.core.IndexedSeq(G__6977__a,0);
}
return cljs$core$list_STAR___5.cljs$core$IFn$_invoke$arity$variadic(a,b,c,d, G__6976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$list_STAR_.cljs$lang$maxFixedArity = 4;
cljs$core$list_STAR_.cljs$lang$applyTo = cljs$core$list_STAR___5.cljs$lang$applyTo;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$1 = cljs$core$list_STAR___1;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$2 = cljs$core$list_STAR___2;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$3 = cljs$core$list_STAR___3;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$4 = cljs$core$list_STAR___4;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$list_STAR___5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$list_STAR_;
})()
;
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 * constant time. The transient collection cannot be used after this
 * call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 * may happen at different 'places' depending on the concrete type.
 * @param {...*} var_args
 */
cljs.core.conj_BANG_ = (function() {
var cljs$core$conj_BANG_ = null;
var cljs$core$conj_BANG___0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});
var cljs$core$conj_BANG___1 = (function (coll){
return coll;
});
var cljs$core$conj_BANG___2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});
var cljs$core$conj_BANG___3 = (function() { 
var G__6978__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__6979 = ntcoll;
var G__6980 = cljs.core.first(vals);
var G__6981 = cljs.core.next(vals);
tcoll = G__6979;
val = G__6980;
vals = G__6981;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6978 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__6982__i = 0, G__6982__a = new Array(arguments.length -  2);
while (G__6982__i < G__6982__a.length) {G__6982__a[G__6982__i] = arguments[G__6982__i + 2]; ++G__6982__i;}
  vals = new cljs.core.IndexedSeq(G__6982__a,0);
} 
return G__6978__delegate.call(this,tcoll,val,vals);};
G__6978.cljs$lang$maxFixedArity = 2;
G__6978.cljs$lang$applyTo = (function (arglist__6983){
var tcoll = cljs.core.first(arglist__6983);
arglist__6983 = cljs.core.next(arglist__6983);
var val = cljs.core.first(arglist__6983);
var vals = cljs.core.rest(arglist__6983);
return G__6978__delegate(tcoll,val,vals);
});
G__6978.cljs$core$IFn$_invoke$arity$variadic = G__6978__delegate;
return G__6978;
})()
;
cljs$core$conj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 0:
return cljs$core$conj_BANG___0.call(this);
case 1:
return cljs$core$conj_BANG___1.call(this,tcoll);
case 2:
return cljs$core$conj_BANG___2.call(this,tcoll,val);
default:
var G__6984 = null;
if (arguments.length > 2) {
var G__6985__i = 0, G__6985__a = new Array(arguments.length -  2);
while (G__6985__i < G__6985__a.length) {G__6985__a[G__6985__i] = arguments[G__6985__i + 2]; ++G__6985__i;}
G__6984 = new cljs.core.IndexedSeq(G__6985__a,0);
}
return cljs$core$conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__6984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$conj_BANG_.cljs$lang$applyTo = cljs$core$conj_BANG___3.cljs$lang$applyTo;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$0 = cljs$core$conj_BANG___0;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$1 = cljs$core$conj_BANG___1;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$conj_BANG___2;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$conj_BANG_;
})()
;
/**
 * When applied to a transient map, adds mapping of key(s) to
 * val(s). When applied to a transient vector, sets the val at index.
 * Note - index must be <= (count vector). Returns coll.
 * @param {...*} var_args
 */
cljs.core.assoc_BANG_ = (function() {
var cljs$core$assoc_BANG_ = null;
var cljs$core$assoc_BANG___3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});
var cljs$core$assoc_BANG___4 = (function() { 
var G__6986__delegate = function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__6987 = ntcoll;
var G__6988 = cljs.core.first(kvs);
var G__6989 = cljs.core.second(kvs);
var G__6990 = cljs.core.nnext(kvs);
tcoll = G__6987;
key = G__6988;
val = G__6989;
kvs = G__6990;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6986 = function (tcoll,key,val,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__6991__i = 0, G__6991__a = new Array(arguments.length -  3);
while (G__6991__i < G__6991__a.length) {G__6991__a[G__6991__i] = arguments[G__6991__i + 3]; ++G__6991__i;}
  kvs = new cljs.core.IndexedSeq(G__6991__a,0);
} 
return G__6986__delegate.call(this,tcoll,key,val,kvs);};
G__6986.cljs$lang$maxFixedArity = 3;
G__6986.cljs$lang$applyTo = (function (arglist__6992){
var tcoll = cljs.core.first(arglist__6992);
arglist__6992 = cljs.core.next(arglist__6992);
var key = cljs.core.first(arglist__6992);
arglist__6992 = cljs.core.next(arglist__6992);
var val = cljs.core.first(arglist__6992);
var kvs = cljs.core.rest(arglist__6992);
return G__6986__delegate(tcoll,key,val,kvs);
});
G__6986.cljs$core$IFn$_invoke$arity$variadic = G__6986__delegate;
return G__6986;
})()
;
cljs$core$assoc_BANG_ = function(tcoll,key,val,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return cljs$core$assoc_BANG___3.call(this,tcoll,key,val);
default:
var G__6993 = null;
if (arguments.length > 3) {
var G__6994__i = 0, G__6994__a = new Array(arguments.length -  3);
while (G__6994__i < G__6994__a.length) {G__6994__a[G__6994__i] = arguments[G__6994__i + 3]; ++G__6994__i;}
G__6993 = new cljs.core.IndexedSeq(G__6994__a,0);
}
return cljs$core$assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic(tcoll,key,val, G__6993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs$core$assoc_BANG_.cljs$lang$applyTo = cljs$core$assoc_BANG___4.cljs$lang$applyTo;
cljs$core$assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$assoc_BANG___3;
cljs$core$assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$assoc_BANG_;
})()
;
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 * @param {...*} var_args
 */
cljs.core.dissoc_BANG_ = (function() {
var cljs$core$dissoc_BANG_ = null;
var cljs$core$dissoc_BANG___2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});
var cljs$core$dissoc_BANG___3 = (function() { 
var G__6995__delegate = function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__6996 = ntcoll;
var G__6997 = cljs.core.first(ks);
var G__6998 = cljs.core.next(ks);
tcoll = G__6996;
key = G__6997;
ks = G__6998;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6995 = function (tcoll,key,var_args){
var ks = null;
if (arguments.length > 2) {
var G__6999__i = 0, G__6999__a = new Array(arguments.length -  2);
while (G__6999__i < G__6999__a.length) {G__6999__a[G__6999__i] = arguments[G__6999__i + 2]; ++G__6999__i;}
  ks = new cljs.core.IndexedSeq(G__6999__a,0);
} 
return G__6995__delegate.call(this,tcoll,key,ks);};
G__6995.cljs$lang$maxFixedArity = 2;
G__6995.cljs$lang$applyTo = (function (arglist__7000){
var tcoll = cljs.core.first(arglist__7000);
arglist__7000 = cljs.core.next(arglist__7000);
var key = cljs.core.first(arglist__7000);
var ks = cljs.core.rest(arglist__7000);
return G__6995__delegate(tcoll,key,ks);
});
G__6995.cljs$core$IFn$_invoke$arity$variadic = G__6995__delegate;
return G__6995;
})()
;
cljs$core$dissoc_BANG_ = function(tcoll,key,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return cljs$core$dissoc_BANG___2.call(this,tcoll,key);
default:
var G__7001 = null;
if (arguments.length > 2) {
var G__7002__i = 0, G__7002__a = new Array(arguments.length -  2);
while (G__7002__i < G__7002__a.length) {G__7002__a[G__7002__i] = arguments[G__7002__i + 2]; ++G__7002__i;}
G__7001 = new cljs.core.IndexedSeq(G__7002__a,0);
}
return cljs$core$dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,key, G__7001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$dissoc_BANG_.cljs$lang$applyTo = cljs$core$dissoc_BANG___3.cljs$lang$applyTo;
cljs$core$dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$dissoc_BANG___2;
cljs$core$dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$dissoc_BANG_;
})()
;
/**
 * Removes the last item from a transient vector. If
 * the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 * does not contain key(s).
 * @param {...*} var_args
 */
cljs.core.disj_BANG_ = (function() {
var cljs$core$disj_BANG_ = null;
var cljs$core$disj_BANG___2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});
var cljs$core$disj_BANG___3 = (function() { 
var G__7003__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__7004 = ntcoll;
var G__7005 = cljs.core.first(vals);
var G__7006 = cljs.core.next(vals);
tcoll = G__7004;
val = G__7005;
vals = G__7006;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__7003 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__7007__i = 0, G__7007__a = new Array(arguments.length -  2);
while (G__7007__i < G__7007__a.length) {G__7007__a[G__7007__i] = arguments[G__7007__i + 2]; ++G__7007__i;}
  vals = new cljs.core.IndexedSeq(G__7007__a,0);
} 
return G__7003__delegate.call(this,tcoll,val,vals);};
G__7003.cljs$lang$maxFixedArity = 2;
G__7003.cljs$lang$applyTo = (function (arglist__7008){
var tcoll = cljs.core.first(arglist__7008);
arglist__7008 = cljs.core.next(arglist__7008);
var val = cljs.core.first(arglist__7008);
var vals = cljs.core.rest(arglist__7008);
return G__7003__delegate(tcoll,val,vals);
});
G__7003.cljs$core$IFn$_invoke$arity$variadic = G__7003__delegate;
return G__7003;
})()
;
cljs$core$disj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 2:
return cljs$core$disj_BANG___2.call(this,tcoll,val);
default:
var G__7009 = null;
if (arguments.length > 2) {
var G__7010__i = 0, G__7010__a = new Array(arguments.length -  2);
while (G__7010__i < G__7010__a.length) {G__7010__a[G__7010__i] = arguments[G__7010__i + 2]; ++G__7010__i;}
G__7009 = new cljs.core.IndexedSeq(G__7010__a,0);
}
return cljs$core$disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__7009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$disj_BANG_.cljs$lang$applyTo = cljs$core$disj_BANG___3.cljs$lang$applyTo;
cljs$core$disj_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$disj_BANG___2;
cljs$core$disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$disj_BANG_;
})()
;

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a4696 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a4696);
} else {
var G__7221 = a4696;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7221) : f.call(null,G__7221));
}
} else {
var b4697 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a4696,b4697);
} else {
var G__7222 = a4696;
var G__7223 = b4697;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7222,G__7223) : f.call(null,G__7222,G__7223));
}
} else {
var c4698 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a4696,b4697,c4698);
} else {
var G__7224 = a4696;
var G__7225 = b4697;
var G__7226 = c4698;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7224,G__7225,G__7226) : f.call(null,G__7224,G__7225,G__7226));
}
} else {
var d4699 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a4696,b4697,c4698,d4699);
} else {
var G__7227 = a4696;
var G__7228 = b4697;
var G__7229 = c4698;
var G__7230 = d4699;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7227,G__7228,G__7229,G__7230) : f.call(null,G__7227,G__7228,G__7229,G__7230));
}
} else {
var e4700 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a4696,b4697,c4698,d4699,e4700);
} else {
var G__7231 = a4696;
var G__7232 = b4697;
var G__7233 = c4698;
var G__7234 = d4699;
var G__7235 = e4700;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7231,G__7232,G__7233,G__7234,G__7235) : f.call(null,G__7231,G__7232,G__7233,G__7234,G__7235));
}
} else {
var f4701 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a4696,b4697,c4698,d4699,e4700,f4701);
} else {
var G__7236 = a4696;
var G__7237 = b4697;
var G__7238 = c4698;
var G__7239 = d4699;
var G__7240 = e4700;
var G__7241 = f4701;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7236,G__7237,G__7238,G__7239,G__7240,G__7241) : f.call(null,G__7236,G__7237,G__7238,G__7239,G__7240,G__7241));
}
} else {
var g4702 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a4696,b4697,c4698,d4699,e4700,f4701,g4702);
} else {
var G__7242 = a4696;
var G__7243 = b4697;
var G__7244 = c4698;
var G__7245 = d4699;
var G__7246 = e4700;
var G__7247 = f4701;
var G__7248 = g4702;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__7242,G__7243,G__7244,G__7245,G__7246,G__7247,G__7248) : f.call(null,G__7242,G__7243,G__7244,G__7245,G__7246,G__7247,G__7248));
}
} else {
var h4703 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703);
} else {
var G__7249 = a4696;
var G__7250 = b4697;
var G__7251 = c4698;
var G__7252 = d4699;
var G__7253 = e4700;
var G__7254 = f4701;
var G__7255 = g4702;
var G__7256 = h4703;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__7249,G__7250,G__7251,G__7252,G__7253,G__7254,G__7255,G__7256) : f.call(null,G__7249,G__7250,G__7251,G__7252,G__7253,G__7254,G__7255,G__7256));
}
} else {
var i4704 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704);
} else {
var G__7257 = a4696;
var G__7258 = b4697;
var G__7259 = c4698;
var G__7260 = d4699;
var G__7261 = e4700;
var G__7262 = f4701;
var G__7263 = g4702;
var G__7264 = h4703;
var G__7265 = i4704;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__7257,G__7258,G__7259,G__7260,G__7261,G__7262,G__7263,G__7264,G__7265) : f.call(null,G__7257,G__7258,G__7259,G__7260,G__7261,G__7262,G__7263,G__7264,G__7265));
}
} else {
var j4705 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705);
} else {
var G__7266 = a4696;
var G__7267 = b4697;
var G__7268 = c4698;
var G__7269 = d4699;
var G__7270 = e4700;
var G__7271 = f4701;
var G__7272 = g4702;
var G__7273 = h4703;
var G__7274 = i4704;
var G__7275 = j4705;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__7266,G__7267,G__7268,G__7269,G__7270,G__7271,G__7272,G__7273,G__7274,G__7275) : f.call(null,G__7266,G__7267,G__7268,G__7269,G__7270,G__7271,G__7272,G__7273,G__7274,G__7275));
}
} else {
var k4706 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706);
} else {
var G__7276 = a4696;
var G__7277 = b4697;
var G__7278 = c4698;
var G__7279 = d4699;
var G__7280 = e4700;
var G__7281 = f4701;
var G__7282 = g4702;
var G__7283 = h4703;
var G__7284 = i4704;
var G__7285 = j4705;
var G__7286 = k4706;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__7276,G__7277,G__7278,G__7279,G__7280,G__7281,G__7282,G__7283,G__7284,G__7285,G__7286) : f.call(null,G__7276,G__7277,G__7278,G__7279,G__7280,G__7281,G__7282,G__7283,G__7284,G__7285,G__7286));
}
} else {
var l4707 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707);
} else {
var G__7287 = a4696;
var G__7288 = b4697;
var G__7289 = c4698;
var G__7290 = d4699;
var G__7291 = e4700;
var G__7292 = f4701;
var G__7293 = g4702;
var G__7294 = h4703;
var G__7295 = i4704;
var G__7296 = j4705;
var G__7297 = k4706;
var G__7298 = l4707;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__7287,G__7288,G__7289,G__7290,G__7291,G__7292,G__7293,G__7294,G__7295,G__7296,G__7297,G__7298) : f.call(null,G__7287,G__7288,G__7289,G__7290,G__7291,G__7292,G__7293,G__7294,G__7295,G__7296,G__7297,G__7298));
}
} else {
var m4708 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708);
} else {
var G__7299 = a4696;
var G__7300 = b4697;
var G__7301 = c4698;
var G__7302 = d4699;
var G__7303 = e4700;
var G__7304 = f4701;
var G__7305 = g4702;
var G__7306 = h4703;
var G__7307 = i4704;
var G__7308 = j4705;
var G__7309 = k4706;
var G__7310 = l4707;
var G__7311 = m4708;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__7299,G__7300,G__7301,G__7302,G__7303,G__7304,G__7305,G__7306,G__7307,G__7308,G__7309,G__7310,G__7311) : f.call(null,G__7299,G__7300,G__7301,G__7302,G__7303,G__7304,G__7305,G__7306,G__7307,G__7308,G__7309,G__7310,G__7311));
}
} else {
var n4709 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708,n4709);
} else {
var G__7312 = a4696;
var G__7313 = b4697;
var G__7314 = c4698;
var G__7315 = d4699;
var G__7316 = e4700;
var G__7317 = f4701;
var G__7318 = g4702;
var G__7319 = h4703;
var G__7320 = i4704;
var G__7321 = j4705;
var G__7322 = k4706;
var G__7323 = l4707;
var G__7324 = m4708;
var G__7325 = n4709;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__7312,G__7313,G__7314,G__7315,G__7316,G__7317,G__7318,G__7319,G__7320,G__7321,G__7322,G__7323,G__7324,G__7325) : f.call(null,G__7312,G__7313,G__7314,G__7315,G__7316,G__7317,G__7318,G__7319,G__7320,G__7321,G__7322,G__7323,G__7324,G__7325));
}
} else {
var o4710 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708,n4709,o4710);
} else {
var G__7326 = a4696;
var G__7327 = b4697;
var G__7328 = c4698;
var G__7329 = d4699;
var G__7330 = e4700;
var G__7331 = f4701;
var G__7332 = g4702;
var G__7333 = h4703;
var G__7334 = i4704;
var G__7335 = j4705;
var G__7336 = k4706;
var G__7337 = l4707;
var G__7338 = m4708;
var G__7339 = n4709;
var G__7340 = o4710;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__7326,G__7327,G__7328,G__7329,G__7330,G__7331,G__7332,G__7333,G__7334,G__7335,G__7336,G__7337,G__7338,G__7339,G__7340) : f.call(null,G__7326,G__7327,G__7328,G__7329,G__7330,G__7331,G__7332,G__7333,G__7334,G__7335,G__7336,G__7337,G__7338,G__7339,G__7340));
}
} else {
var p4711 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708,n4709,o4710,p4711);
} else {
var G__7341 = a4696;
var G__7342 = b4697;
var G__7343 = c4698;
var G__7344 = d4699;
var G__7345 = e4700;
var G__7346 = f4701;
var G__7347 = g4702;
var G__7348 = h4703;
var G__7349 = i4704;
var G__7350 = j4705;
var G__7351 = k4706;
var G__7352 = l4707;
var G__7353 = m4708;
var G__7354 = n4709;
var G__7355 = o4710;
var G__7356 = p4711;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__7341,G__7342,G__7343,G__7344,G__7345,G__7346,G__7347,G__7348,G__7349,G__7350,G__7351,G__7352,G__7353,G__7354,G__7355,G__7356) : f.call(null,G__7341,G__7342,G__7343,G__7344,G__7345,G__7346,G__7347,G__7348,G__7349,G__7350,G__7351,G__7352,G__7353,G__7354,G__7355,G__7356));
}
} else {
var q4712 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708,n4709,o4710,p4711,q4712);
} else {
var G__7357 = a4696;
var G__7358 = b4697;
var G__7359 = c4698;
var G__7360 = d4699;
var G__7361 = e4700;
var G__7362 = f4701;
var G__7363 = g4702;
var G__7364 = h4703;
var G__7365 = i4704;
var G__7366 = j4705;
var G__7367 = k4706;
var G__7368 = l4707;
var G__7369 = m4708;
var G__7370 = n4709;
var G__7371 = o4710;
var G__7372 = p4711;
var G__7373 = q4712;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__7357,G__7358,G__7359,G__7360,G__7361,G__7362,G__7363,G__7364,G__7365,G__7366,G__7367,G__7368,G__7369,G__7370,G__7371,G__7372,G__7373) : f.call(null,G__7357,G__7358,G__7359,G__7360,G__7361,G__7362,G__7363,G__7364,G__7365,G__7366,G__7367,G__7368,G__7369,G__7370,G__7371,G__7372,G__7373));
}
} else {
var r4713 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708,n4709,o4710,p4711,q4712,r4713);
} else {
var G__7374 = a4696;
var G__7375 = b4697;
var G__7376 = c4698;
var G__7377 = d4699;
var G__7378 = e4700;
var G__7379 = f4701;
var G__7380 = g4702;
var G__7381 = h4703;
var G__7382 = i4704;
var G__7383 = j4705;
var G__7384 = k4706;
var G__7385 = l4707;
var G__7386 = m4708;
var G__7387 = n4709;
var G__7388 = o4710;
var G__7389 = p4711;
var G__7390 = q4712;
var G__7391 = r4713;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__7374,G__7375,G__7376,G__7377,G__7378,G__7379,G__7380,G__7381,G__7382,G__7383,G__7384,G__7385,G__7386,G__7387,G__7388,G__7389,G__7390,G__7391) : f.call(null,G__7374,G__7375,G__7376,G__7377,G__7378,G__7379,G__7380,G__7381,G__7382,G__7383,G__7384,G__7385,G__7386,G__7387,G__7388,G__7389,G__7390,G__7391));
}
} else {
var s4714 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708,n4709,o4710,p4711,q4712,r4713,s4714);
} else {
var G__7392 = a4696;
var G__7393 = b4697;
var G__7394 = c4698;
var G__7395 = d4699;
var G__7396 = e4700;
var G__7397 = f4701;
var G__7398 = g4702;
var G__7399 = h4703;
var G__7400 = i4704;
var G__7401 = j4705;
var G__7402 = k4706;
var G__7403 = l4707;
var G__7404 = m4708;
var G__7405 = n4709;
var G__7406 = o4710;
var G__7407 = p4711;
var G__7408 = q4712;
var G__7409 = r4713;
var G__7410 = s4714;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__7392,G__7393,G__7394,G__7395,G__7396,G__7397,G__7398,G__7399,G__7400,G__7401,G__7402,G__7403,G__7404,G__7405,G__7406,G__7407,G__7408,G__7409,G__7410) : f.call(null,G__7392,G__7393,G__7394,G__7395,G__7396,G__7397,G__7398,G__7399,G__7400,G__7401,G__7402,G__7403,G__7404,G__7405,G__7406,G__7407,G__7408,G__7409,G__7410));
}
} else {
var t4715 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a4696,b4697,c4698,d4699,e4700,f4701,g4702,h4703,i4704,j4705,k4706,l4707,m4708,n4709,o4710,p4711,q4712,r4713,s4714,t4715);
} else {
var G__7411 = a4696;
var G__7412 = b4697;
var G__7413 = c4698;
var G__7414 = d4699;
var G__7415 = e4700;
var G__7416 = f4701;
var G__7417 = g4702;
var G__7418 = h4703;
var G__7419 = i4704;
var G__7420 = j4705;
var G__7421 = k4706;
var G__7422 = l4707;
var G__7423 = m4708;
var G__7424 = n4709;
var G__7425 = o4710;
var G__7426 = p4711;
var G__7427 = q4712;
var G__7428 = r4713;
var G__7429 = s4714;
var G__7430 = t4715;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__7411,G__7412,G__7413,G__7414,G__7415,G__7416,G__7417,G__7418,G__7419,G__7420,G__7421,G__7422,G__7423,G__7424,G__7425,G__7426,G__7427,G__7428,G__7429,G__7430) : f.call(null,G__7411,G__7412,G__7413,G__7414,G__7415,G__7416,G__7417,G__7418,G__7419,G__7420,G__7421,G__7422,G__7423,G__7424,G__7425,G__7426,G__7427,G__7428,G__7429,G__7430));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 * @param {...*} var_args
 */
cljs.core.apply = (function() {
var cljs$core$apply = null;
var cljs$core$apply__2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});
var cljs$core$apply__3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__6 = (function() { 
var G__7431__delegate = function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
};
var G__7431 = function (f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 5) {
var G__7432__i = 0, G__7432__a = new Array(arguments.length -  5);
while (G__7432__i < G__7432__a.length) {G__7432__a[G__7432__i] = arguments[G__7432__i + 5]; ++G__7432__i;}
  args = new cljs.core.IndexedSeq(G__7432__a,0);
} 
return G__7431__delegate.call(this,f,a,b,c,d,args);};
G__7431.cljs$lang$maxFixedArity = 5;
G__7431.cljs$lang$applyTo = (function (arglist__7433){
var f = cljs.core.first(arglist__7433);
arglist__7433 = cljs.core.next(arglist__7433);
var a = cljs.core.first(arglist__7433);
arglist__7433 = cljs.core.next(arglist__7433);
var b = cljs.core.first(arglist__7433);
arglist__7433 = cljs.core.next(arglist__7433);
var c = cljs.core.first(arglist__7433);
arglist__7433 = cljs.core.next(arglist__7433);
var d = cljs.core.first(arglist__7433);
var args = cljs.core.rest(arglist__7433);
return G__7431__delegate(f,a,b,c,d,args);
});
G__7431.cljs$core$IFn$_invoke$arity$variadic = G__7431__delegate;
return G__7431;
})()
;
cljs$core$apply = function(f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return cljs$core$apply__2.call(this,f,a);
case 3:
return cljs$core$apply__3.call(this,f,a,b);
case 4:
return cljs$core$apply__4.call(this,f,a,b,c);
case 5:
return cljs$core$apply__5.call(this,f,a,b,c,d);
default:
var G__7434 = null;
if (arguments.length > 5) {
var G__7435__i = 0, G__7435__a = new Array(arguments.length -  5);
while (G__7435__i < G__7435__a.length) {G__7435__a[G__7435__i] = arguments[G__7435__i + 5]; ++G__7435__i;}
G__7434 = new cljs.core.IndexedSeq(G__7435__a,0);
}
return cljs$core$apply__6.cljs$core$IFn$_invoke$arity$variadic(f,a,b,c,d, G__7434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$apply.cljs$lang$maxFixedArity = 5;
cljs$core$apply.cljs$lang$applyTo = cljs$core$apply__6.cljs$lang$applyTo;
cljs$core$apply.cljs$core$IFn$_invoke$arity$2 = cljs$core$apply__2;
cljs$core$apply.cljs$core$IFn$_invoke$arity$3 = cljs$core$apply__3;
cljs$core$apply.cljs$core$IFn$_invoke$arity$4 = cljs$core$apply__4;
cljs$core$apply.cljs$core$IFn$_invoke$arity$5 = cljs$core$apply__5;
cljs$core$apply.cljs$core$IFn$_invoke$arity$variadic = cljs$core$apply__6.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$apply;
})()
;
/**
 * Returns an object of the same type and value as obj, with
 * (apply f (meta obj) args) as its metadata.
 * @param {...*} var_args
 */
cljs.core.vary_meta = (function() {
var cljs$core$vary_meta = null;
var cljs$core$vary_meta__2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__7451 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7451) : f.call(null,G__7451));
})());
});
var cljs$core$vary_meta__3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__7452 = cljs.core.meta(obj);
var G__7453 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7452,G__7453) : f.call(null,G__7452,G__7453));
})());
});
var cljs$core$vary_meta__4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__7454 = cljs.core.meta(obj);
var G__7455 = a;
var G__7456 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7454,G__7455,G__7456) : f.call(null,G__7454,G__7455,G__7456));
})());
});
var cljs$core$vary_meta__5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__7457 = cljs.core.meta(obj);
var G__7458 = a;
var G__7459 = b;
var G__7460 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7457,G__7458,G__7459,G__7460) : f.call(null,G__7457,G__7458,G__7459,G__7460));
})());
});
var cljs$core$vary_meta__6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__7461 = cljs.core.meta(obj);
var G__7462 = a;
var G__7463 = b;
var G__7464 = c;
var G__7465 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7461,G__7462,G__7463,G__7464,G__7465) : f.call(null,G__7461,G__7462,G__7463,G__7464,G__7465));
})());
});
var cljs$core$vary_meta__7 = (function() { 
var G__7466__delegate = function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
};
var G__7466 = function (obj,f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 6) {
var G__7467__i = 0, G__7467__a = new Array(arguments.length -  6);
while (G__7467__i < G__7467__a.length) {G__7467__a[G__7467__i] = arguments[G__7467__i + 6]; ++G__7467__i;}
  args = new cljs.core.IndexedSeq(G__7467__a,0);
} 
return G__7466__delegate.call(this,obj,f,a,b,c,d,args);};
G__7466.cljs$lang$maxFixedArity = 6;
G__7466.cljs$lang$applyTo = (function (arglist__7468){
var obj = cljs.core.first(arglist__7468);
arglist__7468 = cljs.core.next(arglist__7468);
var f = cljs.core.first(arglist__7468);
arglist__7468 = cljs.core.next(arglist__7468);
var a = cljs.core.first(arglist__7468);
arglist__7468 = cljs.core.next(arglist__7468);
var b = cljs.core.first(arglist__7468);
arglist__7468 = cljs.core.next(arglist__7468);
var c = cljs.core.first(arglist__7468);
arglist__7468 = cljs.core.next(arglist__7468);
var d = cljs.core.first(arglist__7468);
var args = cljs.core.rest(arglist__7468);
return G__7466__delegate(obj,f,a,b,c,d,args);
});
G__7466.cljs$core$IFn$_invoke$arity$variadic = G__7466__delegate;
return G__7466;
})()
;
cljs$core$vary_meta = function(obj,f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return cljs$core$vary_meta__2.call(this,obj,f);
case 3:
return cljs$core$vary_meta__3.call(this,obj,f,a);
case 4:
return cljs$core$vary_meta__4.call(this,obj,f,a,b);
case 5:
return cljs$core$vary_meta__5.call(this,obj,f,a,b,c);
case 6:
return cljs$core$vary_meta__6.call(this,obj,f,a,b,c,d);
default:
var G__7469 = null;
if (arguments.length > 6) {
var G__7470__i = 0, G__7470__a = new Array(arguments.length -  6);
while (G__7470__i < G__7470__a.length) {G__7470__a[G__7470__i] = arguments[G__7470__i + 6]; ++G__7470__i;}
G__7469 = new cljs.core.IndexedSeq(G__7470__a,0);
}
return cljs$core$vary_meta__7.cljs$core$IFn$_invoke$arity$variadic(obj,f,a,b,c,d, G__7469);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$vary_meta.cljs$lang$maxFixedArity = 6;
cljs$core$vary_meta.cljs$lang$applyTo = cljs$core$vary_meta__7.cljs$lang$applyTo;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$2 = cljs$core$vary_meta__2;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$3 = cljs$core$vary_meta__3;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$4 = cljs$core$vary_meta__4;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$5 = cljs$core$vary_meta__5;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$6 = cljs$core$vary_meta__6;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$variadic = cljs$core$vary_meta__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$vary_meta;
})()
;
/**
 * Same as (not (= obj1 obj2))
 * @param {...*} var_args
 */
cljs.core.not_EQ_ = (function() {
var cljs$core$not_EQ_ = null;
var cljs$core$not_EQ___1 = (function (x){
return false;
});
var cljs$core$not_EQ___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var cljs$core$not_EQ___3 = (function() { 
var G__7471__delegate = function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
};
var G__7471 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7472__i = 0, G__7472__a = new Array(arguments.length -  2);
while (G__7472__i < G__7472__a.length) {G__7472__a[G__7472__i] = arguments[G__7472__i + 2]; ++G__7472__i;}
  more = new cljs.core.IndexedSeq(G__7472__a,0);
} 
return G__7471__delegate.call(this,x,y,more);};
G__7471.cljs$lang$maxFixedArity = 2;
G__7471.cljs$lang$applyTo = (function (arglist__7473){
var x = cljs.core.first(arglist__7473);
arglist__7473 = cljs.core.next(arglist__7473);
var y = cljs.core.first(arglist__7473);
var more = cljs.core.rest(arglist__7473);
return G__7471__delegate(x,y,more);
});
G__7471.cljs$core$IFn$_invoke$arity$variadic = G__7471__delegate;
return G__7471;
})()
;
cljs$core$not_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$not_EQ___1.call(this,x);
case 2:
return cljs$core$not_EQ___2.call(this,x,y);
default:
var G__7474 = null;
if (arguments.length > 2) {
var G__7475__i = 0, G__7475__a = new Array(arguments.length -  2);
while (G__7475__i < G__7475__a.length) {G__7475__a[G__7475__i] = arguments[G__7475__i + 2]; ++G__7475__i;}
G__7474 = new cljs.core.IndexedSeq(G__7475__a,0);
}
return cljs$core$not_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$not_EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$not_EQ_.cljs$lang$applyTo = cljs$core$not_EQ___3.cljs$lang$applyTo;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$not_EQ___1;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$not_EQ___2;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$not_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$not_EQ_;
})()
;
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t7479 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t7479 = (function (nil_iter,meta7480){
this.nil_iter = nil_iter;
this.meta7480 = meta7480;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.t7479.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t7479.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t7479.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t7479.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_7481){
var self__ = this;
var _7481__$1 = this;
return self__.meta7480;
});

cljs.core.t7479.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_7481,meta7480__$1){
var self__ = this;
var _7481__$1 = this;
return (new cljs.core.t7479(self__.nil_iter,meta7480__$1));
});

cljs.core.t7479.cljs$lang$type = true;

cljs.core.t7479.cljs$lang$ctorStr = "cljs.core/t7479";

cljs.core.t7479.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/t7479");
});

cljs.core.__GT_t7479 = (function cljs$core$nil_iter_$___GT_t7479(nil_iter__$1,meta7480){
return (new cljs.core.t7479(nil_iter__$1,meta7480));
});

}

return (new cljs.core.t7479(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3755__auto__ = !((lt.stepper == null));
if(and__3755__auto__){
return self__.iter.hasNext();
} else {
return and__3755__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__7482 = lt;
var G__7483 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__7482,G__7483) : self__.xform.call(null,G__7482,G__7483));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__7484 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__7484) : self__.xform.call(null,G__7484));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__7486 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7486) : xform.call(null,G__7486));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__7488 = cljs.core.next(iters__$1);
iters__$1 = G__7488;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__4652__auto___7489 = self__.iters.length;
var i_7490 = (0);
while(true){
if((i_7490 < n__4652__auto___7489)){
(self__.nexts[i_7490] = (self__.iters[i_7490]).next());

var G__7491 = (i_7490 + (1));
i_7490 = G__7491;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3755__auto__ = !((lt.stepper == null));
if(and__3755__auto__){
return this$.hasNext();
} else {
return and__3755__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__7487 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__7487) : self__.xform.call(null,G__7487));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function() {
var cljs$core$multi_stepper = null;
var cljs$core$multi_stepper__2 = (function (xform,iters){
return cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});
var cljs$core$multi_stepper__3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$multi_stepper_$_stepfn = null;
var cljs$core$multi_stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$multi_stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$multi_stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$multi_stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$multi_stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$multi_stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$multi_stepper_$_stepfn__1;
cljs$core$multi_stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$multi_stepper_$_stepfn__2;
return cljs$core$multi_stepper_$_stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__7496 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7496) : xform.call(null,G__7496));
})(),iters,nexts));
});
cljs$core$multi_stepper = function(xform,iters,nexts){
switch(arguments.length){
case 2:
return cljs$core$multi_stepper__2.call(this,xform,iters);
case 3:
return cljs$core$multi_stepper__3.call(this,xform,iters,nexts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$2 = cljs$core$multi_stepper__2;
cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$3 = cljs$core$multi_stepper__3;
return cljs$core$multi_stepper;
})()
;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
})
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__7497_7501 = cljs.core.seq(colls);
var chunk__7498_7502 = null;
var count__7499_7503 = (0);
var i__7500_7504 = (0);
while(true){
if((i__7500_7504 < count__7499_7503)){
var coll_7505 = chunk__7498_7502.cljs$core$IIndexed$_nth$arity$2(null,i__7500_7504);
iters.push(cljs.core.iter(coll_7505));

var G__7506 = seq__7497_7501;
var G__7507 = chunk__7498_7502;
var G__7508 = count__7499_7503;
var G__7509 = (i__7500_7504 + (1));
seq__7497_7501 = G__7506;
chunk__7498_7502 = G__7507;
count__7499_7503 = G__7508;
i__7500_7504 = G__7509;
continue;
} else {
var temp__4126__auto___7510 = cljs.core.seq(seq__7497_7501);
if(temp__4126__auto___7510){
var seq__7497_7511__$1 = temp__4126__auto___7510;
if(cljs.core.chunked_seq_QMARK_(seq__7497_7511__$1)){
var c__4552__auto___7512 = cljs.core.chunk_first(seq__7497_7511__$1);
var G__7513 = cljs.core.chunk_rest(seq__7497_7511__$1);
var G__7514 = c__4552__auto___7512;
var G__7515 = cljs.core.count(c__4552__auto___7512);
var G__7516 = (0);
seq__7497_7501 = G__7513;
chunk__7498_7502 = G__7514;
count__7499_7503 = G__7515;
i__7500_7504 = G__7516;
continue;
} else {
var coll_7517 = cljs.core.first(seq__7497_7511__$1);
iters.push(cljs.core.iter(coll_7517));

var G__7518 = cljs.core.next(seq__7497_7511__$1);
var G__7519 = null;
var G__7520 = (0);
var G__7521 = (0);
seq__7497_7501 = G__7518;
chunk__7498_7502 = G__7519;
count__7499_7503 = G__7520;
i__7500_7504 = G__7521;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 * one. Will not force a lazy seq. (sequence nil) yields (), When a
 * transducer is supplied, returns a lazy sequence of applications of
 * the transform to the items in coll(s), i.e. to the set of first
 * items of each coll, followed by the set of second
 * items in each coll, until any one of the colls is exhausted.  Any
 * remaining items in other colls are ignored. The transform should accept
 * number-of-colls arguments
 * @param {...*} var_args
 */
cljs.core.sequence = (function() {
var cljs$core$sequence = null;
var cljs$core$sequence__1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__3767__auto__ = cljs.core.seq(coll);
if(or__3767__auto__){
return or__3767__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});
var cljs$core$sequence__2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});
var cljs$core$sequence__3 = (function() { 
var G__7522__delegate = function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
};
var G__7522 = function (xform,coll,var_args){
var colls = null;
if (arguments.length > 2) {
var G__7523__i = 0, G__7523__a = new Array(arguments.length -  2);
while (G__7523__i < G__7523__a.length) {G__7523__a[G__7523__i] = arguments[G__7523__i + 2]; ++G__7523__i;}
  colls = new cljs.core.IndexedSeq(G__7523__a,0);
} 
return G__7522__delegate.call(this,xform,coll,colls);};
G__7522.cljs$lang$maxFixedArity = 2;
G__7522.cljs$lang$applyTo = (function (arglist__7524){
var xform = cljs.core.first(arglist__7524);
arglist__7524 = cljs.core.next(arglist__7524);
var coll = cljs.core.first(arglist__7524);
var colls = cljs.core.rest(arglist__7524);
return G__7522__delegate(xform,coll,colls);
});
G__7522.cljs$core$IFn$_invoke$arity$variadic = G__7522__delegate;
return G__7522;
})()
;
cljs$core$sequence = function(xform,coll,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$sequence__1.call(this,xform);
case 2:
return cljs$core$sequence__2.call(this,xform,coll);
default:
var G__7525 = null;
if (arguments.length > 2) {
var G__7526__i = 0, G__7526__a = new Array(arguments.length -  2);
while (G__7526__i < G__7526__a.length) {G__7526__a[G__7526__i] = arguments[G__7526__i + 2]; ++G__7526__i;}
G__7525 = new cljs.core.IndexedSeq(G__7526__a,0);
}
return cljs$core$sequence__3.cljs$core$IFn$_invoke$arity$variadic(xform,coll, G__7525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sequence.cljs$lang$maxFixedArity = 2;
cljs$core$sequence.cljs$lang$applyTo = cljs$core$sequence__3.cljs$lang$applyTo;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$1 = cljs$core$sequence__1;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$2 = cljs$core$sequence__2;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sequence__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sequence;
})()
;
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 * false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__7528 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__7528) : pred.call(null,G__7528));
})())){
var G__7529 = pred;
var G__7530 = cljs.core.next(coll);
pred = G__7529;
coll = G__7530;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 * coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 * else nil.  One common idiom is to use a set as pred, for example
 * this will return :fred if :fred is in the sequence, otherwise nil:
 * (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__3767__auto__ = (function (){var G__7534 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__7534) : pred.call(null,G__7534));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var G__7535 = pred;
var G__7536 = cljs.core.next(coll);
pred = G__7535;
coll = G__7536;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 * else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 * has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__7543 = null;
var G__7543__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__7543__1 = (function (x){
return cljs.core.not((function (){var G__7540 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7540) : f.call(null,G__7540));
})());
});
var G__7543__2 = (function (x,y){
return cljs.core.not((function (){var G__7541 = x;
var G__7542 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7541,G__7542) : f.call(null,G__7541,G__7542));
})());
});
var G__7543__3 = (function() { 
var G__7544__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__7544 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__7545__i = 0, G__7545__a = new Array(arguments.length -  2);
while (G__7545__i < G__7545__a.length) {G__7545__a[G__7545__i] = arguments[G__7545__i + 2]; ++G__7545__i;}
  zs = new cljs.core.IndexedSeq(G__7545__a,0);
} 
return G__7544__delegate.call(this,x,y,zs);};
G__7544.cljs$lang$maxFixedArity = 2;
G__7544.cljs$lang$applyTo = (function (arglist__7546){
var x = cljs.core.first(arglist__7546);
arglist__7546 = cljs.core.next(arglist__7546);
var y = cljs.core.first(arglist__7546);
var zs = cljs.core.rest(arglist__7546);
return G__7544__delegate(x,y,zs);
});
G__7544.cljs$core$IFn$_invoke$arity$variadic = G__7544__delegate;
return G__7544;
})()
;
G__7543 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__7543__0.call(this);
case 1:
return G__7543__1.call(this,x);
case 2:
return G__7543__2.call(this,x,y);
default:
var G__7547 = null;
if (arguments.length > 2) {
var G__7548__i = 0, G__7548__a = new Array(arguments.length -  2);
while (G__7548__i < G__7548__a.length) {G__7548__a[G__7548__i] = arguments[G__7548__i + 2]; ++G__7548__i;}
G__7547 = new cljs.core.IndexedSeq(G__7548__a,0);
}
return G__7543__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7543.cljs$lang$maxFixedArity = 2;
G__7543.cljs$lang$applyTo = G__7543__3.cljs$lang$applyTo;
G__7543.cljs$core$IFn$_invoke$arity$0 = G__7543__0;
G__7543.cljs$core$IFn$_invoke$arity$1 = G__7543__1;
G__7543.cljs$core$IFn$_invoke$arity$2 = G__7543__2;
G__7543.cljs$core$IFn$_invoke$arity$variadic = G__7543__3.cljs$core$IFn$_invoke$arity$variadic;
return G__7543;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__7549__delegate = function (args){
return x;
};
var G__7549 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7550__i = 0, G__7550__a = new Array(arguments.length -  0);
while (G__7550__i < G__7550__a.length) {G__7550__a[G__7550__i] = arguments[G__7550__i + 0]; ++G__7550__i;}
  args = new cljs.core.IndexedSeq(G__7550__a,0);
} 
return G__7549__delegate.call(this,args);};
G__7549.cljs$lang$maxFixedArity = 0;
G__7549.cljs$lang$applyTo = (function (arglist__7551){
var args = cljs.core.seq(arglist__7551);
return G__7549__delegate(args);
});
G__7549.cljs$core$IFn$_invoke$arity$variadic = G__7549__delegate;
return G__7549;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 * of those fns.  The returned fn takes a variable number of args,
 * applies the rightmost of fns to the args, the next
 * fn (right-to-left) to the result, etc.
 * @param {...*} var_args
 */
cljs.core.comp = (function() {
var cljs$core$comp = null;
var cljs$core$comp__0 = (function (){
return cljs.core.identity;
});
var cljs$core$comp__1 = (function (f){
return f;
});
var cljs$core$comp__2 = (function (f,g){
return (function() {
var G__7606 = null;
var G__7606__0 = (function (){
var G__7579 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7579) : f.call(null,G__7579));
});
var G__7606__1 = (function (x){
var G__7580 = (function (){var G__7581 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7581) : g.call(null,G__7581));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7580) : f.call(null,G__7580));
});
var G__7606__2 = (function (x,y){
var G__7582 = (function (){var G__7583 = x;
var G__7584 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__7583,G__7584) : g.call(null,G__7583,G__7584));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7582) : f.call(null,G__7582));
});
var G__7606__3 = (function (x,y,z){
var G__7585 = (function (){var G__7586 = x;
var G__7587 = y;
var G__7588 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__7586,G__7587,G__7588) : g.call(null,G__7586,G__7587,G__7588));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7585) : f.call(null,G__7585));
});
var G__7606__4 = (function() { 
var G__7607__delegate = function (x,y,z,args){
var G__7589 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7589) : f.call(null,G__7589));
};
var G__7607 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7608__i = 0, G__7608__a = new Array(arguments.length -  3);
while (G__7608__i < G__7608__a.length) {G__7608__a[G__7608__i] = arguments[G__7608__i + 3]; ++G__7608__i;}
  args = new cljs.core.IndexedSeq(G__7608__a,0);
} 
return G__7607__delegate.call(this,x,y,z,args);};
G__7607.cljs$lang$maxFixedArity = 3;
G__7607.cljs$lang$applyTo = (function (arglist__7609){
var x = cljs.core.first(arglist__7609);
arglist__7609 = cljs.core.next(arglist__7609);
var y = cljs.core.first(arglist__7609);
arglist__7609 = cljs.core.next(arglist__7609);
var z = cljs.core.first(arglist__7609);
var args = cljs.core.rest(arglist__7609);
return G__7607__delegate(x,y,z,args);
});
G__7607.cljs$core$IFn$_invoke$arity$variadic = G__7607__delegate;
return G__7607;
})()
;
G__7606 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7606__0.call(this);
case 1:
return G__7606__1.call(this,x);
case 2:
return G__7606__2.call(this,x,y);
case 3:
return G__7606__3.call(this,x,y,z);
default:
var G__7610 = null;
if (arguments.length > 3) {
var G__7611__i = 0, G__7611__a = new Array(arguments.length -  3);
while (G__7611__i < G__7611__a.length) {G__7611__a[G__7611__i] = arguments[G__7611__i + 3]; ++G__7611__i;}
G__7610 = new cljs.core.IndexedSeq(G__7611__a,0);
}
return G__7606__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7606.cljs$lang$maxFixedArity = 3;
G__7606.cljs$lang$applyTo = G__7606__4.cljs$lang$applyTo;
G__7606.cljs$core$IFn$_invoke$arity$0 = G__7606__0;
G__7606.cljs$core$IFn$_invoke$arity$1 = G__7606__1;
G__7606.cljs$core$IFn$_invoke$arity$2 = G__7606__2;
G__7606.cljs$core$IFn$_invoke$arity$3 = G__7606__3;
G__7606.cljs$core$IFn$_invoke$arity$variadic = G__7606__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7606;
})()
});
var cljs$core$comp__3 = (function (f,g,h){
return (function() {
var G__7612 = null;
var G__7612__0 = (function (){
var G__7590 = (function (){var G__7591 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7591) : g.call(null,G__7591));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7590) : f.call(null,G__7590));
});
var G__7612__1 = (function (x){
var G__7592 = (function (){var G__7593 = (function (){var G__7594 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__7594) : h.call(null,G__7594));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7593) : g.call(null,G__7593));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7592) : f.call(null,G__7592));
});
var G__7612__2 = (function (x,y){
var G__7595 = (function (){var G__7596 = (function (){var G__7597 = x;
var G__7598 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__7597,G__7598) : h.call(null,G__7597,G__7598));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7596) : g.call(null,G__7596));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7595) : f.call(null,G__7595));
});
var G__7612__3 = (function (x,y,z){
var G__7599 = (function (){var G__7600 = (function (){var G__7601 = x;
var G__7602 = y;
var G__7603 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__7601,G__7602,G__7603) : h.call(null,G__7601,G__7602,G__7603));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7600) : g.call(null,G__7600));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7599) : f.call(null,G__7599));
});
var G__7612__4 = (function() { 
var G__7613__delegate = function (x,y,z,args){
var G__7604 = (function (){var G__7605 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7605) : g.call(null,G__7605));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7604) : f.call(null,G__7604));
};
var G__7613 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7614__i = 0, G__7614__a = new Array(arguments.length -  3);
while (G__7614__i < G__7614__a.length) {G__7614__a[G__7614__i] = arguments[G__7614__i + 3]; ++G__7614__i;}
  args = new cljs.core.IndexedSeq(G__7614__a,0);
} 
return G__7613__delegate.call(this,x,y,z,args);};
G__7613.cljs$lang$maxFixedArity = 3;
G__7613.cljs$lang$applyTo = (function (arglist__7615){
var x = cljs.core.first(arglist__7615);
arglist__7615 = cljs.core.next(arglist__7615);
var y = cljs.core.first(arglist__7615);
arglist__7615 = cljs.core.next(arglist__7615);
var z = cljs.core.first(arglist__7615);
var args = cljs.core.rest(arglist__7615);
return G__7613__delegate(x,y,z,args);
});
G__7613.cljs$core$IFn$_invoke$arity$variadic = G__7613__delegate;
return G__7613;
})()
;
G__7612 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7612__0.call(this);
case 1:
return G__7612__1.call(this,x);
case 2:
return G__7612__2.call(this,x,y);
case 3:
return G__7612__3.call(this,x,y,z);
default:
var G__7616 = null;
if (arguments.length > 3) {
var G__7617__i = 0, G__7617__a = new Array(arguments.length -  3);
while (G__7617__i < G__7617__a.length) {G__7617__a[G__7617__i] = arguments[G__7617__i + 3]; ++G__7617__i;}
G__7616 = new cljs.core.IndexedSeq(G__7617__a,0);
}
return G__7612__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7612.cljs$lang$maxFixedArity = 3;
G__7612.cljs$lang$applyTo = G__7612__4.cljs$lang$applyTo;
G__7612.cljs$core$IFn$_invoke$arity$0 = G__7612__0;
G__7612.cljs$core$IFn$_invoke$arity$1 = G__7612__1;
G__7612.cljs$core$IFn$_invoke$arity$2 = G__7612__2;
G__7612.cljs$core$IFn$_invoke$arity$3 = G__7612__3;
G__7612.cljs$core$IFn$_invoke$arity$variadic = G__7612__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7612;
})()
});
var cljs$core$comp__4 = (function() { 
var G__7618__delegate = function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__7619__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__7620 = cljs.core.first(fs__$2).call(null,ret);
var G__7621 = cljs.core.next(fs__$2);
ret = G__7620;
fs__$2 = G__7621;
continue;
} else {
return ret;
}
break;
}
};
var G__7619 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7622__i = 0, G__7622__a = new Array(arguments.length -  0);
while (G__7622__i < G__7622__a.length) {G__7622__a[G__7622__i] = arguments[G__7622__i + 0]; ++G__7622__i;}
  args = new cljs.core.IndexedSeq(G__7622__a,0);
} 
return G__7619__delegate.call(this,args);};
G__7619.cljs$lang$maxFixedArity = 0;
G__7619.cljs$lang$applyTo = (function (arglist__7623){
var args = cljs.core.seq(arglist__7623);
return G__7619__delegate(args);
});
G__7619.cljs$core$IFn$_invoke$arity$variadic = G__7619__delegate;
return G__7619;
})()
;
;})(fs__$1))
};
var G__7618 = function (f1,f2,f3,var_args){
var fs = null;
if (arguments.length > 3) {
var G__7624__i = 0, G__7624__a = new Array(arguments.length -  3);
while (G__7624__i < G__7624__a.length) {G__7624__a[G__7624__i] = arguments[G__7624__i + 3]; ++G__7624__i;}
  fs = new cljs.core.IndexedSeq(G__7624__a,0);
} 
return G__7618__delegate.call(this,f1,f2,f3,fs);};
G__7618.cljs$lang$maxFixedArity = 3;
G__7618.cljs$lang$applyTo = (function (arglist__7625){
var f1 = cljs.core.first(arglist__7625);
arglist__7625 = cljs.core.next(arglist__7625);
var f2 = cljs.core.first(arglist__7625);
arglist__7625 = cljs.core.next(arglist__7625);
var f3 = cljs.core.first(arglist__7625);
var fs = cljs.core.rest(arglist__7625);
return G__7618__delegate(f1,f2,f3,fs);
});
G__7618.cljs$core$IFn$_invoke$arity$variadic = G__7618__delegate;
return G__7618;
})()
;
cljs$core$comp = function(f1,f2,f3,var_args){
var fs = var_args;
switch(arguments.length){
case 0:
return cljs$core$comp__0.call(this);
case 1:
return cljs$core$comp__1.call(this,f1);
case 2:
return cljs$core$comp__2.call(this,f1,f2);
case 3:
return cljs$core$comp__3.call(this,f1,f2,f3);
default:
var G__7626 = null;
if (arguments.length > 3) {
var G__7627__i = 0, G__7627__a = new Array(arguments.length -  3);
while (G__7627__i < G__7627__a.length) {G__7627__a[G__7627__i] = arguments[G__7627__i + 3]; ++G__7627__i;}
G__7626 = new cljs.core.IndexedSeq(G__7627__a,0);
}
return cljs$core$comp__4.cljs$core$IFn$_invoke$arity$variadic(f1,f2,f3, G__7626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$comp.cljs$lang$maxFixedArity = 3;
cljs$core$comp.cljs$lang$applyTo = cljs$core$comp__4.cljs$lang$applyTo;
cljs$core$comp.cljs$core$IFn$_invoke$arity$0 = cljs$core$comp__0;
cljs$core$comp.cljs$core$IFn$_invoke$arity$1 = cljs$core$comp__1;
cljs$core$comp.cljs$core$IFn$_invoke$arity$2 = cljs$core$comp__2;
cljs$core$comp.cljs$core$IFn$_invoke$arity$3 = cljs$core$comp__3;
cljs$core$comp.cljs$core$IFn$_invoke$arity$variadic = cljs$core$comp__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$comp;
})()
;
/**
 * Takes a function f and fewer than the normal arguments to f, and
 * returns a fn that takes a variable number of additional args. When
 * called, the returned function calls f with args + additional args.
 * @param {...*} var_args
 */
cljs.core.partial = (function() {
var cljs$core$partial = null;
var cljs$core$partial__1 = (function (f){
return f;
});
var cljs$core$partial__2 = (function (f,arg1){
return (function() {
var G__7712 = null;
var G__7712__0 = (function (){
var G__7670 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7670) : f.call(null,G__7670));
});
var G__7712__1 = (function (x){
var G__7671 = arg1;
var G__7672 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7671,G__7672) : f.call(null,G__7671,G__7672));
});
var G__7712__2 = (function (x,y){
var G__7673 = arg1;
var G__7674 = x;
var G__7675 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7673,G__7674,G__7675) : f.call(null,G__7673,G__7674,G__7675));
});
var G__7712__3 = (function (x,y,z){
var G__7676 = arg1;
var G__7677 = x;
var G__7678 = y;
var G__7679 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7676,G__7677,G__7678,G__7679) : f.call(null,G__7676,G__7677,G__7678,G__7679));
});
var G__7712__4 = (function() { 
var G__7713__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__7713 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7714__i = 0, G__7714__a = new Array(arguments.length -  3);
while (G__7714__i < G__7714__a.length) {G__7714__a[G__7714__i] = arguments[G__7714__i + 3]; ++G__7714__i;}
  args = new cljs.core.IndexedSeq(G__7714__a,0);
} 
return G__7713__delegate.call(this,x,y,z,args);};
G__7713.cljs$lang$maxFixedArity = 3;
G__7713.cljs$lang$applyTo = (function (arglist__7715){
var x = cljs.core.first(arglist__7715);
arglist__7715 = cljs.core.next(arglist__7715);
var y = cljs.core.first(arglist__7715);
arglist__7715 = cljs.core.next(arglist__7715);
var z = cljs.core.first(arglist__7715);
var args = cljs.core.rest(arglist__7715);
return G__7713__delegate(x,y,z,args);
});
G__7713.cljs$core$IFn$_invoke$arity$variadic = G__7713__delegate;
return G__7713;
})()
;
G__7712 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7712__0.call(this);
case 1:
return G__7712__1.call(this,x);
case 2:
return G__7712__2.call(this,x,y);
case 3:
return G__7712__3.call(this,x,y,z);
default:
var G__7716 = null;
if (arguments.length > 3) {
var G__7717__i = 0, G__7717__a = new Array(arguments.length -  3);
while (G__7717__i < G__7717__a.length) {G__7717__a[G__7717__i] = arguments[G__7717__i + 3]; ++G__7717__i;}
G__7716 = new cljs.core.IndexedSeq(G__7717__a,0);
}
return G__7712__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7712.cljs$lang$maxFixedArity = 3;
G__7712.cljs$lang$applyTo = G__7712__4.cljs$lang$applyTo;
G__7712.cljs$core$IFn$_invoke$arity$0 = G__7712__0;
G__7712.cljs$core$IFn$_invoke$arity$1 = G__7712__1;
G__7712.cljs$core$IFn$_invoke$arity$2 = G__7712__2;
G__7712.cljs$core$IFn$_invoke$arity$3 = G__7712__3;
G__7712.cljs$core$IFn$_invoke$arity$variadic = G__7712__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7712;
})()
});
var cljs$core$partial__3 = (function (f,arg1,arg2){
return (function() {
var G__7718 = null;
var G__7718__0 = (function (){
var G__7680 = arg1;
var G__7681 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7680,G__7681) : f.call(null,G__7680,G__7681));
});
var G__7718__1 = (function (x){
var G__7682 = arg1;
var G__7683 = arg2;
var G__7684 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7682,G__7683,G__7684) : f.call(null,G__7682,G__7683,G__7684));
});
var G__7718__2 = (function (x,y){
var G__7685 = arg1;
var G__7686 = arg2;
var G__7687 = x;
var G__7688 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7685,G__7686,G__7687,G__7688) : f.call(null,G__7685,G__7686,G__7687,G__7688));
});
var G__7718__3 = (function (x,y,z){
var G__7689 = arg1;
var G__7690 = arg2;
var G__7691 = x;
var G__7692 = y;
var G__7693 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7689,G__7690,G__7691,G__7692,G__7693) : f.call(null,G__7689,G__7690,G__7691,G__7692,G__7693));
});
var G__7718__4 = (function() { 
var G__7719__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__7719 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7720__i = 0, G__7720__a = new Array(arguments.length -  3);
while (G__7720__i < G__7720__a.length) {G__7720__a[G__7720__i] = arguments[G__7720__i + 3]; ++G__7720__i;}
  args = new cljs.core.IndexedSeq(G__7720__a,0);
} 
return G__7719__delegate.call(this,x,y,z,args);};
G__7719.cljs$lang$maxFixedArity = 3;
G__7719.cljs$lang$applyTo = (function (arglist__7721){
var x = cljs.core.first(arglist__7721);
arglist__7721 = cljs.core.next(arglist__7721);
var y = cljs.core.first(arglist__7721);
arglist__7721 = cljs.core.next(arglist__7721);
var z = cljs.core.first(arglist__7721);
var args = cljs.core.rest(arglist__7721);
return G__7719__delegate(x,y,z,args);
});
G__7719.cljs$core$IFn$_invoke$arity$variadic = G__7719__delegate;
return G__7719;
})()
;
G__7718 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7718__0.call(this);
case 1:
return G__7718__1.call(this,x);
case 2:
return G__7718__2.call(this,x,y);
case 3:
return G__7718__3.call(this,x,y,z);
default:
var G__7722 = null;
if (arguments.length > 3) {
var G__7723__i = 0, G__7723__a = new Array(arguments.length -  3);
while (G__7723__i < G__7723__a.length) {G__7723__a[G__7723__i] = arguments[G__7723__i + 3]; ++G__7723__i;}
G__7722 = new cljs.core.IndexedSeq(G__7723__a,0);
}
return G__7718__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7718.cljs$lang$maxFixedArity = 3;
G__7718.cljs$lang$applyTo = G__7718__4.cljs$lang$applyTo;
G__7718.cljs$core$IFn$_invoke$arity$0 = G__7718__0;
G__7718.cljs$core$IFn$_invoke$arity$1 = G__7718__1;
G__7718.cljs$core$IFn$_invoke$arity$2 = G__7718__2;
G__7718.cljs$core$IFn$_invoke$arity$3 = G__7718__3;
G__7718.cljs$core$IFn$_invoke$arity$variadic = G__7718__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7718;
})()
});
var cljs$core$partial__4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__7724 = null;
var G__7724__0 = (function (){
var G__7694 = arg1;
var G__7695 = arg2;
var G__7696 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7694,G__7695,G__7696) : f.call(null,G__7694,G__7695,G__7696));
});
var G__7724__1 = (function (x){
var G__7697 = arg1;
var G__7698 = arg2;
var G__7699 = arg3;
var G__7700 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7697,G__7698,G__7699,G__7700) : f.call(null,G__7697,G__7698,G__7699,G__7700));
});
var G__7724__2 = (function (x,y){
var G__7701 = arg1;
var G__7702 = arg2;
var G__7703 = arg3;
var G__7704 = x;
var G__7705 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7701,G__7702,G__7703,G__7704,G__7705) : f.call(null,G__7701,G__7702,G__7703,G__7704,G__7705));
});
var G__7724__3 = (function (x,y,z){
var G__7706 = arg1;
var G__7707 = arg2;
var G__7708 = arg3;
var G__7709 = x;
var G__7710 = y;
var G__7711 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7706,G__7707,G__7708,G__7709,G__7710,G__7711) : f.call(null,G__7706,G__7707,G__7708,G__7709,G__7710,G__7711));
});
var G__7724__4 = (function() { 
var G__7725__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__7725 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7726__i = 0, G__7726__a = new Array(arguments.length -  3);
while (G__7726__i < G__7726__a.length) {G__7726__a[G__7726__i] = arguments[G__7726__i + 3]; ++G__7726__i;}
  args = new cljs.core.IndexedSeq(G__7726__a,0);
} 
return G__7725__delegate.call(this,x,y,z,args);};
G__7725.cljs$lang$maxFixedArity = 3;
G__7725.cljs$lang$applyTo = (function (arglist__7727){
var x = cljs.core.first(arglist__7727);
arglist__7727 = cljs.core.next(arglist__7727);
var y = cljs.core.first(arglist__7727);
arglist__7727 = cljs.core.next(arglist__7727);
var z = cljs.core.first(arglist__7727);
var args = cljs.core.rest(arglist__7727);
return G__7725__delegate(x,y,z,args);
});
G__7725.cljs$core$IFn$_invoke$arity$variadic = G__7725__delegate;
return G__7725;
})()
;
G__7724 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7724__0.call(this);
case 1:
return G__7724__1.call(this,x);
case 2:
return G__7724__2.call(this,x,y);
case 3:
return G__7724__3.call(this,x,y,z);
default:
var G__7728 = null;
if (arguments.length > 3) {
var G__7729__i = 0, G__7729__a = new Array(arguments.length -  3);
while (G__7729__i < G__7729__a.length) {G__7729__a[G__7729__i] = arguments[G__7729__i + 3]; ++G__7729__i;}
G__7728 = new cljs.core.IndexedSeq(G__7729__a,0);
}
return G__7724__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7724.cljs$lang$maxFixedArity = 3;
G__7724.cljs$lang$applyTo = G__7724__4.cljs$lang$applyTo;
G__7724.cljs$core$IFn$_invoke$arity$0 = G__7724__0;
G__7724.cljs$core$IFn$_invoke$arity$1 = G__7724__1;
G__7724.cljs$core$IFn$_invoke$arity$2 = G__7724__2;
G__7724.cljs$core$IFn$_invoke$arity$3 = G__7724__3;
G__7724.cljs$core$IFn$_invoke$arity$variadic = G__7724__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7724;
})()
});
var cljs$core$partial__5 = (function() { 
var G__7730__delegate = function (f,arg1,arg2,arg3,more){
return (function() { 
var G__7731__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__7731 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7732__i = 0, G__7732__a = new Array(arguments.length -  0);
while (G__7732__i < G__7732__a.length) {G__7732__a[G__7732__i] = arguments[G__7732__i + 0]; ++G__7732__i;}
  args = new cljs.core.IndexedSeq(G__7732__a,0);
} 
return G__7731__delegate.call(this,args);};
G__7731.cljs$lang$maxFixedArity = 0;
G__7731.cljs$lang$applyTo = (function (arglist__7733){
var args = cljs.core.seq(arglist__7733);
return G__7731__delegate(args);
});
G__7731.cljs$core$IFn$_invoke$arity$variadic = G__7731__delegate;
return G__7731;
})()
;
};
var G__7730 = function (f,arg1,arg2,arg3,var_args){
var more = null;
if (arguments.length > 4) {
var G__7734__i = 0, G__7734__a = new Array(arguments.length -  4);
while (G__7734__i < G__7734__a.length) {G__7734__a[G__7734__i] = arguments[G__7734__i + 4]; ++G__7734__i;}
  more = new cljs.core.IndexedSeq(G__7734__a,0);
} 
return G__7730__delegate.call(this,f,arg1,arg2,arg3,more);};
G__7730.cljs$lang$maxFixedArity = 4;
G__7730.cljs$lang$applyTo = (function (arglist__7735){
var f = cljs.core.first(arglist__7735);
arglist__7735 = cljs.core.next(arglist__7735);
var arg1 = cljs.core.first(arglist__7735);
arglist__7735 = cljs.core.next(arglist__7735);
var arg2 = cljs.core.first(arglist__7735);
arglist__7735 = cljs.core.next(arglist__7735);
var arg3 = cljs.core.first(arglist__7735);
var more = cljs.core.rest(arglist__7735);
return G__7730__delegate(f,arg1,arg2,arg3,more);
});
G__7730.cljs$core$IFn$_invoke$arity$variadic = G__7730__delegate;
return G__7730;
})()
;
cljs$core$partial = function(f,arg1,arg2,arg3,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$partial__1.call(this,f);
case 2:
return cljs$core$partial__2.call(this,f,arg1);
case 3:
return cljs$core$partial__3.call(this,f,arg1,arg2);
case 4:
return cljs$core$partial__4.call(this,f,arg1,arg2,arg3);
default:
var G__7736 = null;
if (arguments.length > 4) {
var G__7737__i = 0, G__7737__a = new Array(arguments.length -  4);
while (G__7737__i < G__7737__a.length) {G__7737__a[G__7737__i] = arguments[G__7737__i + 4]; ++G__7737__i;}
G__7736 = new cljs.core.IndexedSeq(G__7737__a,0);
}
return cljs$core$partial__5.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3, G__7736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partial.cljs$lang$maxFixedArity = 4;
cljs$core$partial.cljs$lang$applyTo = cljs$core$partial__5.cljs$lang$applyTo;
cljs$core$partial.cljs$core$IFn$_invoke$arity$1 = cljs$core$partial__1;
cljs$core$partial.cljs$core$IFn$_invoke$arity$2 = cljs$core$partial__2;
cljs$core$partial.cljs$core$IFn$_invoke$arity$3 = cljs$core$partial__3;
cljs$core$partial.cljs$core$IFn$_invoke$arity$4 = cljs$core$partial__4;
cljs$core$partial.cljs$core$IFn$_invoke$arity$variadic = cljs$core$partial__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$partial;
})()
;
/**
 * Takes a function f, and returns a function that calls f, replacing
 * a nil first argument to f with the supplied value x. Higher arity
 * versions can replace arguments in the second and third
 * positions (y, z). Note that the function f can take any number of
 * arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function() {
var cljs$core$fnil = null;
var cljs$core$fnil__2 = (function (f,x){
return (function() {
var G__7770 = null;
var G__7770__1 = (function (a){
var G__7754 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7754) : f.call(null,G__7754));
});
var G__7770__2 = (function (a,b){
var G__7755 = (((a == null))?x:a);
var G__7756 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7755,G__7756) : f.call(null,G__7755,G__7756));
});
var G__7770__3 = (function (a,b,c){
var G__7757 = (((a == null))?x:a);
var G__7758 = b;
var G__7759 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7757,G__7758,G__7759) : f.call(null,G__7757,G__7758,G__7759));
});
var G__7770__4 = (function() { 
var G__7771__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__7771 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7772__i = 0, G__7772__a = new Array(arguments.length -  3);
while (G__7772__i < G__7772__a.length) {G__7772__a[G__7772__i] = arguments[G__7772__i + 3]; ++G__7772__i;}
  ds = new cljs.core.IndexedSeq(G__7772__a,0);
} 
return G__7771__delegate.call(this,a,b,c,ds);};
G__7771.cljs$lang$maxFixedArity = 3;
G__7771.cljs$lang$applyTo = (function (arglist__7773){
var a = cljs.core.first(arglist__7773);
arglist__7773 = cljs.core.next(arglist__7773);
var b = cljs.core.first(arglist__7773);
arglist__7773 = cljs.core.next(arglist__7773);
var c = cljs.core.first(arglist__7773);
var ds = cljs.core.rest(arglist__7773);
return G__7771__delegate(a,b,c,ds);
});
G__7771.cljs$core$IFn$_invoke$arity$variadic = G__7771__delegate;
return G__7771;
})()
;
G__7770 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__7770__1.call(this,a);
case 2:
return G__7770__2.call(this,a,b);
case 3:
return G__7770__3.call(this,a,b,c);
default:
var G__7774 = null;
if (arguments.length > 3) {
var G__7775__i = 0, G__7775__a = new Array(arguments.length -  3);
while (G__7775__i < G__7775__a.length) {G__7775__a[G__7775__i] = arguments[G__7775__i + 3]; ++G__7775__i;}
G__7774 = new cljs.core.IndexedSeq(G__7775__a,0);
}
return G__7770__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7770.cljs$lang$maxFixedArity = 3;
G__7770.cljs$lang$applyTo = G__7770__4.cljs$lang$applyTo;
G__7770.cljs$core$IFn$_invoke$arity$1 = G__7770__1;
G__7770.cljs$core$IFn$_invoke$arity$2 = G__7770__2;
G__7770.cljs$core$IFn$_invoke$arity$3 = G__7770__3;
G__7770.cljs$core$IFn$_invoke$arity$variadic = G__7770__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7770;
})()
});
var cljs$core$fnil__3 = (function (f,x,y){
return (function() {
var G__7776 = null;
var G__7776__2 = (function (a,b){
var G__7760 = (((a == null))?x:a);
var G__7761 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7760,G__7761) : f.call(null,G__7760,G__7761));
});
var G__7776__3 = (function (a,b,c){
var G__7762 = (((a == null))?x:a);
var G__7763 = (((b == null))?y:b);
var G__7764 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7762,G__7763,G__7764) : f.call(null,G__7762,G__7763,G__7764));
});
var G__7776__4 = (function() { 
var G__7777__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__7777 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7778__i = 0, G__7778__a = new Array(arguments.length -  3);
while (G__7778__i < G__7778__a.length) {G__7778__a[G__7778__i] = arguments[G__7778__i + 3]; ++G__7778__i;}
  ds = new cljs.core.IndexedSeq(G__7778__a,0);
} 
return G__7777__delegate.call(this,a,b,c,ds);};
G__7777.cljs$lang$maxFixedArity = 3;
G__7777.cljs$lang$applyTo = (function (arglist__7779){
var a = cljs.core.first(arglist__7779);
arglist__7779 = cljs.core.next(arglist__7779);
var b = cljs.core.first(arglist__7779);
arglist__7779 = cljs.core.next(arglist__7779);
var c = cljs.core.first(arglist__7779);
var ds = cljs.core.rest(arglist__7779);
return G__7777__delegate(a,b,c,ds);
});
G__7777.cljs$core$IFn$_invoke$arity$variadic = G__7777__delegate;
return G__7777;
})()
;
G__7776 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__7776__2.call(this,a,b);
case 3:
return G__7776__3.call(this,a,b,c);
default:
var G__7780 = null;
if (arguments.length > 3) {
var G__7781__i = 0, G__7781__a = new Array(arguments.length -  3);
while (G__7781__i < G__7781__a.length) {G__7781__a[G__7781__i] = arguments[G__7781__i + 3]; ++G__7781__i;}
G__7780 = new cljs.core.IndexedSeq(G__7781__a,0);
}
return G__7776__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7776.cljs$lang$maxFixedArity = 3;
G__7776.cljs$lang$applyTo = G__7776__4.cljs$lang$applyTo;
G__7776.cljs$core$IFn$_invoke$arity$2 = G__7776__2;
G__7776.cljs$core$IFn$_invoke$arity$3 = G__7776__3;
G__7776.cljs$core$IFn$_invoke$arity$variadic = G__7776__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7776;
})()
});
var cljs$core$fnil__4 = (function (f,x,y,z){
return (function() {
var G__7782 = null;
var G__7782__2 = (function (a,b){
var G__7765 = (((a == null))?x:a);
var G__7766 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7765,G__7766) : f.call(null,G__7765,G__7766));
});
var G__7782__3 = (function (a,b,c){
var G__7767 = (((a == null))?x:a);
var G__7768 = (((b == null))?y:b);
var G__7769 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7767,G__7768,G__7769) : f.call(null,G__7767,G__7768,G__7769));
});
var G__7782__4 = (function() { 
var G__7783__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__7783 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7784__i = 0, G__7784__a = new Array(arguments.length -  3);
while (G__7784__i < G__7784__a.length) {G__7784__a[G__7784__i] = arguments[G__7784__i + 3]; ++G__7784__i;}
  ds = new cljs.core.IndexedSeq(G__7784__a,0);
} 
return G__7783__delegate.call(this,a,b,c,ds);};
G__7783.cljs$lang$maxFixedArity = 3;
G__7783.cljs$lang$applyTo = (function (arglist__7785){
var a = cljs.core.first(arglist__7785);
arglist__7785 = cljs.core.next(arglist__7785);
var b = cljs.core.first(arglist__7785);
arglist__7785 = cljs.core.next(arglist__7785);
var c = cljs.core.first(arglist__7785);
var ds = cljs.core.rest(arglist__7785);
return G__7783__delegate(a,b,c,ds);
});
G__7783.cljs$core$IFn$_invoke$arity$variadic = G__7783__delegate;
return G__7783;
})()
;
G__7782 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__7782__2.call(this,a,b);
case 3:
return G__7782__3.call(this,a,b,c);
default:
var G__7786 = null;
if (arguments.length > 3) {
var G__7787__i = 0, G__7787__a = new Array(arguments.length -  3);
while (G__7787__i < G__7787__a.length) {G__7787__a[G__7787__i] = arguments[G__7787__i + 3]; ++G__7787__i;}
G__7786 = new cljs.core.IndexedSeq(G__7787__a,0);
}
return G__7782__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7782.cljs$lang$maxFixedArity = 3;
G__7782.cljs$lang$applyTo = G__7782__4.cljs$lang$applyTo;
G__7782.cljs$core$IFn$_invoke$arity$2 = G__7782__2;
G__7782.cljs$core$IFn$_invoke$arity$3 = G__7782__3;
G__7782.cljs$core$IFn$_invoke$arity$variadic = G__7782__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7782;
})()
});
cljs$core$fnil = function(f,x,y,z){
switch(arguments.length){
case 2:
return cljs$core$fnil__2.call(this,f,x);
case 3:
return cljs$core$fnil__3.call(this,f,x,y);
case 4:
return cljs$core$fnil__4.call(this,f,x,y,z);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fnil.cljs$core$IFn$_invoke$arity$2 = cljs$core$fnil__2;
cljs$core$fnil.cljs$core$IFn$_invoke$arity$3 = cljs$core$fnil__3;
cljs$core$fnil.cljs$core$IFn$_invoke$arity$4 = cljs$core$fnil__4;
return cljs$core$fnil;
})()
;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 * and the first item of coll, followed by applying f to 1 and the second
 * item in coll, etc, until coll is exhausted. Thus function f should
 * accept 2 arguments, index and item.
 */
cljs.core.map_indexed = (function() {
var cljs$core$map_indexed = null;
var cljs$core$map_indexed__1 = (function (f){
return (function (rf){
var i = (function (){var G__7818 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__7818) : cljs.core.volatile_BANG_.call(null,G__7818));
})();
return ((function (i){
return (function() {
var G__7848 = null;
var G__7848__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7848__1 = (function (result){
var G__7819 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7819) : rf.call(null,G__7819));
});
var G__7848__2 = (function (result,input){
var G__7820 = result;
var G__7821 = (function (){var G__7822 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__7823 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7822,G__7823) : f.call(null,G__7822,G__7823));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7820,G__7821) : rf.call(null,G__7820,G__7821));
});
G__7848 = function(result,input){
switch(arguments.length){
case 0:
return G__7848__0.call(this);
case 1:
return G__7848__1.call(this,result);
case 2:
return G__7848__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7848.cljs$core$IFn$_invoke$arity$0 = G__7848__0;
G__7848.cljs$core$IFn$_invoke$arity$1 = G__7848__1;
G__7848.cljs$core$IFn$_invoke$arity$2 = G__7848__2;
return G__7848;
})()
;})(i))
});
});
var cljs$core$map_indexed__2 = (function (f,coll){
var mapi = (function cljs$core$map_indexed_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4652__auto___7849 = size;
var i_7850 = (0);
while(true){
if((i_7850 < n__4652__auto___7849)){
cljs.core.chunk_append(b,(function (){var G__7844 = (idx + i_7850);
var G__7845 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7850);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7844,G__7845) : f.call(null,G__7844,G__7845));
})());

var G__7851 = (i_7850 + (1));
i_7850 = G__7851;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$map_indexed_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__7846 = idx;
var G__7847 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7846,G__7847) : f.call(null,G__7846,G__7847));
})(),cljs$core$map_indexed_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});
cljs$core$map_indexed = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$map_indexed__1.call(this,f);
case 2:
return cljs$core$map_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$map_indexed.cljs$core$IFn$_invoke$arity$1 = cljs$core$map_indexed__1;
cljs$core$map_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$map_indexed__2;
return cljs$core$map_indexed;
})()
;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function() {
var cljs$core$keep = null;
var cljs$core$keep__1 = (function (f){
return (function (rf){
return (function() {
var G__7870 = null;
var G__7870__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7870__1 = (function (result){
var G__7864 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7864) : rf.call(null,G__7864));
});
var G__7870__2 = (function (result,input){
var v = (function (){var G__7865 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7865) : f.call(null,G__7865));
})();
if((v == null)){
return result;
} else {
var G__7866 = result;
var G__7867 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7866,G__7867) : rf.call(null,G__7866,G__7867));
}
});
G__7870 = function(result,input){
switch(arguments.length){
case 0:
return G__7870__0.call(this);
case 1:
return G__7870__1.call(this,result);
case 2:
return G__7870__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7870.cljs$core$IFn$_invoke$arity$0 = G__7870__0;
G__7870.cljs$core$IFn$_invoke$arity$1 = G__7870__1;
G__7870.cljs$core$IFn$_invoke$arity$2 = G__7870__2;
return G__7870;
})()
});
});
var cljs$core$keep__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4652__auto___7871 = size;
var i_7872 = (0);
while(true){
if((i_7872 < n__4652__auto___7871)){
var x_7873 = (function (){var G__7868 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7872);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7868) : f.call(null,G__7868));
})();
if((x_7873 == null)){
} else {
cljs.core.chunk_append(b,x_7873);
}

var G__7874 = (i_7872 + (1));
i_7872 = G__7874;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__7869 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7869) : f.call(null,G__7869));
})();
if((x == null)){
return cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
cljs$core$keep = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$keep__1.call(this,f);
case 2:
return cljs$core$keep__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keep.cljs$core$IFn$_invoke$arity$1 = cljs$core$keep__1;
cljs$core$keep.cljs$core$IFn$_invoke$arity$2 = cljs$core$keep__2;
return cljs$core$keep;
})()
;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
this.cljs$lang$protocol_mask$partition1$ = 16386;
})
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__7875 = this$__$1;
return goog.getUid(G__7875);
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__7876 = cljs.core.seq(self__.watches);
var chunk__7877 = null;
var count__7878 = (0);
var i__7879 = (0);
while(true){
if((i__7879 < count__7878)){
var vec__7880 = chunk__7877.cljs$core$IIndexed$_nth$arity$2(null,i__7879);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7880,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7880,(1),null);
var G__7881_7890 = key;
var G__7882_7891 = this$__$1;
var G__7883_7892 = oldval;
var G__7884_7893 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7881_7890,G__7882_7891,G__7883_7892,G__7884_7893) : f.call(null,G__7881_7890,G__7882_7891,G__7883_7892,G__7884_7893));

var G__7894 = seq__7876;
var G__7895 = chunk__7877;
var G__7896 = count__7878;
var G__7897 = (i__7879 + (1));
seq__7876 = G__7894;
chunk__7877 = G__7895;
count__7878 = G__7896;
i__7879 = G__7897;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__7876);
if(temp__4126__auto__){
var seq__7876__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7876__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__7876__$1);
var G__7898 = cljs.core.chunk_rest(seq__7876__$1);
var G__7899 = c__4552__auto__;
var G__7900 = cljs.core.count(c__4552__auto__);
var G__7901 = (0);
seq__7876 = G__7898;
chunk__7877 = G__7899;
count__7878 = G__7900;
i__7879 = G__7901;
continue;
} else {
var vec__7885 = cljs.core.first(seq__7876__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7885,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7885,(1),null);
var G__7886_7902 = key;
var G__7887_7903 = this$__$1;
var G__7888_7904 = oldval;
var G__7889_7905 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7886_7902,G__7887_7903,G__7888_7904,G__7889_7905) : f.call(null,G__7886_7902,G__7887_7903,G__7888_7904,G__7889_7905));

var G__7906 = cljs.core.next(seq__7876__$1);
var G__7907 = null;
var G__7908 = (0);
var G__7909 = (0);
seq__7876 = G__7906;
chunk__7877 = G__7907;
count__7878 = G__7908;
i__7879 = G__7909;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 * more options (in any order):
 * 
 * :meta metadata-map
 * 
 * :validator validate-fn
 * 
 * If metadata-map is supplied, it will be come the metadata on the
 * atom. validate-fn must be nil or a side-effect-free fn of one
 * argument, which will be passed the intended new state on any state
 * change. If the new state is unacceptable, the validate-fn should
 * return false or throw an Error.  If either of these error conditions
 * occur, then the value of the atom will not change.
 * @param {...*} var_args
 */
cljs.core.atom = (function() {
var cljs$core$atom = null;
var cljs$core$atom__1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});
var cljs$core$atom__2 = (function() { 
var G__7913__delegate = function (x,p__7910){
var map__7912 = p__7910;
var map__7912__$1 = ((cljs.core.seq_QMARK_(map__7912))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__7912):map__7912);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7912__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7912__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
return (new cljs.core.Atom(x,meta,validator,null));
};
var G__7913 = function (x,var_args){
var p__7910 = null;
if (arguments.length > 1) {
var G__7914__i = 0, G__7914__a = new Array(arguments.length -  1);
while (G__7914__i < G__7914__a.length) {G__7914__a[G__7914__i] = arguments[G__7914__i + 1]; ++G__7914__i;}
  p__7910 = new cljs.core.IndexedSeq(G__7914__a,0);
} 
return G__7913__delegate.call(this,x,p__7910);};
G__7913.cljs$lang$maxFixedArity = 1;
G__7913.cljs$lang$applyTo = (function (arglist__7915){
var x = cljs.core.first(arglist__7915);
var p__7910 = cljs.core.rest(arglist__7915);
return G__7913__delegate(x,p__7910);
});
G__7913.cljs$core$IFn$_invoke$arity$variadic = G__7913__delegate;
return G__7913;
})()
;
cljs$core$atom = function(x,var_args){
var p__7910 = var_args;
switch(arguments.length){
case 1:
return cljs$core$atom__1.call(this,x);
default:
var G__7916 = null;
if (arguments.length > 1) {
var G__7917__i = 0, G__7917__a = new Array(arguments.length -  1);
while (G__7917__i < G__7917__a.length) {G__7917__a[G__7917__i] = arguments[G__7917__i + 1]; ++G__7917__i;}
G__7916 = new cljs.core.IndexedSeq(G__7917__a,0);
}
return cljs$core$atom__2.cljs$core$IFn$_invoke$arity$variadic(x, G__7916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$atom.cljs$lang$maxFixedArity = 1;
cljs$core$atom.cljs$lang$applyTo = cljs$core$atom__2.cljs$lang$applyTo;
cljs$core$atom.cljs$core$IFn$_invoke$arity$1 = cljs$core$atom__1;
cljs$core$atom.cljs$core$IFn$_invoke$arity$variadic = cljs$core$atom__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$atom;
})()
;
/**
 * Sets the value of atom to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__7920 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__7920) : validate.call(null,G__7920));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__7921 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__7921) : cljs.core.pr_str.call(null,G__7921));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 * (apply f current-value-of-atom args). Note that f may be called
 * multiple times, and thus should be free of side effects.  Returns
 * the value that was swapped in.
 * @param {...*} var_args
 */
cljs.core.swap_BANG_ = (function() {
var cljs$core$swap_BANG_ = null;
var cljs$core$swap_BANG___2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7928 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7928) : f.call(null,G__7928));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});
var cljs$core$swap_BANG___3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7929 = a.state;
var G__7930 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7929,G__7930) : f.call(null,G__7929,G__7930));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});
var cljs$core$swap_BANG___4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7931 = a.state;
var G__7932 = x;
var G__7933 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7931,G__7932,G__7933) : f.call(null,G__7931,G__7932,G__7933));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});
var cljs$core$swap_BANG___5 = (function() { 
var G__7934__delegate = function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
};
var G__7934 = function (a,f,x,y,var_args){
var more = null;
if (arguments.length > 4) {
var G__7935__i = 0, G__7935__a = new Array(arguments.length -  4);
while (G__7935__i < G__7935__a.length) {G__7935__a[G__7935__i] = arguments[G__7935__i + 4]; ++G__7935__i;}
  more = new cljs.core.IndexedSeq(G__7935__a,0);
} 
return G__7934__delegate.call(this,a,f,x,y,more);};
G__7934.cljs$lang$maxFixedArity = 4;
G__7934.cljs$lang$applyTo = (function (arglist__7936){
var a = cljs.core.first(arglist__7936);
arglist__7936 = cljs.core.next(arglist__7936);
var f = cljs.core.first(arglist__7936);
arglist__7936 = cljs.core.next(arglist__7936);
var x = cljs.core.first(arglist__7936);
arglist__7936 = cljs.core.next(arglist__7936);
var y = cljs.core.first(arglist__7936);
var more = cljs.core.rest(arglist__7936);
return G__7934__delegate(a,f,x,y,more);
});
G__7934.cljs$core$IFn$_invoke$arity$variadic = G__7934__delegate;
return G__7934;
})()
;
cljs$core$swap_BANG_ = function(a,f,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$swap_BANG___2.call(this,a,f);
case 3:
return cljs$core$swap_BANG___3.call(this,a,f,x);
case 4:
return cljs$core$swap_BANG___4.call(this,a,f,x,y);
default:
var G__7937 = null;
if (arguments.length > 4) {
var G__7938__i = 0, G__7938__a = new Array(arguments.length -  4);
while (G__7938__i < G__7938__a.length) {G__7938__a[G__7938__i] = arguments[G__7938__i + 4]; ++G__7938__i;}
G__7937 = new cljs.core.IndexedSeq(G__7938__a,0);
}
return cljs$core$swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic(a,f,x,y, G__7937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs$core$swap_BANG_.cljs$lang$applyTo = cljs$core$swap_BANG___5.cljs$lang$applyTo;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$swap_BANG___2;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$swap_BANG___3;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$4 = cljs$core$swap_BANG___4;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$swap_BANG_;
})()
;
/**
 * Atomically sets the value of atom to newval if and only if the
 * current value of the atom is equal to oldval. Returns true if
 * set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 * side-effect-free fn of one argument, which will be passed the intended
 * new state on any state change. If the new state is unacceptable, the
 * validator-fn should return false or throw an Error. If the current state
 * is not acceptable to the new validator, an Error will be thrown and the
 * validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a stateful transducer when no collection is
 * provided.
 */
cljs.core.keep_indexed = (function() {
var cljs$core$keep_indexed = null;
var cljs$core$keep_indexed__1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__8005 = null;
var G__8005__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8005__1 = (function (result){
var G__7972 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7972) : rf.call(null,G__7972));
});
var G__8005__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (function (){var G__7973 = i;
var G__7974 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7973,G__7974) : f.call(null,G__7973,G__7974));
})();
if((v == null)){
return result;
} else {
var G__7975 = result;
var G__7976 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7975,G__7976) : rf.call(null,G__7975,G__7976));
}
});
G__8005 = function(result,input){
switch(arguments.length){
case 0:
return G__8005__0.call(this);
case 1:
return G__8005__1.call(this,result);
case 2:
return G__8005__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8005.cljs$core$IFn$_invoke$arity$0 = G__8005__0;
G__8005.cljs$core$IFn$_invoke$arity$1 = G__8005__1;
G__8005.cljs$core$IFn$_invoke$arity$2 = G__8005__2;
return G__8005;
})()
;})(ia))
});
});
var cljs$core$keep_indexed__2 = (function (f,coll){
var keepi = (function cljs$core$keep_indexed_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4652__auto___8006 = size;
var i_8007 = (0);
while(true){
if((i_8007 < n__4652__auto___8006)){
var x_8008 = (function (){var G__8001 = (idx + i_8007);
var G__8002 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8007);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8001,G__8002) : f.call(null,G__8001,G__8002));
})();
if((x_8008 == null)){
} else {
cljs.core.chunk_append(b,x_8008);
}

var G__8009 = (i_8007 + (1));
i_8007 = G__8009;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keep_indexed_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__8003 = idx;
var G__8004 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8003,G__8004) : f.call(null,G__8003,G__8004));
})();
if((x == null)){
return cljs$core$keep_indexed_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keep_indexed_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});
cljs$core$keep_indexed = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$keep_indexed__1.call(this,f);
case 2:
return cljs$core$keep_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keep_indexed.cljs$core$IFn$_invoke$arity$1 = cljs$core$keep_indexed__1;
cljs$core$keep_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$keep_indexed__2;
return cljs$core$keep_indexed;
})()
;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 * composing predicates return a logical true value against all of its arguments, else it returns
 * false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical false result against the original predicates.
 * @param {...*} var_args
 */
cljs.core.every_pred = (function() {
var cljs$core$every_pred = null;
var cljs$core$every_pred__1 = (function (p){
return (function() {
var cljs$core$every_pred_$_ep1 = null;
var cljs$core$every_pred_$_ep1__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__8223 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8223) : p.call(null,G__8223));
})());
});
var cljs$core$every_pred_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8225 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8225) : p.call(null,G__8225));
})();
if(cljs.core.truth_(and__3755__auto__)){
var G__8226 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8226) : p.call(null,G__8226));
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8228 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8228) : p.call(null,G__8228));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8230 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8230) : p.call(null,G__8230));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var G__8231 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8231) : p.call(null,G__8231));
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep1__4 = (function() { 
var G__8400__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(p,args)));
};
var G__8400 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8401__i = 0, G__8401__a = new Array(arguments.length -  3);
while (G__8401__i < G__8401__a.length) {G__8401__a[G__8401__i] = arguments[G__8401__i + 3]; ++G__8401__i;}
  args = new cljs.core.IndexedSeq(G__8401__a,0);
} 
return G__8400__delegate.call(this,x,y,z,args);};
G__8400.cljs$lang$maxFixedArity = 3;
G__8400.cljs$lang$applyTo = (function (arglist__8402){
var x = cljs.core.first(arglist__8402);
arglist__8402 = cljs.core.next(arglist__8402);
var y = cljs.core.first(arglist__8402);
arglist__8402 = cljs.core.next(arglist__8402);
var z = cljs.core.first(arglist__8402);
var args = cljs.core.rest(arglist__8402);
return G__8400__delegate(x,y,z,args);
});
G__8400.cljs$core$IFn$_invoke$arity$variadic = G__8400__delegate;
return G__8400;
})()
;
cljs$core$every_pred_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep1__0.call(this);
case 1:
return cljs$core$every_pred_$_ep1__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep1__3.call(this,x,y,z);
default:
var G__8403 = null;
if (arguments.length > 3) {
var G__8404__i = 0, G__8404__a = new Array(arguments.length -  3);
while (G__8404__i < G__8404__a.length) {G__8404__a[G__8404__i] = arguments[G__8404__i + 3]; ++G__8404__i;}
G__8403 = new cljs.core.IndexedSeq(G__8404__a,0);
}
return cljs$core$every_pred_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8403);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep1.cljs$lang$applyTo = cljs$core$every_pred_$_ep1__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep1__0;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep1__1;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep1__2;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep1__3;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep1;
})()
});
var cljs$core$every_pred__2 = (function (p1,p2){
return (function() {
var cljs$core$every_pred_$_ep2 = null;
var cljs$core$every_pred_$_ep2__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8263 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8263) : p1.call(null,G__8263));
})();
if(cljs.core.truth_(and__3755__auto__)){
var G__8264 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8264) : p2.call(null,G__8264));
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8266 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8266) : p1.call(null,G__8266));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8268 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8268) : p1.call(null,G__8268));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var and__3755__auto____$2 = (function (){var G__8270 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8270) : p2.call(null,G__8270));
})();
if(cljs.core.truth_(and__3755__auto____$2)){
var G__8271 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8271) : p2.call(null,G__8271));
} else {
return and__3755__auto____$2;
}
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8273 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8273) : p1.call(null,G__8273));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8275 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8275) : p1.call(null,G__8275));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var and__3755__auto____$2 = (function (){var G__8277 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8277) : p1.call(null,G__8277));
})();
if(cljs.core.truth_(and__3755__auto____$2)){
var and__3755__auto____$3 = (function (){var G__8279 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8279) : p2.call(null,G__8279));
})();
if(cljs.core.truth_(and__3755__auto____$3)){
var and__3755__auto____$4 = (function (){var G__8281 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8281) : p2.call(null,G__8281));
})();
if(cljs.core.truth_(and__3755__auto____$4)){
var G__8282 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8282) : p2.call(null,G__8282));
} else {
return and__3755__auto____$4;
}
} else {
return and__3755__auto____$3;
}
} else {
return and__3755__auto____$2;
}
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__4 = (function() { 
var G__8405__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__8010_SHARP_){
var and__3755__auto__ = (function (){var G__8287 = p1__8010_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8287) : p1.call(null,G__8287));
})();
if(cljs.core.truth_(and__3755__auto__)){
var G__8288 = p1__8010_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8288) : p2.call(null,G__8288));
} else {
return and__3755__auto__;
}
}),args)));
};
var G__8405 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8406__i = 0, G__8406__a = new Array(arguments.length -  3);
while (G__8406__i < G__8406__a.length) {G__8406__a[G__8406__i] = arguments[G__8406__i + 3]; ++G__8406__i;}
  args = new cljs.core.IndexedSeq(G__8406__a,0);
} 
return G__8405__delegate.call(this,x,y,z,args);};
G__8405.cljs$lang$maxFixedArity = 3;
G__8405.cljs$lang$applyTo = (function (arglist__8407){
var x = cljs.core.first(arglist__8407);
arglist__8407 = cljs.core.next(arglist__8407);
var y = cljs.core.first(arglist__8407);
arglist__8407 = cljs.core.next(arglist__8407);
var z = cljs.core.first(arglist__8407);
var args = cljs.core.rest(arglist__8407);
return G__8405__delegate(x,y,z,args);
});
G__8405.cljs$core$IFn$_invoke$arity$variadic = G__8405__delegate;
return G__8405;
})()
;
cljs$core$every_pred_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep2__0.call(this);
case 1:
return cljs$core$every_pred_$_ep2__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep2__3.call(this,x,y,z);
default:
var G__8408 = null;
if (arguments.length > 3) {
var G__8409__i = 0, G__8409__a = new Array(arguments.length -  3);
while (G__8409__i < G__8409__a.length) {G__8409__a[G__8409__i] = arguments[G__8409__i + 3]; ++G__8409__i;}
G__8408 = new cljs.core.IndexedSeq(G__8409__a,0);
}
return cljs$core$every_pred_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep2.cljs$lang$applyTo = cljs$core$every_pred_$_ep2__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep2__0;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep2__1;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep2__2;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep2__3;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep2;
})()
});
var cljs$core$every_pred__3 = (function (p1,p2,p3){
return (function() {
var cljs$core$every_pred_$_ep3 = null;
var cljs$core$every_pred_$_ep3__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8334 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8334) : p1.call(null,G__8334));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8336 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8336) : p2.call(null,G__8336));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var G__8337 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8337) : p3.call(null,G__8337));
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8339 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8339) : p1.call(null,G__8339));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8341 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8341) : p2.call(null,G__8341));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var and__3755__auto____$2 = (function (){var G__8343 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8343) : p3.call(null,G__8343));
})();
if(cljs.core.truth_(and__3755__auto____$2)){
var and__3755__auto____$3 = (function (){var G__8345 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8345) : p1.call(null,G__8345));
})();
if(cljs.core.truth_(and__3755__auto____$3)){
var and__3755__auto____$4 = (function (){var G__8347 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8347) : p2.call(null,G__8347));
})();
if(cljs.core.truth_(and__3755__auto____$4)){
var G__8348 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8348) : p3.call(null,G__8348));
} else {
return and__3755__auto____$4;
}
} else {
return and__3755__auto____$3;
}
} else {
return and__3755__auto____$2;
}
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3755__auto__ = (function (){var G__8350 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8350) : p1.call(null,G__8350));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8352 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8352) : p2.call(null,G__8352));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var and__3755__auto____$2 = (function (){var G__8354 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8354) : p3.call(null,G__8354));
})();
if(cljs.core.truth_(and__3755__auto____$2)){
var and__3755__auto____$3 = (function (){var G__8356 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8356) : p1.call(null,G__8356));
})();
if(cljs.core.truth_(and__3755__auto____$3)){
var and__3755__auto____$4 = (function (){var G__8358 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8358) : p2.call(null,G__8358));
})();
if(cljs.core.truth_(and__3755__auto____$4)){
var and__3755__auto____$5 = (function (){var G__8360 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8360) : p3.call(null,G__8360));
})();
if(cljs.core.truth_(and__3755__auto____$5)){
var and__3755__auto____$6 = (function (){var G__8362 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8362) : p1.call(null,G__8362));
})();
if(cljs.core.truth_(and__3755__auto____$6)){
var and__3755__auto____$7 = (function (){var G__8364 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8364) : p2.call(null,G__8364));
})();
if(cljs.core.truth_(and__3755__auto____$7)){
var G__8365 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8365) : p3.call(null,G__8365));
} else {
return and__3755__auto____$7;
}
} else {
return and__3755__auto____$6;
}
} else {
return and__3755__auto____$5;
}
} else {
return and__3755__auto____$4;
}
} else {
return and__3755__auto____$3;
}
} else {
return and__3755__auto____$2;
}
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__4 = (function() { 
var G__8410__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__8011_SHARP_){
var and__3755__auto__ = (function (){var G__8372 = p1__8011_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8372) : p1.call(null,G__8372));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8374 = p1__8011_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8374) : p2.call(null,G__8374));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var G__8375 = p1__8011_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8375) : p3.call(null,G__8375));
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
}),args)));
};
var G__8410 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8411__i = 0, G__8411__a = new Array(arguments.length -  3);
while (G__8411__i < G__8411__a.length) {G__8411__a[G__8411__i] = arguments[G__8411__i + 3]; ++G__8411__i;}
  args = new cljs.core.IndexedSeq(G__8411__a,0);
} 
return G__8410__delegate.call(this,x,y,z,args);};
G__8410.cljs$lang$maxFixedArity = 3;
G__8410.cljs$lang$applyTo = (function (arglist__8412){
var x = cljs.core.first(arglist__8412);
arglist__8412 = cljs.core.next(arglist__8412);
var y = cljs.core.first(arglist__8412);
arglist__8412 = cljs.core.next(arglist__8412);
var z = cljs.core.first(arglist__8412);
var args = cljs.core.rest(arglist__8412);
return G__8410__delegate(x,y,z,args);
});
G__8410.cljs$core$IFn$_invoke$arity$variadic = G__8410__delegate;
return G__8410;
})()
;
cljs$core$every_pred_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep3__0.call(this);
case 1:
return cljs$core$every_pred_$_ep3__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep3__3.call(this,x,y,z);
default:
var G__8413 = null;
if (arguments.length > 3) {
var G__8414__i = 0, G__8414__a = new Array(arguments.length -  3);
while (G__8414__i < G__8414__a.length) {G__8414__a[G__8414__i] = arguments[G__8414__i + 3]; ++G__8414__i;}
G__8413 = new cljs.core.IndexedSeq(G__8414__a,0);
}
return cljs$core$every_pred_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep3.cljs$lang$applyTo = cljs$core$every_pred_$_ep3__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep3__0;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep3__1;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep3__2;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep3__3;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep3;
})()
});
var cljs$core$every_pred__4 = (function() { 
var G__8415__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$every_pred_$_epn = null;
var cljs$core$every_pred_$_epn__0 = (function (){
return true;
});
var cljs$core$every_pred_$_epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8012_SHARP_){
var G__8391 = x;
return (p1__8012_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8012_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8391) : p1__8012_SHARP_.call(null,G__8391));
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8013_SHARP_){
var and__3755__auto__ = (function (){var G__8393 = x;
return (p1__8013_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8013_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8393) : p1__8013_SHARP_.call(null,G__8393));
})();
if(cljs.core.truth_(and__3755__auto__)){
var G__8394 = y;
return (p1__8013_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8013_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8394) : p1__8013_SHARP_.call(null,G__8394));
} else {
return and__3755__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8014_SHARP_){
var and__3755__auto__ = (function (){var G__8396 = x;
return (p1__8014_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8014_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8396) : p1__8014_SHARP_.call(null,G__8396));
})();
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__8398 = y;
return (p1__8014_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8014_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8398) : p1__8014_SHARP_.call(null,G__8398));
})();
if(cljs.core.truth_(and__3755__auto____$1)){
var G__8399 = z;
return (p1__8014_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8014_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8399) : p1__8014_SHARP_.call(null,G__8399));
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__4 = (function() { 
var G__8416__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__8015_SHARP_){
return cljs.core.every_QMARK_(p1__8015_SHARP_,args);
});})(ps__$1))
,ps__$1)));
};
var G__8416 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8417__i = 0, G__8417__a = new Array(arguments.length -  3);
while (G__8417__i < G__8417__a.length) {G__8417__a[G__8417__i] = arguments[G__8417__i + 3]; ++G__8417__i;}
  args = new cljs.core.IndexedSeq(G__8417__a,0);
} 
return G__8416__delegate.call(this,x,y,z,args);};
G__8416.cljs$lang$maxFixedArity = 3;
G__8416.cljs$lang$applyTo = (function (arglist__8418){
var x = cljs.core.first(arglist__8418);
arglist__8418 = cljs.core.next(arglist__8418);
var y = cljs.core.first(arglist__8418);
arglist__8418 = cljs.core.next(arglist__8418);
var z = cljs.core.first(arglist__8418);
var args = cljs.core.rest(arglist__8418);
return G__8416__delegate(x,y,z,args);
});
G__8416.cljs$core$IFn$_invoke$arity$variadic = G__8416__delegate;
return G__8416;
})()
;
cljs$core$every_pred_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_epn__0.call(this);
case 1:
return cljs$core$every_pred_$_epn__1.call(this,x);
case 2:
return cljs$core$every_pred_$_epn__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_epn__3.call(this,x,y,z);
default:
var G__8419 = null;
if (arguments.length > 3) {
var G__8420__i = 0, G__8420__a = new Array(arguments.length -  3);
while (G__8420__i < G__8420__a.length) {G__8420__a[G__8420__i] = arguments[G__8420__i + 3]; ++G__8420__i;}
G__8419 = new cljs.core.IndexedSeq(G__8420__a,0);
}
return cljs$core$every_pred_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_epn.cljs$lang$applyTo = cljs$core$every_pred_$_epn__4.cljs$lang$applyTo;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_epn__0;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_epn__1;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_epn__2;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_epn__3;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_epn;
})()
;})(ps__$1))
};
var G__8415 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__8421__i = 0, G__8421__a = new Array(arguments.length -  3);
while (G__8421__i < G__8421__a.length) {G__8421__a[G__8421__i] = arguments[G__8421__i + 3]; ++G__8421__i;}
  ps = new cljs.core.IndexedSeq(G__8421__a,0);
} 
return G__8415__delegate.call(this,p1,p2,p3,ps);};
G__8415.cljs$lang$maxFixedArity = 3;
G__8415.cljs$lang$applyTo = (function (arglist__8422){
var p1 = cljs.core.first(arglist__8422);
arglist__8422 = cljs.core.next(arglist__8422);
var p2 = cljs.core.first(arglist__8422);
arglist__8422 = cljs.core.next(arglist__8422);
var p3 = cljs.core.first(arglist__8422);
var ps = cljs.core.rest(arglist__8422);
return G__8415__delegate(p1,p2,p3,ps);
});
G__8415.cljs$core$IFn$_invoke$arity$variadic = G__8415__delegate;
return G__8415;
})()
;
cljs$core$every_pred = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return cljs$core$every_pred__1.call(this,p1);
case 2:
return cljs$core$every_pred__2.call(this,p1,p2);
case 3:
return cljs$core$every_pred__3.call(this,p1,p2,p3);
default:
var G__8423 = null;
if (arguments.length > 3) {
var G__8424__i = 0, G__8424__a = new Array(arguments.length -  3);
while (G__8424__i < G__8424__a.length) {G__8424__a[G__8424__i] = arguments[G__8424__i + 3]; ++G__8424__i;}
G__8423 = new cljs.core.IndexedSeq(G__8424__a,0);
}
return cljs$core$every_pred__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__8423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred.cljs$lang$applyTo = cljs$core$every_pred__4.cljs$lang$applyTo;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred__1;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred__2;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred__3;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred;
})()
;
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 * returned by one of its composing predicates against any of its arguments, else it returns
 * logical false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical true result against the original predicates.
 * @param {...*} var_args
 */
cljs.core.some_fn = (function() {
var cljs$core$some_fn = null;
var cljs$core$some_fn__1 = (function (p){
return (function() {
var cljs$core$some_fn_$_sp1 = null;
var cljs$core$some_fn_$_sp1__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp1__1 = (function (x){
var G__8630 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8630) : p.call(null,G__8630));
});
var cljs$core$some_fn_$_sp1__2 = (function (x,y){
var or__3767__auto__ = (function (){var G__8632 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8632) : p.call(null,G__8632));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var G__8633 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8633) : p.call(null,G__8633));
}
});
var cljs$core$some_fn_$_sp1__3 = (function (x,y,z){
var or__3767__auto__ = (function (){var G__8635 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8635) : p.call(null,G__8635));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (function (){var G__8637 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8637) : p.call(null,G__8637));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var G__8638 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8638) : p.call(null,G__8638));
}
}
});
var cljs$core$some_fn_$_sp1__4 = (function() { 
var G__8799__delegate = function (x,y,z,args){
var or__3767__auto__ = cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__8799 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8800__i = 0, G__8800__a = new Array(arguments.length -  3);
while (G__8800__i < G__8800__a.length) {G__8800__a[G__8800__i] = arguments[G__8800__i + 3]; ++G__8800__i;}
  args = new cljs.core.IndexedSeq(G__8800__a,0);
} 
return G__8799__delegate.call(this,x,y,z,args);};
G__8799.cljs$lang$maxFixedArity = 3;
G__8799.cljs$lang$applyTo = (function (arglist__8801){
var x = cljs.core.first(arglist__8801);
arglist__8801 = cljs.core.next(arglist__8801);
var y = cljs.core.first(arglist__8801);
arglist__8801 = cljs.core.next(arglist__8801);
var z = cljs.core.first(arglist__8801);
var args = cljs.core.rest(arglist__8801);
return G__8799__delegate(x,y,z,args);
});
G__8799.cljs$core$IFn$_invoke$arity$variadic = G__8799__delegate;
return G__8799;
})()
;
cljs$core$some_fn_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp1__0.call(this);
case 1:
return cljs$core$some_fn_$_sp1__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp1__3.call(this,x,y,z);
default:
var G__8802 = null;
if (arguments.length > 3) {
var G__8803__i = 0, G__8803__a = new Array(arguments.length -  3);
while (G__8803__i < G__8803__a.length) {G__8803__a[G__8803__i] = arguments[G__8803__i + 3]; ++G__8803__i;}
G__8802 = new cljs.core.IndexedSeq(G__8803__a,0);
}
return cljs$core$some_fn_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp1.cljs$lang$applyTo = cljs$core$some_fn_$_sp1__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp1__0;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp1__1;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp1__2;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp1__3;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp1;
})()
});
var cljs$core$some_fn__2 = (function (p1,p2){
return (function() {
var cljs$core$some_fn_$_sp2 = null;
var cljs$core$some_fn_$_sp2__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp2__1 = (function (x){
var or__3767__auto__ = (function (){var G__8670 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8670) : p1.call(null,G__8670));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var G__8671 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8671) : p2.call(null,G__8671));
}
});
var cljs$core$some_fn_$_sp2__2 = (function (x,y){
var or__3767__auto__ = (function (){var G__8673 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8673) : p1.call(null,G__8673));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (function (){var G__8675 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8675) : p1.call(null,G__8675));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var or__3767__auto____$2 = (function (){var G__8677 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8677) : p2.call(null,G__8677));
})();
if(cljs.core.truth_(or__3767__auto____$2)){
return or__3767__auto____$2;
} else {
var G__8678 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8678) : p2.call(null,G__8678));
}
}
}
});
var cljs$core$some_fn_$_sp2__3 = (function (x,y,z){
var or__3767__auto__ = (function (){var G__8680 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8680) : p1.call(null,G__8680));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (function (){var G__8682 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8682) : p1.call(null,G__8682));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var or__3767__auto____$2 = (function (){var G__8684 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8684) : p1.call(null,G__8684));
})();
if(cljs.core.truth_(or__3767__auto____$2)){
return or__3767__auto____$2;
} else {
var or__3767__auto____$3 = (function (){var G__8686 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8686) : p2.call(null,G__8686));
})();
if(cljs.core.truth_(or__3767__auto____$3)){
return or__3767__auto____$3;
} else {
var or__3767__auto____$4 = (function (){var G__8688 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8688) : p2.call(null,G__8688));
})();
if(cljs.core.truth_(or__3767__auto____$4)){
return or__3767__auto____$4;
} else {
var G__8689 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8689) : p2.call(null,G__8689));
}
}
}
}
}
});
var cljs$core$some_fn_$_sp2__4 = (function() { 
var G__8804__delegate = function (x,y,z,args){
var or__3767__auto__ = cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return cljs.core.some(((function (or__3767__auto__){
return (function (p1__8425_SHARP_){
var or__3767__auto____$1 = (function (){var G__8691 = p1__8425_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8691) : p1.call(null,G__8691));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var G__8692 = p1__8425_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8692) : p2.call(null,G__8692));
}
});})(or__3767__auto__))
,args);
}
};
var G__8804 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8805__i = 0, G__8805__a = new Array(arguments.length -  3);
while (G__8805__i < G__8805__a.length) {G__8805__a[G__8805__i] = arguments[G__8805__i + 3]; ++G__8805__i;}
  args = new cljs.core.IndexedSeq(G__8805__a,0);
} 
return G__8804__delegate.call(this,x,y,z,args);};
G__8804.cljs$lang$maxFixedArity = 3;
G__8804.cljs$lang$applyTo = (function (arglist__8806){
var x = cljs.core.first(arglist__8806);
arglist__8806 = cljs.core.next(arglist__8806);
var y = cljs.core.first(arglist__8806);
arglist__8806 = cljs.core.next(arglist__8806);
var z = cljs.core.first(arglist__8806);
var args = cljs.core.rest(arglist__8806);
return G__8804__delegate(x,y,z,args);
});
G__8804.cljs$core$IFn$_invoke$arity$variadic = G__8804__delegate;
return G__8804;
})()
;
cljs$core$some_fn_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp2__0.call(this);
case 1:
return cljs$core$some_fn_$_sp2__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp2__3.call(this,x,y,z);
default:
var G__8807 = null;
if (arguments.length > 3) {
var G__8808__i = 0, G__8808__a = new Array(arguments.length -  3);
while (G__8808__i < G__8808__a.length) {G__8808__a[G__8808__i] = arguments[G__8808__i + 3]; ++G__8808__i;}
G__8807 = new cljs.core.IndexedSeq(G__8808__a,0);
}
return cljs$core$some_fn_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp2.cljs$lang$applyTo = cljs$core$some_fn_$_sp2__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp2__0;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp2__1;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp2__2;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp2__3;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp2;
})()
});
var cljs$core$some_fn__3 = (function (p1,p2,p3){
return (function() {
var cljs$core$some_fn_$_sp3 = null;
var cljs$core$some_fn_$_sp3__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp3__1 = (function (x){
var or__3767__auto__ = (function (){var G__8738 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8738) : p1.call(null,G__8738));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (function (){var G__8740 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8740) : p2.call(null,G__8740));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var G__8741 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8741) : p3.call(null,G__8741));
}
}
});
var cljs$core$some_fn_$_sp3__2 = (function (x,y){
var or__3767__auto__ = (function (){var G__8743 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8743) : p1.call(null,G__8743));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (function (){var G__8745 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8745) : p2.call(null,G__8745));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var or__3767__auto____$2 = (function (){var G__8747 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8747) : p3.call(null,G__8747));
})();
if(cljs.core.truth_(or__3767__auto____$2)){
return or__3767__auto____$2;
} else {
var or__3767__auto____$3 = (function (){var G__8749 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8749) : p1.call(null,G__8749));
})();
if(cljs.core.truth_(or__3767__auto____$3)){
return or__3767__auto____$3;
} else {
var or__3767__auto____$4 = (function (){var G__8751 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8751) : p2.call(null,G__8751));
})();
if(cljs.core.truth_(or__3767__auto____$4)){
return or__3767__auto____$4;
} else {
var G__8752 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8752) : p3.call(null,G__8752));
}
}
}
}
}
});
var cljs$core$some_fn_$_sp3__3 = (function (x,y,z){
var or__3767__auto__ = (function (){var G__8754 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8754) : p1.call(null,G__8754));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (function (){var G__8756 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8756) : p2.call(null,G__8756));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var or__3767__auto____$2 = (function (){var G__8758 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8758) : p3.call(null,G__8758));
})();
if(cljs.core.truth_(or__3767__auto____$2)){
return or__3767__auto____$2;
} else {
var or__3767__auto____$3 = (function (){var G__8760 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8760) : p1.call(null,G__8760));
})();
if(cljs.core.truth_(or__3767__auto____$3)){
return or__3767__auto____$3;
} else {
var or__3767__auto____$4 = (function (){var G__8762 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8762) : p2.call(null,G__8762));
})();
if(cljs.core.truth_(or__3767__auto____$4)){
return or__3767__auto____$4;
} else {
var or__3767__auto____$5 = (function (){var G__8764 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8764) : p3.call(null,G__8764));
})();
if(cljs.core.truth_(or__3767__auto____$5)){
return or__3767__auto____$5;
} else {
var or__3767__auto____$6 = (function (){var G__8766 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8766) : p1.call(null,G__8766));
})();
if(cljs.core.truth_(or__3767__auto____$6)){
return or__3767__auto____$6;
} else {
var or__3767__auto____$7 = (function (){var G__8768 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8768) : p2.call(null,G__8768));
})();
if(cljs.core.truth_(or__3767__auto____$7)){
return or__3767__auto____$7;
} else {
var G__8769 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8769) : p3.call(null,G__8769));
}
}
}
}
}
}
}
}
});
var cljs$core$some_fn_$_sp3__4 = (function() { 
var G__8809__delegate = function (x,y,z,args){
var or__3767__auto__ = cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return cljs.core.some(((function (or__3767__auto__){
return (function (p1__8426_SHARP_){
var or__3767__auto____$1 = (function (){var G__8771 = p1__8426_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8771) : p1.call(null,G__8771));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var or__3767__auto____$2 = (function (){var G__8773 = p1__8426_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8773) : p2.call(null,G__8773));
})();
if(cljs.core.truth_(or__3767__auto____$2)){
return or__3767__auto____$2;
} else {
var G__8774 = p1__8426_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8774) : p3.call(null,G__8774));
}
}
});})(or__3767__auto__))
,args);
}
};
var G__8809 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8810__i = 0, G__8810__a = new Array(arguments.length -  3);
while (G__8810__i < G__8810__a.length) {G__8810__a[G__8810__i] = arguments[G__8810__i + 3]; ++G__8810__i;}
  args = new cljs.core.IndexedSeq(G__8810__a,0);
} 
return G__8809__delegate.call(this,x,y,z,args);};
G__8809.cljs$lang$maxFixedArity = 3;
G__8809.cljs$lang$applyTo = (function (arglist__8811){
var x = cljs.core.first(arglist__8811);
arglist__8811 = cljs.core.next(arglist__8811);
var y = cljs.core.first(arglist__8811);
arglist__8811 = cljs.core.next(arglist__8811);
var z = cljs.core.first(arglist__8811);
var args = cljs.core.rest(arglist__8811);
return G__8809__delegate(x,y,z,args);
});
G__8809.cljs$core$IFn$_invoke$arity$variadic = G__8809__delegate;
return G__8809;
})()
;
cljs$core$some_fn_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp3__0.call(this);
case 1:
return cljs$core$some_fn_$_sp3__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp3__3.call(this,x,y,z);
default:
var G__8812 = null;
if (arguments.length > 3) {
var G__8813__i = 0, G__8813__a = new Array(arguments.length -  3);
while (G__8813__i < G__8813__a.length) {G__8813__a[G__8813__i] = arguments[G__8813__i + 3]; ++G__8813__i;}
G__8812 = new cljs.core.IndexedSeq(G__8813__a,0);
}
return cljs$core$some_fn_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp3.cljs$lang$applyTo = cljs$core$some_fn_$_sp3__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp3__0;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp3__1;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp3__2;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp3__3;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp3;
})()
});
var cljs$core$some_fn__4 = (function() { 
var G__8814__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$some_fn_$_spn = null;
var cljs$core$some_fn_$_spn__0 = (function (){
return null;
});
var cljs$core$some_fn_$_spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__8427_SHARP_){
var G__8790 = x;
return (p1__8427_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8427_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8790) : p1__8427_SHARP_.call(null,G__8790));
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__8428_SHARP_){
var or__3767__auto__ = (function (){var G__8792 = x;
return (p1__8428_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8428_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8792) : p1__8428_SHARP_.call(null,G__8792));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var G__8793 = y;
return (p1__8428_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8428_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8793) : p1__8428_SHARP_.call(null,G__8793));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__8429_SHARP_){
var or__3767__auto__ = (function (){var G__8795 = x;
return (p1__8429_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8429_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8795) : p1__8429_SHARP_.call(null,G__8795));
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (function (){var G__8797 = y;
return (p1__8429_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8429_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8797) : p1__8429_SHARP_.call(null,G__8797));
})();
if(cljs.core.truth_(or__3767__auto____$1)){
return or__3767__auto____$1;
} else {
var G__8798 = z;
return (p1__8429_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8429_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8798) : p1__8429_SHARP_.call(null,G__8798));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__4 = (function() { 
var G__8815__delegate = function (x,y,z,args){
var or__3767__auto__ = cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return cljs.core.some(((function (or__3767__auto__,ps__$1){
return (function (p1__8430_SHARP_){
return cljs.core.some(p1__8430_SHARP_,args);
});})(or__3767__auto__,ps__$1))
,ps__$1);
}
};
var G__8815 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8816__i = 0, G__8816__a = new Array(arguments.length -  3);
while (G__8816__i < G__8816__a.length) {G__8816__a[G__8816__i] = arguments[G__8816__i + 3]; ++G__8816__i;}
  args = new cljs.core.IndexedSeq(G__8816__a,0);
} 
return G__8815__delegate.call(this,x,y,z,args);};
G__8815.cljs$lang$maxFixedArity = 3;
G__8815.cljs$lang$applyTo = (function (arglist__8817){
var x = cljs.core.first(arglist__8817);
arglist__8817 = cljs.core.next(arglist__8817);
var y = cljs.core.first(arglist__8817);
arglist__8817 = cljs.core.next(arglist__8817);
var z = cljs.core.first(arglist__8817);
var args = cljs.core.rest(arglist__8817);
return G__8815__delegate(x,y,z,args);
});
G__8815.cljs$core$IFn$_invoke$arity$variadic = G__8815__delegate;
return G__8815;
})()
;
cljs$core$some_fn_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_spn__0.call(this);
case 1:
return cljs$core$some_fn_$_spn__1.call(this,x);
case 2:
return cljs$core$some_fn_$_spn__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_spn__3.call(this,x,y,z);
default:
var G__8818 = null;
if (arguments.length > 3) {
var G__8819__i = 0, G__8819__a = new Array(arguments.length -  3);
while (G__8819__i < G__8819__a.length) {G__8819__a[G__8819__i] = arguments[G__8819__i + 3]; ++G__8819__i;}
G__8818 = new cljs.core.IndexedSeq(G__8819__a,0);
}
return cljs$core$some_fn_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_spn.cljs$lang$applyTo = cljs$core$some_fn_$_spn__4.cljs$lang$applyTo;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_spn__0;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_spn__1;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_spn__2;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_spn__3;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_spn;
})()
;})(ps__$1))
};
var G__8814 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__8820__i = 0, G__8820__a = new Array(arguments.length -  3);
while (G__8820__i < G__8820__a.length) {G__8820__a[G__8820__i] = arguments[G__8820__i + 3]; ++G__8820__i;}
  ps = new cljs.core.IndexedSeq(G__8820__a,0);
} 
return G__8814__delegate.call(this,p1,p2,p3,ps);};
G__8814.cljs$lang$maxFixedArity = 3;
G__8814.cljs$lang$applyTo = (function (arglist__8821){
var p1 = cljs.core.first(arglist__8821);
arglist__8821 = cljs.core.next(arglist__8821);
var p2 = cljs.core.first(arglist__8821);
arglist__8821 = cljs.core.next(arglist__8821);
var p3 = cljs.core.first(arglist__8821);
var ps = cljs.core.rest(arglist__8821);
return G__8814__delegate(p1,p2,p3,ps);
});
G__8814.cljs$core$IFn$_invoke$arity$variadic = G__8814__delegate;
return G__8814;
})()
;
cljs$core$some_fn = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return cljs$core$some_fn__1.call(this,p1);
case 2:
return cljs$core$some_fn__2.call(this,p1,p2);
case 3:
return cljs$core$some_fn__3.call(this,p1,p2,p3);
default:
var G__8822 = null;
if (arguments.length > 3) {
var G__8823__i = 0, G__8823__a = new Array(arguments.length -  3);
while (G__8823__i < G__8823__a.length) {G__8823__a[G__8823__i] = arguments[G__8823__i + 3]; ++G__8823__i;}
G__8822 = new cljs.core.IndexedSeq(G__8823__a,0);
}
return cljs$core$some_fn__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__8822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn.cljs$lang$applyTo = cljs$core$some_fn__4.cljs$lang$applyTo;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn__1;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn__2;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn__3;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn;
})()
;
/**
 * Returns a lazy sequence consisting of the result of applying f to
 * the set of first items of each coll, followed by applying f to the
 * set of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments. Returns a transducer when
 * no collection is provided.
 * @param {...*} var_args
 */
cljs.core.map = (function() {
var cljs$core$map = null;
var cljs$core$map__1 = (function (f){
return (function (rf){
return (function() {
var G__8878 = null;
var G__8878__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8878__1 = (function (result){
var G__8864 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8864) : rf.call(null,G__8864));
});
var G__8878__2 = (function (result,input){
var G__8865 = result;
var G__8866 = (function (){var G__8867 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8867) : f.call(null,G__8867));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8865,G__8866) : rf.call(null,G__8865,G__8866));
});
var G__8878__3 = (function() { 
var G__8879__delegate = function (result,input,inputs){
var G__8868 = result;
var G__8869 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8868,G__8869) : rf.call(null,G__8868,G__8869));
};
var G__8879 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__8880__i = 0, G__8880__a = new Array(arguments.length -  2);
while (G__8880__i < G__8880__a.length) {G__8880__a[G__8880__i] = arguments[G__8880__i + 2]; ++G__8880__i;}
  inputs = new cljs.core.IndexedSeq(G__8880__a,0);
} 
return G__8879__delegate.call(this,result,input,inputs);};
G__8879.cljs$lang$maxFixedArity = 2;
G__8879.cljs$lang$applyTo = (function (arglist__8881){
var result = cljs.core.first(arglist__8881);
arglist__8881 = cljs.core.next(arglist__8881);
var input = cljs.core.first(arglist__8881);
var inputs = cljs.core.rest(arglist__8881);
return G__8879__delegate(result,input,inputs);
});
G__8879.cljs$core$IFn$_invoke$arity$variadic = G__8879__delegate;
return G__8879;
})()
;
G__8878 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__8878__0.call(this);
case 1:
return G__8878__1.call(this,result);
case 2:
return G__8878__2.call(this,result,input);
default:
var G__8882 = null;
if (arguments.length > 2) {
var G__8883__i = 0, G__8883__a = new Array(arguments.length -  2);
while (G__8883__i < G__8883__a.length) {G__8883__a[G__8883__i] = arguments[G__8883__i + 2]; ++G__8883__i;}
G__8882 = new cljs.core.IndexedSeq(G__8883__a,0);
}
return G__8878__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__8882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8878.cljs$lang$maxFixedArity = 2;
G__8878.cljs$lang$applyTo = G__8878__3.cljs$lang$applyTo;
G__8878.cljs$core$IFn$_invoke$arity$0 = G__8878__0;
G__8878.cljs$core$IFn$_invoke$arity$1 = G__8878__1;
G__8878.cljs$core$IFn$_invoke$arity$2 = G__8878__2;
G__8878.cljs$core$IFn$_invoke$arity$variadic = G__8878__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8878;
})()
});
});
var cljs$core$map__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4652__auto___8884 = size;
var i_8885 = (0);
while(true){
if((i_8885 < n__4652__auto___8884)){
cljs.core.chunk_append(b,(function (){var G__8870 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8885);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8870) : f.call(null,G__8870));
})());

var G__8886 = (i_8885 + (1));
i_8885 = G__8886;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__8871 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8871) : f.call(null,G__8871));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
var cljs$core$map__3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__8872 = cljs.core.first(s1);
var G__8873 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8872,G__8873) : f.call(null,G__8872,G__8873));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});
var cljs$core$map__4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__8874 = cljs.core.first(s1);
var G__8875 = cljs.core.first(s2);
var G__8876 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8874,G__8875,G__8876) : f.call(null,G__8874,G__8875,G__8876));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});
var cljs$core$map__5 = (function() { 
var G__8887__delegate = function (f,c1,c2,c3,colls){
var step = (function cljs$core$map_$_step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$map_$_step(cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs$core$map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__8824_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__8824_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
};
var G__8887 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__8888__i = 0, G__8888__a = new Array(arguments.length -  4);
while (G__8888__i < G__8888__a.length) {G__8888__a[G__8888__i] = arguments[G__8888__i + 4]; ++G__8888__i;}
  colls = new cljs.core.IndexedSeq(G__8888__a,0);
} 
return G__8887__delegate.call(this,f,c1,c2,c3,colls);};
G__8887.cljs$lang$maxFixedArity = 4;
G__8887.cljs$lang$applyTo = (function (arglist__8889){
var f = cljs.core.first(arglist__8889);
arglist__8889 = cljs.core.next(arglist__8889);
var c1 = cljs.core.first(arglist__8889);
arglist__8889 = cljs.core.next(arglist__8889);
var c2 = cljs.core.first(arglist__8889);
arglist__8889 = cljs.core.next(arglist__8889);
var c3 = cljs.core.first(arglist__8889);
var colls = cljs.core.rest(arglist__8889);
return G__8887__delegate(f,c1,c2,c3,colls);
});
G__8887.cljs$core$IFn$_invoke$arity$variadic = G__8887__delegate;
return G__8887;
})()
;
cljs$core$map = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$map__1.call(this,f);
case 2:
return cljs$core$map__2.call(this,f,c1);
case 3:
return cljs$core$map__3.call(this,f,c1,c2);
case 4:
return cljs$core$map__4.call(this,f,c1,c2,c3);
default:
var G__8890 = null;
if (arguments.length > 4) {
var G__8891__i = 0, G__8891__a = new Array(arguments.length -  4);
while (G__8891__i < G__8891__a.length) {G__8891__a[G__8891__i] = arguments[G__8891__i + 4]; ++G__8891__i;}
G__8890 = new cljs.core.IndexedSeq(G__8891__a,0);
}
return cljs$core$map__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__8890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$map.cljs$lang$maxFixedArity = 4;
cljs$core$map.cljs$lang$applyTo = cljs$core$map__5.cljs$lang$applyTo;
cljs$core$map.cljs$core$IFn$_invoke$arity$1 = cljs$core$map__1;
cljs$core$map.cljs$core$IFn$_invoke$arity$2 = cljs$core$map__2;
cljs$core$map.cljs$core$IFn$_invoke$arity$3 = cljs$core$map__3;
cljs$core$map.cljs$core$IFn$_invoke$arity$4 = cljs$core$map__4;
cljs$core$map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$map__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$map;
})()
;
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 * there are fewer than n.  Returns a stateful transducer when
 * no collection is provided.
 */
cljs.core.take = (function() {
var cljs$core$take = null;
var cljs$core$take__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8900 = null;
var G__8900__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8900__1 = (function (result){
var G__8897 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8897) : rf.call(null,G__8897));
});
var G__8900__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__8898 = result;
var G__8899 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8898,G__8899) : rf.call(null,G__8898,G__8899));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__8900 = function(result,input){
switch(arguments.length){
case 0:
return G__8900__0.call(this);
case 1:
return G__8900__1.call(this,result);
case 2:
return G__8900__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8900.cljs$core$IFn$_invoke$arity$0 = G__8900__0;
G__8900.cljs$core$IFn$_invoke$arity$1 = G__8900__1;
G__8900.cljs$core$IFn$_invoke$arity$2 = G__8900__2;
return G__8900;
})()
;})(na))
});
});
var cljs$core$take__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs$core$take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
cljs$core$take = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$take__1.call(this,n);
case 2:
return cljs$core$take__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take.cljs$core$IFn$_invoke$arity$1 = cljs$core$take__1;
cljs$core$take.cljs$core$IFn$_invoke$arity$2 = cljs$core$take__2;
return cljs$core$take;
})()
;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 * Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function() {
var cljs$core$drop = null;
var cljs$core$drop__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8907 = null;
var G__8907__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8907__1 = (function (result){
var G__8904 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8904) : rf.call(null,G__8904));
});
var G__8907__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__8905 = result;
var G__8906 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8905,G__8906) : rf.call(null,G__8905,G__8906));
}
});
G__8907 = function(result,input){
switch(arguments.length){
case 0:
return G__8907__0.call(this);
case 1:
return G__8907__1.call(this,result);
case 2:
return G__8907__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8907.cljs$core$IFn$_invoke$arity$0 = G__8907__0;
G__8907.cljs$core$IFn$_invoke$arity$1 = G__8907__1;
G__8907.cljs$core$IFn$_invoke$arity$2 = G__8907__2;
return G__8907;
})()
;})(na))
});
});
var cljs$core$drop__2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__8908 = (n__$1 - (1));
var G__8909 = cljs.core.rest(s);
n__$1 = G__8908;
coll__$1 = G__8909;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});
cljs$core$drop = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$drop__1.call(this,n);
case 2:
return cljs$core$drop__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop__1;
cljs$core$drop.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop__2;
return cljs$core$drop;
})()
;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function() {
var cljs$core$drop_last = null;
var cljs$core$drop_last__1 = (function (s){
return cljs$core$drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});
var cljs$core$drop_last__2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});
cljs$core$drop_last = function(n,s){
switch(arguments.length){
case 1:
return cljs$core$drop_last__1.call(this,n);
case 2:
return cljs$core$drop_last__2.call(this,n,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop_last.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop_last__1;
cljs$core$drop_last.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop_last__2;
return cljs$core$drop_last;
})()
;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 * of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__8912 = cljs.core.next(s);
var G__8913 = cljs.core.next(lead);
s = G__8912;
lead = G__8913;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 * first item for which (pred item) returns logical false.  Returns a
 * stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function() {
var cljs$core$drop_while = null;
var cljs$core$drop_while__1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__8926 = null;
var G__8926__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8926__1 = (function (result){
var G__8920 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8920) : rf.call(null,G__8920));
});
var G__8926__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__3755__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__3755__auto__)){
var G__8921 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8921) : pred.call(null,G__8921));
} else {
return and__3755__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__8922 = result;
var G__8923 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8922,G__8923) : rf.call(null,G__8922,G__8923));
}
});
G__8926 = function(result,input){
switch(arguments.length){
case 0:
return G__8926__0.call(this);
case 1:
return G__8926__1.call(this,result);
case 2:
return G__8926__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8926.cljs$core$IFn$_invoke$arity$0 = G__8926__0;
G__8926.cljs$core$IFn$_invoke$arity$1 = G__8926__1;
G__8926.cljs$core$IFn$_invoke$arity$2 = G__8926__2;
return G__8926;
})()
;})(da))
});
});
var cljs$core$drop_while__2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__3755__auto__ = s;
if(and__3755__auto__){
var G__8925 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__8925) : pred__$1.call(null,G__8925));
} else {
return and__3755__auto__;
}
})())){
var G__8927 = pred__$1;
var G__8928 = cljs.core.rest(s);
pred__$1 = G__8927;
coll__$1 = G__8928;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});
cljs$core$drop_while = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$drop_while__1.call(this,pred);
case 2:
return cljs$core$drop_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop_while.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop_while__1;
cljs$core$drop_while.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop_while__2;
return cljs$core$drop_while;
})()
;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function() {
var cljs$core$repeat = null;
var cljs$core$repeat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs$core$repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});
var cljs$core$repeat__2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs$core$repeat.cljs$core$IFn$_invoke$arity$1(x));
});
cljs$core$repeat = function(n,x){
switch(arguments.length){
case 1:
return cljs$core$repeat__1.call(this,n);
case 2:
return cljs$core$repeat__2.call(this,n,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$repeat.cljs$core$IFn$_invoke$arity$1 = cljs$core$repeat__1;
cljs$core$repeat.cljs$core$IFn$_invoke$arity$2 = cljs$core$repeat__2;
return cljs$core$repeat;
})()
;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 * returns an infinite (or length n if supplied) lazy sequence of calls
 * to it
 */
cljs.core.repeatedly = (function() {
var cljs$core$repeatedly = null;
var cljs$core$repeatedly__1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});
var cljs$core$repeatedly__2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});
cljs$core$repeatedly = function(n,f){
switch(arguments.length){
case 1:
return cljs$core$repeatedly__1.call(this,n);
case 2:
return cljs$core$repeatedly__2.call(this,n,f);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1 = cljs$core$repeatedly__1;
cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$2 = cljs$core$repeatedly__2;
return cljs$core$repeatedly;
})()
;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(function (){var G__8937 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8937) : f.call(null,G__8937));
})());
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 * @param {...*} var_args
 */
cljs.core.interleave = (function() {
var cljs$core$interleave = null;
var cljs$core$interleave__2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs$core$interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});
var cljs$core$interleave__3 = (function() { 
var G__8940__delegate = function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs$core$interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
};
var G__8940 = function (c1,c2,var_args){
var colls = null;
if (arguments.length > 2) {
var G__8941__i = 0, G__8941__a = new Array(arguments.length -  2);
while (G__8941__i < G__8941__a.length) {G__8941__a[G__8941__i] = arguments[G__8941__i + 2]; ++G__8941__i;}
  colls = new cljs.core.IndexedSeq(G__8941__a,0);
} 
return G__8940__delegate.call(this,c1,c2,colls);};
G__8940.cljs$lang$maxFixedArity = 2;
G__8940.cljs$lang$applyTo = (function (arglist__8942){
var c1 = cljs.core.first(arglist__8942);
arglist__8942 = cljs.core.next(arglist__8942);
var c2 = cljs.core.first(arglist__8942);
var colls = cljs.core.rest(arglist__8942);
return G__8940__delegate(c1,c2,colls);
});
G__8940.cljs$core$IFn$_invoke$arity$variadic = G__8940__delegate;
return G__8940;
})()
;
cljs$core$interleave = function(c1,c2,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return cljs$core$interleave__2.call(this,c1,c2);
default:
var G__8943 = null;
if (arguments.length > 2) {
var G__8944__i = 0, G__8944__a = new Array(arguments.length -  2);
while (G__8944__i < G__8944__a.length) {G__8944__a[G__8944__i] = arguments[G__8944__i + 2]; ++G__8944__i;}
G__8943 = new cljs.core.IndexedSeq(G__8944__a,0);
}
return cljs$core$interleave__3.cljs$core$IFn$_invoke$arity$variadic(c1,c2, G__8943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$interleave.cljs$lang$maxFixedArity = 2;
cljs$core$interleave.cljs$lang$applyTo = cljs$core$interleave__3.cljs$lang$applyTo;
cljs$core$interleave.cljs$core$IFn$_invoke$arity$2 = cljs$core$interleave__2;
cljs$core$interleave.cljs$core$IFn$_invoke$arity$variadic = cljs$core$interleave__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$interleave;
})()
;
/**
 * Returns a lazy seq of the elements of coll separated by sep
 */
cljs.core.interpose = (function() {
var cljs$core$interpose = null;
var cljs$core$interpose__1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__8959 = null;
var G__8959__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8959__1 = (function (result){
var G__8952 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8952) : rf.call(null,G__8952));
});
var G__8959__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__8953 = result;
var G__8954 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8953,G__8954) : rf.call(null,G__8953,G__8954));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__8955 = sepr;
var G__8956 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8955,G__8956) : rf.call(null,G__8955,G__8956));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__8957 = result;
var G__8958 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8957,G__8958) : rf.call(null,G__8957,G__8958));
}
});
G__8959 = function(result,input){
switch(arguments.length){
case 0:
return G__8959__0.call(this);
case 1:
return G__8959__1.call(this,result);
case 2:
return G__8959__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8959.cljs$core$IFn$_invoke$arity$0 = G__8959__0;
G__8959.cljs$core$IFn$_invoke$arity$1 = G__8959__1;
G__8959.cljs$core$IFn$_invoke$arity$2 = G__8959__2;
return G__8959;
})()
;})(started))
});
});
var cljs$core$interpose__2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});
cljs$core$interpose = function(sep,coll){
switch(arguments.length){
case 1:
return cljs$core$interpose__1.call(this,sep);
case 2:
return cljs$core$interpose__2.call(this,sep,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$interpose.cljs$core$IFn$_invoke$arity$1 = cljs$core$interpose__1;
cljs$core$interpose.cljs$core$IFn$_invoke$arity$2 = cljs$core$interpose__2;
return cljs$core$interpose;
})()
;
/**
 * Take a collection of collections, and return a lazy seq
 * of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var coll__$1 = temp__4124__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 * to f and colls.  Thus function f should return a collection. Returns
 * a transducer when no collections are provided
 * @param {...*} var_args
 */
cljs.core.mapcat = (function() {
var cljs$core$mapcat = null;
var cljs$core$mapcat__1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});
var cljs$core$mapcat__2 = (function() { 
var G__8968__delegate = function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
};
var G__8968 = function (f,var_args){
var colls = null;
if (arguments.length > 1) {
var G__8969__i = 0, G__8969__a = new Array(arguments.length -  1);
while (G__8969__i < G__8969__a.length) {G__8969__a[G__8969__i] = arguments[G__8969__i + 1]; ++G__8969__i;}
  colls = new cljs.core.IndexedSeq(G__8969__a,0);
} 
return G__8968__delegate.call(this,f,colls);};
G__8968.cljs$lang$maxFixedArity = 1;
G__8968.cljs$lang$applyTo = (function (arglist__8970){
var f = cljs.core.first(arglist__8970);
var colls = cljs.core.rest(arglist__8970);
return G__8968__delegate(f,colls);
});
G__8968.cljs$core$IFn$_invoke$arity$variadic = G__8968__delegate;
return G__8968;
})()
;
cljs$core$mapcat = function(f,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$mapcat__1.call(this,f);
default:
var G__8971 = null;
if (arguments.length > 1) {
var G__8972__i = 0, G__8972__a = new Array(arguments.length -  1);
while (G__8972__i < G__8972__a.length) {G__8972__a[G__8972__i] = arguments[G__8972__i + 1]; ++G__8972__i;}
G__8971 = new cljs.core.IndexedSeq(G__8972__a,0);
}
return cljs$core$mapcat__2.cljs$core$IFn$_invoke$arity$variadic(f, G__8971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$mapcat.cljs$lang$maxFixedArity = 1;
cljs$core$mapcat.cljs$lang$applyTo = cljs$core$mapcat__2.cljs$lang$applyTo;
cljs$core$mapcat.cljs$core$IFn$_invoke$arity$1 = cljs$core$mapcat__1;
cljs$core$mapcat.cljs$core$IFn$_invoke$arity$variadic = cljs$core$mapcat__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$mapcat;
})()
;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function() {
var cljs$core$filter = null;
var cljs$core$filter__1 = (function (pred){
return (function (rf){
return (function() {
var G__8991 = null;
var G__8991__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8991__1 = (function (result){
var G__8985 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8985) : rf.call(null,G__8985));
});
var G__8991__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__8986 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8986) : pred.call(null,G__8986));
})())){
var G__8987 = result;
var G__8988 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8987,G__8988) : rf.call(null,G__8987,G__8988));
} else {
return result;
}
});
G__8991 = function(result,input){
switch(arguments.length){
case 0:
return G__8991__0.call(this);
case 1:
return G__8991__1.call(this,result);
case 2:
return G__8991__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8991.cljs$core$IFn$_invoke$arity$0 = G__8991__0;
G__8991.cljs$core$IFn$_invoke$arity$1 = G__8991__1;
G__8991.cljs$core$IFn$_invoke$arity$2 = G__8991__2;
return G__8991;
})()
});
});
var cljs$core$filter__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4652__auto___8992 = size;
var i_8993 = (0);
while(true){
if((i_8993 < n__4652__auto___8992)){
if(cljs.core.truth_((function (){var G__8989 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8993);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8989) : pred.call(null,G__8989));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8993));
} else {
}

var G__8994 = (i_8993 + (1));
i_8993 = G__8994;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__8990 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8990) : pred.call(null,G__8990));
})())){
return cljs.core.cons(f,cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});
cljs$core$filter = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$filter__1.call(this,pred);
case 2:
return cljs$core$filter__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$filter.cljs$core$IFn$_invoke$arity$1 = cljs$core$filter__1;
cljs$core$filter.cljs$core$IFn$_invoke$arity$2 = cljs$core$filter__2;
return cljs$core$filter;
})()
;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns false. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function() {
var cljs$core$remove = null;
var cljs$core$remove__1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});
var cljs$core$remove__2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});
cljs$core$remove = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$remove__1.call(this,pred);
case 2:
return cljs$core$remove__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$remove.cljs$core$IFn$_invoke$arity$1 = cljs$core$remove__1;
cljs$core$remove.cljs$core$IFn$_invoke$arity$2 = cljs$core$remove__2;
return cljs$core$remove;
})()
;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 * tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__9001 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__9001) : branch_QMARK_.call(null,G__9001));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(function (){var G__9002 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__9002) : children.call(null,G__9002));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 * etc.) and returns their contents as a single, flat sequence.
 * (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__9003_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__9003_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 * from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function() {
var cljs$core$into = null;
var cljs$core$into__2 = (function (to,from){
if(!((to == null))){
if((function (){var G__9006 = to;
if(G__9006){
var bit__4434__auto__ = (G__9006.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4434__auto__) || (G__9006.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});
var cljs$core$into__3 = (function (to,xform,from){
if((function (){var G__9007 = to;
if(G__9007){
var bit__4434__auto__ = (G__9007.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4434__auto__) || (G__9007.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});
cljs$core$into = function(to,xform,from){
switch(arguments.length){
case 2:
return cljs$core$into__2.call(this,to,xform);
case 3:
return cljs$core$into__3.call(this,to,xform,from);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$into.cljs$core$IFn$_invoke$arity$2 = cljs$core$into__2;
cljs$core$into.cljs$core$IFn$_invoke$arity$3 = cljs$core$into__3;
return cljs$core$into;
})()
;
/**
 * Returns a vector consisting of the result of applying f to the
 * set of first items of each coll, followed by applying f to the set
 * of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments.
 * @param {...*} var_args
 */
cljs.core.mapv = (function() {
var cljs$core$mapv = null;
var cljs$core$mapv__2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__9009 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9009) : f.call(null,G__9009));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
var cljs$core$mapv__3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});
var cljs$core$mapv__4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});
var cljs$core$mapv__5 = (function() { 
var G__9010__delegate = function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
};
var G__9010 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__9011__i = 0, G__9011__a = new Array(arguments.length -  4);
while (G__9011__i < G__9011__a.length) {G__9011__a[G__9011__i] = arguments[G__9011__i + 4]; ++G__9011__i;}
  colls = new cljs.core.IndexedSeq(G__9011__a,0);
} 
return G__9010__delegate.call(this,f,c1,c2,c3,colls);};
G__9010.cljs$lang$maxFixedArity = 4;
G__9010.cljs$lang$applyTo = (function (arglist__9012){
var f = cljs.core.first(arglist__9012);
arglist__9012 = cljs.core.next(arglist__9012);
var c1 = cljs.core.first(arglist__9012);
arglist__9012 = cljs.core.next(arglist__9012);
var c2 = cljs.core.first(arglist__9012);
arglist__9012 = cljs.core.next(arglist__9012);
var c3 = cljs.core.first(arglist__9012);
var colls = cljs.core.rest(arglist__9012);
return G__9010__delegate(f,c1,c2,c3,colls);
});
G__9010.cljs$core$IFn$_invoke$arity$variadic = G__9010__delegate;
return G__9010;
})()
;
cljs$core$mapv = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return cljs$core$mapv__2.call(this,f,c1);
case 3:
return cljs$core$mapv__3.call(this,f,c1,c2);
case 4:
return cljs$core$mapv__4.call(this,f,c1,c2,c3);
default:
var G__9013 = null;
if (arguments.length > 4) {
var G__9014__i = 0, G__9014__a = new Array(arguments.length -  4);
while (G__9014__i < G__9014__a.length) {G__9014__a[G__9014__i] = arguments[G__9014__i + 4]; ++G__9014__i;}
G__9013 = new cljs.core.IndexedSeq(G__9014__a,0);
}
return cljs$core$mapv__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__9013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$mapv.cljs$lang$maxFixedArity = 4;
cljs$core$mapv.cljs$lang$applyTo = cljs$core$mapv__5.cljs$lang$applyTo;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$2 = cljs$core$mapv__2;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$3 = cljs$core$mapv__3;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$4 = cljs$core$mapv__4;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$variadic = cljs$core$mapv__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$mapv;
})()
;
/**
 * Returns a vector of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__9016 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9016) : pred.call(null,G__9016));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 * apart. If step is not supplied, defaults to n, i.e. the partitions
 * do not overlap. If a pad collection is supplied, use its elements as
 * necessary to complete last partition up to n items. In case there are
 * not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function() {
var cljs$core$partition = null;
var cljs$core$partition__2 = (function (n,coll){
return cljs$core$partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var cljs$core$partition__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs$core$partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
var cljs$core$partition__4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs$core$partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});
cljs$core$partition = function(n,step,pad,coll){
switch(arguments.length){
case 2:
return cljs$core$partition__2.call(this,n,step);
case 3:
return cljs$core$partition__3.call(this,n,step,pad);
case 4:
return cljs$core$partition__4.call(this,n,step,pad,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition__2;
cljs$core$partition.cljs$core$IFn$_invoke$arity$3 = cljs$core$partition__3;
cljs$core$partition.cljs$core$IFn$_invoke$arity$4 = cljs$core$partition__4;
return cljs$core$partition;
})()
;
/**
 * Returns the value in a nested associative structure,
 * where ks is a sequence of keys. Returns nil if the key is not present,
 * or the not-found value if supplied.
 */
cljs.core.get_in = (function() {
var cljs$core$get_in = null;
var cljs$core$get_in__2 = (function (m,ks){
return cljs$core$get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});
var cljs$core$get_in__3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__9031 = m__$1;
if(G__9031){
var bit__4441__auto__ = (G__9031.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4441__auto__) || (G__9031.cljs$core$ILookup$)){
return true;
} else {
if((!G__9031.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9031);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9031);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__9032 = sentinel;
var G__9033 = m__$2;
var G__9034 = cljs.core.next(ks__$1);
sentinel = G__9032;
m__$1 = G__9033;
ks__$1 = G__9034;
continue;
}
}
} else {
return m__$1;
}
break;
}
});
cljs$core$get_in = function(m,ks,not_found){
switch(arguments.length){
case 2:
return cljs$core$get_in__2.call(this,m,ks);
case 3:
return cljs$core$get_in__3.call(this,m,ks,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$get_in.cljs$core$IFn$_invoke$arity$2 = cljs$core$get_in__2;
cljs$core$get_in.cljs$core$IFn$_invoke$arity$3 = cljs$core$get_in__3;
return cljs$core$get_in;
})()
;
/**
 * Associates a value in a nested associative structure, where ks is a
 * sequence of keys and v is the new value and returns a new nested structure.
 * If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__9035,v){
var vec__9040 = p__9035;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9040,(0),null);
var ks = cljs.core.nthnext(vec__9040,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 * sequence of keys and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * nested structure.  If any levels do not exist, hash-maps will be
 * created.
 * @param {...*} var_args
 */
cljs.core.update_in = (function() {
var cljs$core$update_in = null;
var cljs$core$update_in__3 = (function (m,p__9041,f){
var vec__9079 = p__9041;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9079,(0),null);
var ks = cljs.core.nthnext(vec__9079,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9080 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9080) : f.call(null,G__9080));
})());
}
});
var cljs$core$update_in__4 = (function (m,p__9042,f,a){
var vec__9081 = p__9042;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9081,(0),null);
var ks = cljs.core.nthnext(vec__9081,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9082 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9083 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9082,G__9083) : f.call(null,G__9082,G__9083));
})());
}
});
var cljs$core$update_in__5 = (function (m,p__9043,f,a,b){
var vec__9084 = p__9043;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9084,(0),null);
var ks = cljs.core.nthnext(vec__9084,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9085 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9086 = a;
var G__9087 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9085,G__9086,G__9087) : f.call(null,G__9085,G__9086,G__9087));
})());
}
});
var cljs$core$update_in__6 = (function (m,p__9044,f,a,b,c){
var vec__9088 = p__9044;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9088,(0),null);
var ks = cljs.core.nthnext(vec__9088,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9089 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9090 = a;
var G__9091 = b;
var G__9092 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9089,G__9090,G__9091,G__9092) : f.call(null,G__9089,G__9090,G__9091,G__9092));
})());
}
});
var cljs$core$update_in__7 = (function() { 
var G__9094__delegate = function (m,p__9045,f,a,b,c,args){
var vec__9093 = p__9045;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9093,(0),null);
var ks = cljs.core.nthnext(vec__9093,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs$core$update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
};
var G__9094 = function (m,p__9045,f,a,b,c,var_args){
var args = null;
if (arguments.length > 6) {
var G__9095__i = 0, G__9095__a = new Array(arguments.length -  6);
while (G__9095__i < G__9095__a.length) {G__9095__a[G__9095__i] = arguments[G__9095__i + 6]; ++G__9095__i;}
  args = new cljs.core.IndexedSeq(G__9095__a,0);
} 
return G__9094__delegate.call(this,m,p__9045,f,a,b,c,args);};
G__9094.cljs$lang$maxFixedArity = 6;
G__9094.cljs$lang$applyTo = (function (arglist__9096){
var m = cljs.core.first(arglist__9096);
arglist__9096 = cljs.core.next(arglist__9096);
var p__9045 = cljs.core.first(arglist__9096);
arglist__9096 = cljs.core.next(arglist__9096);
var f = cljs.core.first(arglist__9096);
arglist__9096 = cljs.core.next(arglist__9096);
var a = cljs.core.first(arglist__9096);
arglist__9096 = cljs.core.next(arglist__9096);
var b = cljs.core.first(arglist__9096);
arglist__9096 = cljs.core.next(arglist__9096);
var c = cljs.core.first(arglist__9096);
var args = cljs.core.rest(arglist__9096);
return G__9094__delegate(m,p__9045,f,a,b,c,args);
});
G__9094.cljs$core$IFn$_invoke$arity$variadic = G__9094__delegate;
return G__9094;
})()
;
cljs$core$update_in = function(m,p__9045,f,a,b,c,var_args){
var args = var_args;
switch(arguments.length){
case 3:
return cljs$core$update_in__3.call(this,m,p__9045,f);
case 4:
return cljs$core$update_in__4.call(this,m,p__9045,f,a);
case 5:
return cljs$core$update_in__5.call(this,m,p__9045,f,a,b);
case 6:
return cljs$core$update_in__6.call(this,m,p__9045,f,a,b,c);
default:
var G__9097 = null;
if (arguments.length > 6) {
var G__9098__i = 0, G__9098__a = new Array(arguments.length -  6);
while (G__9098__i < G__9098__a.length) {G__9098__a[G__9098__i] = arguments[G__9098__i + 6]; ++G__9098__i;}
G__9097 = new cljs.core.IndexedSeq(G__9098__a,0);
}
return cljs$core$update_in__7.cljs$core$IFn$_invoke$arity$variadic(m,p__9045,f,a,b,c, G__9097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$update_in.cljs$lang$maxFixedArity = 6;
cljs$core$update_in.cljs$lang$applyTo = cljs$core$update_in__7.cljs$lang$applyTo;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$3 = cljs$core$update_in__3;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$4 = cljs$core$update_in__4;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$5 = cljs$core$update_in__5;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$6 = cljs$core$update_in__6;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$variadic = cljs$core$update_in__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$update_in;
})()
;
/**
 * 'Updates' a value in an associative structure, where k is a
 * key and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * structure.  If the key does not exist, nil is passed as the old value.
 * @param {...*} var_args
 */
cljs.core.update = (function() {
var cljs$core$update = null;
var cljs$core$update__3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9109 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9109) : f.call(null,G__9109));
})());
});
var cljs$core$update__4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9111 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9110,G__9111) : f.call(null,G__9110,G__9111));
})());
});
var cljs$core$update__5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9112 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9113 = x;
var G__9114 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9112,G__9113,G__9114) : f.call(null,G__9112,G__9113,G__9114));
})());
});
var cljs$core$update__6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9116 = x;
var G__9117 = y;
var G__9118 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9115,G__9116,G__9117,G__9118) : f.call(null,G__9115,G__9116,G__9117,G__9118));
})());
});
var cljs$core$update__7 = (function() { 
var G__9119__delegate = function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
};
var G__9119 = function (m,k,f,x,y,z,var_args){
var more = null;
if (arguments.length > 6) {
var G__9120__i = 0, G__9120__a = new Array(arguments.length -  6);
while (G__9120__i < G__9120__a.length) {G__9120__a[G__9120__i] = arguments[G__9120__i + 6]; ++G__9120__i;}
  more = new cljs.core.IndexedSeq(G__9120__a,0);
} 
return G__9119__delegate.call(this,m,k,f,x,y,z,more);};
G__9119.cljs$lang$maxFixedArity = 6;
G__9119.cljs$lang$applyTo = (function (arglist__9121){
var m = cljs.core.first(arglist__9121);
arglist__9121 = cljs.core.next(arglist__9121);
var k = cljs.core.first(arglist__9121);
arglist__9121 = cljs.core.next(arglist__9121);
var f = cljs.core.first(arglist__9121);
arglist__9121 = cljs.core.next(arglist__9121);
var x = cljs.core.first(arglist__9121);
arglist__9121 = cljs.core.next(arglist__9121);
var y = cljs.core.first(arglist__9121);
arglist__9121 = cljs.core.next(arglist__9121);
var z = cljs.core.first(arglist__9121);
var more = cljs.core.rest(arglist__9121);
return G__9119__delegate(m,k,f,x,y,z,more);
});
G__9119.cljs$core$IFn$_invoke$arity$variadic = G__9119__delegate;
return G__9119;
})()
;
cljs$core$update = function(m,k,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 3:
return cljs$core$update__3.call(this,m,k,f);
case 4:
return cljs$core$update__4.call(this,m,k,f,x);
case 5:
return cljs$core$update__5.call(this,m,k,f,x,y);
case 6:
return cljs$core$update__6.call(this,m,k,f,x,y,z);
default:
var G__9122 = null;
if (arguments.length > 6) {
var G__9123__i = 0, G__9123__a = new Array(arguments.length -  6);
while (G__9123__i < G__9123__a.length) {G__9123__a[G__9123__i] = arguments[G__9123__i + 6]; ++G__9123__i;}
G__9122 = new cljs.core.IndexedSeq(G__9123__a,0);
}
return cljs$core$update__7.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x,y,z, G__9122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$update.cljs$lang$maxFixedArity = 6;
cljs$core$update.cljs$lang$applyTo = cljs$core$update__7.cljs$lang$applyTo;
cljs$core$update.cljs$core$IFn$_invoke$arity$3 = cljs$core$update__3;
cljs$core$update.cljs$core$IFn$_invoke$arity$4 = cljs$core$update__4;
cljs$core$update.cljs$core$IFn$_invoke$arity$5 = cljs$core$update__5;
cljs$core$update.cljs$core$IFn$_invoke$arity$6 = cljs$core$update__6;
cljs$core$update.cljs$core$IFn$_invoke$arity$variadic = cljs$core$update__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$update;
})()
;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__9124 = (ll - (5));
var G__9125 = r;
ll = G__9124;
ret = G__9125;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9130 = cljs.core.pv_aget(node,(0));
var G__9131 = (level - (5));
node = G__9130;
level = G__9131;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9132 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__9133 = (level - (5));
node = G__9132;
level = G__9133;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9143 = init__$2;
var G__9144 = (j + i);
var G__9145 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9143,G__9144,G__9145) : f.call(null,G__9143,G__9144,G__9145));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9156 = (j + (1));
var G__9157 = init__$3;
j = G__9156;
init__$2 = G__9157;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9146 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9146) : cljs.core.deref.call(null,G__9146));
} else {
var G__9158 = (i + len);
var G__9159 = init__$2;
i = G__9158;
init__$1 = G__9159;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__9147 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__9147) : cljs.core.tv_editable_root.call(null,G__9147));
})(),(function (){var G__9148 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__9148) : cljs.core.tv_editable_tail.call(null,G__9148));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9149 = init__$2;
var G__9150 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9149,G__9150) : f.call(null,G__9149,G__9150));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9160 = (j + (1));
var G__9161 = init__$3;
j = G__9160;
init__$2 = G__9161;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9151 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9151) : cljs.core.deref.call(null,G__9151));
} else {
var G__9162 = (i + len);
var G__9163 = init__$2;
i = G__9162;
init__$1 = G__9163;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__9152 = coll__$1;
var G__9153 = cljs.core.first_array_for_longvec(coll__$1);
var G__9154 = (0);
var G__9155 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9152,G__9153,G__9154,G__9155) : cljs.core.chunked_seq.call(null,G__9152,G__9153,G__9154,G__9155));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4652__auto___9164 = len;
var i_9165 = (0);
while(true){
if((i_9165 < n__4652__auto___9164)){
(new_tail[i_9165] = (self__.tail[i_9165]));

var G__9166 = (i_9165 + (1));
i_9165 = G__9166;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__9167 = null;
var G__9167__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9167__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9167 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9167__2.call(this,self__,k);
case 3:
return G__9167__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9167.cljs$core$IFn$_invoke$arity$2 = G__9167__2;
G__9167.cljs$core$IFn$_invoke$arity$3 = G__9167__3;
return G__9167;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args9142){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9142)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__9168 = (i + (1));
var G__9169 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__9168;
out = G__9169;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 * will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 * @param {...*} var_args
 */
cljs.core.vector = (function() { 
var cljs$core$vector__delegate = function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
};
var cljs$core$vector = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9170__i = 0, G__9170__a = new Array(arguments.length -  0);
while (G__9170__i < G__9170__a.length) {G__9170__a[G__9170__i] = arguments[G__9170__i + 0]; ++G__9170__i;}
  args = new cljs.core.IndexedSeq(G__9170__a,0);
} 
return cljs$core$vector__delegate.call(this,args);};
cljs$core$vector.cljs$lang$maxFixedArity = 0;
cljs$core$vector.cljs$lang$applyTo = (function (arglist__9171){
var args = cljs.core.seq(arglist__9171);
return cljs$core$vector__delegate(args);
});
cljs$core$vector.cljs$core$IFn$_invoke$arity$variadic = cljs$core$vector__delegate;
return cljs$core$vector;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9172 = self__.vec;
var G__9173 = self__.node;
var G__9174 = self__.i;
var G__9175 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9172,G__9173,G__9174,G__9175) : cljs.core.chunked_seq.call(null,G__9172,G__9173,G__9174,G__9175));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__9176 = self__.vec;
var G__9177 = (self__.i + self__.off);
var G__9178 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9176,G__9177,G__9178) : cljs.core.subvec.call(null,G__9176,G__9177,G__9178));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__9179 = self__.vec;
var G__9180 = (self__.i + self__.off);
var G__9181 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9179,G__9180,G__9181) : cljs.core.subvec.call(null,G__9179,G__9180,G__9181));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9182 = self__.vec;
var G__9183 = self__.node;
var G__9184 = self__.i;
var G__9185 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9182,G__9183,G__9184,G__9185) : cljs.core.chunked_seq.call(null,G__9182,G__9183,G__9184,G__9185));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9186 = self__.vec;
var G__9187 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9188 = end;
var G__9189 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9186,G__9187,G__9188,G__9189) : cljs.core.chunked_seq.call(null,G__9186,G__9187,G__9188,G__9189));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__9190 = self__.vec;
var G__9191 = self__.node;
var G__9192 = self__.i;
var G__9193 = self__.off;
var G__9194 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__9190,G__9191,G__9192,G__9193,G__9194) : cljs.core.chunked_seq.call(null,G__9190,G__9191,G__9192,G__9193,G__9194));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9195 = self__.vec;
var G__9196 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9197 = end;
var G__9198 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9195,G__9196,G__9197,G__9198) : cljs.core.chunked_seq.call(null,G__9195,G__9196,G__9197,G__9198));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.chunked_seq = (function() {
var cljs$core$chunked_seq = null;
var cljs$core$chunked_seq__3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});
var cljs$core$chunked_seq__4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});
var cljs$core$chunked_seq__5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});
cljs$core$chunked_seq = function(vec,node,i,off,meta){
switch(arguments.length){
case 3:
return cljs$core$chunked_seq__3.call(this,vec,node,i);
case 4:
return cljs$core$chunked_seq__4.call(this,vec,node,i,off);
case 5:
return cljs$core$chunked_seq__5.call(this,vec,node,i,off,meta);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$3 = cljs$core$chunked_seq__3;
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$4 = cljs$core$chunked_seq__4;
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$5 = cljs$core$chunked_seq__5;
return cljs$core$chunked_seq;
})()
;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__9200 = init__$1;
var G__9201 = j;
var G__9202 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9200,G__9201,G__9202) : f.call(null,G__9200,G__9201,G__9202));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9203 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9203) : cljs.core.deref.call(null,G__9203));
} else {
var G__9225 = (i + (1));
var G__9226 = (j + (1));
var G__9227 = init__$2;
i = G__9225;
j = G__9226;
init__$1 = G__9227;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__9204 = self__.meta;
var G__9205 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__9206 = self__.start;
var G__9207 = (function (){var x__4079__auto__ = self__.end;
var y__4080__auto__ = (v_pos + (1));
return ((x__4079__auto__ > y__4080__auto__) ? x__4079__auto__ : y__4080__auto__);
})();
var G__9208 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9204,G__9205,G__9206,G__9207,G__9208) : cljs.core.build_subvec.call(null,G__9204,G__9205,G__9206,G__9207,G__9208));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__9209 = self__.meta;
var G__9210 = self__.v;
var G__9211 = self__.start;
var G__9212 = (self__.end - (1));
var G__9213 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9209,G__9210,G__9211,G__9212,G__9213) : cljs.core.build_subvec.call(null,G__9209,G__9210,G__9211,G__9212,G__9213));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__9215 = meta__$1;
var G__9216 = self__.v;
var G__9217 = self__.start;
var G__9218 = self__.end;
var G__9219 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9215,G__9216,G__9217,G__9218,G__9219) : cljs.core.build_subvec.call(null,G__9215,G__9216,G__9217,G__9218,G__9219));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__9220 = self__.meta;
var G__9221 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__9222 = self__.start;
var G__9223 = (self__.end + (1));
var G__9224 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9220,G__9221,G__9222,G__9223,G__9224) : cljs.core.build_subvec.call(null,G__9220,G__9221,G__9222,G__9223,G__9224));
});

cljs.core.Subvec.prototype.call = (function() {
var G__9228 = null;
var G__9228__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9228__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9228 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9228__2.call(this,self__,k);
case 3:
return G__9228__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9228.cljs$core$IFn$_invoke$arity$2 = G__9228__2;
G__9228.cljs$core$IFn$_invoke$arity$3 = G__9228__3;
return G__9228;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args9199){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9199)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__9229 = meta;
var G__9230 = v.v;
var G__9231 = (v.start + start);
var G__9232 = (v.start + end);
var G__9233 = __hash;
meta = G__9229;
v = G__9230;
start = G__9231;
end = G__9232;
__hash = G__9233;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 * start (inclusive) to end (exclusive).  If end is not supplied,
 * defaults to (count vector). This operation is O(1) and very fast, as
 * the resulting vector shares structure with the original and no
 * trimming is done.
 */
cljs.core.subvec = (function() {
var cljs$core$subvec = null;
var cljs$core$subvec__2 = (function (v,start){
return cljs$core$subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});
var cljs$core$subvec__3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});
cljs$core$subvec = function(v,start,end){
switch(arguments.length){
case 2:
return cljs$core$subvec__2.call(this,v,start);
case 3:
return cljs$core$subvec__3.call(this,v,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subvec.cljs$core$IFn$_invoke$arity$2 = cljs$core$subvec__2;
cljs$core$subvec.cljs$core$IFn$_invoke$arity$3 = cljs$core$subvec__3;
return cljs$core$subvec;
})()
;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj9240 = {};
return obj9240;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__9248 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__9249 = (level - (5));
node = G__9248;
level = G__9249;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 88;
})
cljs.core.TransientVector.prototype.call = (function() {
var G__9253 = null;
var G__9253__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9253__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9253 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9253__2.call(this,self__,k);
case 3:
return G__9253__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9253.cljs$core$IFn$_invoke$arity$2 = G__9253__2;
G__9253.cljs$core$IFn$_invoke$arity$3 = G__9253__3;
return G__9253;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args9250){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9250)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__3767__auto__ = self__.front;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3767__auto__ = self__.rear;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 * false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__9254 = (i + incr);
i = G__9254;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__9255 = (i + (1));
var G__9256 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__9255;
out = G__9256;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = (function (){var obj9260 = {};
return obj9260;
})();
var l = ks.length;
var i_9261 = (0);
while(true){
if((i_9261 < l)){
var k_9262 = (ks[i_9261]);
(new_obj[k_9262] = (obj[k_9262]));

var G__9263 = (i_9261 + (1));
i_9261 = G__9263;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3755__auto__ = (function (){var G__9267 = k;
return goog.isString(G__9267);
})();
if(cljs.core.truth_(and__3755__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3755__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__9268 = init__$1;
var G__9269 = k;
var G__9270 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9268,G__9269,G__9270) : f.call(null,G__9268,G__9269,G__9270));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9271 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9271) : cljs.core.deref.call(null,G__9271));
} else {
var G__9277 = cljs.core.rest(keys__$1);
var G__9278 = init__$2;
keys__$1 = G__9277;
init__$1 = G__9278;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3755__auto__ = (function (){var G__9273 = k;
return goog.isString(G__9273);
})();
if(cljs.core.truth_(and__3755__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3755__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__9274 = k;
return goog.isString(G__9274);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3755__auto__ = (function (){var G__9276 = k;
return goog.isString(G__9276);
})();
if(cljs.core.truth_(and__3755__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3755__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__9264_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__9264_SHARP_,(self__.strobj[p1__9264_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__9279 = null;
var G__9279__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9279__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9279 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9279__2.call(this,self__,k);
case 3:
return G__9279__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9279.cljs$core$IFn$_invoke$arity$2 = G__9279__2;
G__9279.cljs$core$IFn$_invoke$arity$3 = G__9279__3;
return G__9279;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args9265){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9265)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj9281 = {};
return obj9281;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__9282 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9282,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9282,(1),null);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [k,v]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [x,x]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_map_index_of_nil_QMARK_ = (function cljs$core$array_map_index_of_nil_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__9283 = (i + (2));
i = G__9283;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_keyword_QMARK_ = (function cljs$core$array_map_index_of_keyword_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__9284 = (i + (2));
i = G__9284;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_symbol_QMARK_ = (function cljs$core$array_map_index_of_symbol_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__9285 = (i + (2));
i = G__9285;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_identical_QMARK_ = (function cljs$core$array_map_index_of_identical_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__9286 = (i + (2));
i = G__9286;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_equiv_QMARK_ = (function cljs$core$array_map_index_of_equiv_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__9287 = (i + (2));
i = G__9287;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
var arr = m.arr;
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_map_index_of_keyword_QMARK_(arr,m,k);
} else {
if(cljs.core.truth_((function (){var or__3767__auto__ = (function (){var G__9291 = k;
return goog.isString(G__9291);
})();
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_map_index_of_identical_QMARK_(arr,m,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_map_index_of_symbol_QMARK_(arr,m,k);
} else {
if((k == null)){
return cljs.core.array_map_index_of_nil_QMARK_(arr,m,k);
} else {
return cljs.core.array_map_index_of_equiv_QMARK_(arr,m,k);

}
}
}
}
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
var arr = m.arr;
var l = arr.length;
var narr = (new Array((l + (2))));
var i_9292 = (0);
while(true){
if((i_9292 < l)){
(narr[i_9292] = (arr[i_9292]));

var G__9293 = (i_9292 + (1));
i_9292 = G__9293;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9295 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9295) : cljs.core.keys.call(null,G__9295));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9296 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9296) : cljs.core.vals.call(null,G__9296));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9297 = cljs.core.seq(coll);
var chunk__9298 = null;
var count__9299 = (0);
var i__9300 = (0);
while(true){
if((i__9300 < count__9299)){
var vec__9301 = chunk__9298.cljs$core$IIndexed$_nth$arity$2(null,i__9300);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9301,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9301,(1),null);
var G__9302_9315 = v;
var G__9303_9316 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9302_9315,G__9303_9316) : f.call(null,G__9302_9315,G__9303_9316));

var G__9317 = seq__9297;
var G__9318 = chunk__9298;
var G__9319 = count__9299;
var G__9320 = (i__9300 + (1));
seq__9297 = G__9317;
chunk__9298 = G__9318;
count__9299 = G__9319;
i__9300 = G__9320;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9297);
if(temp__4126__auto__){
var seq__9297__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9297__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__9297__$1);
var G__9321 = cljs.core.chunk_rest(seq__9297__$1);
var G__9322 = c__4552__auto__;
var G__9323 = cljs.core.count(c__4552__auto__);
var G__9324 = (0);
seq__9297 = G__9321;
chunk__9298 = G__9322;
count__9299 = G__9323;
i__9300 = G__9324;
continue;
} else {
var vec__9304 = cljs.core.first(seq__9297__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9304,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9304,(1),null);
var G__9305_9325 = v;
var G__9306_9326 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9305_9325,G__9306_9326) : f.call(null,G__9305_9325,G__9306_9326));

var G__9327 = cljs.core.next(seq__9297__$1);
var G__9328 = null;
var G__9329 = (0);
var G__9330 = (0);
seq__9297 = G__9327;
chunk__9298 = G__9328;
count__9299 = G__9329;
i__9300 = G__9330;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__9307 = init__$1;
var G__9308 = (self__.arr[i]);
var G__9309 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9307,G__9308,G__9309) : f.call(null,G__9307,G__9308,G__9309));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9310 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9310) : cljs.core.deref.call(null,G__9310));
} else {
var G__9331 = (i + (2));
var G__9332 = init__$2;
i = G__9331;
init__$1 = G__9332;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__9311 = other;
if(G__9311){
var bit__4434__auto__ = (G__9311.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4434__auto__) || (G__9311.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__9333 = (i + (2));
i = G__9333;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj9313 = {};
return obj9313;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__9334 = (s + (2));
var G__9335 = d;
s = G__9334;
d = G__9335;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__9336 = (s + (2));
var G__9337 = (d + (2));
s = G__9336;
d = G__9337;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__9314 = cljs.core.aclone(self__.arr);
(G__9314[(idx + (1))] = v);

return G__9314;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9338 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9339 = cljs.core.next(es);
ret = G__9338;
es = G__9339;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__9340 = null;
var G__9340__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9340__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9340 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9340__2.call(this,self__,k);
case 3:
return G__9340__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9340.cljs$core$IFn$_invoke$arity$2 = G__9340__2;
G__9340.cljs$core$IFn$_invoke$arity$3 = G__9340__3;
return G__9340;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args9294){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9294)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
if(no_check){
var cnt = (arr__$1.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$1,null));
} else {
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9341 = (i + (2));
var G__9342 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9341;
ret = G__9342;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__9343_9351 = self__.arr;
G__9343_9351.pop();

G__9343_9351.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__9344 = self__.len;
var G__9345 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__9344,G__9345) : cljs.core.array__GT_transient_hash_map.call(null,G__9344,G__9345));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__9346 = o;
if(G__9346){
var bit__4441__auto__ = (G__9346.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4441__auto__) || (G__9346.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9346.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9346);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9346);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__9347 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9347) : cljs.core.key.call(null,G__9347));
})(),(function (){var G__9348 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9348) : cljs.core.val.call(null,G__9348));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__9352 = cljs.core.next(es);
var G__9353 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__9349 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9349) : cljs.core.key.call(null,G__9349));
})(),(function (){var G__9350 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9350) : cljs.core.val.call(null,G__9350));
})());
es = G__9352;
tcoll__$2 = G__9353;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__9354 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__9355 = (i + (2));
out = G__9354;
i = G__9355;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function() {
var cljs$core$clone_and_set = null;
var cljs$core$clone_and_set__3 = (function (arr,i,a){
var G__9358 = cljs.core.aclone(arr);
(G__9358[i] = a);

return G__9358;
});
var cljs$core$clone_and_set__5 = (function (arr,i,a,j,b){
var G__9359 = cljs.core.aclone(arr);
(G__9359[i] = a);

(G__9359[j] = b);

return G__9359;
});
cljs$core$clone_and_set = function(arr,i,a,j,b){
switch(arguments.length){
case 3:
return cljs$core$clone_and_set__3.call(this,arr,i,a);
case 5:
return cljs$core$clone_and_set__5.call(this,arr,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$clone_and_set.cljs$core$IFn$_invoke$arity$3 = cljs$core$clone_and_set__3;
cljs$core$clone_and_set.cljs$core$IFn$_invoke$arity$5 = cljs$core$clone_and_set__5;
return cljs$core$clone_and_set;
})()
;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function() {
var cljs$core$edit_and_set = null;
var cljs$core$edit_and_set__4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});
var cljs$core$edit_and_set__6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});
cljs$core$edit_and_set = function(inode,edit,i,a,j,b){
switch(arguments.length){
case 4:
return cljs$core$edit_and_set__4.call(this,inode,edit,i,a);
case 6:
return cljs$core$edit_and_set__6.call(this,inode,edit,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$edit_and_set.cljs$core$IFn$_invoke$arity$4 = cljs$core$edit_and_set__4;
cljs$core$edit_and_set.cljs$core$IFn$_invoke$arity$6 = cljs$core$edit_and_set__6;
return cljs$core$edit_and_set;
})()
;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__9364 = init__$1;
var G__9365 = k;
var G__9366 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9364,G__9365,G__9366) : f.call(null,G__9364,G__9365,G__9366));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9367 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9367) : cljs.core.deref.call(null,G__9367));
} else {
var G__9368 = (i + (2));
var G__9369 = init__$2;
i = G__9368;
init__$1 = G__9369;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9370 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9370) : cljs.core.create_inode_seq.call(null,G__9370));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9384 = (0);
var j_9385 = (0);
while(true){
if((i_9384 < (32))){
if((((self__.bitmap >>> i_9384) & (1)) === (0))){
var G__9386 = (i_9384 + (1));
var G__9387 = j_9385;
i_9384 = G__9386;
j_9385 = G__9387;
continue;
} else {
(nodes[i_9384] = ((!(((self__.arr[j_9385]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_9385])),(self__.arr[j_9385]),(self__.arr[(j_9385 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9385 + (1))])));

var G__9388 = (i_9384 + (1));
var G__9389 = (j_9385 + (2));
i_9384 = G__9388;
j_9385 = G__9389;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9371 = edit__$1;
var G__9372 = (shift + (5));
var G__9373 = key_or_nil;
var G__9374 = val_or_node;
var G__9375 = hash;
var G__9376 = key;
var G__9377 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__9371,G__9372,G__9373,G__9374,G__9375,G__9376,G__9377) : cljs.core.create_node.call(null,G__9371,G__9372,G__9373,G__9374,G__9375,G__9376,G__9377));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9390 = (0);
var j_9391 = (0);
while(true){
if((i_9390 < (32))){
if((((self__.bitmap >>> i_9390) & (1)) === (0))){
var G__9392 = (i_9390 + (1));
var G__9393 = j_9391;
i_9390 = G__9392;
j_9391 = G__9393;
continue;
} else {
(nodes[i_9390] = ((!(((self__.arr[j_9391]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_9391])),(self__.arr[j_9391]),(self__.arr[(j_9391 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9391 + (1))])));

var G__9394 = (i_9390 + (1));
var G__9395 = (j_9391 + (2));
i_9390 = G__9394;
j_9391 = G__9395;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9378 = (shift + (5));
var G__9379 = key_or_nil;
var G__9380 = val_or_node;
var G__9381 = hash;
var G__9382 = key;
var G__9383 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__9378,G__9379,G__9380,G__9381,G__9382,G__9383) : cljs.core.create_node.call(null,G__9378,G__9379,G__9380,G__9381,G__9382,G__9383));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__9396 = (i + (1));
var G__9397 = (j + (2));
var G__9398 = (bitmap | ((1) << i));
i = G__9396;
j = G__9397;
bitmap = G__9398;
continue;
} else {
var G__9399 = (i + (1));
var G__9400 = j;
var G__9401 = bitmap;
i = G__9399;
j = G__9400;
bitmap = G__9401;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9402 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__9402) : cljs.core.create_array_node_seq.call(null,G__9402));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9403 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9403) : cljs.core.deref.call(null,G__9403));
} else {
var G__9404 = (i + (1));
var G__9405 = init__$2;
i = G__9404;
init__$1 = G__9405;
continue;
}
} else {
var G__9406 = (i + (1));
var G__9407 = init__$1;
i = G__9406;
init__$1 = G__9407;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__9408 = (i + (2));
i = G__9408;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9409 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9409) : cljs.core.create_inode_seq.call(null,G__9409));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function() {
var cljs$core$create_node = null;
var cljs$core$create_node__6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
var cljs$core$create_node__7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
cljs$core$create_node = function(edit,shift,key1,val1,key2hash,key2,val2){
switch(arguments.length){
case 6:
return cljs$core$create_node__6.call(this,edit,shift,key1,val1,key2hash,key2);
case 7:
return cljs$core$create_node__7.call(this,edit,shift,key1,val1,key2hash,key2,val2);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_node.cljs$core$IFn$_invoke$arity$6 = cljs$core$create_node__6;
cljs$core$create_node.cljs$core$IFn$_invoke$arity$7 = cljs$core$create_node__7;
return cljs$core$create_node;
})()
;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__9410 = self__.nodes;
var G__9411 = (self__.i + (2));
var G__9412 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9410,G__9411,G__9412) : cljs.core.create_inode_seq.call(null,G__9410,G__9411,G__9412));
} else {
var G__9413 = self__.nodes;
var G__9414 = self__.i;
var G__9415 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9413,G__9414,G__9415) : cljs.core.create_inode_seq.call(null,G__9413,G__9414,G__9415));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.create_inode_seq = (function() {
var cljs$core$create_inode_seq = null;
var cljs$core$create_inode_seq__1 = (function (nodes){
return cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});
var cljs$core$create_inode_seq__3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4124__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4124__auto__)){
var node = temp__4124__auto__;
var temp__4124__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var node_seq = temp__4124__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__9419 = (j + (2));
j = G__9419;
continue;
}
} else {
var G__9420 = (j + (2));
j = G__9420;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});
cljs$core$create_inode_seq = function(nodes,i,s){
switch(arguments.length){
case 1:
return cljs$core$create_inode_seq__1.call(this,nodes);
case 3:
return cljs$core$create_inode_seq__3.call(this,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$create_inode_seq__1;
cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$3 = cljs$core$create_inode_seq__3;
return cljs$core$create_inode_seq;
})()
;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__9421 = null;
var G__9422 = self__.nodes;
var G__9423 = self__.i;
var G__9424 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__9421,G__9422,G__9423,G__9424) : cljs.core.create_array_node_seq.call(null,G__9421,G__9422,G__9423,G__9424));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.create_array_node_seq = (function() {
var cljs$core$create_array_node_seq = null;
var cljs$core$create_array_node_seq__1 = (function (nodes){
return cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});
var cljs$core$create_array_node_seq__4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4124__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4124__auto__)){
var nj = temp__4124__auto__;
var temp__4124__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var ns = temp__4124__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__9429 = (j + (1));
j = G__9429;
continue;
}
} else {
var G__9430 = (j + (1));
j = G__9430;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});
cljs$core$create_array_node_seq = function(meta,nodes,i,s){
switch(arguments.length){
case 1:
return cljs$core$create_array_node_seq__1.call(this,meta);
case 4:
return cljs$core$create_array_node_seq__4.call(this,meta,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$create_array_node_seq__1;
cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = cljs$core$create_array_node_seq__4;
return cljs$core$create_array_node_seq;
})()
;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9432 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9432) : cljs.core.keys.call(null,G__9432));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9433 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9433) : cljs.core.vals.call(null,G__9433));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9434 = cljs.core.seq(coll);
var chunk__9435 = null;
var count__9436 = (0);
var i__9437 = (0);
while(true){
if((i__9437 < count__9436)){
var vec__9438 = chunk__9435.cljs$core$IIndexed$_nth$arity$2(null,i__9437);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9438,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9438,(1),null);
var G__9439_9450 = v;
var G__9440_9451 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9439_9450,G__9440_9451) : f.call(null,G__9439_9450,G__9440_9451));

var G__9452 = seq__9434;
var G__9453 = chunk__9435;
var G__9454 = count__9436;
var G__9455 = (i__9437 + (1));
seq__9434 = G__9452;
chunk__9435 = G__9453;
count__9436 = G__9454;
i__9437 = G__9455;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9434);
if(temp__4126__auto__){
var seq__9434__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9434__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__9434__$1);
var G__9456 = cljs.core.chunk_rest(seq__9434__$1);
var G__9457 = c__4552__auto__;
var G__9458 = cljs.core.count(c__4552__auto__);
var G__9459 = (0);
seq__9434 = G__9456;
chunk__9435 = G__9457;
count__9436 = G__9458;
i__9437 = G__9459;
continue;
} else {
var vec__9441 = cljs.core.first(seq__9434__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9441,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9441,(1),null);
var G__9442_9460 = v;
var G__9443_9461 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9442_9460,G__9443_9461) : f.call(null,G__9442_9460,G__9443_9461));

var G__9462 = cljs.core.next(seq__9434__$1);
var G__9463 = null;
var G__9464 = (0);
var G__9465 = (0);
seq__9434 = G__9462;
chunk__9435 = G__9463;
count__9436 = G__9464;
i__9437 = G__9465;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__9444 = init;
var G__9445 = null;
var G__9446 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9444,G__9445,G__9446) : f.call(null,G__9444,G__9445,G__9446));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9447 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9447) : cljs.core.deref.call(null,G__9447));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj9449 = {};
return obj9449;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9466 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9467 = cljs.core.next(es);
ret = G__9466;
es = G__9467;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__9468 = null;
var G__9468__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9468__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9468 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9468__2.call(this,self__,k);
case 3:
return G__9468__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9468.cljs$core$IFn$_invoke$arity$2 = G__9468__2;
G__9468.cljs$core$IFn$_invoke$arity$3 = G__9468__3;
return G__9468;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args9431){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9431)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9469 = (i + (2));
var G__9470 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9469;
ret = G__9470;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9471 = (i + (1));
var G__9472 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__9471;
out = G__9472;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__9473 = o;
if(G__9473){
var bit__4441__auto__ = (G__9473.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4441__auto__) || (G__9473.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9473.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9473);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9473);
}
})()){
return tcoll.assoc_BANG_((function (){var G__9474 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9474) : cljs.core.key.call(null,G__9474));
})(),(function (){var G__9475 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9475) : cljs.core.val.call(null,G__9475));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__9478 = cljs.core.next(es);
var G__9479 = tcoll__$1.assoc_BANG_((function (){var G__9476 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9476) : cljs.core.key.call(null,G__9476));
})(),(function (){var G__9477 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9477) : cljs.core.val.call(null,G__9477));
})());
es = G__9478;
tcoll__$1 = G__9479;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__9480 = ((ascending_QMARK_)?t.left:t.right);
var G__9481 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__9480;
stack__$1 = G__9481;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9494 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9494) : cljs.core.deref.call(null,G__9494));
} else {
var init__$2 = (function (){var G__9495 = init__$1;
var G__9496 = node.key;
var G__9497 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9495,G__9496,G__9497) : f.call(null,G__9495,G__9496,G__9497));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9498 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9498) : cljs.core.deref.call(null,G__9498));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__9499 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9499) : cljs.core.deref.call(null,G__9499));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__9501 = null;
var G__9501__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9501__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9501 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9501__2.call(this,self__,k);
case 3:
return G__9501__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9501.cljs$core$IFn$_invoke$arity$2 = G__9501__2;
G__9501.cljs$core$IFn$_invoke$arity$3 = G__9501__3;
return G__9501;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args9500){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9500)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__9503 = null;
var G__9503__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9503__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9503 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9503__2.call(this,self__,k);
case 3:
return G__9503__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9503.cljs$core$IFn$_invoke$arity$2 = G__9503__2;
G__9503.cljs$core$IFn$_invoke$arity$3 = G__9503__3;
return G__9503;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args9502){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9502)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__9516 = k;
var G__9517 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9516,G__9517) : comp.call(null,G__9516,G__9517));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__9536 = k;
var G__9537 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9536,G__9537) : comp.call(null,G__9536,G__9537));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__9548 = k;
var G__9549 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9548,G__9549) : comp.call(null,G__9548,G__9549));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9551 = cljs.core.seq(coll);
var chunk__9552 = null;
var count__9553 = (0);
var i__9554 = (0);
while(true){
if((i__9554 < count__9553)){
var vec__9555 = chunk__9552.cljs$core$IIndexed$_nth$arity$2(null,i__9554);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9555,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9555,(1),null);
var G__9556_9568 = v;
var G__9557_9569 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9556_9568,G__9557_9569) : f.call(null,G__9556_9568,G__9557_9569));

var G__9570 = seq__9551;
var G__9571 = chunk__9552;
var G__9572 = count__9553;
var G__9573 = (i__9554 + (1));
seq__9551 = G__9570;
chunk__9552 = G__9571;
count__9553 = G__9572;
i__9554 = G__9573;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9551);
if(temp__4126__auto__){
var seq__9551__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9551__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__9551__$1);
var G__9574 = cljs.core.chunk_rest(seq__9551__$1);
var G__9575 = c__4552__auto__;
var G__9576 = cljs.core.count(c__4552__auto__);
var G__9577 = (0);
seq__9551 = G__9574;
chunk__9552 = G__9575;
count__9553 = G__9576;
i__9554 = G__9577;
continue;
} else {
var vec__9558 = cljs.core.first(seq__9551__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9558,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9558,(1),null);
var G__9559_9578 = v;
var G__9560_9579 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9559_9578,G__9560_9579) : f.call(null,G__9559_9578,G__9560_9579));

var G__9580 = cljs.core.next(seq__9551__$1);
var G__9581 = null;
var G__9582 = (0);
var G__9583 = (0);
seq__9551 = G__9580;
chunk__9552 = G__9581;
count__9553 = G__9582;
i__9554 = G__9583;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9561 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9561) : cljs.core.keys.call(null,G__9561));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9562 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9562) : cljs.core.vals.call(null,G__9562));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9563 = k;
var G__9564 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9563,G__9564) : self__.comp.call(null,G__9563,G__9564));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__9584 = t.left;
t = G__9584;
continue;
} else {
var G__9585 = t.right;
t = G__9585;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9586 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9587 = cljs.core.next(es);
ret = G__9586;
es = G__9587;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__9588 = null;
var G__9588__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9588__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9588 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9588__2.call(this,self__,k);
case 3:
return G__9588__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9588.cljs$core$IFn$_invoke$arity$2 = G__9588__2;
G__9588.cljs$core$IFn$_invoke$arity$3 = G__9588__3;
return G__9588;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args9550){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9550)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9565 = k;
var G__9566 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9565,G__9566) : self__.comp.call(null,G__9565,G__9566));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__9589 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9590 = t.left;
stack = G__9589;
t = G__9590;
continue;
} else {
var G__9591 = stack;
var G__9592 = t.right;
stack = G__9591;
t = G__9592;
continue;
}
} else {
if((c > (0))){
var G__9593 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9594 = t.right;
stack = G__9593;
t = G__9594;
continue;
} else {
var G__9595 = stack;
var G__9596 = t.left;
stack = G__9595;
t = G__9596;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__9567 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9567) : cljs.core.key.call(null,G__9567));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * keyval => key val
 * Returns a new hash map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.hash_map = (function() { 
var cljs$core$hash_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__9597 = cljs.core.nnext(in$);
var G__9598 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9597;
out = G__9598;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
};
var cljs$core$hash_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9599__i = 0, G__9599__a = new Array(arguments.length -  0);
while (G__9599__i < G__9599__a.length) {G__9599__a[G__9599__i] = arguments[G__9599__i + 0]; ++G__9599__i;}
  keyvals = new cljs.core.IndexedSeq(G__9599__a,0);
} 
return cljs$core$hash_map__delegate.call(this,keyvals);};
cljs$core$hash_map.cljs$lang$maxFixedArity = 0;
cljs$core$hash_map.cljs$lang$applyTo = (function (arglist__9600){
var keyvals = cljs.core.seq(arglist__9600);
return cljs$core$hash_map__delegate(keyvals);
});
cljs$core$hash_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$hash_map__delegate;
return cljs$core$hash_map;
})()
;
/**
 * keyval => key val
 * Returns a new array map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.array_map = (function() { 
var cljs$core$array_map__delegate = function (keyvals){
return cljs.core.PersistentArrayMap.fromArray(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array,keyvals),true,false);
};
var cljs$core$array_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9601__i = 0, G__9601__a = new Array(arguments.length -  0);
while (G__9601__i < G__9601__a.length) {G__9601__a[G__9601__i] = arguments[G__9601__i + 0]; ++G__9601__i;}
  keyvals = new cljs.core.IndexedSeq(G__9601__a,0);
} 
return cljs$core$array_map__delegate.call(this,keyvals);};
cljs$core$array_map.cljs$lang$maxFixedArity = 0;
cljs$core$array_map.cljs$lang$applyTo = (function (arglist__9602){
var keyvals = cljs.core.seq(arglist__9602);
return cljs$core$array_map__delegate(keyvals);
});
cljs$core$array_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$array_map__delegate;
return cljs$core$array_map;
})()
;
/**
 * keyval => key val
 * Returns a new object map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.obj_map = (function() { 
var cljs$core$obj_map__delegate = function (keyvals){
var ks = [];
var obj = (function (){var obj9606 = {};
return obj9606;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__9607 = cljs.core.nnext(kvs);
kvs = G__9607;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
};
var cljs$core$obj_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9608__i = 0, G__9608__a = new Array(arguments.length -  0);
while (G__9608__i < G__9608__a.length) {G__9608__a[G__9608__i] = arguments[G__9608__i + 0]; ++G__9608__i;}
  keyvals = new cljs.core.IndexedSeq(G__9608__a,0);
} 
return cljs$core$obj_map__delegate.call(this,keyvals);};
cljs$core$obj_map.cljs$lang$maxFixedArity = 0;
cljs$core$obj_map.cljs$lang$applyTo = (function (arglist__9609){
var keyvals = cljs.core.seq(arglist__9609);
return cljs$core$obj_map__delegate(keyvals);
});
cljs$core$obj_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$obj_map__delegate;
return cljs$core$obj_map;
})()
;
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.sorted_map = (function() { 
var cljs$core$sorted_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__9610 = cljs.core.nnext(in$);
var G__9611 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9610;
out = G__9611;
continue;
} else {
return out;
}
break;
}
};
var cljs$core$sorted_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9612__i = 0, G__9612__a = new Array(arguments.length -  0);
while (G__9612__i < G__9612__a.length) {G__9612__a[G__9612__i] = arguments[G__9612__i + 0]; ++G__9612__i;}
  keyvals = new cljs.core.IndexedSeq(G__9612__a,0);
} 
return cljs$core$sorted_map__delegate.call(this,keyvals);};
cljs$core$sorted_map.cljs$lang$maxFixedArity = 0;
cljs$core$sorted_map.cljs$lang$applyTo = (function (arglist__9613){
var keyvals = cljs.core.seq(arglist__9613);
return cljs$core$sorted_map__delegate(keyvals);
});
cljs$core$sorted_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_map__delegate;
return cljs$core$sorted_map;
})()
;
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings, using the supplied comparator.
 * @param {...*} var_args
 */
cljs.core.sorted_map_by = (function() { 
var cljs$core$sorted_map_by__delegate = function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__9614 = cljs.core.nnext(in$);
var G__9615 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9614;
out = G__9615;
continue;
} else {
return out;
}
break;
}
};
var cljs$core$sorted_map_by = function (comparator,var_args){
var keyvals = null;
if (arguments.length > 1) {
var G__9616__i = 0, G__9616__a = new Array(arguments.length -  1);
while (G__9616__i < G__9616__a.length) {G__9616__a[G__9616__i] = arguments[G__9616__i + 1]; ++G__9616__i;}
  keyvals = new cljs.core.IndexedSeq(G__9616__a,0);
} 
return cljs$core$sorted_map_by__delegate.call(this,comparator,keyvals);};
cljs$core$sorted_map_by.cljs$lang$maxFixedArity = 1;
cljs$core$sorted_map_by.cljs$lang$applyTo = (function (arglist__9617){
var comparator = cljs.core.first(arglist__9617);
var keyvals = cljs.core.rest(arglist__9617);
return cljs$core$sorted_map_by__delegate(comparator,keyvals);
});
cljs$core$sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_map_by__delegate;
return cljs$core$sorted_map_by;
})()
;

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9618 = self__.mseq;
if(G__9618){
var bit__4441__auto__ = (G__9618.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4441__auto__) || (G__9618.cljs$core$INext$)){
return true;
} else {
if((!G__9618.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9618);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9618);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9619 = self__.mseq;
if(G__9619){
var bit__4441__auto__ = (G__9619.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4441__auto__) || (G__9619.cljs$core$INext$)){
return true;
} else {
if((!G__9619.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9619);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9619);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9620 = self__.mseq;
if(G__9620){
var bit__4441__auto__ = (G__9620.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4441__auto__) || (G__9620.cljs$core$INext$)){
return true;
} else {
if((!G__9620.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9620);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9620);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9621 = self__.mseq;
if(G__9621){
var bit__4441__auto__ = (G__9621.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4441__auto__) || (G__9621.cljs$core$INext$)){
return true;
} else {
if((!G__9621.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9621);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9621);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping from
 * the latter (left-to-right) will be the mapping in the result.
 * @param {...*} var_args
 */
cljs.core.merge = (function() { 
var cljs$core$merge__delegate = function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__9622_SHARP_,p2__9623_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3767__auto__ = p1__9622_SHARP_;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__9623_SHARP_);
}),maps);
} else {
return null;
}
};
var cljs$core$merge = function (var_args){
var maps = null;
if (arguments.length > 0) {
var G__9624__i = 0, G__9624__a = new Array(arguments.length -  0);
while (G__9624__i < G__9624__a.length) {G__9624__a[G__9624__i] = arguments[G__9624__i + 0]; ++G__9624__i;}
  maps = new cljs.core.IndexedSeq(G__9624__a,0);
} 
return cljs$core$merge__delegate.call(this,maps);};
cljs$core$merge.cljs$lang$maxFixedArity = 0;
cljs$core$merge.cljs$lang$applyTo = (function (arglist__9625){
var maps = cljs.core.seq(arglist__9625);
return cljs$core$merge__delegate(maps);
});
cljs$core$merge.cljs$core$IFn$_invoke$arity$variadic = cljs$core$merge__delegate;
return cljs$core$merge;
})()
;
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping(s)
 * from the latter (left-to-right) will be combined with the mapping in
 * the result by calling (f val-in-result val-in-latter).
 * @param {...*} var_args
 */
cljs.core.merge_with = (function() { 
var cljs$core$merge_with__delegate = function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9629 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9628,G__9629) : f.call(null,G__9628,G__9629));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__3767__auto__ = m1;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
};
var cljs$core$merge_with = function (f,var_args){
var maps = null;
if (arguments.length > 1) {
var G__9630__i = 0, G__9630__a = new Array(arguments.length -  1);
while (G__9630__i < G__9630__a.length) {G__9630__a[G__9630__i] = arguments[G__9630__i + 1]; ++G__9630__i;}
  maps = new cljs.core.IndexedSeq(G__9630__a,0);
} 
return cljs$core$merge_with__delegate.call(this,f,maps);};
cljs$core$merge_with.cljs$lang$maxFixedArity = 1;
cljs$core$merge_with.cljs$lang$applyTo = (function (arglist__9631){
var f = cljs.core.first(arglist__9631);
var maps = cljs.core.rest(arglist__9631);
return cljs$core$merge_with__delegate(f,maps);
});
cljs$core$merge_with.cljs$core$IFn$_invoke$arity$variadic = cljs$core$merge_with__delegate;
return cljs$core$merge_with;
})()
;
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__9632 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__9633 = cljs.core.next(keys);
ret = G__9632;
keys = G__9633;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9636 = cljs.core.seq(coll);
var chunk__9637 = null;
var count__9638 = (0);
var i__9639 = (0);
while(true){
if((i__9639 < count__9638)){
var vec__9640 = chunk__9637.cljs$core$IIndexed$_nth$arity$2(null,i__9639);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9640,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9640,(1),null);
var G__9641_9646 = v;
var G__9642_9647 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9641_9646,G__9642_9647) : f.call(null,G__9641_9646,G__9642_9647));

var G__9648 = seq__9636;
var G__9649 = chunk__9637;
var G__9650 = count__9638;
var G__9651 = (i__9639 + (1));
seq__9636 = G__9648;
chunk__9637 = G__9649;
count__9638 = G__9650;
i__9639 = G__9651;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9636);
if(temp__4126__auto__){
var seq__9636__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9636__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__9636__$1);
var G__9652 = cljs.core.chunk_rest(seq__9636__$1);
var G__9653 = c__4552__auto__;
var G__9654 = cljs.core.count(c__4552__auto__);
var G__9655 = (0);
seq__9636 = G__9652;
chunk__9637 = G__9653;
count__9638 = G__9654;
i__9639 = G__9655;
continue;
} else {
var vec__9643 = cljs.core.first(seq__9636__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9643,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9643,(1),null);
var G__9644_9656 = v;
var G__9645_9657 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9644_9656,G__9645_9657) : f.call(null,G__9644_9656,G__9645_9657));

var G__9658 = cljs.core.next(seq__9636__$1);
var G__9659 = null;
var G__9660 = (0);
var G__9661 = (0);
seq__9636 = G__9658;
chunk__9637 = G__9659;
count__9638 = G__9660;
i__9639 = G__9661;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9634_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9634_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__9662 = null;
var G__9662__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9662__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9662 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9662__2.call(this,self__,k);
case 3:
return G__9662__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9662.cljs$core$IFn$_invoke$arity$2 = G__9662__2;
G__9662.cljs$core$IFn$_invoke$arity$3 = G__9662__3;
return G__9662;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args9635){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9635)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9663 = (i + (1));
var G__9664 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__9663;
out = G__9664;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__9665 = (i + (1));
var G__9666 = cljs.core._conj_BANG_(out,(items[i]));
i = G__9665;
out = G__9666;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 136;
})
cljs.core.TransientHashSet.prototype.call = (function() {
var G__9668 = null;
var G__9668__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__9668__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__9668 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9668__2.call(this,self__,k);
case 3:
return G__9668__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9668.cljs$core$IFn$_invoke$arity$2 = G__9668__2;
G__9668.cljs$core$IFn$_invoke$arity$3 = G__9668__3;
return G__9668;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args9667){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9667)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9671 = cljs.core.seq(coll);
var chunk__9672 = null;
var count__9673 = (0);
var i__9674 = (0);
while(true){
if((i__9674 < count__9673)){
var vec__9675 = chunk__9672.cljs$core$IIndexed$_nth$arity$2(null,i__9674);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9675,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9675,(1),null);
var G__9676_9681 = v;
var G__9677_9682 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9676_9681,G__9677_9682) : f.call(null,G__9676_9681,G__9677_9682));

var G__9683 = seq__9671;
var G__9684 = chunk__9672;
var G__9685 = count__9673;
var G__9686 = (i__9674 + (1));
seq__9671 = G__9683;
chunk__9672 = G__9684;
count__9673 = G__9685;
i__9674 = G__9686;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9671);
if(temp__4126__auto__){
var seq__9671__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9671__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__9671__$1);
var G__9687 = cljs.core.chunk_rest(seq__9671__$1);
var G__9688 = c__4552__auto__;
var G__9689 = cljs.core.count(c__4552__auto__);
var G__9690 = (0);
seq__9671 = G__9687;
chunk__9672 = G__9688;
count__9673 = G__9689;
i__9674 = G__9690;
continue;
} else {
var vec__9678 = cljs.core.first(seq__9671__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9678,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9678,(1),null);
var G__9679_9691 = v;
var G__9680_9692 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9679_9691,G__9680_9692) : f.call(null,G__9679_9691,G__9680_9692));

var G__9693 = cljs.core.next(seq__9671__$1);
var G__9694 = null;
var G__9695 = (0);
var G__9696 = (0);
seq__9671 = G__9693;
chunk__9672 = G__9694;
count__9673 = G__9695;
i__9674 = G__9696;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9669_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9669_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__9697 = null;
var G__9697__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9697__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9697 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9697__2.call(this,self__,k);
case 3:
return G__9697__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9697.cljs$core$IFn$_invoke$arity$2 = G__9697__2;
G__9697.cljs$core$IFn$_invoke$arity$3 = G__9697__3;
return G__9697;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args9670){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9670)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4646__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__4646__auto__.length)){
var G__9698 = (i + (1));
var G__9699 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__9698;
res = G__9699;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__9700 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__9701 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__9700;
out = G__9701;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 * handled as if by repeated uses of conj.
 * @param {...*} var_args
 */
cljs.core.hash_set = (function() {
var cljs$core$hash_set = null;
var cljs$core$hash_set__0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});
var cljs$core$hash_set__1 = (function() { 
var G__9702__delegate = function (keys){
return cljs.core.set(keys);
};
var G__9702 = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__9703__i = 0, G__9703__a = new Array(arguments.length -  0);
while (G__9703__i < G__9703__a.length) {G__9703__a[G__9703__i] = arguments[G__9703__i + 0]; ++G__9703__i;}
  keys = new cljs.core.IndexedSeq(G__9703__a,0);
} 
return G__9702__delegate.call(this,keys);};
G__9702.cljs$lang$maxFixedArity = 0;
G__9702.cljs$lang$applyTo = (function (arglist__9704){
var keys = cljs.core.seq(arglist__9704);
return G__9702__delegate(keys);
});
G__9702.cljs$core$IFn$_invoke$arity$variadic = G__9702__delegate;
return G__9702;
})()
;
cljs$core$hash_set = function(var_args){
var keys = var_args;
switch(arguments.length){
case 0:
return cljs$core$hash_set__0.call(this);
default:
var G__9705 = null;
if (arguments.length > 0) {
var G__9706__i = 0, G__9706__a = new Array(arguments.length -  0);
while (G__9706__i < G__9706__a.length) {G__9706__a[G__9706__i] = arguments[G__9706__i + 0]; ++G__9706__i;}
G__9705 = new cljs.core.IndexedSeq(G__9706__a,0);
}
return cljs$core$hash_set__1.cljs$core$IFn$_invoke$arity$variadic(G__9705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$hash_set.cljs$lang$maxFixedArity = 0;
cljs$core$hash_set.cljs$lang$applyTo = cljs$core$hash_set__1.cljs$lang$applyTo;
cljs$core$hash_set.cljs$core$IFn$_invoke$arity$0 = cljs$core$hash_set__0;
cljs$core$hash_set.cljs$core$IFn$_invoke$arity$variadic = cljs$core$hash_set__1.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$hash_set;
})()
;
/**
 * Returns a new sorted set with supplied keys.
 * @param {...*} var_args
 */
cljs.core.sorted_set = (function() { 
var cljs$core$sorted_set__delegate = function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
};
var cljs$core$sorted_set = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__9707__i = 0, G__9707__a = new Array(arguments.length -  0);
while (G__9707__i < G__9707__a.length) {G__9707__a[G__9707__i] = arguments[G__9707__i + 0]; ++G__9707__i;}
  keys = new cljs.core.IndexedSeq(G__9707__a,0);
} 
return cljs$core$sorted_set__delegate.call(this,keys);};
cljs$core$sorted_set.cljs$lang$maxFixedArity = 0;
cljs$core$sorted_set.cljs$lang$applyTo = (function (arglist__9708){
var keys = cljs.core.seq(arglist__9708);
return cljs$core$sorted_set__delegate(keys);
});
cljs$core$sorted_set.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_set__delegate;
return cljs$core$sorted_set;
})()
;
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 * @param {...*} var_args
 */
cljs.core.sorted_set_by = (function() { 
var cljs$core$sorted_set_by__delegate = function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
};
var cljs$core$sorted_set_by = function (comparator,var_args){
var keys = null;
if (arguments.length > 1) {
var G__9709__i = 0, G__9709__a = new Array(arguments.length -  1);
while (G__9709__i < G__9709__a.length) {G__9709__a[G__9709__i] = arguments[G__9709__i + 1]; ++G__9709__i;}
  keys = new cljs.core.IndexedSeq(G__9709__a,0);
} 
return cljs$core$sorted_set_by__delegate.call(this,comparator,keys);};
cljs$core$sorted_set_by.cljs$lang$maxFixedArity = 1;
cljs$core$sorted_set_by.cljs$lang$applyTo = (function (arglist__9710){
var comparator = cljs.core.first(arglist__9710);
var keys = cljs.core.rest(arglist__9710);
return cljs$core$sorted_set_by__delegate(comparator,keys);
});
cljs$core$sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_set_by__delegate;
return cljs$core$sorted_set_by;
})()
;
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 * vector/seq with any elements = a key in smap replaced with the
 * corresponding val in smap.  Returns a transducer when no collection
 * is provided.
 */
cljs.core.replace = (function() {
var cljs$core$replace = null;
var cljs$core$replace__1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9711_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__9711_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.val(e);
} else {
return p1__9711_SHARP_;
}
}));
});
var cljs$core$replace__2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4124__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9712_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__9712_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.second(e);
} else {
return p1__9712_SHARP_;
}
}),coll);
}
});
cljs$core$replace = function(smap,coll){
switch(arguments.length){
case 1:
return cljs$core$replace__1.call(this,smap);
case 2:
return cljs$core$replace__2.call(this,smap,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$replace.cljs$core$IFn$_invoke$arity$1 = cljs$core$replace__1;
cljs$core$replace.cljs$core$IFn$_invoke$arity$2 = cljs$core$replace__2;
return cljs$core$replace;
})()
;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed
 */
cljs.core.distinct = (function() {
var cljs$core$distinct = null;
var cljs$core$distinct__0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__9733 = null;
var G__9733__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9733__1 = (function (result){
var G__9723 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9723) : rf.call(null,G__9723));
});
var G__9733__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__9724 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9724) : cljs.core.deref.call(null,G__9724));
})(),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

var G__9725 = result;
var G__9726 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9725,G__9726) : rf.call(null,G__9725,G__9726));
}
});
G__9733 = function(result,input){
switch(arguments.length){
case 0:
return G__9733__0.call(this);
case 1:
return G__9733__1.call(this,result);
case 2:
return G__9733__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9733.cljs$core$IFn$_invoke$arity$0 = G__9733__0;
G__9733.cljs$core$IFn$_invoke$arity$1 = G__9733__1;
G__9733.cljs$core$IFn$_invoke$arity$2 = G__9733__2;
return G__9733;
})()
;})(seen))
});
});
var cljs$core$distinct__1 = (function (coll){
var step = (function cljs$core$distinct_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__9731,seen__$1){
while(true){
var vec__9732 = p__9731;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9732,(0),null);
var xs__$1 = vec__9732;
var temp__4126__auto__ = cljs.core.seq(xs__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__9734 = cljs.core.rest(s);
var G__9735 = seen__$1;
p__9731 = G__9734;
seen__$1 = G__9735;
continue;
} else {
return cljs.core.cons(f,cljs$core$distinct_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
cljs$core$distinct = function(coll){
switch(arguments.length){
case 0:
return cljs$core$distinct__0.call(this);
case 1:
return cljs$core$distinct__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$distinct.cljs$core$IFn$_invoke$arity$0 = cljs$core$distinct__0;
cljs$core$distinct.cljs$core$IFn$_invoke$arity$1 = cljs$core$distinct__1;
return cljs$core$distinct;
})()
;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__9736 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__9737 = cljs.core.next(s__$1);
ret = G__9736;
s__$1 = G__9737;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((function (){var G__9739 = x;
if(G__9739){
var bit__4434__auto__ = (G__9739.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4434__auto__) || (G__9739.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__9740 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__9741 = cljs.core.next(ks);
var G__9742 = cljs.core.next(vs);
map = G__9740;
ks = G__9741;
vs = G__9742;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 * @param {...*} var_args
 */
cljs.core.max_key = (function() {
var cljs$core$max_key = null;
var cljs$core$max_key__2 = (function (k,x){
return x;
});
var cljs$core$max_key__3 = (function (k,x,y){
if(((function (){var G__9753 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9753) : k.call(null,G__9753));
})() > (function (){var G__9754 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9754) : k.call(null,G__9754));
})())){
return x;
} else {
return y;
}
});
var cljs$core$max_key__4 = (function() { 
var G__9755__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9743_SHARP_,p2__9744_SHARP_){
return cljs$core$max_key.cljs$core$IFn$_invoke$arity$3(k,p1__9743_SHARP_,p2__9744_SHARP_);
}),cljs$core$max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__9755 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__9756__i = 0, G__9756__a = new Array(arguments.length -  3);
while (G__9756__i < G__9756__a.length) {G__9756__a[G__9756__i] = arguments[G__9756__i + 3]; ++G__9756__i;}
  more = new cljs.core.IndexedSeq(G__9756__a,0);
} 
return G__9755__delegate.call(this,k,x,y,more);};
G__9755.cljs$lang$maxFixedArity = 3;
G__9755.cljs$lang$applyTo = (function (arglist__9757){
var k = cljs.core.first(arglist__9757);
arglist__9757 = cljs.core.next(arglist__9757);
var x = cljs.core.first(arglist__9757);
arglist__9757 = cljs.core.next(arglist__9757);
var y = cljs.core.first(arglist__9757);
var more = cljs.core.rest(arglist__9757);
return G__9755__delegate(k,x,y,more);
});
G__9755.cljs$core$IFn$_invoke$arity$variadic = G__9755__delegate;
return G__9755;
})()
;
cljs$core$max_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$max_key__2.call(this,k,x);
case 3:
return cljs$core$max_key__3.call(this,k,x,y);
default:
var G__9758 = null;
if (arguments.length > 3) {
var G__9759__i = 0, G__9759__a = new Array(arguments.length -  3);
while (G__9759__i < G__9759__a.length) {G__9759__a[G__9759__i] = arguments[G__9759__i + 3]; ++G__9759__i;}
G__9758 = new cljs.core.IndexedSeq(G__9759__a,0);
}
return cljs$core$max_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__9758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$max_key.cljs$lang$maxFixedArity = 3;
cljs$core$max_key.cljs$lang$applyTo = cljs$core$max_key__4.cljs$lang$applyTo;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$2 = cljs$core$max_key__2;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$3 = cljs$core$max_key__3;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$variadic = cljs$core$max_key__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$max_key;
})()
;
/**
 * Returns the x for which (k x), a number, is least.
 * @param {...*} var_args
 */
cljs.core.min_key = (function() {
var cljs$core$min_key = null;
var cljs$core$min_key__2 = (function (k,x){
return x;
});
var cljs$core$min_key__3 = (function (k,x,y){
if(((function (){var G__9770 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9770) : k.call(null,G__9770));
})() < (function (){var G__9771 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9771) : k.call(null,G__9771));
})())){
return x;
} else {
return y;
}
});
var cljs$core$min_key__4 = (function() { 
var G__9772__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9760_SHARP_,p2__9761_SHARP_){
return cljs$core$min_key.cljs$core$IFn$_invoke$arity$3(k,p1__9760_SHARP_,p2__9761_SHARP_);
}),cljs$core$min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__9772 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__9773__i = 0, G__9773__a = new Array(arguments.length -  3);
while (G__9773__i < G__9773__a.length) {G__9773__a[G__9773__i] = arguments[G__9773__i + 3]; ++G__9773__i;}
  more = new cljs.core.IndexedSeq(G__9773__a,0);
} 
return G__9772__delegate.call(this,k,x,y,more);};
G__9772.cljs$lang$maxFixedArity = 3;
G__9772.cljs$lang$applyTo = (function (arglist__9774){
var k = cljs.core.first(arglist__9774);
arglist__9774 = cljs.core.next(arglist__9774);
var x = cljs.core.first(arglist__9774);
arglist__9774 = cljs.core.next(arglist__9774);
var y = cljs.core.first(arglist__9774);
var more = cljs.core.rest(arglist__9774);
return G__9772__delegate(k,x,y,more);
});
G__9772.cljs$core$IFn$_invoke$arity$variadic = G__9772__delegate;
return G__9772;
})()
;
cljs$core$min_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$min_key__2.call(this,k,x);
case 3:
return cljs$core$min_key__3.call(this,k,x,y);
default:
var G__9775 = null;
if (arguments.length > 3) {
var G__9776__i = 0, G__9776__a = new Array(arguments.length -  3);
while (G__9776__i < G__9776__a.length) {G__9776__a[G__9776__i] = arguments[G__9776__i + 3]; ++G__9776__i;}
G__9775 = new cljs.core.IndexedSeq(G__9776__a,0);
}
return cljs$core$min_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__9775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$min_key.cljs$lang$maxFixedArity = 3;
cljs$core$min_key.cljs$lang$applyTo = cljs$core$min_key__4.cljs$lang$applyTo;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$2 = cljs$core$min_key__2;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$3 = cljs$core$min_key__3;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$variadic = cljs$core$min_key__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$min_key;
})()
;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 * partitions with fewer than n items at the end.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_all = (function() {
var cljs$core$partition_all = null;
var cljs$core$partition_all__1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__9793 = null;
var G__9793__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9793__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9788 = result;
var G__9789 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9788,G__9789) : rf.call(null,G__9788,G__9789));
})());
})());
var G__9790 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9790) : rf.call(null,G__9790));
});
var G__9793__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__9791 = result;
var G__9792 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9791,G__9792) : rf.call(null,G__9791,G__9792));
} else {
return result;
}
});
G__9793 = function(result,input){
switch(arguments.length){
case 0:
return G__9793__0.call(this);
case 1:
return G__9793__1.call(this,result);
case 2:
return G__9793__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9793.cljs$core$IFn$_invoke$arity$0 = G__9793__0;
G__9793.cljs$core$IFn$_invoke$arity$1 = G__9793__1;
G__9793.cljs$core$IFn$_invoke$arity$2 = G__9793__2;
return G__9793;
})()
;})(a))
});
});
var cljs$core$partition_all__2 = (function (n,coll){
return cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var cljs$core$partition_all__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});
cljs$core$partition_all = function(n,step,coll){
switch(arguments.length){
case 1:
return cljs$core$partition_all__1.call(this,n);
case 2:
return cljs$core$partition_all__2.call(this,n,step);
case 3:
return cljs$core$partition_all__3.call(this,n,step,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$1 = cljs$core$partition_all__1;
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition_all__2;
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3 = cljs$core$partition_all__3;
return cljs$core$partition_all;
})()
;
/**
 * Returns a lazy sequence of successive items from coll while
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function() {
var cljs$core$take_while = null;
var cljs$core$take_while__1 = (function (pred){
return (function (rf){
return (function() {
var G__9806 = null;
var G__9806__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9806__1 = (function (result){
var G__9801 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9801) : rf.call(null,G__9801));
});
var G__9806__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__9802 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9802) : pred.call(null,G__9802));
})())){
var G__9803 = result;
var G__9804 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9803,G__9804) : rf.call(null,G__9803,G__9804));
} else {
return cljs.core.reduced(result);
}
});
G__9806 = function(result,input){
switch(arguments.length){
case 0:
return G__9806__0.call(this);
case 1:
return G__9806__1.call(this,result);
case 2:
return G__9806__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9806.cljs$core$IFn$_invoke$arity$0 = G__9806__0;
G__9806.cljs$core$IFn$_invoke$arity$1 = G__9806__1;
G__9806.cljs$core$IFn$_invoke$arity$2 = G__9806__2;
return G__9806;
})()
});
});
var cljs$core$take_while__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.truth_((function (){var G__9805 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9805) : pred.call(null,G__9805));
})())){
return cljs.core.cons(cljs.core.first(s),cljs$core$take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
cljs$core$take_while = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$take_while__1.call(this,pred);
case 2:
return cljs$core$take_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take_while.cljs$core$IFn$_invoke$arity$1 = cljs$core$take_while__1;
cljs$core$take_while.cljs$core$IFn$_invoke$arity$2 = cljs$core$take_while__2;
return cljs$core$take_while;
})()
;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__9811 = (function (){var G__9813 = cljs.core._entry_key(sc,e);
var G__9814 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9813,G__9814) : comp.call(null,G__9813,G__9814));
})();
var G__9812 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__9811,G__9812) : test.call(null,G__9811,G__9812));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function() {
var cljs$core$subseq = null;
var cljs$core$subseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9818 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9818,(0),null);
var s = vec__9818;
if(cljs.core.truth_((function (){var G__9819 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9819) : include.call(null,G__9819));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});
var cljs$core$subseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9820 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9820,(0),null);
var s = vec__9820;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
cljs$core$subseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return cljs$core$subseq__3.call(this,sc,start_test,start_key);
case 5:
return cljs$core$subseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subseq.cljs$core$IFn$_invoke$arity$3 = cljs$core$subseq__3;
cljs$core$subseq.cljs$core$IFn$_invoke$arity$5 = cljs$core$subseq__5;
return cljs$core$subseq;
})()
;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a reverse seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function() {
var cljs$core$rsubseq = null;
var cljs$core$rsubseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9824 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9824,(0),null);
var s = vec__9824;
if(cljs.core.truth_((function (){var G__9825 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9825) : include.call(null,G__9825));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});
var cljs$core$rsubseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9826 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9826,(0),null);
var s = vec__9826;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
cljs$core$rsubseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return cljs$core$rsubseq__3.call(this,sc,start_test,start_key);
case 5:
return cljs$core$rsubseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$rsubseq.cljs$core$IFn$_invoke$arity$3 = cljs$core$rsubseq__3;
cljs$core$rsubseq.cljs$core$IFn$_invoke$arity$5 = cljs$core$rsubseq__5;
return cljs$core$rsubseq;
})()
;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__9827 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__9827) : Math.ceil.call(null,G__9827));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4183__auto__ = self__.__hash;
if(!((h__4183__auto__ == null))){
return h__4183__auto__;
} else {
var h__4183__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4183__auto____$1;

return h__4183__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__9828 = ret;
var G__9829 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9828,G__9829) : f.call(null,G__9828,G__9829));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__9830 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9830) : cljs.core.deref.call(null,G__9830));
} else {
var G__9831 = (i + self__.step);
var G__9832 = ret__$1;
i = G__9831;
ret = G__9832;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function() {
var cljs$core$range = null;
var cljs$core$range__0 = (function (){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});
var cljs$core$range__1 = (function (end){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});
var cljs$core$range__2 = (function (start,end){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});
var cljs$core$range__3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});
cljs$core$range = function(start,end,step){
switch(arguments.length){
case 0:
return cljs$core$range__0.call(this);
case 1:
return cljs$core$range__1.call(this,start);
case 2:
return cljs$core$range__2.call(this,start,end);
case 3:
return cljs$core$range__3.call(this,start,end,step);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$range.cljs$core$IFn$_invoke$arity$0 = cljs$core$range__0;
cljs$core$range.cljs$core$IFn$_invoke$arity$1 = cljs$core$range__1;
cljs$core$range.cljs$core$IFn$_invoke$arity$2 = cljs$core$range__2;
cljs$core$range.cljs$core$IFn$_invoke$arity$3 = cljs$core$range__3;
return cljs$core$range;
})()
;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.take_nth = (function() {
var cljs$core$take_nth = null;
var cljs$core$take_nth__1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__9850 = null;
var G__9850__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9850__1 = (function (result){
var G__9847 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9847) : rf.call(null,G__9847));
});
var G__9850__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__9848 = result;
var G__9849 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9848,G__9849) : rf.call(null,G__9848,G__9849));
} else {
return result;
}
});
G__9850 = function(result,input){
switch(arguments.length){
case 0:
return G__9850__0.call(this);
case 1:
return G__9850__1.call(this,result);
case 2:
return G__9850__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9850.cljs$core$IFn$_invoke$arity$0 = G__9850__0;
G__9850.cljs$core$IFn$_invoke$arity$1 = G__9850__1;
G__9850.cljs$core$IFn$_invoke$arity$2 = G__9850__2;
return G__9850;
})()
;})(ia))
});
});
var cljs$core$take_nth__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs$core$take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});
cljs$core$take_nth = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$take_nth__1.call(this,n);
case 2:
return cljs$core$take_nth__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take_nth.cljs$core$IFn$_invoke$arity$1 = cljs$core$take_nth__1;
cljs$core$take_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$take_nth__2;
return cljs$core$take_nth;
})()
;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function() {
var cljs$core$partition_by = null;
var cljs$core$partition_by__1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__9872 = null;
var G__9872__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9872__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9863 = result;
var G__9864 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9863,G__9864) : rf.call(null,G__9863,G__9864));
})());
})());
var G__9865 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9865) : rf.call(null,G__9865));
});
var G__9872__2 = (function (result,input){
var pval = (function (){var G__9866 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9866) : cljs.core.deref.call(null,G__9866));
})();
var val = (function (){var G__9867 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9867) : f.call(null,G__9867));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__9868 = result;
var G__9869 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9868,G__9869) : rf.call(null,G__9868,G__9869));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__9872 = function(result,input){
switch(arguments.length){
case 0:
return G__9872__0.call(this);
case 1:
return G__9872__1.call(this,result);
case 2:
return G__9872__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9872.cljs$core$IFn$_invoke$arity$0 = G__9872__0;
G__9872.cljs$core$IFn$_invoke$arity$1 = G__9872__1;
G__9872.cljs$core$IFn$_invoke$arity$2 = G__9872__2;
return G__9872;
})()
;})(a,pa))
});
});
var cljs$core$partition_by__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__9870 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9870) : f.call(null,G__9870));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4126__auto__){
return (function (p1__9851_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__9871 = p1__9851_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9871) : f.call(null,G__9871));
})());
});})(fst,fv,s,temp__4126__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs$core$partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});
cljs$core$partition_by = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$partition_by__1.call(this,f);
case 2:
return cljs$core$partition_by__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition_by.cljs$core$IFn$_invoke$arity$1 = cljs$core$partition_by__1;
cljs$core$partition_by.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition_by__2;
return cljs$core$partition_by;
})()
;
/**
 * Returns a map from distinct items in coll to the number of times
 * they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 * per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function() {
var cljs$core$reductions = null;
var cljs$core$reductions__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
return cljs$core$reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});
var cljs$core$reductions__3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs$core$reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__9881 = init;
var G__9882 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9881,G__9882) : f.call(null,G__9881,G__9882));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});
cljs$core$reductions = function(f,init,coll){
switch(arguments.length){
case 2:
return cljs$core$reductions__2.call(this,f,init);
case 3:
return cljs$core$reductions__3.call(this,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$reductions.cljs$core$IFn$_invoke$arity$2 = cljs$core$reductions__2;
cljs$core$reductions.cljs$core$IFn$_invoke$arity$3 = cljs$core$reductions__3;
return cljs$core$reductions;
})()
;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 * of those fns.  The returned fn takes a variable number of args, and
 * returns a vector containing the result of applying each fn to the
 * args (left-to-right).
 * ((juxt a b c) x) => [(a x) (b x) (c x)]
 * @param {...*} var_args
 */
cljs.core.juxt = (function() {
var cljs$core$juxt = null;
var cljs$core$juxt__1 = (function (f){
return (function() {
var G__9977 = null;
var G__9977__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__9977__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9935 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9935) : f.call(null,G__9935));
})()],null));
});
var G__9977__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9936 = x;
var G__9937 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9936,G__9937) : f.call(null,G__9936,G__9937));
})()],null));
});
var G__9977__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9938 = x;
var G__9939 = y;
var G__9940 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9938,G__9939,G__9940) : f.call(null,G__9938,G__9939,G__9940));
})()],null));
});
var G__9977__4 = (function() { 
var G__9978__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__9978 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9979__i = 0, G__9979__a = new Array(arguments.length -  3);
while (G__9979__i < G__9979__a.length) {G__9979__a[G__9979__i] = arguments[G__9979__i + 3]; ++G__9979__i;}
  args = new cljs.core.IndexedSeq(G__9979__a,0);
} 
return G__9978__delegate.call(this,x,y,z,args);};
G__9978.cljs$lang$maxFixedArity = 3;
G__9978.cljs$lang$applyTo = (function (arglist__9980){
var x = cljs.core.first(arglist__9980);
arglist__9980 = cljs.core.next(arglist__9980);
var y = cljs.core.first(arglist__9980);
arglist__9980 = cljs.core.next(arglist__9980);
var z = cljs.core.first(arglist__9980);
var args = cljs.core.rest(arglist__9980);
return G__9978__delegate(x,y,z,args);
});
G__9978.cljs$core$IFn$_invoke$arity$variadic = G__9978__delegate;
return G__9978;
})()
;
G__9977 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9977__0.call(this);
case 1:
return G__9977__1.call(this,x);
case 2:
return G__9977__2.call(this,x,y);
case 3:
return G__9977__3.call(this,x,y,z);
default:
var G__9981 = null;
if (arguments.length > 3) {
var G__9982__i = 0, G__9982__a = new Array(arguments.length -  3);
while (G__9982__i < G__9982__a.length) {G__9982__a[G__9982__i] = arguments[G__9982__i + 3]; ++G__9982__i;}
G__9981 = new cljs.core.IndexedSeq(G__9982__a,0);
}
return G__9977__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9981);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9977.cljs$lang$maxFixedArity = 3;
G__9977.cljs$lang$applyTo = G__9977__4.cljs$lang$applyTo;
G__9977.cljs$core$IFn$_invoke$arity$0 = G__9977__0;
G__9977.cljs$core$IFn$_invoke$arity$1 = G__9977__1;
G__9977.cljs$core$IFn$_invoke$arity$2 = G__9977__2;
G__9977.cljs$core$IFn$_invoke$arity$3 = G__9977__3;
G__9977.cljs$core$IFn$_invoke$arity$variadic = G__9977__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9977;
})()
});
var cljs$core$juxt__2 = (function (f,g){
return (function() {
var G__9983 = null;
var G__9983__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__9983__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9941 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9941) : f.call(null,G__9941));
})(),(function (){var G__9942 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9942) : g.call(null,G__9942));
})()],null));
});
var G__9983__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9943 = x;
var G__9944 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9943,G__9944) : f.call(null,G__9943,G__9944));
})(),(function (){var G__9945 = x;
var G__9946 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9945,G__9946) : g.call(null,G__9945,G__9946));
})()],null));
});
var G__9983__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9947 = x;
var G__9948 = y;
var G__9949 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9947,G__9948,G__9949) : f.call(null,G__9947,G__9948,G__9949));
})(),(function (){var G__9950 = x;
var G__9951 = y;
var G__9952 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9950,G__9951,G__9952) : g.call(null,G__9950,G__9951,G__9952));
})()],null));
});
var G__9983__4 = (function() { 
var G__9984__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__9984 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9985__i = 0, G__9985__a = new Array(arguments.length -  3);
while (G__9985__i < G__9985__a.length) {G__9985__a[G__9985__i] = arguments[G__9985__i + 3]; ++G__9985__i;}
  args = new cljs.core.IndexedSeq(G__9985__a,0);
} 
return G__9984__delegate.call(this,x,y,z,args);};
G__9984.cljs$lang$maxFixedArity = 3;
G__9984.cljs$lang$applyTo = (function (arglist__9986){
var x = cljs.core.first(arglist__9986);
arglist__9986 = cljs.core.next(arglist__9986);
var y = cljs.core.first(arglist__9986);
arglist__9986 = cljs.core.next(arglist__9986);
var z = cljs.core.first(arglist__9986);
var args = cljs.core.rest(arglist__9986);
return G__9984__delegate(x,y,z,args);
});
G__9984.cljs$core$IFn$_invoke$arity$variadic = G__9984__delegate;
return G__9984;
})()
;
G__9983 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9983__0.call(this);
case 1:
return G__9983__1.call(this,x);
case 2:
return G__9983__2.call(this,x,y);
case 3:
return G__9983__3.call(this,x,y,z);
default:
var G__9987 = null;
if (arguments.length > 3) {
var G__9988__i = 0, G__9988__a = new Array(arguments.length -  3);
while (G__9988__i < G__9988__a.length) {G__9988__a[G__9988__i] = arguments[G__9988__i + 3]; ++G__9988__i;}
G__9987 = new cljs.core.IndexedSeq(G__9988__a,0);
}
return G__9983__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9983.cljs$lang$maxFixedArity = 3;
G__9983.cljs$lang$applyTo = G__9983__4.cljs$lang$applyTo;
G__9983.cljs$core$IFn$_invoke$arity$0 = G__9983__0;
G__9983.cljs$core$IFn$_invoke$arity$1 = G__9983__1;
G__9983.cljs$core$IFn$_invoke$arity$2 = G__9983__2;
G__9983.cljs$core$IFn$_invoke$arity$3 = G__9983__3;
G__9983.cljs$core$IFn$_invoke$arity$variadic = G__9983__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9983;
})()
});
var cljs$core$juxt__3 = (function (f,g,h){
return (function() {
var G__9989 = null;
var G__9989__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__9989__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9953 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9953) : f.call(null,G__9953));
})(),(function (){var G__9954 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9954) : g.call(null,G__9954));
})(),(function (){var G__9955 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__9955) : h.call(null,G__9955));
})()],null));
});
var G__9989__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9956 = x;
var G__9957 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9956,G__9957) : f.call(null,G__9956,G__9957));
})(),(function (){var G__9958 = x;
var G__9959 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9958,G__9959) : g.call(null,G__9958,G__9959));
})(),(function (){var G__9960 = x;
var G__9961 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__9960,G__9961) : h.call(null,G__9960,G__9961));
})()],null));
});
var G__9989__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9962 = x;
var G__9963 = y;
var G__9964 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9962,G__9963,G__9964) : f.call(null,G__9962,G__9963,G__9964));
})(),(function (){var G__9965 = x;
var G__9966 = y;
var G__9967 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9965,G__9966,G__9967) : g.call(null,G__9965,G__9966,G__9967));
})(),(function (){var G__9968 = x;
var G__9969 = y;
var G__9970 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__9968,G__9969,G__9970) : h.call(null,G__9968,G__9969,G__9970));
})()],null));
});
var G__9989__4 = (function() { 
var G__9990__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__9990 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9991__i = 0, G__9991__a = new Array(arguments.length -  3);
while (G__9991__i < G__9991__a.length) {G__9991__a[G__9991__i] = arguments[G__9991__i + 3]; ++G__9991__i;}
  args = new cljs.core.IndexedSeq(G__9991__a,0);
} 
return G__9990__delegate.call(this,x,y,z,args);};
G__9990.cljs$lang$maxFixedArity = 3;
G__9990.cljs$lang$applyTo = (function (arglist__9992){
var x = cljs.core.first(arglist__9992);
arglist__9992 = cljs.core.next(arglist__9992);
var y = cljs.core.first(arglist__9992);
arglist__9992 = cljs.core.next(arglist__9992);
var z = cljs.core.first(arglist__9992);
var args = cljs.core.rest(arglist__9992);
return G__9990__delegate(x,y,z,args);
});
G__9990.cljs$core$IFn$_invoke$arity$variadic = G__9990__delegate;
return G__9990;
})()
;
G__9989 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9989__0.call(this);
case 1:
return G__9989__1.call(this,x);
case 2:
return G__9989__2.call(this,x,y);
case 3:
return G__9989__3.call(this,x,y,z);
default:
var G__9993 = null;
if (arguments.length > 3) {
var G__9994__i = 0, G__9994__a = new Array(arguments.length -  3);
while (G__9994__i < G__9994__a.length) {G__9994__a[G__9994__i] = arguments[G__9994__i + 3]; ++G__9994__i;}
G__9993 = new cljs.core.IndexedSeq(G__9994__a,0);
}
return G__9989__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9989.cljs$lang$maxFixedArity = 3;
G__9989.cljs$lang$applyTo = G__9989__4.cljs$lang$applyTo;
G__9989.cljs$core$IFn$_invoke$arity$0 = G__9989__0;
G__9989.cljs$core$IFn$_invoke$arity$1 = G__9989__1;
G__9989.cljs$core$IFn$_invoke$arity$2 = G__9989__2;
G__9989.cljs$core$IFn$_invoke$arity$3 = G__9989__3;
G__9989.cljs$core$IFn$_invoke$arity$variadic = G__9989__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9989;
})()
});
var cljs$core$juxt__4 = (function() { 
var G__9995__delegate = function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__9996 = null;
var G__9996__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9883_SHARP_,p2__9884_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9883_SHARP_,(function (){return (p2__9884_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__9884_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__9884_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9996__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9885_SHARP_,p2__9886_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9885_SHARP_,(function (){var G__9971 = x;
return (p2__9886_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__9886_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9971) : p2__9886_SHARP_.call(null,G__9971));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9996__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9887_SHARP_,p2__9888_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9887_SHARP_,(function (){var G__9972 = x;
var G__9973 = y;
return (p2__9888_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__9888_SHARP_.cljs$core$IFn$_invoke$arity$2(G__9972,G__9973) : p2__9888_SHARP_.call(null,G__9972,G__9973));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9996__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9889_SHARP_,p2__9890_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9889_SHARP_,(function (){var G__9974 = x;
var G__9975 = y;
var G__9976 = z;
return (p2__9890_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__9890_SHARP_.cljs$core$IFn$_invoke$arity$3(G__9974,G__9975,G__9976) : p2__9890_SHARP_.call(null,G__9974,G__9975,G__9976));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9996__4 = (function() { 
var G__9997__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9891_SHARP_,p2__9892_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9891_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__9892_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__9997 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9998__i = 0, G__9998__a = new Array(arguments.length -  3);
while (G__9998__i < G__9998__a.length) {G__9998__a[G__9998__i] = arguments[G__9998__i + 3]; ++G__9998__i;}
  args = new cljs.core.IndexedSeq(G__9998__a,0);
} 
return G__9997__delegate.call(this,x,y,z,args);};
G__9997.cljs$lang$maxFixedArity = 3;
G__9997.cljs$lang$applyTo = (function (arglist__9999){
var x = cljs.core.first(arglist__9999);
arglist__9999 = cljs.core.next(arglist__9999);
var y = cljs.core.first(arglist__9999);
arglist__9999 = cljs.core.next(arglist__9999);
var z = cljs.core.first(arglist__9999);
var args = cljs.core.rest(arglist__9999);
return G__9997__delegate(x,y,z,args);
});
G__9997.cljs$core$IFn$_invoke$arity$variadic = G__9997__delegate;
return G__9997;
})()
;
G__9996 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9996__0.call(this);
case 1:
return G__9996__1.call(this,x);
case 2:
return G__9996__2.call(this,x,y);
case 3:
return G__9996__3.call(this,x,y,z);
default:
var G__10000 = null;
if (arguments.length > 3) {
var G__10001__i = 0, G__10001__a = new Array(arguments.length -  3);
while (G__10001__i < G__10001__a.length) {G__10001__a[G__10001__i] = arguments[G__10001__i + 3]; ++G__10001__i;}
G__10000 = new cljs.core.IndexedSeq(G__10001__a,0);
}
return G__9996__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__10000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9996.cljs$lang$maxFixedArity = 3;
G__9996.cljs$lang$applyTo = G__9996__4.cljs$lang$applyTo;
G__9996.cljs$core$IFn$_invoke$arity$0 = G__9996__0;
G__9996.cljs$core$IFn$_invoke$arity$1 = G__9996__1;
G__9996.cljs$core$IFn$_invoke$arity$2 = G__9996__2;
G__9996.cljs$core$IFn$_invoke$arity$3 = G__9996__3;
G__9996.cljs$core$IFn$_invoke$arity$variadic = G__9996__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9996;
})()
;})(fs__$1))
};
var G__9995 = function (f,g,h,var_args){
var fs = null;
if (arguments.length > 3) {
var G__10002__i = 0, G__10002__a = new Array(arguments.length -  3);
while (G__10002__i < G__10002__a.length) {G__10002__a[G__10002__i] = arguments[G__10002__i + 3]; ++G__10002__i;}
  fs = new cljs.core.IndexedSeq(G__10002__a,0);
} 
return G__9995__delegate.call(this,f,g,h,fs);};
G__9995.cljs$lang$maxFixedArity = 3;
G__9995.cljs$lang$applyTo = (function (arglist__10003){
var f = cljs.core.first(arglist__10003);
arglist__10003 = cljs.core.next(arglist__10003);
var g = cljs.core.first(arglist__10003);
arglist__10003 = cljs.core.next(arglist__10003);
var h = cljs.core.first(arglist__10003);
var fs = cljs.core.rest(arglist__10003);
return G__9995__delegate(f,g,h,fs);
});
G__9995.cljs$core$IFn$_invoke$arity$variadic = G__9995__delegate;
return G__9995;
})()
;
cljs$core$juxt = function(f,g,h,var_args){
var fs = var_args;
switch(arguments.length){
case 1:
return cljs$core$juxt__1.call(this,f);
case 2:
return cljs$core$juxt__2.call(this,f,g);
case 3:
return cljs$core$juxt__3.call(this,f,g,h);
default:
var G__10004 = null;
if (arguments.length > 3) {
var G__10005__i = 0, G__10005__a = new Array(arguments.length -  3);
while (G__10005__i < G__10005__a.length) {G__10005__a[G__10005__i] = arguments[G__10005__i + 3]; ++G__10005__i;}
G__10004 = new cljs.core.IndexedSeq(G__10005__a,0);
}
return cljs$core$juxt__4.cljs$core$IFn$_invoke$arity$variadic(f,g,h, G__10004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$juxt.cljs$lang$maxFixedArity = 3;
cljs$core$juxt.cljs$lang$applyTo = cljs$core$juxt__4.cljs$lang$applyTo;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$1 = cljs$core$juxt__1;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$2 = cljs$core$juxt__2;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$3 = cljs$core$juxt__3;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$variadic = cljs$core$juxt__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$juxt;
})()
;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. dorun can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function() {
var cljs$core$dorun = null;
var cljs$core$dorun__1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__10006 = cljs.core.next(coll);
coll = G__10006;
continue;
} else {
return null;
}
break;
}
});
var cljs$core$dorun__2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__10007 = (n - (1));
var G__10008 = cljs.core.next(coll);
n = G__10007;
coll = G__10008;
continue;
} else {
return null;
}
break;
}
});
cljs$core$dorun = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$dorun__1.call(this,n);
case 2:
return cljs$core$dorun__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dorun.cljs$core$IFn$_invoke$arity$1 = cljs$core$dorun__1;
cljs$core$dorun.cljs$core$IFn$_invoke$arity$2 = cljs$core$dorun__2;
return cljs$core$dorun;
})()
;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. doall can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, retains the head and returns it, thus causing the entire
 * seq to reside in memory at one time.
 */
cljs.core.doall = (function() {
var cljs$core$doall = null;
var cljs$core$doall__1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});
var cljs$core$doall__2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});
cljs$core$doall = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$doall__1.call(this,n);
case 2:
return cljs$core$doall__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$doall.cljs$core$IFn$_invoke$arity$1 = cljs$core$doall__1;
cljs$core$doall.cljs$core$IFn$_invoke$arity$2 = cljs$core$doall__2;
return cljs$core$doall;
})()
;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 * re.exec(s). Returns a vector, containing first the matching
 * substring, then any capturing groups if the regular expression contains
 * capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__10012 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10012,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10012,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__3767__auto__ = flags;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_10020 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__3767__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__10021_10027 = cljs.core.first(coll);
var G__10022_10028 = writer;
var G__10023_10029 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10021_10027,G__10022_10028,G__10023_10029) : print_one.call(null,G__10021_10027,G__10022_10028,G__10023_10029));
} else {
}

var coll_10030__$1 = cljs.core.next(coll);
var n_10031 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_10030__$1) && (((n_10031 == null)) || (!((n_10031 === (0)))))){
cljs.core._write(writer,sep);

var G__10024_10032 = cljs.core.first(coll_10030__$1);
var G__10025_10033 = writer;
var G__10026_10034 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10024_10032,G__10025_10033,G__10026_10034) : print_one.call(null,G__10024_10032,G__10025_10033,G__10026_10034));

var G__10035 = cljs.core.next(coll_10030__$1);
var G__10036 = (n_10031 - (1));
coll_10030__$1 = G__10035;
n_10031 = G__10036;
continue;
} else {
if((cljs.core.seq(coll_10030__$1)) && ((n_10031 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__3767__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_10020;
}});
/**
 * @param {...*} var_args
 */
cljs.core.write_all = (function() { 
var cljs$core$write_all__delegate = function (writer,ss){
var seq__10041 = cljs.core.seq(ss);
var chunk__10042 = null;
var count__10043 = (0);
var i__10044 = (0);
while(true){
if((i__10044 < count__10043)){
var s = chunk__10042.cljs$core$IIndexed$_nth$arity$2(null,i__10044);
cljs.core._write(writer,s);

var G__10045 = seq__10041;
var G__10046 = chunk__10042;
var G__10047 = count__10043;
var G__10048 = (i__10044 + (1));
seq__10041 = G__10045;
chunk__10042 = G__10046;
count__10043 = G__10047;
i__10044 = G__10048;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10041);
if(temp__4126__auto__){
var seq__10041__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10041__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__10041__$1);
var G__10049 = cljs.core.chunk_rest(seq__10041__$1);
var G__10050 = c__4552__auto__;
var G__10051 = cljs.core.count(c__4552__auto__);
var G__10052 = (0);
seq__10041 = G__10049;
chunk__10042 = G__10050;
count__10043 = G__10051;
i__10044 = G__10052;
continue;
} else {
var s = cljs.core.first(seq__10041__$1);
cljs.core._write(writer,s);

var G__10053 = cljs.core.next(seq__10041__$1);
var G__10054 = null;
var G__10055 = (0);
var G__10056 = (0);
seq__10041 = G__10053;
chunk__10042 = G__10054;
count__10043 = G__10055;
i__10044 = G__10056;
continue;
}
} else {
return null;
}
}
break;
}
};
var cljs$core$write_all = function (writer,var_args){
var ss = null;
if (arguments.length > 1) {
var G__10057__i = 0, G__10057__a = new Array(arguments.length -  1);
while (G__10057__i < G__10057__a.length) {G__10057__a[G__10057__i] = arguments[G__10057__i + 1]; ++G__10057__i;}
  ss = new cljs.core.IndexedSeq(G__10057__a,0);
} 
return cljs$core$write_all__delegate.call(this,writer,ss);};
cljs$core$write_all.cljs$lang$maxFixedArity = 1;
cljs$core$write_all.cljs$lang$applyTo = (function (arglist__10058){
var writer = cljs.core.first(arglist__10058);
var ss = cljs.core.rest(arglist__10058);
return cljs$core$write_all__delegate(writer,ss);
});
cljs$core$write_all.cljs$core$IFn$_invoke$arity$variadic = cljs$core$write_all__delegate;
return cljs$core$write_all;
})()
;
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj10060 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj10060;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__10063 = "[\\\\\"\b\f\n\r\t]";
var G__10064 = "g";
return RegExp(G__10063,G__10064);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__3755__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__3755__auto__)){
var and__3755__auto____$1 = (function (){var G__10078 = obj;
if(G__10078){
var bit__4441__auto__ = (G__10078.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4441__auto__) || (G__10078.cljs$core$IMeta$)){
return true;
} else {
if((!G__10078.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__10078);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__10078);
}
})();
if(and__3755__auto____$1){
return cljs.core.meta(obj);
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
})())){
cljs.core._write(writer,"^");

var G__10079_10089 = cljs.core.meta(obj);
var G__10080_10090 = writer;
var G__10081_10091 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__10079_10089,G__10080_10090,G__10081_10091) : cljs.core.pr_writer.call(null,G__10079_10089,G__10080_10090,G__10081_10091));

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__10082 = obj;
if(G__10082){
var bit__4434__auto__ = (G__10082.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4434__auto__) || (G__10082.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__10083 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__10084 = cljs.core.pr_writer;
var G__10085 = writer;
var G__10086 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__10083,G__10084,G__10085,G__10086) : cljs.core.print_map.call(null,G__10083,G__10084,G__10085,G__10086));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__10087 = obj;
return goog.isString(G__10087);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__10092 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__10092;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__10088 = obj;
if(G__10088){
var bit__4441__auto__ = (G__10088.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4441__auto__) || (G__10088.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__10088.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__10088);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__10088);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4124__auto__ = new cljs.core.Keyword(null,"alt-impl","alt-impl",670969595).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4124__auto__)){
var alt_impl = temp__4124__auto__;
var G__10096 = obj;
var G__10097 = writer;
var G__10098 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"fallback-impl","fallback-impl",-1501286995),cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__10096,G__10097,G__10098) : alt_impl.call(null,G__10096,G__10097,G__10098));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__10103 = cljs.core.seq(cljs.core.next(objs));
var chunk__10104 = null;
var count__10105 = (0);
var i__10106 = (0);
while(true){
if((i__10106 < count__10105)){
var obj = chunk__10104.cljs$core$IIndexed$_nth$arity$2(null,i__10106);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10107 = seq__10103;
var G__10108 = chunk__10104;
var G__10109 = count__10105;
var G__10110 = (i__10106 + (1));
seq__10103 = G__10107;
chunk__10104 = G__10108;
count__10105 = G__10109;
i__10106 = G__10110;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10103);
if(temp__4126__auto__){
var seq__10103__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10103__$1)){
var c__4552__auto__ = cljs.core.chunk_first(seq__10103__$1);
var G__10111 = cljs.core.chunk_rest(seq__10103__$1);
var G__10112 = c__4552__auto__;
var G__10113 = cljs.core.count(c__4552__auto__);
var G__10114 = (0);
seq__10103 = G__10111;
chunk__10104 = G__10112;
count__10105 = G__10113;
i__10106 = G__10114;
continue;
} else {
var obj = cljs.core.first(seq__10103__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10115 = cljs.core.next(seq__10103__$1);
var G__10116 = null;
var G__10117 = (0);
var G__10118 = (0);
seq__10103 = G__10115;
chunk__10104 = G__10116;
count__10105 = G__10117;
i__10106 = G__10118;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 * options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 * the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 * @param {...*} var_args
 */
cljs.core.pr_str = (function() { 
var cljs$core$pr_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$pr_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10119__i = 0, G__10119__a = new Array(arguments.length -  0);
while (G__10119__i < G__10119__a.length) {G__10119__a[G__10119__i] = arguments[G__10119__i + 0]; ++G__10119__i;}
  objs = new cljs.core.IndexedSeq(G__10119__a,0);
} 
return cljs$core$pr_str__delegate.call(this,objs);};
cljs$core$pr_str.cljs$lang$maxFixedArity = 0;
cljs$core$pr_str.cljs$lang$applyTo = (function (arglist__10120){
var objs = cljs.core.seq(arglist__10120);
return cljs$core$pr_str__delegate(objs);
});
cljs$core$pr_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$pr_str__delegate;
return cljs$core$pr_str;
})()
;
/**
 * Same as pr-str followed by (newline)
 * @param {...*} var_args
 */
cljs.core.prn_str = (function() { 
var cljs$core$prn_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$prn_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10121__i = 0, G__10121__a = new Array(arguments.length -  0);
while (G__10121__i < G__10121__a.length) {G__10121__a[G__10121__i] = arguments[G__10121__i + 0]; ++G__10121__i;}
  objs = new cljs.core.IndexedSeq(G__10121__a,0);
} 
return cljs$core$prn_str__delegate.call(this,objs);};
cljs$core$prn_str.cljs$lang$maxFixedArity = 0;
cljs$core$prn_str.cljs$lang$applyTo = (function (arglist__10122){
var objs = cljs.core.seq(arglist__10122);
return cljs$core$prn_str__delegate(objs);
});
cljs$core$prn_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$prn_str__delegate;
return cljs$core$prn_str;
})()
;
/**
 * Prints the object(s) using string-print.  Prints the
 * object(s), separated by spaces if there is more than one.
 * By default, pr and prn print in a way that objects can be
 * read by the reader
 * @param {...*} var_args
 */
cljs.core.pr = (function() { 
var cljs$core$pr__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$pr = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10123__i = 0, G__10123__a = new Array(arguments.length -  0);
while (G__10123__i < G__10123__a.length) {G__10123__a[G__10123__i] = arguments[G__10123__i + 0]; ++G__10123__i;}
  objs = new cljs.core.IndexedSeq(G__10123__a,0);
} 
return cljs$core$pr__delegate.call(this,objs);};
cljs$core$pr.cljs$lang$maxFixedArity = 0;
cljs$core$pr.cljs$lang$applyTo = (function (arglist__10124){
var objs = cljs.core.seq(arglist__10124);
return cljs$core$pr__delegate(objs);
});
cljs$core$pr.cljs$core$IFn$_invoke$arity$variadic = cljs$core$pr__delegate;
return cljs$core$pr;
})()
;
/**
 * Prints the object(s) using string-print.
 * print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10125__i = 0, G__10125__a = new Array(arguments.length -  0);
while (G__10125__i < G__10125__a.length) {G__10125__a[G__10125__i] = arguments[G__10125__i + 0]; ++G__10125__i;}
  objs = new cljs.core.IndexedSeq(G__10125__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__10126){
var objs = cljs.core.seq(arglist__10126);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 * @param {...*} var_args
 */
cljs.core.print_str = (function() { 
var cljs$core$print_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$print_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10127__i = 0, G__10127__a = new Array(arguments.length -  0);
while (G__10127__i < G__10127__a.length) {G__10127__a[G__10127__i] = arguments[G__10127__i + 0]; ++G__10127__i;}
  objs = new cljs.core.IndexedSeq(G__10127__a,0);
} 
return cljs$core$print_str__delegate.call(this,objs);};
cljs$core$print_str.cljs$lang$maxFixedArity = 0;
cljs$core$print_str.cljs$lang$applyTo = (function (arglist__10128){
var objs = cljs.core.seq(arglist__10128);
return cljs$core$print_str__delegate(objs);
});
cljs$core$print_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$print_str__delegate;
return cljs$core$print_str;
})()
;
/**
 * Same as print followed by (newline)
 * @param {...*} var_args
 */
cljs.core.println = (function() { 
var cljs$core$println__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var cljs$core$println = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10129__i = 0, G__10129__a = new Array(arguments.length -  0);
while (G__10129__i < G__10129__a.length) {G__10129__a[G__10129__i] = arguments[G__10129__i + 0]; ++G__10129__i;}
  objs = new cljs.core.IndexedSeq(G__10129__a,0);
} 
return cljs$core$println__delegate.call(this,objs);};
cljs$core$println.cljs$lang$maxFixedArity = 0;
cljs$core$println.cljs$lang$applyTo = (function (arglist__10130){
var objs = cljs.core.seq(arglist__10130);
return cljs$core$println__delegate(objs);
});
cljs$core$println.cljs$core$IFn$_invoke$arity$variadic = cljs$core$println__delegate;
return cljs$core$println;
})()
;
/**
 * println to a string, returning it
 * @param {...*} var_args
 */
cljs.core.println_str = (function() { 
var cljs$core$println_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$println_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10131__i = 0, G__10131__a = new Array(arguments.length -  0);
while (G__10131__i < G__10131__a.length) {G__10131__a[G__10131__i] = arguments[G__10131__i + 0]; ++G__10131__i;}
  objs = new cljs.core.IndexedSeq(G__10131__a,0);
} 
return cljs$core$println_str__delegate.call(this,objs);};
cljs$core$println_str.cljs$lang$maxFixedArity = 0;
cljs$core$println_str.cljs$lang$applyTo = (function (arglist__10132){
var objs = cljs.core.seq(arglist__10132);
return cljs$core$println_str__delegate(objs);
});
cljs$core$println_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$println_str__delegate;
return cljs$core$println_str;
})()
;
/**
 * Same as pr followed by (newline).
 * @param {...*} var_args
 */
cljs.core.prn = (function() { 
var cljs$core$prn__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var cljs$core$prn = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10133__i = 0, G__10133__a = new Array(arguments.length -  0);
while (G__10133__i < G__10133__a.length) {G__10133__a[G__10133__i] = arguments[G__10133__i + 0]; ++G__10133__i;}
  objs = new cljs.core.IndexedSeq(G__10133__a,0);
} 
return cljs$core$prn__delegate.call(this,objs);};
cljs$core$prn.cljs$lang$maxFixedArity = 0;
cljs$core$prn.cljs$lang$applyTo = (function (arglist__10134){
var objs = cljs.core.seq(arglist__10134);
return cljs$core$prn__delegate(objs);
});
cljs$core$prn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$prn__delegate;
return cljs$core$prn;
})()
;
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__10141_10147 = cljs.core.key(e);
var G__10142_10148 = w;
var G__10143_10149 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10141_10147,G__10142_10148,G__10143_10149) : print_one.call(null,G__10141_10147,G__10142_10148,G__10143_10149));

cljs.core._write(w," ");

var G__10144 = cljs.core.val(e);
var G__10145 = w;
var G__10146 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10144,G__10145,G__10146) : print_one.call(null,G__10144,G__10145,G__10146));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 * (apply f its-current-meta args)
 * 
 * f must be free of side-effects
 * @param {...*} var_args
 */
cljs.core.alter_meta_BANG_ = (function() { 
var cljs$core$alter_meta_BANG___delegate = function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
};
var cljs$core$alter_meta_BANG_ = function (iref,f,var_args){
var args = null;
if (arguments.length > 2) {
var G__10150__i = 0, G__10150__a = new Array(arguments.length -  2);
while (G__10150__i < G__10150__a.length) {G__10150__a[G__10150__i] = arguments[G__10150__i + 2]; ++G__10150__i;}
  args = new cljs.core.IndexedSeq(G__10150__a,0);
} 
return cljs$core$alter_meta_BANG___delegate.call(this,iref,f,args);};
cljs$core$alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$alter_meta_BANG_.cljs$lang$applyTo = (function (arglist__10151){
var iref = cljs.core.first(arglist__10151);
arglist__10151 = cljs.core.next(arglist__10151);
var f = cljs.core.first(arglist__10151);
var args = cljs.core.rest(arglist__10151);
return cljs$core$alter_meta_BANG___delegate(iref,f,args);
});
cljs$core$alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$alter_meta_BANG___delegate;
return cljs$core$alter_meta_BANG_;
})()
;
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Alpha - subject to change.
 * 
 * Adds a watch function to an atom reference. The watch fn must be a
 * fn of 4 args: a key, the reference, its old-state, its
 * new-state. Whenever the reference's state might have been changed,
 * any registered watches will have their functions called. The watch
 * fn will be called synchronously. Note that an atom's state
 * may have changed again prior to the fn call, so use old/new-state
 * rather than derefing the reference. Keys must be unique per
 * reference, and can be used to remove the watch with remove-watch,
 * but are otherwise considered opaque by the watch mechanism.  Bear in
 * mind that regardless of the result or action of the watch fns the
 * atom's value will change.  Example:
 * 
 * (def a (atom 0))
 * (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 * (swap! a inc)
 * ;; Assertion Error
 * (deref a)
 * ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Alpha - subject to change.
 * 
 * Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 * supplied, the name is prefix# where # is some unique number. If
 * prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function() {
var cljs$core$gensym = null;
var cljs$core$gensym__0 = (function (){
return cljs$core$gensym.cljs$core$IFn$_invoke$arity$1("G__");
});
var cljs$core$gensym__1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__10154 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10154) : cljs.core.atom.call(null,G__10154));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});
cljs$core$gensym = function(prefix_string){
switch(arguments.length){
case 0:
return cljs$core$gensym__0.call(this);
case 1:
return cljs$core$gensym__1.call(this,prefix_string);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$gensym.cljs$core$IFn$_invoke$arity$0 = cljs$core$gensym__0;
cljs$core$gensym.cljs$core$IFn$_invoke$arity$1 = cljs$core$gensym__1;
return cljs$core$gensym;
})()
;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
var G__10156 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10156) : cljs.core.deref.call(null,G__10156));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a promise, delay, future or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__10157_SHARP_,p2__10158_SHARP_){
var ret = (function (){var G__10161 = p1__10157_SHARP_;
var G__10162 = p2__10158_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10161,G__10162) : rf.call(null,G__10161,G__10162));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 * collection, into the reduction.
 */
cljs.core.cat = (function cljs$core$cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__10165 = null;
var G__10165__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10165__1 = (function (result){
var G__10164 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10164) : rf.call(null,G__10164));
});
var G__10165__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__10165 = function(result,input){
switch(arguments.length){
case 0:
return G__10165__0.call(this);
case 1:
return G__10165__1.call(this,result);
case 2:
return G__10165__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10165.cljs$core$IFn$_invoke$arity$0 = G__10165__0;
G__10165.cljs$core$IFn$_invoke$arity$1 = G__10165__1;
G__10165.cljs$core$IFn$_invoke$arity$2 = G__10165__2;
return G__10165;
})()
;})(rf1))
});
/**
 * Returns a lazy sequence removing consecutive duplicates in coll.
 * Returns a transducer when no collection is provided.
 */
cljs.core.dedupe = (function() {
var cljs$core$dedupe = null;
var cljs$core$dedupe__0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__10174 = null;
var G__10174__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10174__1 = (function (result){
var G__10170 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10170) : rf.call(null,G__10170));
});
var G__10174__2 = (function (result,input){
var prior = (function (){var G__10171 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10171) : cljs.core.deref.call(null,G__10171));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__10172 = result;
var G__10173 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10172,G__10173) : rf.call(null,G__10172,G__10173));
}
});
G__10174 = function(result,input){
switch(arguments.length){
case 0:
return G__10174__0.call(this);
case 1:
return G__10174__1.call(this,result);
case 2:
return G__10174__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10174.cljs$core$IFn$_invoke$arity$0 = G__10174__0;
G__10174.cljs$core$IFn$_invoke$arity$1 = G__10174__1;
G__10174.cljs$core$IFn$_invoke$arity$2 = G__10174__2;
return G__10174;
})()
;})(pa))
});
});
var cljs$core$dedupe__1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs$core$dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});
cljs$core$dedupe = function(coll){
switch(arguments.length){
case 0:
return cljs$core$dedupe__0.call(this);
case 1:
return cljs$core$dedupe__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dedupe.cljs$core$IFn$_invoke$arity$0 = cljs$core$dedupe__0;
cljs$core$dedupe.cljs$core$IFn$_invoke$arity$1 = cljs$core$dedupe__1;
return cljs$core$dedupe;
})()
;
/**
 * Returns items from coll with random probability of prob (0.0 -
 * 1.0).  Returns a transducer when no collection is provided.
 */
cljs.core.random_sample = (function() {
var cljs$core$random_sample = null;
var cljs$core$random_sample__1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});
var cljs$core$random_sample__2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});
cljs$core$random_sample = function(prob,coll){
switch(arguments.length){
case 1:
return cljs$core$random_sample__1.call(this,prob);
case 2:
return cljs$core$random_sample__2.call(this,prob,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$random_sample.cljs$core$IFn$_invoke$arity$1 = cljs$core$random_sample__1;
cljs$core$random_sample.cljs$core$IFn$_invoke$arity$2 = cljs$core$random_sample__2;
return cljs$core$random_sample;
})()
;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
})
cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4346__auto__,writer__4347__auto__,opt__4348__auto__){
return cljs.core._write(writer__4347__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function cljs$core$__GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4743__auto__ = this;
return cljs.core.es6_iterator(this__4743__auto__);
}));
/**
 * Returns a reducible/iterable/seqable application of
 * the transducer to the items in coll. Note that these applications
 * will be performed every time iterator/seq/reduce is called.
 */
cljs.core.eduction = (function cljs$core$eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
 * Runs the supplied procedure (via reduce), for purposes of side
 * effects, on successive items in the collection. Returns nil
 */
cljs.core.run_BANG_ = (function cljs$core$run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__10176_SHARP_,p2__10175_SHARP_){
var G__10178 = p2__10175_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__10178) : proc.call(null,G__10178));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj10180 = {};
return obj10180;
})();

/**
 * Recursively transforms clj values to JavaScript
 */
cljs.core._clj__GT_js = (function cljs$core$_clj__GT_js(x){
if((function (){var and__3755__auto__ = x;
if(and__3755__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__3755__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4403__auto__ = (((x == null))?null:x);
return (function (){var or__3767__auto__ = (cljs.core._clj__GT_js[(function (){var G__10184 = x__4403__auto__;
return goog.typeOf(G__10184);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

/**
 * Transforms map keys to valid JavaScript keys. Arbitrary keys are
 * encoded to their string representation via (pr-str x)
 */
cljs.core._key__GT_js = (function cljs$core$_key__GT_js(x){
if((function (){var and__3755__auto__ = x;
if(and__3755__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__3755__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4403__auto__ = (((x == null))?null:x);
return (function (){var or__3767__auto__ = (cljs.core._key__GT_js[(function (){var G__10188 = x__4403__auto__;
return goog.typeOf(G__10188);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function cljs$core$key__GT_js(k){
if((function (){var G__10191 = k;
if(G__10191){
var bit__4441__auto__ = null;
if(cljs.core.truth_((function (){var or__3767__auto__ = bit__4441__auto__;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return G__10191.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10191.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10191);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10191);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__10192 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__10192) : cljs.core.clj__GT_js.call(null,G__10192));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
 * Maps become Objects. Arbitrary keys are encoded to by key->js.
 */
cljs.core.clj__GT_js = (function cljs$core$clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__10208 = x;
if(G__10208){
var bit__4441__auto__ = null;
if(cljs.core.truth_((function (){var or__3767__auto__ = bit__4441__auto__;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return G__10208.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10208.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10208);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10208);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj10210 = {};
return obj10210;
})();
var seq__10211_10221 = cljs.core.seq(x);
var chunk__10212_10222 = null;
var count__10213_10223 = (0);
var i__10214_10224 = (0);
while(true){
if((i__10214_10224 < count__10213_10223)){
var vec__10215_10225 = chunk__10212_10222.cljs$core$IIndexed$_nth$arity$2(null,i__10214_10224);
var k_10226 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10215_10225,(0),null);
var v_10227 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10215_10225,(1),null);
(m[cljs.core.key__GT_js(k_10226)] = cljs$core$clj__GT_js(v_10227));

var G__10228 = seq__10211_10221;
var G__10229 = chunk__10212_10222;
var G__10230 = count__10213_10223;
var G__10231 = (i__10214_10224 + (1));
seq__10211_10221 = G__10228;
chunk__10212_10222 = G__10229;
count__10213_10223 = G__10230;
i__10214_10224 = G__10231;
continue;
} else {
var temp__4126__auto___10232 = cljs.core.seq(seq__10211_10221);
if(temp__4126__auto___10232){
var seq__10211_10233__$1 = temp__4126__auto___10232;
if(cljs.core.chunked_seq_QMARK_(seq__10211_10233__$1)){
var c__4552__auto___10234 = cljs.core.chunk_first(seq__10211_10233__$1);
var G__10235 = cljs.core.chunk_rest(seq__10211_10233__$1);
var G__10236 = c__4552__auto___10234;
var G__10237 = cljs.core.count(c__4552__auto___10234);
var G__10238 = (0);
seq__10211_10221 = G__10235;
chunk__10212_10222 = G__10236;
count__10213_10223 = G__10237;
i__10214_10224 = G__10238;
continue;
} else {
var vec__10216_10239 = cljs.core.first(seq__10211_10233__$1);
var k_10240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10216_10239,(0),null);
var v_10241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10216_10239,(1),null);
(m[cljs.core.key__GT_js(k_10240)] = cljs$core$clj__GT_js(v_10241));

var G__10242 = cljs.core.next(seq__10211_10233__$1);
var G__10243 = null;
var G__10244 = (0);
var G__10245 = (0);
seq__10211_10221 = G__10242;
chunk__10212_10222 = G__10243;
count__10213_10223 = G__10244;
i__10214_10224 = G__10245;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__10217_10246 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$clj__GT_js,x));
var chunk__10218_10247 = null;
var count__10219_10248 = (0);
var i__10220_10249 = (0);
while(true){
if((i__10220_10249 < count__10219_10248)){
var x_10250__$1 = chunk__10218_10247.cljs$core$IIndexed$_nth$arity$2(null,i__10220_10249);
arr.push(x_10250__$1);

var G__10251 = seq__10217_10246;
var G__10252 = chunk__10218_10247;
var G__10253 = count__10219_10248;
var G__10254 = (i__10220_10249 + (1));
seq__10217_10246 = G__10251;
chunk__10218_10247 = G__10252;
count__10219_10248 = G__10253;
i__10220_10249 = G__10254;
continue;
} else {
var temp__4126__auto___10255 = cljs.core.seq(seq__10217_10246);
if(temp__4126__auto___10255){
var seq__10217_10256__$1 = temp__4126__auto___10255;
if(cljs.core.chunked_seq_QMARK_(seq__10217_10256__$1)){
var c__4552__auto___10257 = cljs.core.chunk_first(seq__10217_10256__$1);
var G__10258 = cljs.core.chunk_rest(seq__10217_10256__$1);
var G__10259 = c__4552__auto___10257;
var G__10260 = cljs.core.count(c__4552__auto___10257);
var G__10261 = (0);
seq__10217_10246 = G__10258;
chunk__10218_10247 = G__10259;
count__10219_10248 = G__10260;
i__10220_10249 = G__10261;
continue;
} else {
var x_10262__$1 = cljs.core.first(seq__10217_10256__$1);
arr.push(x_10262__$1);

var G__10263 = cljs.core.next(seq__10217_10256__$1);
var G__10264 = null;
var G__10265 = (0);
var G__10266 = (0);
seq__10217_10246 = G__10263;
chunk__10218_10247 = G__10264;
count__10219_10248 = G__10265;
i__10220_10249 = G__10266;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj10268 = {};
return obj10268;
})();

/**
 * Transforms JavaScript values to Clojure
 */
cljs.core._js__GT_clj = (function cljs$core$_js__GT_clj(x,options){
if((function (){var and__3755__auto__ = x;
if(and__3755__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__3755__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4403__auto__ = (((x == null))?null:x);
return (function (){var or__3767__auto__ = (cljs.core._js__GT_clj[(function (){var G__10272 = x__4403__auto__;
return goog.typeOf(G__10272);
})()]);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 * vectors, and JavaScript objects into ClojureScript maps.  With
 * option ':keywordize-keys true' will convert object fields from
 * strings to keywords.
 * @param {...*} var_args
 */
cljs.core.js__GT_clj = (function() {
var cljs$core$js__GT_clj = null;
var cljs$core$js__GT_clj__1 = (function (x){
return cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});
var cljs$core$js__GT_clj__2 = (function() { 
var G__10329__delegate = function (x,opts){
var map__10302 = opts;
var map__10302__$1 = ((cljs.core.seq_QMARK_(map__10302))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10302):map__10302);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10302__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__10302,map__10302__$1,keywordize_keys,keyfn){
return (function cljs$core$js__GT_clj_$_thisfn(x__$1){
if((function (){var G__10318 = x__$1;
if(G__10318){
var bit__4441__auto__ = null;
if(cljs.core.truth_((function (){var or__3767__auto__ = bit__4441__auto__;
if(cljs.core.truth_(or__3767__auto__)){
return or__3767__auto__;
} else {
return G__10318.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__10318.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10318);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10318);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if(cljs.core.array_QMARK_(x__$1)){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4521__auto__ = ((function (map__10302,map__10302__$1,keywordize_keys,keyfn){
return (function cljs$core$js__GT_clj_$_thisfn_$_iter__10319(s__10320){
return (new cljs.core.LazySeq(null,((function (map__10302,map__10302__$1,keywordize_keys,keyfn){
return (function (){
var s__10320__$1 = s__10320;
while(true){
var temp__4126__auto__ = cljs.core.seq(s__10320__$1);
if(temp__4126__auto__){
var s__10320__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s__10320__$2)){
var c__4519__auto__ = cljs.core.chunk_first(s__10320__$2);
var size__4520__auto__ = cljs.core.count(c__4519__auto__);
var b__10322 = cljs.core.chunk_buffer(size__4520__auto__);
if((function (){var i__10321 = (0);
while(true){
if((i__10321 < size__4520__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4519__auto__,i__10321);
cljs.core.chunk_append(b__10322,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10327 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10327) : keyfn.call(null,G__10327));
})(),cljs$core$js__GT_clj_$_thisfn((x__$1[k]))], null));

var G__10330 = (i__10321 + (1));
i__10321 = G__10330;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__10322),cljs$core$js__GT_clj_$_thisfn_$_iter__10319(cljs.core.chunk_rest(s__10320__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__10322),null);
}
} else {
var k = cljs.core.first(s__10320__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10328 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10328) : keyfn.call(null,G__10328));
})(),cljs$core$js__GT_clj_$_thisfn((x__$1[k]))], null),cljs$core$js__GT_clj_$_thisfn_$_iter__10319(cljs.core.rest(s__10320__$2)));
}
} else {
return null;
}
break;
}
});})(map__10302,map__10302__$1,keywordize_keys,keyfn))
,null,null));
});})(map__10302,map__10302__$1,keywordize_keys,keyfn))
;
return iter__4521__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__10302,map__10302__$1,keywordize_keys,keyfn))
;
return f(x);
};
var G__10329 = function (x,var_args){
var opts = null;
if (arguments.length > 1) {
var G__10331__i = 0, G__10331__a = new Array(arguments.length -  1);
while (G__10331__i < G__10331__a.length) {G__10331__a[G__10331__i] = arguments[G__10331__i + 1]; ++G__10331__i;}
  opts = new cljs.core.IndexedSeq(G__10331__a,0);
} 
return G__10329__delegate.call(this,x,opts);};
G__10329.cljs$lang$maxFixedArity = 1;
G__10329.cljs$lang$applyTo = (function (arglist__10332){
var x = cljs.core.first(arglist__10332);
var opts = cljs.core.rest(arglist__10332);
return G__10329__delegate(x,opts);
});
G__10329.cljs$core$IFn$_invoke$arity$variadic = G__10329__delegate;
return G__10329;
})()
;
cljs$core$js__GT_clj = function(x,var_args){
var opts = var_args;
switch(arguments.length){
case 1:
return cljs$core$js__GT_clj__1.call(this,x);
default:
var G__10333 = null;
if (arguments.length > 1) {
var G__10334__i = 0, G__10334__a = new Array(arguments.length -  1);
while (G__10334__i < G__10334__a.length) {G__10334__a[G__10334__i] = arguments[G__10334__i + 1]; ++G__10334__i;}
G__10333 = new cljs.core.IndexedSeq(G__10334__a,0);
}
return cljs$core$js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic(x, G__10333);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$js__GT_clj.cljs$lang$maxFixedArity = 1;
cljs$core$js__GT_clj.cljs$lang$applyTo = cljs$core$js__GT_clj__2.cljs$lang$applyTo;
cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$1 = cljs$core$js__GT_clj__1;
cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$js__GT_clj;
})()
;
/**
 * Returns a memoized version of a referentially transparent function. The
 * memoized version of the function keeps a cache of the mapping from arguments
 * to results and, when calls with the same arguments are repeated often, has
 * higher performance at the expense of higher memory use.
 */
cljs.core.memoize = (function cljs$core$memoize(f){
var mem = (function (){var G__10337 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10337) : cljs.core.atom.call(null,G__10337));
})();
return ((function (mem){
return (function() { 
var G__10339__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__10338 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10338) : cljs.core.deref.call(null,G__10338));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__10339 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10340__i = 0, G__10340__a = new Array(arguments.length -  0);
while (G__10340__i < G__10340__a.length) {G__10340__a[G__10340__i] = arguments[G__10340__i + 0]; ++G__10340__i;}
  args = new cljs.core.IndexedSeq(G__10340__a,0);
} 
return G__10339__delegate.call(this,args);};
G__10339.cljs$lang$maxFixedArity = 0;
G__10339.cljs$lang$applyTo = (function (arglist__10341){
var args = cljs.core.seq(arglist__10341);
return G__10339__delegate(args);
});
G__10339.cljs$core$IFn$_invoke$arity$variadic = G__10339__delegate;
return G__10339;
})()
;
;})(mem))
});
/**
 * trampoline can be used to convert algorithms requiring mutual
 * recursion without stack consumption. Calls f with supplied args, if
 * any. If f returns a fn, calls that fn with no arguments, and
 * continues to repeat, until the return value is not a fn, then
 * returns that non-fn value. Note that if you want to return a fn as a
 * final value, you must wrap it in some data structure and unpack it
 * after trampoline returns.
 * @param {...*} var_args
 */
cljs.core.trampoline = (function() {
var cljs$core$trampoline = null;
var cljs$core$trampoline__1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__10343 = ret;
f = G__10343;
continue;
} else {
return ret;
}
break;
}
});
var cljs$core$trampoline__2 = (function() { 
var G__10344__delegate = function (f,args){
return cljs$core$trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
};
var G__10344 = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__10345__i = 0, G__10345__a = new Array(arguments.length -  1);
while (G__10345__i < G__10345__a.length) {G__10345__a[G__10345__i] = arguments[G__10345__i + 1]; ++G__10345__i;}
  args = new cljs.core.IndexedSeq(G__10345__a,0);
} 
return G__10344__delegate.call(this,f,args);};
G__10344.cljs$lang$maxFixedArity = 1;
G__10344.cljs$lang$applyTo = (function (arglist__10346){
var f = cljs.core.first(arglist__10346);
var args = cljs.core.rest(arglist__10346);
return G__10344__delegate(f,args);
});
G__10344.cljs$core$IFn$_invoke$arity$variadic = G__10344__delegate;
return G__10344;
})()
;
cljs$core$trampoline = function(f,var_args){
var args = var_args;
switch(arguments.length){
case 1:
return cljs$core$trampoline__1.call(this,f);
default:
var G__10347 = null;
if (arguments.length > 1) {
var G__10348__i = 0, G__10348__a = new Array(arguments.length -  1);
while (G__10348__i < G__10348__a.length) {G__10348__a[G__10348__i] = arguments[G__10348__i + 1]; ++G__10348__i;}
G__10347 = new cljs.core.IndexedSeq(G__10348__a,0);
}
return cljs$core$trampoline__2.cljs$core$IFn$_invoke$arity$variadic(f, G__10347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$trampoline.cljs$lang$maxFixedArity = 1;
cljs$core$trampoline.cljs$lang$applyTo = cljs$core$trampoline__2.cljs$lang$applyTo;
cljs$core$trampoline.cljs$core$IFn$_invoke$arity$1 = cljs$core$trampoline__1;
cljs$core$trampoline.cljs$core$IFn$_invoke$arity$variadic = cljs$core$trampoline__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$trampoline;
})()
;
/**
 * Returns a random floating point number between 0 (inclusive) and
 * n (default 1) (exclusive).
 */
cljs.core.rand = (function() {
var cljs$core$rand = null;
var cljs$core$rand__0 = (function (){
return cljs$core$rand.cljs$core$IFn$_invoke$arity$1((1));
});
var cljs$core$rand__1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});
cljs$core$rand = function(n){
switch(arguments.length){
case 0:
return cljs$core$rand__0.call(this);
case 1:
return cljs$core$rand__1.call(this,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$rand.cljs$core$IFn$_invoke$arity$0 = cljs$core$rand__0;
cljs$core$rand.cljs$core$IFn$_invoke$arity$1 = cljs$core$rand__1;
return cljs$core$rand;
})()
;
/**
 * Returns a random integer between 0 (inclusive) and n (exclusive).
 */
cljs.core.rand_int = (function cljs$core$rand_int(n){
var G__10351 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__10351) : Math.floor.call(null,G__10351));
});
/**
 * Return a random element of the (sequential) collection. Will have
 * the same performance characteristics as nth for the given
 * collection.
 */
cljs.core.rand_nth = (function cljs$core$rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
 * Returns a map of the elements of coll keyed by the result of
 * f on each element. The value at each key will be a vector of the
 * corresponding elements, in the order they appeared in coll.
 */
cljs.core.group_by = (function cljs$core$group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__10353 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10353) : f.call(null,G__10353));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Creates a hierarchy object for use with derive, isa? etc.
 */
cljs.core.make_hierarchy = (function cljs$core$make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function cljs$core$get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__10355 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10355) : cljs.core.atom.call(null,G__10355));
})();
} else {
}

return cljs.core._global_hierarchy;
});
/**
 * @param {...*} var_args
 */
cljs.core.swap_global_hierarchy_BANG_ = (function() { 
var cljs$core$swap_global_hierarchy_BANG___delegate = function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
};
var cljs$core$swap_global_hierarchy_BANG_ = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__10356__i = 0, G__10356__a = new Array(arguments.length -  1);
while (G__10356__i < G__10356__a.length) {G__10356__a[G__10356__i] = arguments[G__10356__i + 1]; ++G__10356__i;}
  args = new cljs.core.IndexedSeq(G__10356__a,0);
} 
return cljs$core$swap_global_hierarchy_BANG___delegate.call(this,f,args);};
cljs$core$swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = 1;
cljs$core$swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (arglist__10357){
var f = cljs.core.first(arglist__10357);
var args = cljs.core.rest(arglist__10357);
return cljs$core$swap_global_hierarchy_BANG___delegate(f,args);
});
cljs$core$swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$swap_global_hierarchy_BANG___delegate;
return cljs$core$swap_global_hierarchy_BANG_;
})()
;
/**
 * Returns true if (= child parent), or child is directly or indirectly derived from
 * parent, either via a JavaScript type inheritance relationship or a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy
 */
cljs.core.isa_QMARK_ = (function() {
var cljs$core$isa_QMARK_ = null;
var cljs$core$isa_QMARK___2 = (function (child,parent){
return cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__10422 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10422) : cljs.core.deref.call(null,G__10422));
})(),child,parent);
});
var cljs$core$isa_QMARK___3 = (function (h,child,parent){
var or__3767__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__3767__auto__){
return or__3767__auto__;
} else {
var or__3767__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__3767__auto____$1){
return or__3767__auto____$1;
} else {
var and__3755__auto__ = cljs.core.vector_QMARK_(parent);
if(and__3755__auto__){
var and__3755__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__3755__auto____$1){
var and__3755__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__3755__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__10447 = cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__10445 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__10445) : child.call(null,G__10445));
})(),(function (){var G__10446 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__10446) : parent.call(null,G__10446));
})());
var G__10448 = (i + (1));
ret = G__10447;
i = G__10448;
continue;
}
break;
}
} else {
return and__3755__auto____$2;
}
} else {
return and__3755__auto____$1;
}
} else {
return and__3755__auto__;
}
}
}
});
cljs$core$isa_QMARK_ = function(h,child,parent){
switch(arguments.length){
case 2:
return cljs$core$isa_QMARK___2.call(this,h,child);
case 3:
return cljs$core$isa_QMARK___3.call(this,h,child,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = cljs$core$isa_QMARK___2;
cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = cljs$core$isa_QMARK___3;
return cljs$core$isa_QMARK_;
})()
;
/**
 * Returns the immediate parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.parents = (function() {
var cljs$core$parents = null;
var cljs$core$parents__1 = (function (tag){
return cljs$core$parents.cljs$core$IFn$_invoke$arity$2((function (){var G__10452 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10452) : cljs.core.deref.call(null,G__10452));
})(),tag);
});
var cljs$core$parents__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$parents = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$parents__1.call(this,h);
case 2:
return cljs$core$parents__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$parents.cljs$core$IFn$_invoke$arity$1 = cljs$core$parents__1;
cljs$core$parents.cljs$core$IFn$_invoke$arity$2 = cljs$core$parents__2;
return cljs$core$parents;
})()
;
/**
 * Returns the immediate and indirect parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.ancestors = (function() {
var cljs$core$ancestors = null;
var cljs$core$ancestors__1 = (function (tag){
return cljs$core$ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__10456 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10456) : cljs.core.deref.call(null,G__10456));
})(),tag);
});
var cljs$core$ancestors__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$ancestors = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$ancestors__1.call(this,h);
case 2:
return cljs$core$ancestors__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ancestors.cljs$core$IFn$_invoke$arity$1 = cljs$core$ancestors__1;
cljs$core$ancestors.cljs$core$IFn$_invoke$arity$2 = cljs$core$ancestors__2;
return cljs$core$ancestors;
})()
;
/**
 * Returns the immediate and indirect children of tag, through a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy. Note: does not work on JavaScript type inheritance
 * relationships.
 */
cljs.core.descendants = (function() {
var cljs$core$descendants = null;
var cljs$core$descendants__1 = (function (tag){
return cljs$core$descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__10460 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10460) : cljs.core.deref.call(null,G__10460));
})(),tag);
});
var cljs$core$descendants__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$descendants = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$descendants__1.call(this,h);
case 2:
return cljs$core$descendants__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$descendants.cljs$core$IFn$_invoke$arity$1 = cljs$core$descendants__1;
cljs$core$descendants.cljs$core$IFn$_invoke$arity$2 = cljs$core$descendants__2;
return cljs$core$descendants;
})()
;
/**
 * Establishes a parent/child relationship between parent and
 * tag. Parent must be a namespace-qualified symbol or keyword and
 * child can be either a namespace-qualified symbol or keyword or a
 * class. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.derive = (function() {
var cljs$core$derive = null;
var cljs$core$derive__2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs$core$derive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var cljs$core$derive__3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__10469 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__10469) : targets.call(null,G__10469));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__10470 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__10470) : sources.call(null,G__10470));
})()));
});})(tp,td,ta))
;
var or__3767__auto__ = ((cljs.core.contains_QMARK_((function (){var G__10474 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__10474) : tp.call(null,G__10474));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__10475 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10475) : ta.call(null,G__10475));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.c